/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder;

import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.field.BusSolnOrdItmFUPServiceOrderField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.selectable.BusSolnOrdItmFUPServiceOrderSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Follow-up Service Order Items
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_BusSolnOrdItmFUPServiceOrderType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BusSolnOrdItmFUPServiceOrder extends VdmEntity<BusSolnOrdItmFUPServiceOrder>
{

    /**
     * Selector for all available fields of BusSolnOrdItmFUPServiceOrder.
     *
     */
    public final static BusSolnOrdItmFUPServiceOrderSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocumentItmRelationUUID</b>
     * </p>
     *
     * @return Object Relationship Service : GUID binary link
     */
    @Key
    @SerializedName( "ServiceDocumentItmRelationUUID" )
    @JsonProperty( "ServiceDocumentItmRelationUUID" )
    @Nullable
    @ODataField( odataName = "ServiceDocumentItmRelationUUID" )
    private UUID serviceDocumentItmRelationUUID;
    /**
     * Use with available fluent helpers to apply the <b>ServiceDocumentItmRelationUUID</b> field to query operations.
     *
     */
    public final static BusSolnOrdItmFUPServiceOrderField<UUID> SERVICE_DOCUMENT_ITM_RELATION_UUID =
        new BusSolnOrdItmFUPServiceOrderField<UUID>("ServiceDocumentItmRelationUUID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocItmRltnSqncNumber</b>
     * </p>
     *
     * @return Sequential Number of Segment in IDoc Type
     */
    @Key
    @SerializedName( "ServiceDocItmRltnSqncNumber" )
    @JsonProperty( "ServiceDocItmRltnSqncNumber" )
    @Nullable
    @ODataField( odataName = "ServiceDocItmRltnSqncNumber" )
    private String serviceDocItmRltnSqncNumber;
    /**
     * Use with available fluent helpers to apply the <b>ServiceDocItmRltnSqncNumber</b> field to query operations.
     *
     */
    public final static BusSolnOrdItmFUPServiceOrderField<String> SERVICE_DOC_ITM_RLTN_SQNC_NUMBER =
        new BusSolnOrdItmFUPServiceOrderField<String>("ServiceDocItmRltnSqncNumber");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BusinessSolutionOrderUUID</b>
     * </p>
     *
     * @return 32 Character CRM Object GUID
     */
    @SerializedName( "BusinessSolutionOrderUUID" )
    @JsonProperty( "BusinessSolutionOrderUUID" )
    @Nullable
    @ODataField( odataName = "BusinessSolutionOrderUUID" )
    private UUID businessSolutionOrderUUID;
    /**
     * Use with available fluent helpers to apply the <b>BusinessSolutionOrderUUID</b> field to query operations.
     *
     */
    public final static BusSolnOrdItmFUPServiceOrderField<UUID> BUSINESS_SOLUTION_ORDER_UUID =
        new BusSolnOrdItmFUPServiceOrderField<UUID>("BusinessSolutionOrderUUID");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BusinessSolutionOrder</b>
     * </p>
     *
     * @return Transaction ID
     */
    @SerializedName( "BusinessSolutionOrder" )
    @JsonProperty( "BusinessSolutionOrder" )
    @Nullable
    @ODataField( odataName = "BusinessSolutionOrder" )
    private String businessSolutionOrder;
    /**
     * Use with available fluent helpers to apply the <b>BusinessSolutionOrder</b> field to query operations.
     *
     */
    public final static BusSolnOrdItmFUPServiceOrderField<String> BUSINESS_SOLUTION_ORDER =
        new BusSolnOrdItmFUPServiceOrderField<String>("BusinessSolutionOrder");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BusinessSolutionOrderItem</b>
     * </p>
     *
     * @return Shortened Item Number in Document
     */
    @SerializedName( "BusinessSolutionOrderItem" )
    @JsonProperty( "BusinessSolutionOrderItem" )
    @Nullable
    @ODataField( odataName = "BusinessSolutionOrderItem" )
    private String businessSolutionOrderItem;
    /**
     * Use with available fluent helpers to apply the <b>BusinessSolutionOrderItem</b> field to query operations.
     *
     */
    public final static BusSolnOrdItmFUPServiceOrderField<String> BUSINESS_SOLUTION_ORDER_ITEM =
        new BusSolnOrdItmFUPServiceOrderField<String>("BusinessSolutionOrderItem");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceOrder</b>
     * </p>
     *
     * @return Transaction ID
     */
    @SerializedName( "ServiceOrder" )
    @JsonProperty( "ServiceOrder" )
    @Nullable
    @ODataField( odataName = "ServiceOrder" )
    private String serviceOrder;
    /**
     * Use with available fluent helpers to apply the <b>ServiceOrder</b> field to query operations.
     *
     */
    public final static BusSolnOrdItmFUPServiceOrderField<String> SERVICE_ORDER =
        new BusSolnOrdItmFUPServiceOrderField<String>("ServiceOrder");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ServiceOrderItem</b>
     * </p>
     *
     * @return Shortened Item Number in Document
     */
    @SerializedName( "ServiceOrderItem" )
    @JsonProperty( "ServiceOrderItem" )
    @Nullable
    @ODataField( odataName = "ServiceOrderItem" )
    private String serviceOrderItem;
    /**
     * Use with available fluent helpers to apply the <b>ServiceOrderItem</b> field to query operations.
     *
     */
    public final static BusSolnOrdItmFUPServiceOrderField<String> SERVICE_ORDER_ITEM =
        new BusSolnOrdItmFUPServiceOrderField<String>("ServiceOrderItem");

    @Nonnull
    @Override
    public Class<BusSolnOrdItmFUPServiceOrder> getType()
    {
        return BusSolnOrdItmFUPServiceOrder.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocumentItmRelationUUID</b>
     * </p>
     *
     * @param serviceDocumentItmRelationUUID
     *            Object Relationship Service : GUID binary link
     */
    public void setServiceDocumentItmRelationUUID( @Nullable final UUID serviceDocumentItmRelationUUID )
    {
        rememberChangedField("ServiceDocumentItmRelationUUID", this.serviceDocumentItmRelationUUID);
        this.serviceDocumentItmRelationUUID = serviceDocumentItmRelationUUID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocItmRltnSqncNumber</b>
     * </p>
     *
     * @param serviceDocItmRltnSqncNumber
     *            Sequential Number of Segment in IDoc Type
     */
    public void setServiceDocItmRltnSqncNumber( @Nullable final String serviceDocItmRltnSqncNumber )
    {
        rememberChangedField("ServiceDocItmRltnSqncNumber", this.serviceDocItmRltnSqncNumber);
        this.serviceDocItmRltnSqncNumber = serviceDocItmRltnSqncNumber;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BusinessSolutionOrderUUID</b>
     * </p>
     *
     * @param businessSolutionOrderUUID
     *            32 Character CRM Object GUID
     */
    public void setBusinessSolutionOrderUUID( @Nullable final UUID businessSolutionOrderUUID )
    {
        rememberChangedField("BusinessSolutionOrderUUID", this.businessSolutionOrderUUID);
        this.businessSolutionOrderUUID = businessSolutionOrderUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BusinessSolutionOrder</b>
     * </p>
     *
     * @param businessSolutionOrder
     *            Transaction ID
     */
    public void setBusinessSolutionOrder( @Nullable final String businessSolutionOrder )
    {
        rememberChangedField("BusinessSolutionOrder", this.businessSolutionOrder);
        this.businessSolutionOrder = businessSolutionOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BusinessSolutionOrderItem</b>
     * </p>
     *
     * @param businessSolutionOrderItem
     *            Shortened Item Number in Document
     */
    public void setBusinessSolutionOrderItem( @Nullable final String businessSolutionOrderItem )
    {
        rememberChangedField("BusinessSolutionOrderItem", this.businessSolutionOrderItem);
        this.businessSolutionOrderItem = businessSolutionOrderItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceOrder</b>
     * </p>
     *
     * @param serviceOrder
     *            Transaction ID
     */
    public void setServiceOrder( @Nullable final String serviceOrder )
    {
        rememberChangedField("ServiceOrder", this.serviceOrder);
        this.serviceOrder = serviceOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ServiceOrderItem</b>
     * </p>
     *
     * @param serviceOrderItem
     *            Shortened Item Number in Document
     */
    public void setServiceOrderItem( @Nullable final String serviceOrderItem )
    {
        rememberChangedField("ServiceOrderItem", this.serviceOrderItem);
        this.serviceOrderItem = serviceOrderItem;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_BusSolnOrdItmFUPServiceOrder";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ServiceDocumentItmRelationUUID", getServiceDocumentItmRelationUUID());
        result.put("ServiceDocItmRltnSqncNumber", getServiceDocItmRltnSqncNumber());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ServiceDocumentItmRelationUUID", getServiceDocumentItmRelationUUID());
        values.put("ServiceDocItmRltnSqncNumber", getServiceDocItmRltnSqncNumber());
        values.put("BusinessSolutionOrderUUID", getBusinessSolutionOrderUUID());
        values.put("BusinessSolutionOrder", getBusinessSolutionOrder());
        values.put("BusinessSolutionOrderItem", getBusinessSolutionOrderItem());
        values.put("ServiceOrder", getServiceOrder());
        values.put("ServiceOrderItem", getServiceOrderItem());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ServiceDocumentItmRelationUUID") ) {
                final Object value = values.remove("ServiceDocumentItmRelationUUID");
                if( (value == null) || (!value.equals(getServiceDocumentItmRelationUUID())) ) {
                    setServiceDocumentItmRelationUUID(((UUID) value));
                }
            }
            if( values.containsKey("ServiceDocItmRltnSqncNumber") ) {
                final Object value = values.remove("ServiceDocItmRltnSqncNumber");
                if( (value == null) || (!value.equals(getServiceDocItmRltnSqncNumber())) ) {
                    setServiceDocItmRltnSqncNumber(((String) value));
                }
            }
            if( values.containsKey("BusinessSolutionOrderUUID") ) {
                final Object value = values.remove("BusinessSolutionOrderUUID");
                if( (value == null) || (!value.equals(getBusinessSolutionOrderUUID())) ) {
                    setBusinessSolutionOrderUUID(((UUID) value));
                }
            }
            if( values.containsKey("BusinessSolutionOrder") ) {
                final Object value = values.remove("BusinessSolutionOrder");
                if( (value == null) || (!value.equals(getBusinessSolutionOrder())) ) {
                    setBusinessSolutionOrder(((String) value));
                }
            }
            if( values.containsKey("BusinessSolutionOrderItem") ) {
                final Object value = values.remove("BusinessSolutionOrderItem");
                if( (value == null) || (!value.equals(getBusinessSolutionOrderItem())) ) {
                    setBusinessSolutionOrderItem(((String) value));
                }
            }
            if( values.containsKey("ServiceOrder") ) {
                final Object value = values.remove("ServiceOrder");
                if( (value == null) || (!value.equals(getServiceOrder())) ) {
                    setServiceOrder(((String) value));
                }
            }
            if( values.containsKey("ServiceOrderItem") ) {
                final Object value = values.remove("ServiceOrderItem");
                if( (value == null) || (!value.equals(getServiceOrderItem())) ) {
                    setServiceOrderItem(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> BusSolnOrdItmFUPServiceOrderField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new BusSolnOrdItmFUPServiceOrderField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BusSolnOrdItmFUPServiceOrderField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BusSolnOrdItmFUPServiceOrderField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessSolutionOrderService.DEFAULT_SERVICE_PATH);
    }

}
