/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder;

import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.field.BusSolnOrdItmFUPSubscrpnField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.selectable.BusSolnOrdItmFUPSubscrpnSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Follow-up Subscription Billing Items
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_BusSolnOrdItmFUPSubscrpnType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BusSolnOrdItmFUPSubscrpn extends VdmEntity<BusSolnOrdItmFUPSubscrpn>
{

    /**
     * Selector for all available fields of BusSolnOrdItmFUPSubscrpn.
     *
     */
    public final static BusSolnOrdItmFUPSubscrpnSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocumentItmRelationUUID</b>
     * </p>
     *
     * @return Object Relationship Service : GUID binary link
     */
    @Key
    @SerializedName( "ServiceDocumentItmRelationUUID" )
    @JsonProperty( "ServiceDocumentItmRelationUUID" )
    @Nullable
    @ODataField( odataName = "ServiceDocumentItmRelationUUID" )
    private UUID serviceDocumentItmRelationUUID;
    /**
     * Use with available fluent helpers to apply the <b>ServiceDocumentItmRelationUUID</b> field to query operations.
     *
     */
    public final static BusSolnOrdItmFUPSubscrpnField<UUID> SERVICE_DOCUMENT_ITM_RELATION_UUID =
        new BusSolnOrdItmFUPSubscrpnField<UUID>("ServiceDocumentItmRelationUUID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocItmRltnSqncNumber</b>
     * </p>
     *
     * @return Sequential Number of Segment in IDoc Type
     */
    @Key
    @SerializedName( "ServiceDocItmRltnSqncNumber" )
    @JsonProperty( "ServiceDocItmRltnSqncNumber" )
    @Nullable
    @ODataField( odataName = "ServiceDocItmRltnSqncNumber" )
    private String serviceDocItmRltnSqncNumber;
    /**
     * Use with available fluent helpers to apply the <b>ServiceDocItmRltnSqncNumber</b> field to query operations.
     *
     */
    public final static BusSolnOrdItmFUPSubscrpnField<String> SERVICE_DOC_ITM_RLTN_SQNC_NUMBER =
        new BusSolnOrdItmFUPSubscrpnField<String>("ServiceDocItmRltnSqncNumber");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BusinessSolutionOrder</b>
     * </p>
     *
     * @return Transaction ID
     */
    @SerializedName( "BusinessSolutionOrder" )
    @JsonProperty( "BusinessSolutionOrder" )
    @Nullable
    @ODataField( odataName = "BusinessSolutionOrder" )
    private String businessSolutionOrder;
    /**
     * Use with available fluent helpers to apply the <b>BusinessSolutionOrder</b> field to query operations.
     *
     */
    public final static BusSolnOrdItmFUPSubscrpnField<String> BUSINESS_SOLUTION_ORDER =
        new BusSolnOrdItmFUPSubscrpnField<String>("BusinessSolutionOrder");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BusinessSolutionOrderItem</b>
     * </p>
     *
     * @return Shortened Item Number in Document
     */
    @SerializedName( "BusinessSolutionOrderItem" )
    @JsonProperty( "BusinessSolutionOrderItem" )
    @Nullable
    @ODataField( odataName = "BusinessSolutionOrderItem" )
    private String businessSolutionOrderItem;
    /**
     * Use with available fluent helpers to apply the <b>BusinessSolutionOrderItem</b> field to query operations.
     *
     */
    public final static BusSolnOrdItmFUPSubscrpnField<String> BUSINESS_SOLUTION_ORDER_ITEM =
        new BusSolnOrdItmFUPSubscrpnField<String>("BusinessSolutionOrderItem");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrderItemCharUUID</b>
     * </p>
     *
     * @return 32 Character CRM Object GUID
     */
    @SerializedName( "BusSolnOrderItemCharUUID" )
    @JsonProperty( "BusSolnOrderItemCharUUID" )
    @Nullable
    @ODataField( odataName = "BusSolnOrderItemCharUUID" )
    private UUID busSolnOrderItemCharUUID;
    /**
     * Use with available fluent helpers to apply the <b>BusSolnOrderItemCharUUID</b> field to query operations.
     *
     */
    public final static BusSolnOrdItmFUPSubscrpnField<UUID> BUS_SOLN_ORDER_ITEM_CHAR_UUID =
        new BusSolnOrdItmFUPSubscrpnField<UUID>("BusSolnOrderItemCharUUID");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SubscrpnBillgSubscription</b>
     * </p>
     *
     * @return The subscrpnBillgSubscription contained in this entity.
     */
    @SerializedName( "SubscrpnBillgSubscription" )
    @JsonProperty( "SubscrpnBillgSubscription" )
    @Nullable
    @ODataField( odataName = "SubscrpnBillgSubscription" )
    private String subscrpnBillgSubscription;
    /**
     * Use with available fluent helpers to apply the <b>SubscrpnBillgSubscription</b> field to query operations.
     *
     */
    public final static BusSolnOrdItmFUPSubscrpnField<String> SUBSCRPN_BILLG_SUBSCRIPTION =
        new BusSolnOrdItmFUPSubscrpnField<String>("SubscrpnBillgSubscription");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SubscrpnBillgSubscriptionItem</b>
     * </p>
     *
     * @return Shortened Item Number in Document
     */
    @SerializedName( "SubscrpnBillgSubscriptionItem" )
    @JsonProperty( "SubscrpnBillgSubscriptionItem" )
    @Nullable
    @ODataField( odataName = "SubscrpnBillgSubscriptionItem" )
    private String subscrpnBillgSubscriptionItem;
    /**
     * Use with available fluent helpers to apply the <b>SubscrpnBillgSubscriptionItem</b> field to query operations.
     *
     */
    public final static BusSolnOrdItmFUPSubscrpnField<String> SUBSCRPN_BILLG_SUBSCRIPTION_ITEM =
        new BusSolnOrdItmFUPSubscrpnField<String>("SubscrpnBillgSubscriptionItem");

    @Nonnull
    @Override
    public Class<BusSolnOrdItmFUPSubscrpn> getType()
    {
        return BusSolnOrdItmFUPSubscrpn.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocumentItmRelationUUID</b>
     * </p>
     *
     * @param serviceDocumentItmRelationUUID
     *            Object Relationship Service : GUID binary link
     */
    public void setServiceDocumentItmRelationUUID( @Nullable final UUID serviceDocumentItmRelationUUID )
    {
        rememberChangedField("ServiceDocumentItmRelationUUID", this.serviceDocumentItmRelationUUID);
        this.serviceDocumentItmRelationUUID = serviceDocumentItmRelationUUID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocItmRltnSqncNumber</b>
     * </p>
     *
     * @param serviceDocItmRltnSqncNumber
     *            Sequential Number of Segment in IDoc Type
     */
    public void setServiceDocItmRltnSqncNumber( @Nullable final String serviceDocItmRltnSqncNumber )
    {
        rememberChangedField("ServiceDocItmRltnSqncNumber", this.serviceDocItmRltnSqncNumber);
        this.serviceDocItmRltnSqncNumber = serviceDocItmRltnSqncNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BusinessSolutionOrder</b>
     * </p>
     *
     * @param businessSolutionOrder
     *            Transaction ID
     */
    public void setBusinessSolutionOrder( @Nullable final String businessSolutionOrder )
    {
        rememberChangedField("BusinessSolutionOrder", this.businessSolutionOrder);
        this.businessSolutionOrder = businessSolutionOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BusinessSolutionOrderItem</b>
     * </p>
     *
     * @param businessSolutionOrderItem
     *            Shortened Item Number in Document
     */
    public void setBusinessSolutionOrderItem( @Nullable final String businessSolutionOrderItem )
    {
        rememberChangedField("BusinessSolutionOrderItem", this.businessSolutionOrderItem);
        this.businessSolutionOrderItem = businessSolutionOrderItem;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrderItemCharUUID</b>
     * </p>
     *
     * @param busSolnOrderItemCharUUID
     *            32 Character CRM Object GUID
     */
    public void setBusSolnOrderItemCharUUID( @Nullable final UUID busSolnOrderItemCharUUID )
    {
        rememberChangedField("BusSolnOrderItemCharUUID", this.busSolnOrderItemCharUUID);
        this.busSolnOrderItemCharUUID = busSolnOrderItemCharUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SubscrpnBillgSubscription</b>
     * </p>
     *
     * @param subscrpnBillgSubscription
     *            The subscrpnBillgSubscription to set.
     */
    public void setSubscrpnBillgSubscription( @Nullable final String subscrpnBillgSubscription )
    {
        rememberChangedField("SubscrpnBillgSubscription", this.subscrpnBillgSubscription);
        this.subscrpnBillgSubscription = subscrpnBillgSubscription;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SubscrpnBillgSubscriptionItem</b>
     * </p>
     *
     * @param subscrpnBillgSubscriptionItem
     *            Shortened Item Number in Document
     */
    public void setSubscrpnBillgSubscriptionItem( @Nullable final String subscrpnBillgSubscriptionItem )
    {
        rememberChangedField("SubscrpnBillgSubscriptionItem", this.subscrpnBillgSubscriptionItem);
        this.subscrpnBillgSubscriptionItem = subscrpnBillgSubscriptionItem;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_BusSolnOrdItmFUPSubscrpn";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ServiceDocumentItmRelationUUID", getServiceDocumentItmRelationUUID());
        result.put("ServiceDocItmRltnSqncNumber", getServiceDocItmRltnSqncNumber());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ServiceDocumentItmRelationUUID", getServiceDocumentItmRelationUUID());
        values.put("ServiceDocItmRltnSqncNumber", getServiceDocItmRltnSqncNumber());
        values.put("BusinessSolutionOrder", getBusinessSolutionOrder());
        values.put("BusinessSolutionOrderItem", getBusinessSolutionOrderItem());
        values.put("BusSolnOrderItemCharUUID", getBusSolnOrderItemCharUUID());
        values.put("SubscrpnBillgSubscription", getSubscrpnBillgSubscription());
        values.put("SubscrpnBillgSubscriptionItem", getSubscrpnBillgSubscriptionItem());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ServiceDocumentItmRelationUUID") ) {
                final Object value = values.remove("ServiceDocumentItmRelationUUID");
                if( (value == null) || (!value.equals(getServiceDocumentItmRelationUUID())) ) {
                    setServiceDocumentItmRelationUUID(((UUID) value));
                }
            }
            if( values.containsKey("ServiceDocItmRltnSqncNumber") ) {
                final Object value = values.remove("ServiceDocItmRltnSqncNumber");
                if( (value == null) || (!value.equals(getServiceDocItmRltnSqncNumber())) ) {
                    setServiceDocItmRltnSqncNumber(((String) value));
                }
            }
            if( values.containsKey("BusinessSolutionOrder") ) {
                final Object value = values.remove("BusinessSolutionOrder");
                if( (value == null) || (!value.equals(getBusinessSolutionOrder())) ) {
                    setBusinessSolutionOrder(((String) value));
                }
            }
            if( values.containsKey("BusinessSolutionOrderItem") ) {
                final Object value = values.remove("BusinessSolutionOrderItem");
                if( (value == null) || (!value.equals(getBusinessSolutionOrderItem())) ) {
                    setBusinessSolutionOrderItem(((String) value));
                }
            }
            if( values.containsKey("BusSolnOrderItemCharUUID") ) {
                final Object value = values.remove("BusSolnOrderItemCharUUID");
                if( (value == null) || (!value.equals(getBusSolnOrderItemCharUUID())) ) {
                    setBusSolnOrderItemCharUUID(((UUID) value));
                }
            }
            if( values.containsKey("SubscrpnBillgSubscription") ) {
                final Object value = values.remove("SubscrpnBillgSubscription");
                if( (value == null) || (!value.equals(getSubscrpnBillgSubscription())) ) {
                    setSubscrpnBillgSubscription(((String) value));
                }
            }
            if( values.containsKey("SubscrpnBillgSubscriptionItem") ) {
                final Object value = values.remove("SubscrpnBillgSubscriptionItem");
                if( (value == null) || (!value.equals(getSubscrpnBillgSubscriptionItem())) ) {
                    setSubscrpnBillgSubscriptionItem(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> BusSolnOrdItmFUPSubscrpnField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new BusSolnOrdItmFUPSubscrpnField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BusSolnOrdItmFUPSubscrpnField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BusSolnOrdItmFUPSubscrpnField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessSolutionOrderService.DEFAULT_SERVICE_PATH);
    }

}
