/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.field.BusSolnOrdItmRateElementField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.link.BusSolnOrdItmRateElementLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.link.BusSolnOrdItmRateElementOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.selectable.BusSolnOrdItmRateElementSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Subscription Billing Item Rate Elements
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_BusSolnOrdItmRateElementType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BusSolnOrdItmRateElement extends VdmEntity<BusSolnOrdItmRateElement>
{

    /**
     * Selector for all available fields of BusSolnOrdItmRateElement.
     *
     */
    public final static BusSolnOrdItmRateElementSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BusinessSolutionOrder</b>
     * </p>
     *
     * @return Transaction ID
     */
    @Key
    @SerializedName( "BusinessSolutionOrder" )
    @JsonProperty( "BusinessSolutionOrder" )
    @Nullable
    @ODataField( odataName = "BusinessSolutionOrder" )
    private String businessSolutionOrder;
    /**
     * Use with available fluent helpers to apply the <b>BusinessSolutionOrder</b> field to query operations.
     *
     */
    public final static BusSolnOrdItmRateElementField<String> BUSINESS_SOLUTION_ORDER =
        new BusSolnOrdItmRateElementField<String>("BusinessSolutionOrder");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BusinessSolutionOrderItem</b>
     * </p>
     *
     * @return Shortened Item Number in Document
     */
    @Key
    @SerializedName( "BusinessSolutionOrderItem" )
    @JsonProperty( "BusinessSolutionOrderItem" )
    @Nullable
    @ODataField( odataName = "BusinessSolutionOrderItem" )
    private String businessSolutionOrderItem;
    /**
     * Use with available fluent helpers to apply the <b>BusinessSolutionOrderItem</b> field to query operations.
     *
     */
    public final static BusSolnOrdItmRateElementField<String> BUSINESS_SOLUTION_ORDER_ITEM =
        new BusSolnOrdItmRateElementField<String>("BusinessSolutionOrderItem");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SubscriptionRateElement</b>
     * </p>
     *
     * @return Product Number
     */
    @Key
    @SerializedName( "SubscriptionRateElement" )
    @JsonProperty( "SubscriptionRateElement" )
    @Nullable
    @ODataField( odataName = "SubscriptionRateElement" )
    private String subscriptionRateElement;
    /**
     * Use with available fluent helpers to apply the <b>SubscriptionRateElement</b> field to query operations.
     *
     */
    public final static BusSolnOrdItmRateElementField<String> SUBSCRIPTION_RATE_ELEMENT =
        new BusSolnOrdItmRateElementField<String>("SubscriptionRateElement");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SubscriptionRateElementType</b>
     * </p>
     *
     * @return Rate Type
     */
    @Key
    @SerializedName( "SubscriptionRateElementType" )
    @JsonProperty( "SubscriptionRateElementType" )
    @Nullable
    @ODataField( odataName = "SubscriptionRateElementType" )
    private String subscriptionRateElementType;
    /**
     * Use with available fluent helpers to apply the <b>SubscriptionRateElementType</b> field to query operations.
     *
     */
    public final static BusSolnOrdItmRateElementField<String> SUBSCRIPTION_RATE_ELEMENT_TYPE =
        new BusSolnOrdItmRateElementField<String>("SubscriptionRateElementType");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>SubscrpnRateElementTypeText</b>
     * </p>
     *
     * @return Short Text for Fixed Values
     */
    @SerializedName( "SubscrpnRateElementTypeText" )
    @JsonProperty( "SubscrpnRateElementTypeText" )
    @Nullable
    @ODataField( odataName = "SubscrpnRateElementTypeText" )
    private String subscrpnRateElementTypeText;
    /**
     * Use with available fluent helpers to apply the <b>SubscrpnRateElementTypeText</b> field to query operations.
     *
     */
    public final static BusSolnOrdItmRateElementField<String> SUBSCRPN_RATE_ELEMENT_TYPE_TEXT =
        new BusSolnOrdItmRateElementField<String>("SubscrpnRateElementTypeText");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>SubscrpnRateElementNetAmount</b>
     * </p>
     *
     * @return Net Value
     */
    @SerializedName( "SubscrpnRateElementNetAmount" )
    @JsonProperty( "SubscrpnRateElementNetAmount" )
    @Nullable
    @ODataField( odataName = "SubscrpnRateElementNetAmount" )
    private BigDecimal subscrpnRateElementNetAmount;
    /**
     * Use with available fluent helpers to apply the <b>SubscrpnRateElementNetAmount</b> field to query operations.
     *
     */
    public final static BusSolnOrdItmRateElementField<BigDecimal> SUBSCRPN_RATE_ELEMENT_NET_AMOUNT =
        new BusSolnOrdItmRateElementField<BigDecimal>("SubscrpnRateElementNetAmount");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>SubscrpnRateElementGrossAmount</b>
     * </p>
     *
     * @return Gross Order Value in PO Currency
     */
    @SerializedName( "SubscrpnRateElementGrossAmount" )
    @JsonProperty( "SubscrpnRateElementGrossAmount" )
    @Nullable
    @ODataField( odataName = "SubscrpnRateElementGrossAmount" )
    private BigDecimal subscrpnRateElementGrossAmount;
    /**
     * Use with available fluent helpers to apply the <b>SubscrpnRateElementGrossAmount</b> field to query operations.
     *
     */
    public final static BusSolnOrdItmRateElementField<BigDecimal> SUBSCRPN_RATE_ELEMENT_GROSS_AMOUNT =
        new BusSolnOrdItmRateElementField<BigDecimal>("SubscrpnRateElementGrossAmount");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>SubscrpnRateElementTaxAmount</b>
     * </p>
     *
     * @return Tax amount in document currency
     */
    @SerializedName( "SubscrpnRateElementTaxAmount" )
    @JsonProperty( "SubscrpnRateElementTaxAmount" )
    @Nullable
    @ODataField( odataName = "SubscrpnRateElementTaxAmount" )
    private BigDecimal subscrpnRateElementTaxAmount;
    /**
     * Use with available fluent helpers to apply the <b>SubscrpnRateElementTaxAmount</b> field to query operations.
     *
     */
    public final static BusSolnOrdItmRateElementField<BigDecimal> SUBSCRPN_RATE_ELEMENT_TAX_AMOUNT =
        new BusSolnOrdItmRateElementField<BigDecimal>("SubscrpnRateElementTaxAmount");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Currency</b>
     * </p>
     *
     * @return Currency
     */
    @SerializedName( "Currency" )
    @JsonProperty( "Currency" )
    @Nullable
    @ODataField( odataName = "Currency" )
    private String currency;
    /**
     * Use with available fluent helpers to apply the <b>Currency</b> field to query operations.
     *
     */
    public final static BusSolnOrdItmRateElementField<String> CURRENCY =
        new BusSolnOrdItmRateElementField<String>("Currency");
    /**
     * Navigation property <b>to_BusinessSolutionOrder</b> for <b>BusSolnOrdItmRateElement</b> to single
     * <b>BusinessSolutionOrder</b>.
     *
     */
    @SerializedName( "to_BusinessSolutionOrder" )
    @JsonProperty( "to_BusinessSolutionOrder" )
    @ODataField( odataName = "to_BusinessSolutionOrder" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private BusinessSolutionOrder toBusinessSolutionOrder;
    /**
     * Navigation property <b>to_SubscriptionBillingItem</b> for <b>BusSolnOrdItmRateElement</b> to single
     * <b>BusSolnOrdSubscrpnBillgItem</b>.
     *
     */
    @SerializedName( "to_SubscriptionBillingItem" )
    @JsonProperty( "to_SubscriptionBillingItem" )
    @ODataField( odataName = "to_SubscriptionBillingItem" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private BusSolnOrdSubscrpnBillgItem toSubscriptionBillingItem;
    /**
     * Navigation property <b>to_SubscriptionRateElmPriceElm</b> for <b>BusSolnOrdItmRateElement</b> to multiple
     * <b>BusSolnOrdItmRateElmntPrcElm</b>.
     *
     */
    @SerializedName( "to_SubscriptionRateElmPriceElm" )
    @JsonProperty( "to_SubscriptionRateElmPriceElm" )
    @ODataField( odataName = "to_SubscriptionRateElmPriceElm" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BusSolnOrdItmRateElmntPrcElm> toSubscriptionRateElmPriceElm;
    /**
     * Use with available fluent helpers to apply the <b>to_BusinessSolutionOrder</b> navigation property to query
     * operations.
     *
     */
    public final static BusSolnOrdItmRateElementOneToOneLink<BusinessSolutionOrder> TO_BUSINESS_SOLUTION_ORDER =
        new BusSolnOrdItmRateElementOneToOneLink<BusinessSolutionOrder>("to_BusinessSolutionOrder");
    /**
     * Use with available fluent helpers to apply the <b>to_SubscriptionBillingItem</b> navigation property to query
     * operations.
     *
     */
    public final static BusSolnOrdItmRateElementOneToOneLink<BusSolnOrdSubscrpnBillgItem> TO_SUBSCRIPTION_BILLING_ITEM =
        new BusSolnOrdItmRateElementOneToOneLink<BusSolnOrdSubscrpnBillgItem>("to_SubscriptionBillingItem");
    /**
     * Use with available fluent helpers to apply the <b>to_SubscriptionRateElmPriceElm</b> navigation property to query
     * operations.
     *
     */
    public final static BusSolnOrdItmRateElementLink<BusSolnOrdItmRateElmntPrcElm> TO_SUBSCRIPTION_RATE_ELM_PRICE_ELM =
        new BusSolnOrdItmRateElementLink<BusSolnOrdItmRateElmntPrcElm>("to_SubscriptionRateElmPriceElm");

    @Nonnull
    @Override
    public Class<BusSolnOrdItmRateElement> getType()
    {
        return BusSolnOrdItmRateElement.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BusinessSolutionOrder</b>
     * </p>
     *
     * @param businessSolutionOrder
     *            Transaction ID
     */
    public void setBusinessSolutionOrder( @Nullable final String businessSolutionOrder )
    {
        rememberChangedField("BusinessSolutionOrder", this.businessSolutionOrder);
        this.businessSolutionOrder = businessSolutionOrder;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BusinessSolutionOrderItem</b>
     * </p>
     *
     * @param businessSolutionOrderItem
     *            Shortened Item Number in Document
     */
    public void setBusinessSolutionOrderItem( @Nullable final String businessSolutionOrderItem )
    {
        rememberChangedField("BusinessSolutionOrderItem", this.businessSolutionOrderItem);
        this.businessSolutionOrderItem = businessSolutionOrderItem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SubscriptionRateElement</b>
     * </p>
     *
     * @param subscriptionRateElement
     *            Product Number
     */
    public void setSubscriptionRateElement( @Nullable final String subscriptionRateElement )
    {
        rememberChangedField("SubscriptionRateElement", this.subscriptionRateElement);
        this.subscriptionRateElement = subscriptionRateElement;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SubscriptionRateElementType</b>
     * </p>
     *
     * @param subscriptionRateElementType
     *            Rate Type
     */
    public void setSubscriptionRateElementType( @Nullable final String subscriptionRateElementType )
    {
        rememberChangedField("SubscriptionRateElementType", this.subscriptionRateElementType);
        this.subscriptionRateElementType = subscriptionRateElementType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>SubscrpnRateElementTypeText</b>
     * </p>
     *
     * @param subscrpnRateElementTypeText
     *            Short Text for Fixed Values
     */
    public void setSubscrpnRateElementTypeText( @Nullable final String subscrpnRateElementTypeText )
    {
        rememberChangedField("SubscrpnRateElementTypeText", this.subscrpnRateElementTypeText);
        this.subscrpnRateElementTypeText = subscrpnRateElementTypeText;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>SubscrpnRateElementNetAmount</b>
     * </p>
     *
     * @param subscrpnRateElementNetAmount
     *            Net Value
     */
    public void setSubscrpnRateElementNetAmount( @Nullable final BigDecimal subscrpnRateElementNetAmount )
    {
        rememberChangedField("SubscrpnRateElementNetAmount", this.subscrpnRateElementNetAmount);
        this.subscrpnRateElementNetAmount = subscrpnRateElementNetAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>SubscrpnRateElementGrossAmount</b>
     * </p>
     *
     * @param subscrpnRateElementGrossAmount
     *            Gross Order Value in PO Currency
     */
    public void setSubscrpnRateElementGrossAmount( @Nullable final BigDecimal subscrpnRateElementGrossAmount )
    {
        rememberChangedField("SubscrpnRateElementGrossAmount", this.subscrpnRateElementGrossAmount);
        this.subscrpnRateElementGrossAmount = subscrpnRateElementGrossAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>SubscrpnRateElementTaxAmount</b>
     * </p>
     *
     * @param subscrpnRateElementTaxAmount
     *            Tax amount in document currency
     */
    public void setSubscrpnRateElementTaxAmount( @Nullable final BigDecimal subscrpnRateElementTaxAmount )
    {
        rememberChangedField("SubscrpnRateElementTaxAmount", this.subscrpnRateElementTaxAmount);
        this.subscrpnRateElementTaxAmount = subscrpnRateElementTaxAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Currency</b>
     * </p>
     *
     * @param currency
     *            Currency
     */
    public void setCurrency( @Nullable final String currency )
    {
        rememberChangedField("Currency", this.currency);
        this.currency = currency;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_BusSolnOrdItmRateElement";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("BusinessSolutionOrder", getBusinessSolutionOrder());
        result.put("BusinessSolutionOrderItem", getBusinessSolutionOrderItem());
        result.put("SubscriptionRateElement", getSubscriptionRateElement());
        result.put("SubscriptionRateElementType", getSubscriptionRateElementType());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("BusinessSolutionOrder", getBusinessSolutionOrder());
        values.put("BusinessSolutionOrderItem", getBusinessSolutionOrderItem());
        values.put("SubscriptionRateElement", getSubscriptionRateElement());
        values.put("SubscriptionRateElementType", getSubscriptionRateElementType());
        values.put("SubscrpnRateElementTypeText", getSubscrpnRateElementTypeText());
        values.put("SubscrpnRateElementNetAmount", getSubscrpnRateElementNetAmount());
        values.put("SubscrpnRateElementGrossAmount", getSubscrpnRateElementGrossAmount());
        values.put("SubscrpnRateElementTaxAmount", getSubscrpnRateElementTaxAmount());
        values.put("Currency", getCurrency());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("BusinessSolutionOrder") ) {
                final Object value = values.remove("BusinessSolutionOrder");
                if( (value == null) || (!value.equals(getBusinessSolutionOrder())) ) {
                    setBusinessSolutionOrder(((String) value));
                }
            }
            if( values.containsKey("BusinessSolutionOrderItem") ) {
                final Object value = values.remove("BusinessSolutionOrderItem");
                if( (value == null) || (!value.equals(getBusinessSolutionOrderItem())) ) {
                    setBusinessSolutionOrderItem(((String) value));
                }
            }
            if( values.containsKey("SubscriptionRateElement") ) {
                final Object value = values.remove("SubscriptionRateElement");
                if( (value == null) || (!value.equals(getSubscriptionRateElement())) ) {
                    setSubscriptionRateElement(((String) value));
                }
            }
            if( values.containsKey("SubscriptionRateElementType") ) {
                final Object value = values.remove("SubscriptionRateElementType");
                if( (value == null) || (!value.equals(getSubscriptionRateElementType())) ) {
                    setSubscriptionRateElementType(((String) value));
                }
            }
            if( values.containsKey("SubscrpnRateElementTypeText") ) {
                final Object value = values.remove("SubscrpnRateElementTypeText");
                if( (value == null) || (!value.equals(getSubscrpnRateElementTypeText())) ) {
                    setSubscrpnRateElementTypeText(((String) value));
                }
            }
            if( values.containsKey("SubscrpnRateElementNetAmount") ) {
                final Object value = values.remove("SubscrpnRateElementNetAmount");
                if( (value == null) || (!value.equals(getSubscrpnRateElementNetAmount())) ) {
                    setSubscrpnRateElementNetAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("SubscrpnRateElementGrossAmount") ) {
                final Object value = values.remove("SubscrpnRateElementGrossAmount");
                if( (value == null) || (!value.equals(getSubscrpnRateElementGrossAmount())) ) {
                    setSubscrpnRateElementGrossAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("SubscrpnRateElementTaxAmount") ) {
                final Object value = values.remove("SubscrpnRateElementTaxAmount");
                if( (value == null) || (!value.equals(getSubscrpnRateElementTaxAmount())) ) {
                    setSubscrpnRateElementTaxAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("Currency") ) {
                final Object value = values.remove("Currency");
                if( (value == null) || (!value.equals(getCurrency())) ) {
                    setCurrency(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_BusinessSolutionOrder") ) {
                final Object value = (values).remove("to_BusinessSolutionOrder");
                if( value instanceof Map ) {
                    if( toBusinessSolutionOrder == null ) {
                        toBusinessSolutionOrder = new BusinessSolutionOrder();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toBusinessSolutionOrder.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_SubscriptionBillingItem") ) {
                final Object value = (values).remove("to_SubscriptionBillingItem");
                if( value instanceof Map ) {
                    if( toSubscriptionBillingItem == null ) {
                        toSubscriptionBillingItem = new BusSolnOrdSubscrpnBillgItem();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toSubscriptionBillingItem.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_SubscriptionRateElmPriceElm") ) {
                final Object value = (values).remove("to_SubscriptionRateElmPriceElm");
                if( value instanceof Iterable ) {
                    if( toSubscriptionRateElmPriceElm == null ) {
                        toSubscriptionRateElmPriceElm = Lists.newArrayList();
                    } else {
                        toSubscriptionRateElmPriceElm = Lists.newArrayList(toSubscriptionRateElmPriceElm);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BusSolnOrdItmRateElmntPrcElm entity;
                        if( toSubscriptionRateElmPriceElm.size() > i ) {
                            entity = toSubscriptionRateElmPriceElm.get(i);
                        } else {
                            entity = new BusSolnOrdItmRateElmntPrcElm();
                            toSubscriptionRateElmPriceElm.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> BusSolnOrdItmRateElementField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new BusSolnOrdItmRateElementField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BusSolnOrdItmRateElementField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BusSolnOrdItmRateElementField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessSolutionOrderService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toBusinessSolutionOrder != null ) {
            (values).put("to_BusinessSolutionOrder", toBusinessSolutionOrder);
        }
        if( toSubscriptionBillingItem != null ) {
            (values).put("to_SubscriptionBillingItem", toSubscriptionBillingItem);
        }
        if( toSubscriptionRateElmPriceElm != null ) {
            (values).put("to_SubscriptionRateElmPriceElm", toSubscriptionRateElmPriceElm);
        }
        return values;
    }

    /**
     * Fetches the <b>BusinessSolutionOrder</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_BusinessSolutionOrder</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>BusinessSolutionOrder</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BusinessSolutionOrder fetchBusinessSolutionOrder()
    {
        return fetchFieldAsSingle("to_BusinessSolutionOrder", BusinessSolutionOrder.class);
    }

    /**
     * Retrieval of associated <b>BusinessSolutionOrder</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_BusinessSolutionOrder</b>.
     * <p>
     * If the navigation property <b>to_BusinessSolutionOrder</b> of a queried <b>BusSolnOrdItmRateElement</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BusinessSolutionOrder</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BusinessSolutionOrder getBusinessSolutionOrderOrFetch()
    {
        if( toBusinessSolutionOrder == null ) {
            toBusinessSolutionOrder = fetchBusinessSolutionOrder();
        }
        return toBusinessSolutionOrder;
    }

    /**
     * Retrieval of associated <b>BusinessSolutionOrder</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_BusinessSolutionOrder</b>.
     * <p>
     * If the navigation property for an entity <b>BusSolnOrdItmRateElement</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BusinessSolutionOrder</b> is already loaded, the result
     *         will contain the <b>BusinessSolutionOrder</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<BusinessSolutionOrder> getBusinessSolutionOrderIfPresent()
    {
        return Option.of(toBusinessSolutionOrder);
    }

    /**
     * Overwrites the associated <b>BusinessSolutionOrder</b> entity for the loaded navigation property
     * <b>to_BusinessSolutionOrder</b>.
     *
     * @param value
     *            New <b>BusinessSolutionOrder</b> entity.
     */
    public void setBusinessSolutionOrder( final BusinessSolutionOrder value )
    {
        toBusinessSolutionOrder = value;
    }

    /**
     * Fetches the <b>BusSolnOrdSubscrpnBillgItem</b> entity (one to one) associated with this entity. This corresponds
     * to the OData navigation property <b>to_SubscriptionBillingItem</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>BusSolnOrdSubscrpnBillgItem</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BusSolnOrdSubscrpnBillgItem fetchSubscriptionBillingItem()
    {
        return fetchFieldAsSingle("to_SubscriptionBillingItem", BusSolnOrdSubscrpnBillgItem.class);
    }

    /**
     * Retrieval of associated <b>BusSolnOrdSubscrpnBillgItem</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_SubscriptionBillingItem</b>.
     * <p>
     * If the navigation property <b>to_SubscriptionBillingItem</b> of a queried <b>BusSolnOrdItmRateElement</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BusSolnOrdSubscrpnBillgItem</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BusSolnOrdSubscrpnBillgItem getSubscriptionBillingItemOrFetch()
    {
        if( toSubscriptionBillingItem == null ) {
            toSubscriptionBillingItem = fetchSubscriptionBillingItem();
        }
        return toSubscriptionBillingItem;
    }

    /**
     * Retrieval of associated <b>BusSolnOrdSubscrpnBillgItem</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_SubscriptionBillingItem</b>.
     * <p>
     * If the navigation property for an entity <b>BusSolnOrdItmRateElement</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SubscriptionBillingItem</b> is already loaded, the
     *         result will contain the <b>BusSolnOrdSubscrpnBillgItem</b> entity. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<BusSolnOrdSubscrpnBillgItem> getSubscriptionBillingItemIfPresent()
    {
        return Option.of(toSubscriptionBillingItem);
    }

    /**
     * Overwrites the associated <b>BusSolnOrdSubscrpnBillgItem</b> entity for the loaded navigation property
     * <b>to_SubscriptionBillingItem</b>.
     *
     * @param value
     *            New <b>BusSolnOrdSubscrpnBillgItem</b> entity.
     */
    public void setSubscriptionBillingItem( final BusSolnOrdSubscrpnBillgItem value )
    {
        toSubscriptionBillingItem = value;
    }

    /**
     * Fetches the <b>BusSolnOrdItmRateElmntPrcElm</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_SubscriptionRateElmPriceElm</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BusSolnOrdItmRateElmntPrcElm</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusSolnOrdItmRateElmntPrcElm> fetchSubscriptionRateElmPriceElm()
    {
        return fetchFieldAsList("to_SubscriptionRateElmPriceElm", BusSolnOrdItmRateElmntPrcElm.class);
    }

    /**
     * Retrieval of associated <b>BusSolnOrdItmRateElmntPrcElm</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SubscriptionRateElmPriceElm</b>.
     * <p>
     * If the navigation property <b>to_SubscriptionRateElmPriceElm</b> of a queried <b>BusSolnOrdItmRateElement</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BusSolnOrdItmRateElmntPrcElm</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusSolnOrdItmRateElmntPrcElm> getSubscriptionRateElmPriceElmOrFetch()
    {
        if( toSubscriptionRateElmPriceElm == null ) {
            toSubscriptionRateElmPriceElm = fetchSubscriptionRateElmPriceElm();
        }
        return toSubscriptionRateElmPriceElm;
    }

    /**
     * Retrieval of associated <b>BusSolnOrdItmRateElmntPrcElm</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SubscriptionRateElmPriceElm</b>.
     * <p>
     * If the navigation property for an entity <b>BusSolnOrdItmRateElement</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SubscriptionRateElmPriceElm</b> is already loaded, the
     *         result will contain the <b>BusSolnOrdItmRateElmntPrcElm</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BusSolnOrdItmRateElmntPrcElm>> getSubscriptionRateElmPriceElmIfPresent()
    {
        return Option.of(toSubscriptionRateElmPriceElm);
    }

    /**
     * Overwrites the list of associated <b>BusSolnOrdItmRateElmntPrcElm</b> entities for the loaded navigation property
     * <b>to_SubscriptionRateElmPriceElm</b>.
     * <p>
     * If the navigation property <b>to_SubscriptionRateElmPriceElm</b> of a queried <b>BusSolnOrdItmRateElement</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BusSolnOrdItmRateElmntPrcElm</b> entities.
     */
    public void setSubscriptionRateElmPriceElm( @Nonnull final List<BusSolnOrdItmRateElmntPrcElm> value )
    {
        if( toSubscriptionRateElmPriceElm == null ) {
            toSubscriptionRateElmPriceElm = Lists.newArrayList();
        }
        toSubscriptionRateElmPriceElm.clear();
        toSubscriptionRateElmPriceElm.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BusSolnOrdItmRateElmntPrcElm</b> entities. This corresponds to the
     * OData navigation property <b>to_SubscriptionRateElmPriceElm</b>.
     * <p>
     * If the navigation property <b>to_SubscriptionRateElmPriceElm</b> of a queried <b>BusSolnOrdItmRateElement</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BusSolnOrdItmRateElmntPrcElm</b> entities.
     */
    public void addSubscriptionRateElmPriceElm( BusSolnOrdItmRateElmntPrcElm... entity )
    {
        if( toSubscriptionRateElmPriceElm == null ) {
            toSubscriptionRateElmPriceElm = Lists.newArrayList();
        }
        toSubscriptionRateElmPriceElm.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of BusSolnOrdItmRateElement instances.
     *
     */
    public final static class BusSolnOrdItmRateElementBuilder
    {

        private BusinessSolutionOrder toBusinessSolutionOrder;
        private String businessSolutionOrder = null;
        private BusSolnOrdSubscrpnBillgItem toSubscriptionBillingItem;
        private List<BusSolnOrdItmRateElmntPrcElm> toSubscriptionRateElmPriceElm = Lists.newArrayList();

        private BusSolnOrdItmRateElement.BusSolnOrdItmRateElementBuilder toBusinessSolutionOrder(
            final BusinessSolutionOrder value )
        {
            toBusinessSolutionOrder = value;
            return this;
        }

        /**
         * Navigation property <b>to_BusinessSolutionOrder</b> for <b>BusSolnOrdItmRateElement</b> to single
         * <b>BusinessSolutionOrder</b>.
         *
         * @param value
         *            The BusinessSolutionOrder to build this BusSolnOrdItmRateElement with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusSolnOrdItmRateElement.BusSolnOrdItmRateElementBuilder businessSolutionOrder(
            final BusinessSolutionOrder value )
        {
            return toBusinessSolutionOrder(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 10
         * <p>
         * Original property name from the Odata EDM: <b>BusinessSolutionOrder</b>
         * </p>
         *
         * @param value
         *            The businessSolutionOrder to build this BusSolnOrdItmRateElement with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusSolnOrdItmRateElement.BusSolnOrdItmRateElementBuilder businessSolutionOrder( final String value )
        {
            businessSolutionOrder = value;
            return this;
        }

        private BusSolnOrdItmRateElement.BusSolnOrdItmRateElementBuilder toSubscriptionBillingItem(
            final BusSolnOrdSubscrpnBillgItem value )
        {
            toSubscriptionBillingItem = value;
            return this;
        }

        /**
         * Navigation property <b>to_SubscriptionBillingItem</b> for <b>BusSolnOrdItmRateElement</b> to single
         * <b>BusSolnOrdSubscrpnBillgItem</b>.
         *
         * @param value
         *            The BusSolnOrdSubscrpnBillgItem to build this BusSolnOrdItmRateElement with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusSolnOrdItmRateElement.BusSolnOrdItmRateElementBuilder subscriptionBillingItem(
            final BusSolnOrdSubscrpnBillgItem value )
        {
            return toSubscriptionBillingItem(value);
        }

        private BusSolnOrdItmRateElement.BusSolnOrdItmRateElementBuilder toSubscriptionRateElmPriceElm(
            final List<BusSolnOrdItmRateElmntPrcElm> value )
        {
            toSubscriptionRateElmPriceElm.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_SubscriptionRateElmPriceElm</b> for <b>BusSolnOrdItmRateElement</b> to multiple
         * <b>BusSolnOrdItmRateElmntPrcElm</b>.
         *
         * @param value
         *            The BusSolnOrdItmRateElmntPrcElms to build this BusSolnOrdItmRateElement with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusSolnOrdItmRateElement.BusSolnOrdItmRateElementBuilder subscriptionRateElmPriceElm(
            BusSolnOrdItmRateElmntPrcElm... value )
        {
            return toSubscriptionRateElmPriceElm(Lists.newArrayList(value));
        }

    }

}
