/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.field.BusSolnOrdItmReferenceObjectField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.selectable.BusSolnOrdItmReferenceObjectSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Service Order Item Reference Object
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_BusSolnOrdItmReferenceObjectType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BusSolnOrdItmReferenceObject extends VdmEntity<BusSolnOrdItmReferenceObject>
{

    /**
     * Selector for all available fields of BusSolnOrdItmReferenceObject.
     *
     */
    public final static BusSolnOrdItmReferenceObjectSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BusinessSolutionOrder</b>
     * </p>
     *
     * @return Transaction ID
     */
    @Key
    @SerializedName( "BusinessSolutionOrder" )
    @JsonProperty( "BusinessSolutionOrder" )
    @Nullable
    @ODataField( odataName = "BusinessSolutionOrder" )
    private String businessSolutionOrder;
    /**
     * Use with available fluent helpers to apply the <b>BusinessSolutionOrder</b> field to query operations.
     *
     */
    public final static BusSolnOrdItmReferenceObjectField<String> BUSINESS_SOLUTION_ORDER =
        new BusSolnOrdItmReferenceObjectField<String>("BusinessSolutionOrder");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BusinessSolutionOrderItem</b>
     * </p>
     *
     * @return Shortened Item Number in Document
     */
    @Key
    @SerializedName( "BusinessSolutionOrderItem" )
    @JsonProperty( "BusinessSolutionOrderItem" )
    @Nullable
    @ODataField( odataName = "BusinessSolutionOrderItem" )
    private String businessSolutionOrderItem;
    /**
     * Use with available fluent helpers to apply the <b>BusinessSolutionOrderItem</b> field to query operations.
     *
     */
    public final static BusSolnOrdItmReferenceObjectField<String> BUSINESS_SOLUTION_ORDER_ITEM =
        new BusSolnOrdItmReferenceObjectField<String>("BusinessSolutionOrderItem");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceProduct</b>
     * </p>
     *
     * @return Material Number
     */
    @Key
    @SerializedName( "ReferenceProduct" )
    @JsonProperty( "ReferenceProduct" )
    @Nullable
    @ODataField( odataName = "ReferenceProduct" )
    private String referenceProduct;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceProduct</b> field to query operations.
     *
     */
    public final static BusSolnOrdItmReferenceObjectField<String> REFERENCE_PRODUCT =
        new BusSolnOrdItmReferenceObjectField<String>("ReferenceProduct");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ServiceRefFunctionalLocation</b>
     * </p>
     *
     * @return Functional Location
     */
    @Key
    @SerializedName( "ServiceRefFunctionalLocation" )
    @JsonProperty( "ServiceRefFunctionalLocation" )
    @Nullable
    @ODataField( odataName = "ServiceRefFunctionalLocation" )
    private String serviceRefFunctionalLocation;
    /**
     * Use with available fluent helpers to apply the <b>ServiceRefFunctionalLocation</b> field to query operations.
     *
     */
    public final static BusSolnOrdItmReferenceObjectField<String> SERVICE_REF_FUNCTIONAL_LOCATION =
        new BusSolnOrdItmReferenceObjectField<String>("ServiceRefFunctionalLocation");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>ServiceReferenceEquipment</b>
     * </p>
     *
     * @return Equipment Number
     */
    @Key
    @SerializedName( "ServiceReferenceEquipment" )
    @JsonProperty( "ServiceReferenceEquipment" )
    @Nullable
    @ODataField( odataName = "ServiceReferenceEquipment" )
    private String serviceReferenceEquipment;
    /**
     * Use with available fluent helpers to apply the <b>ServiceReferenceEquipment</b> field to query operations.
     *
     */
    public final static BusSolnOrdItmReferenceObjectField<String> SERVICE_REFERENCE_EQUIPMENT =
        new BusSolnOrdItmReferenceObjectField<String>("ServiceReferenceEquipment");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SrvcRefObjIsMainObject</b>
     * </p>
     *
     * @return Main Reference Object
     */
    @SerializedName( "SrvcRefObjIsMainObject" )
    @JsonProperty( "SrvcRefObjIsMainObject" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "SrvcRefObjIsMainObject" )
    private Boolean srvcRefObjIsMainObject;
    /**
     * Use with available fluent helpers to apply the <b>SrvcRefObjIsMainObject</b> field to query operations.
     *
     */
    public final static BusSolnOrdItmReferenceObjectField<Boolean> SRVC_REF_OBJ_IS_MAIN_OBJECT =
        new BusSolnOrdItmReferenceObjectField<Boolean>("SrvcRefObjIsMainObject");

    @Nonnull
    @Override
    public Class<BusSolnOrdItmReferenceObject> getType()
    {
        return BusSolnOrdItmReferenceObject.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BusinessSolutionOrder</b>
     * </p>
     *
     * @param businessSolutionOrder
     *            Transaction ID
     */
    public void setBusinessSolutionOrder( @Nullable final String businessSolutionOrder )
    {
        rememberChangedField("BusinessSolutionOrder", this.businessSolutionOrder);
        this.businessSolutionOrder = businessSolutionOrder;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BusinessSolutionOrderItem</b>
     * </p>
     *
     * @param businessSolutionOrderItem
     *            Shortened Item Number in Document
     */
    public void setBusinessSolutionOrderItem( @Nullable final String businessSolutionOrderItem )
    {
        rememberChangedField("BusinessSolutionOrderItem", this.businessSolutionOrderItem);
        this.businessSolutionOrderItem = businessSolutionOrderItem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceProduct</b>
     * </p>
     *
     * @param referenceProduct
     *            Material Number
     */
    public void setReferenceProduct( @Nullable final String referenceProduct )
    {
        rememberChangedField("ReferenceProduct", this.referenceProduct);
        this.referenceProduct = referenceProduct;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ServiceRefFunctionalLocation</b>
     * </p>
     *
     * @param serviceRefFunctionalLocation
     *            Functional Location
     */
    public void setServiceRefFunctionalLocation( @Nullable final String serviceRefFunctionalLocation )
    {
        rememberChangedField("ServiceRefFunctionalLocation", this.serviceRefFunctionalLocation);
        this.serviceRefFunctionalLocation = serviceRefFunctionalLocation;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>ServiceReferenceEquipment</b>
     * </p>
     *
     * @param serviceReferenceEquipment
     *            Equipment Number
     */
    public void setServiceReferenceEquipment( @Nullable final String serviceReferenceEquipment )
    {
        rememberChangedField("ServiceReferenceEquipment", this.serviceReferenceEquipment);
        this.serviceReferenceEquipment = serviceReferenceEquipment;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SrvcRefObjIsMainObject</b>
     * </p>
     *
     * @param srvcRefObjIsMainObject
     *            Main Reference Object
     */
    public void setSrvcRefObjIsMainObject( @Nullable final Boolean srvcRefObjIsMainObject )
    {
        rememberChangedField("SrvcRefObjIsMainObject", this.srvcRefObjIsMainObject);
        this.srvcRefObjIsMainObject = srvcRefObjIsMainObject;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_BusSolnOrdItmReferenceObject";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("BusinessSolutionOrder", getBusinessSolutionOrder());
        result.put("BusinessSolutionOrderItem", getBusinessSolutionOrderItem());
        result.put("ReferenceProduct", getReferenceProduct());
        result.put("ServiceRefFunctionalLocation", getServiceRefFunctionalLocation());
        result.put("ServiceReferenceEquipment", getServiceReferenceEquipment());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("BusinessSolutionOrder", getBusinessSolutionOrder());
        values.put("BusinessSolutionOrderItem", getBusinessSolutionOrderItem());
        values.put("ReferenceProduct", getReferenceProduct());
        values.put("ServiceRefFunctionalLocation", getServiceRefFunctionalLocation());
        values.put("ServiceReferenceEquipment", getServiceReferenceEquipment());
        values.put("SrvcRefObjIsMainObject", getSrvcRefObjIsMainObject());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("BusinessSolutionOrder") ) {
                final Object value = values.remove("BusinessSolutionOrder");
                if( (value == null) || (!value.equals(getBusinessSolutionOrder())) ) {
                    setBusinessSolutionOrder(((String) value));
                }
            }
            if( values.containsKey("BusinessSolutionOrderItem") ) {
                final Object value = values.remove("BusinessSolutionOrderItem");
                if( (value == null) || (!value.equals(getBusinessSolutionOrderItem())) ) {
                    setBusinessSolutionOrderItem(((String) value));
                }
            }
            if( values.containsKey("ReferenceProduct") ) {
                final Object value = values.remove("ReferenceProduct");
                if( (value == null) || (!value.equals(getReferenceProduct())) ) {
                    setReferenceProduct(((String) value));
                }
            }
            if( values.containsKey("ServiceRefFunctionalLocation") ) {
                final Object value = values.remove("ServiceRefFunctionalLocation");
                if( (value == null) || (!value.equals(getServiceRefFunctionalLocation())) ) {
                    setServiceRefFunctionalLocation(((String) value));
                }
            }
            if( values.containsKey("ServiceReferenceEquipment") ) {
                final Object value = values.remove("ServiceReferenceEquipment");
                if( (value == null) || (!value.equals(getServiceReferenceEquipment())) ) {
                    setServiceReferenceEquipment(((String) value));
                }
            }
            if( values.containsKey("SrvcRefObjIsMainObject") ) {
                final Object value = values.remove("SrvcRefObjIsMainObject");
                if( (value == null) || (!value.equals(getSrvcRefObjIsMainObject())) ) {
                    setSrvcRefObjIsMainObject(((Boolean) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> BusSolnOrdItmReferenceObjectField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new BusSolnOrdItmReferenceObjectField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BusSolnOrdItmReferenceObjectField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BusSolnOrdItmReferenceObjectField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessSolutionOrderService.DEFAULT_SERVICE_PATH);
    }

}
