/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.selectable.BusSolnOrdItmReferenceObjectSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmReferenceObject
 * BusSolnOrdItmReferenceObject} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class BusSolnOrdItmReferenceObjectByKeyFluentHelper
    extends
    FluentHelperByKey<BusSolnOrdItmReferenceObjectByKeyFluentHelper, BusSolnOrdItmReferenceObject, BusSolnOrdItmReferenceObjectSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmReferenceObject
     * BusSolnOrdItmReferenceObject} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code BusSolnOrdItmReferenceObject}
     * @param businessSolutionOrder
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code BusSolnOrdItmReferenceObject}
     * @param serviceRefFunctionalLocation
     *            Functional Location
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param referenceProduct
     *            Material Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param serviceReferenceEquipment
     *            Equipment Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 18
     *            </p>
     * @param businessSolutionOrderItem
     *            Shortened Item Number in Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     */
    public BusSolnOrdItmReferenceObjectByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String businessSolutionOrder,
        final String businessSolutionOrderItem,
        final String referenceProduct,
        final String serviceRefFunctionalLocation,
        final String serviceReferenceEquipment )
    {
        super(servicePath, entityCollection);
        this.key.put("BusinessSolutionOrder", businessSolutionOrder);
        this.key.put("BusinessSolutionOrderItem", businessSolutionOrderItem);
        this.key.put("ReferenceProduct", referenceProduct);
        this.key.put("ServiceRefFunctionalLocation", serviceRefFunctionalLocation);
        this.key.put("ServiceReferenceEquipment", serviceReferenceEquipment);
    }

    @Override
    @Nonnull
    protected Class<BusSolnOrdItmReferenceObject> getEntityClass()
    {
        return BusSolnOrdItmReferenceObject.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
