/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder;

import java.math.BigDecimal;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.field.BusSolnOrdItmSubscrpnPrAgrmtField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.selectable.BusSolnOrdItmSubscrpnPrAgrmtSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Subscription Billing Price Agreement
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_BusSolnOrdItmSubscrpnPrAgrmtType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BusSolnOrdItmSubscrpnPrAgrmt extends VdmEntity<BusSolnOrdItmSubscrpnPrAgrmt>
{

    /**
     * Selector for all available fields of BusSolnOrdItmSubscrpnPrAgrmt.
     *
     */
    public final static BusSolnOrdItmSubscrpnPrAgrmtSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BusinessSolutionOrder</b>
     * </p>
     *
     * @return Transaction ID
     */
    @Key
    @SerializedName( "BusinessSolutionOrder" )
    @JsonProperty( "BusinessSolutionOrder" )
    @Nullable
    @ODataField( odataName = "BusinessSolutionOrder" )
    private String businessSolutionOrder;
    /**
     * Use with available fluent helpers to apply the <b>BusinessSolutionOrder</b> field to query operations.
     *
     */
    public final static BusSolnOrdItmSubscrpnPrAgrmtField<String> BUSINESS_SOLUTION_ORDER =
        new BusSolnOrdItmSubscrpnPrAgrmtField<String>("BusinessSolutionOrder");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BusinessSolutionOrderItem</b>
     * </p>
     *
     * @return Shortened Item Number in Document
     */
    @Key
    @SerializedName( "BusinessSolutionOrderItem" )
    @JsonProperty( "BusinessSolutionOrderItem" )
    @Nullable
    @ODataField( odataName = "BusinessSolutionOrderItem" )
    private String businessSolutionOrderItem;
    /**
     * Use with available fluent helpers to apply the <b>BusinessSolutionOrderItem</b> field to query operations.
     *
     */
    public final static BusSolnOrdItmSubscrpnPrAgrmtField<String> BUSINESS_SOLUTION_ORDER_ITEM =
        new BusSolnOrdItmSubscrpnPrAgrmtField<String>("BusinessSolutionOrderItem");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SubscriptionRateElement</b>
     * </p>
     *
     * @return Product Number
     */
    @Key
    @SerializedName( "SubscriptionRateElement" )
    @JsonProperty( "SubscriptionRateElement" )
    @Nullable
    @ODataField( odataName = "SubscriptionRateElement" )
    private String subscriptionRateElement;
    /**
     * Use with available fluent helpers to apply the <b>SubscriptionRateElement</b> field to query operations.
     *
     */
    public final static BusSolnOrdItmSubscrpnPrAgrmtField<String> SUBSCRIPTION_RATE_ELEMENT =
        new BusSolnOrdItmSubscrpnPrAgrmtField<String>("SubscriptionRateElement");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>SubscriptionRateSubElement</b>
     * </p>
     *
     * @return Rate Subelement ID
     */
    @Key
    @SerializedName( "SubscriptionRateSubElement" )
    @JsonProperty( "SubscriptionRateSubElement" )
    @Nullable
    @ODataField( odataName = "SubscriptionRateSubElement" )
    private String subscriptionRateSubElement;
    /**
     * Use with available fluent helpers to apply the <b>SubscriptionRateSubElement</b> field to query operations.
     *
     */
    public final static BusSolnOrdItmSubscrpnPrAgrmtField<String> SUBSCRIPTION_RATE_SUB_ELEMENT =
        new BusSolnOrdItmSubscrpnPrAgrmtField<String>("SubscriptionRateSubElement");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SubscrpnBillgPrcElmntSpec</b>
     * </p>
     *
     * @return Code of Price Element Specification
     */
    @Key
    @SerializedName( "SubscrpnBillgPrcElmntSpec" )
    @JsonProperty( "SubscrpnBillgPrcElmntSpec" )
    @Nullable
    @ODataField( odataName = "SubscrpnBillgPrcElmntSpec" )
    private String subscrpnBillgPrcElmntSpec;
    /**
     * Use with available fluent helpers to apply the <b>SubscrpnBillgPrcElmntSpec</b> field to query operations.
     *
     */
    public final static BusSolnOrdItmSubscrpnPrAgrmtField<String> SUBSCRPN_BILLG_PRC_ELMNT_SPEC =
        new BusSolnOrdItmSubscrpnPrAgrmtField<String>("SubscrpnBillgPrcElmntSpec");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SubscrpnBillgPricingField</b>
     * </p>
     *
     * @return Pricing Field ID
     */
    @Key
    @SerializedName( "SubscrpnBillgPricingField" )
    @JsonProperty( "SubscrpnBillgPricingField" )
    @Nullable
    @ODataField( odataName = "SubscrpnBillgPricingField" )
    private String subscrpnBillgPricingField;
    /**
     * Use with available fluent helpers to apply the <b>SubscrpnBillgPricingField</b> field to query operations.
     *
     */
    public final static BusSolnOrdItmSubscrpnPrAgrmtField<String> SUBSCRPN_BILLG_PRICING_FIELD =
        new BusSolnOrdItmSubscrpnPrAgrmtField<String>("SubscrpnBillgPricingField");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SubscrpnBillgPrcAgreementLine</b>
     * </p>
     *
     * @return Condition item number
     */
    @Key
    @SerializedName( "SubscrpnBillgPrcAgreementLine" )
    @JsonProperty( "SubscrpnBillgPrcAgreementLine" )
    @Nullable
    @ODataField( odataName = "SubscrpnBillgPrcAgreementLine" )
    private String subscrpnBillgPrcAgreementLine;
    /**
     * Use with available fluent helpers to apply the <b>SubscrpnBillgPrcAgreementLine</b> field to query operations.
     *
     */
    public final static BusSolnOrdItmSubscrpnPrAgrmtField<String> SUBSCRPN_BILLG_PRC_AGREEMENT_LINE =
        new BusSolnOrdItmSubscrpnPrAgrmtField<String>("SubscrpnBillgPrcAgreementLine");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SubscrpnBillgPricingScaleType</b>
     * </p>
     *
     * @return Scale Type for Pricing
     */
    @SerializedName( "SubscrpnBillgPricingScaleType" )
    @JsonProperty( "SubscrpnBillgPricingScaleType" )
    @Nullable
    @ODataField( odataName = "SubscrpnBillgPricingScaleType" )
    private String subscrpnBillgPricingScaleType;
    /**
     * Use with available fluent helpers to apply the <b>SubscrpnBillgPricingScaleType</b> field to query operations.
     *
     */
    public final static BusSolnOrdItmSubscrpnPrAgrmtField<String> SUBSCRPN_BILLG_PRICING_SCALE_TYPE =
        new BusSolnOrdItmSubscrpnPrAgrmtField<String>("SubscrpnBillgPricingScaleType");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SubscrpnBillgCndnCalcType</b>
     * </p>
     *
     * @return Calculation Type for Condition
     */
    @SerializedName( "SubscrpnBillgCndnCalcType" )
    @JsonProperty( "SubscrpnBillgCndnCalcType" )
    @Nullable
    @ODataField( odataName = "SubscrpnBillgCndnCalcType" )
    private String subscrpnBillgCndnCalcType;
    /**
     * Use with available fluent helpers to apply the <b>SubscrpnBillgCndnCalcType</b> field to query operations.
     *
     */
    public final static BusSolnOrdItmSubscrpnPrAgrmtField<String> SUBSCRPN_BILLG_CNDN_CALC_TYPE =
        new BusSolnOrdItmSubscrpnPrAgrmtField<String>("SubscrpnBillgCndnCalcType");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleQuantity</b>
     * </p>
     *
     * @return Condition Scale Quantity
     */
    @SerializedName( "ConditionScaleQuantity" )
    @JsonProperty( "ConditionScaleQuantity" )
    @Nullable
    @ODataField( odataName = "ConditionScaleQuantity" )
    private BigDecimal conditionScaleQuantity;
    /**
     * Use with available fluent helpers to apply the <b>ConditionScaleQuantity</b> field to query operations.
     *
     */
    public final static BusSolnOrdItmSubscrpnPrAgrmtField<BigDecimal> CONDITION_SCALE_QUANTITY =
        new BusSolnOrdItmSubscrpnPrAgrmtField<BigDecimal>("ConditionScaleQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleQuantityUnit</b>
     * </p>
     *
     * @return Condition Scale Unit of Measure
     */
    @SerializedName( "ConditionScaleQuantityUnit" )
    @JsonProperty( "ConditionScaleQuantityUnit" )
    @Nullable
    @ODataField( odataName = "ConditionScaleQuantityUnit" )
    private String conditionScaleQuantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>ConditionScaleQuantityUnit</b> field to query operations.
     *
     */
    public final static BusSolnOrdItmSubscrpnPrAgrmtField<String> CONDITION_SCALE_QUANTITY_UNIT =
        new BusSolnOrdItmSubscrpnPrAgrmtField<String>("ConditionScaleQuantityUnit");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleAmount</b>
     * </p>
     *
     * @return Scale Value
     */
    @SerializedName( "ConditionScaleAmount" )
    @JsonProperty( "ConditionScaleAmount" )
    @Nullable
    @ODataField( odataName = "ConditionScaleAmount" )
    private BigDecimal conditionScaleAmount;
    /**
     * Use with available fluent helpers to apply the <b>ConditionScaleAmount</b> field to query operations.
     *
     */
    public final static BusSolnOrdItmSubscrpnPrAgrmtField<BigDecimal> CONDITION_SCALE_AMOUNT =
        new BusSolnOrdItmSubscrpnPrAgrmtField<BigDecimal>("ConditionScaleAmount");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleAmountCurrency</b>
     * </p>
     *
     * @return Scale Currency
     */
    @SerializedName( "ConditionScaleAmountCurrency" )
    @JsonProperty( "ConditionScaleAmountCurrency" )
    @Nullable
    @ODataField( odataName = "ConditionScaleAmountCurrency" )
    private String conditionScaleAmountCurrency;
    /**
     * Use with available fluent helpers to apply the <b>ConditionScaleAmountCurrency</b> field to query operations.
     *
     */
    public final static BusSolnOrdItmSubscrpnPrAgrmtField<String> CONDITION_SCALE_AMOUNT_CURRENCY =
        new BusSolnOrdItmSubscrpnPrAgrmtField<String>("ConditionScaleAmountCurrency");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateValue</b>
     * </p>
     *
     * @return Condition Value
     */
    @SerializedName( "ConditionRateValue" )
    @JsonProperty( "ConditionRateValue" )
    @Nullable
    @ODataField( odataName = "ConditionRateValue" )
    private BigDecimal conditionRateValue;
    /**
     * Use with available fluent helpers to apply the <b>ConditionRateValue</b> field to query operations.
     *
     */
    public final static BusSolnOrdItmSubscrpnPrAgrmtField<BigDecimal> CONDITION_RATE_VALUE =
        new BusSolnOrdItmSubscrpnPrAgrmtField<BigDecimal>("ConditionRateValue");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConditionCurrency</b>
     * </p>
     *
     * @return Currency
     */
    @SerializedName( "ConditionCurrency" )
    @JsonProperty( "ConditionCurrency" )
    @Nullable
    @ODataField( odataName = "ConditionCurrency" )
    private String conditionCurrency;
    /**
     * Use with available fluent helpers to apply the <b>ConditionCurrency</b> field to query operations.
     *
     */
    public final static BusSolnOrdItmSubscrpnPrAgrmtField<String> CONDITION_CURRENCY =
        new BusSolnOrdItmSubscrpnPrAgrmtField<String>("ConditionCurrency");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionQuantity</b>
     * </p>
     *
     * @return Condition Quantity
     */
    @SerializedName( "ConditionQuantity" )
    @JsonProperty( "ConditionQuantity" )
    @Nullable
    @ODataField( odataName = "ConditionQuantity" )
    private BigDecimal conditionQuantity;
    /**
     * Use with available fluent helpers to apply the <b>ConditionQuantity</b> field to query operations.
     *
     */
    public final static BusSolnOrdItmSubscrpnPrAgrmtField<BigDecimal> CONDITION_QUANTITY =
        new BusSolnOrdItmSubscrpnPrAgrmtField<BigDecimal>("ConditionQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionQuantityUnit</b>
     * </p>
     *
     * @return Condition Unit
     */
    @SerializedName( "ConditionQuantityUnit" )
    @JsonProperty( "ConditionQuantityUnit" )
    @Nullable
    @ODataField( odataName = "ConditionQuantityUnit" )
    private String conditionQuantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>ConditionQuantityUnit</b> field to query operations.
     *
     */
    public final static BusSolnOrdItmSubscrpnPrAgrmtField<String> CONDITION_QUANTITY_UNIT =
        new BusSolnOrdItmSubscrpnPrAgrmtField<String>("ConditionQuantityUnit");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 9
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateRatio</b>
     * </p>
     *
     * @return Condition Ratio (in Percent or Per Mille)
     */
    @SerializedName( "ConditionRateRatio" )
    @JsonProperty( "ConditionRateRatio" )
    @Nullable
    @ODataField( odataName = "ConditionRateRatio" )
    private BigDecimal conditionRateRatio;
    /**
     * Use with available fluent helpers to apply the <b>ConditionRateRatio</b> field to query operations.
     *
     */
    public final static BusSolnOrdItmSubscrpnPrAgrmtField<BigDecimal> CONDITION_RATE_RATIO =
        new BusSolnOrdItmSubscrpnPrAgrmtField<BigDecimal>("ConditionRateRatio");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SbscrBilgCndnScaleLineIsUnlmtd</b>
     * </p>
     *
     * @return Indicator for the condition line to be set as unlimited
     */
    @SerializedName( "SbscrBilgCndnScaleLineIsUnlmtd" )
    @JsonProperty( "SbscrBilgCndnScaleLineIsUnlmtd" )
    @Nullable
    @ODataField( odataName = "SbscrBilgCndnScaleLineIsUnlmtd" )
    private String sbscrBilgCndnScaleLineIsUnlmtd;
    /**
     * Use with available fluent helpers to apply the <b>SbscrBilgCndnScaleLineIsUnlmtd</b> field to query operations.
     *
     */
    public final static BusSolnOrdItmSubscrpnPrAgrmtField<String> SBSCR_BILG_CNDN_SCALE_LINE_IS_UNLMTD =
        new BusSolnOrdItmSubscrpnPrAgrmtField<String>("SbscrBilgCndnScaleLineIsUnlmtd");

    @Nonnull
    @Override
    public Class<BusSolnOrdItmSubscrpnPrAgrmt> getType()
    {
        return BusSolnOrdItmSubscrpnPrAgrmt.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BusinessSolutionOrder</b>
     * </p>
     *
     * @param businessSolutionOrder
     *            Transaction ID
     */
    public void setBusinessSolutionOrder( @Nullable final String businessSolutionOrder )
    {
        rememberChangedField("BusinessSolutionOrder", this.businessSolutionOrder);
        this.businessSolutionOrder = businessSolutionOrder;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BusinessSolutionOrderItem</b>
     * </p>
     *
     * @param businessSolutionOrderItem
     *            Shortened Item Number in Document
     */
    public void setBusinessSolutionOrderItem( @Nullable final String businessSolutionOrderItem )
    {
        rememberChangedField("BusinessSolutionOrderItem", this.businessSolutionOrderItem);
        this.businessSolutionOrderItem = businessSolutionOrderItem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SubscriptionRateElement</b>
     * </p>
     *
     * @param subscriptionRateElement
     *            Product Number
     */
    public void setSubscriptionRateElement( @Nullable final String subscriptionRateElement )
    {
        rememberChangedField("SubscriptionRateElement", this.subscriptionRateElement);
        this.subscriptionRateElement = subscriptionRateElement;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>SubscriptionRateSubElement</b>
     * </p>
     *
     * @param subscriptionRateSubElement
     *            Rate Subelement ID
     */
    public void setSubscriptionRateSubElement( @Nullable final String subscriptionRateSubElement )
    {
        rememberChangedField("SubscriptionRateSubElement", this.subscriptionRateSubElement);
        this.subscriptionRateSubElement = subscriptionRateSubElement;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SubscrpnBillgPrcElmntSpec</b>
     * </p>
     *
     * @param subscrpnBillgPrcElmntSpec
     *            Code of Price Element Specification
     */
    public void setSubscrpnBillgPrcElmntSpec( @Nullable final String subscrpnBillgPrcElmntSpec )
    {
        rememberChangedField("SubscrpnBillgPrcElmntSpec", this.subscrpnBillgPrcElmntSpec);
        this.subscrpnBillgPrcElmntSpec = subscrpnBillgPrcElmntSpec;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SubscrpnBillgPricingField</b>
     * </p>
     *
     * @param subscrpnBillgPricingField
     *            Pricing Field ID
     */
    public void setSubscrpnBillgPricingField( @Nullable final String subscrpnBillgPricingField )
    {
        rememberChangedField("SubscrpnBillgPricingField", this.subscrpnBillgPricingField);
        this.subscrpnBillgPricingField = subscrpnBillgPricingField;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SubscrpnBillgPrcAgreementLine</b>
     * </p>
     *
     * @param subscrpnBillgPrcAgreementLine
     *            Condition item number
     */
    public void setSubscrpnBillgPrcAgreementLine( @Nullable final String subscrpnBillgPrcAgreementLine )
    {
        rememberChangedField("SubscrpnBillgPrcAgreementLine", this.subscrpnBillgPrcAgreementLine);
        this.subscrpnBillgPrcAgreementLine = subscrpnBillgPrcAgreementLine;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SubscrpnBillgPricingScaleType</b>
     * </p>
     *
     * @param subscrpnBillgPricingScaleType
     *            Scale Type for Pricing
     */
    public void setSubscrpnBillgPricingScaleType( @Nullable final String subscrpnBillgPricingScaleType )
    {
        rememberChangedField("SubscrpnBillgPricingScaleType", this.subscrpnBillgPricingScaleType);
        this.subscrpnBillgPricingScaleType = subscrpnBillgPricingScaleType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SubscrpnBillgCndnCalcType</b>
     * </p>
     *
     * @param subscrpnBillgCndnCalcType
     *            Calculation Type for Condition
     */
    public void setSubscrpnBillgCndnCalcType( @Nullable final String subscrpnBillgCndnCalcType )
    {
        rememberChangedField("SubscrpnBillgCndnCalcType", this.subscrpnBillgCndnCalcType);
        this.subscrpnBillgCndnCalcType = subscrpnBillgCndnCalcType;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleQuantity</b>
     * </p>
     *
     * @param conditionScaleQuantity
     *            Condition Scale Quantity
     */
    public void setConditionScaleQuantity( @Nullable final BigDecimal conditionScaleQuantity )
    {
        rememberChangedField("ConditionScaleQuantity", this.conditionScaleQuantity);
        this.conditionScaleQuantity = conditionScaleQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleQuantityUnit</b>
     * </p>
     *
     * @param conditionScaleQuantityUnit
     *            Condition Scale Unit of Measure
     */
    public void setConditionScaleQuantityUnit( @Nullable final String conditionScaleQuantityUnit )
    {
        rememberChangedField("ConditionScaleQuantityUnit", this.conditionScaleQuantityUnit);
        this.conditionScaleQuantityUnit = conditionScaleQuantityUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleAmount</b>
     * </p>
     *
     * @param conditionScaleAmount
     *            Scale Value
     */
    public void setConditionScaleAmount( @Nullable final BigDecimal conditionScaleAmount )
    {
        rememberChangedField("ConditionScaleAmount", this.conditionScaleAmount);
        this.conditionScaleAmount = conditionScaleAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleAmountCurrency</b>
     * </p>
     *
     * @param conditionScaleAmountCurrency
     *            Scale Currency
     */
    public void setConditionScaleAmountCurrency( @Nullable final String conditionScaleAmountCurrency )
    {
        rememberChangedField("ConditionScaleAmountCurrency", this.conditionScaleAmountCurrency);
        this.conditionScaleAmountCurrency = conditionScaleAmountCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateValue</b>
     * </p>
     *
     * @param conditionRateValue
     *            Condition Value
     */
    public void setConditionRateValue( @Nullable final BigDecimal conditionRateValue )
    {
        rememberChangedField("ConditionRateValue", this.conditionRateValue);
        this.conditionRateValue = conditionRateValue;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConditionCurrency</b>
     * </p>
     *
     * @param conditionCurrency
     *            Currency
     */
    public void setConditionCurrency( @Nullable final String conditionCurrency )
    {
        rememberChangedField("ConditionCurrency", this.conditionCurrency);
        this.conditionCurrency = conditionCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionQuantity</b>
     * </p>
     *
     * @param conditionQuantity
     *            Condition Quantity
     */
    public void setConditionQuantity( @Nullable final BigDecimal conditionQuantity )
    {
        rememberChangedField("ConditionQuantity", this.conditionQuantity);
        this.conditionQuantity = conditionQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionQuantityUnit</b>
     * </p>
     *
     * @param conditionQuantityUnit
     *            Condition Unit
     */
    public void setConditionQuantityUnit( @Nullable final String conditionQuantityUnit )
    {
        rememberChangedField("ConditionQuantityUnit", this.conditionQuantityUnit);
        this.conditionQuantityUnit = conditionQuantityUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 9
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateRatio</b>
     * </p>
     *
     * @param conditionRateRatio
     *            Condition Ratio (in Percent or Per Mille)
     */
    public void setConditionRateRatio( @Nullable final BigDecimal conditionRateRatio )
    {
        rememberChangedField("ConditionRateRatio", this.conditionRateRatio);
        this.conditionRateRatio = conditionRateRatio;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SbscrBilgCndnScaleLineIsUnlmtd</b>
     * </p>
     *
     * @param sbscrBilgCndnScaleLineIsUnlmtd
     *            Indicator for the condition line to be set as unlimited
     */
    public void setSbscrBilgCndnScaleLineIsUnlmtd( @Nullable final String sbscrBilgCndnScaleLineIsUnlmtd )
    {
        rememberChangedField("SbscrBilgCndnScaleLineIsUnlmtd", this.sbscrBilgCndnScaleLineIsUnlmtd);
        this.sbscrBilgCndnScaleLineIsUnlmtd = sbscrBilgCndnScaleLineIsUnlmtd;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_BusSolnOrdItmSubscrpnPrAgrmt";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("BusinessSolutionOrder", getBusinessSolutionOrder());
        result.put("BusinessSolutionOrderItem", getBusinessSolutionOrderItem());
        result.put("SubscriptionRateElement", getSubscriptionRateElement());
        result.put("SubscriptionRateSubElement", getSubscriptionRateSubElement());
        result.put("SubscrpnBillgPrcElmntSpec", getSubscrpnBillgPrcElmntSpec());
        result.put("SubscrpnBillgPricingField", getSubscrpnBillgPricingField());
        result.put("SubscrpnBillgPrcAgreementLine", getSubscrpnBillgPrcAgreementLine());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("BusinessSolutionOrder", getBusinessSolutionOrder());
        values.put("BusinessSolutionOrderItem", getBusinessSolutionOrderItem());
        values.put("SubscriptionRateElement", getSubscriptionRateElement());
        values.put("SubscriptionRateSubElement", getSubscriptionRateSubElement());
        values.put("SubscrpnBillgPrcElmntSpec", getSubscrpnBillgPrcElmntSpec());
        values.put("SubscrpnBillgPricingField", getSubscrpnBillgPricingField());
        values.put("SubscrpnBillgPrcAgreementLine", getSubscrpnBillgPrcAgreementLine());
        values.put("SubscrpnBillgPricingScaleType", getSubscrpnBillgPricingScaleType());
        values.put("SubscrpnBillgCndnCalcType", getSubscrpnBillgCndnCalcType());
        values.put("ConditionScaleQuantity", getConditionScaleQuantity());
        values.put("ConditionScaleQuantityUnit", getConditionScaleQuantityUnit());
        values.put("ConditionScaleAmount", getConditionScaleAmount());
        values.put("ConditionScaleAmountCurrency", getConditionScaleAmountCurrency());
        values.put("ConditionRateValue", getConditionRateValue());
        values.put("ConditionCurrency", getConditionCurrency());
        values.put("ConditionQuantity", getConditionQuantity());
        values.put("ConditionQuantityUnit", getConditionQuantityUnit());
        values.put("ConditionRateRatio", getConditionRateRatio());
        values.put("SbscrBilgCndnScaleLineIsUnlmtd", getSbscrBilgCndnScaleLineIsUnlmtd());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("BusinessSolutionOrder") ) {
                final Object value = values.remove("BusinessSolutionOrder");
                if( (value == null) || (!value.equals(getBusinessSolutionOrder())) ) {
                    setBusinessSolutionOrder(((String) value));
                }
            }
            if( values.containsKey("BusinessSolutionOrderItem") ) {
                final Object value = values.remove("BusinessSolutionOrderItem");
                if( (value == null) || (!value.equals(getBusinessSolutionOrderItem())) ) {
                    setBusinessSolutionOrderItem(((String) value));
                }
            }
            if( values.containsKey("SubscriptionRateElement") ) {
                final Object value = values.remove("SubscriptionRateElement");
                if( (value == null) || (!value.equals(getSubscriptionRateElement())) ) {
                    setSubscriptionRateElement(((String) value));
                }
            }
            if( values.containsKey("SubscriptionRateSubElement") ) {
                final Object value = values.remove("SubscriptionRateSubElement");
                if( (value == null) || (!value.equals(getSubscriptionRateSubElement())) ) {
                    setSubscriptionRateSubElement(((String) value));
                }
            }
            if( values.containsKey("SubscrpnBillgPrcElmntSpec") ) {
                final Object value = values.remove("SubscrpnBillgPrcElmntSpec");
                if( (value == null) || (!value.equals(getSubscrpnBillgPrcElmntSpec())) ) {
                    setSubscrpnBillgPrcElmntSpec(((String) value));
                }
            }
            if( values.containsKey("SubscrpnBillgPricingField") ) {
                final Object value = values.remove("SubscrpnBillgPricingField");
                if( (value == null) || (!value.equals(getSubscrpnBillgPricingField())) ) {
                    setSubscrpnBillgPricingField(((String) value));
                }
            }
            if( values.containsKey("SubscrpnBillgPrcAgreementLine") ) {
                final Object value = values.remove("SubscrpnBillgPrcAgreementLine");
                if( (value == null) || (!value.equals(getSubscrpnBillgPrcAgreementLine())) ) {
                    setSubscrpnBillgPrcAgreementLine(((String) value));
                }
            }
            if( values.containsKey("SubscrpnBillgPricingScaleType") ) {
                final Object value = values.remove("SubscrpnBillgPricingScaleType");
                if( (value == null) || (!value.equals(getSubscrpnBillgPricingScaleType())) ) {
                    setSubscrpnBillgPricingScaleType(((String) value));
                }
            }
            if( values.containsKey("SubscrpnBillgCndnCalcType") ) {
                final Object value = values.remove("SubscrpnBillgCndnCalcType");
                if( (value == null) || (!value.equals(getSubscrpnBillgCndnCalcType())) ) {
                    setSubscrpnBillgCndnCalcType(((String) value));
                }
            }
            if( values.containsKey("ConditionScaleQuantity") ) {
                final Object value = values.remove("ConditionScaleQuantity");
                if( (value == null) || (!value.equals(getConditionScaleQuantity())) ) {
                    setConditionScaleQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionScaleQuantityUnit") ) {
                final Object value = values.remove("ConditionScaleQuantityUnit");
                if( (value == null) || (!value.equals(getConditionScaleQuantityUnit())) ) {
                    setConditionScaleQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("ConditionScaleAmount") ) {
                final Object value = values.remove("ConditionScaleAmount");
                if( (value == null) || (!value.equals(getConditionScaleAmount())) ) {
                    setConditionScaleAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionScaleAmountCurrency") ) {
                final Object value = values.remove("ConditionScaleAmountCurrency");
                if( (value == null) || (!value.equals(getConditionScaleAmountCurrency())) ) {
                    setConditionScaleAmountCurrency(((String) value));
                }
            }
            if( values.containsKey("ConditionRateValue") ) {
                final Object value = values.remove("ConditionRateValue");
                if( (value == null) || (!value.equals(getConditionRateValue())) ) {
                    setConditionRateValue(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionCurrency") ) {
                final Object value = values.remove("ConditionCurrency");
                if( (value == null) || (!value.equals(getConditionCurrency())) ) {
                    setConditionCurrency(((String) value));
                }
            }
            if( values.containsKey("ConditionQuantity") ) {
                final Object value = values.remove("ConditionQuantity");
                if( (value == null) || (!value.equals(getConditionQuantity())) ) {
                    setConditionQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionQuantityUnit") ) {
                final Object value = values.remove("ConditionQuantityUnit");
                if( (value == null) || (!value.equals(getConditionQuantityUnit())) ) {
                    setConditionQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("ConditionRateRatio") ) {
                final Object value = values.remove("ConditionRateRatio");
                if( (value == null) || (!value.equals(getConditionRateRatio())) ) {
                    setConditionRateRatio(((BigDecimal) value));
                }
            }
            if( values.containsKey("SbscrBilgCndnScaleLineIsUnlmtd") ) {
                final Object value = values.remove("SbscrBilgCndnScaleLineIsUnlmtd");
                if( (value == null) || (!value.equals(getSbscrBilgCndnScaleLineIsUnlmtd())) ) {
                    setSbscrBilgCndnScaleLineIsUnlmtd(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> BusSolnOrdItmSubscrpnPrAgrmtField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new BusSolnOrdItmSubscrpnPrAgrmtField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BusSolnOrdItmSubscrpnPrAgrmtField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BusSolnOrdItmSubscrpnPrAgrmtField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessSolutionOrderService.DEFAULT_SERVICE_PATH);
    }

}
