/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.selectable.BusSolnOrdItmSubscrpnPrAgrmtSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrAgrmt
 * BusSolnOrdItmSubscrpnPrAgrmt} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class BusSolnOrdItmSubscrpnPrAgrmtByKeyFluentHelper
    extends
    FluentHelperByKey<BusSolnOrdItmSubscrpnPrAgrmtByKeyFluentHelper, BusSolnOrdItmSubscrpnPrAgrmt, BusSolnOrdItmSubscrpnPrAgrmtSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrAgrmt
     * BusSolnOrdItmSubscrpnPrAgrmt} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code BusSolnOrdItmSubscrpnPrAgrmt}
     * @param businessSolutionOrder
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code BusSolnOrdItmSubscrpnPrAgrmt}
     * @param subscrpnBillgPricingField
     *            Pricing Field ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 20
     *            </p>
     * @param subscriptionRateSubElement
     *            Rate Subelement ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 50
     *            </p>
     * @param subscrpnBillgPrcElmntSpec
     *            Code of Price Element Specification
     *            <p>
     *            Constraints: Not nullable, Maximum length: 20
     *            </p>
     * @param businessSolutionOrderItem
     *            Shortened Item Number in Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param subscriptionRateElement
     *            Product Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param subscrpnBillgPrcAgreementLine
     *            Condition item number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     */
    public BusSolnOrdItmSubscrpnPrAgrmtByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String businessSolutionOrder,
        final String businessSolutionOrderItem,
        final String subscriptionRateElement,
        final String subscriptionRateSubElement,
        final String subscrpnBillgPrcElmntSpec,
        final String subscrpnBillgPricingField,
        final String subscrpnBillgPrcAgreementLine )
    {
        super(servicePath, entityCollection);
        this.key.put("BusinessSolutionOrder", businessSolutionOrder);
        this.key.put("BusinessSolutionOrderItem", businessSolutionOrderItem);
        this.key.put("SubscriptionRateElement", subscriptionRateElement);
        this.key.put("SubscriptionRateSubElement", subscriptionRateSubElement);
        this.key.put("SubscrpnBillgPrcElmntSpec", subscrpnBillgPrcElmntSpec);
        this.key.put("SubscrpnBillgPricingField", subscrpnBillgPricingField);
        this.key.put("SubscrpnBillgPrcAgreementLine", subscrpnBillgPrcAgreementLine);
    }

    @Override
    @Nonnull
    protected Class<BusSolnOrdItmSubscrpnPrAgrmt> getEntityClass()
    {
        return BusSolnOrdItmSubscrpnPrAgrmt.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
