/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder;

import java.math.BigDecimal;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.field.BusSolnOrdItmSubscrpnPrParamField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.selectable.BusSolnOrdItmSubscrpnPrParamSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Subscription Pricing Parameters
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_BusSolnOrdItmSubscrpnPrParamType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BusSolnOrdItmSubscrpnPrParam extends VdmEntity<BusSolnOrdItmSubscrpnPrParam>
{

    /**
     * Selector for all available fields of BusSolnOrdItmSubscrpnPrParam.
     *
     */
    public final static BusSolnOrdItmSubscrpnPrParamSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BusinessSolutionOrder</b>
     * </p>
     *
     * @return Transaction ID
     */
    @Key
    @SerializedName( "BusinessSolutionOrder" )
    @JsonProperty( "BusinessSolutionOrder" )
    @Nullable
    @ODataField( odataName = "BusinessSolutionOrder" )
    private String businessSolutionOrder;
    /**
     * Use with available fluent helpers to apply the <b>BusinessSolutionOrder</b> field to query operations.
     *
     */
    public final static BusSolnOrdItmSubscrpnPrParamField<String> BUSINESS_SOLUTION_ORDER =
        new BusSolnOrdItmSubscrpnPrParamField<String>("BusinessSolutionOrder");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BusinessSolutionOrderItem</b>
     * </p>
     *
     * @return Shortened Item Number in Document
     */
    @Key
    @SerializedName( "BusinessSolutionOrderItem" )
    @JsonProperty( "BusinessSolutionOrderItem" )
    @Nullable
    @ODataField( odataName = "BusinessSolutionOrderItem" )
    private String businessSolutionOrderItem;
    /**
     * Use with available fluent helpers to apply the <b>BusinessSolutionOrderItem</b> field to query operations.
     *
     */
    public final static BusSolnOrdItmSubscrpnPrParamField<String> BUSINESS_SOLUTION_ORDER_ITEM =
        new BusSolnOrdItmSubscrpnPrParamField<String>("BusinessSolutionOrderItem");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 64
     * <p>
     * Original property name from the Odata EDM: <b>SubscrpnPrcgParameter</b>
     * </p>
     *
     * @return Subscription Billing Parameter ID
     */
    @Key
    @SerializedName( "SubscrpnPrcgParameter" )
    @JsonProperty( "SubscrpnPrcgParameter" )
    @Nullable
    @ODataField( odataName = "SubscrpnPrcgParameter" )
    private String subscrpnPrcgParameter;
    /**
     * Use with available fluent helpers to apply the <b>SubscrpnPrcgParameter</b> field to query operations.
     *
     */
    public final static BusSolnOrdItmSubscrpnPrParamField<String> SUBSCRPN_PRCG_PARAMETER =
        new BusSolnOrdItmSubscrpnPrParamField<String>("SubscrpnPrcgParameter");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SubscrpnPrcgParamValType</b>
     * </p>
     *
     * @return Value Type of Subscription Billing Parameter
     */
    @SerializedName( "SubscrpnPrcgParamValType" )
    @JsonProperty( "SubscrpnPrcgParamValType" )
    @Nullable
    @ODataField( odataName = "SubscrpnPrcgParamValType" )
    private String subscrpnPrcgParamValType;
    /**
     * Use with available fluent helpers to apply the <b>SubscrpnPrcgParamValType</b> field to query operations.
     *
     */
    public final static BusSolnOrdItmSubscrpnPrParamField<String> SUBSCRPN_PRCG_PARAM_VAL_TYPE =
        new BusSolnOrdItmSubscrpnPrParamField<String>("SubscrpnPrcgParamValType");
    /**
     * Constraints: Not nullable, Precision: 28, Scale: 6
     * <p>
     * Original property name from the Odata EDM: <b>SubscrpnParameterDecimalValue</b>
     * </p>
     *
     * @return Numeric Manual Value for Subscription Billing Parameter
     */
    @SerializedName( "SubscrpnParameterDecimalValue" )
    @JsonProperty( "SubscrpnParameterDecimalValue" )
    @Nullable
    @ODataField( odataName = "SubscrpnParameterDecimalValue" )
    private BigDecimal subscrpnParameterDecimalValue;
    /**
     * Use with available fluent helpers to apply the <b>SubscrpnParameterDecimalValue</b> field to query operations.
     *
     */
    public final static BusSolnOrdItmSubscrpnPrParamField<BigDecimal> SUBSCRPN_PARAMETER_DECIMAL_VALUE =
        new BusSolnOrdItmSubscrpnPrParamField<BigDecimal>("SubscrpnParameterDecimalValue");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>SubscrpnPrcgParamValTypeText</b>
     * </p>
     *
     * @return Short Text for Fixed Values
     */
    @SerializedName( "SubscrpnPrcgParamValTypeText" )
    @JsonProperty( "SubscrpnPrcgParamValTypeText" )
    @Nullable
    @ODataField( odataName = "SubscrpnPrcgParamValTypeText" )
    private String subscrpnPrcgParamValTypeText;
    /**
     * Use with available fluent helpers to apply the <b>SubscrpnPrcgParamValTypeText</b> field to query operations.
     *
     */
    public final static BusSolnOrdItmSubscrpnPrParamField<String> SUBSCRPN_PRCG_PARAM_VAL_TYPE_TEXT =
        new BusSolnOrdItmSubscrpnPrParamField<String>("SubscrpnPrcgParamValTypeText");
    /**
     * Constraints: Not nullable, Precision: 28, Scale: 6
     * <p>
     * Original property name from the Odata EDM: <b>SubscrpnParamDfltDecimalValue</b>
     * </p>
     *
     * @return Numeric Default Value for Subscription Billing Parameter
     */
    @SerializedName( "SubscrpnParamDfltDecimalValue" )
    @JsonProperty( "SubscrpnParamDfltDecimalValue" )
    @Nullable
    @ODataField( odataName = "SubscrpnParamDfltDecimalValue" )
    private BigDecimal subscrpnParamDfltDecimalValue;
    /**
     * Use with available fluent helpers to apply the <b>SubscrpnParamDfltDecimalValue</b> field to query operations.
     *
     */
    public final static BusSolnOrdItmSubscrpnPrParamField<BigDecimal> SUBSCRPN_PARAM_DFLT_DECIMAL_VALUE =
        new BusSolnOrdItmSubscrpnPrParamField<BigDecimal>("SubscrpnParamDfltDecimalValue");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SubscrpnPrcgParamValIsSpcfd</b>
     * </p>
     *
     * @return The subscrpnPrcgParamValIsSpcfd contained in this entity.
     */
    @SerializedName( "SubscrpnPrcgParamValIsSpcfd" )
    @JsonProperty( "SubscrpnPrcgParamValIsSpcfd" )
    @Nullable
    @ODataField( odataName = "SubscrpnPrcgParamValIsSpcfd" )
    private String subscrpnPrcgParamValIsSpcfd;
    /**
     * Use with available fluent helpers to apply the <b>SubscrpnPrcgParamValIsSpcfd</b> field to query operations.
     *
     */
    public final static BusSolnOrdItmSubscrpnPrParamField<String> SUBSCRPN_PRCG_PARAM_VAL_IS_SPCFD =
        new BusSolnOrdItmSubscrpnPrParamField<String>("SubscrpnPrcgParamValIsSpcfd");

    @Nonnull
    @Override
    public Class<BusSolnOrdItmSubscrpnPrParam> getType()
    {
        return BusSolnOrdItmSubscrpnPrParam.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BusinessSolutionOrder</b>
     * </p>
     *
     * @param businessSolutionOrder
     *            Transaction ID
     */
    public void setBusinessSolutionOrder( @Nullable final String businessSolutionOrder )
    {
        rememberChangedField("BusinessSolutionOrder", this.businessSolutionOrder);
        this.businessSolutionOrder = businessSolutionOrder;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BusinessSolutionOrderItem</b>
     * </p>
     *
     * @param businessSolutionOrderItem
     *            Shortened Item Number in Document
     */
    public void setBusinessSolutionOrderItem( @Nullable final String businessSolutionOrderItem )
    {
        rememberChangedField("BusinessSolutionOrderItem", this.businessSolutionOrderItem);
        this.businessSolutionOrderItem = businessSolutionOrderItem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 64
     * <p>
     * Original property name from the Odata EDM: <b>SubscrpnPrcgParameter</b>
     * </p>
     *
     * @param subscrpnPrcgParameter
     *            Subscription Billing Parameter ID
     */
    public void setSubscrpnPrcgParameter( @Nullable final String subscrpnPrcgParameter )
    {
        rememberChangedField("SubscrpnPrcgParameter", this.subscrpnPrcgParameter);
        this.subscrpnPrcgParameter = subscrpnPrcgParameter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SubscrpnPrcgParamValType</b>
     * </p>
     *
     * @param subscrpnPrcgParamValType
     *            Value Type of Subscription Billing Parameter
     */
    public void setSubscrpnPrcgParamValType( @Nullable final String subscrpnPrcgParamValType )
    {
        rememberChangedField("SubscrpnPrcgParamValType", this.subscrpnPrcgParamValType);
        this.subscrpnPrcgParamValType = subscrpnPrcgParamValType;
    }

    /**
     * Constraints: Not nullable, Precision: 28, Scale: 6
     * <p>
     * Original property name from the Odata EDM: <b>SubscrpnParameterDecimalValue</b>
     * </p>
     *
     * @param subscrpnParameterDecimalValue
     *            Numeric Manual Value for Subscription Billing Parameter
     */
    public void setSubscrpnParameterDecimalValue( @Nullable final BigDecimal subscrpnParameterDecimalValue )
    {
        rememberChangedField("SubscrpnParameterDecimalValue", this.subscrpnParameterDecimalValue);
        this.subscrpnParameterDecimalValue = subscrpnParameterDecimalValue;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>SubscrpnPrcgParamValTypeText</b>
     * </p>
     *
     * @param subscrpnPrcgParamValTypeText
     *            Short Text for Fixed Values
     */
    public void setSubscrpnPrcgParamValTypeText( @Nullable final String subscrpnPrcgParamValTypeText )
    {
        rememberChangedField("SubscrpnPrcgParamValTypeText", this.subscrpnPrcgParamValTypeText);
        this.subscrpnPrcgParamValTypeText = subscrpnPrcgParamValTypeText;
    }

    /**
     * Constraints: Not nullable, Precision: 28, Scale: 6
     * <p>
     * Original property name from the Odata EDM: <b>SubscrpnParamDfltDecimalValue</b>
     * </p>
     *
     * @param subscrpnParamDfltDecimalValue
     *            Numeric Default Value for Subscription Billing Parameter
     */
    public void setSubscrpnParamDfltDecimalValue( @Nullable final BigDecimal subscrpnParamDfltDecimalValue )
    {
        rememberChangedField("SubscrpnParamDfltDecimalValue", this.subscrpnParamDfltDecimalValue);
        this.subscrpnParamDfltDecimalValue = subscrpnParamDfltDecimalValue;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SubscrpnPrcgParamValIsSpcfd</b>
     * </p>
     *
     * @param subscrpnPrcgParamValIsSpcfd
     *            The subscrpnPrcgParamValIsSpcfd to set.
     */
    public void setSubscrpnPrcgParamValIsSpcfd( @Nullable final String subscrpnPrcgParamValIsSpcfd )
    {
        rememberChangedField("SubscrpnPrcgParamValIsSpcfd", this.subscrpnPrcgParamValIsSpcfd);
        this.subscrpnPrcgParamValIsSpcfd = subscrpnPrcgParamValIsSpcfd;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_BusSolnOrdItmSubscrpnPrParam";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("BusinessSolutionOrder", getBusinessSolutionOrder());
        result.put("BusinessSolutionOrderItem", getBusinessSolutionOrderItem());
        result.put("SubscrpnPrcgParameter", getSubscrpnPrcgParameter());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("BusinessSolutionOrder", getBusinessSolutionOrder());
        values.put("BusinessSolutionOrderItem", getBusinessSolutionOrderItem());
        values.put("SubscrpnPrcgParameter", getSubscrpnPrcgParameter());
        values.put("SubscrpnPrcgParamValType", getSubscrpnPrcgParamValType());
        values.put("SubscrpnParameterDecimalValue", getSubscrpnParameterDecimalValue());
        values.put("SubscrpnPrcgParamValTypeText", getSubscrpnPrcgParamValTypeText());
        values.put("SubscrpnParamDfltDecimalValue", getSubscrpnParamDfltDecimalValue());
        values.put("SubscrpnPrcgParamValIsSpcfd", getSubscrpnPrcgParamValIsSpcfd());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("BusinessSolutionOrder") ) {
                final Object value = values.remove("BusinessSolutionOrder");
                if( (value == null) || (!value.equals(getBusinessSolutionOrder())) ) {
                    setBusinessSolutionOrder(((String) value));
                }
            }
            if( values.containsKey("BusinessSolutionOrderItem") ) {
                final Object value = values.remove("BusinessSolutionOrderItem");
                if( (value == null) || (!value.equals(getBusinessSolutionOrderItem())) ) {
                    setBusinessSolutionOrderItem(((String) value));
                }
            }
            if( values.containsKey("SubscrpnPrcgParameter") ) {
                final Object value = values.remove("SubscrpnPrcgParameter");
                if( (value == null) || (!value.equals(getSubscrpnPrcgParameter())) ) {
                    setSubscrpnPrcgParameter(((String) value));
                }
            }
            if( values.containsKey("SubscrpnPrcgParamValType") ) {
                final Object value = values.remove("SubscrpnPrcgParamValType");
                if( (value == null) || (!value.equals(getSubscrpnPrcgParamValType())) ) {
                    setSubscrpnPrcgParamValType(((String) value));
                }
            }
            if( values.containsKey("SubscrpnParameterDecimalValue") ) {
                final Object value = values.remove("SubscrpnParameterDecimalValue");
                if( (value == null) || (!value.equals(getSubscrpnParameterDecimalValue())) ) {
                    setSubscrpnParameterDecimalValue(((BigDecimal) value));
                }
            }
            if( values.containsKey("SubscrpnPrcgParamValTypeText") ) {
                final Object value = values.remove("SubscrpnPrcgParamValTypeText");
                if( (value == null) || (!value.equals(getSubscrpnPrcgParamValTypeText())) ) {
                    setSubscrpnPrcgParamValTypeText(((String) value));
                }
            }
            if( values.containsKey("SubscrpnParamDfltDecimalValue") ) {
                final Object value = values.remove("SubscrpnParamDfltDecimalValue");
                if( (value == null) || (!value.equals(getSubscrpnParamDfltDecimalValue())) ) {
                    setSubscrpnParamDfltDecimalValue(((BigDecimal) value));
                }
            }
            if( values.containsKey("SubscrpnPrcgParamValIsSpcfd") ) {
                final Object value = values.remove("SubscrpnPrcgParamValIsSpcfd");
                if( (value == null) || (!value.equals(getSubscrpnPrcgParamValIsSpcfd())) ) {
                    setSubscrpnPrcgParamValIsSpcfd(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> BusSolnOrdItmSubscrpnPrParamField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new BusSolnOrdItmSubscrpnPrParamField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BusSolnOrdItmSubscrpnPrParamField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BusSolnOrdItmSubscrpnPrParamField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessSolutionOrderService.DEFAULT_SERVICE_PATH);
    }

}
