/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperUpdate;

/**
 * Fluent helper to update an existing
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrParam
 * BusSolnOrdItmSubscrpnPrParam} entity and save it to the S/4HANA system.
 * <p>
 * To perform execution, call the {@link #executeRequest executeRequest} method on the fluent helper object.
 *
 */
public class BusSolnOrdItmSubscrpnPrParamUpdateFluentHelper
    extends
    FluentHelperUpdate<BusSolnOrdItmSubscrpnPrParamUpdateFluentHelper, BusSolnOrdItmSubscrpnPrParam>
{

    /**
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrParam
     * BusSolnOrdItmSubscrpnPrParam} entity object that will be updated in the S/4HANA system.
     *
     */
    private final BusSolnOrdItmSubscrpnPrParam entity;

    /**
     * Creates a fluent helper object that will update a
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrParam
     * BusSolnOrdItmSubscrpnPrParam} entity on the OData endpoint. To perform execution, call the {@link #executeRequest
     * executeRequest} method on the fluent helper object.
     *
     * @param servicePath
     *            The service path to direct the update requests to.
     * @param entity
     *            The BusSolnOrdItmSubscrpnPrParam to take the updated values from.
     */
    public BusSolnOrdItmSubscrpnPrParamUpdateFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final BusSolnOrdItmSubscrpnPrParam entity,
        @Nonnull final String entityCollection )
    {
        super(servicePath, entityCollection);
        this.entity = entity;
    }

    @Override
    @Nonnull
    protected BusSolnOrdItmSubscrpnPrParam getEntity()
    {
        return entity;
    }

}
