/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder;

import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.field.BusSolnOrdSrvcContractItemField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.link.BusSolnOrdSrvcContractItemLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.link.BusSolnOrdSrvcContractItemOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.selectable.BusSolnOrdSrvcContractItemSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Service Contract Item
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_BusSolnOrdSrvcContractItemType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BusSolnOrdSrvcContractItem extends VdmEntity<BusSolnOrdSrvcContractItem>
{

    /**
     * Selector for all available fields of BusSolnOrdSrvcContractItem.
     *
     */
    public final static BusSolnOrdSrvcContractItemSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BusinessSolutionOrder</b>
     * </p>
     *
     * @return Transaction ID
     */
    @Key
    @SerializedName( "BusinessSolutionOrder" )
    @JsonProperty( "BusinessSolutionOrder" )
    @Nullable
    @ODataField( odataName = "BusinessSolutionOrder" )
    private String businessSolutionOrder;
    /**
     * Use with available fluent helpers to apply the <b>BusinessSolutionOrder</b> field to query operations.
     *
     */
    public final static BusSolnOrdSrvcContractItemField<String> BUSINESS_SOLUTION_ORDER =
        new BusSolnOrdSrvcContractItemField<String>("BusinessSolutionOrder");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BusinessSolutionOrderItem</b>
     * </p>
     *
     * @return Shortened Item Number in Document
     */
    @Key
    @SerializedName( "BusinessSolutionOrderItem" )
    @JsonProperty( "BusinessSolutionOrderItem" )
    @Nullable
    @ODataField( odataName = "BusinessSolutionOrderItem" )
    private String businessSolutionOrderItem;
    /**
     * Use with available fluent helpers to apply the <b>BusinessSolutionOrderItem</b> field to query operations.
     *
     */
    public final static BusSolnOrdSrvcContractItemField<String> BUSINESS_SOLUTION_ORDER_ITEM =
        new BusSolnOrdSrvcContractItemField<String>("BusinessSolutionOrderItem");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocumentItemCharUUID</b>
     * </p>
     *
     * @return 32 Character CRM Object GUID (Converted)
     */
    @SerializedName( "ServiceDocumentItemCharUUID" )
    @JsonProperty( "ServiceDocumentItemCharUUID" )
    @Nullable
    @ODataField( odataName = "ServiceDocumentItemCharUUID" )
    private UUID serviceDocumentItemCharUUID;
    /**
     * Use with available fluent helpers to apply the <b>ServiceDocumentItemCharUUID</b> field to query operations.
     *
     */
    public final static BusSolnOrdSrvcContractItemField<UUID> SERVICE_DOCUMENT_ITEM_CHAR_UUID =
        new BusSolnOrdSrvcContractItemField<UUID>("ServiceDocumentItemCharUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BusinessSolutionOrderItemUUID</b>
     * </p>
     *
     * @return GUID of a CRM Order Object
     */
    @SerializedName( "BusinessSolutionOrderItemUUID" )
    @JsonProperty( "BusinessSolutionOrderItemUUID" )
    @Nullable
    @ODataField( odataName = "BusinessSolutionOrderItemUUID" )
    private UUID businessSolutionOrderItemUUID;
    /**
     * Use with available fluent helpers to apply the <b>BusinessSolutionOrderItemUUID</b> field to query operations.
     *
     */
    public final static BusSolnOrdSrvcContractItemField<UUID> BUSINESS_SOLUTION_ORDER_ITEM_UUID =
        new BusSolnOrdSrvcContractItemField<UUID>("BusinessSolutionOrderItemUUID");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmCategory</b>
     * </p>
     *
     * @return Item Category
     */
    @SerializedName( "BusSolnOrdItmCategory" )
    @JsonProperty( "BusSolnOrdItmCategory" )
    @Nullable
    @ODataField( odataName = "BusSolnOrdItmCategory" )
    private String busSolnOrdItmCategory;
    /**
     * Use with available fluent helpers to apply the <b>BusSolnOrdItmCategory</b> field to query operations.
     *
     */
    public final static BusSolnOrdSrvcContractItemField<String> BUS_SOLN_ORD_ITM_CATEGORY =
        new BusSolnOrdSrvcContractItemField<String>("BusSolnOrdItmCategory");
    /**
     * Constraints: Not nullable, Maximum length: 54
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @return Product Name Entered
     */
    @SerializedName( "Product" )
    @JsonProperty( "Product" )
    @Nullable
    @ODataField( odataName = "Product" )
    private String product;
    /**
     * Use with available fluent helpers to apply the <b>Product</b> field to query operations.
     *
     */
    public final static BusSolnOrdSrvcContractItemField<String> PRODUCT =
        new BusSolnOrdSrvcContractItemField<String>("Product");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Quantity</b>
     * </p>
     *
     * @return CRM: Order Quantity
     */
    @SerializedName( "Quantity" )
    @JsonProperty( "Quantity" )
    @Nullable
    @ODataField( odataName = "Quantity" )
    private BigDecimal quantity;
    /**
     * Use with available fluent helpers to apply the <b>Quantity</b> field to query operations.
     *
     */
    public final static BusSolnOrdSrvcContractItemField<BigDecimal> QUANTITY =
        new BusSolnOrdSrvcContractItemField<BigDecimal>("Quantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>QuantityUnit</b>
     * </p>
     *
     * @return Unit of Measure in Which the Product Is Sold
     */
    @SerializedName( "QuantityUnit" )
    @JsonProperty( "QuantityUnit" )
    @Nullable
    @ODataField( odataName = "QuantityUnit" )
    private String quantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>QuantityUnit</b> field to query operations.
     *
     */
    public final static BusSolnOrdSrvcContractItemField<String> QUANTITY_UNIT =
        new BusSolnOrdSrvcContractItemField<String>("QuantityUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmQtyUnitSAPCode</b>
     * </p>
     *
     * @return SAP Unit Code for Order Quantity
     */
    @SerializedName( "BusSolnOrdItmQtyUnitSAPCode" )
    @JsonProperty( "BusSolnOrdItmQtyUnitSAPCode" )
    @Nullable
    @ODataField( odataName = "BusSolnOrdItmQtyUnitSAPCode" )
    private String busSolnOrdItmQtyUnitSAPCode;
    /**
     * Use with available fluent helpers to apply the <b>BusSolnOrdItmQtyUnitSAPCode</b> field to query operations.
     *
     */
    public final static BusSolnOrdSrvcContractItemField<String> BUS_SOLN_ORD_ITM_QTY_UNIT_SAP_CODE =
        new BusSolnOrdSrvcContractItemField<String>("BusSolnOrdItmQtyUnitSAPCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmQtyUnitISOCode</b>
     * </p>
     *
     * @return ISO Unit Code for Order Quantity
     */
    @SerializedName( "BusSolnOrdItmQtyUnitISOCode" )
    @JsonProperty( "BusSolnOrdItmQtyUnitISOCode" )
    @Nullable
    @ODataField( odataName = "BusSolnOrdItmQtyUnitISOCode" )
    private String busSolnOrdItmQtyUnitISOCode;
    /**
     * Use with available fluent helpers to apply the <b>BusSolnOrdItmQtyUnitISOCode</b> field to query operations.
     *
     */
    public final static BusSolnOrdSrvcContractItemField<String> BUS_SOLN_ORD_ITM_QTY_UNIT_ISO_CODE =
        new BusSolnOrdSrvcContractItemField<String>("BusSolnOrdItmQtyUnitISOCode");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmDescription</b>
     * </p>
     *
     * @return Product Description
     */
    @SerializedName( "BusSolnOrdItmDescription" )
    @JsonProperty( "BusSolnOrdItmDescription" )
    @Nullable
    @ODataField( odataName = "BusSolnOrdItmDescription" )
    private String busSolnOrdItmDescription;
    /**
     * Use with available fluent helpers to apply the <b>BusSolnOrdItmDescription</b> field to query operations.
     *
     */
    public final static BusSolnOrdSrvcContractItemField<String> BUS_SOLN_ORD_ITM_DESCRIPTION =
        new BusSolnOrdSrvcContractItemField<String>("BusSolnOrdItmDescription");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Short Text Language for an Item
     */
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static BusSolnOrdSrvcContractItemField<String> LANGUAGE =
        new BusSolnOrdSrvcContractItemField<String>("Language");
    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmExtReference</b>
     * </p>
     *
     * @return External Reference Number
     */
    @SerializedName( "BusSolnOrdItmExtReference" )
    @JsonProperty( "BusSolnOrdItmExtReference" )
    @Nullable
    @ODataField( odataName = "BusSolnOrdItmExtReference" )
    private String busSolnOrdItmExtReference;
    /**
     * Use with available fluent helpers to apply the <b>BusSolnOrdItmExtReference</b> field to query operations.
     *
     */
    public final static BusSolnOrdSrvcContractItemField<String> BUS_SOLN_ORD_ITM_EXT_REFERENCE =
        new BusSolnOrdSrvcContractItemField<String>("BusSolnOrdItmExtReference");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmIsReleased</b>
     * </p>
     *
     * @return Release Status
     */
    @SerializedName( "BusSolnOrdItmIsReleased" )
    @JsonProperty( "BusSolnOrdItmIsReleased" )
    @Nullable
    @ODataField( odataName = "BusSolnOrdItmIsReleased" )
    private String busSolnOrdItmIsReleased;
    /**
     * Use with available fluent helpers to apply the <b>BusSolnOrdItmIsReleased</b> field to query operations.
     *
     */
    public final static BusSolnOrdSrvcContractItemField<String> BUS_SOLN_ORD_ITM_IS_RELEASED =
        new BusSolnOrdSrvcContractItemField<String>("BusSolnOrdItmIsReleased");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmIsCompleted</b>
     * </p>
     *
     * @return The busSolnOrdItmIsCompleted contained in this entity.
     */
    @SerializedName( "BusSolnOrdItmIsCompleted" )
    @JsonProperty( "BusSolnOrdItmIsCompleted" )
    @Nullable
    @ODataField( odataName = "BusSolnOrdItmIsCompleted" )
    private String busSolnOrdItmIsCompleted;
    /**
     * Use with available fluent helpers to apply the <b>BusSolnOrdItmIsCompleted</b> field to query operations.
     *
     */
    public final static BusSolnOrdSrvcContractItemField<String> BUS_SOLN_ORD_ITM_IS_COMPLETED =
        new BusSolnOrdSrvcContractItemField<String>("BusSolnOrdItmIsCompleted");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmIsRejected</b>
     * </p>
     *
     * @return Cancellation Status
     */
    @SerializedName( "BusSolnOrdItmIsRejected" )
    @JsonProperty( "BusSolnOrdItmIsRejected" )
    @Nullable
    @ODataField( odataName = "BusSolnOrdItmIsRejected" )
    private String busSolnOrdItmIsRejected;
    /**
     * Use with available fluent helpers to apply the <b>BusSolnOrdItmIsRejected</b> field to query operations.
     *
     */
    public final static BusSolnOrdSrvcContractItemField<String> BUS_SOLN_ORD_ITM_IS_REJECTED =
        new BusSolnOrdSrvcContractItemField<String>("BusSolnOrdItmIsRejected");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmDistrStatus</b>
     * </p>
     *
     * @return The busSolnOrdItmDistrStatus contained in this entity.
     */
    @SerializedName( "BusSolnOrdItmDistrStatus" )
    @JsonProperty( "BusSolnOrdItmDistrStatus" )
    @Nullable
    @ODataField( odataName = "BusSolnOrdItmDistrStatus" )
    private String busSolnOrdItmDistrStatus;
    /**
     * Use with available fluent helpers to apply the <b>BusSolnOrdItmDistrStatus</b> field to query operations.
     *
     */
    public final static BusSolnOrdSrvcContractItemField<String> BUS_SOLN_ORD_ITM_DISTR_STATUS =
        new BusSolnOrdSrvcContractItemField<String>("BusSolnOrdItmDistrStatus");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmDistrStatusName</b>
     * </p>
     *
     * @return The busSolnOrdItmDistrStatusName contained in this entity.
     */
    @SerializedName( "BusSolnOrdItmDistrStatusName" )
    @JsonProperty( "BusSolnOrdItmDistrStatusName" )
    @Nullable
    @ODataField( odataName = "BusSolnOrdItmDistrStatusName" )
    private String busSolnOrdItmDistrStatusName;
    /**
     * Use with available fluent helpers to apply the <b>BusSolnOrdItmDistrStatusName</b> field to query operations.
     *
     */
    public final static BusSolnOrdSrvcContractItemField<String> BUS_SOLN_ORD_ITM_DISTR_STATUS_NAME =
        new BusSolnOrdSrvcContractItemField<String>("BusSolnOrdItmDistrStatusName");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmRjcnReason</b>
     * </p>
     *
     * @return Cancellation Reason Code
     */
    @SerializedName( "BusSolnOrdItmRjcnReason" )
    @JsonProperty( "BusSolnOrdItmRjcnReason" )
    @Nullable
    @ODataField( odataName = "BusSolnOrdItmRjcnReason" )
    private String busSolnOrdItmRjcnReason;
    /**
     * Use with available fluent helpers to apply the <b>BusSolnOrdItmRjcnReason</b> field to query operations.
     *
     */
    public final static BusSolnOrdSrvcContractItemField<String> BUS_SOLN_ORD_ITM_RJCN_REASON =
        new BusSolnOrdSrvcContractItemField<String>("BusSolnOrdItmRjcnReason");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmRjcnReasonText</b>
     * </p>
     *
     * @return Description
     */
    @SerializedName( "BusSolnOrdItmRjcnReasonText" )
    @JsonProperty( "BusSolnOrdItmRjcnReasonText" )
    @Nullable
    @ODataField( odataName = "BusSolnOrdItmRjcnReasonText" )
    private String busSolnOrdItmRjcnReasonText;
    /**
     * Use with available fluent helpers to apply the <b>BusSolnOrdItmRjcnReasonText</b> field to query operations.
     *
     */
    public final static BusSolnOrdSrvcContractItemField<String> BUS_SOLN_ORD_ITM_RJCN_REASON_TEXT =
        new BusSolnOrdSrvcContractItemField<String>("BusSolnOrdItmRjcnReasonText");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BillingBlockReason</b>
     * </p>
     *
     * @return Business Partner: Billing Block Reason
     */
    @SerializedName( "BillingBlockReason" )
    @JsonProperty( "BillingBlockReason" )
    @Nullable
    @ODataField( odataName = "BillingBlockReason" )
    private String billingBlockReason;
    /**
     * Use with available fluent helpers to apply the <b>BillingBlockReason</b> field to query operations.
     *
     */
    public final static BusSolnOrdSrvcContractItemField<String> BILLING_BLOCK_REASON =
        new BusSolnOrdSrvcContractItemField<String>("BillingBlockReason");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocumentItemNetAmount</b>
     * </p>
     *
     * @return Net Value
     */
    @SerializedName( "ServiceDocumentItemNetAmount" )
    @JsonProperty( "ServiceDocumentItemNetAmount" )
    @Nullable
    @ODataField( odataName = "ServiceDocumentItemNetAmount" )
    private BigDecimal serviceDocumentItemNetAmount;
    /**
     * Use with available fluent helpers to apply the <b>ServiceDocumentItemNetAmount</b> field to query operations.
     *
     */
    public final static BusSolnOrdSrvcContractItemField<BigDecimal> SERVICE_DOCUMENT_ITEM_NET_AMOUNT =
        new BusSolnOrdSrvcContractItemField<BigDecimal>("ServiceDocumentItemNetAmount");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @return Currency
     */
    @SerializedName( "TransactionCurrency" )
    @JsonProperty( "TransactionCurrency" )
    @Nullable
    @ODataField( odataName = "TransactionCurrency" )
    private String transactionCurrency;
    /**
     * Use with available fluent helpers to apply the <b>TransactionCurrency</b> field to query operations.
     *
     */
    public final static BusSolnOrdSrvcContractItemField<String> TRANSACTION_CURRENCY =
        new BusSolnOrdSrvcContractItemField<String>("TransactionCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>ConfigurationNumber</b>
     * </p>
     *
     * @return Configuration (Internal Object Number)
     */
    @SerializedName( "ConfigurationNumber" )
    @JsonProperty( "ConfigurationNumber" )
    @Nullable
    @ODataField( odataName = "ConfigurationNumber" )
    private String configurationNumber;
    /**
     * Use with available fluent helpers to apply the <b>ConfigurationNumber</b> field to query operations.
     *
     */
    public final static BusSolnOrdSrvcContractItemField<String> CONFIGURATION_NUMBER =
        new BusSolnOrdSrvcContractItemField<String>("ConfigurationNumber");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SoldToParty</b>
     * </p>
     *
     * @return Sold-To Party
     */
    @SerializedName( "SoldToParty" )
    @JsonProperty( "SoldToParty" )
    @Nullable
    @ODataField( odataName = "SoldToParty" )
    private String soldToParty;
    /**
     * Use with available fluent helpers to apply the <b>SoldToParty</b> field to query operations.
     *
     */
    public final static BusSolnOrdSrvcContractItemField<String> SOLD_TO_PARTY =
        new BusSolnOrdSrvcContractItemField<String>("SoldToParty");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ShipToParty</b>
     * </p>
     *
     * @return Ship-To Party
     */
    @SerializedName( "ShipToParty" )
    @JsonProperty( "ShipToParty" )
    @Nullable
    @ODataField( odataName = "ShipToParty" )
    private String shipToParty;
    /**
     * Use with available fluent helpers to apply the <b>ShipToParty</b> field to query operations.
     *
     */
    public final static BusSolnOrdSrvcContractItemField<String> SHIP_TO_PARTY =
        new BusSolnOrdSrvcContractItemField<String>("ShipToParty");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BillToParty</b>
     * </p>
     *
     * @return Bill-To Party
     */
    @SerializedName( "BillToParty" )
    @JsonProperty( "BillToParty" )
    @Nullable
    @ODataField( odataName = "BillToParty" )
    private String billToParty;
    /**
     * Use with available fluent helpers to apply the <b>BillToParty</b> field to query operations.
     *
     */
    public final static BusSolnOrdSrvcContractItemField<String> BILL_TO_PARTY =
        new BusSolnOrdSrvcContractItemField<String>("BillToParty");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PayerParty</b>
     * </p>
     *
     * @return Payer
     */
    @SerializedName( "PayerParty" )
    @JsonProperty( "PayerParty" )
    @Nullable
    @ODataField( odataName = "PayerParty" )
    private String payerParty;
    /**
     * Use with available fluent helpers to apply the <b>PayerParty</b> field to query operations.
     *
     */
    public final static BusSolnOrdSrvcContractItemField<String> PAYER_PARTY =
        new BusSolnOrdSrvcContractItemField<String>("PayerParty");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PersonResponsible</b>
     * </p>
     *
     * @return Employee Responsible
     */
    @SerializedName( "PersonResponsible" )
    @JsonProperty( "PersonResponsible" )
    @Nullable
    @ODataField( odataName = "PersonResponsible" )
    private String personResponsible;
    /**
     * Use with available fluent helpers to apply the <b>PersonResponsible</b> field to query operations.
     *
     */
    public final static BusSolnOrdSrvcContractItemField<String> PERSON_RESPONSIBLE =
        new BusSolnOrdSrvcContractItemField<String>("PersonResponsible");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ContactPerson</b>
     * </p>
     *
     * @return Customer Contact Person
     */
    @SerializedName( "ContactPerson" )
    @JsonProperty( "ContactPerson" )
    @Nullable
    @ODataField( odataName = "ContactPerson" )
    private String contactPerson;
    /**
     * Use with available fluent helpers to apply the <b>ContactPerson</b> field to query operations.
     *
     */
    public final static BusSolnOrdSrvcContractItemField<String> CONTACT_PERSON =
        new BusSolnOrdSrvcContractItemField<String>("ContactPerson");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PaymentTerms</b>
     * </p>
     *
     * @return Terms of Payment
     */
    @SerializedName( "PaymentTerms" )
    @JsonProperty( "PaymentTerms" )
    @Nullable
    @ODataField( odataName = "PaymentTerms" )
    private String paymentTerms;
    /**
     * Use with available fluent helpers to apply the <b>PaymentTerms</b> field to query operations.
     *
     */
    public final static BusSolnOrdSrvcContractItemField<String> PAYMENT_TERMS =
        new BusSolnOrdSrvcContractItemField<String>("PaymentTerms");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceProfile</b>
     * </p>
     *
     * @return Service Profile
     */
    @SerializedName( "ServiceProfile" )
    @JsonProperty( "ServiceProfile" )
    @Nullable
    @ODataField( odataName = "ServiceProfile" )
    private String serviceProfile;
    /**
     * Use with available fluent helpers to apply the <b>ServiceProfile</b> field to query operations.
     *
     */
    public final static BusSolnOrdSrvcContractItemField<String> SERVICE_PROFILE =
        new BusSolnOrdSrvcContractItemField<String>("ServiceProfile");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ResponseProfile</b>
     * </p>
     *
     * @return Response Profile
     */
    @SerializedName( "ResponseProfile" )
    @JsonProperty( "ResponseProfile" )
    @Nullable
    @ODataField( odataName = "ResponseProfile" )
    private String responseProfile;
    /**
     * Use with available fluent helpers to apply the <b>ResponseProfile</b> field to query operations.
     *
     */
    public final static BusSolnOrdSrvcContractItemField<String> RESPONSE_PROFILE =
        new BusSolnOrdSrvcContractItemField<String>("ResponseProfile");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>BillingPlanBillingDateRule</b>
     * </p>
     *
     * @return Name for Date Rule
     */
    @SerializedName( "BillingPlanBillingDateRule" )
    @JsonProperty( "BillingPlanBillingDateRule" )
    @Nullable
    @ODataField( odataName = "BillingPlanBillingDateRule" )
    private String billingPlanBillingDateRule;
    /**
     * Use with available fluent helpers to apply the <b>BillingPlanBillingDateRule</b> field to query operations.
     *
     */
    public final static BusSolnOrdSrvcContractItemField<String> BILLING_PLAN_BILLING_DATE_RULE =
        new BusSolnOrdSrvcContractItemField<String>("BillingPlanBillingDateRule");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>SettlementPeriodRule</b>
     * </p>
     *
     * @return Name for Date Rule
     */
    @SerializedName( "SettlementPeriodRule" )
    @JsonProperty( "SettlementPeriodRule" )
    @Nullable
    @ODataField( odataName = "SettlementPeriodRule" )
    private String settlementPeriodRule;
    /**
     * Use with available fluent helpers to apply the <b>SettlementPeriodRule</b> field to query operations.
     *
     */
    public final static BusSolnOrdSrvcContractItemField<String> SETTLEMENT_PERIOD_RULE =
        new BusSolnOrdSrvcContractItemField<String>("SettlementPeriodRule");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ServiceContrItemStartDateTime</b>
     * </p>
     *
     * @return Contract Start date
     */
    @SerializedName( "ServiceContrItemStartDateTime" )
    @JsonProperty( "ServiceContrItemStartDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "ServiceContrItemStartDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime serviceContrItemStartDateTime;
    /**
     * Use with available fluent helpers to apply the <b>ServiceContrItemStartDateTime</b> field to query operations.
     *
     */
    public final static BusSolnOrdSrvcContractItemField<ZonedDateTime> SERVICE_CONTR_ITEM_START_DATE_TIME =
        new BusSolnOrdSrvcContractItemField<ZonedDateTime>("ServiceContrItemStartDateTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ServiceContrItemEndDateTime</b>
     * </p>
     *
     * @return Contract End Date
     */
    @SerializedName( "ServiceContrItemEndDateTime" )
    @JsonProperty( "ServiceContrItemEndDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "ServiceContrItemEndDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime serviceContrItemEndDateTime;
    /**
     * Use with available fluent helpers to apply the <b>ServiceContrItemEndDateTime</b> field to query operations.
     *
     */
    public final static BusSolnOrdSrvcContractItemField<ZonedDateTime> SERVICE_CONTR_ITEM_END_DATE_TIME =
        new BusSolnOrdSrvcContractItemField<ZonedDateTime>("ServiceContrItemEndDateTime");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>SrvcContrItemRnwlDuration</b>
     * </p>
     *
     * @return Unit for Auto Renewal Period
     */
    @SerializedName( "SrvcContrItemRnwlDuration" )
    @JsonProperty( "SrvcContrItemRnwlDuration" )
    @Nullable
    @ODataField( odataName = "SrvcContrItemRnwlDuration" )
    private BigDecimal srvcContrItemRnwlDuration;
    /**
     * Use with available fluent helpers to apply the <b>SrvcContrItemRnwlDuration</b> field to query operations.
     *
     */
    public final static BusSolnOrdSrvcContractItemField<BigDecimal> SRVC_CONTR_ITEM_RNWL_DURATION =
        new BusSolnOrdSrvcContractItemField<BigDecimal>("SrvcContrItemRnwlDuration");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SrvcContrItemRnwlDurationUnit</b>
     * </p>
     *
     * @return UOM for Auto Renewal Period
     */
    @SerializedName( "SrvcContrItemRnwlDurationUnit" )
    @JsonProperty( "SrvcContrItemRnwlDurationUnit" )
    @Nullable
    @ODataField( odataName = "SrvcContrItemRnwlDurationUnit" )
    private String srvcContrItemRnwlDurationUnit;
    /**
     * Use with available fluent helpers to apply the <b>SrvcContrItemRnwlDurationUnit</b> field to query operations.
     *
     */
    public final static BusSolnOrdSrvcContractItemField<String> SRVC_CONTR_ITEM_RNWL_DURATION_UNIT =
        new BusSolnOrdSrvcContractItemField<String>("SrvcContrItemRnwlDurationUnit");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>SrvcContrItemExtensionDuration</b>
     * </p>
     *
     * @return Unit for Contract Extension
     */
    @SerializedName( "SrvcContrItemExtensionDuration" )
    @JsonProperty( "SrvcContrItemExtensionDuration" )
    @Nullable
    @ODataField( odataName = "SrvcContrItemExtensionDuration" )
    private BigDecimal srvcContrItemExtensionDuration;
    /**
     * Use with available fluent helpers to apply the <b>SrvcContrItemExtensionDuration</b> field to query operations.
     *
     */
    public final static BusSolnOrdSrvcContractItemField<BigDecimal> SRVC_CONTR_ITEM_EXTENSION_DURATION =
        new BusSolnOrdSrvcContractItemField<BigDecimal>("SrvcContrItemExtensionDuration");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SrvcContrItemExtnDurationUnit</b>
     * </p>
     *
     * @return UOM for Contract Extension
     */
    @SerializedName( "SrvcContrItemExtnDurationUnit" )
    @JsonProperty( "SrvcContrItemExtnDurationUnit" )
    @Nullable
    @ODataField( odataName = "SrvcContrItemExtnDurationUnit" )
    private String srvcContrItemExtnDurationUnit;
    /**
     * Use with available fluent helpers to apply the <b>SrvcContrItemExtnDurationUnit</b> field to query operations.
     *
     */
    public final static BusSolnOrdSrvcContractItemField<String> SRVC_CONTR_ITEM_EXTN_DURATION_UNIT =
        new BusSolnOrdSrvcContractItemField<String>("SrvcContrItemExtnDurationUnit");
    /**
     * Constraints: Not nullable, Maximum length: 32
     * <p>
     * Original property name from the Odata EDM: <b>CPQQuotationItem</b>
     * </p>
     *
     * @return Identification of a Reference Object for Items
     */
    @SerializedName( "CPQQuotationItem" )
    @JsonProperty( "CPQQuotationItem" )
    @Nullable
    @ODataField( odataName = "CPQQuotationItem" )
    private String cPQQuotationItem;
    /**
     * Use with available fluent helpers to apply the <b>CPQQuotationItem</b> field to query operations.
     *
     */
    public final static BusSolnOrdSrvcContractItemField<String> CPQ_QUOTATION_ITEM =
        new BusSolnOrdSrvcContractItemField<String>("CPQQuotationItem");
    /**
     * Navigation property <b>to_BillingRequestItem</b> for <b>BusSolnOrdSrvcContractItem</b> to multiple
     * <b>BSOrdSrvcContrItmBillgReqItm</b>.
     *
     */
    @SerializedName( "to_BillingRequestItem" )
    @JsonProperty( "to_BillingRequestItem" )
    @ODataField( odataName = "to_BillingRequestItem" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BSOrdSrvcContrItmBillgReqItm> toBillingRequestItem;
    /**
     * Navigation property <b>to_BusinessSolutionOrder</b> for <b>BusSolnOrdSrvcContractItem</b> to single
     * <b>BusinessSolutionOrder</b>.
     *
     */
    @SerializedName( "to_BusinessSolutionOrder" )
    @JsonProperty( "to_BusinessSolutionOrder" )
    @ODataField( odataName = "to_BusinessSolutionOrder" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private BusinessSolutionOrder toBusinessSolutionOrder;
    /**
     * Navigation property <b>to_Configurations</b> for <b>BusSolnOrdSrvcContractItem</b> to multiple
     * <b>BusSolnOrdItmConfiguration</b>.
     *
     */
    @SerializedName( "to_Configurations" )
    @JsonProperty( "to_Configurations" )
    @ODataField( odataName = "to_Configurations" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BusSolnOrdItmConfiguration> toConfigurations;
    /**
     * Navigation property <b>to_ObjectList</b> for <b>BusSolnOrdSrvcContractItem</b> to multiple
     * <b>BusSolnOrderItemObjectList</b>.
     *
     */
    @SerializedName( "to_ObjectList" )
    @JsonProperty( "to_ObjectList" )
    @ODataField( odataName = "to_ObjectList" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BusSolnOrderItemObjectList> toObjectList;
    /**
     * Navigation property <b>to_PriceElement</b> for <b>BusSolnOrdSrvcContractItem</b> to multiple
     * <b>BusSolnOrderItemPriceElement</b>.
     *
     */
    @SerializedName( "to_PriceElement" )
    @JsonProperty( "to_PriceElement" )
    @ODataField( odataName = "to_PriceElement" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BusSolnOrderItemPriceElement> toPriceElement;
    /**
     * Navigation property <b>to_ProductList</b> for <b>BusSolnOrdSrvcContractItem</b> to multiple
     * <b>BusSolnOrderItemProductList</b>.
     *
     */
    @SerializedName( "to_ProductList" )
    @JsonProperty( "to_ProductList" )
    @ODataField( odataName = "to_ProductList" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BusSolnOrderItemProductList> toProductList;
    /**
     * Navigation property <b>to_ServiceContract</b> for <b>BusSolnOrdSrvcContractItem</b> to multiple
     * <b>BusSolnOrdItmFUPSrvcContr</b>.
     *
     */
    @SerializedName( "to_ServiceContract" )
    @JsonProperty( "to_ServiceContract" )
    @ODataField( odataName = "to_ServiceContract" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BusSolnOrdItmFUPSrvcContr> toServiceContract;
    /**
     * Navigation property <b>to_Text</b> for <b>BusSolnOrdSrvcContractItem</b> to multiple
     * <b>BusSolutionOrderItemText</b>.
     *
     */
    @SerializedName( "to_Text" )
    @JsonProperty( "to_Text" )
    @ODataField( odataName = "to_Text" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BusSolutionOrderItemText> toText;
    /**
     * Navigation property <b>to_UserStatus</b> for <b>BusSolnOrdSrvcContractItem</b> to multiple
     * <b>BusSolnOrdItmUserStatus</b>.
     *
     */
    @SerializedName( "to_UserStatus" )
    @JsonProperty( "to_UserStatus" )
    @ODataField( odataName = "to_UserStatus" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BusSolnOrdItmUserStatus> toUserStatus;
    /**
     * Use with available fluent helpers to apply the <b>to_BillingRequestItem</b> navigation property to query
     * operations.
     *
     */
    public final static BusSolnOrdSrvcContractItemLink<BSOrdSrvcContrItmBillgReqItm> TO_BILLING_REQUEST_ITEM =
        new BusSolnOrdSrvcContractItemLink<BSOrdSrvcContrItmBillgReqItm>("to_BillingRequestItem");
    /**
     * Use with available fluent helpers to apply the <b>to_BusinessSolutionOrder</b> navigation property to query
     * operations.
     *
     */
    public final static BusSolnOrdSrvcContractItemOneToOneLink<BusinessSolutionOrder> TO_BUSINESS_SOLUTION_ORDER =
        new BusSolnOrdSrvcContractItemOneToOneLink<BusinessSolutionOrder>("to_BusinessSolutionOrder");
    /**
     * Use with available fluent helpers to apply the <b>to_Configurations</b> navigation property to query operations.
     *
     */
    public final static BusSolnOrdSrvcContractItemLink<BusSolnOrdItmConfiguration> TO_CONFIGURATIONS =
        new BusSolnOrdSrvcContractItemLink<BusSolnOrdItmConfiguration>("to_Configurations");
    /**
     * Use with available fluent helpers to apply the <b>to_ObjectList</b> navigation property to query operations.
     *
     */
    public final static BusSolnOrdSrvcContractItemLink<BusSolnOrderItemObjectList> TO_OBJECT_LIST =
        new BusSolnOrdSrvcContractItemLink<BusSolnOrderItemObjectList>("to_ObjectList");
    /**
     * Use with available fluent helpers to apply the <b>to_PriceElement</b> navigation property to query operations.
     *
     */
    public final static BusSolnOrdSrvcContractItemLink<BusSolnOrderItemPriceElement> TO_PRICE_ELEMENT =
        new BusSolnOrdSrvcContractItemLink<BusSolnOrderItemPriceElement>("to_PriceElement");
    /**
     * Use with available fluent helpers to apply the <b>to_ProductList</b> navigation property to query operations.
     *
     */
    public final static BusSolnOrdSrvcContractItemLink<BusSolnOrderItemProductList> TO_PRODUCT_LIST =
        new BusSolnOrdSrvcContractItemLink<BusSolnOrderItemProductList>("to_ProductList");
    /**
     * Use with available fluent helpers to apply the <b>to_ServiceContract</b> navigation property to query operations.
     *
     */
    public final static BusSolnOrdSrvcContractItemLink<BusSolnOrdItmFUPSrvcContr> TO_SERVICE_CONTRACT =
        new BusSolnOrdSrvcContractItemLink<BusSolnOrdItmFUPSrvcContr>("to_ServiceContract");
    /**
     * Use with available fluent helpers to apply the <b>to_Text</b> navigation property to query operations.
     *
     */
    public final static BusSolnOrdSrvcContractItemLink<BusSolutionOrderItemText> TO_TEXT =
        new BusSolnOrdSrvcContractItemLink<BusSolutionOrderItemText>("to_Text");
    /**
     * Use with available fluent helpers to apply the <b>to_UserStatus</b> navigation property to query operations.
     *
     */
    public final static BusSolnOrdSrvcContractItemLink<BusSolnOrdItmUserStatus> TO_USER_STATUS =
        new BusSolnOrdSrvcContractItemLink<BusSolnOrdItmUserStatus>("to_UserStatus");

    @Nonnull
    @Override
    public Class<BusSolnOrdSrvcContractItem> getType()
    {
        return BusSolnOrdSrvcContractItem.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BusinessSolutionOrder</b>
     * </p>
     *
     * @param businessSolutionOrder
     *            Transaction ID
     */
    public void setBusinessSolutionOrder( @Nullable final String businessSolutionOrder )
    {
        rememberChangedField("BusinessSolutionOrder", this.businessSolutionOrder);
        this.businessSolutionOrder = businessSolutionOrder;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BusinessSolutionOrderItem</b>
     * </p>
     *
     * @param businessSolutionOrderItem
     *            Shortened Item Number in Document
     */
    public void setBusinessSolutionOrderItem( @Nullable final String businessSolutionOrderItem )
    {
        rememberChangedField("BusinessSolutionOrderItem", this.businessSolutionOrderItem);
        this.businessSolutionOrderItem = businessSolutionOrderItem;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocumentItemCharUUID</b>
     * </p>
     *
     * @param serviceDocumentItemCharUUID
     *            32 Character CRM Object GUID (Converted)
     */
    public void setServiceDocumentItemCharUUID( @Nullable final UUID serviceDocumentItemCharUUID )
    {
        rememberChangedField("ServiceDocumentItemCharUUID", this.serviceDocumentItemCharUUID);
        this.serviceDocumentItemCharUUID = serviceDocumentItemCharUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BusinessSolutionOrderItemUUID</b>
     * </p>
     *
     * @param businessSolutionOrderItemUUID
     *            GUID of a CRM Order Object
     */
    public void setBusinessSolutionOrderItemUUID( @Nullable final UUID businessSolutionOrderItemUUID )
    {
        rememberChangedField("BusinessSolutionOrderItemUUID", this.businessSolutionOrderItemUUID);
        this.businessSolutionOrderItemUUID = businessSolutionOrderItemUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmCategory</b>
     * </p>
     *
     * @param busSolnOrdItmCategory
     *            Item Category
     */
    public void setBusSolnOrdItmCategory( @Nullable final String busSolnOrdItmCategory )
    {
        rememberChangedField("BusSolnOrdItmCategory", this.busSolnOrdItmCategory);
        this.busSolnOrdItmCategory = busSolnOrdItmCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 54
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @param product
     *            Product Name Entered
     */
    public void setProduct( @Nullable final String product )
    {
        rememberChangedField("Product", this.product);
        this.product = product;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Quantity</b>
     * </p>
     *
     * @param quantity
     *            CRM: Order Quantity
     */
    public void setQuantity( @Nullable final BigDecimal quantity )
    {
        rememberChangedField("Quantity", this.quantity);
        this.quantity = quantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>QuantityUnit</b>
     * </p>
     *
     * @param quantityUnit
     *            Unit of Measure in Which the Product Is Sold
     */
    public void setQuantityUnit( @Nullable final String quantityUnit )
    {
        rememberChangedField("QuantityUnit", this.quantityUnit);
        this.quantityUnit = quantityUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmQtyUnitSAPCode</b>
     * </p>
     *
     * @param busSolnOrdItmQtyUnitSAPCode
     *            SAP Unit Code for Order Quantity
     */
    public void setBusSolnOrdItmQtyUnitSAPCode( @Nullable final String busSolnOrdItmQtyUnitSAPCode )
    {
        rememberChangedField("BusSolnOrdItmQtyUnitSAPCode", this.busSolnOrdItmQtyUnitSAPCode);
        this.busSolnOrdItmQtyUnitSAPCode = busSolnOrdItmQtyUnitSAPCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmQtyUnitISOCode</b>
     * </p>
     *
     * @param busSolnOrdItmQtyUnitISOCode
     *            ISO Unit Code for Order Quantity
     */
    public void setBusSolnOrdItmQtyUnitISOCode( @Nullable final String busSolnOrdItmQtyUnitISOCode )
    {
        rememberChangedField("BusSolnOrdItmQtyUnitISOCode", this.busSolnOrdItmQtyUnitISOCode);
        this.busSolnOrdItmQtyUnitISOCode = busSolnOrdItmQtyUnitISOCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmDescription</b>
     * </p>
     *
     * @param busSolnOrdItmDescription
     *            Product Description
     */
    public void setBusSolnOrdItmDescription( @Nullable final String busSolnOrdItmDescription )
    {
        rememberChangedField("BusSolnOrdItmDescription", this.busSolnOrdItmDescription);
        this.busSolnOrdItmDescription = busSolnOrdItmDescription;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Short Text Language for an Item
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmExtReference</b>
     * </p>
     *
     * @param busSolnOrdItmExtReference
     *            External Reference Number
     */
    public void setBusSolnOrdItmExtReference( @Nullable final String busSolnOrdItmExtReference )
    {
        rememberChangedField("BusSolnOrdItmExtReference", this.busSolnOrdItmExtReference);
        this.busSolnOrdItmExtReference = busSolnOrdItmExtReference;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmIsReleased</b>
     * </p>
     *
     * @param busSolnOrdItmIsReleased
     *            Release Status
     */
    public void setBusSolnOrdItmIsReleased( @Nullable final String busSolnOrdItmIsReleased )
    {
        rememberChangedField("BusSolnOrdItmIsReleased", this.busSolnOrdItmIsReleased);
        this.busSolnOrdItmIsReleased = busSolnOrdItmIsReleased;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmIsCompleted</b>
     * </p>
     *
     * @param busSolnOrdItmIsCompleted
     *            The busSolnOrdItmIsCompleted to set.
     */
    public void setBusSolnOrdItmIsCompleted( @Nullable final String busSolnOrdItmIsCompleted )
    {
        rememberChangedField("BusSolnOrdItmIsCompleted", this.busSolnOrdItmIsCompleted);
        this.busSolnOrdItmIsCompleted = busSolnOrdItmIsCompleted;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmIsRejected</b>
     * </p>
     *
     * @param busSolnOrdItmIsRejected
     *            Cancellation Status
     */
    public void setBusSolnOrdItmIsRejected( @Nullable final String busSolnOrdItmIsRejected )
    {
        rememberChangedField("BusSolnOrdItmIsRejected", this.busSolnOrdItmIsRejected);
        this.busSolnOrdItmIsRejected = busSolnOrdItmIsRejected;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmDistrStatus</b>
     * </p>
     *
     * @param busSolnOrdItmDistrStatus
     *            The busSolnOrdItmDistrStatus to set.
     */
    public void setBusSolnOrdItmDistrStatus( @Nullable final String busSolnOrdItmDistrStatus )
    {
        rememberChangedField("BusSolnOrdItmDistrStatus", this.busSolnOrdItmDistrStatus);
        this.busSolnOrdItmDistrStatus = busSolnOrdItmDistrStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmDistrStatusName</b>
     * </p>
     *
     * @param busSolnOrdItmDistrStatusName
     *            The busSolnOrdItmDistrStatusName to set.
     */
    public void setBusSolnOrdItmDistrStatusName( @Nullable final String busSolnOrdItmDistrStatusName )
    {
        rememberChangedField("BusSolnOrdItmDistrStatusName", this.busSolnOrdItmDistrStatusName);
        this.busSolnOrdItmDistrStatusName = busSolnOrdItmDistrStatusName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmRjcnReason</b>
     * </p>
     *
     * @param busSolnOrdItmRjcnReason
     *            Cancellation Reason Code
     */
    public void setBusSolnOrdItmRjcnReason( @Nullable final String busSolnOrdItmRjcnReason )
    {
        rememberChangedField("BusSolnOrdItmRjcnReason", this.busSolnOrdItmRjcnReason);
        this.busSolnOrdItmRjcnReason = busSolnOrdItmRjcnReason;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmRjcnReasonText</b>
     * </p>
     *
     * @param busSolnOrdItmRjcnReasonText
     *            Description
     */
    public void setBusSolnOrdItmRjcnReasonText( @Nullable final String busSolnOrdItmRjcnReasonText )
    {
        rememberChangedField("BusSolnOrdItmRjcnReasonText", this.busSolnOrdItmRjcnReasonText);
        this.busSolnOrdItmRjcnReasonText = busSolnOrdItmRjcnReasonText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BillingBlockReason</b>
     * </p>
     *
     * @param billingBlockReason
     *            Business Partner: Billing Block Reason
     */
    public void setBillingBlockReason( @Nullable final String billingBlockReason )
    {
        rememberChangedField("BillingBlockReason", this.billingBlockReason);
        this.billingBlockReason = billingBlockReason;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocumentItemNetAmount</b>
     * </p>
     *
     * @param serviceDocumentItemNetAmount
     *            Net Value
     */
    public void setServiceDocumentItemNetAmount( @Nullable final BigDecimal serviceDocumentItemNetAmount )
    {
        rememberChangedField("ServiceDocumentItemNetAmount", this.serviceDocumentItemNetAmount);
        this.serviceDocumentItemNetAmount = serviceDocumentItemNetAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @param transactionCurrency
     *            Currency
     */
    public void setTransactionCurrency( @Nullable final String transactionCurrency )
    {
        rememberChangedField("TransactionCurrency", this.transactionCurrency);
        this.transactionCurrency = transactionCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>ConfigurationNumber</b>
     * </p>
     *
     * @param configurationNumber
     *            Configuration (Internal Object Number)
     */
    public void setConfigurationNumber( @Nullable final String configurationNumber )
    {
        rememberChangedField("ConfigurationNumber", this.configurationNumber);
        this.configurationNumber = configurationNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SoldToParty</b>
     * </p>
     *
     * @param soldToParty
     *            Sold-To Party
     */
    public void setSoldToParty( @Nullable final String soldToParty )
    {
        rememberChangedField("SoldToParty", this.soldToParty);
        this.soldToParty = soldToParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ShipToParty</b>
     * </p>
     *
     * @param shipToParty
     *            Ship-To Party
     */
    public void setShipToParty( @Nullable final String shipToParty )
    {
        rememberChangedField("ShipToParty", this.shipToParty);
        this.shipToParty = shipToParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BillToParty</b>
     * </p>
     *
     * @param billToParty
     *            Bill-To Party
     */
    public void setBillToParty( @Nullable final String billToParty )
    {
        rememberChangedField("BillToParty", this.billToParty);
        this.billToParty = billToParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PayerParty</b>
     * </p>
     *
     * @param payerParty
     *            Payer
     */
    public void setPayerParty( @Nullable final String payerParty )
    {
        rememberChangedField("PayerParty", this.payerParty);
        this.payerParty = payerParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PersonResponsible</b>
     * </p>
     *
     * @param personResponsible
     *            Employee Responsible
     */
    public void setPersonResponsible( @Nullable final String personResponsible )
    {
        rememberChangedField("PersonResponsible", this.personResponsible);
        this.personResponsible = personResponsible;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ContactPerson</b>
     * </p>
     *
     * @param contactPerson
     *            Customer Contact Person
     */
    public void setContactPerson( @Nullable final String contactPerson )
    {
        rememberChangedField("ContactPerson", this.contactPerson);
        this.contactPerson = contactPerson;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PaymentTerms</b>
     * </p>
     *
     * @param paymentTerms
     *            Terms of Payment
     */
    public void setPaymentTerms( @Nullable final String paymentTerms )
    {
        rememberChangedField("PaymentTerms", this.paymentTerms);
        this.paymentTerms = paymentTerms;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceProfile</b>
     * </p>
     *
     * @param serviceProfile
     *            Service Profile
     */
    public void setServiceProfile( @Nullable final String serviceProfile )
    {
        rememberChangedField("ServiceProfile", this.serviceProfile);
        this.serviceProfile = serviceProfile;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ResponseProfile</b>
     * </p>
     *
     * @param responseProfile
     *            Response Profile
     */
    public void setResponseProfile( @Nullable final String responseProfile )
    {
        rememberChangedField("ResponseProfile", this.responseProfile);
        this.responseProfile = responseProfile;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>BillingPlanBillingDateRule</b>
     * </p>
     *
     * @param billingPlanBillingDateRule
     *            Name for Date Rule
     */
    public void setBillingPlanBillingDateRule( @Nullable final String billingPlanBillingDateRule )
    {
        rememberChangedField("BillingPlanBillingDateRule", this.billingPlanBillingDateRule);
        this.billingPlanBillingDateRule = billingPlanBillingDateRule;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>SettlementPeriodRule</b>
     * </p>
     *
     * @param settlementPeriodRule
     *            Name for Date Rule
     */
    public void setSettlementPeriodRule( @Nullable final String settlementPeriodRule )
    {
        rememberChangedField("SettlementPeriodRule", this.settlementPeriodRule);
        this.settlementPeriodRule = settlementPeriodRule;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ServiceContrItemStartDateTime</b>
     * </p>
     *
     * @param serviceContrItemStartDateTime
     *            Contract Start date
     */
    public void setServiceContrItemStartDateTime( @Nullable final ZonedDateTime serviceContrItemStartDateTime )
    {
        rememberChangedField("ServiceContrItemStartDateTime", this.serviceContrItemStartDateTime);
        this.serviceContrItemStartDateTime = serviceContrItemStartDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ServiceContrItemEndDateTime</b>
     * </p>
     *
     * @param serviceContrItemEndDateTime
     *            Contract End Date
     */
    public void setServiceContrItemEndDateTime( @Nullable final ZonedDateTime serviceContrItemEndDateTime )
    {
        rememberChangedField("ServiceContrItemEndDateTime", this.serviceContrItemEndDateTime);
        this.serviceContrItemEndDateTime = serviceContrItemEndDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>SrvcContrItemRnwlDuration</b>
     * </p>
     *
     * @param srvcContrItemRnwlDuration
     *            Unit for Auto Renewal Period
     */
    public void setSrvcContrItemRnwlDuration( @Nullable final BigDecimal srvcContrItemRnwlDuration )
    {
        rememberChangedField("SrvcContrItemRnwlDuration", this.srvcContrItemRnwlDuration);
        this.srvcContrItemRnwlDuration = srvcContrItemRnwlDuration;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SrvcContrItemRnwlDurationUnit</b>
     * </p>
     *
     * @param srvcContrItemRnwlDurationUnit
     *            UOM for Auto Renewal Period
     */
    public void setSrvcContrItemRnwlDurationUnit( @Nullable final String srvcContrItemRnwlDurationUnit )
    {
        rememberChangedField("SrvcContrItemRnwlDurationUnit", this.srvcContrItemRnwlDurationUnit);
        this.srvcContrItemRnwlDurationUnit = srvcContrItemRnwlDurationUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>SrvcContrItemExtensionDuration</b>
     * </p>
     *
     * @param srvcContrItemExtensionDuration
     *            Unit for Contract Extension
     */
    public void setSrvcContrItemExtensionDuration( @Nullable final BigDecimal srvcContrItemExtensionDuration )
    {
        rememberChangedField("SrvcContrItemExtensionDuration", this.srvcContrItemExtensionDuration);
        this.srvcContrItemExtensionDuration = srvcContrItemExtensionDuration;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SrvcContrItemExtnDurationUnit</b>
     * </p>
     *
     * @param srvcContrItemExtnDurationUnit
     *            UOM for Contract Extension
     */
    public void setSrvcContrItemExtnDurationUnit( @Nullable final String srvcContrItemExtnDurationUnit )
    {
        rememberChangedField("SrvcContrItemExtnDurationUnit", this.srvcContrItemExtnDurationUnit);
        this.srvcContrItemExtnDurationUnit = srvcContrItemExtnDurationUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 32
     * <p>
     * Original property name from the Odata EDM: <b>CPQQuotationItem</b>
     * </p>
     *
     * @param cPQQuotationItem
     *            Identification of a Reference Object for Items
     */
    public void setCPQQuotationItem( @Nullable final String cPQQuotationItem )
    {
        rememberChangedField("CPQQuotationItem", this.cPQQuotationItem);
        this.cPQQuotationItem = cPQQuotationItem;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_BusSolnOrdSrvcContractItem";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("BusinessSolutionOrder", getBusinessSolutionOrder());
        result.put("BusinessSolutionOrderItem", getBusinessSolutionOrderItem());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("BusinessSolutionOrder", getBusinessSolutionOrder());
        values.put("BusinessSolutionOrderItem", getBusinessSolutionOrderItem());
        values.put("ServiceDocumentItemCharUUID", getServiceDocumentItemCharUUID());
        values.put("BusinessSolutionOrderItemUUID", getBusinessSolutionOrderItemUUID());
        values.put("BusSolnOrdItmCategory", getBusSolnOrdItmCategory());
        values.put("Product", getProduct());
        values.put("Quantity", getQuantity());
        values.put("QuantityUnit", getQuantityUnit());
        values.put("BusSolnOrdItmQtyUnitSAPCode", getBusSolnOrdItmQtyUnitSAPCode());
        values.put("BusSolnOrdItmQtyUnitISOCode", getBusSolnOrdItmQtyUnitISOCode());
        values.put("BusSolnOrdItmDescription", getBusSolnOrdItmDescription());
        values.put("Language", getLanguage());
        values.put("BusSolnOrdItmExtReference", getBusSolnOrdItmExtReference());
        values.put("BusSolnOrdItmIsReleased", getBusSolnOrdItmIsReleased());
        values.put("BusSolnOrdItmIsCompleted", getBusSolnOrdItmIsCompleted());
        values.put("BusSolnOrdItmIsRejected", getBusSolnOrdItmIsRejected());
        values.put("BusSolnOrdItmDistrStatus", getBusSolnOrdItmDistrStatus());
        values.put("BusSolnOrdItmDistrStatusName", getBusSolnOrdItmDistrStatusName());
        values.put("BusSolnOrdItmRjcnReason", getBusSolnOrdItmRjcnReason());
        values.put("BusSolnOrdItmRjcnReasonText", getBusSolnOrdItmRjcnReasonText());
        values.put("BillingBlockReason", getBillingBlockReason());
        values.put("ServiceDocumentItemNetAmount", getServiceDocumentItemNetAmount());
        values.put("TransactionCurrency", getTransactionCurrency());
        values.put("ConfigurationNumber", getConfigurationNumber());
        values.put("SoldToParty", getSoldToParty());
        values.put("ShipToParty", getShipToParty());
        values.put("BillToParty", getBillToParty());
        values.put("PayerParty", getPayerParty());
        values.put("PersonResponsible", getPersonResponsible());
        values.put("ContactPerson", getContactPerson());
        values.put("PaymentTerms", getPaymentTerms());
        values.put("ServiceProfile", getServiceProfile());
        values.put("ResponseProfile", getResponseProfile());
        values.put("BillingPlanBillingDateRule", getBillingPlanBillingDateRule());
        values.put("SettlementPeriodRule", getSettlementPeriodRule());
        values.put("ServiceContrItemStartDateTime", getServiceContrItemStartDateTime());
        values.put("ServiceContrItemEndDateTime", getServiceContrItemEndDateTime());
        values.put("SrvcContrItemRnwlDuration", getSrvcContrItemRnwlDuration());
        values.put("SrvcContrItemRnwlDurationUnit", getSrvcContrItemRnwlDurationUnit());
        values.put("SrvcContrItemExtensionDuration", getSrvcContrItemExtensionDuration());
        values.put("SrvcContrItemExtnDurationUnit", getSrvcContrItemExtnDurationUnit());
        values.put("CPQQuotationItem", getCPQQuotationItem());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("BusinessSolutionOrder") ) {
                final Object value = values.remove("BusinessSolutionOrder");
                if( (value == null) || (!value.equals(getBusinessSolutionOrder())) ) {
                    setBusinessSolutionOrder(((String) value));
                }
            }
            if( values.containsKey("BusinessSolutionOrderItem") ) {
                final Object value = values.remove("BusinessSolutionOrderItem");
                if( (value == null) || (!value.equals(getBusinessSolutionOrderItem())) ) {
                    setBusinessSolutionOrderItem(((String) value));
                }
            }
            if( values.containsKey("ServiceDocumentItemCharUUID") ) {
                final Object value = values.remove("ServiceDocumentItemCharUUID");
                if( (value == null) || (!value.equals(getServiceDocumentItemCharUUID())) ) {
                    setServiceDocumentItemCharUUID(((UUID) value));
                }
            }
            if( values.containsKey("BusinessSolutionOrderItemUUID") ) {
                final Object value = values.remove("BusinessSolutionOrderItemUUID");
                if( (value == null) || (!value.equals(getBusinessSolutionOrderItemUUID())) ) {
                    setBusinessSolutionOrderItemUUID(((UUID) value));
                }
            }
            if( values.containsKey("BusSolnOrdItmCategory") ) {
                final Object value = values.remove("BusSolnOrdItmCategory");
                if( (value == null) || (!value.equals(getBusSolnOrdItmCategory())) ) {
                    setBusSolnOrdItmCategory(((String) value));
                }
            }
            if( values.containsKey("Product") ) {
                final Object value = values.remove("Product");
                if( (value == null) || (!value.equals(getProduct())) ) {
                    setProduct(((String) value));
                }
            }
            if( values.containsKey("Quantity") ) {
                final Object value = values.remove("Quantity");
                if( (value == null) || (!value.equals(getQuantity())) ) {
                    setQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("QuantityUnit") ) {
                final Object value = values.remove("QuantityUnit");
                if( (value == null) || (!value.equals(getQuantityUnit())) ) {
                    setQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("BusSolnOrdItmQtyUnitSAPCode") ) {
                final Object value = values.remove("BusSolnOrdItmQtyUnitSAPCode");
                if( (value == null) || (!value.equals(getBusSolnOrdItmQtyUnitSAPCode())) ) {
                    setBusSolnOrdItmQtyUnitSAPCode(((String) value));
                }
            }
            if( values.containsKey("BusSolnOrdItmQtyUnitISOCode") ) {
                final Object value = values.remove("BusSolnOrdItmQtyUnitISOCode");
                if( (value == null) || (!value.equals(getBusSolnOrdItmQtyUnitISOCode())) ) {
                    setBusSolnOrdItmQtyUnitISOCode(((String) value));
                }
            }
            if( values.containsKey("BusSolnOrdItmDescription") ) {
                final Object value = values.remove("BusSolnOrdItmDescription");
                if( (value == null) || (!value.equals(getBusSolnOrdItmDescription())) ) {
                    setBusSolnOrdItmDescription(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("BusSolnOrdItmExtReference") ) {
                final Object value = values.remove("BusSolnOrdItmExtReference");
                if( (value == null) || (!value.equals(getBusSolnOrdItmExtReference())) ) {
                    setBusSolnOrdItmExtReference(((String) value));
                }
            }
            if( values.containsKey("BusSolnOrdItmIsReleased") ) {
                final Object value = values.remove("BusSolnOrdItmIsReleased");
                if( (value == null) || (!value.equals(getBusSolnOrdItmIsReleased())) ) {
                    setBusSolnOrdItmIsReleased(((String) value));
                }
            }
            if( values.containsKey("BusSolnOrdItmIsCompleted") ) {
                final Object value = values.remove("BusSolnOrdItmIsCompleted");
                if( (value == null) || (!value.equals(getBusSolnOrdItmIsCompleted())) ) {
                    setBusSolnOrdItmIsCompleted(((String) value));
                }
            }
            if( values.containsKey("BusSolnOrdItmIsRejected") ) {
                final Object value = values.remove("BusSolnOrdItmIsRejected");
                if( (value == null) || (!value.equals(getBusSolnOrdItmIsRejected())) ) {
                    setBusSolnOrdItmIsRejected(((String) value));
                }
            }
            if( values.containsKey("BusSolnOrdItmDistrStatus") ) {
                final Object value = values.remove("BusSolnOrdItmDistrStatus");
                if( (value == null) || (!value.equals(getBusSolnOrdItmDistrStatus())) ) {
                    setBusSolnOrdItmDistrStatus(((String) value));
                }
            }
            if( values.containsKey("BusSolnOrdItmDistrStatusName") ) {
                final Object value = values.remove("BusSolnOrdItmDistrStatusName");
                if( (value == null) || (!value.equals(getBusSolnOrdItmDistrStatusName())) ) {
                    setBusSolnOrdItmDistrStatusName(((String) value));
                }
            }
            if( values.containsKey("BusSolnOrdItmRjcnReason") ) {
                final Object value = values.remove("BusSolnOrdItmRjcnReason");
                if( (value == null) || (!value.equals(getBusSolnOrdItmRjcnReason())) ) {
                    setBusSolnOrdItmRjcnReason(((String) value));
                }
            }
            if( values.containsKey("BusSolnOrdItmRjcnReasonText") ) {
                final Object value = values.remove("BusSolnOrdItmRjcnReasonText");
                if( (value == null) || (!value.equals(getBusSolnOrdItmRjcnReasonText())) ) {
                    setBusSolnOrdItmRjcnReasonText(((String) value));
                }
            }
            if( values.containsKey("BillingBlockReason") ) {
                final Object value = values.remove("BillingBlockReason");
                if( (value == null) || (!value.equals(getBillingBlockReason())) ) {
                    setBillingBlockReason(((String) value));
                }
            }
            if( values.containsKey("ServiceDocumentItemNetAmount") ) {
                final Object value = values.remove("ServiceDocumentItemNetAmount");
                if( (value == null) || (!value.equals(getServiceDocumentItemNetAmount())) ) {
                    setServiceDocumentItemNetAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("TransactionCurrency") ) {
                final Object value = values.remove("TransactionCurrency");
                if( (value == null) || (!value.equals(getTransactionCurrency())) ) {
                    setTransactionCurrency(((String) value));
                }
            }
            if( values.containsKey("ConfigurationNumber") ) {
                final Object value = values.remove("ConfigurationNumber");
                if( (value == null) || (!value.equals(getConfigurationNumber())) ) {
                    setConfigurationNumber(((String) value));
                }
            }
            if( values.containsKey("SoldToParty") ) {
                final Object value = values.remove("SoldToParty");
                if( (value == null) || (!value.equals(getSoldToParty())) ) {
                    setSoldToParty(((String) value));
                }
            }
            if( values.containsKey("ShipToParty") ) {
                final Object value = values.remove("ShipToParty");
                if( (value == null) || (!value.equals(getShipToParty())) ) {
                    setShipToParty(((String) value));
                }
            }
            if( values.containsKey("BillToParty") ) {
                final Object value = values.remove("BillToParty");
                if( (value == null) || (!value.equals(getBillToParty())) ) {
                    setBillToParty(((String) value));
                }
            }
            if( values.containsKey("PayerParty") ) {
                final Object value = values.remove("PayerParty");
                if( (value == null) || (!value.equals(getPayerParty())) ) {
                    setPayerParty(((String) value));
                }
            }
            if( values.containsKey("PersonResponsible") ) {
                final Object value = values.remove("PersonResponsible");
                if( (value == null) || (!value.equals(getPersonResponsible())) ) {
                    setPersonResponsible(((String) value));
                }
            }
            if( values.containsKey("ContactPerson") ) {
                final Object value = values.remove("ContactPerson");
                if( (value == null) || (!value.equals(getContactPerson())) ) {
                    setContactPerson(((String) value));
                }
            }
            if( values.containsKey("PaymentTerms") ) {
                final Object value = values.remove("PaymentTerms");
                if( (value == null) || (!value.equals(getPaymentTerms())) ) {
                    setPaymentTerms(((String) value));
                }
            }
            if( values.containsKey("ServiceProfile") ) {
                final Object value = values.remove("ServiceProfile");
                if( (value == null) || (!value.equals(getServiceProfile())) ) {
                    setServiceProfile(((String) value));
                }
            }
            if( values.containsKey("ResponseProfile") ) {
                final Object value = values.remove("ResponseProfile");
                if( (value == null) || (!value.equals(getResponseProfile())) ) {
                    setResponseProfile(((String) value));
                }
            }
            if( values.containsKey("BillingPlanBillingDateRule") ) {
                final Object value = values.remove("BillingPlanBillingDateRule");
                if( (value == null) || (!value.equals(getBillingPlanBillingDateRule())) ) {
                    setBillingPlanBillingDateRule(((String) value));
                }
            }
            if( values.containsKey("SettlementPeriodRule") ) {
                final Object value = values.remove("SettlementPeriodRule");
                if( (value == null) || (!value.equals(getSettlementPeriodRule())) ) {
                    setSettlementPeriodRule(((String) value));
                }
            }
            if( values.containsKey("ServiceContrItemStartDateTime") ) {
                final Object value = values.remove("ServiceContrItemStartDateTime");
                if( (value == null) || (!value.equals(getServiceContrItemStartDateTime())) ) {
                    setServiceContrItemStartDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("ServiceContrItemEndDateTime") ) {
                final Object value = values.remove("ServiceContrItemEndDateTime");
                if( (value == null) || (!value.equals(getServiceContrItemEndDateTime())) ) {
                    setServiceContrItemEndDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("SrvcContrItemRnwlDuration") ) {
                final Object value = values.remove("SrvcContrItemRnwlDuration");
                if( (value == null) || (!value.equals(getSrvcContrItemRnwlDuration())) ) {
                    setSrvcContrItemRnwlDuration(((BigDecimal) value));
                }
            }
            if( values.containsKey("SrvcContrItemRnwlDurationUnit") ) {
                final Object value = values.remove("SrvcContrItemRnwlDurationUnit");
                if( (value == null) || (!value.equals(getSrvcContrItemRnwlDurationUnit())) ) {
                    setSrvcContrItemRnwlDurationUnit(((String) value));
                }
            }
            if( values.containsKey("SrvcContrItemExtensionDuration") ) {
                final Object value = values.remove("SrvcContrItemExtensionDuration");
                if( (value == null) || (!value.equals(getSrvcContrItemExtensionDuration())) ) {
                    setSrvcContrItemExtensionDuration(((BigDecimal) value));
                }
            }
            if( values.containsKey("SrvcContrItemExtnDurationUnit") ) {
                final Object value = values.remove("SrvcContrItemExtnDurationUnit");
                if( (value == null) || (!value.equals(getSrvcContrItemExtnDurationUnit())) ) {
                    setSrvcContrItemExtnDurationUnit(((String) value));
                }
            }
            if( values.containsKey("CPQQuotationItem") ) {
                final Object value = values.remove("CPQQuotationItem");
                if( (value == null) || (!value.equals(getCPQQuotationItem())) ) {
                    setCPQQuotationItem(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_BillingRequestItem") ) {
                final Object value = (values).remove("to_BillingRequestItem");
                if( value instanceof Iterable ) {
                    if( toBillingRequestItem == null ) {
                        toBillingRequestItem = Lists.newArrayList();
                    } else {
                        toBillingRequestItem = Lists.newArrayList(toBillingRequestItem);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BSOrdSrvcContrItmBillgReqItm entity;
                        if( toBillingRequestItem.size() > i ) {
                            entity = toBillingRequestItem.get(i);
                        } else {
                            entity = new BSOrdSrvcContrItmBillgReqItm();
                            toBillingRequestItem.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_BusinessSolutionOrder") ) {
                final Object value = (values).remove("to_BusinessSolutionOrder");
                if( value instanceof Map ) {
                    if( toBusinessSolutionOrder == null ) {
                        toBusinessSolutionOrder = new BusinessSolutionOrder();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toBusinessSolutionOrder.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_Configurations") ) {
                final Object value = (values).remove("to_Configurations");
                if( value instanceof Iterable ) {
                    if( toConfigurations == null ) {
                        toConfigurations = Lists.newArrayList();
                    } else {
                        toConfigurations = Lists.newArrayList(toConfigurations);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BusSolnOrdItmConfiguration entity;
                        if( toConfigurations.size() > i ) {
                            entity = toConfigurations.get(i);
                        } else {
                            entity = new BusSolnOrdItmConfiguration();
                            toConfigurations.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_ObjectList") ) {
                final Object value = (values).remove("to_ObjectList");
                if( value instanceof Iterable ) {
                    if( toObjectList == null ) {
                        toObjectList = Lists.newArrayList();
                    } else {
                        toObjectList = Lists.newArrayList(toObjectList);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BusSolnOrderItemObjectList entity;
                        if( toObjectList.size() > i ) {
                            entity = toObjectList.get(i);
                        } else {
                            entity = new BusSolnOrderItemObjectList();
                            toObjectList.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_PriceElement") ) {
                final Object value = (values).remove("to_PriceElement");
                if( value instanceof Iterable ) {
                    if( toPriceElement == null ) {
                        toPriceElement = Lists.newArrayList();
                    } else {
                        toPriceElement = Lists.newArrayList(toPriceElement);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BusSolnOrderItemPriceElement entity;
                        if( toPriceElement.size() > i ) {
                            entity = toPriceElement.get(i);
                        } else {
                            entity = new BusSolnOrderItemPriceElement();
                            toPriceElement.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_ProductList") ) {
                final Object value = (values).remove("to_ProductList");
                if( value instanceof Iterable ) {
                    if( toProductList == null ) {
                        toProductList = Lists.newArrayList();
                    } else {
                        toProductList = Lists.newArrayList(toProductList);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BusSolnOrderItemProductList entity;
                        if( toProductList.size() > i ) {
                            entity = toProductList.get(i);
                        } else {
                            entity = new BusSolnOrderItemProductList();
                            toProductList.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_ServiceContract") ) {
                final Object value = (values).remove("to_ServiceContract");
                if( value instanceof Iterable ) {
                    if( toServiceContract == null ) {
                        toServiceContract = Lists.newArrayList();
                    } else {
                        toServiceContract = Lists.newArrayList(toServiceContract);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BusSolnOrdItmFUPSrvcContr entity;
                        if( toServiceContract.size() > i ) {
                            entity = toServiceContract.get(i);
                        } else {
                            entity = new BusSolnOrdItmFUPSrvcContr();
                            toServiceContract.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_Text") ) {
                final Object value = (values).remove("to_Text");
                if( value instanceof Iterable ) {
                    if( toText == null ) {
                        toText = Lists.newArrayList();
                    } else {
                        toText = Lists.newArrayList(toText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BusSolutionOrderItemText entity;
                        if( toText.size() > i ) {
                            entity = toText.get(i);
                        } else {
                            entity = new BusSolutionOrderItemText();
                            toText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_UserStatus") ) {
                final Object value = (values).remove("to_UserStatus");
                if( value instanceof Iterable ) {
                    if( toUserStatus == null ) {
                        toUserStatus = Lists.newArrayList();
                    } else {
                        toUserStatus = Lists.newArrayList(toUserStatus);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BusSolnOrdItmUserStatus entity;
                        if( toUserStatus.size() > i ) {
                            entity = toUserStatus.get(i);
                        } else {
                            entity = new BusSolnOrdItmUserStatus();
                            toUserStatus.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> BusSolnOrdSrvcContractItemField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new BusSolnOrdSrvcContractItemField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BusSolnOrdSrvcContractItemField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BusSolnOrdSrvcContractItemField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessSolutionOrderService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toBillingRequestItem != null ) {
            (values).put("to_BillingRequestItem", toBillingRequestItem);
        }
        if( toBusinessSolutionOrder != null ) {
            (values).put("to_BusinessSolutionOrder", toBusinessSolutionOrder);
        }
        if( toConfigurations != null ) {
            (values).put("to_Configurations", toConfigurations);
        }
        if( toObjectList != null ) {
            (values).put("to_ObjectList", toObjectList);
        }
        if( toPriceElement != null ) {
            (values).put("to_PriceElement", toPriceElement);
        }
        if( toProductList != null ) {
            (values).put("to_ProductList", toProductList);
        }
        if( toServiceContract != null ) {
            (values).put("to_ServiceContract", toServiceContract);
        }
        if( toText != null ) {
            (values).put("to_Text", toText);
        }
        if( toUserStatus != null ) {
            (values).put("to_UserStatus", toUserStatus);
        }
        return values;
    }

    /**
     * Fetches the <b>BSOrdSrvcContrItmBillgReqItm</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_BillingRequestItem</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BSOrdSrvcContrItmBillgReqItm</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BSOrdSrvcContrItmBillgReqItm> fetchBillingRequestItem()
    {
        return fetchFieldAsList("to_BillingRequestItem", BSOrdSrvcContrItmBillgReqItm.class);
    }

    /**
     * Retrieval of associated <b>BSOrdSrvcContrItmBillgReqItm</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_BillingRequestItem</b>.
     * <p>
     * If the navigation property <b>to_BillingRequestItem</b> of a queried <b>BusSolnOrdSrvcContractItem</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BSOrdSrvcContrItmBillgReqItm</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BSOrdSrvcContrItmBillgReqItm> getBillingRequestItemOrFetch()
    {
        if( toBillingRequestItem == null ) {
            toBillingRequestItem = fetchBillingRequestItem();
        }
        return toBillingRequestItem;
    }

    /**
     * Retrieval of associated <b>BSOrdSrvcContrItmBillgReqItm</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_BillingRequestItem</b>.
     * <p>
     * If the navigation property for an entity <b>BusSolnOrdSrvcContractItem</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BillingRequestItem</b> is already loaded, the result
     *         will contain the <b>BSOrdSrvcContrItmBillgReqItm</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BSOrdSrvcContrItmBillgReqItm>> getBillingRequestItemIfPresent()
    {
        return Option.of(toBillingRequestItem);
    }

    /**
     * Overwrites the list of associated <b>BSOrdSrvcContrItmBillgReqItm</b> entities for the loaded navigation property
     * <b>to_BillingRequestItem</b>.
     * <p>
     * If the navigation property <b>to_BillingRequestItem</b> of a queried <b>BusSolnOrdSrvcContractItem</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BSOrdSrvcContrItmBillgReqItm</b> entities.
     */
    public void setBillingRequestItem( @Nonnull final List<BSOrdSrvcContrItmBillgReqItm> value )
    {
        if( toBillingRequestItem == null ) {
            toBillingRequestItem = Lists.newArrayList();
        }
        toBillingRequestItem.clear();
        toBillingRequestItem.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BSOrdSrvcContrItmBillgReqItm</b> entities. This corresponds to the
     * OData navigation property <b>to_BillingRequestItem</b>.
     * <p>
     * If the navigation property <b>to_BillingRequestItem</b> of a queried <b>BusSolnOrdSrvcContractItem</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BSOrdSrvcContrItmBillgReqItm</b> entities.
     */
    public void addBillingRequestItem( BSOrdSrvcContrItmBillgReqItm... entity )
    {
        if( toBillingRequestItem == null ) {
            toBillingRequestItem = Lists.newArrayList();
        }
        toBillingRequestItem.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>BusinessSolutionOrder</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_BusinessSolutionOrder</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>BusinessSolutionOrder</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BusinessSolutionOrder fetchBusinessSolutionOrder()
    {
        return fetchFieldAsSingle("to_BusinessSolutionOrder", BusinessSolutionOrder.class);
    }

    /**
     * Retrieval of associated <b>BusinessSolutionOrder</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_BusinessSolutionOrder</b>.
     * <p>
     * If the navigation property <b>to_BusinessSolutionOrder</b> of a queried <b>BusSolnOrdSrvcContractItem</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BusinessSolutionOrder</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BusinessSolutionOrder getBusinessSolutionOrderOrFetch()
    {
        if( toBusinessSolutionOrder == null ) {
            toBusinessSolutionOrder = fetchBusinessSolutionOrder();
        }
        return toBusinessSolutionOrder;
    }

    /**
     * Retrieval of associated <b>BusinessSolutionOrder</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_BusinessSolutionOrder</b>.
     * <p>
     * If the navigation property for an entity <b>BusSolnOrdSrvcContractItem</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BusinessSolutionOrder</b> is already loaded, the result
     *         will contain the <b>BusinessSolutionOrder</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<BusinessSolutionOrder> getBusinessSolutionOrderIfPresent()
    {
        return Option.of(toBusinessSolutionOrder);
    }

    /**
     * Overwrites the associated <b>BusinessSolutionOrder</b> entity for the loaded navigation property
     * <b>to_BusinessSolutionOrder</b>.
     *
     * @param value
     *            New <b>BusinessSolutionOrder</b> entity.
     */
    public void setBusinessSolutionOrder( final BusinessSolutionOrder value )
    {
        toBusinessSolutionOrder = value;
    }

    /**
     * Fetches the <b>BusSolnOrdItmConfiguration</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_Configurations</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BusSolnOrdItmConfiguration</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusSolnOrdItmConfiguration> fetchConfigurations()
    {
        return fetchFieldAsList("to_Configurations", BusSolnOrdItmConfiguration.class);
    }

    /**
     * Retrieval of associated <b>BusSolnOrdItmConfiguration</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Configurations</b>.
     * <p>
     * If the navigation property <b>to_Configurations</b> of a queried <b>BusSolnOrdSrvcContractItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BusSolnOrdItmConfiguration</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusSolnOrdItmConfiguration> getConfigurationsOrFetch()
    {
        if( toConfigurations == null ) {
            toConfigurations = fetchConfigurations();
        }
        return toConfigurations;
    }

    /**
     * Retrieval of associated <b>BusSolnOrdItmConfiguration</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Configurations</b>.
     * <p>
     * If the navigation property for an entity <b>BusSolnOrdSrvcContractItem</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Configurations</b> is already loaded, the result will
     *         contain the <b>BusSolnOrdItmConfiguration</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BusSolnOrdItmConfiguration>> getConfigurationsIfPresent()
    {
        return Option.of(toConfigurations);
    }

    /**
     * Overwrites the list of associated <b>BusSolnOrdItmConfiguration</b> entities for the loaded navigation property
     * <b>to_Configurations</b>.
     * <p>
     * If the navigation property <b>to_Configurations</b> of a queried <b>BusSolnOrdSrvcContractItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BusSolnOrdItmConfiguration</b> entities.
     */
    public void setConfigurations( @Nonnull final List<BusSolnOrdItmConfiguration> value )
    {
        if( toConfigurations == null ) {
            toConfigurations = Lists.newArrayList();
        }
        toConfigurations.clear();
        toConfigurations.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BusSolnOrdItmConfiguration</b> entities. This corresponds to the OData
     * navigation property <b>to_Configurations</b>.
     * <p>
     * If the navigation property <b>to_Configurations</b> of a queried <b>BusSolnOrdSrvcContractItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BusSolnOrdItmConfiguration</b> entities.
     */
    public void addConfigurations( BusSolnOrdItmConfiguration... entity )
    {
        if( toConfigurations == null ) {
            toConfigurations = Lists.newArrayList();
        }
        toConfigurations.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>BusSolnOrderItemObjectList</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_ObjectList</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BusSolnOrderItemObjectList</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusSolnOrderItemObjectList> fetchObjectList()
    {
        return fetchFieldAsList("to_ObjectList", BusSolnOrderItemObjectList.class);
    }

    /**
     * Retrieval of associated <b>BusSolnOrderItemObjectList</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ObjectList</b>.
     * <p>
     * If the navigation property <b>to_ObjectList</b> of a queried <b>BusSolnOrdSrvcContractItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BusSolnOrderItemObjectList</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusSolnOrderItemObjectList> getObjectListOrFetch()
    {
        if( toObjectList == null ) {
            toObjectList = fetchObjectList();
        }
        return toObjectList;
    }

    /**
     * Retrieval of associated <b>BusSolnOrderItemObjectList</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ObjectList</b>.
     * <p>
     * If the navigation property for an entity <b>BusSolnOrdSrvcContractItem</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ObjectList</b> is already loaded, the result will
     *         contain the <b>BusSolnOrderItemObjectList</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BusSolnOrderItemObjectList>> getObjectListIfPresent()
    {
        return Option.of(toObjectList);
    }

    /**
     * Overwrites the list of associated <b>BusSolnOrderItemObjectList</b> entities for the loaded navigation property
     * <b>to_ObjectList</b>.
     * <p>
     * If the navigation property <b>to_ObjectList</b> of a queried <b>BusSolnOrdSrvcContractItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BusSolnOrderItemObjectList</b> entities.
     */
    public void setObjectList( @Nonnull final List<BusSolnOrderItemObjectList> value )
    {
        if( toObjectList == null ) {
            toObjectList = Lists.newArrayList();
        }
        toObjectList.clear();
        toObjectList.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BusSolnOrderItemObjectList</b> entities. This corresponds to the OData
     * navigation property <b>to_ObjectList</b>.
     * <p>
     * If the navigation property <b>to_ObjectList</b> of a queried <b>BusSolnOrdSrvcContractItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BusSolnOrderItemObjectList</b> entities.
     */
    public void addObjectList( BusSolnOrderItemObjectList... entity )
    {
        if( toObjectList == null ) {
            toObjectList = Lists.newArrayList();
        }
        toObjectList.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>BusSolnOrderItemPriceElement</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_PriceElement</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BusSolnOrderItemPriceElement</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusSolnOrderItemPriceElement> fetchPriceElement()
    {
        return fetchFieldAsList("to_PriceElement", BusSolnOrderItemPriceElement.class);
    }

    /**
     * Retrieval of associated <b>BusSolnOrderItemPriceElement</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PriceElement</b>.
     * <p>
     * If the navigation property <b>to_PriceElement</b> of a queried <b>BusSolnOrdSrvcContractItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BusSolnOrderItemPriceElement</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusSolnOrderItemPriceElement> getPriceElementOrFetch()
    {
        if( toPriceElement == null ) {
            toPriceElement = fetchPriceElement();
        }
        return toPriceElement;
    }

    /**
     * Retrieval of associated <b>BusSolnOrderItemPriceElement</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PriceElement</b>.
     * <p>
     * If the navigation property for an entity <b>BusSolnOrdSrvcContractItem</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_PriceElement</b> is already loaded, the result will
     *         contain the <b>BusSolnOrderItemPriceElement</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BusSolnOrderItemPriceElement>> getPriceElementIfPresent()
    {
        return Option.of(toPriceElement);
    }

    /**
     * Overwrites the list of associated <b>BusSolnOrderItemPriceElement</b> entities for the loaded navigation property
     * <b>to_PriceElement</b>.
     * <p>
     * If the navigation property <b>to_PriceElement</b> of a queried <b>BusSolnOrdSrvcContractItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BusSolnOrderItemPriceElement</b> entities.
     */
    public void setPriceElement( @Nonnull final List<BusSolnOrderItemPriceElement> value )
    {
        if( toPriceElement == null ) {
            toPriceElement = Lists.newArrayList();
        }
        toPriceElement.clear();
        toPriceElement.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BusSolnOrderItemPriceElement</b> entities. This corresponds to the
     * OData navigation property <b>to_PriceElement</b>.
     * <p>
     * If the navigation property <b>to_PriceElement</b> of a queried <b>BusSolnOrdSrvcContractItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BusSolnOrderItemPriceElement</b> entities.
     */
    public void addPriceElement( BusSolnOrderItemPriceElement... entity )
    {
        if( toPriceElement == null ) {
            toPriceElement = Lists.newArrayList();
        }
        toPriceElement.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>BusSolnOrderItemProductList</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_ProductList</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BusSolnOrderItemProductList</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusSolnOrderItemProductList> fetchProductList()
    {
        return fetchFieldAsList("to_ProductList", BusSolnOrderItemProductList.class);
    }

    /**
     * Retrieval of associated <b>BusSolnOrderItemProductList</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ProductList</b>.
     * <p>
     * If the navigation property <b>to_ProductList</b> of a queried <b>BusSolnOrdSrvcContractItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BusSolnOrderItemProductList</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusSolnOrderItemProductList> getProductListOrFetch()
    {
        if( toProductList == null ) {
            toProductList = fetchProductList();
        }
        return toProductList;
    }

    /**
     * Retrieval of associated <b>BusSolnOrderItemProductList</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ProductList</b>.
     * <p>
     * If the navigation property for an entity <b>BusSolnOrdSrvcContractItem</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ProductList</b> is already loaded, the result will
     *         contain the <b>BusSolnOrderItemProductList</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BusSolnOrderItemProductList>> getProductListIfPresent()
    {
        return Option.of(toProductList);
    }

    /**
     * Overwrites the list of associated <b>BusSolnOrderItemProductList</b> entities for the loaded navigation property
     * <b>to_ProductList</b>.
     * <p>
     * If the navigation property <b>to_ProductList</b> of a queried <b>BusSolnOrdSrvcContractItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BusSolnOrderItemProductList</b> entities.
     */
    public void setProductList( @Nonnull final List<BusSolnOrderItemProductList> value )
    {
        if( toProductList == null ) {
            toProductList = Lists.newArrayList();
        }
        toProductList.clear();
        toProductList.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BusSolnOrderItemProductList</b> entities. This corresponds to the
     * OData navigation property <b>to_ProductList</b>.
     * <p>
     * If the navigation property <b>to_ProductList</b> of a queried <b>BusSolnOrdSrvcContractItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BusSolnOrderItemProductList</b> entities.
     */
    public void addProductList( BusSolnOrderItemProductList... entity )
    {
        if( toProductList == null ) {
            toProductList = Lists.newArrayList();
        }
        toProductList.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>BusSolnOrdItmFUPSrvcContr</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_ServiceContract</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BusSolnOrdItmFUPSrvcContr</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusSolnOrdItmFUPSrvcContr> fetchServiceContract()
    {
        return fetchFieldAsList("to_ServiceContract", BusSolnOrdItmFUPSrvcContr.class);
    }

    /**
     * Retrieval of associated <b>BusSolnOrdItmFUPSrvcContr</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ServiceContract</b>.
     * <p>
     * If the navigation property <b>to_ServiceContract</b> of a queried <b>BusSolnOrdSrvcContractItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BusSolnOrdItmFUPSrvcContr</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusSolnOrdItmFUPSrvcContr> getServiceContractOrFetch()
    {
        if( toServiceContract == null ) {
            toServiceContract = fetchServiceContract();
        }
        return toServiceContract;
    }

    /**
     * Retrieval of associated <b>BusSolnOrdItmFUPSrvcContr</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ServiceContract</b>.
     * <p>
     * If the navigation property for an entity <b>BusSolnOrdSrvcContractItem</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ServiceContract</b> is already loaded, the result will
     *         contain the <b>BusSolnOrdItmFUPSrvcContr</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BusSolnOrdItmFUPSrvcContr>> getServiceContractIfPresent()
    {
        return Option.of(toServiceContract);
    }

    /**
     * Overwrites the list of associated <b>BusSolnOrdItmFUPSrvcContr</b> entities for the loaded navigation property
     * <b>to_ServiceContract</b>.
     * <p>
     * If the navigation property <b>to_ServiceContract</b> of a queried <b>BusSolnOrdSrvcContractItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BusSolnOrdItmFUPSrvcContr</b> entities.
     */
    public void setServiceContract( @Nonnull final List<BusSolnOrdItmFUPSrvcContr> value )
    {
        if( toServiceContract == null ) {
            toServiceContract = Lists.newArrayList();
        }
        toServiceContract.clear();
        toServiceContract.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BusSolnOrdItmFUPSrvcContr</b> entities. This corresponds to the OData
     * navigation property <b>to_ServiceContract</b>.
     * <p>
     * If the navigation property <b>to_ServiceContract</b> of a queried <b>BusSolnOrdSrvcContractItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BusSolnOrdItmFUPSrvcContr</b> entities.
     */
    public void addServiceContract( BusSolnOrdItmFUPSrvcContr... entity )
    {
        if( toServiceContract == null ) {
            toServiceContract = Lists.newArrayList();
        }
        toServiceContract.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>BusSolutionOrderItemText</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_Text</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BusSolutionOrderItemText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusSolutionOrderItemText> fetchText()
    {
        return fetchFieldAsList("to_Text", BusSolutionOrderItemText.class);
    }

    /**
     * Retrieval of associated <b>BusSolutionOrderItemText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>BusSolnOrdSrvcContractItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BusSolutionOrderItemText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusSolutionOrderItemText> getTextOrFetch()
    {
        if( toText == null ) {
            toText = fetchText();
        }
        return toText;
    }

    /**
     * Retrieval of associated <b>BusSolutionOrderItemText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property for an entity <b>BusSolnOrdSrvcContractItem</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Text</b> is already loaded, the result will contain the
     *         <b>BusSolutionOrderItemText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BusSolutionOrderItemText>> getTextIfPresent()
    {
        return Option.of(toText);
    }

    /**
     * Overwrites the list of associated <b>BusSolutionOrderItemText</b> entities for the loaded navigation property
     * <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>BusSolnOrdSrvcContractItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BusSolutionOrderItemText</b> entities.
     */
    public void setText( @Nonnull final List<BusSolutionOrderItemText> value )
    {
        if( toText == null ) {
            toText = Lists.newArrayList();
        }
        toText.clear();
        toText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BusSolutionOrderItemText</b> entities. This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>BusSolnOrdSrvcContractItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BusSolutionOrderItemText</b> entities.
     */
    public void addText( BusSolutionOrderItemText... entity )
    {
        if( toText == null ) {
            toText = Lists.newArrayList();
        }
        toText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>BusSolnOrdItmUserStatus</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_UserStatus</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BusSolnOrdItmUserStatus</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusSolnOrdItmUserStatus> fetchUserStatus()
    {
        return fetchFieldAsList("to_UserStatus", BusSolnOrdItmUserStatus.class);
    }

    /**
     * Retrieval of associated <b>BusSolnOrdItmUserStatus</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_UserStatus</b>.
     * <p>
     * If the navigation property <b>to_UserStatus</b> of a queried <b>BusSolnOrdSrvcContractItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BusSolnOrdItmUserStatus</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusSolnOrdItmUserStatus> getUserStatusOrFetch()
    {
        if( toUserStatus == null ) {
            toUserStatus = fetchUserStatus();
        }
        return toUserStatus;
    }

    /**
     * Retrieval of associated <b>BusSolnOrdItmUserStatus</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_UserStatus</b>.
     * <p>
     * If the navigation property for an entity <b>BusSolnOrdSrvcContractItem</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_UserStatus</b> is already loaded, the result will
     *         contain the <b>BusSolnOrdItmUserStatus</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BusSolnOrdItmUserStatus>> getUserStatusIfPresent()
    {
        return Option.of(toUserStatus);
    }

    /**
     * Overwrites the list of associated <b>BusSolnOrdItmUserStatus</b> entities for the loaded navigation property
     * <b>to_UserStatus</b>.
     * <p>
     * If the navigation property <b>to_UserStatus</b> of a queried <b>BusSolnOrdSrvcContractItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BusSolnOrdItmUserStatus</b> entities.
     */
    public void setUserStatus( @Nonnull final List<BusSolnOrdItmUserStatus> value )
    {
        if( toUserStatus == null ) {
            toUserStatus = Lists.newArrayList();
        }
        toUserStatus.clear();
        toUserStatus.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BusSolnOrdItmUserStatus</b> entities. This corresponds to the OData
     * navigation property <b>to_UserStatus</b>.
     * <p>
     * If the navigation property <b>to_UserStatus</b> of a queried <b>BusSolnOrdSrvcContractItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BusSolnOrdItmUserStatus</b> entities.
     */
    public void addUserStatus( BusSolnOrdItmUserStatus... entity )
    {
        if( toUserStatus == null ) {
            toUserStatus = Lists.newArrayList();
        }
        toUserStatus.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of BusSolnOrdSrvcContractItem instances.
     *
     */
    public final static class BusSolnOrdSrvcContractItemBuilder
    {

        private List<BSOrdSrvcContrItmBillgReqItm> toBillingRequestItem = Lists.newArrayList();
        private BusinessSolutionOrder toBusinessSolutionOrder;
        private String businessSolutionOrder = null;
        private List<BusSolnOrdItmConfiguration> toConfigurations = Lists.newArrayList();
        private List<BusSolnOrderItemObjectList> toObjectList = Lists.newArrayList();
        private List<BusSolnOrderItemPriceElement> toPriceElement = Lists.newArrayList();
        private List<BusSolnOrderItemProductList> toProductList = Lists.newArrayList();
        private List<BusSolnOrdItmFUPSrvcContr> toServiceContract = Lists.newArrayList();
        private List<BusSolutionOrderItemText> toText = Lists.newArrayList();
        private List<BusSolnOrdItmUserStatus> toUserStatus = Lists.newArrayList();

        private BusSolnOrdSrvcContractItem.BusSolnOrdSrvcContractItemBuilder toBillingRequestItem(
            final List<BSOrdSrvcContrItmBillgReqItm> value )
        {
            toBillingRequestItem.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_BillingRequestItem</b> for <b>BusSolnOrdSrvcContractItem</b> to multiple
         * <b>BSOrdSrvcContrItmBillgReqItm</b>.
         *
         * @param value
         *            The BSOrdSrvcContrItmBillgReqItms to build this BusSolnOrdSrvcContractItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusSolnOrdSrvcContractItem.BusSolnOrdSrvcContractItemBuilder billingRequestItem(
            BSOrdSrvcContrItmBillgReqItm... value )
        {
            return toBillingRequestItem(Lists.newArrayList(value));
        }

        private BusSolnOrdSrvcContractItem.BusSolnOrdSrvcContractItemBuilder toBusinessSolutionOrder(
            final BusinessSolutionOrder value )
        {
            toBusinessSolutionOrder = value;
            return this;
        }

        /**
         * Navigation property <b>to_BusinessSolutionOrder</b> for <b>BusSolnOrdSrvcContractItem</b> to single
         * <b>BusinessSolutionOrder</b>.
         *
         * @param value
         *            The BusinessSolutionOrder to build this BusSolnOrdSrvcContractItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusSolnOrdSrvcContractItem.BusSolnOrdSrvcContractItemBuilder businessSolutionOrder(
            final BusinessSolutionOrder value )
        {
            return toBusinessSolutionOrder(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 10
         * <p>
         * Original property name from the Odata EDM: <b>BusinessSolutionOrder</b>
         * </p>
         *
         * @param value
         *            The businessSolutionOrder to build this BusSolnOrdSrvcContractItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusSolnOrdSrvcContractItem.BusSolnOrdSrvcContractItemBuilder businessSolutionOrder( final String value )
        {
            businessSolutionOrder = value;
            return this;
        }

        private BusSolnOrdSrvcContractItem.BusSolnOrdSrvcContractItemBuilder toConfigurations(
            final List<BusSolnOrdItmConfiguration> value )
        {
            toConfigurations.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Configurations</b> for <b>BusSolnOrdSrvcContractItem</b> to multiple
         * <b>BusSolnOrdItmConfiguration</b>.
         *
         * @param value
         *            The BusSolnOrdItmConfigurations to build this BusSolnOrdSrvcContractItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusSolnOrdSrvcContractItem.BusSolnOrdSrvcContractItemBuilder configurations(
            BusSolnOrdItmConfiguration... value )
        {
            return toConfigurations(Lists.newArrayList(value));
        }

        private BusSolnOrdSrvcContractItem.BusSolnOrdSrvcContractItemBuilder toObjectList(
            final List<BusSolnOrderItemObjectList> value )
        {
            toObjectList.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ObjectList</b> for <b>BusSolnOrdSrvcContractItem</b> to multiple
         * <b>BusSolnOrderItemObjectList</b>.
         *
         * @param value
         *            The BusSolnOrderItemObjectLists to build this BusSolnOrdSrvcContractItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusSolnOrdSrvcContractItem.BusSolnOrdSrvcContractItemBuilder objectList(
            BusSolnOrderItemObjectList... value )
        {
            return toObjectList(Lists.newArrayList(value));
        }

        private BusSolnOrdSrvcContractItem.BusSolnOrdSrvcContractItemBuilder toPriceElement(
            final List<BusSolnOrderItemPriceElement> value )
        {
            toPriceElement.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_PriceElement</b> for <b>BusSolnOrdSrvcContractItem</b> to multiple
         * <b>BusSolnOrderItemPriceElement</b>.
         *
         * @param value
         *            The BusSolnOrderItemPriceElements to build this BusSolnOrdSrvcContractItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusSolnOrdSrvcContractItem.BusSolnOrdSrvcContractItemBuilder priceElement(
            BusSolnOrderItemPriceElement... value )
        {
            return toPriceElement(Lists.newArrayList(value));
        }

        private BusSolnOrdSrvcContractItem.BusSolnOrdSrvcContractItemBuilder toProductList(
            final List<BusSolnOrderItemProductList> value )
        {
            toProductList.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ProductList</b> for <b>BusSolnOrdSrvcContractItem</b> to multiple
         * <b>BusSolnOrderItemProductList</b>.
         *
         * @param value
         *            The BusSolnOrderItemProductLists to build this BusSolnOrdSrvcContractItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusSolnOrdSrvcContractItem.BusSolnOrdSrvcContractItemBuilder productList(
            BusSolnOrderItemProductList... value )
        {
            return toProductList(Lists.newArrayList(value));
        }

        private BusSolnOrdSrvcContractItem.BusSolnOrdSrvcContractItemBuilder toServiceContract(
            final List<BusSolnOrdItmFUPSrvcContr> value )
        {
            toServiceContract.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ServiceContract</b> for <b>BusSolnOrdSrvcContractItem</b> to multiple
         * <b>BusSolnOrdItmFUPSrvcContr</b>.
         *
         * @param value
         *            The BusSolnOrdItmFUPSrvcContrs to build this BusSolnOrdSrvcContractItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusSolnOrdSrvcContractItem.BusSolnOrdSrvcContractItemBuilder serviceContract(
            BusSolnOrdItmFUPSrvcContr... value )
        {
            return toServiceContract(Lists.newArrayList(value));
        }

        private BusSolnOrdSrvcContractItem.BusSolnOrdSrvcContractItemBuilder toText(
            final List<BusSolutionOrderItemText> value )
        {
            toText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Text</b> for <b>BusSolnOrdSrvcContractItem</b> to multiple
         * <b>BusSolutionOrderItemText</b>.
         *
         * @param value
         *            The BusSolutionOrderItemTexts to build this BusSolnOrdSrvcContractItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusSolnOrdSrvcContractItem.BusSolnOrdSrvcContractItemBuilder text( BusSolutionOrderItemText... value )
        {
            return toText(Lists.newArrayList(value));
        }

        private BusSolnOrdSrvcContractItem.BusSolnOrdSrvcContractItemBuilder toUserStatus(
            final List<BusSolnOrdItmUserStatus> value )
        {
            toUserStatus.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_UserStatus</b> for <b>BusSolnOrdSrvcContractItem</b> to multiple
         * <b>BusSolnOrdItmUserStatus</b>.
         *
         * @param value
         *            The BusSolnOrdItmUserStatuss to build this BusSolnOrdSrvcContractItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusSolnOrdSrvcContractItem.BusSolnOrdSrvcContractItemBuilder userStatus(
            BusSolnOrdItmUserStatus... value )
        {
            return toUserStatus(Lists.newArrayList(value));
        }

    }

}
