/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder;

import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.field.BusSolnOrdSubscrpnBillgItemField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.link.BusSolnOrdSubscrpnBillgItemLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.link.BusSolnOrdSubscrpnBillgItemOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.selectable.BusSolnOrdSubscrpnBillgItemSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Subscription Billing Item
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_BusSolnOrdSubscrpnBillgItemType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BusSolnOrdSubscrpnBillgItem extends VdmEntity<BusSolnOrdSubscrpnBillgItem>
{

    /**
     * Selector for all available fields of BusSolnOrdSubscrpnBillgItem.
     *
     */
    public final static BusSolnOrdSubscrpnBillgItemSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BusinessSolutionOrder</b>
     * </p>
     *
     * @return Transaction ID
     */
    @Key
    @SerializedName( "BusinessSolutionOrder" )
    @JsonProperty( "BusinessSolutionOrder" )
    @Nullable
    @ODataField( odataName = "BusinessSolutionOrder" )
    private String businessSolutionOrder;
    /**
     * Use with available fluent helpers to apply the <b>BusinessSolutionOrder</b> field to query operations.
     *
     */
    public final static BusSolnOrdSubscrpnBillgItemField<String> BUSINESS_SOLUTION_ORDER =
        new BusSolnOrdSubscrpnBillgItemField<String>("BusinessSolutionOrder");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BusinessSolutionOrderItem</b>
     * </p>
     *
     * @return Shortened Item Number in Document
     */
    @Key
    @SerializedName( "BusinessSolutionOrderItem" )
    @JsonProperty( "BusinessSolutionOrderItem" )
    @Nullable
    @ODataField( odataName = "BusinessSolutionOrderItem" )
    private String businessSolutionOrderItem;
    /**
     * Use with available fluent helpers to apply the <b>BusinessSolutionOrderItem</b> field to query operations.
     *
     */
    public final static BusSolnOrdSubscrpnBillgItemField<String> BUSINESS_SOLUTION_ORDER_ITEM =
        new BusSolnOrdSubscrpnBillgItemField<String>("BusinessSolutionOrderItem");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BusinessSolutionOrderItemUUID</b>
     * </p>
     *
     * @return GUID of a CRM Order Object
     */
    @SerializedName( "BusinessSolutionOrderItemUUID" )
    @JsonProperty( "BusinessSolutionOrderItemUUID" )
    @Nullable
    @ODataField( odataName = "BusinessSolutionOrderItemUUID" )
    private UUID businessSolutionOrderItemUUID;
    /**
     * Use with available fluent helpers to apply the <b>BusinessSolutionOrderItemUUID</b> field to query operations.
     *
     */
    public final static BusSolnOrdSubscrpnBillgItemField<UUID> BUSINESS_SOLUTION_ORDER_ITEM_UUID =
        new BusSolnOrdSubscrpnBillgItemField<UUID>("BusinessSolutionOrderItemUUID");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmCategory</b>
     * </p>
     *
     * @return Item Category
     */
    @SerializedName( "BusSolnOrdItmCategory" )
    @JsonProperty( "BusSolnOrdItmCategory" )
    @Nullable
    @ODataField( odataName = "BusSolnOrdItmCategory" )
    private String busSolnOrdItmCategory;
    /**
     * Use with available fluent helpers to apply the <b>BusSolnOrdItmCategory</b> field to query operations.
     *
     */
    public final static BusSolnOrdSubscrpnBillgItemField<String> BUS_SOLN_ORD_ITM_CATEGORY =
        new BusSolnOrdSubscrpnBillgItemField<String>("BusSolnOrdItmCategory");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @return Product Number
     */
    @SerializedName( "Product" )
    @JsonProperty( "Product" )
    @Nullable
    @ODataField( odataName = "Product" )
    private String product;
    /**
     * Use with available fluent helpers to apply the <b>Product</b> field to query operations.
     *
     */
    public final static BusSolnOrdSubscrpnBillgItemField<String> PRODUCT =
        new BusSolnOrdSubscrpnBillgItemField<String>("Product");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Quantity</b>
     * </p>
     *
     * @return CRM: Order Quantity
     */
    @SerializedName( "Quantity" )
    @JsonProperty( "Quantity" )
    @Nullable
    @ODataField( odataName = "Quantity" )
    private BigDecimal quantity;
    /**
     * Use with available fluent helpers to apply the <b>Quantity</b> field to query operations.
     *
     */
    public final static BusSolnOrdSubscrpnBillgItemField<BigDecimal> QUANTITY =
        new BusSolnOrdSubscrpnBillgItemField<BigDecimal>("Quantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>QuantityUnit</b>
     * </p>
     *
     * @return Unit of Measure in Which the Product Is Sold
     */
    @SerializedName( "QuantityUnit" )
    @JsonProperty( "QuantityUnit" )
    @Nullable
    @ODataField( odataName = "QuantityUnit" )
    private String quantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>QuantityUnit</b> field to query operations.
     *
     */
    public final static BusSolnOrdSubscrpnBillgItemField<String> QUANTITY_UNIT =
        new BusSolnOrdSubscrpnBillgItemField<String>("QuantityUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmQtyUnitSAPCode</b>
     * </p>
     *
     * @return SAP Unit Code for Order Quantity
     */
    @SerializedName( "BusSolnOrdItmQtyUnitSAPCode" )
    @JsonProperty( "BusSolnOrdItmQtyUnitSAPCode" )
    @Nullable
    @ODataField( odataName = "BusSolnOrdItmQtyUnitSAPCode" )
    private String busSolnOrdItmQtyUnitSAPCode;
    /**
     * Use with available fluent helpers to apply the <b>BusSolnOrdItmQtyUnitSAPCode</b> field to query operations.
     *
     */
    public final static BusSolnOrdSubscrpnBillgItemField<String> BUS_SOLN_ORD_ITM_QTY_UNIT_SAP_CODE =
        new BusSolnOrdSubscrpnBillgItemField<String>("BusSolnOrdItmQtyUnitSAPCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmQtyUnitISOCode</b>
     * </p>
     *
     * @return ISO Unit Code for Order Quantity
     */
    @SerializedName( "BusSolnOrdItmQtyUnitISOCode" )
    @JsonProperty( "BusSolnOrdItmQtyUnitISOCode" )
    @Nullable
    @ODataField( odataName = "BusSolnOrdItmQtyUnitISOCode" )
    private String busSolnOrdItmQtyUnitISOCode;
    /**
     * Use with available fluent helpers to apply the <b>BusSolnOrdItmQtyUnitISOCode</b> field to query operations.
     *
     */
    public final static BusSolnOrdSubscrpnBillgItemField<String> BUS_SOLN_ORD_ITM_QTY_UNIT_ISO_CODE =
        new BusSolnOrdSubscrpnBillgItemField<String>("BusSolnOrdItmQtyUnitISOCode");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmDescription</b>
     * </p>
     *
     * @return Product Description
     */
    @SerializedName( "BusSolnOrdItmDescription" )
    @JsonProperty( "BusSolnOrdItmDescription" )
    @Nullable
    @ODataField( odataName = "BusSolnOrdItmDescription" )
    private String busSolnOrdItmDescription;
    /**
     * Use with available fluent helpers to apply the <b>BusSolnOrdItmDescription</b> field to query operations.
     *
     */
    public final static BusSolnOrdSubscrpnBillgItemField<String> BUS_SOLN_ORD_ITM_DESCRIPTION =
        new BusSolnOrdSubscrpnBillgItemField<String>("BusSolnOrdItmDescription");
    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmExtReference</b>
     * </p>
     *
     * @return External Reference Number
     */
    @SerializedName( "BusSolnOrdItmExtReference" )
    @JsonProperty( "BusSolnOrdItmExtReference" )
    @Nullable
    @ODataField( odataName = "BusSolnOrdItmExtReference" )
    private String busSolnOrdItmExtReference;
    /**
     * Use with available fluent helpers to apply the <b>BusSolnOrdItmExtReference</b> field to query operations.
     *
     */
    public final static BusSolnOrdSubscrpnBillgItemField<String> BUS_SOLN_ORD_ITM_EXT_REFERENCE =
        new BusSolnOrdSubscrpnBillgItemField<String>("BusSolnOrdItmExtReference");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocumentItemNetAmount</b>
     * </p>
     *
     * @return Net Value
     */
    @SerializedName( "ServiceDocumentItemNetAmount" )
    @JsonProperty( "ServiceDocumentItemNetAmount" )
    @Nullable
    @ODataField( odataName = "ServiceDocumentItemNetAmount" )
    private BigDecimal serviceDocumentItemNetAmount;
    /**
     * Use with available fluent helpers to apply the <b>ServiceDocumentItemNetAmount</b> field to query operations.
     *
     */
    public final static BusSolnOrdSubscrpnBillgItemField<BigDecimal> SERVICE_DOCUMENT_ITEM_NET_AMOUNT =
        new BusSolnOrdSubscrpnBillgItemField<BigDecimal>("ServiceDocumentItemNetAmount");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @return Currency
     */
    @SerializedName( "TransactionCurrency" )
    @JsonProperty( "TransactionCurrency" )
    @Nullable
    @ODataField( odataName = "TransactionCurrency" )
    private String transactionCurrency;
    /**
     * Use with available fluent helpers to apply the <b>TransactionCurrency</b> field to query operations.
     *
     */
    public final static BusSolnOrdSubscrpnBillgItemField<String> TRANSACTION_CURRENCY =
        new BusSolnOrdSubscrpnBillgItemField<String>("TransactionCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Short Text Language for an Item
     */
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static BusSolnOrdSubscrpnBillgItemField<String> LANGUAGE =
        new BusSolnOrdSubscrpnBillgItemField<String>("Language");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmIsCompleted</b>
     * </p>
     *
     * @return The busSolnOrdItmIsCompleted contained in this entity.
     */
    @SerializedName( "BusSolnOrdItmIsCompleted" )
    @JsonProperty( "BusSolnOrdItmIsCompleted" )
    @Nullable
    @ODataField( odataName = "BusSolnOrdItmIsCompleted" )
    private String busSolnOrdItmIsCompleted;
    /**
     * Use with available fluent helpers to apply the <b>BusSolnOrdItmIsCompleted</b> field to query operations.
     *
     */
    public final static BusSolnOrdSubscrpnBillgItemField<String> BUS_SOLN_ORD_ITM_IS_COMPLETED =
        new BusSolnOrdSubscrpnBillgItemField<String>("BusSolnOrdItmIsCompleted");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmIsReleased</b>
     * </p>
     *
     * @return Release Status
     */
    @SerializedName( "BusSolnOrdItmIsReleased" )
    @JsonProperty( "BusSolnOrdItmIsReleased" )
    @Nullable
    @ODataField( odataName = "BusSolnOrdItmIsReleased" )
    private String busSolnOrdItmIsReleased;
    /**
     * Use with available fluent helpers to apply the <b>BusSolnOrdItmIsReleased</b> field to query operations.
     *
     */
    public final static BusSolnOrdSubscrpnBillgItemField<String> BUS_SOLN_ORD_ITM_IS_RELEASED =
        new BusSolnOrdSubscrpnBillgItemField<String>("BusSolnOrdItmIsReleased");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmDistrStatus</b>
     * </p>
     *
     * @return The busSolnOrdItmDistrStatus contained in this entity.
     */
    @SerializedName( "BusSolnOrdItmDistrStatus" )
    @JsonProperty( "BusSolnOrdItmDistrStatus" )
    @Nullable
    @ODataField( odataName = "BusSolnOrdItmDistrStatus" )
    private String busSolnOrdItmDistrStatus;
    /**
     * Use with available fluent helpers to apply the <b>BusSolnOrdItmDistrStatus</b> field to query operations.
     *
     */
    public final static BusSolnOrdSubscrpnBillgItemField<String> BUS_SOLN_ORD_ITM_DISTR_STATUS =
        new BusSolnOrdSubscrpnBillgItemField<String>("BusSolnOrdItmDistrStatus");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmDistrStatusName</b>
     * </p>
     *
     * @return The busSolnOrdItmDistrStatusName contained in this entity.
     */
    @SerializedName( "BusSolnOrdItmDistrStatusName" )
    @JsonProperty( "BusSolnOrdItmDistrStatusName" )
    @Nullable
    @ODataField( odataName = "BusSolnOrdItmDistrStatusName" )
    private String busSolnOrdItmDistrStatusName;
    /**
     * Use with available fluent helpers to apply the <b>BusSolnOrdItmDistrStatusName</b> field to query operations.
     *
     */
    public final static BusSolnOrdSubscrpnBillgItemField<String> BUS_SOLN_ORD_ITM_DISTR_STATUS_NAME =
        new BusSolnOrdSubscrpnBillgItemField<String>("BusSolnOrdItmDistrStatusName");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SubscrpnSimulationStatus</b>
     * </p>
     *
     * @return The subscrpnSimulationStatus contained in this entity.
     */
    @SerializedName( "SubscrpnSimulationStatus" )
    @JsonProperty( "SubscrpnSimulationStatus" )
    @Nullable
    @ODataField( odataName = "SubscrpnSimulationStatus" )
    private String subscrpnSimulationStatus;
    /**
     * Use with available fluent helpers to apply the <b>SubscrpnSimulationStatus</b> field to query operations.
     *
     */
    public final static BusSolnOrdSubscrpnBillgItemField<String> SUBSCRPN_SIMULATION_STATUS =
        new BusSolnOrdSubscrpnBillgItemField<String>("SubscrpnSimulationStatus");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>SubscrpnSimulationStatusName</b>
     * </p>
     *
     * @return The subscrpnSimulationStatusName contained in this entity.
     */
    @SerializedName( "SubscrpnSimulationStatusName" )
    @JsonProperty( "SubscrpnSimulationStatusName" )
    @Nullable
    @ODataField( odataName = "SubscrpnSimulationStatusName" )
    private String subscrpnSimulationStatusName;
    /**
     * Use with available fluent helpers to apply the <b>SubscrpnSimulationStatusName</b> field to query operations.
     *
     */
    public final static BusSolnOrdSubscrpnBillgItemField<String> SUBSCRPN_SIMULATION_STATUS_NAME =
        new BusSolnOrdSubscrpnBillgItemField<String>("SubscrpnSimulationStatusName");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SubscriptionStartDateTime</b>
     * </p>
     *
     * @return Contract Start date
     */
    @SerializedName( "SubscriptionStartDateTime" )
    @JsonProperty( "SubscriptionStartDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "SubscriptionStartDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime subscriptionStartDateTime;
    /**
     * Use with available fluent helpers to apply the <b>SubscriptionStartDateTime</b> field to query operations.
     *
     */
    public final static BusSolnOrdSubscrpnBillgItemField<ZonedDateTime> SUBSCRIPTION_START_DATE_TIME =
        new BusSolnOrdSubscrpnBillgItemField<ZonedDateTime>("SubscriptionStartDateTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SubscriptionEndDateTime</b>
     * </p>
     *
     * @return Contract End Date
     */
    @SerializedName( "SubscriptionEndDateTime" )
    @JsonProperty( "SubscriptionEndDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "SubscriptionEndDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime subscriptionEndDateTime;
    /**
     * Use with available fluent helpers to apply the <b>SubscriptionEndDateTime</b> field to query operations.
     *
     */
    public final static BusSolnOrdSubscrpnBillgItemField<ZonedDateTime> SUBSCRIPTION_END_DATE_TIME =
        new BusSolnOrdSubscrpnBillgItemField<ZonedDateTime>("SubscriptionEndDateTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SubscrpnBillgItmPrcgDateTime</b>
     * </p>
     *
     * @return Time Stamp (UTC) of Start Time of Appointment
     */
    @SerializedName( "SubscrpnBillgItmPrcgDateTime" )
    @JsonProperty( "SubscrpnBillgItmPrcgDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "SubscrpnBillgItmPrcgDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime subscrpnBillgItmPrcgDateTime;
    /**
     * Use with available fluent helpers to apply the <b>SubscrpnBillgItmPrcgDateTime</b> field to query operations.
     *
     */
    public final static BusSolnOrdSubscrpnBillgItemField<ZonedDateTime> SUBSCRPN_BILLG_ITM_PRCG_DATE_TIME =
        new BusSolnOrdSubscrpnBillgItemField<ZonedDateTime>("SubscrpnBillgItmPrcgDateTime");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>SubscrpnWithdrawalPeriod</b>
     * </p>
     *
     * @return The subscrpnWithdrawalPeriod contained in this entity.
     */
    @SerializedName( "SubscrpnWithdrawalPeriod" )
    @JsonProperty( "SubscrpnWithdrawalPeriod" )
    @Nullable
    @ODataField( odataName = "SubscrpnWithdrawalPeriod" )
    private BigDecimal subscrpnWithdrawalPeriod;
    /**
     * Use with available fluent helpers to apply the <b>SubscrpnWithdrawalPeriod</b> field to query operations.
     *
     */
    public final static BusSolnOrdSubscrpnBillgItemField<BigDecimal> SUBSCRPN_WITHDRAWAL_PERIOD =
        new BusSolnOrdSubscrpnBillgItemField<BigDecimal>("SubscrpnWithdrawalPeriod");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>SubscriptionFixedTerm</b>
     * </p>
     *
     * @return The subscriptionFixedTerm contained in this entity.
     */
    @SerializedName( "SubscriptionFixedTerm" )
    @JsonProperty( "SubscriptionFixedTerm" )
    @Nullable
    @ODataField( odataName = "SubscriptionFixedTerm" )
    private BigDecimal subscriptionFixedTerm;
    /**
     * Use with available fluent helpers to apply the <b>SubscriptionFixedTerm</b> field to query operations.
     *
     */
    public final static BusSolnOrdSubscrpnBillgItemField<BigDecimal> SUBSCRIPTION_FIXED_TERM =
        new BusSolnOrdSubscrpnBillgItemField<BigDecimal>("SubscriptionFixedTerm");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>SubscriptionTermOfNotice</b>
     * </p>
     *
     * @return The subscriptionTermOfNotice contained in this entity.
     */
    @SerializedName( "SubscriptionTermOfNotice" )
    @JsonProperty( "SubscriptionTermOfNotice" )
    @Nullable
    @ODataField( odataName = "SubscriptionTermOfNotice" )
    private BigDecimal subscriptionTermOfNotice;
    /**
     * Use with available fluent helpers to apply the <b>SubscriptionTermOfNotice</b> field to query operations.
     *
     */
    public final static BusSolnOrdSubscrpnBillgItemField<BigDecimal> SUBSCRIPTION_TERM_OF_NOTICE =
        new BusSolnOrdSubscrpnBillgItemField<BigDecimal>("SubscriptionTermOfNotice");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>SubscriptionMinimumTerm</b>
     * </p>
     *
     * @return The subscriptionMinimumTerm contained in this entity.
     */
    @SerializedName( "SubscriptionMinimumTerm" )
    @JsonProperty( "SubscriptionMinimumTerm" )
    @Nullable
    @ODataField( odataName = "SubscriptionMinimumTerm" )
    private BigDecimal subscriptionMinimumTerm;
    /**
     * Use with available fluent helpers to apply the <b>SubscriptionMinimumTerm</b> field to query operations.
     *
     */
    public final static BusSolnOrdSubscrpnBillgItemField<BigDecimal> SUBSCRIPTION_MINIMUM_TERM =
        new BusSolnOrdSubscrpnBillgItemField<BigDecimal>("SubscriptionMinimumTerm");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>SubscriptionRenewalPeriod</b>
     * </p>
     *
     * @return The subscriptionRenewalPeriod contained in this entity.
     */
    @SerializedName( "SubscriptionRenewalPeriod" )
    @JsonProperty( "SubscriptionRenewalPeriod" )
    @Nullable
    @ODataField( odataName = "SubscriptionRenewalPeriod" )
    private BigDecimal subscriptionRenewalPeriod;
    /**
     * Use with available fluent helpers to apply the <b>SubscriptionRenewalPeriod</b> field to query operations.
     *
     */
    public final static BusSolnOrdSubscrpnBillgItemField<BigDecimal> SUBSCRIPTION_RENEWAL_PERIOD =
        new BusSolnOrdSubscrpnBillgItemField<BigDecimal>("SubscriptionRenewalPeriod");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>SubscriptionExpectedTerm</b>
     * </p>
     *
     * @return The subscriptionExpectedTerm contained in this entity.
     */
    @SerializedName( "SubscriptionExpectedTerm" )
    @JsonProperty( "SubscriptionExpectedTerm" )
    @Nullable
    @ODataField( odataName = "SubscriptionExpectedTerm" )
    private BigDecimal subscriptionExpectedTerm;
    /**
     * Use with available fluent helpers to apply the <b>SubscriptionExpectedTerm</b> field to query operations.
     *
     */
    public final static BusSolnOrdSubscrpnBillgItemField<BigDecimal> SUBSCRIPTION_EXPECTED_TERM =
        new BusSolnOrdSubscrpnBillgItemField<BigDecimal>("SubscriptionExpectedTerm");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SubscrpnContrTrmsAreSpecified</b>
     * </p>
     *
     * @return The subscrpnContrTrmsAreSpecified contained in this entity.
     */
    @SerializedName( "SubscrpnContrTrmsAreSpecified" )
    @JsonProperty( "SubscrpnContrTrmsAreSpecified" )
    @Nullable
    @ODataField( odataName = "SubscrpnContrTrmsAreSpecified" )
    private String subscrpnContrTrmsAreSpecified;
    /**
     * Use with available fluent helpers to apply the <b>SubscrpnContrTrmsAreSpecified</b> field to query operations.
     *
     */
    public final static BusSolnOrdSubscrpnBillgItemField<String> SUBSCRPN_CONTR_TRMS_ARE_SPECIFIED =
        new BusSolnOrdSubscrpnBillgItemField<String>("SubscrpnContrTrmsAreSpecified");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MidBillgCycExprtnIsAllowed</b>
     * </p>
     *
     * @return Allow Mid-Bill-Cycle Expiration
     */
    @SerializedName( "MidBillgCycExprtnIsAllowed" )
    @JsonProperty( "MidBillgCycExprtnIsAllowed" )
    @Nullable
    @ODataField( odataName = "MidBillgCycExprtnIsAllowed" )
    private String midBillgCycExprtnIsAllowed;
    /**
     * Use with available fluent helpers to apply the <b>MidBillgCycExprtnIsAllowed</b> field to query operations.
     *
     */
    public final static BusSolnOrdSubscrpnBillgItemField<String> MID_BILLG_CYC_EXPRTN_IS_ALLOWED =
        new BusSolnOrdSubscrpnBillgItemField<String>("MidBillgCycExprtnIsAllowed");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SubscriptionBillingCycle</b>
     * </p>
     *
     * @return Billing Cycle
     */
    @SerializedName( "SubscriptionBillingCycle" )
    @JsonProperty( "SubscriptionBillingCycle" )
    @Nullable
    @ODataField( odataName = "SubscriptionBillingCycle" )
    private String subscriptionBillingCycle;
    /**
     * Use with available fluent helpers to apply the <b>SubscriptionBillingCycle</b> field to query operations.
     *
     */
    public final static BusSolnOrdSubscrpnBillgItemField<String> SUBSCRIPTION_BILLING_CYCLE =
        new BusSolnOrdSubscrpnBillgItemField<String>("SubscriptionBillingCycle");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SoldToParty</b>
     * </p>
     *
     * @return Sold-To Party
     */
    @SerializedName( "SoldToParty" )
    @JsonProperty( "SoldToParty" )
    @Nullable
    @ODataField( odataName = "SoldToParty" )
    private String soldToParty;
    /**
     * Use with available fluent helpers to apply the <b>SoldToParty</b> field to query operations.
     *
     */
    public final static BusSolnOrdSubscrpnBillgItemField<String> SOLD_TO_PARTY =
        new BusSolnOrdSubscrpnBillgItemField<String>("SoldToParty");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ShipToParty</b>
     * </p>
     *
     * @return Ship-To Party
     */
    @SerializedName( "ShipToParty" )
    @JsonProperty( "ShipToParty" )
    @Nullable
    @ODataField( odataName = "ShipToParty" )
    private String shipToParty;
    /**
     * Use with available fluent helpers to apply the <b>ShipToParty</b> field to query operations.
     *
     */
    public final static BusSolnOrdSubscrpnBillgItemField<String> SHIP_TO_PARTY =
        new BusSolnOrdSubscrpnBillgItemField<String>("ShipToParty");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BillToParty</b>
     * </p>
     *
     * @return Bill-To Party
     */
    @SerializedName( "BillToParty" )
    @JsonProperty( "BillToParty" )
    @Nullable
    @ODataField( odataName = "BillToParty" )
    private String billToParty;
    /**
     * Use with available fluent helpers to apply the <b>BillToParty</b> field to query operations.
     *
     */
    public final static BusSolnOrdSubscrpnBillgItemField<String> BILL_TO_PARTY =
        new BusSolnOrdSubscrpnBillgItemField<String>("BillToParty");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PayerParty</b>
     * </p>
     *
     * @return Payer
     */
    @SerializedName( "PayerParty" )
    @JsonProperty( "PayerParty" )
    @Nullable
    @ODataField( odataName = "PayerParty" )
    private String payerParty;
    /**
     * Use with available fluent helpers to apply the <b>PayerParty</b> field to query operations.
     *
     */
    public final static BusSolnOrdSubscrpnBillgItemField<String> PAYER_PARTY =
        new BusSolnOrdSubscrpnBillgItemField<String>("PayerParty");
    /**
     * Navigation property <b>to_BusinessSolutionOrder</b> for <b>BusSolnOrdSubscrpnBillgItem</b> to single
     * <b>BusinessSolutionOrder</b>.
     *
     */
    @SerializedName( "to_BusinessSolutionOrder" )
    @JsonProperty( "to_BusinessSolutionOrder" )
    @ODataField( odataName = "to_BusinessSolutionOrder" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private BusinessSolutionOrder toBusinessSolutionOrder;
    /**
     * Navigation property <b>to_PriceParameters</b> for <b>BusSolnOrdSubscrpnBillgItem</b> to multiple
     * <b>BusSolnOrdItmSubscrpnPrParam</b>.
     *
     */
    @SerializedName( "to_PriceParameters" )
    @JsonProperty( "to_PriceParameters" )
    @ODataField( odataName = "to_PriceParameters" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BusSolnOrdItmSubscrpnPrParam> toPriceParameters;
    /**
     * Navigation property <b>to_RateElements</b> for <b>BusSolnOrdSubscrpnBillgItem</b> to multiple
     * <b>BusSolnOrdItmRateElement</b>.
     *
     */
    @SerializedName( "to_RateElements" )
    @JsonProperty( "to_RateElements" )
    @ODataField( odataName = "to_RateElements" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BusSolnOrdItmRateElement> toRateElements;
    /**
     * Navigation property <b>to_SubscriptionBilling</b> for <b>BusSolnOrdSubscrpnBillgItem</b> to multiple
     * <b>BusSolnOrdItmFUPSubscrpn</b>.
     *
     */
    @SerializedName( "to_SubscriptionBilling" )
    @JsonProperty( "to_SubscriptionBilling" )
    @ODataField( odataName = "to_SubscriptionBilling" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BusSolnOrdItmFUPSubscrpn> toSubscriptionBilling;
    /**
     * Navigation property <b>to_SubscriptionParameters</b> for <b>BusSolnOrdSubscrpnBillgItem</b> to multiple
     * <b>BusSolnOrdItmSubscrpnParam</b>.
     *
     */
    @SerializedName( "to_SubscriptionParameters" )
    @JsonProperty( "to_SubscriptionParameters" )
    @ODataField( odataName = "to_SubscriptionParameters" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BusSolnOrdItmSubscrpnParam> toSubscriptionParameters;
    /**
     * Navigation property <b>to_SubscriptionPriceAgreements</b> for <b>BusSolnOrdSubscrpnBillgItem</b> to multiple
     * <b>BusSolnOrdItmSubscrpnPrAgrmt</b>.
     *
     */
    @SerializedName( "to_SubscriptionPriceAgreements" )
    @JsonProperty( "to_SubscriptionPriceAgreements" )
    @ODataField( odataName = "to_SubscriptionPriceAgreements" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BusSolnOrdItmSubscrpnPrAgrmt> toSubscriptionPriceAgreements;
    /**
     * Navigation property <b>to_UserStatus</b> for <b>BusSolnOrdSubscrpnBillgItem</b> to multiple
     * <b>BusSolnOrdItmUserStatus</b>.
     *
     */
    @SerializedName( "to_UserStatus" )
    @JsonProperty( "to_UserStatus" )
    @ODataField( odataName = "to_UserStatus" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BusSolnOrdItmUserStatus> toUserStatus;
    /**
     * Use with available fluent helpers to apply the <b>to_BusinessSolutionOrder</b> navigation property to query
     * operations.
     *
     */
    public final static BusSolnOrdSubscrpnBillgItemOneToOneLink<BusinessSolutionOrder> TO_BUSINESS_SOLUTION_ORDER =
        new BusSolnOrdSubscrpnBillgItemOneToOneLink<BusinessSolutionOrder>("to_BusinessSolutionOrder");
    /**
     * Use with available fluent helpers to apply the <b>to_PriceParameters</b> navigation property to query operations.
     *
     */
    public final static BusSolnOrdSubscrpnBillgItemLink<BusSolnOrdItmSubscrpnPrParam> TO_PRICE_PARAMETERS =
        new BusSolnOrdSubscrpnBillgItemLink<BusSolnOrdItmSubscrpnPrParam>("to_PriceParameters");
    /**
     * Use with available fluent helpers to apply the <b>to_RateElements</b> navigation property to query operations.
     *
     */
    public final static BusSolnOrdSubscrpnBillgItemLink<BusSolnOrdItmRateElement> TO_RATE_ELEMENTS =
        new BusSolnOrdSubscrpnBillgItemLink<BusSolnOrdItmRateElement>("to_RateElements");
    /**
     * Use with available fluent helpers to apply the <b>to_SubscriptionBilling</b> navigation property to query
     * operations.
     *
     */
    public final static BusSolnOrdSubscrpnBillgItemLink<BusSolnOrdItmFUPSubscrpn> TO_SUBSCRIPTION_BILLING =
        new BusSolnOrdSubscrpnBillgItemLink<BusSolnOrdItmFUPSubscrpn>("to_SubscriptionBilling");
    /**
     * Use with available fluent helpers to apply the <b>to_SubscriptionParameters</b> navigation property to query
     * operations.
     *
     */
    public final static BusSolnOrdSubscrpnBillgItemLink<BusSolnOrdItmSubscrpnParam> TO_SUBSCRIPTION_PARAMETERS =
        new BusSolnOrdSubscrpnBillgItemLink<BusSolnOrdItmSubscrpnParam>("to_SubscriptionParameters");
    /**
     * Use with available fluent helpers to apply the <b>to_SubscriptionPriceAgreements</b> navigation property to query
     * operations.
     *
     */
    public final static BusSolnOrdSubscrpnBillgItemLink<BusSolnOrdItmSubscrpnPrAgrmt> TO_SUBSCRIPTION_PRICE_AGREEMENTS =
        new BusSolnOrdSubscrpnBillgItemLink<BusSolnOrdItmSubscrpnPrAgrmt>("to_SubscriptionPriceAgreements");
    /**
     * Use with available fluent helpers to apply the <b>to_UserStatus</b> navigation property to query operations.
     *
     */
    public final static BusSolnOrdSubscrpnBillgItemLink<BusSolnOrdItmUserStatus> TO_USER_STATUS =
        new BusSolnOrdSubscrpnBillgItemLink<BusSolnOrdItmUserStatus>("to_UserStatus");

    @Nonnull
    @Override
    public Class<BusSolnOrdSubscrpnBillgItem> getType()
    {
        return BusSolnOrdSubscrpnBillgItem.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BusinessSolutionOrder</b>
     * </p>
     *
     * @param businessSolutionOrder
     *            Transaction ID
     */
    public void setBusinessSolutionOrder( @Nullable final String businessSolutionOrder )
    {
        rememberChangedField("BusinessSolutionOrder", this.businessSolutionOrder);
        this.businessSolutionOrder = businessSolutionOrder;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BusinessSolutionOrderItem</b>
     * </p>
     *
     * @param businessSolutionOrderItem
     *            Shortened Item Number in Document
     */
    public void setBusinessSolutionOrderItem( @Nullable final String businessSolutionOrderItem )
    {
        rememberChangedField("BusinessSolutionOrderItem", this.businessSolutionOrderItem);
        this.businessSolutionOrderItem = businessSolutionOrderItem;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BusinessSolutionOrderItemUUID</b>
     * </p>
     *
     * @param businessSolutionOrderItemUUID
     *            GUID of a CRM Order Object
     */
    public void setBusinessSolutionOrderItemUUID( @Nullable final UUID businessSolutionOrderItemUUID )
    {
        rememberChangedField("BusinessSolutionOrderItemUUID", this.businessSolutionOrderItemUUID);
        this.businessSolutionOrderItemUUID = businessSolutionOrderItemUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmCategory</b>
     * </p>
     *
     * @param busSolnOrdItmCategory
     *            Item Category
     */
    public void setBusSolnOrdItmCategory( @Nullable final String busSolnOrdItmCategory )
    {
        rememberChangedField("BusSolnOrdItmCategory", this.busSolnOrdItmCategory);
        this.busSolnOrdItmCategory = busSolnOrdItmCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @param product
     *            Product Number
     */
    public void setProduct( @Nullable final String product )
    {
        rememberChangedField("Product", this.product);
        this.product = product;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Quantity</b>
     * </p>
     *
     * @param quantity
     *            CRM: Order Quantity
     */
    public void setQuantity( @Nullable final BigDecimal quantity )
    {
        rememberChangedField("Quantity", this.quantity);
        this.quantity = quantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>QuantityUnit</b>
     * </p>
     *
     * @param quantityUnit
     *            Unit of Measure in Which the Product Is Sold
     */
    public void setQuantityUnit( @Nullable final String quantityUnit )
    {
        rememberChangedField("QuantityUnit", this.quantityUnit);
        this.quantityUnit = quantityUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmQtyUnitSAPCode</b>
     * </p>
     *
     * @param busSolnOrdItmQtyUnitSAPCode
     *            SAP Unit Code for Order Quantity
     */
    public void setBusSolnOrdItmQtyUnitSAPCode( @Nullable final String busSolnOrdItmQtyUnitSAPCode )
    {
        rememberChangedField("BusSolnOrdItmQtyUnitSAPCode", this.busSolnOrdItmQtyUnitSAPCode);
        this.busSolnOrdItmQtyUnitSAPCode = busSolnOrdItmQtyUnitSAPCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmQtyUnitISOCode</b>
     * </p>
     *
     * @param busSolnOrdItmQtyUnitISOCode
     *            ISO Unit Code for Order Quantity
     */
    public void setBusSolnOrdItmQtyUnitISOCode( @Nullable final String busSolnOrdItmQtyUnitISOCode )
    {
        rememberChangedField("BusSolnOrdItmQtyUnitISOCode", this.busSolnOrdItmQtyUnitISOCode);
        this.busSolnOrdItmQtyUnitISOCode = busSolnOrdItmQtyUnitISOCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmDescription</b>
     * </p>
     *
     * @param busSolnOrdItmDescription
     *            Product Description
     */
    public void setBusSolnOrdItmDescription( @Nullable final String busSolnOrdItmDescription )
    {
        rememberChangedField("BusSolnOrdItmDescription", this.busSolnOrdItmDescription);
        this.busSolnOrdItmDescription = busSolnOrdItmDescription;
    }

    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmExtReference</b>
     * </p>
     *
     * @param busSolnOrdItmExtReference
     *            External Reference Number
     */
    public void setBusSolnOrdItmExtReference( @Nullable final String busSolnOrdItmExtReference )
    {
        rememberChangedField("BusSolnOrdItmExtReference", this.busSolnOrdItmExtReference);
        this.busSolnOrdItmExtReference = busSolnOrdItmExtReference;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocumentItemNetAmount</b>
     * </p>
     *
     * @param serviceDocumentItemNetAmount
     *            Net Value
     */
    public void setServiceDocumentItemNetAmount( @Nullable final BigDecimal serviceDocumentItemNetAmount )
    {
        rememberChangedField("ServiceDocumentItemNetAmount", this.serviceDocumentItemNetAmount);
        this.serviceDocumentItemNetAmount = serviceDocumentItemNetAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @param transactionCurrency
     *            Currency
     */
    public void setTransactionCurrency( @Nullable final String transactionCurrency )
    {
        rememberChangedField("TransactionCurrency", this.transactionCurrency);
        this.transactionCurrency = transactionCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Short Text Language for an Item
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmIsCompleted</b>
     * </p>
     *
     * @param busSolnOrdItmIsCompleted
     *            The busSolnOrdItmIsCompleted to set.
     */
    public void setBusSolnOrdItmIsCompleted( @Nullable final String busSolnOrdItmIsCompleted )
    {
        rememberChangedField("BusSolnOrdItmIsCompleted", this.busSolnOrdItmIsCompleted);
        this.busSolnOrdItmIsCompleted = busSolnOrdItmIsCompleted;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmIsReleased</b>
     * </p>
     *
     * @param busSolnOrdItmIsReleased
     *            Release Status
     */
    public void setBusSolnOrdItmIsReleased( @Nullable final String busSolnOrdItmIsReleased )
    {
        rememberChangedField("BusSolnOrdItmIsReleased", this.busSolnOrdItmIsReleased);
        this.busSolnOrdItmIsReleased = busSolnOrdItmIsReleased;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmDistrStatus</b>
     * </p>
     *
     * @param busSolnOrdItmDistrStatus
     *            The busSolnOrdItmDistrStatus to set.
     */
    public void setBusSolnOrdItmDistrStatus( @Nullable final String busSolnOrdItmDistrStatus )
    {
        rememberChangedField("BusSolnOrdItmDistrStatus", this.busSolnOrdItmDistrStatus);
        this.busSolnOrdItmDistrStatus = busSolnOrdItmDistrStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmDistrStatusName</b>
     * </p>
     *
     * @param busSolnOrdItmDistrStatusName
     *            The busSolnOrdItmDistrStatusName to set.
     */
    public void setBusSolnOrdItmDistrStatusName( @Nullable final String busSolnOrdItmDistrStatusName )
    {
        rememberChangedField("BusSolnOrdItmDistrStatusName", this.busSolnOrdItmDistrStatusName);
        this.busSolnOrdItmDistrStatusName = busSolnOrdItmDistrStatusName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SubscrpnSimulationStatus</b>
     * </p>
     *
     * @param subscrpnSimulationStatus
     *            The subscrpnSimulationStatus to set.
     */
    public void setSubscrpnSimulationStatus( @Nullable final String subscrpnSimulationStatus )
    {
        rememberChangedField("SubscrpnSimulationStatus", this.subscrpnSimulationStatus);
        this.subscrpnSimulationStatus = subscrpnSimulationStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>SubscrpnSimulationStatusName</b>
     * </p>
     *
     * @param subscrpnSimulationStatusName
     *            The subscrpnSimulationStatusName to set.
     */
    public void setSubscrpnSimulationStatusName( @Nullable final String subscrpnSimulationStatusName )
    {
        rememberChangedField("SubscrpnSimulationStatusName", this.subscrpnSimulationStatusName);
        this.subscrpnSimulationStatusName = subscrpnSimulationStatusName;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SubscriptionStartDateTime</b>
     * </p>
     *
     * @param subscriptionStartDateTime
     *            Contract Start date
     */
    public void setSubscriptionStartDateTime( @Nullable final ZonedDateTime subscriptionStartDateTime )
    {
        rememberChangedField("SubscriptionStartDateTime", this.subscriptionStartDateTime);
        this.subscriptionStartDateTime = subscriptionStartDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SubscriptionEndDateTime</b>
     * </p>
     *
     * @param subscriptionEndDateTime
     *            Contract End Date
     */
    public void setSubscriptionEndDateTime( @Nullable final ZonedDateTime subscriptionEndDateTime )
    {
        rememberChangedField("SubscriptionEndDateTime", this.subscriptionEndDateTime);
        this.subscriptionEndDateTime = subscriptionEndDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SubscrpnBillgItmPrcgDateTime</b>
     * </p>
     *
     * @param subscrpnBillgItmPrcgDateTime
     *            Time Stamp (UTC) of Start Time of Appointment
     */
    public void setSubscrpnBillgItmPrcgDateTime( @Nullable final ZonedDateTime subscrpnBillgItmPrcgDateTime )
    {
        rememberChangedField("SubscrpnBillgItmPrcgDateTime", this.subscrpnBillgItmPrcgDateTime);
        this.subscrpnBillgItmPrcgDateTime = subscrpnBillgItmPrcgDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>SubscrpnWithdrawalPeriod</b>
     * </p>
     *
     * @param subscrpnWithdrawalPeriod
     *            The subscrpnWithdrawalPeriod to set.
     */
    public void setSubscrpnWithdrawalPeriod( @Nullable final BigDecimal subscrpnWithdrawalPeriod )
    {
        rememberChangedField("SubscrpnWithdrawalPeriod", this.subscrpnWithdrawalPeriod);
        this.subscrpnWithdrawalPeriod = subscrpnWithdrawalPeriod;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>SubscriptionFixedTerm</b>
     * </p>
     *
     * @param subscriptionFixedTerm
     *            The subscriptionFixedTerm to set.
     */
    public void setSubscriptionFixedTerm( @Nullable final BigDecimal subscriptionFixedTerm )
    {
        rememberChangedField("SubscriptionFixedTerm", this.subscriptionFixedTerm);
        this.subscriptionFixedTerm = subscriptionFixedTerm;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>SubscriptionTermOfNotice</b>
     * </p>
     *
     * @param subscriptionTermOfNotice
     *            The subscriptionTermOfNotice to set.
     */
    public void setSubscriptionTermOfNotice( @Nullable final BigDecimal subscriptionTermOfNotice )
    {
        rememberChangedField("SubscriptionTermOfNotice", this.subscriptionTermOfNotice);
        this.subscriptionTermOfNotice = subscriptionTermOfNotice;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>SubscriptionMinimumTerm</b>
     * </p>
     *
     * @param subscriptionMinimumTerm
     *            The subscriptionMinimumTerm to set.
     */
    public void setSubscriptionMinimumTerm( @Nullable final BigDecimal subscriptionMinimumTerm )
    {
        rememberChangedField("SubscriptionMinimumTerm", this.subscriptionMinimumTerm);
        this.subscriptionMinimumTerm = subscriptionMinimumTerm;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>SubscriptionRenewalPeriod</b>
     * </p>
     *
     * @param subscriptionRenewalPeriod
     *            The subscriptionRenewalPeriod to set.
     */
    public void setSubscriptionRenewalPeriod( @Nullable final BigDecimal subscriptionRenewalPeriod )
    {
        rememberChangedField("SubscriptionRenewalPeriod", this.subscriptionRenewalPeriod);
        this.subscriptionRenewalPeriod = subscriptionRenewalPeriod;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>SubscriptionExpectedTerm</b>
     * </p>
     *
     * @param subscriptionExpectedTerm
     *            The subscriptionExpectedTerm to set.
     */
    public void setSubscriptionExpectedTerm( @Nullable final BigDecimal subscriptionExpectedTerm )
    {
        rememberChangedField("SubscriptionExpectedTerm", this.subscriptionExpectedTerm);
        this.subscriptionExpectedTerm = subscriptionExpectedTerm;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SubscrpnContrTrmsAreSpecified</b>
     * </p>
     *
     * @param subscrpnContrTrmsAreSpecified
     *            The subscrpnContrTrmsAreSpecified to set.
     */
    public void setSubscrpnContrTrmsAreSpecified( @Nullable final String subscrpnContrTrmsAreSpecified )
    {
        rememberChangedField("SubscrpnContrTrmsAreSpecified", this.subscrpnContrTrmsAreSpecified);
        this.subscrpnContrTrmsAreSpecified = subscrpnContrTrmsAreSpecified;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MidBillgCycExprtnIsAllowed</b>
     * </p>
     *
     * @param midBillgCycExprtnIsAllowed
     *            Allow Mid-Bill-Cycle Expiration
     */
    public void setMidBillgCycExprtnIsAllowed( @Nullable final String midBillgCycExprtnIsAllowed )
    {
        rememberChangedField("MidBillgCycExprtnIsAllowed", this.midBillgCycExprtnIsAllowed);
        this.midBillgCycExprtnIsAllowed = midBillgCycExprtnIsAllowed;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SubscriptionBillingCycle</b>
     * </p>
     *
     * @param subscriptionBillingCycle
     *            Billing Cycle
     */
    public void setSubscriptionBillingCycle( @Nullable final String subscriptionBillingCycle )
    {
        rememberChangedField("SubscriptionBillingCycle", this.subscriptionBillingCycle);
        this.subscriptionBillingCycle = subscriptionBillingCycle;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SoldToParty</b>
     * </p>
     *
     * @param soldToParty
     *            Sold-To Party
     */
    public void setSoldToParty( @Nullable final String soldToParty )
    {
        rememberChangedField("SoldToParty", this.soldToParty);
        this.soldToParty = soldToParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ShipToParty</b>
     * </p>
     *
     * @param shipToParty
     *            Ship-To Party
     */
    public void setShipToParty( @Nullable final String shipToParty )
    {
        rememberChangedField("ShipToParty", this.shipToParty);
        this.shipToParty = shipToParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BillToParty</b>
     * </p>
     *
     * @param billToParty
     *            Bill-To Party
     */
    public void setBillToParty( @Nullable final String billToParty )
    {
        rememberChangedField("BillToParty", this.billToParty);
        this.billToParty = billToParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PayerParty</b>
     * </p>
     *
     * @param payerParty
     *            Payer
     */
    public void setPayerParty( @Nullable final String payerParty )
    {
        rememberChangedField("PayerParty", this.payerParty);
        this.payerParty = payerParty;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_BusSolnOrdSubscrpnBillgItem";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("BusinessSolutionOrder", getBusinessSolutionOrder());
        result.put("BusinessSolutionOrderItem", getBusinessSolutionOrderItem());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("BusinessSolutionOrder", getBusinessSolutionOrder());
        values.put("BusinessSolutionOrderItem", getBusinessSolutionOrderItem());
        values.put("BusinessSolutionOrderItemUUID", getBusinessSolutionOrderItemUUID());
        values.put("BusSolnOrdItmCategory", getBusSolnOrdItmCategory());
        values.put("Product", getProduct());
        values.put("Quantity", getQuantity());
        values.put("QuantityUnit", getQuantityUnit());
        values.put("BusSolnOrdItmQtyUnitSAPCode", getBusSolnOrdItmQtyUnitSAPCode());
        values.put("BusSolnOrdItmQtyUnitISOCode", getBusSolnOrdItmQtyUnitISOCode());
        values.put("BusSolnOrdItmDescription", getBusSolnOrdItmDescription());
        values.put("BusSolnOrdItmExtReference", getBusSolnOrdItmExtReference());
        values.put("ServiceDocumentItemNetAmount", getServiceDocumentItemNetAmount());
        values.put("TransactionCurrency", getTransactionCurrency());
        values.put("Language", getLanguage());
        values.put("BusSolnOrdItmIsCompleted", getBusSolnOrdItmIsCompleted());
        values.put("BusSolnOrdItmIsReleased", getBusSolnOrdItmIsReleased());
        values.put("BusSolnOrdItmDistrStatus", getBusSolnOrdItmDistrStatus());
        values.put("BusSolnOrdItmDistrStatusName", getBusSolnOrdItmDistrStatusName());
        values.put("SubscrpnSimulationStatus", getSubscrpnSimulationStatus());
        values.put("SubscrpnSimulationStatusName", getSubscrpnSimulationStatusName());
        values.put("SubscriptionStartDateTime", getSubscriptionStartDateTime());
        values.put("SubscriptionEndDateTime", getSubscriptionEndDateTime());
        values.put("SubscrpnBillgItmPrcgDateTime", getSubscrpnBillgItmPrcgDateTime());
        values.put("SubscrpnWithdrawalPeriod", getSubscrpnWithdrawalPeriod());
        values.put("SubscriptionFixedTerm", getSubscriptionFixedTerm());
        values.put("SubscriptionTermOfNotice", getSubscriptionTermOfNotice());
        values.put("SubscriptionMinimumTerm", getSubscriptionMinimumTerm());
        values.put("SubscriptionRenewalPeriod", getSubscriptionRenewalPeriod());
        values.put("SubscriptionExpectedTerm", getSubscriptionExpectedTerm());
        values.put("SubscrpnContrTrmsAreSpecified", getSubscrpnContrTrmsAreSpecified());
        values.put("MidBillgCycExprtnIsAllowed", getMidBillgCycExprtnIsAllowed());
        values.put("SubscriptionBillingCycle", getSubscriptionBillingCycle());
        values.put("SoldToParty", getSoldToParty());
        values.put("ShipToParty", getShipToParty());
        values.put("BillToParty", getBillToParty());
        values.put("PayerParty", getPayerParty());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("BusinessSolutionOrder") ) {
                final Object value = values.remove("BusinessSolutionOrder");
                if( (value == null) || (!value.equals(getBusinessSolutionOrder())) ) {
                    setBusinessSolutionOrder(((String) value));
                }
            }
            if( values.containsKey("BusinessSolutionOrderItem") ) {
                final Object value = values.remove("BusinessSolutionOrderItem");
                if( (value == null) || (!value.equals(getBusinessSolutionOrderItem())) ) {
                    setBusinessSolutionOrderItem(((String) value));
                }
            }
            if( values.containsKey("BusinessSolutionOrderItemUUID") ) {
                final Object value = values.remove("BusinessSolutionOrderItemUUID");
                if( (value == null) || (!value.equals(getBusinessSolutionOrderItemUUID())) ) {
                    setBusinessSolutionOrderItemUUID(((UUID) value));
                }
            }
            if( values.containsKey("BusSolnOrdItmCategory") ) {
                final Object value = values.remove("BusSolnOrdItmCategory");
                if( (value == null) || (!value.equals(getBusSolnOrdItmCategory())) ) {
                    setBusSolnOrdItmCategory(((String) value));
                }
            }
            if( values.containsKey("Product") ) {
                final Object value = values.remove("Product");
                if( (value == null) || (!value.equals(getProduct())) ) {
                    setProduct(((String) value));
                }
            }
            if( values.containsKey("Quantity") ) {
                final Object value = values.remove("Quantity");
                if( (value == null) || (!value.equals(getQuantity())) ) {
                    setQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("QuantityUnit") ) {
                final Object value = values.remove("QuantityUnit");
                if( (value == null) || (!value.equals(getQuantityUnit())) ) {
                    setQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("BusSolnOrdItmQtyUnitSAPCode") ) {
                final Object value = values.remove("BusSolnOrdItmQtyUnitSAPCode");
                if( (value == null) || (!value.equals(getBusSolnOrdItmQtyUnitSAPCode())) ) {
                    setBusSolnOrdItmQtyUnitSAPCode(((String) value));
                }
            }
            if( values.containsKey("BusSolnOrdItmQtyUnitISOCode") ) {
                final Object value = values.remove("BusSolnOrdItmQtyUnitISOCode");
                if( (value == null) || (!value.equals(getBusSolnOrdItmQtyUnitISOCode())) ) {
                    setBusSolnOrdItmQtyUnitISOCode(((String) value));
                }
            }
            if( values.containsKey("BusSolnOrdItmDescription") ) {
                final Object value = values.remove("BusSolnOrdItmDescription");
                if( (value == null) || (!value.equals(getBusSolnOrdItmDescription())) ) {
                    setBusSolnOrdItmDescription(((String) value));
                }
            }
            if( values.containsKey("BusSolnOrdItmExtReference") ) {
                final Object value = values.remove("BusSolnOrdItmExtReference");
                if( (value == null) || (!value.equals(getBusSolnOrdItmExtReference())) ) {
                    setBusSolnOrdItmExtReference(((String) value));
                }
            }
            if( values.containsKey("ServiceDocumentItemNetAmount") ) {
                final Object value = values.remove("ServiceDocumentItemNetAmount");
                if( (value == null) || (!value.equals(getServiceDocumentItemNetAmount())) ) {
                    setServiceDocumentItemNetAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("TransactionCurrency") ) {
                final Object value = values.remove("TransactionCurrency");
                if( (value == null) || (!value.equals(getTransactionCurrency())) ) {
                    setTransactionCurrency(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("BusSolnOrdItmIsCompleted") ) {
                final Object value = values.remove("BusSolnOrdItmIsCompleted");
                if( (value == null) || (!value.equals(getBusSolnOrdItmIsCompleted())) ) {
                    setBusSolnOrdItmIsCompleted(((String) value));
                }
            }
            if( values.containsKey("BusSolnOrdItmIsReleased") ) {
                final Object value = values.remove("BusSolnOrdItmIsReleased");
                if( (value == null) || (!value.equals(getBusSolnOrdItmIsReleased())) ) {
                    setBusSolnOrdItmIsReleased(((String) value));
                }
            }
            if( values.containsKey("BusSolnOrdItmDistrStatus") ) {
                final Object value = values.remove("BusSolnOrdItmDistrStatus");
                if( (value == null) || (!value.equals(getBusSolnOrdItmDistrStatus())) ) {
                    setBusSolnOrdItmDistrStatus(((String) value));
                }
            }
            if( values.containsKey("BusSolnOrdItmDistrStatusName") ) {
                final Object value = values.remove("BusSolnOrdItmDistrStatusName");
                if( (value == null) || (!value.equals(getBusSolnOrdItmDistrStatusName())) ) {
                    setBusSolnOrdItmDistrStatusName(((String) value));
                }
            }
            if( values.containsKey("SubscrpnSimulationStatus") ) {
                final Object value = values.remove("SubscrpnSimulationStatus");
                if( (value == null) || (!value.equals(getSubscrpnSimulationStatus())) ) {
                    setSubscrpnSimulationStatus(((String) value));
                }
            }
            if( values.containsKey("SubscrpnSimulationStatusName") ) {
                final Object value = values.remove("SubscrpnSimulationStatusName");
                if( (value == null) || (!value.equals(getSubscrpnSimulationStatusName())) ) {
                    setSubscrpnSimulationStatusName(((String) value));
                }
            }
            if( values.containsKey("SubscriptionStartDateTime") ) {
                final Object value = values.remove("SubscriptionStartDateTime");
                if( (value == null) || (!value.equals(getSubscriptionStartDateTime())) ) {
                    setSubscriptionStartDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("SubscriptionEndDateTime") ) {
                final Object value = values.remove("SubscriptionEndDateTime");
                if( (value == null) || (!value.equals(getSubscriptionEndDateTime())) ) {
                    setSubscriptionEndDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("SubscrpnBillgItmPrcgDateTime") ) {
                final Object value = values.remove("SubscrpnBillgItmPrcgDateTime");
                if( (value == null) || (!value.equals(getSubscrpnBillgItmPrcgDateTime())) ) {
                    setSubscrpnBillgItmPrcgDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("SubscrpnWithdrawalPeriod") ) {
                final Object value = values.remove("SubscrpnWithdrawalPeriod");
                if( (value == null) || (!value.equals(getSubscrpnWithdrawalPeriod())) ) {
                    setSubscrpnWithdrawalPeriod(((BigDecimal) value));
                }
            }
            if( values.containsKey("SubscriptionFixedTerm") ) {
                final Object value = values.remove("SubscriptionFixedTerm");
                if( (value == null) || (!value.equals(getSubscriptionFixedTerm())) ) {
                    setSubscriptionFixedTerm(((BigDecimal) value));
                }
            }
            if( values.containsKey("SubscriptionTermOfNotice") ) {
                final Object value = values.remove("SubscriptionTermOfNotice");
                if( (value == null) || (!value.equals(getSubscriptionTermOfNotice())) ) {
                    setSubscriptionTermOfNotice(((BigDecimal) value));
                }
            }
            if( values.containsKey("SubscriptionMinimumTerm") ) {
                final Object value = values.remove("SubscriptionMinimumTerm");
                if( (value == null) || (!value.equals(getSubscriptionMinimumTerm())) ) {
                    setSubscriptionMinimumTerm(((BigDecimal) value));
                }
            }
            if( values.containsKey("SubscriptionRenewalPeriod") ) {
                final Object value = values.remove("SubscriptionRenewalPeriod");
                if( (value == null) || (!value.equals(getSubscriptionRenewalPeriod())) ) {
                    setSubscriptionRenewalPeriod(((BigDecimal) value));
                }
            }
            if( values.containsKey("SubscriptionExpectedTerm") ) {
                final Object value = values.remove("SubscriptionExpectedTerm");
                if( (value == null) || (!value.equals(getSubscriptionExpectedTerm())) ) {
                    setSubscriptionExpectedTerm(((BigDecimal) value));
                }
            }
            if( values.containsKey("SubscrpnContrTrmsAreSpecified") ) {
                final Object value = values.remove("SubscrpnContrTrmsAreSpecified");
                if( (value == null) || (!value.equals(getSubscrpnContrTrmsAreSpecified())) ) {
                    setSubscrpnContrTrmsAreSpecified(((String) value));
                }
            }
            if( values.containsKey("MidBillgCycExprtnIsAllowed") ) {
                final Object value = values.remove("MidBillgCycExprtnIsAllowed");
                if( (value == null) || (!value.equals(getMidBillgCycExprtnIsAllowed())) ) {
                    setMidBillgCycExprtnIsAllowed(((String) value));
                }
            }
            if( values.containsKey("SubscriptionBillingCycle") ) {
                final Object value = values.remove("SubscriptionBillingCycle");
                if( (value == null) || (!value.equals(getSubscriptionBillingCycle())) ) {
                    setSubscriptionBillingCycle(((String) value));
                }
            }
            if( values.containsKey("SoldToParty") ) {
                final Object value = values.remove("SoldToParty");
                if( (value == null) || (!value.equals(getSoldToParty())) ) {
                    setSoldToParty(((String) value));
                }
            }
            if( values.containsKey("ShipToParty") ) {
                final Object value = values.remove("ShipToParty");
                if( (value == null) || (!value.equals(getShipToParty())) ) {
                    setShipToParty(((String) value));
                }
            }
            if( values.containsKey("BillToParty") ) {
                final Object value = values.remove("BillToParty");
                if( (value == null) || (!value.equals(getBillToParty())) ) {
                    setBillToParty(((String) value));
                }
            }
            if( values.containsKey("PayerParty") ) {
                final Object value = values.remove("PayerParty");
                if( (value == null) || (!value.equals(getPayerParty())) ) {
                    setPayerParty(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_BusinessSolutionOrder") ) {
                final Object value = (values).remove("to_BusinessSolutionOrder");
                if( value instanceof Map ) {
                    if( toBusinessSolutionOrder == null ) {
                        toBusinessSolutionOrder = new BusinessSolutionOrder();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toBusinessSolutionOrder.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_PriceParameters") ) {
                final Object value = (values).remove("to_PriceParameters");
                if( value instanceof Iterable ) {
                    if( toPriceParameters == null ) {
                        toPriceParameters = Lists.newArrayList();
                    } else {
                        toPriceParameters = Lists.newArrayList(toPriceParameters);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BusSolnOrdItmSubscrpnPrParam entity;
                        if( toPriceParameters.size() > i ) {
                            entity = toPriceParameters.get(i);
                        } else {
                            entity = new BusSolnOrdItmSubscrpnPrParam();
                            toPriceParameters.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_RateElements") ) {
                final Object value = (values).remove("to_RateElements");
                if( value instanceof Iterable ) {
                    if( toRateElements == null ) {
                        toRateElements = Lists.newArrayList();
                    } else {
                        toRateElements = Lists.newArrayList(toRateElements);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BusSolnOrdItmRateElement entity;
                        if( toRateElements.size() > i ) {
                            entity = toRateElements.get(i);
                        } else {
                            entity = new BusSolnOrdItmRateElement();
                            toRateElements.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_SubscriptionBilling") ) {
                final Object value = (values).remove("to_SubscriptionBilling");
                if( value instanceof Iterable ) {
                    if( toSubscriptionBilling == null ) {
                        toSubscriptionBilling = Lists.newArrayList();
                    } else {
                        toSubscriptionBilling = Lists.newArrayList(toSubscriptionBilling);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BusSolnOrdItmFUPSubscrpn entity;
                        if( toSubscriptionBilling.size() > i ) {
                            entity = toSubscriptionBilling.get(i);
                        } else {
                            entity = new BusSolnOrdItmFUPSubscrpn();
                            toSubscriptionBilling.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_SubscriptionParameters") ) {
                final Object value = (values).remove("to_SubscriptionParameters");
                if( value instanceof Iterable ) {
                    if( toSubscriptionParameters == null ) {
                        toSubscriptionParameters = Lists.newArrayList();
                    } else {
                        toSubscriptionParameters = Lists.newArrayList(toSubscriptionParameters);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BusSolnOrdItmSubscrpnParam entity;
                        if( toSubscriptionParameters.size() > i ) {
                            entity = toSubscriptionParameters.get(i);
                        } else {
                            entity = new BusSolnOrdItmSubscrpnParam();
                            toSubscriptionParameters.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_SubscriptionPriceAgreements") ) {
                final Object value = (values).remove("to_SubscriptionPriceAgreements");
                if( value instanceof Iterable ) {
                    if( toSubscriptionPriceAgreements == null ) {
                        toSubscriptionPriceAgreements = Lists.newArrayList();
                    } else {
                        toSubscriptionPriceAgreements = Lists.newArrayList(toSubscriptionPriceAgreements);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BusSolnOrdItmSubscrpnPrAgrmt entity;
                        if( toSubscriptionPriceAgreements.size() > i ) {
                            entity = toSubscriptionPriceAgreements.get(i);
                        } else {
                            entity = new BusSolnOrdItmSubscrpnPrAgrmt();
                            toSubscriptionPriceAgreements.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_UserStatus") ) {
                final Object value = (values).remove("to_UserStatus");
                if( value instanceof Iterable ) {
                    if( toUserStatus == null ) {
                        toUserStatus = Lists.newArrayList();
                    } else {
                        toUserStatus = Lists.newArrayList(toUserStatus);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BusSolnOrdItmUserStatus entity;
                        if( toUserStatus.size() > i ) {
                            entity = toUserStatus.get(i);
                        } else {
                            entity = new BusSolnOrdItmUserStatus();
                            toUserStatus.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> BusSolnOrdSubscrpnBillgItemField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new BusSolnOrdSubscrpnBillgItemField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BusSolnOrdSubscrpnBillgItemField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BusSolnOrdSubscrpnBillgItemField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessSolutionOrderService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toBusinessSolutionOrder != null ) {
            (values).put("to_BusinessSolutionOrder", toBusinessSolutionOrder);
        }
        if( toPriceParameters != null ) {
            (values).put("to_PriceParameters", toPriceParameters);
        }
        if( toRateElements != null ) {
            (values).put("to_RateElements", toRateElements);
        }
        if( toSubscriptionBilling != null ) {
            (values).put("to_SubscriptionBilling", toSubscriptionBilling);
        }
        if( toSubscriptionParameters != null ) {
            (values).put("to_SubscriptionParameters", toSubscriptionParameters);
        }
        if( toSubscriptionPriceAgreements != null ) {
            (values).put("to_SubscriptionPriceAgreements", toSubscriptionPriceAgreements);
        }
        if( toUserStatus != null ) {
            (values).put("to_UserStatus", toUserStatus);
        }
        return values;
    }

    /**
     * Fetches the <b>BusinessSolutionOrder</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_BusinessSolutionOrder</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>BusinessSolutionOrder</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BusinessSolutionOrder fetchBusinessSolutionOrder()
    {
        return fetchFieldAsSingle("to_BusinessSolutionOrder", BusinessSolutionOrder.class);
    }

    /**
     * Retrieval of associated <b>BusinessSolutionOrder</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_BusinessSolutionOrder</b>.
     * <p>
     * If the navigation property <b>to_BusinessSolutionOrder</b> of a queried <b>BusSolnOrdSubscrpnBillgItem</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BusinessSolutionOrder</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BusinessSolutionOrder getBusinessSolutionOrderOrFetch()
    {
        if( toBusinessSolutionOrder == null ) {
            toBusinessSolutionOrder = fetchBusinessSolutionOrder();
        }
        return toBusinessSolutionOrder;
    }

    /**
     * Retrieval of associated <b>BusinessSolutionOrder</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_BusinessSolutionOrder</b>.
     * <p>
     * If the navigation property for an entity <b>BusSolnOrdSubscrpnBillgItem</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BusinessSolutionOrder</b> is already loaded, the result
     *         will contain the <b>BusinessSolutionOrder</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<BusinessSolutionOrder> getBusinessSolutionOrderIfPresent()
    {
        return Option.of(toBusinessSolutionOrder);
    }

    /**
     * Overwrites the associated <b>BusinessSolutionOrder</b> entity for the loaded navigation property
     * <b>to_BusinessSolutionOrder</b>.
     *
     * @param value
     *            New <b>BusinessSolutionOrder</b> entity.
     */
    public void setBusinessSolutionOrder( final BusinessSolutionOrder value )
    {
        toBusinessSolutionOrder = value;
    }

    /**
     * Fetches the <b>BusSolnOrdItmSubscrpnPrParam</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_PriceParameters</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BusSolnOrdItmSubscrpnPrParam</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusSolnOrdItmSubscrpnPrParam> fetchPriceParameters()
    {
        return fetchFieldAsList("to_PriceParameters", BusSolnOrdItmSubscrpnPrParam.class);
    }

    /**
     * Retrieval of associated <b>BusSolnOrdItmSubscrpnPrParam</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PriceParameters</b>.
     * <p>
     * If the navigation property <b>to_PriceParameters</b> of a queried <b>BusSolnOrdSubscrpnBillgItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BusSolnOrdItmSubscrpnPrParam</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusSolnOrdItmSubscrpnPrParam> getPriceParametersOrFetch()
    {
        if( toPriceParameters == null ) {
            toPriceParameters = fetchPriceParameters();
        }
        return toPriceParameters;
    }

    /**
     * Retrieval of associated <b>BusSolnOrdItmSubscrpnPrParam</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PriceParameters</b>.
     * <p>
     * If the navigation property for an entity <b>BusSolnOrdSubscrpnBillgItem</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_PriceParameters</b> is already loaded, the result will
     *         contain the <b>BusSolnOrdItmSubscrpnPrParam</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BusSolnOrdItmSubscrpnPrParam>> getPriceParametersIfPresent()
    {
        return Option.of(toPriceParameters);
    }

    /**
     * Overwrites the list of associated <b>BusSolnOrdItmSubscrpnPrParam</b> entities for the loaded navigation property
     * <b>to_PriceParameters</b>.
     * <p>
     * If the navigation property <b>to_PriceParameters</b> of a queried <b>BusSolnOrdSubscrpnBillgItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BusSolnOrdItmSubscrpnPrParam</b> entities.
     */
    public void setPriceParameters( @Nonnull final List<BusSolnOrdItmSubscrpnPrParam> value )
    {
        if( toPriceParameters == null ) {
            toPriceParameters = Lists.newArrayList();
        }
        toPriceParameters.clear();
        toPriceParameters.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BusSolnOrdItmSubscrpnPrParam</b> entities. This corresponds to the
     * OData navigation property <b>to_PriceParameters</b>.
     * <p>
     * If the navigation property <b>to_PriceParameters</b> of a queried <b>BusSolnOrdSubscrpnBillgItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BusSolnOrdItmSubscrpnPrParam</b> entities.
     */
    public void addPriceParameters( BusSolnOrdItmSubscrpnPrParam... entity )
    {
        if( toPriceParameters == null ) {
            toPriceParameters = Lists.newArrayList();
        }
        toPriceParameters.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>BusSolnOrdItmRateElement</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_RateElements</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BusSolnOrdItmRateElement</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusSolnOrdItmRateElement> fetchRateElements()
    {
        return fetchFieldAsList("to_RateElements", BusSolnOrdItmRateElement.class);
    }

    /**
     * Retrieval of associated <b>BusSolnOrdItmRateElement</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RateElements</b>.
     * <p>
     * If the navigation property <b>to_RateElements</b> of a queried <b>BusSolnOrdSubscrpnBillgItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BusSolnOrdItmRateElement</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusSolnOrdItmRateElement> getRateElementsOrFetch()
    {
        if( toRateElements == null ) {
            toRateElements = fetchRateElements();
        }
        return toRateElements;
    }

    /**
     * Retrieval of associated <b>BusSolnOrdItmRateElement</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RateElements</b>.
     * <p>
     * If the navigation property for an entity <b>BusSolnOrdSubscrpnBillgItem</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_RateElements</b> is already loaded, the result will
     *         contain the <b>BusSolnOrdItmRateElement</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BusSolnOrdItmRateElement>> getRateElementsIfPresent()
    {
        return Option.of(toRateElements);
    }

    /**
     * Overwrites the list of associated <b>BusSolnOrdItmRateElement</b> entities for the loaded navigation property
     * <b>to_RateElements</b>.
     * <p>
     * If the navigation property <b>to_RateElements</b> of a queried <b>BusSolnOrdSubscrpnBillgItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BusSolnOrdItmRateElement</b> entities.
     */
    public void setRateElements( @Nonnull final List<BusSolnOrdItmRateElement> value )
    {
        if( toRateElements == null ) {
            toRateElements = Lists.newArrayList();
        }
        toRateElements.clear();
        toRateElements.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BusSolnOrdItmRateElement</b> entities. This corresponds to the OData
     * navigation property <b>to_RateElements</b>.
     * <p>
     * If the navigation property <b>to_RateElements</b> of a queried <b>BusSolnOrdSubscrpnBillgItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BusSolnOrdItmRateElement</b> entities.
     */
    public void addRateElements( BusSolnOrdItmRateElement... entity )
    {
        if( toRateElements == null ) {
            toRateElements = Lists.newArrayList();
        }
        toRateElements.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>BusSolnOrdItmFUPSubscrpn</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_SubscriptionBilling</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BusSolnOrdItmFUPSubscrpn</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusSolnOrdItmFUPSubscrpn> fetchSubscriptionBilling()
    {
        return fetchFieldAsList("to_SubscriptionBilling", BusSolnOrdItmFUPSubscrpn.class);
    }

    /**
     * Retrieval of associated <b>BusSolnOrdItmFUPSubscrpn</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SubscriptionBilling</b>.
     * <p>
     * If the navigation property <b>to_SubscriptionBilling</b> of a queried <b>BusSolnOrdSubscrpnBillgItem</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BusSolnOrdItmFUPSubscrpn</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusSolnOrdItmFUPSubscrpn> getSubscriptionBillingOrFetch()
    {
        if( toSubscriptionBilling == null ) {
            toSubscriptionBilling = fetchSubscriptionBilling();
        }
        return toSubscriptionBilling;
    }

    /**
     * Retrieval of associated <b>BusSolnOrdItmFUPSubscrpn</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SubscriptionBilling</b>.
     * <p>
     * If the navigation property for an entity <b>BusSolnOrdSubscrpnBillgItem</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SubscriptionBilling</b> is already loaded, the result
     *         will contain the <b>BusSolnOrdItmFUPSubscrpn</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BusSolnOrdItmFUPSubscrpn>> getSubscriptionBillingIfPresent()
    {
        return Option.of(toSubscriptionBilling);
    }

    /**
     * Overwrites the list of associated <b>BusSolnOrdItmFUPSubscrpn</b> entities for the loaded navigation property
     * <b>to_SubscriptionBilling</b>.
     * <p>
     * If the navigation property <b>to_SubscriptionBilling</b> of a queried <b>BusSolnOrdSubscrpnBillgItem</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BusSolnOrdItmFUPSubscrpn</b> entities.
     */
    public void setSubscriptionBilling( @Nonnull final List<BusSolnOrdItmFUPSubscrpn> value )
    {
        if( toSubscriptionBilling == null ) {
            toSubscriptionBilling = Lists.newArrayList();
        }
        toSubscriptionBilling.clear();
        toSubscriptionBilling.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BusSolnOrdItmFUPSubscrpn</b> entities. This corresponds to the OData
     * navigation property <b>to_SubscriptionBilling</b>.
     * <p>
     * If the navigation property <b>to_SubscriptionBilling</b> of a queried <b>BusSolnOrdSubscrpnBillgItem</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BusSolnOrdItmFUPSubscrpn</b> entities.
     */
    public void addSubscriptionBilling( BusSolnOrdItmFUPSubscrpn... entity )
    {
        if( toSubscriptionBilling == null ) {
            toSubscriptionBilling = Lists.newArrayList();
        }
        toSubscriptionBilling.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>BusSolnOrdItmSubscrpnParam</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_SubscriptionParameters</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BusSolnOrdItmSubscrpnParam</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusSolnOrdItmSubscrpnParam> fetchSubscriptionParameters()
    {
        return fetchFieldAsList("to_SubscriptionParameters", BusSolnOrdItmSubscrpnParam.class);
    }

    /**
     * Retrieval of associated <b>BusSolnOrdItmSubscrpnParam</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SubscriptionParameters</b>.
     * <p>
     * If the navigation property <b>to_SubscriptionParameters</b> of a queried <b>BusSolnOrdSubscrpnBillgItem</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BusSolnOrdItmSubscrpnParam</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusSolnOrdItmSubscrpnParam> getSubscriptionParametersOrFetch()
    {
        if( toSubscriptionParameters == null ) {
            toSubscriptionParameters = fetchSubscriptionParameters();
        }
        return toSubscriptionParameters;
    }

    /**
     * Retrieval of associated <b>BusSolnOrdItmSubscrpnParam</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SubscriptionParameters</b>.
     * <p>
     * If the navigation property for an entity <b>BusSolnOrdSubscrpnBillgItem</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SubscriptionParameters</b> is already loaded, the result
     *         will contain the <b>BusSolnOrdItmSubscrpnParam</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BusSolnOrdItmSubscrpnParam>> getSubscriptionParametersIfPresent()
    {
        return Option.of(toSubscriptionParameters);
    }

    /**
     * Overwrites the list of associated <b>BusSolnOrdItmSubscrpnParam</b> entities for the loaded navigation property
     * <b>to_SubscriptionParameters</b>.
     * <p>
     * If the navigation property <b>to_SubscriptionParameters</b> of a queried <b>BusSolnOrdSubscrpnBillgItem</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BusSolnOrdItmSubscrpnParam</b> entities.
     */
    public void setSubscriptionParameters( @Nonnull final List<BusSolnOrdItmSubscrpnParam> value )
    {
        if( toSubscriptionParameters == null ) {
            toSubscriptionParameters = Lists.newArrayList();
        }
        toSubscriptionParameters.clear();
        toSubscriptionParameters.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BusSolnOrdItmSubscrpnParam</b> entities. This corresponds to the OData
     * navigation property <b>to_SubscriptionParameters</b>.
     * <p>
     * If the navigation property <b>to_SubscriptionParameters</b> of a queried <b>BusSolnOrdSubscrpnBillgItem</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BusSolnOrdItmSubscrpnParam</b> entities.
     */
    public void addSubscriptionParameters( BusSolnOrdItmSubscrpnParam... entity )
    {
        if( toSubscriptionParameters == null ) {
            toSubscriptionParameters = Lists.newArrayList();
        }
        toSubscriptionParameters.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>BusSolnOrdItmSubscrpnPrAgrmt</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_SubscriptionPriceAgreements</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BusSolnOrdItmSubscrpnPrAgrmt</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusSolnOrdItmSubscrpnPrAgrmt> fetchSubscriptionPriceAgreements()
    {
        return fetchFieldAsList("to_SubscriptionPriceAgreements", BusSolnOrdItmSubscrpnPrAgrmt.class);
    }

    /**
     * Retrieval of associated <b>BusSolnOrdItmSubscrpnPrAgrmt</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SubscriptionPriceAgreements</b>.
     * <p>
     * If the navigation property <b>to_SubscriptionPriceAgreements</b> of a queried <b>BusSolnOrdSubscrpnBillgItem</b>
     * is operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BusSolnOrdItmSubscrpnPrAgrmt</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusSolnOrdItmSubscrpnPrAgrmt> getSubscriptionPriceAgreementsOrFetch()
    {
        if( toSubscriptionPriceAgreements == null ) {
            toSubscriptionPriceAgreements = fetchSubscriptionPriceAgreements();
        }
        return toSubscriptionPriceAgreements;
    }

    /**
     * Retrieval of associated <b>BusSolnOrdItmSubscrpnPrAgrmt</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SubscriptionPriceAgreements</b>.
     * <p>
     * If the navigation property for an entity <b>BusSolnOrdSubscrpnBillgItem</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SubscriptionPriceAgreements</b> is already loaded, the
     *         result will contain the <b>BusSolnOrdItmSubscrpnPrAgrmt</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BusSolnOrdItmSubscrpnPrAgrmt>> getSubscriptionPriceAgreementsIfPresent()
    {
        return Option.of(toSubscriptionPriceAgreements);
    }

    /**
     * Overwrites the list of associated <b>BusSolnOrdItmSubscrpnPrAgrmt</b> entities for the loaded navigation property
     * <b>to_SubscriptionPriceAgreements</b>.
     * <p>
     * If the navigation property <b>to_SubscriptionPriceAgreements</b> of a queried <b>BusSolnOrdSubscrpnBillgItem</b>
     * is operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BusSolnOrdItmSubscrpnPrAgrmt</b> entities.
     */
    public void setSubscriptionPriceAgreements( @Nonnull final List<BusSolnOrdItmSubscrpnPrAgrmt> value )
    {
        if( toSubscriptionPriceAgreements == null ) {
            toSubscriptionPriceAgreements = Lists.newArrayList();
        }
        toSubscriptionPriceAgreements.clear();
        toSubscriptionPriceAgreements.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BusSolnOrdItmSubscrpnPrAgrmt</b> entities. This corresponds to the
     * OData navigation property <b>to_SubscriptionPriceAgreements</b>.
     * <p>
     * If the navigation property <b>to_SubscriptionPriceAgreements</b> of a queried <b>BusSolnOrdSubscrpnBillgItem</b>
     * is operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BusSolnOrdItmSubscrpnPrAgrmt</b> entities.
     */
    public void addSubscriptionPriceAgreements( BusSolnOrdItmSubscrpnPrAgrmt... entity )
    {
        if( toSubscriptionPriceAgreements == null ) {
            toSubscriptionPriceAgreements = Lists.newArrayList();
        }
        toSubscriptionPriceAgreements.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>BusSolnOrdItmUserStatus</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_UserStatus</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BusSolnOrdItmUserStatus</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusSolnOrdItmUserStatus> fetchUserStatus()
    {
        return fetchFieldAsList("to_UserStatus", BusSolnOrdItmUserStatus.class);
    }

    /**
     * Retrieval of associated <b>BusSolnOrdItmUserStatus</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_UserStatus</b>.
     * <p>
     * If the navigation property <b>to_UserStatus</b> of a queried <b>BusSolnOrdSubscrpnBillgItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BusSolnOrdItmUserStatus</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusSolnOrdItmUserStatus> getUserStatusOrFetch()
    {
        if( toUserStatus == null ) {
            toUserStatus = fetchUserStatus();
        }
        return toUserStatus;
    }

    /**
     * Retrieval of associated <b>BusSolnOrdItmUserStatus</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_UserStatus</b>.
     * <p>
     * If the navigation property for an entity <b>BusSolnOrdSubscrpnBillgItem</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_UserStatus</b> is already loaded, the result will
     *         contain the <b>BusSolnOrdItmUserStatus</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BusSolnOrdItmUserStatus>> getUserStatusIfPresent()
    {
        return Option.of(toUserStatus);
    }

    /**
     * Overwrites the list of associated <b>BusSolnOrdItmUserStatus</b> entities for the loaded navigation property
     * <b>to_UserStatus</b>.
     * <p>
     * If the navigation property <b>to_UserStatus</b> of a queried <b>BusSolnOrdSubscrpnBillgItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BusSolnOrdItmUserStatus</b> entities.
     */
    public void setUserStatus( @Nonnull final List<BusSolnOrdItmUserStatus> value )
    {
        if( toUserStatus == null ) {
            toUserStatus = Lists.newArrayList();
        }
        toUserStatus.clear();
        toUserStatus.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BusSolnOrdItmUserStatus</b> entities. This corresponds to the OData
     * navigation property <b>to_UserStatus</b>.
     * <p>
     * If the navigation property <b>to_UserStatus</b> of a queried <b>BusSolnOrdSubscrpnBillgItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BusSolnOrdItmUserStatus</b> entities.
     */
    public void addUserStatus( BusSolnOrdItmUserStatus... entity )
    {
        if( toUserStatus == null ) {
            toUserStatus = Lists.newArrayList();
        }
        toUserStatus.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of BusSolnOrdSubscrpnBillgItem instances.
     *
     */
    public final static class BusSolnOrdSubscrpnBillgItemBuilder
    {

        private BusinessSolutionOrder toBusinessSolutionOrder;
        private String businessSolutionOrder = null;
        private List<BusSolnOrdItmSubscrpnPrParam> toPriceParameters = Lists.newArrayList();
        private List<BusSolnOrdItmRateElement> toRateElements = Lists.newArrayList();
        private List<BusSolnOrdItmFUPSubscrpn> toSubscriptionBilling = Lists.newArrayList();
        private List<BusSolnOrdItmSubscrpnParam> toSubscriptionParameters = Lists.newArrayList();
        private List<BusSolnOrdItmSubscrpnPrAgrmt> toSubscriptionPriceAgreements = Lists.newArrayList();
        private List<BusSolnOrdItmUserStatus> toUserStatus = Lists.newArrayList();

        private BusSolnOrdSubscrpnBillgItem.BusSolnOrdSubscrpnBillgItemBuilder toBusinessSolutionOrder(
            final BusinessSolutionOrder value )
        {
            toBusinessSolutionOrder = value;
            return this;
        }

        /**
         * Navigation property <b>to_BusinessSolutionOrder</b> for <b>BusSolnOrdSubscrpnBillgItem</b> to single
         * <b>BusinessSolutionOrder</b>.
         *
         * @param value
         *            The BusinessSolutionOrder to build this BusSolnOrdSubscrpnBillgItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusSolnOrdSubscrpnBillgItem.BusSolnOrdSubscrpnBillgItemBuilder businessSolutionOrder(
            final BusinessSolutionOrder value )
        {
            return toBusinessSolutionOrder(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 10
         * <p>
         * Original property name from the Odata EDM: <b>BusinessSolutionOrder</b>
         * </p>
         *
         * @param value
         *            The businessSolutionOrder to build this BusSolnOrdSubscrpnBillgItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusSolnOrdSubscrpnBillgItem.BusSolnOrdSubscrpnBillgItemBuilder businessSolutionOrder(
            final String value )
        {
            businessSolutionOrder = value;
            return this;
        }

        private BusSolnOrdSubscrpnBillgItem.BusSolnOrdSubscrpnBillgItemBuilder toPriceParameters(
            final List<BusSolnOrdItmSubscrpnPrParam> value )
        {
            toPriceParameters.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_PriceParameters</b> for <b>BusSolnOrdSubscrpnBillgItem</b> to multiple
         * <b>BusSolnOrdItmSubscrpnPrParam</b>.
         *
         * @param value
         *            The BusSolnOrdItmSubscrpnPrParams to build this BusSolnOrdSubscrpnBillgItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusSolnOrdSubscrpnBillgItem.BusSolnOrdSubscrpnBillgItemBuilder priceParameters(
            BusSolnOrdItmSubscrpnPrParam... value )
        {
            return toPriceParameters(Lists.newArrayList(value));
        }

        private BusSolnOrdSubscrpnBillgItem.BusSolnOrdSubscrpnBillgItemBuilder toRateElements(
            final List<BusSolnOrdItmRateElement> value )
        {
            toRateElements.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_RateElements</b> for <b>BusSolnOrdSubscrpnBillgItem</b> to multiple
         * <b>BusSolnOrdItmRateElement</b>.
         *
         * @param value
         *            The BusSolnOrdItmRateElements to build this BusSolnOrdSubscrpnBillgItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusSolnOrdSubscrpnBillgItem.BusSolnOrdSubscrpnBillgItemBuilder rateElements(
            BusSolnOrdItmRateElement... value )
        {
            return toRateElements(Lists.newArrayList(value));
        }

        private BusSolnOrdSubscrpnBillgItem.BusSolnOrdSubscrpnBillgItemBuilder toSubscriptionBilling(
            final List<BusSolnOrdItmFUPSubscrpn> value )
        {
            toSubscriptionBilling.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_SubscriptionBilling</b> for <b>BusSolnOrdSubscrpnBillgItem</b> to multiple
         * <b>BusSolnOrdItmFUPSubscrpn</b>.
         *
         * @param value
         *            The BusSolnOrdItmFUPSubscrpns to build this BusSolnOrdSubscrpnBillgItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusSolnOrdSubscrpnBillgItem.BusSolnOrdSubscrpnBillgItemBuilder subscriptionBilling(
            BusSolnOrdItmFUPSubscrpn... value )
        {
            return toSubscriptionBilling(Lists.newArrayList(value));
        }

        private BusSolnOrdSubscrpnBillgItem.BusSolnOrdSubscrpnBillgItemBuilder toSubscriptionParameters(
            final List<BusSolnOrdItmSubscrpnParam> value )
        {
            toSubscriptionParameters.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_SubscriptionParameters</b> for <b>BusSolnOrdSubscrpnBillgItem</b> to multiple
         * <b>BusSolnOrdItmSubscrpnParam</b>.
         *
         * @param value
         *            The BusSolnOrdItmSubscrpnParams to build this BusSolnOrdSubscrpnBillgItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusSolnOrdSubscrpnBillgItem.BusSolnOrdSubscrpnBillgItemBuilder subscriptionParameters(
            BusSolnOrdItmSubscrpnParam... value )
        {
            return toSubscriptionParameters(Lists.newArrayList(value));
        }

        private BusSolnOrdSubscrpnBillgItem.BusSolnOrdSubscrpnBillgItemBuilder toSubscriptionPriceAgreements(
            final List<BusSolnOrdItmSubscrpnPrAgrmt> value )
        {
            toSubscriptionPriceAgreements.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_SubscriptionPriceAgreements</b> for <b>BusSolnOrdSubscrpnBillgItem</b> to multiple
         * <b>BusSolnOrdItmSubscrpnPrAgrmt</b>.
         *
         * @param value
         *            The BusSolnOrdItmSubscrpnPrAgrmts to build this BusSolnOrdSubscrpnBillgItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusSolnOrdSubscrpnBillgItem.BusSolnOrdSubscrpnBillgItemBuilder subscriptionPriceAgreements(
            BusSolnOrdItmSubscrpnPrAgrmt... value )
        {
            return toSubscriptionPriceAgreements(Lists.newArrayList(value));
        }

        private BusSolnOrdSubscrpnBillgItem.BusSolnOrdSubscrpnBillgItemBuilder toUserStatus(
            final List<BusSolnOrdItmUserStatus> value )
        {
            toUserStatus.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_UserStatus</b> for <b>BusSolnOrdSubscrpnBillgItem</b> to multiple
         * <b>BusSolnOrdItmUserStatus</b>.
         *
         * @param value
         *            The BusSolnOrdItmUserStatuss to build this BusSolnOrdSubscrpnBillgItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusSolnOrdSubscrpnBillgItem.BusSolnOrdSubscrpnBillgItemBuilder userStatus(
            BusSolnOrdItmUserStatus... value )
        {
            return toUserStatus(Lists.newArrayList(value));
        }

    }

}
