/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.selectable.BusSolnOrdUserStatusSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdUserStatus
 * BusSolnOrdUserStatus} entity using key fields. This fluent helper allows methods which modify the underlying query to
 * be called before executing the query itself.
 *
 */
public class BusSolnOrdUserStatusByKeyFluentHelper
    extends
    FluentHelperByKey<BusSolnOrdUserStatusByKeyFluentHelper, BusSolnOrdUserStatus, BusSolnOrdUserStatusSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdUserStatus
     * BusSolnOrdUserStatus} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code BusSolnOrdUserStatus}
     * @param userStatus
     *            Object Status
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     * @param businessSolutionOrder
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code BusSolnOrdUserStatus}
     */
    public BusSolnOrdUserStatusByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String businessSolutionOrder,
        final String userStatus )
    {
        super(servicePath, entityCollection);
        this.key.put("BusinessSolutionOrder", businessSolutionOrder);
        this.key.put("UserStatus", userStatus);
    }

    @Override
    @Nonnull
    protected Class<BusSolnOrdUserStatus> getEntityClass()
    {
        return BusSolnOrdUserStatus.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
