/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.field.BusSolnOrderExpenseItemField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.link.BusSolnOrderExpenseItemLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.link.BusSolnOrderExpenseItemOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.selectable.BusSolnOrderExpenseItemSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Expense Item
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_BusSolnOrderExpenseItemType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BusSolnOrderExpenseItem extends VdmEntity<BusSolnOrderExpenseItem>
{

    /**
     * Selector for all available fields of BusSolnOrderExpenseItem.
     *
     */
    public final static BusSolnOrderExpenseItemSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BusinessSolutionOrder</b>
     * </p>
     *
     * @return Transaction ID
     */
    @Key
    @SerializedName( "BusinessSolutionOrder" )
    @JsonProperty( "BusinessSolutionOrder" )
    @Nullable
    @ODataField( odataName = "BusinessSolutionOrder" )
    private String businessSolutionOrder;
    /**
     * Use with available fluent helpers to apply the <b>BusinessSolutionOrder</b> field to query operations.
     *
     */
    public final static BusSolnOrderExpenseItemField<String> BUSINESS_SOLUTION_ORDER =
        new BusSolnOrderExpenseItemField<String>("BusinessSolutionOrder");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BusinessSolutionOrderItem</b>
     * </p>
     *
     * @return Shortened Item Number in Document
     */
    @Key
    @SerializedName( "BusinessSolutionOrderItem" )
    @JsonProperty( "BusinessSolutionOrderItem" )
    @Nullable
    @ODataField( odataName = "BusinessSolutionOrderItem" )
    private String businessSolutionOrderItem;
    /**
     * Use with available fluent helpers to apply the <b>BusinessSolutionOrderItem</b> field to query operations.
     *
     */
    public final static BusSolnOrderExpenseItemField<String> BUSINESS_SOLUTION_ORDER_ITEM =
        new BusSolnOrderExpenseItemField<String>("BusinessSolutionOrderItem");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocumentItemCharUUID</b>
     * </p>
     *
     * @return 32 Character CRM Object GUID (Converted)
     */
    @SerializedName( "ServiceDocumentItemCharUUID" )
    @JsonProperty( "ServiceDocumentItemCharUUID" )
    @Nullable
    @ODataField( odataName = "ServiceDocumentItemCharUUID" )
    private UUID serviceDocumentItemCharUUID;
    /**
     * Use with available fluent helpers to apply the <b>ServiceDocumentItemCharUUID</b> field to query operations.
     *
     */
    public final static BusSolnOrderExpenseItemField<UUID> SERVICE_DOCUMENT_ITEM_CHAR_UUID =
        new BusSolnOrderExpenseItemField<UUID>("ServiceDocumentItemCharUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BusinessSolutionOrderItemUUID</b>
     * </p>
     *
     * @return GUID of a CRM Order Object
     */
    @SerializedName( "BusinessSolutionOrderItemUUID" )
    @JsonProperty( "BusinessSolutionOrderItemUUID" )
    @Nullable
    @ODataField( odataName = "BusinessSolutionOrderItemUUID" )
    private UUID businessSolutionOrderItemUUID;
    /**
     * Use with available fluent helpers to apply the <b>BusinessSolutionOrderItemUUID</b> field to query operations.
     *
     */
    public final static BusSolnOrderExpenseItemField<UUID> BUSINESS_SOLUTION_ORDER_ITEM_UUID =
        new BusSolnOrderExpenseItemField<UUID>("BusinessSolutionOrderItemUUID");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmCategory</b>
     * </p>
     *
     * @return Item Category
     */
    @SerializedName( "BusSolnOrdItmCategory" )
    @JsonProperty( "BusSolnOrdItmCategory" )
    @Nullable
    @ODataField( odataName = "BusSolnOrdItmCategory" )
    private String busSolnOrdItmCategory;
    /**
     * Use with available fluent helpers to apply the <b>BusSolnOrdItmCategory</b> field to query operations.
     *
     */
    public final static BusSolnOrderExpenseItemField<String> BUS_SOLN_ORD_ITM_CATEGORY =
        new BusSolnOrderExpenseItemField<String>("BusSolnOrdItmCategory");
    /**
     * Constraints: Not nullable, Maximum length: 54
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @return Product Name Entered
     */
    @SerializedName( "Product" )
    @JsonProperty( "Product" )
    @Nullable
    @ODataField( odataName = "Product" )
    private String product;
    /**
     * Use with available fluent helpers to apply the <b>Product</b> field to query operations.
     *
     */
    public final static BusSolnOrderExpenseItemField<String> PRODUCT =
        new BusSolnOrderExpenseItemField<String>("Product");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Quantity</b>
     * </p>
     *
     * @return CRM: Order Quantity
     */
    @SerializedName( "Quantity" )
    @JsonProperty( "Quantity" )
    @Nullable
    @ODataField( odataName = "Quantity" )
    private BigDecimal quantity;
    /**
     * Use with available fluent helpers to apply the <b>Quantity</b> field to query operations.
     *
     */
    public final static BusSolnOrderExpenseItemField<BigDecimal> QUANTITY =
        new BusSolnOrderExpenseItemField<BigDecimal>("Quantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>QuantityUnit</b>
     * </p>
     *
     * @return Unit of Measure in Which the Product Is Sold
     */
    @SerializedName( "QuantityUnit" )
    @JsonProperty( "QuantityUnit" )
    @Nullable
    @ODataField( odataName = "QuantityUnit" )
    private String quantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>QuantityUnit</b> field to query operations.
     *
     */
    public final static BusSolnOrderExpenseItemField<String> QUANTITY_UNIT =
        new BusSolnOrderExpenseItemField<String>("QuantityUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmQtyUnitSAPCode</b>
     * </p>
     *
     * @return SAP Unit Code for Order Quantity
     */
    @SerializedName( "BusSolnOrdItmQtyUnitSAPCode" )
    @JsonProperty( "BusSolnOrdItmQtyUnitSAPCode" )
    @Nullable
    @ODataField( odataName = "BusSolnOrdItmQtyUnitSAPCode" )
    private String busSolnOrdItmQtyUnitSAPCode;
    /**
     * Use with available fluent helpers to apply the <b>BusSolnOrdItmQtyUnitSAPCode</b> field to query operations.
     *
     */
    public final static BusSolnOrderExpenseItemField<String> BUS_SOLN_ORD_ITM_QTY_UNIT_SAP_CODE =
        new BusSolnOrderExpenseItemField<String>("BusSolnOrdItmQtyUnitSAPCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmQtyUnitISOCode</b>
     * </p>
     *
     * @return ISO Unit Code for Order Quantity
     */
    @SerializedName( "BusSolnOrdItmQtyUnitISOCode" )
    @JsonProperty( "BusSolnOrdItmQtyUnitISOCode" )
    @Nullable
    @ODataField( odataName = "BusSolnOrdItmQtyUnitISOCode" )
    private String busSolnOrdItmQtyUnitISOCode;
    /**
     * Use with available fluent helpers to apply the <b>BusSolnOrdItmQtyUnitISOCode</b> field to query operations.
     *
     */
    public final static BusSolnOrderExpenseItemField<String> BUS_SOLN_ORD_ITM_QTY_UNIT_ISO_CODE =
        new BusSolnOrderExpenseItemField<String>("BusSolnOrdItmQtyUnitISOCode");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmDescription</b>
     * </p>
     *
     * @return Product Description
     */
    @SerializedName( "BusSolnOrdItmDescription" )
    @JsonProperty( "BusSolnOrdItmDescription" )
    @Nullable
    @ODataField( odataName = "BusSolnOrdItmDescription" )
    private String busSolnOrdItmDescription;
    /**
     * Use with available fluent helpers to apply the <b>BusSolnOrdItmDescription</b> field to query operations.
     *
     */
    public final static BusSolnOrderExpenseItemField<String> BUS_SOLN_ORD_ITM_DESCRIPTION =
        new BusSolnOrderExpenseItemField<String>("BusSolnOrdItmDescription");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Short Text Language for an Item
     */
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static BusSolnOrderExpenseItemField<String> LANGUAGE =
        new BusSolnOrderExpenseItemField<String>("Language");
    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmExtReference</b>
     * </p>
     *
     * @return External Reference Number
     */
    @SerializedName( "BusSolnOrdItmExtReference" )
    @JsonProperty( "BusSolnOrdItmExtReference" )
    @Nullable
    @ODataField( odataName = "BusSolnOrdItmExtReference" )
    private String busSolnOrdItmExtReference;
    /**
     * Use with available fluent helpers to apply the <b>BusSolnOrdItmExtReference</b> field to query operations.
     *
     */
    public final static BusSolnOrderExpenseItemField<String> BUS_SOLN_ORD_ITM_EXT_REFERENCE =
        new BusSolnOrderExpenseItemField<String>("BusSolnOrdItmExtReference");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemOrderProbabilityInPercent</b>
     * </p>
     *
     * @return Order Probability
     */
    @SerializedName( "ItemOrderProbabilityInPercent" )
    @JsonProperty( "ItemOrderProbabilityInPercent" )
    @Nullable
    @ODataField( odataName = "ItemOrderProbabilityInPercent" )
    private String itemOrderProbabilityInPercent;
    /**
     * Use with available fluent helpers to apply the <b>ItemOrderProbabilityInPercent</b> field to query operations.
     *
     */
    public final static BusSolnOrderExpenseItemField<String> ITEM_ORDER_PROBABILITY_IN_PERCENT =
        new BusSolnOrderExpenseItemField<String>("ItemOrderProbabilityInPercent");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PaymentTerms</b>
     * </p>
     *
     * @return Terms of Payment
     */
    @SerializedName( "PaymentTerms" )
    @JsonProperty( "PaymentTerms" )
    @Nullable
    @ODataField( odataName = "PaymentTerms" )
    private String paymentTerms;
    /**
     * Use with available fluent helpers to apply the <b>PaymentTerms</b> field to query operations.
     *
     */
    public final static BusSolnOrderExpenseItemField<String> PAYMENT_TERMS =
        new BusSolnOrderExpenseItemField<String>("PaymentTerms");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BillableControl</b>
     * </p>
     *
     * @return Accounting Indicator
     */
    @SerializedName( "BillableControl" )
    @JsonProperty( "BillableControl" )
    @Nullable
    @ODataField( odataName = "BillableControl" )
    private String billableControl;
    /**
     * Use with available fluent helpers to apply the <b>BillableControl</b> field to query operations.
     *
     */
    public final static BusSolnOrderExpenseItemField<String> BILLABLE_CONTROL =
        new BusSolnOrderExpenseItemField<String>("BillableControl");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocumentItemNetAmount</b>
     * </p>
     *
     * @return Net Value
     */
    @SerializedName( "ServiceDocumentItemNetAmount" )
    @JsonProperty( "ServiceDocumentItemNetAmount" )
    @Nullable
    @ODataField( odataName = "ServiceDocumentItemNetAmount" )
    private BigDecimal serviceDocumentItemNetAmount;
    /**
     * Use with available fluent helpers to apply the <b>ServiceDocumentItemNetAmount</b> field to query operations.
     *
     */
    public final static BusSolnOrderExpenseItemField<BigDecimal> SERVICE_DOCUMENT_ITEM_NET_AMOUNT =
        new BusSolnOrderExpenseItemField<BigDecimal>("ServiceDocumentItemNetAmount");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @return Currency
     */
    @SerializedName( "TransactionCurrency" )
    @JsonProperty( "TransactionCurrency" )
    @Nullable
    @ODataField( odataName = "TransactionCurrency" )
    private String transactionCurrency;
    /**
     * Use with available fluent helpers to apply the <b>TransactionCurrency</b> field to query operations.
     *
     */
    public final static BusSolnOrderExpenseItemField<String> TRANSACTION_CURRENCY =
        new BusSolnOrderExpenseItemField<String>("TransactionCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmIsCompleted</b>
     * </p>
     *
     * @return The busSolnOrdItmIsCompleted contained in this entity.
     */
    @SerializedName( "BusSolnOrdItmIsCompleted" )
    @JsonProperty( "BusSolnOrdItmIsCompleted" )
    @Nullable
    @ODataField( odataName = "BusSolnOrdItmIsCompleted" )
    private String busSolnOrdItmIsCompleted;
    /**
     * Use with available fluent helpers to apply the <b>BusSolnOrdItmIsCompleted</b> field to query operations.
     *
     */
    public final static BusSolnOrderExpenseItemField<String> BUS_SOLN_ORD_ITM_IS_COMPLETED =
        new BusSolnOrderExpenseItemField<String>("BusSolnOrdItmIsCompleted");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmIsReleased</b>
     * </p>
     *
     * @return Release Status
     */
    @SerializedName( "BusSolnOrdItmIsReleased" )
    @JsonProperty( "BusSolnOrdItmIsReleased" )
    @Nullable
    @ODataField( odataName = "BusSolnOrdItmIsReleased" )
    private String busSolnOrdItmIsReleased;
    /**
     * Use with available fluent helpers to apply the <b>BusSolnOrdItmIsReleased</b> field to query operations.
     *
     */
    public final static BusSolnOrderExpenseItemField<String> BUS_SOLN_ORD_ITM_IS_RELEASED =
        new BusSolnOrderExpenseItemField<String>("BusSolnOrdItmIsReleased");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmIsRejected</b>
     * </p>
     *
     * @return Cancellation Status
     */
    @SerializedName( "BusSolnOrdItmIsRejected" )
    @JsonProperty( "BusSolnOrdItmIsRejected" )
    @Nullable
    @ODataField( odataName = "BusSolnOrdItmIsRejected" )
    private String busSolnOrdItmIsRejected;
    /**
     * Use with available fluent helpers to apply the <b>BusSolnOrdItmIsRejected</b> field to query operations.
     *
     */
    public final static BusSolnOrderExpenseItemField<String> BUS_SOLN_ORD_ITM_IS_REJECTED =
        new BusSolnOrderExpenseItemField<String>("BusSolnOrdItmIsRejected");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmDistrStatus</b>
     * </p>
     *
     * @return The busSolnOrdItmDistrStatus contained in this entity.
     */
    @SerializedName( "BusSolnOrdItmDistrStatus" )
    @JsonProperty( "BusSolnOrdItmDistrStatus" )
    @Nullable
    @ODataField( odataName = "BusSolnOrdItmDistrStatus" )
    private String busSolnOrdItmDistrStatus;
    /**
     * Use with available fluent helpers to apply the <b>BusSolnOrdItmDistrStatus</b> field to query operations.
     *
     */
    public final static BusSolnOrderExpenseItemField<String> BUS_SOLN_ORD_ITM_DISTR_STATUS =
        new BusSolnOrderExpenseItemField<String>("BusSolnOrdItmDistrStatus");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmDistrStatusName</b>
     * </p>
     *
     * @return The busSolnOrdItmDistrStatusName contained in this entity.
     */
    @SerializedName( "BusSolnOrdItmDistrStatusName" )
    @JsonProperty( "BusSolnOrdItmDistrStatusName" )
    @Nullable
    @ODataField( odataName = "BusSolnOrdItmDistrStatusName" )
    private String busSolnOrdItmDistrStatusName;
    /**
     * Use with available fluent helpers to apply the <b>BusSolnOrdItmDistrStatusName</b> field to query operations.
     *
     */
    public final static BusSolnOrderExpenseItemField<String> BUS_SOLN_ORD_ITM_DISTR_STATUS_NAME =
        new BusSolnOrderExpenseItemField<String>("BusSolnOrdItmDistrStatusName");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmRjcnReason</b>
     * </p>
     *
     * @return Cancellation Reason Code
     */
    @SerializedName( "BusSolnOrdItmRjcnReason" )
    @JsonProperty( "BusSolnOrdItmRjcnReason" )
    @Nullable
    @ODataField( odataName = "BusSolnOrdItmRjcnReason" )
    private String busSolnOrdItmRjcnReason;
    /**
     * Use with available fluent helpers to apply the <b>BusSolnOrdItmRjcnReason</b> field to query operations.
     *
     */
    public final static BusSolnOrderExpenseItemField<String> BUS_SOLN_ORD_ITM_RJCN_REASON =
        new BusSolnOrderExpenseItemField<String>("BusSolnOrdItmRjcnReason");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmRjcnReasonText</b>
     * </p>
     *
     * @return Description
     */
    @SerializedName( "BusSolnOrdItmRjcnReasonText" )
    @JsonProperty( "BusSolnOrdItmRjcnReasonText" )
    @Nullable
    @ODataField( odataName = "BusSolnOrdItmRjcnReasonText" )
    private String busSolnOrdItmRjcnReasonText;
    /**
     * Use with available fluent helpers to apply the <b>BusSolnOrdItmRjcnReasonText</b> field to query operations.
     *
     */
    public final static BusSolnOrderExpenseItemField<String> BUS_SOLN_ORD_ITM_RJCN_REASON_TEXT =
        new BusSolnOrderExpenseItemField<String>("BusSolnOrdItmRjcnReasonText");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceServiceContract</b>
     * </p>
     *
     * @return Transaction ID
     */
    @SerializedName( "ReferenceServiceContract" )
    @JsonProperty( "ReferenceServiceContract" )
    @Nullable
    @ODataField( odataName = "ReferenceServiceContract" )
    private String referenceServiceContract;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceServiceContract</b> field to query operations.
     *
     */
    public final static BusSolnOrderExpenseItemField<String> REFERENCE_SERVICE_CONTRACT =
        new BusSolnOrderExpenseItemField<String>("ReferenceServiceContract");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceServiceContractItem</b>
     * </p>
     *
     * @return Shortened Item Number in Document
     */
    @SerializedName( "ReferenceServiceContractItem" )
    @JsonProperty( "ReferenceServiceContractItem" )
    @Nullable
    @ODataField( odataName = "ReferenceServiceContractItem" )
    private String referenceServiceContractItem;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceServiceContractItem</b> field to query operations.
     *
     */
    public final static BusSolnOrderExpenseItemField<String> REFERENCE_SERVICE_CONTRACT_ITEM =
        new BusSolnOrderExpenseItemField<String>("ReferenceServiceContractItem");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SrvcContrDetnIsSpprsd</b>
     * </p>
     *
     * @return Status Is Active
     */
    @SerializedName( "SrvcContrDetnIsSpprsd" )
    @JsonProperty( "SrvcContrDetnIsSpprsd" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "SrvcContrDetnIsSpprsd" )
    private Boolean srvcContrDetnIsSpprsd;
    /**
     * Use with available fluent helpers to apply the <b>SrvcContrDetnIsSpprsd</b> field to query operations.
     *
     */
    public final static BusSolnOrderExpenseItemField<Boolean> SRVC_CONTR_DETN_IS_SPPRSD =
        new BusSolnOrderExpenseItemField<Boolean>("SrvcContrDetnIsSpprsd");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SoldToParty</b>
     * </p>
     *
     * @return Sold-To Party
     */
    @SerializedName( "SoldToParty" )
    @JsonProperty( "SoldToParty" )
    @Nullable
    @ODataField( odataName = "SoldToParty" )
    private String soldToParty;
    /**
     * Use with available fluent helpers to apply the <b>SoldToParty</b> field to query operations.
     *
     */
    public final static BusSolnOrderExpenseItemField<String> SOLD_TO_PARTY =
        new BusSolnOrderExpenseItemField<String>("SoldToParty");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ShipToParty</b>
     * </p>
     *
     * @return Ship-To Party
     */
    @SerializedName( "ShipToParty" )
    @JsonProperty( "ShipToParty" )
    @Nullable
    @ODataField( odataName = "ShipToParty" )
    private String shipToParty;
    /**
     * Use with available fluent helpers to apply the <b>ShipToParty</b> field to query operations.
     *
     */
    public final static BusSolnOrderExpenseItemField<String> SHIP_TO_PARTY =
        new BusSolnOrderExpenseItemField<String>("ShipToParty");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BillToParty</b>
     * </p>
     *
     * @return Bill-To Party
     */
    @SerializedName( "BillToParty" )
    @JsonProperty( "BillToParty" )
    @Nullable
    @ODataField( odataName = "BillToParty" )
    private String billToParty;
    /**
     * Use with available fluent helpers to apply the <b>BillToParty</b> field to query operations.
     *
     */
    public final static BusSolnOrderExpenseItemField<String> BILL_TO_PARTY =
        new BusSolnOrderExpenseItemField<String>("BillToParty");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PayerParty</b>
     * </p>
     *
     * @return Payer
     */
    @SerializedName( "PayerParty" )
    @JsonProperty( "PayerParty" )
    @Nullable
    @ODataField( odataName = "PayerParty" )
    private String payerParty;
    /**
     * Use with available fluent helpers to apply the <b>PayerParty</b> field to query operations.
     *
     */
    public final static BusSolnOrderExpenseItemField<String> PAYER_PARTY =
        new BusSolnOrderExpenseItemField<String>("PayerParty");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PersonResponsible</b>
     * </p>
     *
     * @return Employee Responsible
     */
    @SerializedName( "PersonResponsible" )
    @JsonProperty( "PersonResponsible" )
    @Nullable
    @ODataField( odataName = "PersonResponsible" )
    private String personResponsible;
    /**
     * Use with available fluent helpers to apply the <b>PersonResponsible</b> field to query operations.
     *
     */
    public final static BusSolnOrderExpenseItemField<String> PERSON_RESPONSIBLE =
        new BusSolnOrderExpenseItemField<String>("PersonResponsible");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ContactPerson</b>
     * </p>
     *
     * @return Customer Contact Person
     */
    @SerializedName( "ContactPerson" )
    @JsonProperty( "ContactPerson" )
    @Nullable
    @ODataField( odataName = "ContactPerson" )
    private String contactPerson;
    /**
     * Use with available fluent helpers to apply the <b>ContactPerson</b> field to query operations.
     *
     */
    public final static BusSolnOrderExpenseItemField<String> CONTACT_PERSON =
        new BusSolnOrderExpenseItemField<String>("ContactPerson");
    /**
     * Navigation property <b>to_BusinessSolutionOrder</b> for <b>BusSolnOrderExpenseItem</b> to single
     * <b>BusinessSolutionOrder</b>.
     *
     */
    @SerializedName( "to_BusinessSolutionOrder" )
    @JsonProperty( "to_BusinessSolutionOrder" )
    @ODataField( odataName = "to_BusinessSolutionOrder" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private BusinessSolutionOrder toBusinessSolutionOrder;
    /**
     * Navigation property <b>to_PriceElement</b> for <b>BusSolnOrderExpenseItem</b> to multiple
     * <b>BusSolnOrderItemPriceElement</b>.
     *
     */
    @SerializedName( "to_PriceElement" )
    @JsonProperty( "to_PriceElement" )
    @ODataField( odataName = "to_PriceElement" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BusSolnOrderItemPriceElement> toPriceElement;
    /**
     * Navigation property <b>to_ReferenceObject</b> for <b>BusSolnOrderExpenseItem</b> to multiple
     * <b>BusSolnOrdItmReferenceObject</b>.
     *
     */
    @SerializedName( "to_ReferenceObject" )
    @JsonProperty( "to_ReferenceObject" )
    @ODataField( odataName = "to_ReferenceObject" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BusSolnOrdItmReferenceObject> toReferenceObject;
    /**
     * Navigation property <b>to_ServiceOrder</b> for <b>BusSolnOrderExpenseItem</b> to multiple
     * <b>BusSolnOrdItmFUPServiceOrder</b>.
     *
     */
    @SerializedName( "to_ServiceOrder" )
    @JsonProperty( "to_ServiceOrder" )
    @ODataField( odataName = "to_ServiceOrder" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BusSolnOrdItmFUPServiceOrder> toServiceOrder;
    /**
     * Navigation property <b>to_Text</b> for <b>BusSolnOrderExpenseItem</b> to multiple
     * <b>BusSolutionOrderItemText</b>.
     *
     */
    @SerializedName( "to_Text" )
    @JsonProperty( "to_Text" )
    @ODataField( odataName = "to_Text" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BusSolutionOrderItemText> toText;
    /**
     * Navigation property <b>to_UserStatus</b> for <b>BusSolnOrderExpenseItem</b> to multiple
     * <b>BusSolnOrdItmUserStatus</b>.
     *
     */
    @SerializedName( "to_UserStatus" )
    @JsonProperty( "to_UserStatus" )
    @ODataField( odataName = "to_UserStatus" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BusSolnOrdItmUserStatus> toUserStatus;
    /**
     * Use with available fluent helpers to apply the <b>to_BusinessSolutionOrder</b> navigation property to query
     * operations.
     *
     */
    public final static BusSolnOrderExpenseItemOneToOneLink<BusinessSolutionOrder> TO_BUSINESS_SOLUTION_ORDER =
        new BusSolnOrderExpenseItemOneToOneLink<BusinessSolutionOrder>("to_BusinessSolutionOrder");
    /**
     * Use with available fluent helpers to apply the <b>to_PriceElement</b> navigation property to query operations.
     *
     */
    public final static BusSolnOrderExpenseItemLink<BusSolnOrderItemPriceElement> TO_PRICE_ELEMENT =
        new BusSolnOrderExpenseItemLink<BusSolnOrderItemPriceElement>("to_PriceElement");
    /**
     * Use with available fluent helpers to apply the <b>to_ReferenceObject</b> navigation property to query operations.
     *
     */
    public final static BusSolnOrderExpenseItemLink<BusSolnOrdItmReferenceObject> TO_REFERENCE_OBJECT =
        new BusSolnOrderExpenseItemLink<BusSolnOrdItmReferenceObject>("to_ReferenceObject");
    /**
     * Use with available fluent helpers to apply the <b>to_ServiceOrder</b> navigation property to query operations.
     *
     */
    public final static BusSolnOrderExpenseItemLink<BusSolnOrdItmFUPServiceOrder> TO_SERVICE_ORDER =
        new BusSolnOrderExpenseItemLink<BusSolnOrdItmFUPServiceOrder>("to_ServiceOrder");
    /**
     * Use with available fluent helpers to apply the <b>to_Text</b> navigation property to query operations.
     *
     */
    public final static BusSolnOrderExpenseItemLink<BusSolutionOrderItemText> TO_TEXT =
        new BusSolnOrderExpenseItemLink<BusSolutionOrderItemText>("to_Text");
    /**
     * Use with available fluent helpers to apply the <b>to_UserStatus</b> navigation property to query operations.
     *
     */
    public final static BusSolnOrderExpenseItemLink<BusSolnOrdItmUserStatus> TO_USER_STATUS =
        new BusSolnOrderExpenseItemLink<BusSolnOrdItmUserStatus>("to_UserStatus");

    @Nonnull
    @Override
    public Class<BusSolnOrderExpenseItem> getType()
    {
        return BusSolnOrderExpenseItem.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BusinessSolutionOrder</b>
     * </p>
     *
     * @param businessSolutionOrder
     *            Transaction ID
     */
    public void setBusinessSolutionOrder( @Nullable final String businessSolutionOrder )
    {
        rememberChangedField("BusinessSolutionOrder", this.businessSolutionOrder);
        this.businessSolutionOrder = businessSolutionOrder;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BusinessSolutionOrderItem</b>
     * </p>
     *
     * @param businessSolutionOrderItem
     *            Shortened Item Number in Document
     */
    public void setBusinessSolutionOrderItem( @Nullable final String businessSolutionOrderItem )
    {
        rememberChangedField("BusinessSolutionOrderItem", this.businessSolutionOrderItem);
        this.businessSolutionOrderItem = businessSolutionOrderItem;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocumentItemCharUUID</b>
     * </p>
     *
     * @param serviceDocumentItemCharUUID
     *            32 Character CRM Object GUID (Converted)
     */
    public void setServiceDocumentItemCharUUID( @Nullable final UUID serviceDocumentItemCharUUID )
    {
        rememberChangedField("ServiceDocumentItemCharUUID", this.serviceDocumentItemCharUUID);
        this.serviceDocumentItemCharUUID = serviceDocumentItemCharUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BusinessSolutionOrderItemUUID</b>
     * </p>
     *
     * @param businessSolutionOrderItemUUID
     *            GUID of a CRM Order Object
     */
    public void setBusinessSolutionOrderItemUUID( @Nullable final UUID businessSolutionOrderItemUUID )
    {
        rememberChangedField("BusinessSolutionOrderItemUUID", this.businessSolutionOrderItemUUID);
        this.businessSolutionOrderItemUUID = businessSolutionOrderItemUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmCategory</b>
     * </p>
     *
     * @param busSolnOrdItmCategory
     *            Item Category
     */
    public void setBusSolnOrdItmCategory( @Nullable final String busSolnOrdItmCategory )
    {
        rememberChangedField("BusSolnOrdItmCategory", this.busSolnOrdItmCategory);
        this.busSolnOrdItmCategory = busSolnOrdItmCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 54
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @param product
     *            Product Name Entered
     */
    public void setProduct( @Nullable final String product )
    {
        rememberChangedField("Product", this.product);
        this.product = product;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Quantity</b>
     * </p>
     *
     * @param quantity
     *            CRM: Order Quantity
     */
    public void setQuantity( @Nullable final BigDecimal quantity )
    {
        rememberChangedField("Quantity", this.quantity);
        this.quantity = quantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>QuantityUnit</b>
     * </p>
     *
     * @param quantityUnit
     *            Unit of Measure in Which the Product Is Sold
     */
    public void setQuantityUnit( @Nullable final String quantityUnit )
    {
        rememberChangedField("QuantityUnit", this.quantityUnit);
        this.quantityUnit = quantityUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmQtyUnitSAPCode</b>
     * </p>
     *
     * @param busSolnOrdItmQtyUnitSAPCode
     *            SAP Unit Code for Order Quantity
     */
    public void setBusSolnOrdItmQtyUnitSAPCode( @Nullable final String busSolnOrdItmQtyUnitSAPCode )
    {
        rememberChangedField("BusSolnOrdItmQtyUnitSAPCode", this.busSolnOrdItmQtyUnitSAPCode);
        this.busSolnOrdItmQtyUnitSAPCode = busSolnOrdItmQtyUnitSAPCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmQtyUnitISOCode</b>
     * </p>
     *
     * @param busSolnOrdItmQtyUnitISOCode
     *            ISO Unit Code for Order Quantity
     */
    public void setBusSolnOrdItmQtyUnitISOCode( @Nullable final String busSolnOrdItmQtyUnitISOCode )
    {
        rememberChangedField("BusSolnOrdItmQtyUnitISOCode", this.busSolnOrdItmQtyUnitISOCode);
        this.busSolnOrdItmQtyUnitISOCode = busSolnOrdItmQtyUnitISOCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmDescription</b>
     * </p>
     *
     * @param busSolnOrdItmDescription
     *            Product Description
     */
    public void setBusSolnOrdItmDescription( @Nullable final String busSolnOrdItmDescription )
    {
        rememberChangedField("BusSolnOrdItmDescription", this.busSolnOrdItmDescription);
        this.busSolnOrdItmDescription = busSolnOrdItmDescription;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Short Text Language for an Item
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmExtReference</b>
     * </p>
     *
     * @param busSolnOrdItmExtReference
     *            External Reference Number
     */
    public void setBusSolnOrdItmExtReference( @Nullable final String busSolnOrdItmExtReference )
    {
        rememberChangedField("BusSolnOrdItmExtReference", this.busSolnOrdItmExtReference);
        this.busSolnOrdItmExtReference = busSolnOrdItmExtReference;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemOrderProbabilityInPercent</b>
     * </p>
     *
     * @param itemOrderProbabilityInPercent
     *            Order Probability
     */
    public void setItemOrderProbabilityInPercent( @Nullable final String itemOrderProbabilityInPercent )
    {
        rememberChangedField("ItemOrderProbabilityInPercent", this.itemOrderProbabilityInPercent);
        this.itemOrderProbabilityInPercent = itemOrderProbabilityInPercent;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PaymentTerms</b>
     * </p>
     *
     * @param paymentTerms
     *            Terms of Payment
     */
    public void setPaymentTerms( @Nullable final String paymentTerms )
    {
        rememberChangedField("PaymentTerms", this.paymentTerms);
        this.paymentTerms = paymentTerms;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BillableControl</b>
     * </p>
     *
     * @param billableControl
     *            Accounting Indicator
     */
    public void setBillableControl( @Nullable final String billableControl )
    {
        rememberChangedField("BillableControl", this.billableControl);
        this.billableControl = billableControl;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocumentItemNetAmount</b>
     * </p>
     *
     * @param serviceDocumentItemNetAmount
     *            Net Value
     */
    public void setServiceDocumentItemNetAmount( @Nullable final BigDecimal serviceDocumentItemNetAmount )
    {
        rememberChangedField("ServiceDocumentItemNetAmount", this.serviceDocumentItemNetAmount);
        this.serviceDocumentItemNetAmount = serviceDocumentItemNetAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @param transactionCurrency
     *            Currency
     */
    public void setTransactionCurrency( @Nullable final String transactionCurrency )
    {
        rememberChangedField("TransactionCurrency", this.transactionCurrency);
        this.transactionCurrency = transactionCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmIsCompleted</b>
     * </p>
     *
     * @param busSolnOrdItmIsCompleted
     *            The busSolnOrdItmIsCompleted to set.
     */
    public void setBusSolnOrdItmIsCompleted( @Nullable final String busSolnOrdItmIsCompleted )
    {
        rememberChangedField("BusSolnOrdItmIsCompleted", this.busSolnOrdItmIsCompleted);
        this.busSolnOrdItmIsCompleted = busSolnOrdItmIsCompleted;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmIsReleased</b>
     * </p>
     *
     * @param busSolnOrdItmIsReleased
     *            Release Status
     */
    public void setBusSolnOrdItmIsReleased( @Nullable final String busSolnOrdItmIsReleased )
    {
        rememberChangedField("BusSolnOrdItmIsReleased", this.busSolnOrdItmIsReleased);
        this.busSolnOrdItmIsReleased = busSolnOrdItmIsReleased;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmIsRejected</b>
     * </p>
     *
     * @param busSolnOrdItmIsRejected
     *            Cancellation Status
     */
    public void setBusSolnOrdItmIsRejected( @Nullable final String busSolnOrdItmIsRejected )
    {
        rememberChangedField("BusSolnOrdItmIsRejected", this.busSolnOrdItmIsRejected);
        this.busSolnOrdItmIsRejected = busSolnOrdItmIsRejected;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmDistrStatus</b>
     * </p>
     *
     * @param busSolnOrdItmDistrStatus
     *            The busSolnOrdItmDistrStatus to set.
     */
    public void setBusSolnOrdItmDistrStatus( @Nullable final String busSolnOrdItmDistrStatus )
    {
        rememberChangedField("BusSolnOrdItmDistrStatus", this.busSolnOrdItmDistrStatus);
        this.busSolnOrdItmDistrStatus = busSolnOrdItmDistrStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmDistrStatusName</b>
     * </p>
     *
     * @param busSolnOrdItmDistrStatusName
     *            The busSolnOrdItmDistrStatusName to set.
     */
    public void setBusSolnOrdItmDistrStatusName( @Nullable final String busSolnOrdItmDistrStatusName )
    {
        rememberChangedField("BusSolnOrdItmDistrStatusName", this.busSolnOrdItmDistrStatusName);
        this.busSolnOrdItmDistrStatusName = busSolnOrdItmDistrStatusName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmRjcnReason</b>
     * </p>
     *
     * @param busSolnOrdItmRjcnReason
     *            Cancellation Reason Code
     */
    public void setBusSolnOrdItmRjcnReason( @Nullable final String busSolnOrdItmRjcnReason )
    {
        rememberChangedField("BusSolnOrdItmRjcnReason", this.busSolnOrdItmRjcnReason);
        this.busSolnOrdItmRjcnReason = busSolnOrdItmRjcnReason;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmRjcnReasonText</b>
     * </p>
     *
     * @param busSolnOrdItmRjcnReasonText
     *            Description
     */
    public void setBusSolnOrdItmRjcnReasonText( @Nullable final String busSolnOrdItmRjcnReasonText )
    {
        rememberChangedField("BusSolnOrdItmRjcnReasonText", this.busSolnOrdItmRjcnReasonText);
        this.busSolnOrdItmRjcnReasonText = busSolnOrdItmRjcnReasonText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceServiceContract</b>
     * </p>
     *
     * @param referenceServiceContract
     *            Transaction ID
     */
    public void setReferenceServiceContract( @Nullable final String referenceServiceContract )
    {
        rememberChangedField("ReferenceServiceContract", this.referenceServiceContract);
        this.referenceServiceContract = referenceServiceContract;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceServiceContractItem</b>
     * </p>
     *
     * @param referenceServiceContractItem
     *            Shortened Item Number in Document
     */
    public void setReferenceServiceContractItem( @Nullable final String referenceServiceContractItem )
    {
        rememberChangedField("ReferenceServiceContractItem", this.referenceServiceContractItem);
        this.referenceServiceContractItem = referenceServiceContractItem;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SrvcContrDetnIsSpprsd</b>
     * </p>
     *
     * @param srvcContrDetnIsSpprsd
     *            Status Is Active
     */
    public void setSrvcContrDetnIsSpprsd( @Nullable final Boolean srvcContrDetnIsSpprsd )
    {
        rememberChangedField("SrvcContrDetnIsSpprsd", this.srvcContrDetnIsSpprsd);
        this.srvcContrDetnIsSpprsd = srvcContrDetnIsSpprsd;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SoldToParty</b>
     * </p>
     *
     * @param soldToParty
     *            Sold-To Party
     */
    public void setSoldToParty( @Nullable final String soldToParty )
    {
        rememberChangedField("SoldToParty", this.soldToParty);
        this.soldToParty = soldToParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ShipToParty</b>
     * </p>
     *
     * @param shipToParty
     *            Ship-To Party
     */
    public void setShipToParty( @Nullable final String shipToParty )
    {
        rememberChangedField("ShipToParty", this.shipToParty);
        this.shipToParty = shipToParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BillToParty</b>
     * </p>
     *
     * @param billToParty
     *            Bill-To Party
     */
    public void setBillToParty( @Nullable final String billToParty )
    {
        rememberChangedField("BillToParty", this.billToParty);
        this.billToParty = billToParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PayerParty</b>
     * </p>
     *
     * @param payerParty
     *            Payer
     */
    public void setPayerParty( @Nullable final String payerParty )
    {
        rememberChangedField("PayerParty", this.payerParty);
        this.payerParty = payerParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PersonResponsible</b>
     * </p>
     *
     * @param personResponsible
     *            Employee Responsible
     */
    public void setPersonResponsible( @Nullable final String personResponsible )
    {
        rememberChangedField("PersonResponsible", this.personResponsible);
        this.personResponsible = personResponsible;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ContactPerson</b>
     * </p>
     *
     * @param contactPerson
     *            Customer Contact Person
     */
    public void setContactPerson( @Nullable final String contactPerson )
    {
        rememberChangedField("ContactPerson", this.contactPerson);
        this.contactPerson = contactPerson;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_BusSolnOrderExpenseItem";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("BusinessSolutionOrder", getBusinessSolutionOrder());
        result.put("BusinessSolutionOrderItem", getBusinessSolutionOrderItem());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("BusinessSolutionOrder", getBusinessSolutionOrder());
        values.put("BusinessSolutionOrderItem", getBusinessSolutionOrderItem());
        values.put("ServiceDocumentItemCharUUID", getServiceDocumentItemCharUUID());
        values.put("BusinessSolutionOrderItemUUID", getBusinessSolutionOrderItemUUID());
        values.put("BusSolnOrdItmCategory", getBusSolnOrdItmCategory());
        values.put("Product", getProduct());
        values.put("Quantity", getQuantity());
        values.put("QuantityUnit", getQuantityUnit());
        values.put("BusSolnOrdItmQtyUnitSAPCode", getBusSolnOrdItmQtyUnitSAPCode());
        values.put("BusSolnOrdItmQtyUnitISOCode", getBusSolnOrdItmQtyUnitISOCode());
        values.put("BusSolnOrdItmDescription", getBusSolnOrdItmDescription());
        values.put("Language", getLanguage());
        values.put("BusSolnOrdItmExtReference", getBusSolnOrdItmExtReference());
        values.put("ItemOrderProbabilityInPercent", getItemOrderProbabilityInPercent());
        values.put("PaymentTerms", getPaymentTerms());
        values.put("BillableControl", getBillableControl());
        values.put("ServiceDocumentItemNetAmount", getServiceDocumentItemNetAmount());
        values.put("TransactionCurrency", getTransactionCurrency());
        values.put("BusSolnOrdItmIsCompleted", getBusSolnOrdItmIsCompleted());
        values.put("BusSolnOrdItmIsReleased", getBusSolnOrdItmIsReleased());
        values.put("BusSolnOrdItmIsRejected", getBusSolnOrdItmIsRejected());
        values.put("BusSolnOrdItmDistrStatus", getBusSolnOrdItmDistrStatus());
        values.put("BusSolnOrdItmDistrStatusName", getBusSolnOrdItmDistrStatusName());
        values.put("BusSolnOrdItmRjcnReason", getBusSolnOrdItmRjcnReason());
        values.put("BusSolnOrdItmRjcnReasonText", getBusSolnOrdItmRjcnReasonText());
        values.put("ReferenceServiceContract", getReferenceServiceContract());
        values.put("ReferenceServiceContractItem", getReferenceServiceContractItem());
        values.put("SrvcContrDetnIsSpprsd", getSrvcContrDetnIsSpprsd());
        values.put("SoldToParty", getSoldToParty());
        values.put("ShipToParty", getShipToParty());
        values.put("BillToParty", getBillToParty());
        values.put("PayerParty", getPayerParty());
        values.put("PersonResponsible", getPersonResponsible());
        values.put("ContactPerson", getContactPerson());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("BusinessSolutionOrder") ) {
                final Object value = values.remove("BusinessSolutionOrder");
                if( (value == null) || (!value.equals(getBusinessSolutionOrder())) ) {
                    setBusinessSolutionOrder(((String) value));
                }
            }
            if( values.containsKey("BusinessSolutionOrderItem") ) {
                final Object value = values.remove("BusinessSolutionOrderItem");
                if( (value == null) || (!value.equals(getBusinessSolutionOrderItem())) ) {
                    setBusinessSolutionOrderItem(((String) value));
                }
            }
            if( values.containsKey("ServiceDocumentItemCharUUID") ) {
                final Object value = values.remove("ServiceDocumentItemCharUUID");
                if( (value == null) || (!value.equals(getServiceDocumentItemCharUUID())) ) {
                    setServiceDocumentItemCharUUID(((UUID) value));
                }
            }
            if( values.containsKey("BusinessSolutionOrderItemUUID") ) {
                final Object value = values.remove("BusinessSolutionOrderItemUUID");
                if( (value == null) || (!value.equals(getBusinessSolutionOrderItemUUID())) ) {
                    setBusinessSolutionOrderItemUUID(((UUID) value));
                }
            }
            if( values.containsKey("BusSolnOrdItmCategory") ) {
                final Object value = values.remove("BusSolnOrdItmCategory");
                if( (value == null) || (!value.equals(getBusSolnOrdItmCategory())) ) {
                    setBusSolnOrdItmCategory(((String) value));
                }
            }
            if( values.containsKey("Product") ) {
                final Object value = values.remove("Product");
                if( (value == null) || (!value.equals(getProduct())) ) {
                    setProduct(((String) value));
                }
            }
            if( values.containsKey("Quantity") ) {
                final Object value = values.remove("Quantity");
                if( (value == null) || (!value.equals(getQuantity())) ) {
                    setQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("QuantityUnit") ) {
                final Object value = values.remove("QuantityUnit");
                if( (value == null) || (!value.equals(getQuantityUnit())) ) {
                    setQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("BusSolnOrdItmQtyUnitSAPCode") ) {
                final Object value = values.remove("BusSolnOrdItmQtyUnitSAPCode");
                if( (value == null) || (!value.equals(getBusSolnOrdItmQtyUnitSAPCode())) ) {
                    setBusSolnOrdItmQtyUnitSAPCode(((String) value));
                }
            }
            if( values.containsKey("BusSolnOrdItmQtyUnitISOCode") ) {
                final Object value = values.remove("BusSolnOrdItmQtyUnitISOCode");
                if( (value == null) || (!value.equals(getBusSolnOrdItmQtyUnitISOCode())) ) {
                    setBusSolnOrdItmQtyUnitISOCode(((String) value));
                }
            }
            if( values.containsKey("BusSolnOrdItmDescription") ) {
                final Object value = values.remove("BusSolnOrdItmDescription");
                if( (value == null) || (!value.equals(getBusSolnOrdItmDescription())) ) {
                    setBusSolnOrdItmDescription(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("BusSolnOrdItmExtReference") ) {
                final Object value = values.remove("BusSolnOrdItmExtReference");
                if( (value == null) || (!value.equals(getBusSolnOrdItmExtReference())) ) {
                    setBusSolnOrdItmExtReference(((String) value));
                }
            }
            if( values.containsKey("ItemOrderProbabilityInPercent") ) {
                final Object value = values.remove("ItemOrderProbabilityInPercent");
                if( (value == null) || (!value.equals(getItemOrderProbabilityInPercent())) ) {
                    setItemOrderProbabilityInPercent(((String) value));
                }
            }
            if( values.containsKey("PaymentTerms") ) {
                final Object value = values.remove("PaymentTerms");
                if( (value == null) || (!value.equals(getPaymentTerms())) ) {
                    setPaymentTerms(((String) value));
                }
            }
            if( values.containsKey("BillableControl") ) {
                final Object value = values.remove("BillableControl");
                if( (value == null) || (!value.equals(getBillableControl())) ) {
                    setBillableControl(((String) value));
                }
            }
            if( values.containsKey("ServiceDocumentItemNetAmount") ) {
                final Object value = values.remove("ServiceDocumentItemNetAmount");
                if( (value == null) || (!value.equals(getServiceDocumentItemNetAmount())) ) {
                    setServiceDocumentItemNetAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("TransactionCurrency") ) {
                final Object value = values.remove("TransactionCurrency");
                if( (value == null) || (!value.equals(getTransactionCurrency())) ) {
                    setTransactionCurrency(((String) value));
                }
            }
            if( values.containsKey("BusSolnOrdItmIsCompleted") ) {
                final Object value = values.remove("BusSolnOrdItmIsCompleted");
                if( (value == null) || (!value.equals(getBusSolnOrdItmIsCompleted())) ) {
                    setBusSolnOrdItmIsCompleted(((String) value));
                }
            }
            if( values.containsKey("BusSolnOrdItmIsReleased") ) {
                final Object value = values.remove("BusSolnOrdItmIsReleased");
                if( (value == null) || (!value.equals(getBusSolnOrdItmIsReleased())) ) {
                    setBusSolnOrdItmIsReleased(((String) value));
                }
            }
            if( values.containsKey("BusSolnOrdItmIsRejected") ) {
                final Object value = values.remove("BusSolnOrdItmIsRejected");
                if( (value == null) || (!value.equals(getBusSolnOrdItmIsRejected())) ) {
                    setBusSolnOrdItmIsRejected(((String) value));
                }
            }
            if( values.containsKey("BusSolnOrdItmDistrStatus") ) {
                final Object value = values.remove("BusSolnOrdItmDistrStatus");
                if( (value == null) || (!value.equals(getBusSolnOrdItmDistrStatus())) ) {
                    setBusSolnOrdItmDistrStatus(((String) value));
                }
            }
            if( values.containsKey("BusSolnOrdItmDistrStatusName") ) {
                final Object value = values.remove("BusSolnOrdItmDistrStatusName");
                if( (value == null) || (!value.equals(getBusSolnOrdItmDistrStatusName())) ) {
                    setBusSolnOrdItmDistrStatusName(((String) value));
                }
            }
            if( values.containsKey("BusSolnOrdItmRjcnReason") ) {
                final Object value = values.remove("BusSolnOrdItmRjcnReason");
                if( (value == null) || (!value.equals(getBusSolnOrdItmRjcnReason())) ) {
                    setBusSolnOrdItmRjcnReason(((String) value));
                }
            }
            if( values.containsKey("BusSolnOrdItmRjcnReasonText") ) {
                final Object value = values.remove("BusSolnOrdItmRjcnReasonText");
                if( (value == null) || (!value.equals(getBusSolnOrdItmRjcnReasonText())) ) {
                    setBusSolnOrdItmRjcnReasonText(((String) value));
                }
            }
            if( values.containsKey("ReferenceServiceContract") ) {
                final Object value = values.remove("ReferenceServiceContract");
                if( (value == null) || (!value.equals(getReferenceServiceContract())) ) {
                    setReferenceServiceContract(((String) value));
                }
            }
            if( values.containsKey("ReferenceServiceContractItem") ) {
                final Object value = values.remove("ReferenceServiceContractItem");
                if( (value == null) || (!value.equals(getReferenceServiceContractItem())) ) {
                    setReferenceServiceContractItem(((String) value));
                }
            }
            if( values.containsKey("SrvcContrDetnIsSpprsd") ) {
                final Object value = values.remove("SrvcContrDetnIsSpprsd");
                if( (value == null) || (!value.equals(getSrvcContrDetnIsSpprsd())) ) {
                    setSrvcContrDetnIsSpprsd(((Boolean) value));
                }
            }
            if( values.containsKey("SoldToParty") ) {
                final Object value = values.remove("SoldToParty");
                if( (value == null) || (!value.equals(getSoldToParty())) ) {
                    setSoldToParty(((String) value));
                }
            }
            if( values.containsKey("ShipToParty") ) {
                final Object value = values.remove("ShipToParty");
                if( (value == null) || (!value.equals(getShipToParty())) ) {
                    setShipToParty(((String) value));
                }
            }
            if( values.containsKey("BillToParty") ) {
                final Object value = values.remove("BillToParty");
                if( (value == null) || (!value.equals(getBillToParty())) ) {
                    setBillToParty(((String) value));
                }
            }
            if( values.containsKey("PayerParty") ) {
                final Object value = values.remove("PayerParty");
                if( (value == null) || (!value.equals(getPayerParty())) ) {
                    setPayerParty(((String) value));
                }
            }
            if( values.containsKey("PersonResponsible") ) {
                final Object value = values.remove("PersonResponsible");
                if( (value == null) || (!value.equals(getPersonResponsible())) ) {
                    setPersonResponsible(((String) value));
                }
            }
            if( values.containsKey("ContactPerson") ) {
                final Object value = values.remove("ContactPerson");
                if( (value == null) || (!value.equals(getContactPerson())) ) {
                    setContactPerson(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_BusinessSolutionOrder") ) {
                final Object value = (values).remove("to_BusinessSolutionOrder");
                if( value instanceof Map ) {
                    if( toBusinessSolutionOrder == null ) {
                        toBusinessSolutionOrder = new BusinessSolutionOrder();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toBusinessSolutionOrder.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_PriceElement") ) {
                final Object value = (values).remove("to_PriceElement");
                if( value instanceof Iterable ) {
                    if( toPriceElement == null ) {
                        toPriceElement = Lists.newArrayList();
                    } else {
                        toPriceElement = Lists.newArrayList(toPriceElement);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BusSolnOrderItemPriceElement entity;
                        if( toPriceElement.size() > i ) {
                            entity = toPriceElement.get(i);
                        } else {
                            entity = new BusSolnOrderItemPriceElement();
                            toPriceElement.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_ReferenceObject") ) {
                final Object value = (values).remove("to_ReferenceObject");
                if( value instanceof Iterable ) {
                    if( toReferenceObject == null ) {
                        toReferenceObject = Lists.newArrayList();
                    } else {
                        toReferenceObject = Lists.newArrayList(toReferenceObject);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BusSolnOrdItmReferenceObject entity;
                        if( toReferenceObject.size() > i ) {
                            entity = toReferenceObject.get(i);
                        } else {
                            entity = new BusSolnOrdItmReferenceObject();
                            toReferenceObject.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_ServiceOrder") ) {
                final Object value = (values).remove("to_ServiceOrder");
                if( value instanceof Iterable ) {
                    if( toServiceOrder == null ) {
                        toServiceOrder = Lists.newArrayList();
                    } else {
                        toServiceOrder = Lists.newArrayList(toServiceOrder);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BusSolnOrdItmFUPServiceOrder entity;
                        if( toServiceOrder.size() > i ) {
                            entity = toServiceOrder.get(i);
                        } else {
                            entity = new BusSolnOrdItmFUPServiceOrder();
                            toServiceOrder.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_Text") ) {
                final Object value = (values).remove("to_Text");
                if( value instanceof Iterable ) {
                    if( toText == null ) {
                        toText = Lists.newArrayList();
                    } else {
                        toText = Lists.newArrayList(toText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BusSolutionOrderItemText entity;
                        if( toText.size() > i ) {
                            entity = toText.get(i);
                        } else {
                            entity = new BusSolutionOrderItemText();
                            toText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_UserStatus") ) {
                final Object value = (values).remove("to_UserStatus");
                if( value instanceof Iterable ) {
                    if( toUserStatus == null ) {
                        toUserStatus = Lists.newArrayList();
                    } else {
                        toUserStatus = Lists.newArrayList(toUserStatus);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BusSolnOrdItmUserStatus entity;
                        if( toUserStatus.size() > i ) {
                            entity = toUserStatus.get(i);
                        } else {
                            entity = new BusSolnOrdItmUserStatus();
                            toUserStatus.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> BusSolnOrderExpenseItemField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new BusSolnOrderExpenseItemField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BusSolnOrderExpenseItemField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BusSolnOrderExpenseItemField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessSolutionOrderService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toBusinessSolutionOrder != null ) {
            (values).put("to_BusinessSolutionOrder", toBusinessSolutionOrder);
        }
        if( toPriceElement != null ) {
            (values).put("to_PriceElement", toPriceElement);
        }
        if( toReferenceObject != null ) {
            (values).put("to_ReferenceObject", toReferenceObject);
        }
        if( toServiceOrder != null ) {
            (values).put("to_ServiceOrder", toServiceOrder);
        }
        if( toText != null ) {
            (values).put("to_Text", toText);
        }
        if( toUserStatus != null ) {
            (values).put("to_UserStatus", toUserStatus);
        }
        return values;
    }

    /**
     * Fetches the <b>BusinessSolutionOrder</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_BusinessSolutionOrder</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>BusinessSolutionOrder</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BusinessSolutionOrder fetchBusinessSolutionOrder()
    {
        return fetchFieldAsSingle("to_BusinessSolutionOrder", BusinessSolutionOrder.class);
    }

    /**
     * Retrieval of associated <b>BusinessSolutionOrder</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_BusinessSolutionOrder</b>.
     * <p>
     * If the navigation property <b>to_BusinessSolutionOrder</b> of a queried <b>BusSolnOrderExpenseItem</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BusinessSolutionOrder</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BusinessSolutionOrder getBusinessSolutionOrderOrFetch()
    {
        if( toBusinessSolutionOrder == null ) {
            toBusinessSolutionOrder = fetchBusinessSolutionOrder();
        }
        return toBusinessSolutionOrder;
    }

    /**
     * Retrieval of associated <b>BusinessSolutionOrder</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_BusinessSolutionOrder</b>.
     * <p>
     * If the navigation property for an entity <b>BusSolnOrderExpenseItem</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BusinessSolutionOrder</b> is already loaded, the result
     *         will contain the <b>BusinessSolutionOrder</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<BusinessSolutionOrder> getBusinessSolutionOrderIfPresent()
    {
        return Option.of(toBusinessSolutionOrder);
    }

    /**
     * Overwrites the associated <b>BusinessSolutionOrder</b> entity for the loaded navigation property
     * <b>to_BusinessSolutionOrder</b>.
     *
     * @param value
     *            New <b>BusinessSolutionOrder</b> entity.
     */
    public void setBusinessSolutionOrder( final BusinessSolutionOrder value )
    {
        toBusinessSolutionOrder = value;
    }

    /**
     * Fetches the <b>BusSolnOrderItemPriceElement</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_PriceElement</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BusSolnOrderItemPriceElement</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusSolnOrderItemPriceElement> fetchPriceElement()
    {
        return fetchFieldAsList("to_PriceElement", BusSolnOrderItemPriceElement.class);
    }

    /**
     * Retrieval of associated <b>BusSolnOrderItemPriceElement</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PriceElement</b>.
     * <p>
     * If the navigation property <b>to_PriceElement</b> of a queried <b>BusSolnOrderExpenseItem</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BusSolnOrderItemPriceElement</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusSolnOrderItemPriceElement> getPriceElementOrFetch()
    {
        if( toPriceElement == null ) {
            toPriceElement = fetchPriceElement();
        }
        return toPriceElement;
    }

    /**
     * Retrieval of associated <b>BusSolnOrderItemPriceElement</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PriceElement</b>.
     * <p>
     * If the navigation property for an entity <b>BusSolnOrderExpenseItem</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_PriceElement</b> is already loaded, the result will
     *         contain the <b>BusSolnOrderItemPriceElement</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BusSolnOrderItemPriceElement>> getPriceElementIfPresent()
    {
        return Option.of(toPriceElement);
    }

    /**
     * Overwrites the list of associated <b>BusSolnOrderItemPriceElement</b> entities for the loaded navigation property
     * <b>to_PriceElement</b>.
     * <p>
     * If the navigation property <b>to_PriceElement</b> of a queried <b>BusSolnOrderExpenseItem</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BusSolnOrderItemPriceElement</b> entities.
     */
    public void setPriceElement( @Nonnull final List<BusSolnOrderItemPriceElement> value )
    {
        if( toPriceElement == null ) {
            toPriceElement = Lists.newArrayList();
        }
        toPriceElement.clear();
        toPriceElement.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BusSolnOrderItemPriceElement</b> entities. This corresponds to the
     * OData navigation property <b>to_PriceElement</b>.
     * <p>
     * If the navigation property <b>to_PriceElement</b> of a queried <b>BusSolnOrderExpenseItem</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BusSolnOrderItemPriceElement</b> entities.
     */
    public void addPriceElement( BusSolnOrderItemPriceElement... entity )
    {
        if( toPriceElement == null ) {
            toPriceElement = Lists.newArrayList();
        }
        toPriceElement.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>BusSolnOrdItmReferenceObject</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_ReferenceObject</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BusSolnOrdItmReferenceObject</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusSolnOrdItmReferenceObject> fetchReferenceObject()
    {
        return fetchFieldAsList("to_ReferenceObject", BusSolnOrdItmReferenceObject.class);
    }

    /**
     * Retrieval of associated <b>BusSolnOrdItmReferenceObject</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ReferenceObject</b>.
     * <p>
     * If the navigation property <b>to_ReferenceObject</b> of a queried <b>BusSolnOrderExpenseItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BusSolnOrdItmReferenceObject</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusSolnOrdItmReferenceObject> getReferenceObjectOrFetch()
    {
        if( toReferenceObject == null ) {
            toReferenceObject = fetchReferenceObject();
        }
        return toReferenceObject;
    }

    /**
     * Retrieval of associated <b>BusSolnOrdItmReferenceObject</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ReferenceObject</b>.
     * <p>
     * If the navigation property for an entity <b>BusSolnOrderExpenseItem</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ReferenceObject</b> is already loaded, the result will
     *         contain the <b>BusSolnOrdItmReferenceObject</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BusSolnOrdItmReferenceObject>> getReferenceObjectIfPresent()
    {
        return Option.of(toReferenceObject);
    }

    /**
     * Overwrites the list of associated <b>BusSolnOrdItmReferenceObject</b> entities for the loaded navigation property
     * <b>to_ReferenceObject</b>.
     * <p>
     * If the navigation property <b>to_ReferenceObject</b> of a queried <b>BusSolnOrderExpenseItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BusSolnOrdItmReferenceObject</b> entities.
     */
    public void setReferenceObject( @Nonnull final List<BusSolnOrdItmReferenceObject> value )
    {
        if( toReferenceObject == null ) {
            toReferenceObject = Lists.newArrayList();
        }
        toReferenceObject.clear();
        toReferenceObject.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BusSolnOrdItmReferenceObject</b> entities. This corresponds to the
     * OData navigation property <b>to_ReferenceObject</b>.
     * <p>
     * If the navigation property <b>to_ReferenceObject</b> of a queried <b>BusSolnOrderExpenseItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BusSolnOrdItmReferenceObject</b> entities.
     */
    public void addReferenceObject( BusSolnOrdItmReferenceObject... entity )
    {
        if( toReferenceObject == null ) {
            toReferenceObject = Lists.newArrayList();
        }
        toReferenceObject.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>BusSolnOrdItmFUPServiceOrder</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_ServiceOrder</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BusSolnOrdItmFUPServiceOrder</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusSolnOrdItmFUPServiceOrder> fetchServiceOrder()
    {
        return fetchFieldAsList("to_ServiceOrder", BusSolnOrdItmFUPServiceOrder.class);
    }

    /**
     * Retrieval of associated <b>BusSolnOrdItmFUPServiceOrder</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ServiceOrder</b>.
     * <p>
     * If the navigation property <b>to_ServiceOrder</b> of a queried <b>BusSolnOrderExpenseItem</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BusSolnOrdItmFUPServiceOrder</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusSolnOrdItmFUPServiceOrder> getServiceOrderOrFetch()
    {
        if( toServiceOrder == null ) {
            toServiceOrder = fetchServiceOrder();
        }
        return toServiceOrder;
    }

    /**
     * Retrieval of associated <b>BusSolnOrdItmFUPServiceOrder</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ServiceOrder</b>.
     * <p>
     * If the navigation property for an entity <b>BusSolnOrderExpenseItem</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ServiceOrder</b> is already loaded, the result will
     *         contain the <b>BusSolnOrdItmFUPServiceOrder</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BusSolnOrdItmFUPServiceOrder>> getServiceOrderIfPresent()
    {
        return Option.of(toServiceOrder);
    }

    /**
     * Overwrites the list of associated <b>BusSolnOrdItmFUPServiceOrder</b> entities for the loaded navigation property
     * <b>to_ServiceOrder</b>.
     * <p>
     * If the navigation property <b>to_ServiceOrder</b> of a queried <b>BusSolnOrderExpenseItem</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BusSolnOrdItmFUPServiceOrder</b> entities.
     */
    public void setServiceOrder( @Nonnull final List<BusSolnOrdItmFUPServiceOrder> value )
    {
        if( toServiceOrder == null ) {
            toServiceOrder = Lists.newArrayList();
        }
        toServiceOrder.clear();
        toServiceOrder.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BusSolnOrdItmFUPServiceOrder</b> entities. This corresponds to the
     * OData navigation property <b>to_ServiceOrder</b>.
     * <p>
     * If the navigation property <b>to_ServiceOrder</b> of a queried <b>BusSolnOrderExpenseItem</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BusSolnOrdItmFUPServiceOrder</b> entities.
     */
    public void addServiceOrder( BusSolnOrdItmFUPServiceOrder... entity )
    {
        if( toServiceOrder == null ) {
            toServiceOrder = Lists.newArrayList();
        }
        toServiceOrder.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>BusSolutionOrderItemText</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_Text</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BusSolutionOrderItemText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusSolutionOrderItemText> fetchText()
    {
        return fetchFieldAsList("to_Text", BusSolutionOrderItemText.class);
    }

    /**
     * Retrieval of associated <b>BusSolutionOrderItemText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>BusSolnOrderExpenseItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BusSolutionOrderItemText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusSolutionOrderItemText> getTextOrFetch()
    {
        if( toText == null ) {
            toText = fetchText();
        }
        return toText;
    }

    /**
     * Retrieval of associated <b>BusSolutionOrderItemText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property for an entity <b>BusSolnOrderExpenseItem</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Text</b> is already loaded, the result will contain the
     *         <b>BusSolutionOrderItemText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BusSolutionOrderItemText>> getTextIfPresent()
    {
        return Option.of(toText);
    }

    /**
     * Overwrites the list of associated <b>BusSolutionOrderItemText</b> entities for the loaded navigation property
     * <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>BusSolnOrderExpenseItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BusSolutionOrderItemText</b> entities.
     */
    public void setText( @Nonnull final List<BusSolutionOrderItemText> value )
    {
        if( toText == null ) {
            toText = Lists.newArrayList();
        }
        toText.clear();
        toText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BusSolutionOrderItemText</b> entities. This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>BusSolnOrderExpenseItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BusSolutionOrderItemText</b> entities.
     */
    public void addText( BusSolutionOrderItemText... entity )
    {
        if( toText == null ) {
            toText = Lists.newArrayList();
        }
        toText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>BusSolnOrdItmUserStatus</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_UserStatus</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BusSolnOrdItmUserStatus</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusSolnOrdItmUserStatus> fetchUserStatus()
    {
        return fetchFieldAsList("to_UserStatus", BusSolnOrdItmUserStatus.class);
    }

    /**
     * Retrieval of associated <b>BusSolnOrdItmUserStatus</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_UserStatus</b>.
     * <p>
     * If the navigation property <b>to_UserStatus</b> of a queried <b>BusSolnOrderExpenseItem</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BusSolnOrdItmUserStatus</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusSolnOrdItmUserStatus> getUserStatusOrFetch()
    {
        if( toUserStatus == null ) {
            toUserStatus = fetchUserStatus();
        }
        return toUserStatus;
    }

    /**
     * Retrieval of associated <b>BusSolnOrdItmUserStatus</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_UserStatus</b>.
     * <p>
     * If the navigation property for an entity <b>BusSolnOrderExpenseItem</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_UserStatus</b> is already loaded, the result will
     *         contain the <b>BusSolnOrdItmUserStatus</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BusSolnOrdItmUserStatus>> getUserStatusIfPresent()
    {
        return Option.of(toUserStatus);
    }

    /**
     * Overwrites the list of associated <b>BusSolnOrdItmUserStatus</b> entities for the loaded navigation property
     * <b>to_UserStatus</b>.
     * <p>
     * If the navigation property <b>to_UserStatus</b> of a queried <b>BusSolnOrderExpenseItem</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BusSolnOrdItmUserStatus</b> entities.
     */
    public void setUserStatus( @Nonnull final List<BusSolnOrdItmUserStatus> value )
    {
        if( toUserStatus == null ) {
            toUserStatus = Lists.newArrayList();
        }
        toUserStatus.clear();
        toUserStatus.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BusSolnOrdItmUserStatus</b> entities. This corresponds to the OData
     * navigation property <b>to_UserStatus</b>.
     * <p>
     * If the navigation property <b>to_UserStatus</b> of a queried <b>BusSolnOrderExpenseItem</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BusSolnOrdItmUserStatus</b> entities.
     */
    public void addUserStatus( BusSolnOrdItmUserStatus... entity )
    {
        if( toUserStatus == null ) {
            toUserStatus = Lists.newArrayList();
        }
        toUserStatus.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of BusSolnOrderExpenseItem instances.
     *
     */
    public final static class BusSolnOrderExpenseItemBuilder
    {

        private BusinessSolutionOrder toBusinessSolutionOrder;
        private String businessSolutionOrder = null;
        private List<BusSolnOrderItemPriceElement> toPriceElement = Lists.newArrayList();
        private List<BusSolnOrdItmReferenceObject> toReferenceObject = Lists.newArrayList();
        private List<BusSolnOrdItmFUPServiceOrder> toServiceOrder = Lists.newArrayList();
        private List<BusSolutionOrderItemText> toText = Lists.newArrayList();
        private List<BusSolnOrdItmUserStatus> toUserStatus = Lists.newArrayList();

        private BusSolnOrderExpenseItem.BusSolnOrderExpenseItemBuilder toBusinessSolutionOrder(
            final BusinessSolutionOrder value )
        {
            toBusinessSolutionOrder = value;
            return this;
        }

        /**
         * Navigation property <b>to_BusinessSolutionOrder</b> for <b>BusSolnOrderExpenseItem</b> to single
         * <b>BusinessSolutionOrder</b>.
         *
         * @param value
         *            The BusinessSolutionOrder to build this BusSolnOrderExpenseItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusSolnOrderExpenseItem.BusSolnOrderExpenseItemBuilder businessSolutionOrder(
            final BusinessSolutionOrder value )
        {
            return toBusinessSolutionOrder(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 10
         * <p>
         * Original property name from the Odata EDM: <b>BusinessSolutionOrder</b>
         * </p>
         *
         * @param value
         *            The businessSolutionOrder to build this BusSolnOrderExpenseItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusSolnOrderExpenseItem.BusSolnOrderExpenseItemBuilder businessSolutionOrder( final String value )
        {
            businessSolutionOrder = value;
            return this;
        }

        private BusSolnOrderExpenseItem.BusSolnOrderExpenseItemBuilder toPriceElement(
            final List<BusSolnOrderItemPriceElement> value )
        {
            toPriceElement.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_PriceElement</b> for <b>BusSolnOrderExpenseItem</b> to multiple
         * <b>BusSolnOrderItemPriceElement</b>.
         *
         * @param value
         *            The BusSolnOrderItemPriceElements to build this BusSolnOrderExpenseItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusSolnOrderExpenseItem.BusSolnOrderExpenseItemBuilder priceElement(
            BusSolnOrderItemPriceElement... value )
        {
            return toPriceElement(Lists.newArrayList(value));
        }

        private BusSolnOrderExpenseItem.BusSolnOrderExpenseItemBuilder toReferenceObject(
            final List<BusSolnOrdItmReferenceObject> value )
        {
            toReferenceObject.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ReferenceObject</b> for <b>BusSolnOrderExpenseItem</b> to multiple
         * <b>BusSolnOrdItmReferenceObject</b>.
         *
         * @param value
         *            The BusSolnOrdItmReferenceObjects to build this BusSolnOrderExpenseItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusSolnOrderExpenseItem.BusSolnOrderExpenseItemBuilder referenceObject(
            BusSolnOrdItmReferenceObject... value )
        {
            return toReferenceObject(Lists.newArrayList(value));
        }

        private BusSolnOrderExpenseItem.BusSolnOrderExpenseItemBuilder toServiceOrder(
            final List<BusSolnOrdItmFUPServiceOrder> value )
        {
            toServiceOrder.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ServiceOrder</b> for <b>BusSolnOrderExpenseItem</b> to multiple
         * <b>BusSolnOrdItmFUPServiceOrder</b>.
         *
         * @param value
         *            The BusSolnOrdItmFUPServiceOrders to build this BusSolnOrderExpenseItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusSolnOrderExpenseItem.BusSolnOrderExpenseItemBuilder serviceOrder(
            BusSolnOrdItmFUPServiceOrder... value )
        {
            return toServiceOrder(Lists.newArrayList(value));
        }

        private BusSolnOrderExpenseItem.BusSolnOrderExpenseItemBuilder toText(
            final List<BusSolutionOrderItemText> value )
        {
            toText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Text</b> for <b>BusSolnOrderExpenseItem</b> to multiple
         * <b>BusSolutionOrderItemText</b>.
         *
         * @param value
         *            The BusSolutionOrderItemTexts to build this BusSolnOrderExpenseItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusSolnOrderExpenseItem.BusSolnOrderExpenseItemBuilder text( BusSolutionOrderItemText... value )
        {
            return toText(Lists.newArrayList(value));
        }

        private BusSolnOrderExpenseItem.BusSolnOrderExpenseItemBuilder toUserStatus(
            final List<BusSolnOrdItmUserStatus> value )
        {
            toUserStatus.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_UserStatus</b> for <b>BusSolnOrderExpenseItem</b> to multiple
         * <b>BusSolnOrdItmUserStatus</b>.
         *
         * @param value
         *            The BusSolnOrdItmUserStatuss to build this BusSolnOrderExpenseItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusSolnOrderExpenseItem.BusSolnOrderExpenseItemBuilder userStatus( BusSolnOrdItmUserStatus... value )
        {
            return toUserStatus(Lists.newArrayList(value));
        }

    }

}
