/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.field.BusSolnOrderItemObjectListField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.selectable.BusSolnOrderItemObjectListSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Service Contract Item Object List
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_BusSolnOrderItemObjectListType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BusSolnOrderItemObjectList extends VdmEntity<BusSolnOrderItemObjectList>
{

    /**
     * Selector for all available fields of BusSolnOrderItemObjectList.
     *
     */
    public final static BusSolnOrderItemObjectListSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BusinessSolutionOrder</b>
     * </p>
     *
     * @return Transaction ID
     */
    @Key
    @SerializedName( "BusinessSolutionOrder" )
    @JsonProperty( "BusinessSolutionOrder" )
    @Nullable
    @ODataField( odataName = "BusinessSolutionOrder" )
    private String businessSolutionOrder;
    /**
     * Use with available fluent helpers to apply the <b>BusinessSolutionOrder</b> field to query operations.
     *
     */
    public final static BusSolnOrderItemObjectListField<String> BUSINESS_SOLUTION_ORDER =
        new BusSolnOrderItemObjectListField<String>("BusinessSolutionOrder");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BusinessSolutionOrderItem</b>
     * </p>
     *
     * @return Shortened Item Number in Document
     */
    @Key
    @SerializedName( "BusinessSolutionOrderItem" )
    @JsonProperty( "BusinessSolutionOrderItem" )
    @Nullable
    @ODataField( odataName = "BusinessSolutionOrderItem" )
    private String businessSolutionOrderItem;
    /**
     * Use with available fluent helpers to apply the <b>BusinessSolutionOrderItem</b> field to query operations.
     *
     */
    public final static BusSolnOrderItemObjectListField<String> BUSINESS_SOLUTION_ORDER_ITEM =
        new BusSolnOrderItemObjectListField<String>("BusinessSolutionOrderItem");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @return Material Number
     */
    @Key
    @SerializedName( "Product" )
    @JsonProperty( "Product" )
    @Nullable
    @ODataField( odataName = "Product" )
    private String product;
    /**
     * Use with available fluent helpers to apply the <b>Product</b> field to query operations.
     *
     */
    public final static BusSolnOrderItemObjectListField<String> PRODUCT =
        new BusSolnOrderItemObjectListField<String>("Product");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Equipment</b>
     * </p>
     *
     * @return Equipment Number
     */
    @Key
    @SerializedName( "Equipment" )
    @JsonProperty( "Equipment" )
    @Nullable
    @ODataField( odataName = "Equipment" )
    private String equipment;
    /**
     * Use with available fluent helpers to apply the <b>Equipment</b> field to query operations.
     *
     */
    public final static BusSolnOrderItemObjectListField<String> EQUIPMENT =
        new BusSolnOrderItemObjectListField<String>("Equipment");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ServiceRefFunctionalLocation</b>
     * </p>
     *
     * @return Functional Location
     */
    @Key
    @SerializedName( "ServiceRefFunctionalLocation" )
    @JsonProperty( "ServiceRefFunctionalLocation" )
    @Nullable
    @ODataField( odataName = "ServiceRefFunctionalLocation" )
    private String serviceRefFunctionalLocation;
    /**
     * Use with available fluent helpers to apply the <b>ServiceRefFunctionalLocation</b> field to query operations.
     *
     */
    public final static BusSolnOrderItemObjectListField<String> SERVICE_REF_FUNCTIONAL_LOCATION =
        new BusSolnOrderItemObjectListField<String>("ServiceRefFunctionalLocation");

    @Nonnull
    @Override
    public Class<BusSolnOrderItemObjectList> getType()
    {
        return BusSolnOrderItemObjectList.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BusinessSolutionOrder</b>
     * </p>
     *
     * @param businessSolutionOrder
     *            Transaction ID
     */
    public void setBusinessSolutionOrder( @Nullable final String businessSolutionOrder )
    {
        rememberChangedField("BusinessSolutionOrder", this.businessSolutionOrder);
        this.businessSolutionOrder = businessSolutionOrder;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BusinessSolutionOrderItem</b>
     * </p>
     *
     * @param businessSolutionOrderItem
     *            Shortened Item Number in Document
     */
    public void setBusinessSolutionOrderItem( @Nullable final String businessSolutionOrderItem )
    {
        rememberChangedField("BusinessSolutionOrderItem", this.businessSolutionOrderItem);
        this.businessSolutionOrderItem = businessSolutionOrderItem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @param product
     *            Material Number
     */
    public void setProduct( @Nullable final String product )
    {
        rememberChangedField("Product", this.product);
        this.product = product;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Equipment</b>
     * </p>
     *
     * @param equipment
     *            Equipment Number
     */
    public void setEquipment( @Nullable final String equipment )
    {
        rememberChangedField("Equipment", this.equipment);
        this.equipment = equipment;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ServiceRefFunctionalLocation</b>
     * </p>
     *
     * @param serviceRefFunctionalLocation
     *            Functional Location
     */
    public void setServiceRefFunctionalLocation( @Nullable final String serviceRefFunctionalLocation )
    {
        rememberChangedField("ServiceRefFunctionalLocation", this.serviceRefFunctionalLocation);
        this.serviceRefFunctionalLocation = serviceRefFunctionalLocation;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_BusSolnOrderItemObjectList";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("BusinessSolutionOrder", getBusinessSolutionOrder());
        result.put("BusinessSolutionOrderItem", getBusinessSolutionOrderItem());
        result.put("Product", getProduct());
        result.put("Equipment", getEquipment());
        result.put("ServiceRefFunctionalLocation", getServiceRefFunctionalLocation());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("BusinessSolutionOrder", getBusinessSolutionOrder());
        values.put("BusinessSolutionOrderItem", getBusinessSolutionOrderItem());
        values.put("Product", getProduct());
        values.put("Equipment", getEquipment());
        values.put("ServiceRefFunctionalLocation", getServiceRefFunctionalLocation());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("BusinessSolutionOrder") ) {
                final Object value = values.remove("BusinessSolutionOrder");
                if( (value == null) || (!value.equals(getBusinessSolutionOrder())) ) {
                    setBusinessSolutionOrder(((String) value));
                }
            }
            if( values.containsKey("BusinessSolutionOrderItem") ) {
                final Object value = values.remove("BusinessSolutionOrderItem");
                if( (value == null) || (!value.equals(getBusinessSolutionOrderItem())) ) {
                    setBusinessSolutionOrderItem(((String) value));
                }
            }
            if( values.containsKey("Product") ) {
                final Object value = values.remove("Product");
                if( (value == null) || (!value.equals(getProduct())) ) {
                    setProduct(((String) value));
                }
            }
            if( values.containsKey("Equipment") ) {
                final Object value = values.remove("Equipment");
                if( (value == null) || (!value.equals(getEquipment())) ) {
                    setEquipment(((String) value));
                }
            }
            if( values.containsKey("ServiceRefFunctionalLocation") ) {
                final Object value = values.remove("ServiceRefFunctionalLocation");
                if( (value == null) || (!value.equals(getServiceRefFunctionalLocation())) ) {
                    setServiceRefFunctionalLocation(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> BusSolnOrderItemObjectListField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new BusSolnOrderItemObjectListField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BusSolnOrderItemObjectListField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BusSolnOrderItemObjectListField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessSolutionOrderService.DEFAULT_SERVICE_PATH);
    }

}
