/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder;

import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.field.BusSolnOrderSalesItemField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.link.BusSolnOrderSalesItemLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.link.BusSolnOrderSalesItemOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.selectable.BusSolnOrderSalesItemSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Sales Order Item
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_BusSolnOrderSalesItemType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BusSolnOrderSalesItem extends VdmEntity<BusSolnOrderSalesItem>
{

    /**
     * Selector for all available fields of BusSolnOrderSalesItem.
     *
     */
    public final static BusSolnOrderSalesItemSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BusinessSolutionOrder</b>
     * </p>
     *
     * @return Transaction ID
     */
    @Key
    @SerializedName( "BusinessSolutionOrder" )
    @JsonProperty( "BusinessSolutionOrder" )
    @Nullable
    @ODataField( odataName = "BusinessSolutionOrder" )
    private String businessSolutionOrder;
    /**
     * Use with available fluent helpers to apply the <b>BusinessSolutionOrder</b> field to query operations.
     *
     */
    public final static BusSolnOrderSalesItemField<String> BUSINESS_SOLUTION_ORDER =
        new BusSolnOrderSalesItemField<String>("BusinessSolutionOrder");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BusinessSolutionOrderItem</b>
     * </p>
     *
     * @return Shortened Item Number in Document
     */
    @Key
    @SerializedName( "BusinessSolutionOrderItem" )
    @JsonProperty( "BusinessSolutionOrderItem" )
    @Nullable
    @ODataField( odataName = "BusinessSolutionOrderItem" )
    private String businessSolutionOrderItem;
    /**
     * Use with available fluent helpers to apply the <b>BusinessSolutionOrderItem</b> field to query operations.
     *
     */
    public final static BusSolnOrderSalesItemField<String> BUSINESS_SOLUTION_ORDER_ITEM =
        new BusSolnOrderSalesItemField<String>("BusinessSolutionOrderItem");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocumentItemCharUUID</b>
     * </p>
     *
     * @return 32 Character CRM Object GUID (Converted)
     */
    @SerializedName( "ServiceDocumentItemCharUUID" )
    @JsonProperty( "ServiceDocumentItemCharUUID" )
    @Nullable
    @ODataField( odataName = "ServiceDocumentItemCharUUID" )
    private UUID serviceDocumentItemCharUUID;
    /**
     * Use with available fluent helpers to apply the <b>ServiceDocumentItemCharUUID</b> field to query operations.
     *
     */
    public final static BusSolnOrderSalesItemField<UUID> SERVICE_DOCUMENT_ITEM_CHAR_UUID =
        new BusSolnOrderSalesItemField<UUID>("ServiceDocumentItemCharUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BusinessSolutionOrderItemUUID</b>
     * </p>
     *
     * @return GUID of a CRM Order Object
     */
    @SerializedName( "BusinessSolutionOrderItemUUID" )
    @JsonProperty( "BusinessSolutionOrderItemUUID" )
    @Nullable
    @ODataField( odataName = "BusinessSolutionOrderItemUUID" )
    private UUID businessSolutionOrderItemUUID;
    /**
     * Use with available fluent helpers to apply the <b>BusinessSolutionOrderItemUUID</b> field to query operations.
     *
     */
    public final static BusSolnOrderSalesItemField<UUID> BUSINESS_SOLUTION_ORDER_ITEM_UUID =
        new BusSolnOrderSalesItemField<UUID>("BusinessSolutionOrderItemUUID");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmCategory</b>
     * </p>
     *
     * @return Item Category
     */
    @SerializedName( "BusSolnOrdItmCategory" )
    @JsonProperty( "BusSolnOrdItmCategory" )
    @Nullable
    @ODataField( odataName = "BusSolnOrdItmCategory" )
    private String busSolnOrdItmCategory;
    /**
     * Use with available fluent helpers to apply the <b>BusSolnOrdItmCategory</b> field to query operations.
     *
     */
    public final static BusSolnOrderSalesItemField<String> BUS_SOLN_ORD_ITM_CATEGORY =
        new BusSolnOrderSalesItemField<String>("BusSolnOrdItmCategory");
    /**
     * Constraints: Not nullable, Maximum length: 54
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @return Product Name Entered
     */
    @SerializedName( "Product" )
    @JsonProperty( "Product" )
    @Nullable
    @ODataField( odataName = "Product" )
    private String product;
    /**
     * Use with available fluent helpers to apply the <b>Product</b> field to query operations.
     *
     */
    public final static BusSolnOrderSalesItemField<String> PRODUCT = new BusSolnOrderSalesItemField<String>("Product");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Quantity</b>
     * </p>
     *
     * @return CRM: Order Quantity
     */
    @SerializedName( "Quantity" )
    @JsonProperty( "Quantity" )
    @Nullable
    @ODataField( odataName = "Quantity" )
    private BigDecimal quantity;
    /**
     * Use with available fluent helpers to apply the <b>Quantity</b> field to query operations.
     *
     */
    public final static BusSolnOrderSalesItemField<BigDecimal> QUANTITY =
        new BusSolnOrderSalesItemField<BigDecimal>("Quantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>QuantityUnit</b>
     * </p>
     *
     * @return Unit of Measure in Which the Product Is Sold
     */
    @SerializedName( "QuantityUnit" )
    @JsonProperty( "QuantityUnit" )
    @Nullable
    @ODataField( odataName = "QuantityUnit" )
    private String quantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>QuantityUnit</b> field to query operations.
     *
     */
    public final static BusSolnOrderSalesItemField<String> QUANTITY_UNIT =
        new BusSolnOrderSalesItemField<String>("QuantityUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmQtyUnitSAPCode</b>
     * </p>
     *
     * @return SAP Unit Code for Order Quantity
     */
    @SerializedName( "BusSolnOrdItmQtyUnitSAPCode" )
    @JsonProperty( "BusSolnOrdItmQtyUnitSAPCode" )
    @Nullable
    @ODataField( odataName = "BusSolnOrdItmQtyUnitSAPCode" )
    private String busSolnOrdItmQtyUnitSAPCode;
    /**
     * Use with available fluent helpers to apply the <b>BusSolnOrdItmQtyUnitSAPCode</b> field to query operations.
     *
     */
    public final static BusSolnOrderSalesItemField<String> BUS_SOLN_ORD_ITM_QTY_UNIT_SAP_CODE =
        new BusSolnOrderSalesItemField<String>("BusSolnOrdItmQtyUnitSAPCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmQtyUnitISOCode</b>
     * </p>
     *
     * @return ISO Unit Code for Order Quantity
     */
    @SerializedName( "BusSolnOrdItmQtyUnitISOCode" )
    @JsonProperty( "BusSolnOrdItmQtyUnitISOCode" )
    @Nullable
    @ODataField( odataName = "BusSolnOrdItmQtyUnitISOCode" )
    private String busSolnOrdItmQtyUnitISOCode;
    /**
     * Use with available fluent helpers to apply the <b>BusSolnOrdItmQtyUnitISOCode</b> field to query operations.
     *
     */
    public final static BusSolnOrderSalesItemField<String> BUS_SOLN_ORD_ITM_QTY_UNIT_ISO_CODE =
        new BusSolnOrderSalesItemField<String>("BusSolnOrdItmQtyUnitISOCode");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmDescription</b>
     * </p>
     *
     * @return Product Description
     */
    @SerializedName( "BusSolnOrdItmDescription" )
    @JsonProperty( "BusSolnOrdItmDescription" )
    @Nullable
    @ODataField( odataName = "BusSolnOrdItmDescription" )
    private String busSolnOrdItmDescription;
    /**
     * Use with available fluent helpers to apply the <b>BusSolnOrdItmDescription</b> field to query operations.
     *
     */
    public final static BusSolnOrderSalesItemField<String> BUS_SOLN_ORD_ITM_DESCRIPTION =
        new BusSolnOrderSalesItemField<String>("BusSolnOrdItmDescription");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Short Text Language for an Item
     */
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static BusSolnOrderSalesItemField<String> LANGUAGE =
        new BusSolnOrderSalesItemField<String>("Language");
    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmExtReference</b>
     * </p>
     *
     * @return External Reference Number
     */
    @SerializedName( "BusSolnOrdItmExtReference" )
    @JsonProperty( "BusSolnOrdItmExtReference" )
    @Nullable
    @ODataField( odataName = "BusSolnOrdItmExtReference" )
    private String busSolnOrdItmExtReference;
    /**
     * Use with available fluent helpers to apply the <b>BusSolnOrdItmExtReference</b> field to query operations.
     *
     */
    public final static BusSolnOrderSalesItemField<String> BUS_SOLN_ORD_ITM_EXT_REFERENCE =
        new BusSolnOrderSalesItemField<String>("BusSolnOrdItmExtReference");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemOrderProbabilityInPercent</b>
     * </p>
     *
     * @return Order Probability
     */
    @SerializedName( "ItemOrderProbabilityInPercent" )
    @JsonProperty( "ItemOrderProbabilityInPercent" )
    @Nullable
    @ODataField( odataName = "ItemOrderProbabilityInPercent" )
    private String itemOrderProbabilityInPercent;
    /**
     * Use with available fluent helpers to apply the <b>ItemOrderProbabilityInPercent</b> field to query operations.
     *
     */
    public final static BusSolnOrderSalesItemField<String> ITEM_ORDER_PROBABILITY_IN_PERCENT =
        new BusSolnOrderSalesItemField<String>("ItemOrderProbabilityInPercent");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PaymentTerms</b>
     * </p>
     *
     * @return Terms of Payment
     */
    @SerializedName( "PaymentTerms" )
    @JsonProperty( "PaymentTerms" )
    @Nullable
    @ODataField( odataName = "PaymentTerms" )
    private String paymentTerms;
    /**
     * Use with available fluent helpers to apply the <b>PaymentTerms</b> field to query operations.
     *
     */
    public final static BusSolnOrderSalesItemField<String> PAYMENT_TERMS =
        new BusSolnOrderSalesItemField<String>("PaymentTerms");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsPart1</b>
     * </p>
     *
     * @return Incoterms (Part 1)
     */
    @SerializedName( "IncotermsPart1" )
    @JsonProperty( "IncotermsPart1" )
    @Nullable
    @ODataField( odataName = "IncotermsPart1" )
    private String incotermsPart1;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsPart1</b> field to query operations.
     *
     */
    public final static BusSolnOrderSalesItemField<String> INCOTERMS_PART1 =
        new BusSolnOrderSalesItemField<String>("IncotermsPart1");
    /**
     * Constraints: Not nullable, Maximum length: 28
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsPart2</b>
     * </p>
     *
     * @return Incoterms (Part 2)
     */
    @SerializedName( "IncotermsPart2" )
    @JsonProperty( "IncotermsPart2" )
    @Nullable
    @ODataField( odataName = "IncotermsPart2" )
    private String incotermsPart2;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsPart2</b> field to query operations.
     *
     */
    public final static BusSolnOrderSalesItemField<String> INCOTERMS_PART2 =
        new BusSolnOrderSalesItemField<String>("IncotermsPart2");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static BusSolnOrderSalesItemField<String> PLANT = new BusSolnOrderSalesItemField<String>("Plant");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmIsReleased</b>
     * </p>
     *
     * @return Release Status
     */
    @SerializedName( "BusSolnOrdItmIsReleased" )
    @JsonProperty( "BusSolnOrdItmIsReleased" )
    @Nullable
    @ODataField( odataName = "BusSolnOrdItmIsReleased" )
    private String busSolnOrdItmIsReleased;
    /**
     * Use with available fluent helpers to apply the <b>BusSolnOrdItmIsReleased</b> field to query operations.
     *
     */
    public final static BusSolnOrderSalesItemField<String> BUS_SOLN_ORD_ITM_IS_RELEASED =
        new BusSolnOrderSalesItemField<String>("BusSolnOrdItmIsReleased");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmIsCompleted</b>
     * </p>
     *
     * @return The busSolnOrdItmIsCompleted contained in this entity.
     */
    @SerializedName( "BusSolnOrdItmIsCompleted" )
    @JsonProperty( "BusSolnOrdItmIsCompleted" )
    @Nullable
    @ODataField( odataName = "BusSolnOrdItmIsCompleted" )
    private String busSolnOrdItmIsCompleted;
    /**
     * Use with available fluent helpers to apply the <b>BusSolnOrdItmIsCompleted</b> field to query operations.
     *
     */
    public final static BusSolnOrderSalesItemField<String> BUS_SOLN_ORD_ITM_IS_COMPLETED =
        new BusSolnOrderSalesItemField<String>("BusSolnOrdItmIsCompleted");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmIsRejected</b>
     * </p>
     *
     * @return Cancellation Status
     */
    @SerializedName( "BusSolnOrdItmIsRejected" )
    @JsonProperty( "BusSolnOrdItmIsRejected" )
    @Nullable
    @ODataField( odataName = "BusSolnOrdItmIsRejected" )
    private String busSolnOrdItmIsRejected;
    /**
     * Use with available fluent helpers to apply the <b>BusSolnOrdItmIsRejected</b> field to query operations.
     *
     */
    public final static BusSolnOrderSalesItemField<String> BUS_SOLN_ORD_ITM_IS_REJECTED =
        new BusSolnOrderSalesItemField<String>("BusSolnOrdItmIsRejected");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmDistrStatus</b>
     * </p>
     *
     * @return The busSolnOrdItmDistrStatus contained in this entity.
     */
    @SerializedName( "BusSolnOrdItmDistrStatus" )
    @JsonProperty( "BusSolnOrdItmDistrStatus" )
    @Nullable
    @ODataField( odataName = "BusSolnOrdItmDistrStatus" )
    private String busSolnOrdItmDistrStatus;
    /**
     * Use with available fluent helpers to apply the <b>BusSolnOrdItmDistrStatus</b> field to query operations.
     *
     */
    public final static BusSolnOrderSalesItemField<String> BUS_SOLN_ORD_ITM_DISTR_STATUS =
        new BusSolnOrderSalesItemField<String>("BusSolnOrdItmDistrStatus");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmDistrStatusName</b>
     * </p>
     *
     * @return The busSolnOrdItmDistrStatusName contained in this entity.
     */
    @SerializedName( "BusSolnOrdItmDistrStatusName" )
    @JsonProperty( "BusSolnOrdItmDistrStatusName" )
    @Nullable
    @ODataField( odataName = "BusSolnOrdItmDistrStatusName" )
    private String busSolnOrdItmDistrStatusName;
    /**
     * Use with available fluent helpers to apply the <b>BusSolnOrdItmDistrStatusName</b> field to query operations.
     *
     */
    public final static BusSolnOrderSalesItemField<String> BUS_SOLN_ORD_ITM_DISTR_STATUS_NAME =
        new BusSolnOrderSalesItemField<String>("BusSolnOrdItmDistrStatusName");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmRjcnReason</b>
     * </p>
     *
     * @return Cancellation Reason Code
     */
    @SerializedName( "BusSolnOrdItmRjcnReason" )
    @JsonProperty( "BusSolnOrdItmRjcnReason" )
    @Nullable
    @ODataField( odataName = "BusSolnOrdItmRjcnReason" )
    private String busSolnOrdItmRjcnReason;
    /**
     * Use with available fluent helpers to apply the <b>BusSolnOrdItmRjcnReason</b> field to query operations.
     *
     */
    public final static BusSolnOrderSalesItemField<String> BUS_SOLN_ORD_ITM_RJCN_REASON =
        new BusSolnOrderSalesItemField<String>("BusSolnOrdItmRjcnReason");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmRjcnReasonText</b>
     * </p>
     *
     * @return Description
     */
    @SerializedName( "BusSolnOrdItmRjcnReasonText" )
    @JsonProperty( "BusSolnOrdItmRjcnReasonText" )
    @Nullable
    @ODataField( odataName = "BusSolnOrdItmRjcnReasonText" )
    private String busSolnOrdItmRjcnReasonText;
    /**
     * Use with available fluent helpers to apply the <b>BusSolnOrdItmRjcnReasonText</b> field to query operations.
     *
     */
    public final static BusSolnOrderSalesItemField<String> BUS_SOLN_ORD_ITM_RJCN_REASON_TEXT =
        new BusSolnOrderSalesItemField<String>("BusSolnOrdItmRjcnReasonText");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SrvcDocItmDeliveryStatus</b>
     * </p>
     *
     * @return Delivery Status
     */
    @SerializedName( "SrvcDocItmDeliveryStatus" )
    @JsonProperty( "SrvcDocItmDeliveryStatus" )
    @Nullable
    @ODataField( odataName = "SrvcDocItmDeliveryStatus" )
    private String srvcDocItmDeliveryStatus;
    /**
     * Use with available fluent helpers to apply the <b>SrvcDocItmDeliveryStatus</b> field to query operations.
     *
     */
    public final static BusSolnOrderSalesItemField<String> SRVC_DOC_ITM_DELIVERY_STATUS =
        new BusSolnOrderSalesItemField<String>("SrvcDocItmDeliveryStatus");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>SrvcDocDeliveryStatusText</b>
     * </p>
     *
     * @return Short Text for Fixed Values
     */
    @SerializedName( "SrvcDocDeliveryStatusText" )
    @JsonProperty( "SrvcDocDeliveryStatusText" )
    @Nullable
    @ODataField( odataName = "SrvcDocDeliveryStatusText" )
    private String srvcDocDeliveryStatusText;
    /**
     * Use with available fluent helpers to apply the <b>SrvcDocDeliveryStatusText</b> field to query operations.
     *
     */
    public final static BusSolnOrderSalesItemField<String> SRVC_DOC_DELIVERY_STATUS_TEXT =
        new BusSolnOrderSalesItemField<String>("SrvcDocDeliveryStatusText");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocItemBillingStatus</b>
     * </p>
     *
     * @return Billing Status
     */
    @SerializedName( "ServiceDocItemBillingStatus" )
    @JsonProperty( "ServiceDocItemBillingStatus" )
    @Nullable
    @ODataField( odataName = "ServiceDocItemBillingStatus" )
    private String serviceDocItemBillingStatus;
    /**
     * Use with available fluent helpers to apply the <b>ServiceDocItemBillingStatus</b> field to query operations.
     *
     */
    public final static BusSolnOrderSalesItemField<String> SERVICE_DOC_ITEM_BILLING_STATUS =
        new BusSolnOrderSalesItemField<String>("ServiceDocItemBillingStatus");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BillingBlockReason</b>
     * </p>
     *
     * @return Business Partner: Billing Block Reason
     */
    @SerializedName( "BillingBlockReason" )
    @JsonProperty( "BillingBlockReason" )
    @Nullable
    @ODataField( odataName = "BillingBlockReason" )
    private String billingBlockReason;
    /**
     * Use with available fluent helpers to apply the <b>BillingBlockReason</b> field to query operations.
     *
     */
    public final static BusSolnOrderSalesItemField<String> BILLING_BLOCK_REASON =
        new BusSolnOrderSalesItemField<String>("BillingBlockReason");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SoldToParty</b>
     * </p>
     *
     * @return Sold-To Party
     */
    @SerializedName( "SoldToParty" )
    @JsonProperty( "SoldToParty" )
    @Nullable
    @ODataField( odataName = "SoldToParty" )
    private String soldToParty;
    /**
     * Use with available fluent helpers to apply the <b>SoldToParty</b> field to query operations.
     *
     */
    public final static BusSolnOrderSalesItemField<String> SOLD_TO_PARTY =
        new BusSolnOrderSalesItemField<String>("SoldToParty");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ShipToParty</b>
     * </p>
     *
     * @return Ship-To Party
     */
    @SerializedName( "ShipToParty" )
    @JsonProperty( "ShipToParty" )
    @Nullable
    @ODataField( odataName = "ShipToParty" )
    private String shipToParty;
    /**
     * Use with available fluent helpers to apply the <b>ShipToParty</b> field to query operations.
     *
     */
    public final static BusSolnOrderSalesItemField<String> SHIP_TO_PARTY =
        new BusSolnOrderSalesItemField<String>("ShipToParty");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BillToParty</b>
     * </p>
     *
     * @return Bill-To Party
     */
    @SerializedName( "BillToParty" )
    @JsonProperty( "BillToParty" )
    @Nullable
    @ODataField( odataName = "BillToParty" )
    private String billToParty;
    /**
     * Use with available fluent helpers to apply the <b>BillToParty</b> field to query operations.
     *
     */
    public final static BusSolnOrderSalesItemField<String> BILL_TO_PARTY =
        new BusSolnOrderSalesItemField<String>("BillToParty");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PayerParty</b>
     * </p>
     *
     * @return Payer
     */
    @SerializedName( "PayerParty" )
    @JsonProperty( "PayerParty" )
    @Nullable
    @ODataField( odataName = "PayerParty" )
    private String payerParty;
    /**
     * Use with available fluent helpers to apply the <b>PayerParty</b> field to query operations.
     *
     */
    public final static BusSolnOrderSalesItemField<String> PAYER_PARTY =
        new BusSolnOrderSalesItemField<String>("PayerParty");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PersonResponsible</b>
     * </p>
     *
     * @return Employee Responsible
     */
    @SerializedName( "PersonResponsible" )
    @JsonProperty( "PersonResponsible" )
    @Nullable
    @ODataField( odataName = "PersonResponsible" )
    private String personResponsible;
    /**
     * Use with available fluent helpers to apply the <b>PersonResponsible</b> field to query operations.
     *
     */
    public final static BusSolnOrderSalesItemField<String> PERSON_RESPONSIBLE =
        new BusSolnOrderSalesItemField<String>("PersonResponsible");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ContactPerson</b>
     * </p>
     *
     * @return Customer Contact Person
     */
    @SerializedName( "ContactPerson" )
    @JsonProperty( "ContactPerson" )
    @Nullable
    @ODataField( odataName = "ContactPerson" )
    private String contactPerson;
    /**
     * Use with available fluent helpers to apply the <b>ContactPerson</b> field to query operations.
     *
     */
    public final static BusSolnOrderSalesItemField<String> CONTACT_PERSON =
        new BusSolnOrderSalesItemField<String>("ContactPerson");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryPriority</b>
     * </p>
     *
     * @return Delivery Priority
     */
    @SerializedName( "DeliveryPriority" )
    @JsonProperty( "DeliveryPriority" )
    @Nullable
    @ODataField( odataName = "DeliveryPriority" )
    private String deliveryPriority;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryPriority</b> field to query operations.
     *
     */
    public final static BusSolnOrderSalesItemField<String> DELIVERY_PRIORITY =
        new BusSolnOrderSalesItemField<String>("DeliveryPriority");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PartialDeliveryIsAllowed</b>
     * </p>
     *
     * @return Delivery Control (Item)
     */
    @SerializedName( "PartialDeliveryIsAllowed" )
    @JsonProperty( "PartialDeliveryIsAllowed" )
    @Nullable
    @ODataField( odataName = "PartialDeliveryIsAllowed" )
    private String partialDeliveryIsAllowed;
    /**
     * Use with available fluent helpers to apply the <b>PartialDeliveryIsAllowed</b> field to query operations.
     *
     */
    public final static BusSolnOrderSalesItemField<String> PARTIAL_DELIVERY_IS_ALLOWED =
        new BusSolnOrderSalesItemField<String>("PartialDeliveryIsAllowed");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>OrderCombinationIsAllowed</b>
     * </p>
     *
     * @return Indicator: Order Combination
     */
    @SerializedName( "OrderCombinationIsAllowed" )
    @JsonProperty( "OrderCombinationIsAllowed" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "OrderCombinationIsAllowed" )
    private Boolean orderCombinationIsAllowed;
    /**
     * Use with available fluent helpers to apply the <b>OrderCombinationIsAllowed</b> field to query operations.
     *
     */
    public final static BusSolnOrderSalesItemField<Boolean> ORDER_COMBINATION_IS_ALLOWED =
        new BusSolnOrderSalesItemField<Boolean>("OrderCombinationIsAllowed");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryBlockReason</b>
     * </p>
     *
     * @return Business Partner: Delivery Block Reason
     */
    @SerializedName( "DeliveryBlockReason" )
    @JsonProperty( "DeliveryBlockReason" )
    @Nullable
    @ODataField( odataName = "DeliveryBlockReason" )
    private String deliveryBlockReason;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryBlockReason</b> field to query operations.
     *
     */
    public final static BusSolnOrderSalesItemField<String> DELIVERY_BLOCK_REASON =
        new BusSolnOrderSalesItemField<String>("DeliveryBlockReason");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RequestedDeliveryUTCDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @SerializedName( "RequestedDeliveryUTCDateTime" )
    @JsonProperty( "RequestedDeliveryUTCDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "RequestedDeliveryUTCDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime requestedDeliveryUTCDateTime;
    /**
     * Use with available fluent helpers to apply the <b>RequestedDeliveryUTCDateTime</b> field to query operations.
     *
     */
    public final static BusSolnOrderSalesItemField<ZonedDateTime> REQUESTED_DELIVERY_UTC_DATE_TIME =
        new BusSolnOrderSalesItemField<ZonedDateTime>("RequestedDeliveryUTCDateTime");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocumentItemNetAmount</b>
     * </p>
     *
     * @return Net Value
     */
    @SerializedName( "ServiceDocumentItemNetAmount" )
    @JsonProperty( "ServiceDocumentItemNetAmount" )
    @Nullable
    @ODataField( odataName = "ServiceDocumentItemNetAmount" )
    private BigDecimal serviceDocumentItemNetAmount;
    /**
     * Use with available fluent helpers to apply the <b>ServiceDocumentItemNetAmount</b> field to query operations.
     *
     */
    public final static BusSolnOrderSalesItemField<BigDecimal> SERVICE_DOCUMENT_ITEM_NET_AMOUNT =
        new BusSolnOrderSalesItemField<BigDecimal>("ServiceDocumentItemNetAmount");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @return Currency
     */
    @SerializedName( "TransactionCurrency" )
    @JsonProperty( "TransactionCurrency" )
    @Nullable
    @ODataField( odataName = "TransactionCurrency" )
    private String transactionCurrency;
    /**
     * Use with available fluent helpers to apply the <b>TransactionCurrency</b> field to query operations.
     *
     */
    public final static BusSolnOrderSalesItemField<String> TRANSACTION_CURRENCY =
        new BusSolnOrderSalesItemField<String>("TransactionCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @return Profit Center
     */
    @SerializedName( "ProfitCenter" )
    @JsonProperty( "ProfitCenter" )
    @Nullable
    @ODataField( odataName = "ProfitCenter" )
    private String profitCenter;
    /**
     * Use with available fluent helpers to apply the <b>ProfitCenter</b> field to query operations.
     *
     */
    public final static BusSolnOrderSalesItemField<String> PROFIT_CENTER =
        new BusSolnOrderSalesItemField<String>("ProfitCenter");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderByCustomer</b>
     * </p>
     *
     * @return Sold-To Party's External Reference Number
     */
    @SerializedName( "PurchaseOrderByCustomer" )
    @JsonProperty( "PurchaseOrderByCustomer" )
    @Nullable
    @ODataField( odataName = "PurchaseOrderByCustomer" )
    private String purchaseOrderByCustomer;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseOrderByCustomer</b> field to query operations.
     *
     */
    public final static BusSolnOrderSalesItemField<String> PURCHASE_ORDER_BY_CUSTOMER =
        new BusSolnOrderSalesItemField<String>("PurchaseOrderByCustomer");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MaterialPricingGroup</b>
     * </p>
     *
     * @return Material Price Group
     */
    @SerializedName( "MaterialPricingGroup" )
    @JsonProperty( "MaterialPricingGroup" )
    @Nullable
    @ODataField( odataName = "MaterialPricingGroup" )
    private String materialPricingGroup;
    /**
     * Use with available fluent helpers to apply the <b>MaterialPricingGroup</b> field to query operations.
     *
     */
    public final static BusSolnOrderSalesItemField<String> MATERIAL_PRICING_GROUP =
        new BusSolnOrderSalesItemField<String>("MaterialPricingGroup");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemGrossWeight</b>
     * </p>
     *
     * @return Gross Weight
     */
    @SerializedName( "ItemGrossWeight" )
    @JsonProperty( "ItemGrossWeight" )
    @Nullable
    @ODataField( odataName = "ItemGrossWeight" )
    private BigDecimal itemGrossWeight;
    /**
     * Use with available fluent helpers to apply the <b>ItemGrossWeight</b> field to query operations.
     *
     */
    public final static BusSolnOrderSalesItemField<BigDecimal> ITEM_GROSS_WEIGHT =
        new BusSolnOrderSalesItemField<BigDecimal>("ItemGrossWeight");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemNetWeight</b>
     * </p>
     *
     * @return Net Weight
     */
    @SerializedName( "ItemNetWeight" )
    @JsonProperty( "ItemNetWeight" )
    @Nullable
    @ODataField( odataName = "ItemNetWeight" )
    private BigDecimal itemNetWeight;
    /**
     * Use with available fluent helpers to apply the <b>ItemNetWeight</b> field to query operations.
     *
     */
    public final static BusSolnOrderSalesItemField<BigDecimal> ITEM_NET_WEIGHT =
        new BusSolnOrderSalesItemField<BigDecimal>("ItemNetWeight");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemWeightUnit</b>
     * </p>
     *
     * @return Unit of Weight
     */
    @SerializedName( "ItemWeightUnit" )
    @JsonProperty( "ItemWeightUnit" )
    @Nullable
    @ODataField( odataName = "ItemWeightUnit" )
    private String itemWeightUnit;
    /**
     * Use with available fluent helpers to apply the <b>ItemWeightUnit</b> field to query operations.
     *
     */
    public final static BusSolnOrderSalesItemField<String> ITEM_WEIGHT_UNIT =
        new BusSolnOrderSalesItemField<String>("ItemWeightUnit");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemVolume</b>
     * </p>
     *
     * @return Volume Occupied by the Product per Volume Unit
     */
    @SerializedName( "ItemVolume" )
    @JsonProperty( "ItemVolume" )
    @Nullable
    @ODataField( odataName = "ItemVolume" )
    private BigDecimal itemVolume;
    /**
     * Use with available fluent helpers to apply the <b>ItemVolume</b> field to query operations.
     *
     */
    public final static BusSolnOrderSalesItemField<BigDecimal> ITEM_VOLUME =
        new BusSolnOrderSalesItemField<BigDecimal>("ItemVolume");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemVolumeUnit</b>
     * </p>
     *
     * @return Unit for the Volume of a Product
     */
    @SerializedName( "ItemVolumeUnit" )
    @JsonProperty( "ItemVolumeUnit" )
    @Nullable
    @ODataField( odataName = "ItemVolumeUnit" )
    private String itemVolumeUnit;
    /**
     * Use with available fluent helpers to apply the <b>ItemVolumeUnit</b> field to query operations.
     *
     */
    public final static BusSolnOrderSalesItemField<String> ITEM_VOLUME_UNIT =
        new BusSolnOrderSalesItemField<String>("ItemVolumeUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryGroup</b>
     * </p>
     *
     * @return Delivery Group (Items are Delivered Together)
     */
    @SerializedName( "DeliveryGroup" )
    @JsonProperty( "DeliveryGroup" )
    @Nullable
    @ODataField( odataName = "DeliveryGroup" )
    private String deliveryGroup;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryGroup</b> field to query operations.
     *
     */
    public final static BusSolnOrderSalesItemField<String> DELIVERY_GROUP =
        new BusSolnOrderSalesItemField<String>("DeliveryGroup");
    /**
     * Constraints: Not nullable, Maximum length: 32
     * <p>
     * Original property name from the Odata EDM: <b>CPQQuotationItem</b>
     * </p>
     *
     * @return Identification of a Reference Object for Items
     */
    @SerializedName( "CPQQuotationItem" )
    @JsonProperty( "CPQQuotationItem" )
    @Nullable
    @ODataField( odataName = "CPQQuotationItem" )
    private String cPQQuotationItem;
    /**
     * Use with available fluent helpers to apply the <b>CPQQuotationItem</b> field to query operations.
     *
     */
    public final static BusSolnOrderSalesItemField<String> CPQ_QUOTATION_ITEM =
        new BusSolnOrderSalesItemField<String>("CPQQuotationItem");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>ConfigurationNumber</b>
     * </p>
     *
     * @return Configuration (Internal Object Number)
     */
    @SerializedName( "ConfigurationNumber" )
    @JsonProperty( "ConfigurationNumber" )
    @Nullable
    @ODataField( odataName = "ConfigurationNumber" )
    private String configurationNumber;
    /**
     * Use with available fluent helpers to apply the <b>ConfigurationNumber</b> field to query operations.
     *
     */
    public final static BusSolnOrderSalesItemField<String> CONFIGURATION_NUMBER =
        new BusSolnOrderSalesItemField<String>("ConfigurationNumber");
    /**
     * Navigation property <b>to_BusinessSolutionOrder</b> for <b>BusSolnOrderSalesItem</b> to single
     * <b>BusinessSolutionOrder</b>.
     *
     */
    @SerializedName( "to_BusinessSolutionOrder" )
    @JsonProperty( "to_BusinessSolutionOrder" )
    @ODataField( odataName = "to_BusinessSolutionOrder" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private BusinessSolutionOrder toBusinessSolutionOrder;
    /**
     * Navigation property <b>to_Configurations</b> for <b>BusSolnOrderSalesItem</b> to multiple
     * <b>BusSolnOrdItmConfiguration</b>.
     *
     */
    @SerializedName( "to_Configurations" )
    @JsonProperty( "to_Configurations" )
    @ODataField( odataName = "to_Configurations" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BusSolnOrdItmConfiguration> toConfigurations;
    /**
     * Navigation property <b>to_PriceElement</b> for <b>BusSolnOrderSalesItem</b> to multiple
     * <b>BusSolnOrderItemPriceElement</b>.
     *
     */
    @SerializedName( "to_PriceElement" )
    @JsonProperty( "to_PriceElement" )
    @ODataField( odataName = "to_PriceElement" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BusSolnOrderItemPriceElement> toPriceElement;
    /**
     * Navigation property <b>to_SalesOrder</b> for <b>BusSolnOrderSalesItem</b> to multiple
     * <b>BusSolnOrdItmFUPSalesOrder</b>.
     *
     */
    @SerializedName( "to_SalesOrder" )
    @JsonProperty( "to_SalesOrder" )
    @ODataField( odataName = "to_SalesOrder" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BusSolnOrdItmFUPSalesOrder> toSalesOrder;
    /**
     * Navigation property <b>to_ScheduleLine</b> for <b>BusSolnOrderSalesItem</b> to multiple
     * <b>BusSolnOrderItemScheduleLine</b>.
     *
     */
    @SerializedName( "to_ScheduleLine" )
    @JsonProperty( "to_ScheduleLine" )
    @ODataField( odataName = "to_ScheduleLine" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BusSolnOrderItemScheduleLine> toScheduleLine;
    /**
     * Navigation property <b>to_Text</b> for <b>BusSolnOrderSalesItem</b> to multiple <b>BusSolutionOrderItemText</b>.
     *
     */
    @SerializedName( "to_Text" )
    @JsonProperty( "to_Text" )
    @ODataField( odataName = "to_Text" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BusSolutionOrderItemText> toText;
    /**
     * Navigation property <b>to_UserStatus</b> for <b>BusSolnOrderSalesItem</b> to multiple
     * <b>BusSolnOrdItmUserStatus</b>.
     *
     */
    @SerializedName( "to_UserStatus" )
    @JsonProperty( "to_UserStatus" )
    @ODataField( odataName = "to_UserStatus" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BusSolnOrdItmUserStatus> toUserStatus;
    /**
     * Use with available fluent helpers to apply the <b>to_BusinessSolutionOrder</b> navigation property to query
     * operations.
     *
     */
    public final static BusSolnOrderSalesItemOneToOneLink<BusinessSolutionOrder> TO_BUSINESS_SOLUTION_ORDER =
        new BusSolnOrderSalesItemOneToOneLink<BusinessSolutionOrder>("to_BusinessSolutionOrder");
    /**
     * Use with available fluent helpers to apply the <b>to_Configurations</b> navigation property to query operations.
     *
     */
    public final static BusSolnOrderSalesItemLink<BusSolnOrdItmConfiguration> TO_CONFIGURATIONS =
        new BusSolnOrderSalesItemLink<BusSolnOrdItmConfiguration>("to_Configurations");
    /**
     * Use with available fluent helpers to apply the <b>to_PriceElement</b> navigation property to query operations.
     *
     */
    public final static BusSolnOrderSalesItemLink<BusSolnOrderItemPriceElement> TO_PRICE_ELEMENT =
        new BusSolnOrderSalesItemLink<BusSolnOrderItemPriceElement>("to_PriceElement");
    /**
     * Use with available fluent helpers to apply the <b>to_SalesOrder</b> navigation property to query operations.
     *
     */
    public final static BusSolnOrderSalesItemLink<BusSolnOrdItmFUPSalesOrder> TO_SALES_ORDER =
        new BusSolnOrderSalesItemLink<BusSolnOrdItmFUPSalesOrder>("to_SalesOrder");
    /**
     * Use with available fluent helpers to apply the <b>to_ScheduleLine</b> navigation property to query operations.
     *
     */
    public final static BusSolnOrderSalesItemLink<BusSolnOrderItemScheduleLine> TO_SCHEDULE_LINE =
        new BusSolnOrderSalesItemLink<BusSolnOrderItemScheduleLine>("to_ScheduleLine");
    /**
     * Use with available fluent helpers to apply the <b>to_Text</b> navigation property to query operations.
     *
     */
    public final static BusSolnOrderSalesItemLink<BusSolutionOrderItemText> TO_TEXT =
        new BusSolnOrderSalesItemLink<BusSolutionOrderItemText>("to_Text");
    /**
     * Use with available fluent helpers to apply the <b>to_UserStatus</b> navigation property to query operations.
     *
     */
    public final static BusSolnOrderSalesItemLink<BusSolnOrdItmUserStatus> TO_USER_STATUS =
        new BusSolnOrderSalesItemLink<BusSolnOrdItmUserStatus>("to_UserStatus");

    @Nonnull
    @Override
    public Class<BusSolnOrderSalesItem> getType()
    {
        return BusSolnOrderSalesItem.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BusinessSolutionOrder</b>
     * </p>
     *
     * @param businessSolutionOrder
     *            Transaction ID
     */
    public void setBusinessSolutionOrder( @Nullable final String businessSolutionOrder )
    {
        rememberChangedField("BusinessSolutionOrder", this.businessSolutionOrder);
        this.businessSolutionOrder = businessSolutionOrder;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BusinessSolutionOrderItem</b>
     * </p>
     *
     * @param businessSolutionOrderItem
     *            Shortened Item Number in Document
     */
    public void setBusinessSolutionOrderItem( @Nullable final String businessSolutionOrderItem )
    {
        rememberChangedField("BusinessSolutionOrderItem", this.businessSolutionOrderItem);
        this.businessSolutionOrderItem = businessSolutionOrderItem;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocumentItemCharUUID</b>
     * </p>
     *
     * @param serviceDocumentItemCharUUID
     *            32 Character CRM Object GUID (Converted)
     */
    public void setServiceDocumentItemCharUUID( @Nullable final UUID serviceDocumentItemCharUUID )
    {
        rememberChangedField("ServiceDocumentItemCharUUID", this.serviceDocumentItemCharUUID);
        this.serviceDocumentItemCharUUID = serviceDocumentItemCharUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BusinessSolutionOrderItemUUID</b>
     * </p>
     *
     * @param businessSolutionOrderItemUUID
     *            GUID of a CRM Order Object
     */
    public void setBusinessSolutionOrderItemUUID( @Nullable final UUID businessSolutionOrderItemUUID )
    {
        rememberChangedField("BusinessSolutionOrderItemUUID", this.businessSolutionOrderItemUUID);
        this.businessSolutionOrderItemUUID = businessSolutionOrderItemUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmCategory</b>
     * </p>
     *
     * @param busSolnOrdItmCategory
     *            Item Category
     */
    public void setBusSolnOrdItmCategory( @Nullable final String busSolnOrdItmCategory )
    {
        rememberChangedField("BusSolnOrdItmCategory", this.busSolnOrdItmCategory);
        this.busSolnOrdItmCategory = busSolnOrdItmCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 54
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @param product
     *            Product Name Entered
     */
    public void setProduct( @Nullable final String product )
    {
        rememberChangedField("Product", this.product);
        this.product = product;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Quantity</b>
     * </p>
     *
     * @param quantity
     *            CRM: Order Quantity
     */
    public void setQuantity( @Nullable final BigDecimal quantity )
    {
        rememberChangedField("Quantity", this.quantity);
        this.quantity = quantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>QuantityUnit</b>
     * </p>
     *
     * @param quantityUnit
     *            Unit of Measure in Which the Product Is Sold
     */
    public void setQuantityUnit( @Nullable final String quantityUnit )
    {
        rememberChangedField("QuantityUnit", this.quantityUnit);
        this.quantityUnit = quantityUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmQtyUnitSAPCode</b>
     * </p>
     *
     * @param busSolnOrdItmQtyUnitSAPCode
     *            SAP Unit Code for Order Quantity
     */
    public void setBusSolnOrdItmQtyUnitSAPCode( @Nullable final String busSolnOrdItmQtyUnitSAPCode )
    {
        rememberChangedField("BusSolnOrdItmQtyUnitSAPCode", this.busSolnOrdItmQtyUnitSAPCode);
        this.busSolnOrdItmQtyUnitSAPCode = busSolnOrdItmQtyUnitSAPCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmQtyUnitISOCode</b>
     * </p>
     *
     * @param busSolnOrdItmQtyUnitISOCode
     *            ISO Unit Code for Order Quantity
     */
    public void setBusSolnOrdItmQtyUnitISOCode( @Nullable final String busSolnOrdItmQtyUnitISOCode )
    {
        rememberChangedField("BusSolnOrdItmQtyUnitISOCode", this.busSolnOrdItmQtyUnitISOCode);
        this.busSolnOrdItmQtyUnitISOCode = busSolnOrdItmQtyUnitISOCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmDescription</b>
     * </p>
     *
     * @param busSolnOrdItmDescription
     *            Product Description
     */
    public void setBusSolnOrdItmDescription( @Nullable final String busSolnOrdItmDescription )
    {
        rememberChangedField("BusSolnOrdItmDescription", this.busSolnOrdItmDescription);
        this.busSolnOrdItmDescription = busSolnOrdItmDescription;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Short Text Language for an Item
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmExtReference</b>
     * </p>
     *
     * @param busSolnOrdItmExtReference
     *            External Reference Number
     */
    public void setBusSolnOrdItmExtReference( @Nullable final String busSolnOrdItmExtReference )
    {
        rememberChangedField("BusSolnOrdItmExtReference", this.busSolnOrdItmExtReference);
        this.busSolnOrdItmExtReference = busSolnOrdItmExtReference;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemOrderProbabilityInPercent</b>
     * </p>
     *
     * @param itemOrderProbabilityInPercent
     *            Order Probability
     */
    public void setItemOrderProbabilityInPercent( @Nullable final String itemOrderProbabilityInPercent )
    {
        rememberChangedField("ItemOrderProbabilityInPercent", this.itemOrderProbabilityInPercent);
        this.itemOrderProbabilityInPercent = itemOrderProbabilityInPercent;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PaymentTerms</b>
     * </p>
     *
     * @param paymentTerms
     *            Terms of Payment
     */
    public void setPaymentTerms( @Nullable final String paymentTerms )
    {
        rememberChangedField("PaymentTerms", this.paymentTerms);
        this.paymentTerms = paymentTerms;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsPart1</b>
     * </p>
     *
     * @param incotermsPart1
     *            Incoterms (Part 1)
     */
    public void setIncotermsPart1( @Nullable final String incotermsPart1 )
    {
        rememberChangedField("IncotermsPart1", this.incotermsPart1);
        this.incotermsPart1 = incotermsPart1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 28
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsPart2</b>
     * </p>
     *
     * @param incotermsPart2
     *            Incoterms (Part 2)
     */
    public void setIncotermsPart2( @Nullable final String incotermsPart2 )
    {
        rememberChangedField("IncotermsPart2", this.incotermsPart2);
        this.incotermsPart2 = incotermsPart2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmIsReleased</b>
     * </p>
     *
     * @param busSolnOrdItmIsReleased
     *            Release Status
     */
    public void setBusSolnOrdItmIsReleased( @Nullable final String busSolnOrdItmIsReleased )
    {
        rememberChangedField("BusSolnOrdItmIsReleased", this.busSolnOrdItmIsReleased);
        this.busSolnOrdItmIsReleased = busSolnOrdItmIsReleased;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmIsCompleted</b>
     * </p>
     *
     * @param busSolnOrdItmIsCompleted
     *            The busSolnOrdItmIsCompleted to set.
     */
    public void setBusSolnOrdItmIsCompleted( @Nullable final String busSolnOrdItmIsCompleted )
    {
        rememberChangedField("BusSolnOrdItmIsCompleted", this.busSolnOrdItmIsCompleted);
        this.busSolnOrdItmIsCompleted = busSolnOrdItmIsCompleted;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmIsRejected</b>
     * </p>
     *
     * @param busSolnOrdItmIsRejected
     *            Cancellation Status
     */
    public void setBusSolnOrdItmIsRejected( @Nullable final String busSolnOrdItmIsRejected )
    {
        rememberChangedField("BusSolnOrdItmIsRejected", this.busSolnOrdItmIsRejected);
        this.busSolnOrdItmIsRejected = busSolnOrdItmIsRejected;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmDistrStatus</b>
     * </p>
     *
     * @param busSolnOrdItmDistrStatus
     *            The busSolnOrdItmDistrStatus to set.
     */
    public void setBusSolnOrdItmDistrStatus( @Nullable final String busSolnOrdItmDistrStatus )
    {
        rememberChangedField("BusSolnOrdItmDistrStatus", this.busSolnOrdItmDistrStatus);
        this.busSolnOrdItmDistrStatus = busSolnOrdItmDistrStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmDistrStatusName</b>
     * </p>
     *
     * @param busSolnOrdItmDistrStatusName
     *            The busSolnOrdItmDistrStatusName to set.
     */
    public void setBusSolnOrdItmDistrStatusName( @Nullable final String busSolnOrdItmDistrStatusName )
    {
        rememberChangedField("BusSolnOrdItmDistrStatusName", this.busSolnOrdItmDistrStatusName);
        this.busSolnOrdItmDistrStatusName = busSolnOrdItmDistrStatusName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmRjcnReason</b>
     * </p>
     *
     * @param busSolnOrdItmRjcnReason
     *            Cancellation Reason Code
     */
    public void setBusSolnOrdItmRjcnReason( @Nullable final String busSolnOrdItmRjcnReason )
    {
        rememberChangedField("BusSolnOrdItmRjcnReason", this.busSolnOrdItmRjcnReason);
        this.busSolnOrdItmRjcnReason = busSolnOrdItmRjcnReason;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdItmRjcnReasonText</b>
     * </p>
     *
     * @param busSolnOrdItmRjcnReasonText
     *            Description
     */
    public void setBusSolnOrdItmRjcnReasonText( @Nullable final String busSolnOrdItmRjcnReasonText )
    {
        rememberChangedField("BusSolnOrdItmRjcnReasonText", this.busSolnOrdItmRjcnReasonText);
        this.busSolnOrdItmRjcnReasonText = busSolnOrdItmRjcnReasonText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SrvcDocItmDeliveryStatus</b>
     * </p>
     *
     * @param srvcDocItmDeliveryStatus
     *            Delivery Status
     */
    public void setSrvcDocItmDeliveryStatus( @Nullable final String srvcDocItmDeliveryStatus )
    {
        rememberChangedField("SrvcDocItmDeliveryStatus", this.srvcDocItmDeliveryStatus);
        this.srvcDocItmDeliveryStatus = srvcDocItmDeliveryStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>SrvcDocDeliveryStatusText</b>
     * </p>
     *
     * @param srvcDocDeliveryStatusText
     *            Short Text for Fixed Values
     */
    public void setSrvcDocDeliveryStatusText( @Nullable final String srvcDocDeliveryStatusText )
    {
        rememberChangedField("SrvcDocDeliveryStatusText", this.srvcDocDeliveryStatusText);
        this.srvcDocDeliveryStatusText = srvcDocDeliveryStatusText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocItemBillingStatus</b>
     * </p>
     *
     * @param serviceDocItemBillingStatus
     *            Billing Status
     */
    public void setServiceDocItemBillingStatus( @Nullable final String serviceDocItemBillingStatus )
    {
        rememberChangedField("ServiceDocItemBillingStatus", this.serviceDocItemBillingStatus);
        this.serviceDocItemBillingStatus = serviceDocItemBillingStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BillingBlockReason</b>
     * </p>
     *
     * @param billingBlockReason
     *            Business Partner: Billing Block Reason
     */
    public void setBillingBlockReason( @Nullable final String billingBlockReason )
    {
        rememberChangedField("BillingBlockReason", this.billingBlockReason);
        this.billingBlockReason = billingBlockReason;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SoldToParty</b>
     * </p>
     *
     * @param soldToParty
     *            Sold-To Party
     */
    public void setSoldToParty( @Nullable final String soldToParty )
    {
        rememberChangedField("SoldToParty", this.soldToParty);
        this.soldToParty = soldToParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ShipToParty</b>
     * </p>
     *
     * @param shipToParty
     *            Ship-To Party
     */
    public void setShipToParty( @Nullable final String shipToParty )
    {
        rememberChangedField("ShipToParty", this.shipToParty);
        this.shipToParty = shipToParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BillToParty</b>
     * </p>
     *
     * @param billToParty
     *            Bill-To Party
     */
    public void setBillToParty( @Nullable final String billToParty )
    {
        rememberChangedField("BillToParty", this.billToParty);
        this.billToParty = billToParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PayerParty</b>
     * </p>
     *
     * @param payerParty
     *            Payer
     */
    public void setPayerParty( @Nullable final String payerParty )
    {
        rememberChangedField("PayerParty", this.payerParty);
        this.payerParty = payerParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PersonResponsible</b>
     * </p>
     *
     * @param personResponsible
     *            Employee Responsible
     */
    public void setPersonResponsible( @Nullable final String personResponsible )
    {
        rememberChangedField("PersonResponsible", this.personResponsible);
        this.personResponsible = personResponsible;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ContactPerson</b>
     * </p>
     *
     * @param contactPerson
     *            Customer Contact Person
     */
    public void setContactPerson( @Nullable final String contactPerson )
    {
        rememberChangedField("ContactPerson", this.contactPerson);
        this.contactPerson = contactPerson;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryPriority</b>
     * </p>
     *
     * @param deliveryPriority
     *            Delivery Priority
     */
    public void setDeliveryPriority( @Nullable final String deliveryPriority )
    {
        rememberChangedField("DeliveryPriority", this.deliveryPriority);
        this.deliveryPriority = deliveryPriority;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PartialDeliveryIsAllowed</b>
     * </p>
     *
     * @param partialDeliveryIsAllowed
     *            Delivery Control (Item)
     */
    public void setPartialDeliveryIsAllowed( @Nullable final String partialDeliveryIsAllowed )
    {
        rememberChangedField("PartialDeliveryIsAllowed", this.partialDeliveryIsAllowed);
        this.partialDeliveryIsAllowed = partialDeliveryIsAllowed;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>OrderCombinationIsAllowed</b>
     * </p>
     *
     * @param orderCombinationIsAllowed
     *            Indicator: Order Combination
     */
    public void setOrderCombinationIsAllowed( @Nullable final Boolean orderCombinationIsAllowed )
    {
        rememberChangedField("OrderCombinationIsAllowed", this.orderCombinationIsAllowed);
        this.orderCombinationIsAllowed = orderCombinationIsAllowed;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryBlockReason</b>
     * </p>
     *
     * @param deliveryBlockReason
     *            Business Partner: Delivery Block Reason
     */
    public void setDeliveryBlockReason( @Nullable final String deliveryBlockReason )
    {
        rememberChangedField("DeliveryBlockReason", this.deliveryBlockReason);
        this.deliveryBlockReason = deliveryBlockReason;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RequestedDeliveryUTCDateTime</b>
     * </p>
     *
     * @param requestedDeliveryUTCDateTime
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setRequestedDeliveryUTCDateTime( @Nullable final ZonedDateTime requestedDeliveryUTCDateTime )
    {
        rememberChangedField("RequestedDeliveryUTCDateTime", this.requestedDeliveryUTCDateTime);
        this.requestedDeliveryUTCDateTime = requestedDeliveryUTCDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocumentItemNetAmount</b>
     * </p>
     *
     * @param serviceDocumentItemNetAmount
     *            Net Value
     */
    public void setServiceDocumentItemNetAmount( @Nullable final BigDecimal serviceDocumentItemNetAmount )
    {
        rememberChangedField("ServiceDocumentItemNetAmount", this.serviceDocumentItemNetAmount);
        this.serviceDocumentItemNetAmount = serviceDocumentItemNetAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @param transactionCurrency
     *            Currency
     */
    public void setTransactionCurrency( @Nullable final String transactionCurrency )
    {
        rememberChangedField("TransactionCurrency", this.transactionCurrency);
        this.transactionCurrency = transactionCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @param profitCenter
     *            Profit Center
     */
    public void setProfitCenter( @Nullable final String profitCenter )
    {
        rememberChangedField("ProfitCenter", this.profitCenter);
        this.profitCenter = profitCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderByCustomer</b>
     * </p>
     *
     * @param purchaseOrderByCustomer
     *            Sold-To Party's External Reference Number
     */
    public void setPurchaseOrderByCustomer( @Nullable final String purchaseOrderByCustomer )
    {
        rememberChangedField("PurchaseOrderByCustomer", this.purchaseOrderByCustomer);
        this.purchaseOrderByCustomer = purchaseOrderByCustomer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MaterialPricingGroup</b>
     * </p>
     *
     * @param materialPricingGroup
     *            Material Price Group
     */
    public void setMaterialPricingGroup( @Nullable final String materialPricingGroup )
    {
        rememberChangedField("MaterialPricingGroup", this.materialPricingGroup);
        this.materialPricingGroup = materialPricingGroup;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemGrossWeight</b>
     * </p>
     *
     * @param itemGrossWeight
     *            Gross Weight
     */
    public void setItemGrossWeight( @Nullable final BigDecimal itemGrossWeight )
    {
        rememberChangedField("ItemGrossWeight", this.itemGrossWeight);
        this.itemGrossWeight = itemGrossWeight;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemNetWeight</b>
     * </p>
     *
     * @param itemNetWeight
     *            Net Weight
     */
    public void setItemNetWeight( @Nullable final BigDecimal itemNetWeight )
    {
        rememberChangedField("ItemNetWeight", this.itemNetWeight);
        this.itemNetWeight = itemNetWeight;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemWeightUnit</b>
     * </p>
     *
     * @param itemWeightUnit
     *            Unit of Weight
     */
    public void setItemWeightUnit( @Nullable final String itemWeightUnit )
    {
        rememberChangedField("ItemWeightUnit", this.itemWeightUnit);
        this.itemWeightUnit = itemWeightUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemVolume</b>
     * </p>
     *
     * @param itemVolume
     *            Volume Occupied by the Product per Volume Unit
     */
    public void setItemVolume( @Nullable final BigDecimal itemVolume )
    {
        rememberChangedField("ItemVolume", this.itemVolume);
        this.itemVolume = itemVolume;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemVolumeUnit</b>
     * </p>
     *
     * @param itemVolumeUnit
     *            Unit for the Volume of a Product
     */
    public void setItemVolumeUnit( @Nullable final String itemVolumeUnit )
    {
        rememberChangedField("ItemVolumeUnit", this.itemVolumeUnit);
        this.itemVolumeUnit = itemVolumeUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryGroup</b>
     * </p>
     *
     * @param deliveryGroup
     *            Delivery Group (Items are Delivered Together)
     */
    public void setDeliveryGroup( @Nullable final String deliveryGroup )
    {
        rememberChangedField("DeliveryGroup", this.deliveryGroup);
        this.deliveryGroup = deliveryGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 32
     * <p>
     * Original property name from the Odata EDM: <b>CPQQuotationItem</b>
     * </p>
     *
     * @param cPQQuotationItem
     *            Identification of a Reference Object for Items
     */
    public void setCPQQuotationItem( @Nullable final String cPQQuotationItem )
    {
        rememberChangedField("CPQQuotationItem", this.cPQQuotationItem);
        this.cPQQuotationItem = cPQQuotationItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>ConfigurationNumber</b>
     * </p>
     *
     * @param configurationNumber
     *            Configuration (Internal Object Number)
     */
    public void setConfigurationNumber( @Nullable final String configurationNumber )
    {
        rememberChangedField("ConfigurationNumber", this.configurationNumber);
        this.configurationNumber = configurationNumber;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_BusSolnOrderSalesItem";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("BusinessSolutionOrder", getBusinessSolutionOrder());
        result.put("BusinessSolutionOrderItem", getBusinessSolutionOrderItem());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("BusinessSolutionOrder", getBusinessSolutionOrder());
        values.put("BusinessSolutionOrderItem", getBusinessSolutionOrderItem());
        values.put("ServiceDocumentItemCharUUID", getServiceDocumentItemCharUUID());
        values.put("BusinessSolutionOrderItemUUID", getBusinessSolutionOrderItemUUID());
        values.put("BusSolnOrdItmCategory", getBusSolnOrdItmCategory());
        values.put("Product", getProduct());
        values.put("Quantity", getQuantity());
        values.put("QuantityUnit", getQuantityUnit());
        values.put("BusSolnOrdItmQtyUnitSAPCode", getBusSolnOrdItmQtyUnitSAPCode());
        values.put("BusSolnOrdItmQtyUnitISOCode", getBusSolnOrdItmQtyUnitISOCode());
        values.put("BusSolnOrdItmDescription", getBusSolnOrdItmDescription());
        values.put("Language", getLanguage());
        values.put("BusSolnOrdItmExtReference", getBusSolnOrdItmExtReference());
        values.put("ItemOrderProbabilityInPercent", getItemOrderProbabilityInPercent());
        values.put("PaymentTerms", getPaymentTerms());
        values.put("IncotermsPart1", getIncotermsPart1());
        values.put("IncotermsPart2", getIncotermsPart2());
        values.put("Plant", getPlant());
        values.put("BusSolnOrdItmIsReleased", getBusSolnOrdItmIsReleased());
        values.put("BusSolnOrdItmIsCompleted", getBusSolnOrdItmIsCompleted());
        values.put("BusSolnOrdItmIsRejected", getBusSolnOrdItmIsRejected());
        values.put("BusSolnOrdItmDistrStatus", getBusSolnOrdItmDistrStatus());
        values.put("BusSolnOrdItmDistrStatusName", getBusSolnOrdItmDistrStatusName());
        values.put("BusSolnOrdItmRjcnReason", getBusSolnOrdItmRjcnReason());
        values.put("BusSolnOrdItmRjcnReasonText", getBusSolnOrdItmRjcnReasonText());
        values.put("SrvcDocItmDeliveryStatus", getSrvcDocItmDeliveryStatus());
        values.put("SrvcDocDeliveryStatusText", getSrvcDocDeliveryStatusText());
        values.put("ServiceDocItemBillingStatus", getServiceDocItemBillingStatus());
        values.put("BillingBlockReason", getBillingBlockReason());
        values.put("SoldToParty", getSoldToParty());
        values.put("ShipToParty", getShipToParty());
        values.put("BillToParty", getBillToParty());
        values.put("PayerParty", getPayerParty());
        values.put("PersonResponsible", getPersonResponsible());
        values.put("ContactPerson", getContactPerson());
        values.put("DeliveryPriority", getDeliveryPriority());
        values.put("PartialDeliveryIsAllowed", getPartialDeliveryIsAllowed());
        values.put("OrderCombinationIsAllowed", getOrderCombinationIsAllowed());
        values.put("DeliveryBlockReason", getDeliveryBlockReason());
        values.put("RequestedDeliveryUTCDateTime", getRequestedDeliveryUTCDateTime());
        values.put("ServiceDocumentItemNetAmount", getServiceDocumentItemNetAmount());
        values.put("TransactionCurrency", getTransactionCurrency());
        values.put("ProfitCenter", getProfitCenter());
        values.put("PurchaseOrderByCustomer", getPurchaseOrderByCustomer());
        values.put("MaterialPricingGroup", getMaterialPricingGroup());
        values.put("ItemGrossWeight", getItemGrossWeight());
        values.put("ItemNetWeight", getItemNetWeight());
        values.put("ItemWeightUnit", getItemWeightUnit());
        values.put("ItemVolume", getItemVolume());
        values.put("ItemVolumeUnit", getItemVolumeUnit());
        values.put("DeliveryGroup", getDeliveryGroup());
        values.put("CPQQuotationItem", getCPQQuotationItem());
        values.put("ConfigurationNumber", getConfigurationNumber());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("BusinessSolutionOrder") ) {
                final Object value = values.remove("BusinessSolutionOrder");
                if( (value == null) || (!value.equals(getBusinessSolutionOrder())) ) {
                    setBusinessSolutionOrder(((String) value));
                }
            }
            if( values.containsKey("BusinessSolutionOrderItem") ) {
                final Object value = values.remove("BusinessSolutionOrderItem");
                if( (value == null) || (!value.equals(getBusinessSolutionOrderItem())) ) {
                    setBusinessSolutionOrderItem(((String) value));
                }
            }
            if( values.containsKey("ServiceDocumentItemCharUUID") ) {
                final Object value = values.remove("ServiceDocumentItemCharUUID");
                if( (value == null) || (!value.equals(getServiceDocumentItemCharUUID())) ) {
                    setServiceDocumentItemCharUUID(((UUID) value));
                }
            }
            if( values.containsKey("BusinessSolutionOrderItemUUID") ) {
                final Object value = values.remove("BusinessSolutionOrderItemUUID");
                if( (value == null) || (!value.equals(getBusinessSolutionOrderItemUUID())) ) {
                    setBusinessSolutionOrderItemUUID(((UUID) value));
                }
            }
            if( values.containsKey("BusSolnOrdItmCategory") ) {
                final Object value = values.remove("BusSolnOrdItmCategory");
                if( (value == null) || (!value.equals(getBusSolnOrdItmCategory())) ) {
                    setBusSolnOrdItmCategory(((String) value));
                }
            }
            if( values.containsKey("Product") ) {
                final Object value = values.remove("Product");
                if( (value == null) || (!value.equals(getProduct())) ) {
                    setProduct(((String) value));
                }
            }
            if( values.containsKey("Quantity") ) {
                final Object value = values.remove("Quantity");
                if( (value == null) || (!value.equals(getQuantity())) ) {
                    setQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("QuantityUnit") ) {
                final Object value = values.remove("QuantityUnit");
                if( (value == null) || (!value.equals(getQuantityUnit())) ) {
                    setQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("BusSolnOrdItmQtyUnitSAPCode") ) {
                final Object value = values.remove("BusSolnOrdItmQtyUnitSAPCode");
                if( (value == null) || (!value.equals(getBusSolnOrdItmQtyUnitSAPCode())) ) {
                    setBusSolnOrdItmQtyUnitSAPCode(((String) value));
                }
            }
            if( values.containsKey("BusSolnOrdItmQtyUnitISOCode") ) {
                final Object value = values.remove("BusSolnOrdItmQtyUnitISOCode");
                if( (value == null) || (!value.equals(getBusSolnOrdItmQtyUnitISOCode())) ) {
                    setBusSolnOrdItmQtyUnitISOCode(((String) value));
                }
            }
            if( values.containsKey("BusSolnOrdItmDescription") ) {
                final Object value = values.remove("BusSolnOrdItmDescription");
                if( (value == null) || (!value.equals(getBusSolnOrdItmDescription())) ) {
                    setBusSolnOrdItmDescription(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("BusSolnOrdItmExtReference") ) {
                final Object value = values.remove("BusSolnOrdItmExtReference");
                if( (value == null) || (!value.equals(getBusSolnOrdItmExtReference())) ) {
                    setBusSolnOrdItmExtReference(((String) value));
                }
            }
            if( values.containsKey("ItemOrderProbabilityInPercent") ) {
                final Object value = values.remove("ItemOrderProbabilityInPercent");
                if( (value == null) || (!value.equals(getItemOrderProbabilityInPercent())) ) {
                    setItemOrderProbabilityInPercent(((String) value));
                }
            }
            if( values.containsKey("PaymentTerms") ) {
                final Object value = values.remove("PaymentTerms");
                if( (value == null) || (!value.equals(getPaymentTerms())) ) {
                    setPaymentTerms(((String) value));
                }
            }
            if( values.containsKey("IncotermsPart1") ) {
                final Object value = values.remove("IncotermsPart1");
                if( (value == null) || (!value.equals(getIncotermsPart1())) ) {
                    setIncotermsPart1(((String) value));
                }
            }
            if( values.containsKey("IncotermsPart2") ) {
                final Object value = values.remove("IncotermsPart2");
                if( (value == null) || (!value.equals(getIncotermsPart2())) ) {
                    setIncotermsPart2(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("BusSolnOrdItmIsReleased") ) {
                final Object value = values.remove("BusSolnOrdItmIsReleased");
                if( (value == null) || (!value.equals(getBusSolnOrdItmIsReleased())) ) {
                    setBusSolnOrdItmIsReleased(((String) value));
                }
            }
            if( values.containsKey("BusSolnOrdItmIsCompleted") ) {
                final Object value = values.remove("BusSolnOrdItmIsCompleted");
                if( (value == null) || (!value.equals(getBusSolnOrdItmIsCompleted())) ) {
                    setBusSolnOrdItmIsCompleted(((String) value));
                }
            }
            if( values.containsKey("BusSolnOrdItmIsRejected") ) {
                final Object value = values.remove("BusSolnOrdItmIsRejected");
                if( (value == null) || (!value.equals(getBusSolnOrdItmIsRejected())) ) {
                    setBusSolnOrdItmIsRejected(((String) value));
                }
            }
            if( values.containsKey("BusSolnOrdItmDistrStatus") ) {
                final Object value = values.remove("BusSolnOrdItmDistrStatus");
                if( (value == null) || (!value.equals(getBusSolnOrdItmDistrStatus())) ) {
                    setBusSolnOrdItmDistrStatus(((String) value));
                }
            }
            if( values.containsKey("BusSolnOrdItmDistrStatusName") ) {
                final Object value = values.remove("BusSolnOrdItmDistrStatusName");
                if( (value == null) || (!value.equals(getBusSolnOrdItmDistrStatusName())) ) {
                    setBusSolnOrdItmDistrStatusName(((String) value));
                }
            }
            if( values.containsKey("BusSolnOrdItmRjcnReason") ) {
                final Object value = values.remove("BusSolnOrdItmRjcnReason");
                if( (value == null) || (!value.equals(getBusSolnOrdItmRjcnReason())) ) {
                    setBusSolnOrdItmRjcnReason(((String) value));
                }
            }
            if( values.containsKey("BusSolnOrdItmRjcnReasonText") ) {
                final Object value = values.remove("BusSolnOrdItmRjcnReasonText");
                if( (value == null) || (!value.equals(getBusSolnOrdItmRjcnReasonText())) ) {
                    setBusSolnOrdItmRjcnReasonText(((String) value));
                }
            }
            if( values.containsKey("SrvcDocItmDeliveryStatus") ) {
                final Object value = values.remove("SrvcDocItmDeliveryStatus");
                if( (value == null) || (!value.equals(getSrvcDocItmDeliveryStatus())) ) {
                    setSrvcDocItmDeliveryStatus(((String) value));
                }
            }
            if( values.containsKey("SrvcDocDeliveryStatusText") ) {
                final Object value = values.remove("SrvcDocDeliveryStatusText");
                if( (value == null) || (!value.equals(getSrvcDocDeliveryStatusText())) ) {
                    setSrvcDocDeliveryStatusText(((String) value));
                }
            }
            if( values.containsKey("ServiceDocItemBillingStatus") ) {
                final Object value = values.remove("ServiceDocItemBillingStatus");
                if( (value == null) || (!value.equals(getServiceDocItemBillingStatus())) ) {
                    setServiceDocItemBillingStatus(((String) value));
                }
            }
            if( values.containsKey("BillingBlockReason") ) {
                final Object value = values.remove("BillingBlockReason");
                if( (value == null) || (!value.equals(getBillingBlockReason())) ) {
                    setBillingBlockReason(((String) value));
                }
            }
            if( values.containsKey("SoldToParty") ) {
                final Object value = values.remove("SoldToParty");
                if( (value == null) || (!value.equals(getSoldToParty())) ) {
                    setSoldToParty(((String) value));
                }
            }
            if( values.containsKey("ShipToParty") ) {
                final Object value = values.remove("ShipToParty");
                if( (value == null) || (!value.equals(getShipToParty())) ) {
                    setShipToParty(((String) value));
                }
            }
            if( values.containsKey("BillToParty") ) {
                final Object value = values.remove("BillToParty");
                if( (value == null) || (!value.equals(getBillToParty())) ) {
                    setBillToParty(((String) value));
                }
            }
            if( values.containsKey("PayerParty") ) {
                final Object value = values.remove("PayerParty");
                if( (value == null) || (!value.equals(getPayerParty())) ) {
                    setPayerParty(((String) value));
                }
            }
            if( values.containsKey("PersonResponsible") ) {
                final Object value = values.remove("PersonResponsible");
                if( (value == null) || (!value.equals(getPersonResponsible())) ) {
                    setPersonResponsible(((String) value));
                }
            }
            if( values.containsKey("ContactPerson") ) {
                final Object value = values.remove("ContactPerson");
                if( (value == null) || (!value.equals(getContactPerson())) ) {
                    setContactPerson(((String) value));
                }
            }
            if( values.containsKey("DeliveryPriority") ) {
                final Object value = values.remove("DeliveryPriority");
                if( (value == null) || (!value.equals(getDeliveryPriority())) ) {
                    setDeliveryPriority(((String) value));
                }
            }
            if( values.containsKey("PartialDeliveryIsAllowed") ) {
                final Object value = values.remove("PartialDeliveryIsAllowed");
                if( (value == null) || (!value.equals(getPartialDeliveryIsAllowed())) ) {
                    setPartialDeliveryIsAllowed(((String) value));
                }
            }
            if( values.containsKey("OrderCombinationIsAllowed") ) {
                final Object value = values.remove("OrderCombinationIsAllowed");
                if( (value == null) || (!value.equals(getOrderCombinationIsAllowed())) ) {
                    setOrderCombinationIsAllowed(((Boolean) value));
                }
            }
            if( values.containsKey("DeliveryBlockReason") ) {
                final Object value = values.remove("DeliveryBlockReason");
                if( (value == null) || (!value.equals(getDeliveryBlockReason())) ) {
                    setDeliveryBlockReason(((String) value));
                }
            }
            if( values.containsKey("RequestedDeliveryUTCDateTime") ) {
                final Object value = values.remove("RequestedDeliveryUTCDateTime");
                if( (value == null) || (!value.equals(getRequestedDeliveryUTCDateTime())) ) {
                    setRequestedDeliveryUTCDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("ServiceDocumentItemNetAmount") ) {
                final Object value = values.remove("ServiceDocumentItemNetAmount");
                if( (value == null) || (!value.equals(getServiceDocumentItemNetAmount())) ) {
                    setServiceDocumentItemNetAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("TransactionCurrency") ) {
                final Object value = values.remove("TransactionCurrency");
                if( (value == null) || (!value.equals(getTransactionCurrency())) ) {
                    setTransactionCurrency(((String) value));
                }
            }
            if( values.containsKey("ProfitCenter") ) {
                final Object value = values.remove("ProfitCenter");
                if( (value == null) || (!value.equals(getProfitCenter())) ) {
                    setProfitCenter(((String) value));
                }
            }
            if( values.containsKey("PurchaseOrderByCustomer") ) {
                final Object value = values.remove("PurchaseOrderByCustomer");
                if( (value == null) || (!value.equals(getPurchaseOrderByCustomer())) ) {
                    setPurchaseOrderByCustomer(((String) value));
                }
            }
            if( values.containsKey("MaterialPricingGroup") ) {
                final Object value = values.remove("MaterialPricingGroup");
                if( (value == null) || (!value.equals(getMaterialPricingGroup())) ) {
                    setMaterialPricingGroup(((String) value));
                }
            }
            if( values.containsKey("ItemGrossWeight") ) {
                final Object value = values.remove("ItemGrossWeight");
                if( (value == null) || (!value.equals(getItemGrossWeight())) ) {
                    setItemGrossWeight(((BigDecimal) value));
                }
            }
            if( values.containsKey("ItemNetWeight") ) {
                final Object value = values.remove("ItemNetWeight");
                if( (value == null) || (!value.equals(getItemNetWeight())) ) {
                    setItemNetWeight(((BigDecimal) value));
                }
            }
            if( values.containsKey("ItemWeightUnit") ) {
                final Object value = values.remove("ItemWeightUnit");
                if( (value == null) || (!value.equals(getItemWeightUnit())) ) {
                    setItemWeightUnit(((String) value));
                }
            }
            if( values.containsKey("ItemVolume") ) {
                final Object value = values.remove("ItemVolume");
                if( (value == null) || (!value.equals(getItemVolume())) ) {
                    setItemVolume(((BigDecimal) value));
                }
            }
            if( values.containsKey("ItemVolumeUnit") ) {
                final Object value = values.remove("ItemVolumeUnit");
                if( (value == null) || (!value.equals(getItemVolumeUnit())) ) {
                    setItemVolumeUnit(((String) value));
                }
            }
            if( values.containsKey("DeliveryGroup") ) {
                final Object value = values.remove("DeliveryGroup");
                if( (value == null) || (!value.equals(getDeliveryGroup())) ) {
                    setDeliveryGroup(((String) value));
                }
            }
            if( values.containsKey("CPQQuotationItem") ) {
                final Object value = values.remove("CPQQuotationItem");
                if( (value == null) || (!value.equals(getCPQQuotationItem())) ) {
                    setCPQQuotationItem(((String) value));
                }
            }
            if( values.containsKey("ConfigurationNumber") ) {
                final Object value = values.remove("ConfigurationNumber");
                if( (value == null) || (!value.equals(getConfigurationNumber())) ) {
                    setConfigurationNumber(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_BusinessSolutionOrder") ) {
                final Object value = (values).remove("to_BusinessSolutionOrder");
                if( value instanceof Map ) {
                    if( toBusinessSolutionOrder == null ) {
                        toBusinessSolutionOrder = new BusinessSolutionOrder();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toBusinessSolutionOrder.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_Configurations") ) {
                final Object value = (values).remove("to_Configurations");
                if( value instanceof Iterable ) {
                    if( toConfigurations == null ) {
                        toConfigurations = Lists.newArrayList();
                    } else {
                        toConfigurations = Lists.newArrayList(toConfigurations);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BusSolnOrdItmConfiguration entity;
                        if( toConfigurations.size() > i ) {
                            entity = toConfigurations.get(i);
                        } else {
                            entity = new BusSolnOrdItmConfiguration();
                            toConfigurations.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_PriceElement") ) {
                final Object value = (values).remove("to_PriceElement");
                if( value instanceof Iterable ) {
                    if( toPriceElement == null ) {
                        toPriceElement = Lists.newArrayList();
                    } else {
                        toPriceElement = Lists.newArrayList(toPriceElement);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BusSolnOrderItemPriceElement entity;
                        if( toPriceElement.size() > i ) {
                            entity = toPriceElement.get(i);
                        } else {
                            entity = new BusSolnOrderItemPriceElement();
                            toPriceElement.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_SalesOrder") ) {
                final Object value = (values).remove("to_SalesOrder");
                if( value instanceof Iterable ) {
                    if( toSalesOrder == null ) {
                        toSalesOrder = Lists.newArrayList();
                    } else {
                        toSalesOrder = Lists.newArrayList(toSalesOrder);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BusSolnOrdItmFUPSalesOrder entity;
                        if( toSalesOrder.size() > i ) {
                            entity = toSalesOrder.get(i);
                        } else {
                            entity = new BusSolnOrdItmFUPSalesOrder();
                            toSalesOrder.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_ScheduleLine") ) {
                final Object value = (values).remove("to_ScheduleLine");
                if( value instanceof Iterable ) {
                    if( toScheduleLine == null ) {
                        toScheduleLine = Lists.newArrayList();
                    } else {
                        toScheduleLine = Lists.newArrayList(toScheduleLine);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BusSolnOrderItemScheduleLine entity;
                        if( toScheduleLine.size() > i ) {
                            entity = toScheduleLine.get(i);
                        } else {
                            entity = new BusSolnOrderItemScheduleLine();
                            toScheduleLine.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_Text") ) {
                final Object value = (values).remove("to_Text");
                if( value instanceof Iterable ) {
                    if( toText == null ) {
                        toText = Lists.newArrayList();
                    } else {
                        toText = Lists.newArrayList(toText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BusSolutionOrderItemText entity;
                        if( toText.size() > i ) {
                            entity = toText.get(i);
                        } else {
                            entity = new BusSolutionOrderItemText();
                            toText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_UserStatus") ) {
                final Object value = (values).remove("to_UserStatus");
                if( value instanceof Iterable ) {
                    if( toUserStatus == null ) {
                        toUserStatus = Lists.newArrayList();
                    } else {
                        toUserStatus = Lists.newArrayList(toUserStatus);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BusSolnOrdItmUserStatus entity;
                        if( toUserStatus.size() > i ) {
                            entity = toUserStatus.get(i);
                        } else {
                            entity = new BusSolnOrdItmUserStatus();
                            toUserStatus.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> BusSolnOrderSalesItemField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new BusSolnOrderSalesItemField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BusSolnOrderSalesItemField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BusSolnOrderSalesItemField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessSolutionOrderService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toBusinessSolutionOrder != null ) {
            (values).put("to_BusinessSolutionOrder", toBusinessSolutionOrder);
        }
        if( toConfigurations != null ) {
            (values).put("to_Configurations", toConfigurations);
        }
        if( toPriceElement != null ) {
            (values).put("to_PriceElement", toPriceElement);
        }
        if( toSalesOrder != null ) {
            (values).put("to_SalesOrder", toSalesOrder);
        }
        if( toScheduleLine != null ) {
            (values).put("to_ScheduleLine", toScheduleLine);
        }
        if( toText != null ) {
            (values).put("to_Text", toText);
        }
        if( toUserStatus != null ) {
            (values).put("to_UserStatus", toUserStatus);
        }
        return values;
    }

    /**
     * Fetches the <b>BusinessSolutionOrder</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_BusinessSolutionOrder</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>BusinessSolutionOrder</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BusinessSolutionOrder fetchBusinessSolutionOrder()
    {
        return fetchFieldAsSingle("to_BusinessSolutionOrder", BusinessSolutionOrder.class);
    }

    /**
     * Retrieval of associated <b>BusinessSolutionOrder</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_BusinessSolutionOrder</b>.
     * <p>
     * If the navigation property <b>to_BusinessSolutionOrder</b> of a queried <b>BusSolnOrderSalesItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BusinessSolutionOrder</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public BusinessSolutionOrder getBusinessSolutionOrderOrFetch()
    {
        if( toBusinessSolutionOrder == null ) {
            toBusinessSolutionOrder = fetchBusinessSolutionOrder();
        }
        return toBusinessSolutionOrder;
    }

    /**
     * Retrieval of associated <b>BusinessSolutionOrder</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_BusinessSolutionOrder</b>.
     * <p>
     * If the navigation property for an entity <b>BusSolnOrderSalesItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BusinessSolutionOrder</b> is already loaded, the result
     *         will contain the <b>BusinessSolutionOrder</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<BusinessSolutionOrder> getBusinessSolutionOrderIfPresent()
    {
        return Option.of(toBusinessSolutionOrder);
    }

    /**
     * Overwrites the associated <b>BusinessSolutionOrder</b> entity for the loaded navigation property
     * <b>to_BusinessSolutionOrder</b>.
     *
     * @param value
     *            New <b>BusinessSolutionOrder</b> entity.
     */
    public void setBusinessSolutionOrder( final BusinessSolutionOrder value )
    {
        toBusinessSolutionOrder = value;
    }

    /**
     * Fetches the <b>BusSolnOrdItmConfiguration</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_Configurations</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BusSolnOrdItmConfiguration</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusSolnOrdItmConfiguration> fetchConfigurations()
    {
        return fetchFieldAsList("to_Configurations", BusSolnOrdItmConfiguration.class);
    }

    /**
     * Retrieval of associated <b>BusSolnOrdItmConfiguration</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Configurations</b>.
     * <p>
     * If the navigation property <b>to_Configurations</b> of a queried <b>BusSolnOrderSalesItem</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BusSolnOrdItmConfiguration</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusSolnOrdItmConfiguration> getConfigurationsOrFetch()
    {
        if( toConfigurations == null ) {
            toConfigurations = fetchConfigurations();
        }
        return toConfigurations;
    }

    /**
     * Retrieval of associated <b>BusSolnOrdItmConfiguration</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Configurations</b>.
     * <p>
     * If the navigation property for an entity <b>BusSolnOrderSalesItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Configurations</b> is already loaded, the result will
     *         contain the <b>BusSolnOrdItmConfiguration</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BusSolnOrdItmConfiguration>> getConfigurationsIfPresent()
    {
        return Option.of(toConfigurations);
    }

    /**
     * Overwrites the list of associated <b>BusSolnOrdItmConfiguration</b> entities for the loaded navigation property
     * <b>to_Configurations</b>.
     * <p>
     * If the navigation property <b>to_Configurations</b> of a queried <b>BusSolnOrderSalesItem</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BusSolnOrdItmConfiguration</b> entities.
     */
    public void setConfigurations( @Nonnull final List<BusSolnOrdItmConfiguration> value )
    {
        if( toConfigurations == null ) {
            toConfigurations = Lists.newArrayList();
        }
        toConfigurations.clear();
        toConfigurations.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BusSolnOrdItmConfiguration</b> entities. This corresponds to the OData
     * navigation property <b>to_Configurations</b>.
     * <p>
     * If the navigation property <b>to_Configurations</b> of a queried <b>BusSolnOrderSalesItem</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BusSolnOrdItmConfiguration</b> entities.
     */
    public void addConfigurations( BusSolnOrdItmConfiguration... entity )
    {
        if( toConfigurations == null ) {
            toConfigurations = Lists.newArrayList();
        }
        toConfigurations.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>BusSolnOrderItemPriceElement</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_PriceElement</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BusSolnOrderItemPriceElement</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusSolnOrderItemPriceElement> fetchPriceElement()
    {
        return fetchFieldAsList("to_PriceElement", BusSolnOrderItemPriceElement.class);
    }

    /**
     * Retrieval of associated <b>BusSolnOrderItemPriceElement</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PriceElement</b>.
     * <p>
     * If the navigation property <b>to_PriceElement</b> of a queried <b>BusSolnOrderSalesItem</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BusSolnOrderItemPriceElement</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusSolnOrderItemPriceElement> getPriceElementOrFetch()
    {
        if( toPriceElement == null ) {
            toPriceElement = fetchPriceElement();
        }
        return toPriceElement;
    }

    /**
     * Retrieval of associated <b>BusSolnOrderItemPriceElement</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PriceElement</b>.
     * <p>
     * If the navigation property for an entity <b>BusSolnOrderSalesItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_PriceElement</b> is already loaded, the result will
     *         contain the <b>BusSolnOrderItemPriceElement</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BusSolnOrderItemPriceElement>> getPriceElementIfPresent()
    {
        return Option.of(toPriceElement);
    }

    /**
     * Overwrites the list of associated <b>BusSolnOrderItemPriceElement</b> entities for the loaded navigation property
     * <b>to_PriceElement</b>.
     * <p>
     * If the navigation property <b>to_PriceElement</b> of a queried <b>BusSolnOrderSalesItem</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BusSolnOrderItemPriceElement</b> entities.
     */
    public void setPriceElement( @Nonnull final List<BusSolnOrderItemPriceElement> value )
    {
        if( toPriceElement == null ) {
            toPriceElement = Lists.newArrayList();
        }
        toPriceElement.clear();
        toPriceElement.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BusSolnOrderItemPriceElement</b> entities. This corresponds to the
     * OData navigation property <b>to_PriceElement</b>.
     * <p>
     * If the navigation property <b>to_PriceElement</b> of a queried <b>BusSolnOrderSalesItem</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BusSolnOrderItemPriceElement</b> entities.
     */
    public void addPriceElement( BusSolnOrderItemPriceElement... entity )
    {
        if( toPriceElement == null ) {
            toPriceElement = Lists.newArrayList();
        }
        toPriceElement.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>BusSolnOrdItmFUPSalesOrder</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_SalesOrder</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BusSolnOrdItmFUPSalesOrder</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusSolnOrdItmFUPSalesOrder> fetchSalesOrder()
    {
        return fetchFieldAsList("to_SalesOrder", BusSolnOrdItmFUPSalesOrder.class);
    }

    /**
     * Retrieval of associated <b>BusSolnOrdItmFUPSalesOrder</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SalesOrder</b>.
     * <p>
     * If the navigation property <b>to_SalesOrder</b> of a queried <b>BusSolnOrderSalesItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BusSolnOrdItmFUPSalesOrder</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusSolnOrdItmFUPSalesOrder> getSalesOrderOrFetch()
    {
        if( toSalesOrder == null ) {
            toSalesOrder = fetchSalesOrder();
        }
        return toSalesOrder;
    }

    /**
     * Retrieval of associated <b>BusSolnOrdItmFUPSalesOrder</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SalesOrder</b>.
     * <p>
     * If the navigation property for an entity <b>BusSolnOrderSalesItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SalesOrder</b> is already loaded, the result will
     *         contain the <b>BusSolnOrdItmFUPSalesOrder</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BusSolnOrdItmFUPSalesOrder>> getSalesOrderIfPresent()
    {
        return Option.of(toSalesOrder);
    }

    /**
     * Overwrites the list of associated <b>BusSolnOrdItmFUPSalesOrder</b> entities for the loaded navigation property
     * <b>to_SalesOrder</b>.
     * <p>
     * If the navigation property <b>to_SalesOrder</b> of a queried <b>BusSolnOrderSalesItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BusSolnOrdItmFUPSalesOrder</b> entities.
     */
    public void setSalesOrder( @Nonnull final List<BusSolnOrdItmFUPSalesOrder> value )
    {
        if( toSalesOrder == null ) {
            toSalesOrder = Lists.newArrayList();
        }
        toSalesOrder.clear();
        toSalesOrder.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BusSolnOrdItmFUPSalesOrder</b> entities. This corresponds to the OData
     * navigation property <b>to_SalesOrder</b>.
     * <p>
     * If the navigation property <b>to_SalesOrder</b> of a queried <b>BusSolnOrderSalesItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BusSolnOrdItmFUPSalesOrder</b> entities.
     */
    public void addSalesOrder( BusSolnOrdItmFUPSalesOrder... entity )
    {
        if( toSalesOrder == null ) {
            toSalesOrder = Lists.newArrayList();
        }
        toSalesOrder.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>BusSolnOrderItemScheduleLine</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_ScheduleLine</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BusSolnOrderItemScheduleLine</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusSolnOrderItemScheduleLine> fetchScheduleLine()
    {
        return fetchFieldAsList("to_ScheduleLine", BusSolnOrderItemScheduleLine.class);
    }

    /**
     * Retrieval of associated <b>BusSolnOrderItemScheduleLine</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ScheduleLine</b>.
     * <p>
     * If the navigation property <b>to_ScheduleLine</b> of a queried <b>BusSolnOrderSalesItem</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BusSolnOrderItemScheduleLine</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusSolnOrderItemScheduleLine> getScheduleLineOrFetch()
    {
        if( toScheduleLine == null ) {
            toScheduleLine = fetchScheduleLine();
        }
        return toScheduleLine;
    }

    /**
     * Retrieval of associated <b>BusSolnOrderItemScheduleLine</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ScheduleLine</b>.
     * <p>
     * If the navigation property for an entity <b>BusSolnOrderSalesItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ScheduleLine</b> is already loaded, the result will
     *         contain the <b>BusSolnOrderItemScheduleLine</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BusSolnOrderItemScheduleLine>> getScheduleLineIfPresent()
    {
        return Option.of(toScheduleLine);
    }

    /**
     * Overwrites the list of associated <b>BusSolnOrderItemScheduleLine</b> entities for the loaded navigation property
     * <b>to_ScheduleLine</b>.
     * <p>
     * If the navigation property <b>to_ScheduleLine</b> of a queried <b>BusSolnOrderSalesItem</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BusSolnOrderItemScheduleLine</b> entities.
     */
    public void setScheduleLine( @Nonnull final List<BusSolnOrderItemScheduleLine> value )
    {
        if( toScheduleLine == null ) {
            toScheduleLine = Lists.newArrayList();
        }
        toScheduleLine.clear();
        toScheduleLine.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BusSolnOrderItemScheduleLine</b> entities. This corresponds to the
     * OData navigation property <b>to_ScheduleLine</b>.
     * <p>
     * If the navigation property <b>to_ScheduleLine</b> of a queried <b>BusSolnOrderSalesItem</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BusSolnOrderItemScheduleLine</b> entities.
     */
    public void addScheduleLine( BusSolnOrderItemScheduleLine... entity )
    {
        if( toScheduleLine == null ) {
            toScheduleLine = Lists.newArrayList();
        }
        toScheduleLine.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>BusSolutionOrderItemText</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_Text</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BusSolutionOrderItemText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusSolutionOrderItemText> fetchText()
    {
        return fetchFieldAsList("to_Text", BusSolutionOrderItemText.class);
    }

    /**
     * Retrieval of associated <b>BusSolutionOrderItemText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>BusSolnOrderSalesItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BusSolutionOrderItemText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusSolutionOrderItemText> getTextOrFetch()
    {
        if( toText == null ) {
            toText = fetchText();
        }
        return toText;
    }

    /**
     * Retrieval of associated <b>BusSolutionOrderItemText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property for an entity <b>BusSolnOrderSalesItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Text</b> is already loaded, the result will contain the
     *         <b>BusSolutionOrderItemText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BusSolutionOrderItemText>> getTextIfPresent()
    {
        return Option.of(toText);
    }

    /**
     * Overwrites the list of associated <b>BusSolutionOrderItemText</b> entities for the loaded navigation property
     * <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>BusSolnOrderSalesItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BusSolutionOrderItemText</b> entities.
     */
    public void setText( @Nonnull final List<BusSolutionOrderItemText> value )
    {
        if( toText == null ) {
            toText = Lists.newArrayList();
        }
        toText.clear();
        toText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BusSolutionOrderItemText</b> entities. This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>BusSolnOrderSalesItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BusSolutionOrderItemText</b> entities.
     */
    public void addText( BusSolutionOrderItemText... entity )
    {
        if( toText == null ) {
            toText = Lists.newArrayList();
        }
        toText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>BusSolnOrdItmUserStatus</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_UserStatus</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BusSolnOrdItmUserStatus</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusSolnOrdItmUserStatus> fetchUserStatus()
    {
        return fetchFieldAsList("to_UserStatus", BusSolnOrdItmUserStatus.class);
    }

    /**
     * Retrieval of associated <b>BusSolnOrdItmUserStatus</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_UserStatus</b>.
     * <p>
     * If the navigation property <b>to_UserStatus</b> of a queried <b>BusSolnOrderSalesItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BusSolnOrdItmUserStatus</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusSolnOrdItmUserStatus> getUserStatusOrFetch()
    {
        if( toUserStatus == null ) {
            toUserStatus = fetchUserStatus();
        }
        return toUserStatus;
    }

    /**
     * Retrieval of associated <b>BusSolnOrdItmUserStatus</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_UserStatus</b>.
     * <p>
     * If the navigation property for an entity <b>BusSolnOrderSalesItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_UserStatus</b> is already loaded, the result will
     *         contain the <b>BusSolnOrdItmUserStatus</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BusSolnOrdItmUserStatus>> getUserStatusIfPresent()
    {
        return Option.of(toUserStatus);
    }

    /**
     * Overwrites the list of associated <b>BusSolnOrdItmUserStatus</b> entities for the loaded navigation property
     * <b>to_UserStatus</b>.
     * <p>
     * If the navigation property <b>to_UserStatus</b> of a queried <b>BusSolnOrderSalesItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BusSolnOrdItmUserStatus</b> entities.
     */
    public void setUserStatus( @Nonnull final List<BusSolnOrdItmUserStatus> value )
    {
        if( toUserStatus == null ) {
            toUserStatus = Lists.newArrayList();
        }
        toUserStatus.clear();
        toUserStatus.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BusSolnOrdItmUserStatus</b> entities. This corresponds to the OData
     * navigation property <b>to_UserStatus</b>.
     * <p>
     * If the navigation property <b>to_UserStatus</b> of a queried <b>BusSolnOrderSalesItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BusSolnOrdItmUserStatus</b> entities.
     */
    public void addUserStatus( BusSolnOrdItmUserStatus... entity )
    {
        if( toUserStatus == null ) {
            toUserStatus = Lists.newArrayList();
        }
        toUserStatus.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of BusSolnOrderSalesItem instances.
     *
     */
    public final static class BusSolnOrderSalesItemBuilder
    {

        private BusinessSolutionOrder toBusinessSolutionOrder;
        private String businessSolutionOrder = null;
        private List<BusSolnOrdItmConfiguration> toConfigurations = Lists.newArrayList();
        private List<BusSolnOrderItemPriceElement> toPriceElement = Lists.newArrayList();
        private List<BusSolnOrdItmFUPSalesOrder> toSalesOrder = Lists.newArrayList();
        private List<BusSolnOrderItemScheduleLine> toScheduleLine = Lists.newArrayList();
        private List<BusSolutionOrderItemText> toText = Lists.newArrayList();
        private List<BusSolnOrdItmUserStatus> toUserStatus = Lists.newArrayList();

        private BusSolnOrderSalesItem.BusSolnOrderSalesItemBuilder toBusinessSolutionOrder(
            final BusinessSolutionOrder value )
        {
            toBusinessSolutionOrder = value;
            return this;
        }

        /**
         * Navigation property <b>to_BusinessSolutionOrder</b> for <b>BusSolnOrderSalesItem</b> to single
         * <b>BusinessSolutionOrder</b>.
         *
         * @param value
         *            The BusinessSolutionOrder to build this BusSolnOrderSalesItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusSolnOrderSalesItem.BusSolnOrderSalesItemBuilder businessSolutionOrder(
            final BusinessSolutionOrder value )
        {
            return toBusinessSolutionOrder(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 10
         * <p>
         * Original property name from the Odata EDM: <b>BusinessSolutionOrder</b>
         * </p>
         *
         * @param value
         *            The businessSolutionOrder to build this BusSolnOrderSalesItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusSolnOrderSalesItem.BusSolnOrderSalesItemBuilder businessSolutionOrder( final String value )
        {
            businessSolutionOrder = value;
            return this;
        }

        private BusSolnOrderSalesItem.BusSolnOrderSalesItemBuilder toConfigurations(
            final List<BusSolnOrdItmConfiguration> value )
        {
            toConfigurations.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Configurations</b> for <b>BusSolnOrderSalesItem</b> to multiple
         * <b>BusSolnOrdItmConfiguration</b>.
         *
         * @param value
         *            The BusSolnOrdItmConfigurations to build this BusSolnOrderSalesItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusSolnOrderSalesItem.BusSolnOrderSalesItemBuilder configurations( BusSolnOrdItmConfiguration... value )
        {
            return toConfigurations(Lists.newArrayList(value));
        }

        private BusSolnOrderSalesItem.BusSolnOrderSalesItemBuilder toPriceElement(
            final List<BusSolnOrderItemPriceElement> value )
        {
            toPriceElement.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_PriceElement</b> for <b>BusSolnOrderSalesItem</b> to multiple
         * <b>BusSolnOrderItemPriceElement</b>.
         *
         * @param value
         *            The BusSolnOrderItemPriceElements to build this BusSolnOrderSalesItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusSolnOrderSalesItem.BusSolnOrderSalesItemBuilder priceElement( BusSolnOrderItemPriceElement... value )
        {
            return toPriceElement(Lists.newArrayList(value));
        }

        private BusSolnOrderSalesItem.BusSolnOrderSalesItemBuilder toSalesOrder(
            final List<BusSolnOrdItmFUPSalesOrder> value )
        {
            toSalesOrder.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_SalesOrder</b> for <b>BusSolnOrderSalesItem</b> to multiple
         * <b>BusSolnOrdItmFUPSalesOrder</b>.
         *
         * @param value
         *            The BusSolnOrdItmFUPSalesOrders to build this BusSolnOrderSalesItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusSolnOrderSalesItem.BusSolnOrderSalesItemBuilder salesOrder( BusSolnOrdItmFUPSalesOrder... value )
        {
            return toSalesOrder(Lists.newArrayList(value));
        }

        private BusSolnOrderSalesItem.BusSolnOrderSalesItemBuilder toScheduleLine(
            final List<BusSolnOrderItemScheduleLine> value )
        {
            toScheduleLine.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ScheduleLine</b> for <b>BusSolnOrderSalesItem</b> to multiple
         * <b>BusSolnOrderItemScheduleLine</b>.
         *
         * @param value
         *            The BusSolnOrderItemScheduleLines to build this BusSolnOrderSalesItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusSolnOrderSalesItem.BusSolnOrderSalesItemBuilder scheduleLine( BusSolnOrderItemScheduleLine... value )
        {
            return toScheduleLine(Lists.newArrayList(value));
        }

        private BusSolnOrderSalesItem.BusSolnOrderSalesItemBuilder toText( final List<BusSolutionOrderItemText> value )
        {
            toText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Text</b> for <b>BusSolnOrderSalesItem</b> to multiple
         * <b>BusSolutionOrderItemText</b>.
         *
         * @param value
         *            The BusSolutionOrderItemTexts to build this BusSolnOrderSalesItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusSolnOrderSalesItem.BusSolnOrderSalesItemBuilder text( BusSolutionOrderItemText... value )
        {
            return toText(Lists.newArrayList(value));
        }

        private BusSolnOrderSalesItem.BusSolnOrderSalesItemBuilder toUserStatus(
            final List<BusSolnOrdItmUserStatus> value )
        {
            toUserStatus.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_UserStatus</b> for <b>BusSolnOrderSalesItem</b> to multiple
         * <b>BusSolnOrdItmUserStatus</b>.
         *
         * @param value
         *            The BusSolnOrdItmUserStatuss to build this BusSolnOrderSalesItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusSolnOrderSalesItem.BusSolnOrderSalesItemBuilder userStatus( BusSolnOrdItmUserStatus... value )
        {
            return toUserStatus(Lists.newArrayList(value));
        }

    }

}
