/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.selectable.BusSolnOrderSalesItemSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderSalesItem
 * BusSolnOrderSalesItem} entity using key fields. This fluent helper allows methods which modify the underlying query
 * to be called before executing the query itself.
 *
 */
public class BusSolnOrderSalesItemByKeyFluentHelper
    extends
    FluentHelperByKey<BusSolnOrderSalesItemByKeyFluentHelper, BusSolnOrderSalesItem, BusSolnOrderSalesItemSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderSalesItem
     * BusSolnOrderSalesItem} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code BusSolnOrderSalesItem}
     * @param businessSolutionOrder
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code BusSolnOrderSalesItem}
     * @param businessSolutionOrderItem
     *            Shortened Item Number in Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     */
    public BusSolnOrderSalesItemByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String businessSolutionOrder,
        final String businessSolutionOrderItem )
    {
        super(servicePath, entityCollection);
        this.key.put("BusinessSolutionOrder", businessSolutionOrder);
        this.key.put("BusinessSolutionOrderItem", businessSolutionOrderItem);
    }

    @Override
    @Nonnull
    protected Class<BusSolnOrderSalesItem> getEntityClass()
    {
        return BusSolnOrderSalesItem.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
