/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.field.BusinessSolutionOrderField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.link.BusinessSolutionOrderLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.selectable.BusinessSolutionOrderSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Solution Order Header
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_BusinessSolutionOrderType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class BusinessSolutionOrder extends VdmEntity<BusinessSolutionOrder>
{

    /**
     * Selector for all available fields of BusinessSolutionOrder.
     *
     */
    public final static BusinessSolutionOrderSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BusinessSolutionOrder</b>
     * </p>
     *
     * @return Transaction ID
     */
    @Key
    @SerializedName( "BusinessSolutionOrder" )
    @JsonProperty( "BusinessSolutionOrder" )
    @Nullable
    @ODataField( odataName = "BusinessSolutionOrder" )
    private String businessSolutionOrder;
    /**
     * Use with available fluent helpers to apply the <b>BusinessSolutionOrder</b> field to query operations.
     *
     */
    public final static BusinessSolutionOrderField<String> BUSINESS_SOLUTION_ORDER =
        new BusinessSolutionOrderField<String>("BusinessSolutionOrder");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdType</b>
     * </p>
     *
     * @return Business Transaction Type
     */
    @SerializedName( "BusSolnOrdType" )
    @JsonProperty( "BusSolnOrdType" )
    @Nullable
    @ODataField( odataName = "BusSolnOrdType" )
    private String busSolnOrdType;
    /**
     * Use with available fluent helpers to apply the <b>BusSolnOrdType</b> field to query operations.
     *
     */
    public final static BusinessSolutionOrderField<String> BUS_SOLN_ORD_TYPE =
        new BusinessSolutionOrderField<String>("BusSolnOrdType");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BusinessSolutionOrderUUID</b>
     * </p>
     *
     * @return GUID of a CRM Order Object
     */
    @SerializedName( "BusinessSolutionOrderUUID" )
    @JsonProperty( "BusinessSolutionOrderUUID" )
    @Nullable
    @ODataField( odataName = "BusinessSolutionOrderUUID" )
    private UUID businessSolutionOrderUUID;
    /**
     * Use with available fluent helpers to apply the <b>BusinessSolutionOrderUUID</b> field to query operations.
     *
     */
    public final static BusinessSolutionOrderField<UUID> BUSINESS_SOLUTION_ORDER_UUID =
        new BusinessSolutionOrderField<UUID>("BusinessSolutionOrderUUID");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdDescription</b>
     * </p>
     *
     * @return Transaction Description
     */
    @SerializedName( "BusSolnOrdDescription" )
    @JsonProperty( "BusSolnOrdDescription" )
    @Nullable
    @ODataField( odataName = "BusSolnOrdDescription" )
    private String busSolnOrdDescription;
    /**
     * Use with available fluent helpers to apply the <b>BusSolnOrdDescription</b> field to query operations.
     *
     */
    public final static BusinessSolutionOrderField<String> BUS_SOLN_ORD_DESCRIPTION =
        new BusinessSolutionOrderField<String>("BusSolnOrdDescription");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key of Description
     */
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static BusinessSolutionOrderField<String> LANGUAGE =
        new BusinessSolutionOrderField<String>("Language");
    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdExtReference</b>
     * </p>
     *
     * @return External Reference Number
     */
    @SerializedName( "BusSolnOrdExtReference" )
    @JsonProperty( "BusSolnOrdExtReference" )
    @Nullable
    @ODataField( odataName = "BusSolnOrdExtReference" )
    private String busSolnOrdExtReference;
    /**
     * Use with available fluent helpers to apply the <b>BusSolnOrdExtReference</b> field to query operations.
     *
     */
    public final static BusinessSolutionOrderField<String> BUS_SOLN_ORD_EXT_REFERENCE =
        new BusinessSolutionOrderField<String>("BusSolnOrdExtReference");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PaymentTerms</b>
     * </p>
     *
     * @return Terms of Payment
     */
    @SerializedName( "PaymentTerms" )
    @JsonProperty( "PaymentTerms" )
    @Nullable
    @ODataField( odataName = "PaymentTerms" )
    private String paymentTerms;
    /**
     * Use with available fluent helpers to apply the <b>PaymentTerms</b> field to query operations.
     *
     */
    public final static BusinessSolutionOrderField<String> PAYMENT_TERMS =
        new BusinessSolutionOrderField<String>("PaymentTerms");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return User that Created the Transaction
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static BusinessSolutionOrderField<String> CREATED_BY_USER =
        new BusinessSolutionOrderField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     *
     * @return Created At
     */
    @SerializedName( "CreationDateTime" )
    @JsonProperty( "CreationDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime creationDateTime;
    /**
     * Use with available fluent helpers to apply the <b>CreationDateTime</b> field to query operations.
     *
     */
    public final static BusinessSolutionOrderField<ZonedDateTime> CREATION_DATE_TIME =
        new BusinessSolutionOrderField<ZonedDateTime>("CreationDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @return Transaction Last Changed By
     */
    @SerializedName( "LastChangedByUser" )
    @JsonProperty( "LastChangedByUser" )
    @Nullable
    @ODataField( odataName = "LastChangedByUser" )
    private String lastChangedByUser;
    /**
     * Use with available fluent helpers to apply the <b>LastChangedByUser</b> field to query operations.
     *
     */
    public final static BusinessSolutionOrderField<String> LAST_CHANGED_BY_USER =
        new BusinessSolutionOrderField<String>("LastChangedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @return Changed At
     */
    @SerializedName( "LastChangeDateTime" )
    @JsonProperty( "LastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime lastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDateTime</b> field to query operations.
     *
     */
    public final static BusinessSolutionOrderField<ZonedDateTime> LAST_CHANGE_DATE_TIME =
        new BusinessSolutionOrderField<ZonedDateTime>("LastChangeDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdIsReleased</b>
     * </p>
     *
     * @return Release Status
     */
    @SerializedName( "BusSolnOrdIsReleased" )
    @JsonProperty( "BusSolnOrdIsReleased" )
    @Nullable
    @ODataField( odataName = "BusSolnOrdIsReleased" )
    private String busSolnOrdIsReleased;
    /**
     * Use with available fluent helpers to apply the <b>BusSolnOrdIsReleased</b> field to query operations.
     *
     */
    public final static BusinessSolutionOrderField<String> BUS_SOLN_ORD_IS_RELEASED =
        new BusinessSolutionOrderField<String>("BusSolnOrdIsReleased");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdIsCompleted</b>
     * </p>
     *
     * @return The busSolnOrdIsCompleted contained in this entity.
     */
    @SerializedName( "BusSolnOrdIsCompleted" )
    @JsonProperty( "BusSolnOrdIsCompleted" )
    @Nullable
    @ODataField( odataName = "BusSolnOrdIsCompleted" )
    private String busSolnOrdIsCompleted;
    /**
     * Use with available fluent helpers to apply the <b>BusSolnOrdIsCompleted</b> field to query operations.
     *
     */
    public final static BusinessSolutionOrderField<String> BUS_SOLN_ORD_IS_COMPLETED =
        new BusinessSolutionOrderField<String>("BusSolnOrdIsCompleted");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocumentHasError</b>
     * </p>
     *
     * @return Error Status
     */
    @SerializedName( "ServiceDocumentHasError" )
    @JsonProperty( "ServiceDocumentHasError" )
    @Nullable
    @ODataField( odataName = "ServiceDocumentHasError" )
    private String serviceDocumentHasError;
    /**
     * Use with available fluent helpers to apply the <b>ServiceDocumentHasError</b> field to query operations.
     *
     */
    public final static BusinessSolutionOrderField<String> SERVICE_DOCUMENT_HAS_ERROR =
        new BusinessSolutionOrderField<String>("ServiceDocumentHasError");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderByCustomer</b>
     * </p>
     *
     * @return Sold-To Party's External Reference Number
     */
    @SerializedName( "PurchaseOrderByCustomer" )
    @JsonProperty( "PurchaseOrderByCustomer" )
    @Nullable
    @ODataField( odataName = "PurchaseOrderByCustomer" )
    private String purchaseOrderByCustomer;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseOrderByCustomer</b> field to query operations.
     *
     */
    public final static BusinessSolutionOrderField<String> PURCHASE_ORDER_BY_CUSTOMER =
        new BusinessSolutionOrderField<String>("PurchaseOrderByCustomer");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CustomerPurchaseOrderDate</b>
     * </p>
     *
     * @return Reference Document Date
     */
    @SerializedName( "CustomerPurchaseOrderDate" )
    @JsonProperty( "CustomerPurchaseOrderDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CustomerPurchaseOrderDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime customerPurchaseOrderDate;
    /**
     * Use with available fluent helpers to apply the <b>CustomerPurchaseOrderDate</b> field to query operations.
     *
     */
    public final static BusinessSolutionOrderField<LocalDateTime> CUSTOMER_PURCHASE_ORDER_DATE =
        new BusinessSolutionOrderField<LocalDateTime>("CustomerPurchaseOrderDate");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocNetAmount</b>
     * </p>
     *
     * @return Total Net Value of Document in Document Currency
     */
    @SerializedName( "ServiceDocNetAmount" )
    @JsonProperty( "ServiceDocNetAmount" )
    @Nullable
    @ODataField( odataName = "ServiceDocNetAmount" )
    private BigDecimal serviceDocNetAmount;
    /**
     * Use with available fluent helpers to apply the <b>ServiceDocNetAmount</b> field to query operations.
     *
     */
    public final static BusinessSolutionOrderField<BigDecimal> SERVICE_DOC_NET_AMOUNT =
        new BusinessSolutionOrderField<BigDecimal>("ServiceDocNetAmount");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @return Currency
     */
    @SerializedName( "TransactionCurrency" )
    @JsonProperty( "TransactionCurrency" )
    @Nullable
    @ODataField( odataName = "TransactionCurrency" )
    private String transactionCurrency;
    /**
     * Use with available fluent helpers to apply the <b>TransactionCurrency</b> field to query operations.
     *
     */
    public final static BusinessSolutionOrderField<String> TRANSACTION_CURRENCY =
        new BusinessSolutionOrderField<String>("TransactionCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CPQQuotation</b>
     * </p>
     *
     * @return The cPQQuotation contained in this entity.
     */
    @SerializedName( "CPQQuotation" )
    @JsonProperty( "CPQQuotation" )
    @Nullable
    @ODataField( odataName = "CPQQuotation" )
    private String cPQQuotation;
    /**
     * Use with available fluent helpers to apply the <b>CPQQuotation</b> field to query operations.
     *
     */
    public final static BusinessSolutionOrderField<String> CPQ_QUOTATION =
        new BusinessSolutionOrderField<String>("CPQQuotation");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganization</b>
     * </p>
     *
     * @return Sales Organization
     */
    @SerializedName( "SalesOrganization" )
    @JsonProperty( "SalesOrganization" )
    @Nullable
    @ODataField( odataName = "SalesOrganization" )
    private String salesOrganization;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrganization</b> field to query operations.
     *
     */
    public final static BusinessSolutionOrderField<String> SALES_ORGANIZATION =
        new BusinessSolutionOrderField<String>("SalesOrganization");
    /**
     * Constraints: Not nullable, Maximum length: 14
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganizationOrgUnitID</b>
     * </p>
     *
     * @return Sales Organization ID
     */
    @SerializedName( "SalesOrganizationOrgUnitID" )
    @JsonProperty( "SalesOrganizationOrgUnitID" )
    @Nullable
    @ODataField( odataName = "SalesOrganizationOrgUnitID" )
    private String salesOrganizationOrgUnitID;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrganizationOrgUnitID</b> field to query operations.
     *
     */
    public final static BusinessSolutionOrderField<String> SALES_ORGANIZATION_ORG_UNIT_ID =
        new BusinessSolutionOrderField<String>("SalesOrganizationOrgUnitID");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DistributionChannel</b>
     * </p>
     *
     * @return Distribution Channel
     */
    @SerializedName( "DistributionChannel" )
    @JsonProperty( "DistributionChannel" )
    @Nullable
    @ODataField( odataName = "DistributionChannel" )
    private String distributionChannel;
    /**
     * Use with available fluent helpers to apply the <b>DistributionChannel</b> field to query operations.
     *
     */
    public final static BusinessSolutionOrderField<String> DISTRIBUTION_CHANNEL =
        new BusinessSolutionOrderField<String>("DistributionChannel");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Division</b>
     * </p>
     *
     * @return Division
     */
    @SerializedName( "Division" )
    @JsonProperty( "Division" )
    @Nullable
    @ODataField( odataName = "Division" )
    private String division;
    /**
     * Use with available fluent helpers to apply the <b>Division</b> field to query operations.
     *
     */
    public final static BusinessSolutionOrderField<String> DIVISION =
        new BusinessSolutionOrderField<String>("Division");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOffice</b>
     * </p>
     *
     * @return Sales Office
     */
    @SerializedName( "SalesOffice" )
    @JsonProperty( "SalesOffice" )
    @Nullable
    @ODataField( odataName = "SalesOffice" )
    private String salesOffice;
    /**
     * Use with available fluent helpers to apply the <b>SalesOffice</b> field to query operations.
     *
     */
    public final static BusinessSolutionOrderField<String> SALES_OFFICE =
        new BusinessSolutionOrderField<String>("SalesOffice");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SalesGroup</b>
     * </p>
     *
     * @return Sales Group
     */
    @SerializedName( "SalesGroup" )
    @JsonProperty( "SalesGroup" )
    @Nullable
    @ODataField( odataName = "SalesGroup" )
    private String salesGroup;
    /**
     * Use with available fluent helpers to apply the <b>SalesGroup</b> field to query operations.
     *
     */
    public final static BusinessSolutionOrderField<String> SALES_GROUP =
        new BusinessSolutionOrderField<String>("SalesGroup");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SoldToParty</b>
     * </p>
     *
     * @return Sold-To Party
     */
    @SerializedName( "SoldToParty" )
    @JsonProperty( "SoldToParty" )
    @Nullable
    @ODataField( odataName = "SoldToParty" )
    private String soldToParty;
    /**
     * Use with available fluent helpers to apply the <b>SoldToParty</b> field to query operations.
     *
     */
    public final static BusinessSolutionOrderField<String> SOLD_TO_PARTY =
        new BusinessSolutionOrderField<String>("SoldToParty");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ShipToParty</b>
     * </p>
     *
     * @return Ship-To Party
     */
    @SerializedName( "ShipToParty" )
    @JsonProperty( "ShipToParty" )
    @Nullable
    @ODataField( odataName = "ShipToParty" )
    private String shipToParty;
    /**
     * Use with available fluent helpers to apply the <b>ShipToParty</b> field to query operations.
     *
     */
    public final static BusinessSolutionOrderField<String> SHIP_TO_PARTY =
        new BusinessSolutionOrderField<String>("ShipToParty");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BillToParty</b>
     * </p>
     *
     * @return Bill-To Party
     */
    @SerializedName( "BillToParty" )
    @JsonProperty( "BillToParty" )
    @Nullable
    @ODataField( odataName = "BillToParty" )
    private String billToParty;
    /**
     * Use with available fluent helpers to apply the <b>BillToParty</b> field to query operations.
     *
     */
    public final static BusinessSolutionOrderField<String> BILL_TO_PARTY =
        new BusinessSolutionOrderField<String>("BillToParty");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PayerParty</b>
     * </p>
     *
     * @return Payer
     */
    @SerializedName( "PayerParty" )
    @JsonProperty( "PayerParty" )
    @Nullable
    @ODataField( odataName = "PayerParty" )
    private String payerParty;
    /**
     * Use with available fluent helpers to apply the <b>PayerParty</b> field to query operations.
     *
     */
    public final static BusinessSolutionOrderField<String> PAYER_PARTY =
        new BusinessSolutionOrderField<String>("PayerParty");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PersonResponsible</b>
     * </p>
     *
     * @return Employee Responsible
     */
    @SerializedName( "PersonResponsible" )
    @JsonProperty( "PersonResponsible" )
    @Nullable
    @ODataField( odataName = "PersonResponsible" )
    private String personResponsible;
    /**
     * Use with available fluent helpers to apply the <b>PersonResponsible</b> field to query operations.
     *
     */
    public final static BusinessSolutionOrderField<String> PERSON_RESPONSIBLE =
        new BusinessSolutionOrderField<String>("PersonResponsible");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ContactPerson</b>
     * </p>
     *
     * @return Customer Contact Person
     */
    @SerializedName( "ContactPerson" )
    @JsonProperty( "ContactPerson" )
    @Nullable
    @ODataField( odataName = "ContactPerson" )
    private String contactPerson;
    /**
     * Use with available fluent helpers to apply the <b>ContactPerson</b> field to query operations.
     *
     */
    public final static BusinessSolutionOrderField<String> CONTACT_PERSON =
        new BusinessSolutionOrderField<String>("ContactPerson");
    /**
     * Navigation property <b>to_EnterpriseProject</b> for <b>BusinessSolutionOrder</b> to multiple
     * <b>BusSolnOrdFUPEntProject</b>.
     *
     */
    @SerializedName( "to_EnterpriseProject" )
    @JsonProperty( "to_EnterpriseProject" )
    @ODataField( odataName = "to_EnterpriseProject" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BusSolnOrdFUPEntProject> toEnterpriseProject;
    /**
     * Navigation property <b>to_EnterpriseProjectItem</b> for <b>BusinessSolutionOrder</b> to multiple
     * <b>BusSolnOrdEntProjectItem</b>.
     *
     */
    @SerializedName( "to_EnterpriseProjectItem" )
    @JsonProperty( "to_EnterpriseProjectItem" )
    @ODataField( odataName = "to_EnterpriseProjectItem" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BusSolnOrdEntProjectItem> toEnterpriseProjectItem;
    /**
     * Navigation property <b>to_ExpenseItem</b> for <b>BusinessSolutionOrder</b> to multiple
     * <b>BusSolnOrderExpenseItem</b>.
     *
     */
    @SerializedName( "to_ExpenseItem" )
    @JsonProperty( "to_ExpenseItem" )
    @ODataField( odataName = "to_ExpenseItem" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BusSolnOrderExpenseItem> toExpenseItem;
    /**
     * Navigation property <b>to_ItemRelationships</b> for <b>BusinessSolutionOrder</b> to multiple
     * <b>BusSolnOrdItemRelationships</b>.
     *
     */
    @SerializedName( "to_ItemRelationships" )
    @JsonProperty( "to_ItemRelationships" )
    @ODataField( odataName = "to_ItemRelationships" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BusSolnOrdItemRelationships> toItemRelationships;
    /**
     * Navigation property <b>to_SalesItem</b> for <b>BusinessSolutionOrder</b> to multiple
     * <b>BusSolnOrderSalesItem</b>.
     *
     */
    @SerializedName( "to_SalesItem" )
    @JsonProperty( "to_SalesItem" )
    @ODataField( odataName = "to_SalesItem" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BusSolnOrderSalesItem> toSalesItem;
    /**
     * Navigation property <b>to_SalesOrder</b> for <b>BusinessSolutionOrder</b> to multiple
     * <b>BusSolnOrderFUPSalesOrder</b>.
     *
     */
    @SerializedName( "to_SalesOrder" )
    @JsonProperty( "to_SalesOrder" )
    @ODataField( odataName = "to_SalesOrder" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BusSolnOrderFUPSalesOrder> toSalesOrder;
    /**
     * Navigation property <b>to_ServiceContract</b> for <b>BusinessSolutionOrder</b> to multiple
     * <b>BusSolnOrdFUPServiceContract</b>.
     *
     */
    @SerializedName( "to_ServiceContract" )
    @JsonProperty( "to_ServiceContract" )
    @ODataField( odataName = "to_ServiceContract" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BusSolnOrdFUPServiceContract> toServiceContract;
    /**
     * Navigation property <b>to_ServiceContractItem</b> for <b>BusinessSolutionOrder</b> to multiple
     * <b>BusSolnOrdSrvcContractItem</b>.
     *
     */
    @SerializedName( "to_ServiceContractItem" )
    @JsonProperty( "to_ServiceContractItem" )
    @ODataField( odataName = "to_ServiceContractItem" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BusSolnOrdSrvcContractItem> toServiceContractItem;
    /**
     * Navigation property <b>to_ServiceItem</b> for <b>BusinessSolutionOrder</b> to multiple
     * <b>BusSolnOrderServiceItem</b>.
     *
     */
    @SerializedName( "to_ServiceItem" )
    @JsonProperty( "to_ServiceItem" )
    @ODataField( odataName = "to_ServiceItem" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BusSolnOrderServiceItem> toServiceItem;
    /**
     * Navigation property <b>to_ServiceOrder</b> for <b>BusinessSolutionOrder</b> to multiple
     * <b>BusSolnOrdFUPServiceOrder</b>.
     *
     */
    @SerializedName( "to_ServiceOrder" )
    @JsonProperty( "to_ServiceOrder" )
    @ODataField( odataName = "to_ServiceOrder" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BusSolnOrdFUPServiceOrder> toServiceOrder;
    /**
     * Navigation property <b>to_ServicePartItem</b> for <b>BusinessSolutionOrder</b> to multiple
     * <b>BusSolnOrdSrvcPrtItem</b>.
     *
     */
    @SerializedName( "to_ServicePartItem" )
    @JsonProperty( "to_ServicePartItem" )
    @ODataField( odataName = "to_ServicePartItem" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BusSolnOrdSrvcPrtItem> toServicePartItem;
    /**
     * Navigation property <b>to_SubscriptionBilling</b> for <b>BusinessSolutionOrder</b> to multiple
     * <b>BusSolnOrdFUPSubscrpn</b>.
     *
     */
    @SerializedName( "to_SubscriptionBilling" )
    @JsonProperty( "to_SubscriptionBilling" )
    @ODataField( odataName = "to_SubscriptionBilling" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BusSolnOrdFUPSubscrpn> toSubscriptionBilling;
    /**
     * Navigation property <b>to_SubscriptionBillingItem</b> for <b>BusinessSolutionOrder</b> to multiple
     * <b>BusSolnOrdSubscrpnBillgItem</b>.
     *
     */
    @SerializedName( "to_SubscriptionBillingItem" )
    @JsonProperty( "to_SubscriptionBillingItem" )
    @ODataField( odataName = "to_SubscriptionBillingItem" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BusSolnOrdSubscrpnBillgItem> toSubscriptionBillingItem;
    /**
     * Navigation property <b>to_Text</b> for <b>BusinessSolutionOrder</b> to multiple <b>BusinessSolutionOrderText</b>.
     *
     */
    @SerializedName( "to_Text" )
    @JsonProperty( "to_Text" )
    @ODataField( odataName = "to_Text" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BusinessSolutionOrderText> toText;
    /**
     * Navigation property <b>to_UserStatus</b> for <b>BusinessSolutionOrder</b> to multiple
     * <b>BusSolnOrdUserStatus</b>.
     *
     */
    @SerializedName( "to_UserStatus" )
    @JsonProperty( "to_UserStatus" )
    @ODataField( odataName = "to_UserStatus" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<BusSolnOrdUserStatus> toUserStatus;
    /**
     * Use with available fluent helpers to apply the <b>to_EnterpriseProject</b> navigation property to query
     * operations.
     *
     */
    public final static BusinessSolutionOrderLink<BusSolnOrdFUPEntProject> TO_ENTERPRISE_PROJECT =
        new BusinessSolutionOrderLink<BusSolnOrdFUPEntProject>("to_EnterpriseProject");
    /**
     * Use with available fluent helpers to apply the <b>to_EnterpriseProjectItem</b> navigation property to query
     * operations.
     *
     */
    public final static BusinessSolutionOrderLink<BusSolnOrdEntProjectItem> TO_ENTERPRISE_PROJECT_ITEM =
        new BusinessSolutionOrderLink<BusSolnOrdEntProjectItem>("to_EnterpriseProjectItem");
    /**
     * Use with available fluent helpers to apply the <b>to_ExpenseItem</b> navigation property to query operations.
     *
     */
    public final static BusinessSolutionOrderLink<BusSolnOrderExpenseItem> TO_EXPENSE_ITEM =
        new BusinessSolutionOrderLink<BusSolnOrderExpenseItem>("to_ExpenseItem");
    /**
     * Use with available fluent helpers to apply the <b>to_ItemRelationships</b> navigation property to query
     * operations.
     *
     */
    public final static BusinessSolutionOrderLink<BusSolnOrdItemRelationships> TO_ITEM_RELATIONSHIPS =
        new BusinessSolutionOrderLink<BusSolnOrdItemRelationships>("to_ItemRelationships");
    /**
     * Use with available fluent helpers to apply the <b>to_SalesItem</b> navigation property to query operations.
     *
     */
    public final static BusinessSolutionOrderLink<BusSolnOrderSalesItem> TO_SALES_ITEM =
        new BusinessSolutionOrderLink<BusSolnOrderSalesItem>("to_SalesItem");
    /**
     * Use with available fluent helpers to apply the <b>to_SalesOrder</b> navigation property to query operations.
     *
     */
    public final static BusinessSolutionOrderLink<BusSolnOrderFUPSalesOrder> TO_SALES_ORDER =
        new BusinessSolutionOrderLink<BusSolnOrderFUPSalesOrder>("to_SalesOrder");
    /**
     * Use with available fluent helpers to apply the <b>to_ServiceContract</b> navigation property to query operations.
     *
     */
    public final static BusinessSolutionOrderLink<BusSolnOrdFUPServiceContract> TO_SERVICE_CONTRACT =
        new BusinessSolutionOrderLink<BusSolnOrdFUPServiceContract>("to_ServiceContract");
    /**
     * Use with available fluent helpers to apply the <b>to_ServiceContractItem</b> navigation property to query
     * operations.
     *
     */
    public final static BusinessSolutionOrderLink<BusSolnOrdSrvcContractItem> TO_SERVICE_CONTRACT_ITEM =
        new BusinessSolutionOrderLink<BusSolnOrdSrvcContractItem>("to_ServiceContractItem");
    /**
     * Use with available fluent helpers to apply the <b>to_ServiceItem</b> navigation property to query operations.
     *
     */
    public final static BusinessSolutionOrderLink<BusSolnOrderServiceItem> TO_SERVICE_ITEM =
        new BusinessSolutionOrderLink<BusSolnOrderServiceItem>("to_ServiceItem");
    /**
     * Use with available fluent helpers to apply the <b>to_ServiceOrder</b> navigation property to query operations.
     *
     */
    public final static BusinessSolutionOrderLink<BusSolnOrdFUPServiceOrder> TO_SERVICE_ORDER =
        new BusinessSolutionOrderLink<BusSolnOrdFUPServiceOrder>("to_ServiceOrder");
    /**
     * Use with available fluent helpers to apply the <b>to_ServicePartItem</b> navigation property to query operations.
     *
     */
    public final static BusinessSolutionOrderLink<BusSolnOrdSrvcPrtItem> TO_SERVICE_PART_ITEM =
        new BusinessSolutionOrderLink<BusSolnOrdSrvcPrtItem>("to_ServicePartItem");
    /**
     * Use with available fluent helpers to apply the <b>to_SubscriptionBilling</b> navigation property to query
     * operations.
     *
     */
    public final static BusinessSolutionOrderLink<BusSolnOrdFUPSubscrpn> TO_SUBSCRIPTION_BILLING =
        new BusinessSolutionOrderLink<BusSolnOrdFUPSubscrpn>("to_SubscriptionBilling");
    /**
     * Use with available fluent helpers to apply the <b>to_SubscriptionBillingItem</b> navigation property to query
     * operations.
     *
     */
    public final static BusinessSolutionOrderLink<BusSolnOrdSubscrpnBillgItem> TO_SUBSCRIPTION_BILLING_ITEM =
        new BusinessSolutionOrderLink<BusSolnOrdSubscrpnBillgItem>("to_SubscriptionBillingItem");
    /**
     * Use with available fluent helpers to apply the <b>to_Text</b> navigation property to query operations.
     *
     */
    public final static BusinessSolutionOrderLink<BusinessSolutionOrderText> TO_TEXT =
        new BusinessSolutionOrderLink<BusinessSolutionOrderText>("to_Text");
    /**
     * Use with available fluent helpers to apply the <b>to_UserStatus</b> navigation property to query operations.
     *
     */
    public final static BusinessSolutionOrderLink<BusSolnOrdUserStatus> TO_USER_STATUS =
        new BusinessSolutionOrderLink<BusSolnOrdUserStatus>("to_UserStatus");

    @Nonnull
    @Override
    public Class<BusinessSolutionOrder> getType()
    {
        return BusinessSolutionOrder.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BusinessSolutionOrder</b>
     * </p>
     *
     * @param businessSolutionOrder
     *            Transaction ID
     */
    public void setBusinessSolutionOrder( @Nullable final String businessSolutionOrder )
    {
        rememberChangedField("BusinessSolutionOrder", this.businessSolutionOrder);
        this.businessSolutionOrder = businessSolutionOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdType</b>
     * </p>
     *
     * @param busSolnOrdType
     *            Business Transaction Type
     */
    public void setBusSolnOrdType( @Nullable final String busSolnOrdType )
    {
        rememberChangedField("BusSolnOrdType", this.busSolnOrdType);
        this.busSolnOrdType = busSolnOrdType;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BusinessSolutionOrderUUID</b>
     * </p>
     *
     * @param businessSolutionOrderUUID
     *            GUID of a CRM Order Object
     */
    public void setBusinessSolutionOrderUUID( @Nullable final UUID businessSolutionOrderUUID )
    {
        rememberChangedField("BusinessSolutionOrderUUID", this.businessSolutionOrderUUID);
        this.businessSolutionOrderUUID = businessSolutionOrderUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdDescription</b>
     * </p>
     *
     * @param busSolnOrdDescription
     *            Transaction Description
     */
    public void setBusSolnOrdDescription( @Nullable final String busSolnOrdDescription )
    {
        rememberChangedField("BusSolnOrdDescription", this.busSolnOrdDescription);
        this.busSolnOrdDescription = busSolnOrdDescription;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key of Description
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdExtReference</b>
     * </p>
     *
     * @param busSolnOrdExtReference
     *            External Reference Number
     */
    public void setBusSolnOrdExtReference( @Nullable final String busSolnOrdExtReference )
    {
        rememberChangedField("BusSolnOrdExtReference", this.busSolnOrdExtReference);
        this.busSolnOrdExtReference = busSolnOrdExtReference;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PaymentTerms</b>
     * </p>
     *
     * @param paymentTerms
     *            Terms of Payment
     */
    public void setPaymentTerms( @Nullable final String paymentTerms )
    {
        rememberChangedField("PaymentTerms", this.paymentTerms);
        this.paymentTerms = paymentTerms;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            User that Created the Transaction
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     *
     * @param creationDateTime
     *            Created At
     */
    public void setCreationDateTime( @Nullable final ZonedDateTime creationDateTime )
    {
        rememberChangedField("CreationDateTime", this.creationDateTime);
        this.creationDateTime = creationDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @param lastChangedByUser
     *            Transaction Last Changed By
     */
    public void setLastChangedByUser( @Nullable final String lastChangedByUser )
    {
        rememberChangedField("LastChangedByUser", this.lastChangedByUser);
        this.lastChangedByUser = lastChangedByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @param lastChangeDateTime
     *            Changed At
     */
    public void setLastChangeDateTime( @Nullable final ZonedDateTime lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdIsReleased</b>
     * </p>
     *
     * @param busSolnOrdIsReleased
     *            Release Status
     */
    public void setBusSolnOrdIsReleased( @Nullable final String busSolnOrdIsReleased )
    {
        rememberChangedField("BusSolnOrdIsReleased", this.busSolnOrdIsReleased);
        this.busSolnOrdIsReleased = busSolnOrdIsReleased;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BusSolnOrdIsCompleted</b>
     * </p>
     *
     * @param busSolnOrdIsCompleted
     *            The busSolnOrdIsCompleted to set.
     */
    public void setBusSolnOrdIsCompleted( @Nullable final String busSolnOrdIsCompleted )
    {
        rememberChangedField("BusSolnOrdIsCompleted", this.busSolnOrdIsCompleted);
        this.busSolnOrdIsCompleted = busSolnOrdIsCompleted;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocumentHasError</b>
     * </p>
     *
     * @param serviceDocumentHasError
     *            Error Status
     */
    public void setServiceDocumentHasError( @Nullable final String serviceDocumentHasError )
    {
        rememberChangedField("ServiceDocumentHasError", this.serviceDocumentHasError);
        this.serviceDocumentHasError = serviceDocumentHasError;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderByCustomer</b>
     * </p>
     *
     * @param purchaseOrderByCustomer
     *            Sold-To Party's External Reference Number
     */
    public void setPurchaseOrderByCustomer( @Nullable final String purchaseOrderByCustomer )
    {
        rememberChangedField("PurchaseOrderByCustomer", this.purchaseOrderByCustomer);
        this.purchaseOrderByCustomer = purchaseOrderByCustomer;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CustomerPurchaseOrderDate</b>
     * </p>
     *
     * @param customerPurchaseOrderDate
     *            Reference Document Date
     */
    public void setCustomerPurchaseOrderDate( @Nullable final LocalDateTime customerPurchaseOrderDate )
    {
        rememberChangedField("CustomerPurchaseOrderDate", this.customerPurchaseOrderDate);
        this.customerPurchaseOrderDate = customerPurchaseOrderDate;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocNetAmount</b>
     * </p>
     *
     * @param serviceDocNetAmount
     *            Total Net Value of Document in Document Currency
     */
    public void setServiceDocNetAmount( @Nullable final BigDecimal serviceDocNetAmount )
    {
        rememberChangedField("ServiceDocNetAmount", this.serviceDocNetAmount);
        this.serviceDocNetAmount = serviceDocNetAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @param transactionCurrency
     *            Currency
     */
    public void setTransactionCurrency( @Nullable final String transactionCurrency )
    {
        rememberChangedField("TransactionCurrency", this.transactionCurrency);
        this.transactionCurrency = transactionCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CPQQuotation</b>
     * </p>
     *
     * @param cPQQuotation
     *            The cPQQuotation to set.
     */
    public void setCPQQuotation( @Nullable final String cPQQuotation )
    {
        rememberChangedField("CPQQuotation", this.cPQQuotation);
        this.cPQQuotation = cPQQuotation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganization</b>
     * </p>
     *
     * @param salesOrganization
     *            Sales Organization
     */
    public void setSalesOrganization( @Nullable final String salesOrganization )
    {
        rememberChangedField("SalesOrganization", this.salesOrganization);
        this.salesOrganization = salesOrganization;
    }

    /**
     * Constraints: Not nullable, Maximum length: 14
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganizationOrgUnitID</b>
     * </p>
     *
     * @param salesOrganizationOrgUnitID
     *            Sales Organization ID
     */
    public void setSalesOrganizationOrgUnitID( @Nullable final String salesOrganizationOrgUnitID )
    {
        rememberChangedField("SalesOrganizationOrgUnitID", this.salesOrganizationOrgUnitID);
        this.salesOrganizationOrgUnitID = salesOrganizationOrgUnitID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DistributionChannel</b>
     * </p>
     *
     * @param distributionChannel
     *            Distribution Channel
     */
    public void setDistributionChannel( @Nullable final String distributionChannel )
    {
        rememberChangedField("DistributionChannel", this.distributionChannel);
        this.distributionChannel = distributionChannel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Division</b>
     * </p>
     *
     * @param division
     *            Division
     */
    public void setDivision( @Nullable final String division )
    {
        rememberChangedField("Division", this.division);
        this.division = division;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOffice</b>
     * </p>
     *
     * @param salesOffice
     *            Sales Office
     */
    public void setSalesOffice( @Nullable final String salesOffice )
    {
        rememberChangedField("SalesOffice", this.salesOffice);
        this.salesOffice = salesOffice;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SalesGroup</b>
     * </p>
     *
     * @param salesGroup
     *            Sales Group
     */
    public void setSalesGroup( @Nullable final String salesGroup )
    {
        rememberChangedField("SalesGroup", this.salesGroup);
        this.salesGroup = salesGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SoldToParty</b>
     * </p>
     *
     * @param soldToParty
     *            Sold-To Party
     */
    public void setSoldToParty( @Nullable final String soldToParty )
    {
        rememberChangedField("SoldToParty", this.soldToParty);
        this.soldToParty = soldToParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ShipToParty</b>
     * </p>
     *
     * @param shipToParty
     *            Ship-To Party
     */
    public void setShipToParty( @Nullable final String shipToParty )
    {
        rememberChangedField("ShipToParty", this.shipToParty);
        this.shipToParty = shipToParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BillToParty</b>
     * </p>
     *
     * @param billToParty
     *            Bill-To Party
     */
    public void setBillToParty( @Nullable final String billToParty )
    {
        rememberChangedField("BillToParty", this.billToParty);
        this.billToParty = billToParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PayerParty</b>
     * </p>
     *
     * @param payerParty
     *            Payer
     */
    public void setPayerParty( @Nullable final String payerParty )
    {
        rememberChangedField("PayerParty", this.payerParty);
        this.payerParty = payerParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PersonResponsible</b>
     * </p>
     *
     * @param personResponsible
     *            Employee Responsible
     */
    public void setPersonResponsible( @Nullable final String personResponsible )
    {
        rememberChangedField("PersonResponsible", this.personResponsible);
        this.personResponsible = personResponsible;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ContactPerson</b>
     * </p>
     *
     * @param contactPerson
     *            Customer Contact Person
     */
    public void setContactPerson( @Nullable final String contactPerson )
    {
        rememberChangedField("ContactPerson", this.contactPerson);
        this.contactPerson = contactPerson;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_BusinessSolutionOrder";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("BusinessSolutionOrder", getBusinessSolutionOrder());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("BusinessSolutionOrder", getBusinessSolutionOrder());
        values.put("BusSolnOrdType", getBusSolnOrdType());
        values.put("BusinessSolutionOrderUUID", getBusinessSolutionOrderUUID());
        values.put("BusSolnOrdDescription", getBusSolnOrdDescription());
        values.put("Language", getLanguage());
        values.put("BusSolnOrdExtReference", getBusSolnOrdExtReference());
        values.put("PaymentTerms", getPaymentTerms());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("CreationDateTime", getCreationDateTime());
        values.put("LastChangedByUser", getLastChangedByUser());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        values.put("BusSolnOrdIsReleased", getBusSolnOrdIsReleased());
        values.put("BusSolnOrdIsCompleted", getBusSolnOrdIsCompleted());
        values.put("ServiceDocumentHasError", getServiceDocumentHasError());
        values.put("PurchaseOrderByCustomer", getPurchaseOrderByCustomer());
        values.put("CustomerPurchaseOrderDate", getCustomerPurchaseOrderDate());
        values.put("ServiceDocNetAmount", getServiceDocNetAmount());
        values.put("TransactionCurrency", getTransactionCurrency());
        values.put("CPQQuotation", getCPQQuotation());
        values.put("SalesOrganization", getSalesOrganization());
        values.put("SalesOrganizationOrgUnitID", getSalesOrganizationOrgUnitID());
        values.put("DistributionChannel", getDistributionChannel());
        values.put("Division", getDivision());
        values.put("SalesOffice", getSalesOffice());
        values.put("SalesGroup", getSalesGroup());
        values.put("SoldToParty", getSoldToParty());
        values.put("ShipToParty", getShipToParty());
        values.put("BillToParty", getBillToParty());
        values.put("PayerParty", getPayerParty());
        values.put("PersonResponsible", getPersonResponsible());
        values.put("ContactPerson", getContactPerson());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("BusinessSolutionOrder") ) {
                final Object value = values.remove("BusinessSolutionOrder");
                if( (value == null) || (!value.equals(getBusinessSolutionOrder())) ) {
                    setBusinessSolutionOrder(((String) value));
                }
            }
            if( values.containsKey("BusSolnOrdType") ) {
                final Object value = values.remove("BusSolnOrdType");
                if( (value == null) || (!value.equals(getBusSolnOrdType())) ) {
                    setBusSolnOrdType(((String) value));
                }
            }
            if( values.containsKey("BusinessSolutionOrderUUID") ) {
                final Object value = values.remove("BusinessSolutionOrderUUID");
                if( (value == null) || (!value.equals(getBusinessSolutionOrderUUID())) ) {
                    setBusinessSolutionOrderUUID(((UUID) value));
                }
            }
            if( values.containsKey("BusSolnOrdDescription") ) {
                final Object value = values.remove("BusSolnOrdDescription");
                if( (value == null) || (!value.equals(getBusSolnOrdDescription())) ) {
                    setBusSolnOrdDescription(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("BusSolnOrdExtReference") ) {
                final Object value = values.remove("BusSolnOrdExtReference");
                if( (value == null) || (!value.equals(getBusSolnOrdExtReference())) ) {
                    setBusSolnOrdExtReference(((String) value));
                }
            }
            if( values.containsKey("PaymentTerms") ) {
                final Object value = values.remove("PaymentTerms");
                if( (value == null) || (!value.equals(getPaymentTerms())) ) {
                    setPaymentTerms(((String) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("CreationDateTime") ) {
                final Object value = values.remove("CreationDateTime");
                if( (value == null) || (!value.equals(getCreationDateTime())) ) {
                    setCreationDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("LastChangedByUser") ) {
                final Object value = values.remove("LastChangedByUser");
                if( (value == null) || (!value.equals(getLastChangedByUser())) ) {
                    setLastChangedByUser(((String) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("BusSolnOrdIsReleased") ) {
                final Object value = values.remove("BusSolnOrdIsReleased");
                if( (value == null) || (!value.equals(getBusSolnOrdIsReleased())) ) {
                    setBusSolnOrdIsReleased(((String) value));
                }
            }
            if( values.containsKey("BusSolnOrdIsCompleted") ) {
                final Object value = values.remove("BusSolnOrdIsCompleted");
                if( (value == null) || (!value.equals(getBusSolnOrdIsCompleted())) ) {
                    setBusSolnOrdIsCompleted(((String) value));
                }
            }
            if( values.containsKey("ServiceDocumentHasError") ) {
                final Object value = values.remove("ServiceDocumentHasError");
                if( (value == null) || (!value.equals(getServiceDocumentHasError())) ) {
                    setServiceDocumentHasError(((String) value));
                }
            }
            if( values.containsKey("PurchaseOrderByCustomer") ) {
                final Object value = values.remove("PurchaseOrderByCustomer");
                if( (value == null) || (!value.equals(getPurchaseOrderByCustomer())) ) {
                    setPurchaseOrderByCustomer(((String) value));
                }
            }
            if( values.containsKey("CustomerPurchaseOrderDate") ) {
                final Object value = values.remove("CustomerPurchaseOrderDate");
                if( (value == null) || (!value.equals(getCustomerPurchaseOrderDate())) ) {
                    setCustomerPurchaseOrderDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ServiceDocNetAmount") ) {
                final Object value = values.remove("ServiceDocNetAmount");
                if( (value == null) || (!value.equals(getServiceDocNetAmount())) ) {
                    setServiceDocNetAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("TransactionCurrency") ) {
                final Object value = values.remove("TransactionCurrency");
                if( (value == null) || (!value.equals(getTransactionCurrency())) ) {
                    setTransactionCurrency(((String) value));
                }
            }
            if( values.containsKey("CPQQuotation") ) {
                final Object value = values.remove("CPQQuotation");
                if( (value == null) || (!value.equals(getCPQQuotation())) ) {
                    setCPQQuotation(((String) value));
                }
            }
            if( values.containsKey("SalesOrganization") ) {
                final Object value = values.remove("SalesOrganization");
                if( (value == null) || (!value.equals(getSalesOrganization())) ) {
                    setSalesOrganization(((String) value));
                }
            }
            if( values.containsKey("SalesOrganizationOrgUnitID") ) {
                final Object value = values.remove("SalesOrganizationOrgUnitID");
                if( (value == null) || (!value.equals(getSalesOrganizationOrgUnitID())) ) {
                    setSalesOrganizationOrgUnitID(((String) value));
                }
            }
            if( values.containsKey("DistributionChannel") ) {
                final Object value = values.remove("DistributionChannel");
                if( (value == null) || (!value.equals(getDistributionChannel())) ) {
                    setDistributionChannel(((String) value));
                }
            }
            if( values.containsKey("Division") ) {
                final Object value = values.remove("Division");
                if( (value == null) || (!value.equals(getDivision())) ) {
                    setDivision(((String) value));
                }
            }
            if( values.containsKey("SalesOffice") ) {
                final Object value = values.remove("SalesOffice");
                if( (value == null) || (!value.equals(getSalesOffice())) ) {
                    setSalesOffice(((String) value));
                }
            }
            if( values.containsKey("SalesGroup") ) {
                final Object value = values.remove("SalesGroup");
                if( (value == null) || (!value.equals(getSalesGroup())) ) {
                    setSalesGroup(((String) value));
                }
            }
            if( values.containsKey("SoldToParty") ) {
                final Object value = values.remove("SoldToParty");
                if( (value == null) || (!value.equals(getSoldToParty())) ) {
                    setSoldToParty(((String) value));
                }
            }
            if( values.containsKey("ShipToParty") ) {
                final Object value = values.remove("ShipToParty");
                if( (value == null) || (!value.equals(getShipToParty())) ) {
                    setShipToParty(((String) value));
                }
            }
            if( values.containsKey("BillToParty") ) {
                final Object value = values.remove("BillToParty");
                if( (value == null) || (!value.equals(getBillToParty())) ) {
                    setBillToParty(((String) value));
                }
            }
            if( values.containsKey("PayerParty") ) {
                final Object value = values.remove("PayerParty");
                if( (value == null) || (!value.equals(getPayerParty())) ) {
                    setPayerParty(((String) value));
                }
            }
            if( values.containsKey("PersonResponsible") ) {
                final Object value = values.remove("PersonResponsible");
                if( (value == null) || (!value.equals(getPersonResponsible())) ) {
                    setPersonResponsible(((String) value));
                }
            }
            if( values.containsKey("ContactPerson") ) {
                final Object value = values.remove("ContactPerson");
                if( (value == null) || (!value.equals(getContactPerson())) ) {
                    setContactPerson(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_EnterpriseProject") ) {
                final Object value = (values).remove("to_EnterpriseProject");
                if( value instanceof Iterable ) {
                    if( toEnterpriseProject == null ) {
                        toEnterpriseProject = Lists.newArrayList();
                    } else {
                        toEnterpriseProject = Lists.newArrayList(toEnterpriseProject);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BusSolnOrdFUPEntProject entity;
                        if( toEnterpriseProject.size() > i ) {
                            entity = toEnterpriseProject.get(i);
                        } else {
                            entity = new BusSolnOrdFUPEntProject();
                            toEnterpriseProject.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_EnterpriseProjectItem") ) {
                final Object value = (values).remove("to_EnterpriseProjectItem");
                if( value instanceof Iterable ) {
                    if( toEnterpriseProjectItem == null ) {
                        toEnterpriseProjectItem = Lists.newArrayList();
                    } else {
                        toEnterpriseProjectItem = Lists.newArrayList(toEnterpriseProjectItem);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BusSolnOrdEntProjectItem entity;
                        if( toEnterpriseProjectItem.size() > i ) {
                            entity = toEnterpriseProjectItem.get(i);
                        } else {
                            entity = new BusSolnOrdEntProjectItem();
                            toEnterpriseProjectItem.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_ExpenseItem") ) {
                final Object value = (values).remove("to_ExpenseItem");
                if( value instanceof Iterable ) {
                    if( toExpenseItem == null ) {
                        toExpenseItem = Lists.newArrayList();
                    } else {
                        toExpenseItem = Lists.newArrayList(toExpenseItem);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BusSolnOrderExpenseItem entity;
                        if( toExpenseItem.size() > i ) {
                            entity = toExpenseItem.get(i);
                        } else {
                            entity = new BusSolnOrderExpenseItem();
                            toExpenseItem.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_ItemRelationships") ) {
                final Object value = (values).remove("to_ItemRelationships");
                if( value instanceof Iterable ) {
                    if( toItemRelationships == null ) {
                        toItemRelationships = Lists.newArrayList();
                    } else {
                        toItemRelationships = Lists.newArrayList(toItemRelationships);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BusSolnOrdItemRelationships entity;
                        if( toItemRelationships.size() > i ) {
                            entity = toItemRelationships.get(i);
                        } else {
                            entity = new BusSolnOrdItemRelationships();
                            toItemRelationships.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_SalesItem") ) {
                final Object value = (values).remove("to_SalesItem");
                if( value instanceof Iterable ) {
                    if( toSalesItem == null ) {
                        toSalesItem = Lists.newArrayList();
                    } else {
                        toSalesItem = Lists.newArrayList(toSalesItem);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BusSolnOrderSalesItem entity;
                        if( toSalesItem.size() > i ) {
                            entity = toSalesItem.get(i);
                        } else {
                            entity = new BusSolnOrderSalesItem();
                            toSalesItem.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_SalesOrder") ) {
                final Object value = (values).remove("to_SalesOrder");
                if( value instanceof Iterable ) {
                    if( toSalesOrder == null ) {
                        toSalesOrder = Lists.newArrayList();
                    } else {
                        toSalesOrder = Lists.newArrayList(toSalesOrder);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BusSolnOrderFUPSalesOrder entity;
                        if( toSalesOrder.size() > i ) {
                            entity = toSalesOrder.get(i);
                        } else {
                            entity = new BusSolnOrderFUPSalesOrder();
                            toSalesOrder.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_ServiceContract") ) {
                final Object value = (values).remove("to_ServiceContract");
                if( value instanceof Iterable ) {
                    if( toServiceContract == null ) {
                        toServiceContract = Lists.newArrayList();
                    } else {
                        toServiceContract = Lists.newArrayList(toServiceContract);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BusSolnOrdFUPServiceContract entity;
                        if( toServiceContract.size() > i ) {
                            entity = toServiceContract.get(i);
                        } else {
                            entity = new BusSolnOrdFUPServiceContract();
                            toServiceContract.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_ServiceContractItem") ) {
                final Object value = (values).remove("to_ServiceContractItem");
                if( value instanceof Iterable ) {
                    if( toServiceContractItem == null ) {
                        toServiceContractItem = Lists.newArrayList();
                    } else {
                        toServiceContractItem = Lists.newArrayList(toServiceContractItem);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BusSolnOrdSrvcContractItem entity;
                        if( toServiceContractItem.size() > i ) {
                            entity = toServiceContractItem.get(i);
                        } else {
                            entity = new BusSolnOrdSrvcContractItem();
                            toServiceContractItem.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_ServiceItem") ) {
                final Object value = (values).remove("to_ServiceItem");
                if( value instanceof Iterable ) {
                    if( toServiceItem == null ) {
                        toServiceItem = Lists.newArrayList();
                    } else {
                        toServiceItem = Lists.newArrayList(toServiceItem);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BusSolnOrderServiceItem entity;
                        if( toServiceItem.size() > i ) {
                            entity = toServiceItem.get(i);
                        } else {
                            entity = new BusSolnOrderServiceItem();
                            toServiceItem.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_ServiceOrder") ) {
                final Object value = (values).remove("to_ServiceOrder");
                if( value instanceof Iterable ) {
                    if( toServiceOrder == null ) {
                        toServiceOrder = Lists.newArrayList();
                    } else {
                        toServiceOrder = Lists.newArrayList(toServiceOrder);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BusSolnOrdFUPServiceOrder entity;
                        if( toServiceOrder.size() > i ) {
                            entity = toServiceOrder.get(i);
                        } else {
                            entity = new BusSolnOrdFUPServiceOrder();
                            toServiceOrder.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_ServicePartItem") ) {
                final Object value = (values).remove("to_ServicePartItem");
                if( value instanceof Iterable ) {
                    if( toServicePartItem == null ) {
                        toServicePartItem = Lists.newArrayList();
                    } else {
                        toServicePartItem = Lists.newArrayList(toServicePartItem);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BusSolnOrdSrvcPrtItem entity;
                        if( toServicePartItem.size() > i ) {
                            entity = toServicePartItem.get(i);
                        } else {
                            entity = new BusSolnOrdSrvcPrtItem();
                            toServicePartItem.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_SubscriptionBilling") ) {
                final Object value = (values).remove("to_SubscriptionBilling");
                if( value instanceof Iterable ) {
                    if( toSubscriptionBilling == null ) {
                        toSubscriptionBilling = Lists.newArrayList();
                    } else {
                        toSubscriptionBilling = Lists.newArrayList(toSubscriptionBilling);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BusSolnOrdFUPSubscrpn entity;
                        if( toSubscriptionBilling.size() > i ) {
                            entity = toSubscriptionBilling.get(i);
                        } else {
                            entity = new BusSolnOrdFUPSubscrpn();
                            toSubscriptionBilling.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_SubscriptionBillingItem") ) {
                final Object value = (values).remove("to_SubscriptionBillingItem");
                if( value instanceof Iterable ) {
                    if( toSubscriptionBillingItem == null ) {
                        toSubscriptionBillingItem = Lists.newArrayList();
                    } else {
                        toSubscriptionBillingItem = Lists.newArrayList(toSubscriptionBillingItem);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BusSolnOrdSubscrpnBillgItem entity;
                        if( toSubscriptionBillingItem.size() > i ) {
                            entity = toSubscriptionBillingItem.get(i);
                        } else {
                            entity = new BusSolnOrdSubscrpnBillgItem();
                            toSubscriptionBillingItem.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_Text") ) {
                final Object value = (values).remove("to_Text");
                if( value instanceof Iterable ) {
                    if( toText == null ) {
                        toText = Lists.newArrayList();
                    } else {
                        toText = Lists.newArrayList(toText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BusinessSolutionOrderText entity;
                        if( toText.size() > i ) {
                            entity = toText.get(i);
                        } else {
                            entity = new BusinessSolutionOrderText();
                            toText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_UserStatus") ) {
                final Object value = (values).remove("to_UserStatus");
                if( value instanceof Iterable ) {
                    if( toUserStatus == null ) {
                        toUserStatus = Lists.newArrayList();
                    } else {
                        toUserStatus = Lists.newArrayList(toUserStatus);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        BusSolnOrdUserStatus entity;
                        if( toUserStatus.size() > i ) {
                            entity = toUserStatus.get(i);
                        } else {
                            entity = new BusSolnOrdUserStatus();
                            toUserStatus.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> BusinessSolutionOrderField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new BusinessSolutionOrderField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> BusinessSolutionOrderField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new BusinessSolutionOrderField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessSolutionOrderService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toEnterpriseProject != null ) {
            (values).put("to_EnterpriseProject", toEnterpriseProject);
        }
        if( toEnterpriseProjectItem != null ) {
            (values).put("to_EnterpriseProjectItem", toEnterpriseProjectItem);
        }
        if( toExpenseItem != null ) {
            (values).put("to_ExpenseItem", toExpenseItem);
        }
        if( toItemRelationships != null ) {
            (values).put("to_ItemRelationships", toItemRelationships);
        }
        if( toSalesItem != null ) {
            (values).put("to_SalesItem", toSalesItem);
        }
        if( toSalesOrder != null ) {
            (values).put("to_SalesOrder", toSalesOrder);
        }
        if( toServiceContract != null ) {
            (values).put("to_ServiceContract", toServiceContract);
        }
        if( toServiceContractItem != null ) {
            (values).put("to_ServiceContractItem", toServiceContractItem);
        }
        if( toServiceItem != null ) {
            (values).put("to_ServiceItem", toServiceItem);
        }
        if( toServiceOrder != null ) {
            (values).put("to_ServiceOrder", toServiceOrder);
        }
        if( toServicePartItem != null ) {
            (values).put("to_ServicePartItem", toServicePartItem);
        }
        if( toSubscriptionBilling != null ) {
            (values).put("to_SubscriptionBilling", toSubscriptionBilling);
        }
        if( toSubscriptionBillingItem != null ) {
            (values).put("to_SubscriptionBillingItem", toSubscriptionBillingItem);
        }
        if( toText != null ) {
            (values).put("to_Text", toText);
        }
        if( toUserStatus != null ) {
            (values).put("to_UserStatus", toUserStatus);
        }
        return values;
    }

    /**
     * Fetches the <b>BusSolnOrdFUPEntProject</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_EnterpriseProject</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BusSolnOrdFUPEntProject</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusSolnOrdFUPEntProject> fetchEnterpriseProject()
    {
        return fetchFieldAsList("to_EnterpriseProject", BusSolnOrdFUPEntProject.class);
    }

    /**
     * Retrieval of associated <b>BusSolnOrdFUPEntProject</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_EnterpriseProject</b>.
     * <p>
     * If the navigation property <b>to_EnterpriseProject</b> of a queried <b>BusinessSolutionOrder</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BusSolnOrdFUPEntProject</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusSolnOrdFUPEntProject> getEnterpriseProjectOrFetch()
    {
        if( toEnterpriseProject == null ) {
            toEnterpriseProject = fetchEnterpriseProject();
        }
        return toEnterpriseProject;
    }

    /**
     * Retrieval of associated <b>BusSolnOrdFUPEntProject</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_EnterpriseProject</b>.
     * <p>
     * If the navigation property for an entity <b>BusinessSolutionOrder</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_EnterpriseProject</b> is already loaded, the result will
     *         contain the <b>BusSolnOrdFUPEntProject</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BusSolnOrdFUPEntProject>> getEnterpriseProjectIfPresent()
    {
        return Option.of(toEnterpriseProject);
    }

    /**
     * Overwrites the list of associated <b>BusSolnOrdFUPEntProject</b> entities for the loaded navigation property
     * <b>to_EnterpriseProject</b>.
     * <p>
     * If the navigation property <b>to_EnterpriseProject</b> of a queried <b>BusinessSolutionOrder</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BusSolnOrdFUPEntProject</b> entities.
     */
    public void setEnterpriseProject( @Nonnull final List<BusSolnOrdFUPEntProject> value )
    {
        if( toEnterpriseProject == null ) {
            toEnterpriseProject = Lists.newArrayList();
        }
        toEnterpriseProject.clear();
        toEnterpriseProject.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BusSolnOrdFUPEntProject</b> entities. This corresponds to the OData
     * navigation property <b>to_EnterpriseProject</b>.
     * <p>
     * If the navigation property <b>to_EnterpriseProject</b> of a queried <b>BusinessSolutionOrder</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BusSolnOrdFUPEntProject</b> entities.
     */
    public void addEnterpriseProject( BusSolnOrdFUPEntProject... entity )
    {
        if( toEnterpriseProject == null ) {
            toEnterpriseProject = Lists.newArrayList();
        }
        toEnterpriseProject.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>BusSolnOrdEntProjectItem</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_EnterpriseProjectItem</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BusSolnOrdEntProjectItem</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusSolnOrdEntProjectItem> fetchEnterpriseProjectItem()
    {
        return fetchFieldAsList("to_EnterpriseProjectItem", BusSolnOrdEntProjectItem.class);
    }

    /**
     * Retrieval of associated <b>BusSolnOrdEntProjectItem</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_EnterpriseProjectItem</b>.
     * <p>
     * If the navigation property <b>to_EnterpriseProjectItem</b> of a queried <b>BusinessSolutionOrder</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BusSolnOrdEntProjectItem</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusSolnOrdEntProjectItem> getEnterpriseProjectItemOrFetch()
    {
        if( toEnterpriseProjectItem == null ) {
            toEnterpriseProjectItem = fetchEnterpriseProjectItem();
        }
        return toEnterpriseProjectItem;
    }

    /**
     * Retrieval of associated <b>BusSolnOrdEntProjectItem</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_EnterpriseProjectItem</b>.
     * <p>
     * If the navigation property for an entity <b>BusinessSolutionOrder</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_EnterpriseProjectItem</b> is already loaded, the result
     *         will contain the <b>BusSolnOrdEntProjectItem</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BusSolnOrdEntProjectItem>> getEnterpriseProjectItemIfPresent()
    {
        return Option.of(toEnterpriseProjectItem);
    }

    /**
     * Overwrites the list of associated <b>BusSolnOrdEntProjectItem</b> entities for the loaded navigation property
     * <b>to_EnterpriseProjectItem</b>.
     * <p>
     * If the navigation property <b>to_EnterpriseProjectItem</b> of a queried <b>BusinessSolutionOrder</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BusSolnOrdEntProjectItem</b> entities.
     */
    public void setEnterpriseProjectItem( @Nonnull final List<BusSolnOrdEntProjectItem> value )
    {
        if( toEnterpriseProjectItem == null ) {
            toEnterpriseProjectItem = Lists.newArrayList();
        }
        toEnterpriseProjectItem.clear();
        toEnterpriseProjectItem.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BusSolnOrdEntProjectItem</b> entities. This corresponds to the OData
     * navigation property <b>to_EnterpriseProjectItem</b>.
     * <p>
     * If the navigation property <b>to_EnterpriseProjectItem</b> of a queried <b>BusinessSolutionOrder</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BusSolnOrdEntProjectItem</b> entities.
     */
    public void addEnterpriseProjectItem( BusSolnOrdEntProjectItem... entity )
    {
        if( toEnterpriseProjectItem == null ) {
            toEnterpriseProjectItem = Lists.newArrayList();
        }
        toEnterpriseProjectItem.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>BusSolnOrderExpenseItem</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_ExpenseItem</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BusSolnOrderExpenseItem</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusSolnOrderExpenseItem> fetchExpenseItem()
    {
        return fetchFieldAsList("to_ExpenseItem", BusSolnOrderExpenseItem.class);
    }

    /**
     * Retrieval of associated <b>BusSolnOrderExpenseItem</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ExpenseItem</b>.
     * <p>
     * If the navigation property <b>to_ExpenseItem</b> of a queried <b>BusinessSolutionOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BusSolnOrderExpenseItem</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusSolnOrderExpenseItem> getExpenseItemOrFetch()
    {
        if( toExpenseItem == null ) {
            toExpenseItem = fetchExpenseItem();
        }
        return toExpenseItem;
    }

    /**
     * Retrieval of associated <b>BusSolnOrderExpenseItem</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ExpenseItem</b>.
     * <p>
     * If the navigation property for an entity <b>BusinessSolutionOrder</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ExpenseItem</b> is already loaded, the result will
     *         contain the <b>BusSolnOrderExpenseItem</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BusSolnOrderExpenseItem>> getExpenseItemIfPresent()
    {
        return Option.of(toExpenseItem);
    }

    /**
     * Overwrites the list of associated <b>BusSolnOrderExpenseItem</b> entities for the loaded navigation property
     * <b>to_ExpenseItem</b>.
     * <p>
     * If the navigation property <b>to_ExpenseItem</b> of a queried <b>BusinessSolutionOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BusSolnOrderExpenseItem</b> entities.
     */
    public void setExpenseItem( @Nonnull final List<BusSolnOrderExpenseItem> value )
    {
        if( toExpenseItem == null ) {
            toExpenseItem = Lists.newArrayList();
        }
        toExpenseItem.clear();
        toExpenseItem.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BusSolnOrderExpenseItem</b> entities. This corresponds to the OData
     * navigation property <b>to_ExpenseItem</b>.
     * <p>
     * If the navigation property <b>to_ExpenseItem</b> of a queried <b>BusinessSolutionOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BusSolnOrderExpenseItem</b> entities.
     */
    public void addExpenseItem( BusSolnOrderExpenseItem... entity )
    {
        if( toExpenseItem == null ) {
            toExpenseItem = Lists.newArrayList();
        }
        toExpenseItem.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>BusSolnOrdItemRelationships</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_ItemRelationships</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BusSolnOrdItemRelationships</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusSolnOrdItemRelationships> fetchItemRelationships()
    {
        return fetchFieldAsList("to_ItemRelationships", BusSolnOrdItemRelationships.class);
    }

    /**
     * Retrieval of associated <b>BusSolnOrdItemRelationships</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ItemRelationships</b>.
     * <p>
     * If the navigation property <b>to_ItemRelationships</b> of a queried <b>BusinessSolutionOrder</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BusSolnOrdItemRelationships</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusSolnOrdItemRelationships> getItemRelationshipsOrFetch()
    {
        if( toItemRelationships == null ) {
            toItemRelationships = fetchItemRelationships();
        }
        return toItemRelationships;
    }

    /**
     * Retrieval of associated <b>BusSolnOrdItemRelationships</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ItemRelationships</b>.
     * <p>
     * If the navigation property for an entity <b>BusinessSolutionOrder</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ItemRelationships</b> is already loaded, the result will
     *         contain the <b>BusSolnOrdItemRelationships</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BusSolnOrdItemRelationships>> getItemRelationshipsIfPresent()
    {
        return Option.of(toItemRelationships);
    }

    /**
     * Overwrites the list of associated <b>BusSolnOrdItemRelationships</b> entities for the loaded navigation property
     * <b>to_ItemRelationships</b>.
     * <p>
     * If the navigation property <b>to_ItemRelationships</b> of a queried <b>BusinessSolutionOrder</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BusSolnOrdItemRelationships</b> entities.
     */
    public void setItemRelationships( @Nonnull final List<BusSolnOrdItemRelationships> value )
    {
        if( toItemRelationships == null ) {
            toItemRelationships = Lists.newArrayList();
        }
        toItemRelationships.clear();
        toItemRelationships.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BusSolnOrdItemRelationships</b> entities. This corresponds to the
     * OData navigation property <b>to_ItemRelationships</b>.
     * <p>
     * If the navigation property <b>to_ItemRelationships</b> of a queried <b>BusinessSolutionOrder</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BusSolnOrdItemRelationships</b> entities.
     */
    public void addItemRelationships( BusSolnOrdItemRelationships... entity )
    {
        if( toItemRelationships == null ) {
            toItemRelationships = Lists.newArrayList();
        }
        toItemRelationships.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>BusSolnOrderSalesItem</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_SalesItem</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BusSolnOrderSalesItem</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusSolnOrderSalesItem> fetchSalesItem()
    {
        return fetchFieldAsList("to_SalesItem", BusSolnOrderSalesItem.class);
    }

    /**
     * Retrieval of associated <b>BusSolnOrderSalesItem</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SalesItem</b>.
     * <p>
     * If the navigation property <b>to_SalesItem</b> of a queried <b>BusinessSolutionOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BusSolnOrderSalesItem</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusSolnOrderSalesItem> getSalesItemOrFetch()
    {
        if( toSalesItem == null ) {
            toSalesItem = fetchSalesItem();
        }
        return toSalesItem;
    }

    /**
     * Retrieval of associated <b>BusSolnOrderSalesItem</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SalesItem</b>.
     * <p>
     * If the navigation property for an entity <b>BusinessSolutionOrder</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SalesItem</b> is already loaded, the result will contain
     *         the <b>BusSolnOrderSalesItem</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BusSolnOrderSalesItem>> getSalesItemIfPresent()
    {
        return Option.of(toSalesItem);
    }

    /**
     * Overwrites the list of associated <b>BusSolnOrderSalesItem</b> entities for the loaded navigation property
     * <b>to_SalesItem</b>.
     * <p>
     * If the navigation property <b>to_SalesItem</b> of a queried <b>BusinessSolutionOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BusSolnOrderSalesItem</b> entities.
     */
    public void setSalesItem( @Nonnull final List<BusSolnOrderSalesItem> value )
    {
        if( toSalesItem == null ) {
            toSalesItem = Lists.newArrayList();
        }
        toSalesItem.clear();
        toSalesItem.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BusSolnOrderSalesItem</b> entities. This corresponds to the OData
     * navigation property <b>to_SalesItem</b>.
     * <p>
     * If the navigation property <b>to_SalesItem</b> of a queried <b>BusinessSolutionOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BusSolnOrderSalesItem</b> entities.
     */
    public void addSalesItem( BusSolnOrderSalesItem... entity )
    {
        if( toSalesItem == null ) {
            toSalesItem = Lists.newArrayList();
        }
        toSalesItem.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>BusSolnOrderFUPSalesOrder</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_SalesOrder</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BusSolnOrderFUPSalesOrder</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusSolnOrderFUPSalesOrder> fetchSalesOrder()
    {
        return fetchFieldAsList("to_SalesOrder", BusSolnOrderFUPSalesOrder.class);
    }

    /**
     * Retrieval of associated <b>BusSolnOrderFUPSalesOrder</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SalesOrder</b>.
     * <p>
     * If the navigation property <b>to_SalesOrder</b> of a queried <b>BusinessSolutionOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BusSolnOrderFUPSalesOrder</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusSolnOrderFUPSalesOrder> getSalesOrderOrFetch()
    {
        if( toSalesOrder == null ) {
            toSalesOrder = fetchSalesOrder();
        }
        return toSalesOrder;
    }

    /**
     * Retrieval of associated <b>BusSolnOrderFUPSalesOrder</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SalesOrder</b>.
     * <p>
     * If the navigation property for an entity <b>BusinessSolutionOrder</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SalesOrder</b> is already loaded, the result will
     *         contain the <b>BusSolnOrderFUPSalesOrder</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BusSolnOrderFUPSalesOrder>> getSalesOrderIfPresent()
    {
        return Option.of(toSalesOrder);
    }

    /**
     * Overwrites the list of associated <b>BusSolnOrderFUPSalesOrder</b> entities for the loaded navigation property
     * <b>to_SalesOrder</b>.
     * <p>
     * If the navigation property <b>to_SalesOrder</b> of a queried <b>BusinessSolutionOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BusSolnOrderFUPSalesOrder</b> entities.
     */
    public void setSalesOrder( @Nonnull final List<BusSolnOrderFUPSalesOrder> value )
    {
        if( toSalesOrder == null ) {
            toSalesOrder = Lists.newArrayList();
        }
        toSalesOrder.clear();
        toSalesOrder.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BusSolnOrderFUPSalesOrder</b> entities. This corresponds to the OData
     * navigation property <b>to_SalesOrder</b>.
     * <p>
     * If the navigation property <b>to_SalesOrder</b> of a queried <b>BusinessSolutionOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BusSolnOrderFUPSalesOrder</b> entities.
     */
    public void addSalesOrder( BusSolnOrderFUPSalesOrder... entity )
    {
        if( toSalesOrder == null ) {
            toSalesOrder = Lists.newArrayList();
        }
        toSalesOrder.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>BusSolnOrdFUPServiceContract</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_ServiceContract</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BusSolnOrdFUPServiceContract</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusSolnOrdFUPServiceContract> fetchServiceContract()
    {
        return fetchFieldAsList("to_ServiceContract", BusSolnOrdFUPServiceContract.class);
    }

    /**
     * Retrieval of associated <b>BusSolnOrdFUPServiceContract</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ServiceContract</b>.
     * <p>
     * If the navigation property <b>to_ServiceContract</b> of a queried <b>BusinessSolutionOrder</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BusSolnOrdFUPServiceContract</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusSolnOrdFUPServiceContract> getServiceContractOrFetch()
    {
        if( toServiceContract == null ) {
            toServiceContract = fetchServiceContract();
        }
        return toServiceContract;
    }

    /**
     * Retrieval of associated <b>BusSolnOrdFUPServiceContract</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ServiceContract</b>.
     * <p>
     * If the navigation property for an entity <b>BusinessSolutionOrder</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ServiceContract</b> is already loaded, the result will
     *         contain the <b>BusSolnOrdFUPServiceContract</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BusSolnOrdFUPServiceContract>> getServiceContractIfPresent()
    {
        return Option.of(toServiceContract);
    }

    /**
     * Overwrites the list of associated <b>BusSolnOrdFUPServiceContract</b> entities for the loaded navigation property
     * <b>to_ServiceContract</b>.
     * <p>
     * If the navigation property <b>to_ServiceContract</b> of a queried <b>BusinessSolutionOrder</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BusSolnOrdFUPServiceContract</b> entities.
     */
    public void setServiceContract( @Nonnull final List<BusSolnOrdFUPServiceContract> value )
    {
        if( toServiceContract == null ) {
            toServiceContract = Lists.newArrayList();
        }
        toServiceContract.clear();
        toServiceContract.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BusSolnOrdFUPServiceContract</b> entities. This corresponds to the
     * OData navigation property <b>to_ServiceContract</b>.
     * <p>
     * If the navigation property <b>to_ServiceContract</b> of a queried <b>BusinessSolutionOrder</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BusSolnOrdFUPServiceContract</b> entities.
     */
    public void addServiceContract( BusSolnOrdFUPServiceContract... entity )
    {
        if( toServiceContract == null ) {
            toServiceContract = Lists.newArrayList();
        }
        toServiceContract.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>BusSolnOrdSrvcContractItem</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_ServiceContractItem</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BusSolnOrdSrvcContractItem</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusSolnOrdSrvcContractItem> fetchServiceContractItem()
    {
        return fetchFieldAsList("to_ServiceContractItem", BusSolnOrdSrvcContractItem.class);
    }

    /**
     * Retrieval of associated <b>BusSolnOrdSrvcContractItem</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ServiceContractItem</b>.
     * <p>
     * If the navigation property <b>to_ServiceContractItem</b> of a queried <b>BusinessSolutionOrder</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BusSolnOrdSrvcContractItem</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusSolnOrdSrvcContractItem> getServiceContractItemOrFetch()
    {
        if( toServiceContractItem == null ) {
            toServiceContractItem = fetchServiceContractItem();
        }
        return toServiceContractItem;
    }

    /**
     * Retrieval of associated <b>BusSolnOrdSrvcContractItem</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ServiceContractItem</b>.
     * <p>
     * If the navigation property for an entity <b>BusinessSolutionOrder</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ServiceContractItem</b> is already loaded, the result
     *         will contain the <b>BusSolnOrdSrvcContractItem</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BusSolnOrdSrvcContractItem>> getServiceContractItemIfPresent()
    {
        return Option.of(toServiceContractItem);
    }

    /**
     * Overwrites the list of associated <b>BusSolnOrdSrvcContractItem</b> entities for the loaded navigation property
     * <b>to_ServiceContractItem</b>.
     * <p>
     * If the navigation property <b>to_ServiceContractItem</b> of a queried <b>BusinessSolutionOrder</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BusSolnOrdSrvcContractItem</b> entities.
     */
    public void setServiceContractItem( @Nonnull final List<BusSolnOrdSrvcContractItem> value )
    {
        if( toServiceContractItem == null ) {
            toServiceContractItem = Lists.newArrayList();
        }
        toServiceContractItem.clear();
        toServiceContractItem.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BusSolnOrdSrvcContractItem</b> entities. This corresponds to the OData
     * navigation property <b>to_ServiceContractItem</b>.
     * <p>
     * If the navigation property <b>to_ServiceContractItem</b> of a queried <b>BusinessSolutionOrder</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BusSolnOrdSrvcContractItem</b> entities.
     */
    public void addServiceContractItem( BusSolnOrdSrvcContractItem... entity )
    {
        if( toServiceContractItem == null ) {
            toServiceContractItem = Lists.newArrayList();
        }
        toServiceContractItem.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>BusSolnOrderServiceItem</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_ServiceItem</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BusSolnOrderServiceItem</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusSolnOrderServiceItem> fetchServiceItem()
    {
        return fetchFieldAsList("to_ServiceItem", BusSolnOrderServiceItem.class);
    }

    /**
     * Retrieval of associated <b>BusSolnOrderServiceItem</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ServiceItem</b>.
     * <p>
     * If the navigation property <b>to_ServiceItem</b> of a queried <b>BusinessSolutionOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BusSolnOrderServiceItem</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusSolnOrderServiceItem> getServiceItemOrFetch()
    {
        if( toServiceItem == null ) {
            toServiceItem = fetchServiceItem();
        }
        return toServiceItem;
    }

    /**
     * Retrieval of associated <b>BusSolnOrderServiceItem</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ServiceItem</b>.
     * <p>
     * If the navigation property for an entity <b>BusinessSolutionOrder</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ServiceItem</b> is already loaded, the result will
     *         contain the <b>BusSolnOrderServiceItem</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BusSolnOrderServiceItem>> getServiceItemIfPresent()
    {
        return Option.of(toServiceItem);
    }

    /**
     * Overwrites the list of associated <b>BusSolnOrderServiceItem</b> entities for the loaded navigation property
     * <b>to_ServiceItem</b>.
     * <p>
     * If the navigation property <b>to_ServiceItem</b> of a queried <b>BusinessSolutionOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BusSolnOrderServiceItem</b> entities.
     */
    public void setServiceItem( @Nonnull final List<BusSolnOrderServiceItem> value )
    {
        if( toServiceItem == null ) {
            toServiceItem = Lists.newArrayList();
        }
        toServiceItem.clear();
        toServiceItem.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BusSolnOrderServiceItem</b> entities. This corresponds to the OData
     * navigation property <b>to_ServiceItem</b>.
     * <p>
     * If the navigation property <b>to_ServiceItem</b> of a queried <b>BusinessSolutionOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BusSolnOrderServiceItem</b> entities.
     */
    public void addServiceItem( BusSolnOrderServiceItem... entity )
    {
        if( toServiceItem == null ) {
            toServiceItem = Lists.newArrayList();
        }
        toServiceItem.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>BusSolnOrdFUPServiceOrder</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_ServiceOrder</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BusSolnOrdFUPServiceOrder</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusSolnOrdFUPServiceOrder> fetchServiceOrder()
    {
        return fetchFieldAsList("to_ServiceOrder", BusSolnOrdFUPServiceOrder.class);
    }

    /**
     * Retrieval of associated <b>BusSolnOrdFUPServiceOrder</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ServiceOrder</b>.
     * <p>
     * If the navigation property <b>to_ServiceOrder</b> of a queried <b>BusinessSolutionOrder</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BusSolnOrdFUPServiceOrder</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusSolnOrdFUPServiceOrder> getServiceOrderOrFetch()
    {
        if( toServiceOrder == null ) {
            toServiceOrder = fetchServiceOrder();
        }
        return toServiceOrder;
    }

    /**
     * Retrieval of associated <b>BusSolnOrdFUPServiceOrder</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ServiceOrder</b>.
     * <p>
     * If the navigation property for an entity <b>BusinessSolutionOrder</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ServiceOrder</b> is already loaded, the result will
     *         contain the <b>BusSolnOrdFUPServiceOrder</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BusSolnOrdFUPServiceOrder>> getServiceOrderIfPresent()
    {
        return Option.of(toServiceOrder);
    }

    /**
     * Overwrites the list of associated <b>BusSolnOrdFUPServiceOrder</b> entities for the loaded navigation property
     * <b>to_ServiceOrder</b>.
     * <p>
     * If the navigation property <b>to_ServiceOrder</b> of a queried <b>BusinessSolutionOrder</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BusSolnOrdFUPServiceOrder</b> entities.
     */
    public void setServiceOrder( @Nonnull final List<BusSolnOrdFUPServiceOrder> value )
    {
        if( toServiceOrder == null ) {
            toServiceOrder = Lists.newArrayList();
        }
        toServiceOrder.clear();
        toServiceOrder.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BusSolnOrdFUPServiceOrder</b> entities. This corresponds to the OData
     * navigation property <b>to_ServiceOrder</b>.
     * <p>
     * If the navigation property <b>to_ServiceOrder</b> of a queried <b>BusinessSolutionOrder</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BusSolnOrdFUPServiceOrder</b> entities.
     */
    public void addServiceOrder( BusSolnOrdFUPServiceOrder... entity )
    {
        if( toServiceOrder == null ) {
            toServiceOrder = Lists.newArrayList();
        }
        toServiceOrder.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>BusSolnOrdSrvcPrtItem</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_ServicePartItem</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BusSolnOrdSrvcPrtItem</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusSolnOrdSrvcPrtItem> fetchServicePartItem()
    {
        return fetchFieldAsList("to_ServicePartItem", BusSolnOrdSrvcPrtItem.class);
    }

    /**
     * Retrieval of associated <b>BusSolnOrdSrvcPrtItem</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ServicePartItem</b>.
     * <p>
     * If the navigation property <b>to_ServicePartItem</b> of a queried <b>BusinessSolutionOrder</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BusSolnOrdSrvcPrtItem</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusSolnOrdSrvcPrtItem> getServicePartItemOrFetch()
    {
        if( toServicePartItem == null ) {
            toServicePartItem = fetchServicePartItem();
        }
        return toServicePartItem;
    }

    /**
     * Retrieval of associated <b>BusSolnOrdSrvcPrtItem</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ServicePartItem</b>.
     * <p>
     * If the navigation property for an entity <b>BusinessSolutionOrder</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ServicePartItem</b> is already loaded, the result will
     *         contain the <b>BusSolnOrdSrvcPrtItem</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BusSolnOrdSrvcPrtItem>> getServicePartItemIfPresent()
    {
        return Option.of(toServicePartItem);
    }

    /**
     * Overwrites the list of associated <b>BusSolnOrdSrvcPrtItem</b> entities for the loaded navigation property
     * <b>to_ServicePartItem</b>.
     * <p>
     * If the navigation property <b>to_ServicePartItem</b> of a queried <b>BusinessSolutionOrder</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BusSolnOrdSrvcPrtItem</b> entities.
     */
    public void setServicePartItem( @Nonnull final List<BusSolnOrdSrvcPrtItem> value )
    {
        if( toServicePartItem == null ) {
            toServicePartItem = Lists.newArrayList();
        }
        toServicePartItem.clear();
        toServicePartItem.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BusSolnOrdSrvcPrtItem</b> entities. This corresponds to the OData
     * navigation property <b>to_ServicePartItem</b>.
     * <p>
     * If the navigation property <b>to_ServicePartItem</b> of a queried <b>BusinessSolutionOrder</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BusSolnOrdSrvcPrtItem</b> entities.
     */
    public void addServicePartItem( BusSolnOrdSrvcPrtItem... entity )
    {
        if( toServicePartItem == null ) {
            toServicePartItem = Lists.newArrayList();
        }
        toServicePartItem.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>BusSolnOrdFUPSubscrpn</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_SubscriptionBilling</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BusSolnOrdFUPSubscrpn</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusSolnOrdFUPSubscrpn> fetchSubscriptionBilling()
    {
        return fetchFieldAsList("to_SubscriptionBilling", BusSolnOrdFUPSubscrpn.class);
    }

    /**
     * Retrieval of associated <b>BusSolnOrdFUPSubscrpn</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SubscriptionBilling</b>.
     * <p>
     * If the navigation property <b>to_SubscriptionBilling</b> of a queried <b>BusinessSolutionOrder</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BusSolnOrdFUPSubscrpn</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusSolnOrdFUPSubscrpn> getSubscriptionBillingOrFetch()
    {
        if( toSubscriptionBilling == null ) {
            toSubscriptionBilling = fetchSubscriptionBilling();
        }
        return toSubscriptionBilling;
    }

    /**
     * Retrieval of associated <b>BusSolnOrdFUPSubscrpn</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SubscriptionBilling</b>.
     * <p>
     * If the navigation property for an entity <b>BusinessSolutionOrder</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SubscriptionBilling</b> is already loaded, the result
     *         will contain the <b>BusSolnOrdFUPSubscrpn</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BusSolnOrdFUPSubscrpn>> getSubscriptionBillingIfPresent()
    {
        return Option.of(toSubscriptionBilling);
    }

    /**
     * Overwrites the list of associated <b>BusSolnOrdFUPSubscrpn</b> entities for the loaded navigation property
     * <b>to_SubscriptionBilling</b>.
     * <p>
     * If the navigation property <b>to_SubscriptionBilling</b> of a queried <b>BusinessSolutionOrder</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BusSolnOrdFUPSubscrpn</b> entities.
     */
    public void setSubscriptionBilling( @Nonnull final List<BusSolnOrdFUPSubscrpn> value )
    {
        if( toSubscriptionBilling == null ) {
            toSubscriptionBilling = Lists.newArrayList();
        }
        toSubscriptionBilling.clear();
        toSubscriptionBilling.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BusSolnOrdFUPSubscrpn</b> entities. This corresponds to the OData
     * navigation property <b>to_SubscriptionBilling</b>.
     * <p>
     * If the navigation property <b>to_SubscriptionBilling</b> of a queried <b>BusinessSolutionOrder</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BusSolnOrdFUPSubscrpn</b> entities.
     */
    public void addSubscriptionBilling( BusSolnOrdFUPSubscrpn... entity )
    {
        if( toSubscriptionBilling == null ) {
            toSubscriptionBilling = Lists.newArrayList();
        }
        toSubscriptionBilling.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>BusSolnOrdSubscrpnBillgItem</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_SubscriptionBillingItem</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BusSolnOrdSubscrpnBillgItem</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusSolnOrdSubscrpnBillgItem> fetchSubscriptionBillingItem()
    {
        return fetchFieldAsList("to_SubscriptionBillingItem", BusSolnOrdSubscrpnBillgItem.class);
    }

    /**
     * Retrieval of associated <b>BusSolnOrdSubscrpnBillgItem</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SubscriptionBillingItem</b>.
     * <p>
     * If the navigation property <b>to_SubscriptionBillingItem</b> of a queried <b>BusinessSolutionOrder</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BusSolnOrdSubscrpnBillgItem</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusSolnOrdSubscrpnBillgItem> getSubscriptionBillingItemOrFetch()
    {
        if( toSubscriptionBillingItem == null ) {
            toSubscriptionBillingItem = fetchSubscriptionBillingItem();
        }
        return toSubscriptionBillingItem;
    }

    /**
     * Retrieval of associated <b>BusSolnOrdSubscrpnBillgItem</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SubscriptionBillingItem</b>.
     * <p>
     * If the navigation property for an entity <b>BusinessSolutionOrder</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SubscriptionBillingItem</b> is already loaded, the
     *         result will contain the <b>BusSolnOrdSubscrpnBillgItem</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BusSolnOrdSubscrpnBillgItem>> getSubscriptionBillingItemIfPresent()
    {
        return Option.of(toSubscriptionBillingItem);
    }

    /**
     * Overwrites the list of associated <b>BusSolnOrdSubscrpnBillgItem</b> entities for the loaded navigation property
     * <b>to_SubscriptionBillingItem</b>.
     * <p>
     * If the navigation property <b>to_SubscriptionBillingItem</b> of a queried <b>BusinessSolutionOrder</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BusSolnOrdSubscrpnBillgItem</b> entities.
     */
    public void setSubscriptionBillingItem( @Nonnull final List<BusSolnOrdSubscrpnBillgItem> value )
    {
        if( toSubscriptionBillingItem == null ) {
            toSubscriptionBillingItem = Lists.newArrayList();
        }
        toSubscriptionBillingItem.clear();
        toSubscriptionBillingItem.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BusSolnOrdSubscrpnBillgItem</b> entities. This corresponds to the
     * OData navigation property <b>to_SubscriptionBillingItem</b>.
     * <p>
     * If the navigation property <b>to_SubscriptionBillingItem</b> of a queried <b>BusinessSolutionOrder</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BusSolnOrdSubscrpnBillgItem</b> entities.
     */
    public void addSubscriptionBillingItem( BusSolnOrdSubscrpnBillgItem... entity )
    {
        if( toSubscriptionBillingItem == null ) {
            toSubscriptionBillingItem = Lists.newArrayList();
        }
        toSubscriptionBillingItem.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>BusinessSolutionOrderText</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_Text</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BusinessSolutionOrderText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusinessSolutionOrderText> fetchText()
    {
        return fetchFieldAsList("to_Text", BusinessSolutionOrderText.class);
    }

    /**
     * Retrieval of associated <b>BusinessSolutionOrderText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>BusinessSolutionOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BusinessSolutionOrderText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusinessSolutionOrderText> getTextOrFetch()
    {
        if( toText == null ) {
            toText = fetchText();
        }
        return toText;
    }

    /**
     * Retrieval of associated <b>BusinessSolutionOrderText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property for an entity <b>BusinessSolutionOrder</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Text</b> is already loaded, the result will contain the
     *         <b>BusinessSolutionOrderText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BusinessSolutionOrderText>> getTextIfPresent()
    {
        return Option.of(toText);
    }

    /**
     * Overwrites the list of associated <b>BusinessSolutionOrderText</b> entities for the loaded navigation property
     * <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>BusinessSolutionOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BusinessSolutionOrderText</b> entities.
     */
    public void setText( @Nonnull final List<BusinessSolutionOrderText> value )
    {
        if( toText == null ) {
            toText = Lists.newArrayList();
        }
        toText.clear();
        toText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BusinessSolutionOrderText</b> entities. This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>BusinessSolutionOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BusinessSolutionOrderText</b> entities.
     */
    public void addText( BusinessSolutionOrderText... entity )
    {
        if( toText == null ) {
            toText = Lists.newArrayList();
        }
        toText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>BusSolnOrdUserStatus</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_UserStatus</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>BusSolnOrdUserStatus</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusSolnOrdUserStatus> fetchUserStatus()
    {
        return fetchFieldAsList("to_UserStatus", BusSolnOrdUserStatus.class);
    }

    /**
     * Retrieval of associated <b>BusSolnOrdUserStatus</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_UserStatus</b>.
     * <p>
     * If the navigation property <b>to_UserStatus</b> of a queried <b>BusinessSolutionOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>BusSolnOrdUserStatus</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<BusSolnOrdUserStatus> getUserStatusOrFetch()
    {
        if( toUserStatus == null ) {
            toUserStatus = fetchUserStatus();
        }
        return toUserStatus;
    }

    /**
     * Retrieval of associated <b>BusSolnOrdUserStatus</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_UserStatus</b>.
     * <p>
     * If the navigation property for an entity <b>BusinessSolutionOrder</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_UserStatus</b> is already loaded, the result will
     *         contain the <b>BusSolnOrdUserStatus</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<BusSolnOrdUserStatus>> getUserStatusIfPresent()
    {
        return Option.of(toUserStatus);
    }

    /**
     * Overwrites the list of associated <b>BusSolnOrdUserStatus</b> entities for the loaded navigation property
     * <b>to_UserStatus</b>.
     * <p>
     * If the navigation property <b>to_UserStatus</b> of a queried <b>BusinessSolutionOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>BusSolnOrdUserStatus</b> entities.
     */
    public void setUserStatus( @Nonnull final List<BusSolnOrdUserStatus> value )
    {
        if( toUserStatus == null ) {
            toUserStatus = Lists.newArrayList();
        }
        toUserStatus.clear();
        toUserStatus.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>BusSolnOrdUserStatus</b> entities. This corresponds to the OData
     * navigation property <b>to_UserStatus</b>.
     * <p>
     * If the navigation property <b>to_UserStatus</b> of a queried <b>BusinessSolutionOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>BusSolnOrdUserStatus</b> entities.
     */
    public void addUserStatus( BusSolnOrdUserStatus... entity )
    {
        if( toUserStatus == null ) {
            toUserStatus = Lists.newArrayList();
        }
        toUserStatus.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of BusinessSolutionOrder instances.
     *
     */
    public final static class BusinessSolutionOrderBuilder
    {

        private List<BusSolnOrdFUPEntProject> toEnterpriseProject = Lists.newArrayList();
        private List<BusSolnOrdEntProjectItem> toEnterpriseProjectItem = Lists.newArrayList();
        private List<BusSolnOrderExpenseItem> toExpenseItem = Lists.newArrayList();
        private List<BusSolnOrdItemRelationships> toItemRelationships = Lists.newArrayList();
        private List<BusSolnOrderSalesItem> toSalesItem = Lists.newArrayList();
        private List<BusSolnOrderFUPSalesOrder> toSalesOrder = Lists.newArrayList();
        private List<BusSolnOrdFUPServiceContract> toServiceContract = Lists.newArrayList();
        private List<BusSolnOrdSrvcContractItem> toServiceContractItem = Lists.newArrayList();
        private List<BusSolnOrderServiceItem> toServiceItem = Lists.newArrayList();
        private List<BusSolnOrdFUPServiceOrder> toServiceOrder = Lists.newArrayList();
        private List<BusSolnOrdSrvcPrtItem> toServicePartItem = Lists.newArrayList();
        private List<BusSolnOrdFUPSubscrpn> toSubscriptionBilling = Lists.newArrayList();
        private List<BusSolnOrdSubscrpnBillgItem> toSubscriptionBillingItem = Lists.newArrayList();
        private List<BusinessSolutionOrderText> toText = Lists.newArrayList();
        private List<BusSolnOrdUserStatus> toUserStatus = Lists.newArrayList();

        private BusinessSolutionOrder.BusinessSolutionOrderBuilder toEnterpriseProject(
            final List<BusSolnOrdFUPEntProject> value )
        {
            toEnterpriseProject.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_EnterpriseProject</b> for <b>BusinessSolutionOrder</b> to multiple
         * <b>BusSolnOrdFUPEntProject</b>.
         *
         * @param value
         *            The BusSolnOrdFUPEntProjects to build this BusinessSolutionOrder with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusinessSolutionOrder.BusinessSolutionOrderBuilder enterpriseProject( BusSolnOrdFUPEntProject... value )
        {
            return toEnterpriseProject(Lists.newArrayList(value));
        }

        private BusinessSolutionOrder.BusinessSolutionOrderBuilder toEnterpriseProjectItem(
            final List<BusSolnOrdEntProjectItem> value )
        {
            toEnterpriseProjectItem.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_EnterpriseProjectItem</b> for <b>BusinessSolutionOrder</b> to multiple
         * <b>BusSolnOrdEntProjectItem</b>.
         *
         * @param value
         *            The BusSolnOrdEntProjectItems to build this BusinessSolutionOrder with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusinessSolutionOrder.BusinessSolutionOrderBuilder enterpriseProjectItem(
            BusSolnOrdEntProjectItem... value )
        {
            return toEnterpriseProjectItem(Lists.newArrayList(value));
        }

        private BusinessSolutionOrder.BusinessSolutionOrderBuilder toExpenseItem(
            final List<BusSolnOrderExpenseItem> value )
        {
            toExpenseItem.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ExpenseItem</b> for <b>BusinessSolutionOrder</b> to multiple
         * <b>BusSolnOrderExpenseItem</b>.
         *
         * @param value
         *            The BusSolnOrderExpenseItems to build this BusinessSolutionOrder with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusinessSolutionOrder.BusinessSolutionOrderBuilder expenseItem( BusSolnOrderExpenseItem... value )
        {
            return toExpenseItem(Lists.newArrayList(value));
        }

        private BusinessSolutionOrder.BusinessSolutionOrderBuilder toItemRelationships(
            final List<BusSolnOrdItemRelationships> value )
        {
            toItemRelationships.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ItemRelationships</b> for <b>BusinessSolutionOrder</b> to multiple
         * <b>BusSolnOrdItemRelationships</b>.
         *
         * @param value
         *            The BusSolnOrdItemRelationshipss to build this BusinessSolutionOrder with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusinessSolutionOrder.BusinessSolutionOrderBuilder itemRelationships(
            BusSolnOrdItemRelationships... value )
        {
            return toItemRelationships(Lists.newArrayList(value));
        }

        private BusinessSolutionOrder.BusinessSolutionOrderBuilder toSalesItem(
            final List<BusSolnOrderSalesItem> value )
        {
            toSalesItem.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_SalesItem</b> for <b>BusinessSolutionOrder</b> to multiple
         * <b>BusSolnOrderSalesItem</b>.
         *
         * @param value
         *            The BusSolnOrderSalesItems to build this BusinessSolutionOrder with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusinessSolutionOrder.BusinessSolutionOrderBuilder salesItem( BusSolnOrderSalesItem... value )
        {
            return toSalesItem(Lists.newArrayList(value));
        }

        private BusinessSolutionOrder.BusinessSolutionOrderBuilder toSalesOrder(
            final List<BusSolnOrderFUPSalesOrder> value )
        {
            toSalesOrder.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_SalesOrder</b> for <b>BusinessSolutionOrder</b> to multiple
         * <b>BusSolnOrderFUPSalesOrder</b>.
         *
         * @param value
         *            The BusSolnOrderFUPSalesOrders to build this BusinessSolutionOrder with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusinessSolutionOrder.BusinessSolutionOrderBuilder salesOrder( BusSolnOrderFUPSalesOrder... value )
        {
            return toSalesOrder(Lists.newArrayList(value));
        }

        private BusinessSolutionOrder.BusinessSolutionOrderBuilder toServiceContract(
            final List<BusSolnOrdFUPServiceContract> value )
        {
            toServiceContract.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ServiceContract</b> for <b>BusinessSolutionOrder</b> to multiple
         * <b>BusSolnOrdFUPServiceContract</b>.
         *
         * @param value
         *            The BusSolnOrdFUPServiceContracts to build this BusinessSolutionOrder with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusinessSolutionOrder.BusinessSolutionOrderBuilder serviceContract(
            BusSolnOrdFUPServiceContract... value )
        {
            return toServiceContract(Lists.newArrayList(value));
        }

        private BusinessSolutionOrder.BusinessSolutionOrderBuilder toServiceContractItem(
            final List<BusSolnOrdSrvcContractItem> value )
        {
            toServiceContractItem.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ServiceContractItem</b> for <b>BusinessSolutionOrder</b> to multiple
         * <b>BusSolnOrdSrvcContractItem</b>.
         *
         * @param value
         *            The BusSolnOrdSrvcContractItems to build this BusinessSolutionOrder with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusinessSolutionOrder.BusinessSolutionOrderBuilder serviceContractItem(
            BusSolnOrdSrvcContractItem... value )
        {
            return toServiceContractItem(Lists.newArrayList(value));
        }

        private BusinessSolutionOrder.BusinessSolutionOrderBuilder toServiceItem(
            final List<BusSolnOrderServiceItem> value )
        {
            toServiceItem.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ServiceItem</b> for <b>BusinessSolutionOrder</b> to multiple
         * <b>BusSolnOrderServiceItem</b>.
         *
         * @param value
         *            The BusSolnOrderServiceItems to build this BusinessSolutionOrder with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusinessSolutionOrder.BusinessSolutionOrderBuilder serviceItem( BusSolnOrderServiceItem... value )
        {
            return toServiceItem(Lists.newArrayList(value));
        }

        private BusinessSolutionOrder.BusinessSolutionOrderBuilder toServiceOrder(
            final List<BusSolnOrdFUPServiceOrder> value )
        {
            toServiceOrder.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ServiceOrder</b> for <b>BusinessSolutionOrder</b> to multiple
         * <b>BusSolnOrdFUPServiceOrder</b>.
         *
         * @param value
         *            The BusSolnOrdFUPServiceOrders to build this BusinessSolutionOrder with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusinessSolutionOrder.BusinessSolutionOrderBuilder serviceOrder( BusSolnOrdFUPServiceOrder... value )
        {
            return toServiceOrder(Lists.newArrayList(value));
        }

        private BusinessSolutionOrder.BusinessSolutionOrderBuilder toServicePartItem(
            final List<BusSolnOrdSrvcPrtItem> value )
        {
            toServicePartItem.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ServicePartItem</b> for <b>BusinessSolutionOrder</b> to multiple
         * <b>BusSolnOrdSrvcPrtItem</b>.
         *
         * @param value
         *            The BusSolnOrdSrvcPrtItems to build this BusinessSolutionOrder with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusinessSolutionOrder.BusinessSolutionOrderBuilder servicePartItem( BusSolnOrdSrvcPrtItem... value )
        {
            return toServicePartItem(Lists.newArrayList(value));
        }

        private BusinessSolutionOrder.BusinessSolutionOrderBuilder toSubscriptionBilling(
            final List<BusSolnOrdFUPSubscrpn> value )
        {
            toSubscriptionBilling.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_SubscriptionBilling</b> for <b>BusinessSolutionOrder</b> to multiple
         * <b>BusSolnOrdFUPSubscrpn</b>.
         *
         * @param value
         *            The BusSolnOrdFUPSubscrpns to build this BusinessSolutionOrder with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusinessSolutionOrder.BusinessSolutionOrderBuilder subscriptionBilling( BusSolnOrdFUPSubscrpn... value )
        {
            return toSubscriptionBilling(Lists.newArrayList(value));
        }

        private BusinessSolutionOrder.BusinessSolutionOrderBuilder toSubscriptionBillingItem(
            final List<BusSolnOrdSubscrpnBillgItem> value )
        {
            toSubscriptionBillingItem.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_SubscriptionBillingItem</b> for <b>BusinessSolutionOrder</b> to multiple
         * <b>BusSolnOrdSubscrpnBillgItem</b>.
         *
         * @param value
         *            The BusSolnOrdSubscrpnBillgItems to build this BusinessSolutionOrder with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusinessSolutionOrder.BusinessSolutionOrderBuilder subscriptionBillingItem(
            BusSolnOrdSubscrpnBillgItem... value )
        {
            return toSubscriptionBillingItem(Lists.newArrayList(value));
        }

        private BusinessSolutionOrder.BusinessSolutionOrderBuilder toText( final List<BusinessSolutionOrderText> value )
        {
            toText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Text</b> for <b>BusinessSolutionOrder</b> to multiple
         * <b>BusinessSolutionOrderText</b>.
         *
         * @param value
         *            The BusinessSolutionOrderTexts to build this BusinessSolutionOrder with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusinessSolutionOrder.BusinessSolutionOrderBuilder text( BusinessSolutionOrderText... value )
        {
            return toText(Lists.newArrayList(value));
        }

        private BusinessSolutionOrder.BusinessSolutionOrderBuilder toUserStatus(
            final List<BusSolnOrdUserStatus> value )
        {
            toUserStatus.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_UserStatus</b> for <b>BusinessSolutionOrder</b> to multiple
         * <b>BusSolnOrdUserStatus</b>.
         *
         * @param value
         *            The BusSolnOrdUserStatuss to build this BusinessSolutionOrder with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusinessSolutionOrder.BusinessSolutionOrderBuilder userStatus( BusSolnOrdUserStatus... value )
        {
            return toUserStatus(Lists.newArrayList(value));
        }

    }

}
