/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.selectable.BusinessSolutionOrderTextSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusinessSolutionOrderText
 * BusinessSolutionOrderText} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class BusinessSolutionOrderTextByKeyFluentHelper
    extends
    FluentHelperByKey<BusinessSolutionOrderTextByKeyFluentHelper, BusinessSolutionOrderText, BusinessSolutionOrderTextSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusinessSolutionOrderText
     * BusinessSolutionOrderText} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code BusinessSolutionOrderText}
     * @param businessSolutionOrder
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param textObjectType
     *            Text ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code BusinessSolutionOrderText}
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     */
    public BusinessSolutionOrderTextByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String businessSolutionOrder,
        final String language,
        final String textObjectType )
    {
        super(servicePath, entityCollection);
        this.key.put("BusinessSolutionOrder", businessSolutionOrder);
        this.key.put("Language", language);
        this.key.put("TextObjectType", textObjectType);
    }

    @Override
    @Nonnull
    protected Class<BusinessSolutionOrderText> getEntityClass()
    {
        return BusinessSolutionOrderText.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
