/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdEntProjectItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItemRelationships;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmConfiguration;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmReferenceObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnParam;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrAgrmt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrParam;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmUserStatus;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcContractItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcPrtItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSubscrpnBillgItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdUserStatus;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderExpenseItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemObjectList;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemPriceElement;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemProductList;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderSalesItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderServiceItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolutionOrderItemText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusinessSolutionOrder;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusinessSolutionOrderText;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessSolutionOrderService
 * BusinessSolutionOrderService}.
 *
 */
public interface BusinessSolutionOrderServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<BusinessSolutionOrderServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<BusinessSolutionOrderServiceBatch>
{

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusinessSolutionOrder
     * BusinessSolutionOrder} entity and save it to the S/4HANA system.
     *
     * @param businessSolutionOrder
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusinessSolutionOrder
     *            BusinessSolutionOrder} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessSolutionOrderServiceBatchChangeSet
        createBusinessSolutionOrder( @Nonnull final BusinessSolutionOrder businessSolutionOrder );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusinessSolutionOrder
     * BusinessSolutionOrder} entity and save it to the S/4HANA system.
     *
     * @param businessSolutionOrder
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusinessSolutionOrder
     *            BusinessSolutionOrder} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessSolutionOrderServiceBatchChangeSet
        updateBusinessSolutionOrder( @Nonnull final BusinessSolutionOrder businessSolutionOrder );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusinessSolutionOrderText
     * BusinessSolutionOrderText} entity and save it to the S/4HANA system.
     *
     * @param businessSolutionOrderText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusinessSolutionOrderText
     *            BusinessSolutionOrderText} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessSolutionOrderServiceBatchChangeSet
        createBusinessSolutionOrderText( @Nonnull final BusinessSolutionOrderText businessSolutionOrderText );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusinessSolutionOrderText
     * BusinessSolutionOrderText} entity and save it to the S/4HANA system.
     *
     * @param businessSolutionOrderText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusinessSolutionOrderText
     *            BusinessSolutionOrderText} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessSolutionOrderServiceBatchChangeSet
        updateBusinessSolutionOrderText( @Nonnull final BusinessSolutionOrderText businessSolutionOrderText );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusinessSolutionOrderText
     * BusinessSolutionOrderText} entity in the S/4HANA system.
     *
     * @param businessSolutionOrderText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusinessSolutionOrderText
     *            BusinessSolutionOrderText} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessSolutionOrderServiceBatchChangeSet
        deleteBusinessSolutionOrderText( @Nonnull final BusinessSolutionOrderText businessSolutionOrderText );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdEntProjectItem
     * BusSolnOrdEntProjectItem} entity and save it to the S/4HANA system.
     *
     * @param busSolnOrdEntProjectItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdEntProjectItem
     *            BusSolnOrdEntProjectItem} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessSolutionOrderServiceBatchChangeSet
        createBusSolnOrdEntProjectItem( @Nonnull final BusSolnOrdEntProjectItem busSolnOrdEntProjectItem );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdEntProjectItem
     * BusSolnOrdEntProjectItem} entity and save it to the S/4HANA system.
     *
     * @param busSolnOrdEntProjectItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdEntProjectItem
     *            BusSolnOrdEntProjectItem} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessSolutionOrderServiceBatchChangeSet
        updateBusSolnOrdEntProjectItem( @Nonnull final BusSolnOrdEntProjectItem busSolnOrdEntProjectItem );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdEntProjectItem
     * BusSolnOrdEntProjectItem} entity in the S/4HANA system.
     *
     * @param busSolnOrdEntProjectItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdEntProjectItem
     *            BusSolnOrdEntProjectItem} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessSolutionOrderServiceBatchChangeSet
        deleteBusSolnOrdEntProjectItem( @Nonnull final BusSolnOrdEntProjectItem busSolnOrdEntProjectItem );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderExpenseItem
     * BusSolnOrderExpenseItem} entity and save it to the S/4HANA system.
     *
     * @param busSolnOrderExpenseItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderExpenseItem
     *            BusSolnOrderExpenseItem} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessSolutionOrderServiceBatchChangeSet
        createBusSolnOrderExpenseItem( @Nonnull final BusSolnOrderExpenseItem busSolnOrderExpenseItem );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderExpenseItem
     * BusSolnOrderExpenseItem} entity and save it to the S/4HANA system.
     *
     * @param busSolnOrderExpenseItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderExpenseItem
     *            BusSolnOrderExpenseItem} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessSolutionOrderServiceBatchChangeSet
        updateBusSolnOrderExpenseItem( @Nonnull final BusSolnOrderExpenseItem busSolnOrderExpenseItem );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderExpenseItem
     * BusSolnOrderExpenseItem} entity in the S/4HANA system.
     *
     * @param busSolnOrderExpenseItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderExpenseItem
     *            BusSolnOrderExpenseItem} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessSolutionOrderServiceBatchChangeSet
        deleteBusSolnOrderExpenseItem( @Nonnull final BusSolnOrderExpenseItem busSolnOrderExpenseItem );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemObjectList
     * BusSolnOrderItemObjectList} entity and save it to the S/4HANA system.
     *
     * @param busSolnOrderItemObjectList
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemObjectList
     *            BusSolnOrderItemObjectList} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessSolutionOrderServiceBatchChangeSet
        createBusSolnOrderItemObjectList( @Nonnull final BusSolnOrderItemObjectList busSolnOrderItemObjectList );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemObjectList
     * BusSolnOrderItemObjectList} entity in the S/4HANA system.
     *
     * @param busSolnOrderItemObjectList
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemObjectList
     *            BusSolnOrderItemObjectList} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessSolutionOrderServiceBatchChangeSet
        deleteBusSolnOrderItemObjectList( @Nonnull final BusSolnOrderItemObjectList busSolnOrderItemObjectList );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemPriceElement
     * BusSolnOrderItemPriceElement} entity and save it to the S/4HANA system.
     *
     * @param busSolnOrderItemPriceElement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemPriceElement
     *            BusSolnOrderItemPriceElement} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessSolutionOrderServiceBatchChangeSet
        createBusSolnOrderItemPriceElement( @Nonnull final BusSolnOrderItemPriceElement busSolnOrderItemPriceElement );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemPriceElement
     * BusSolnOrderItemPriceElement} entity and save it to the S/4HANA system.
     *
     * @param busSolnOrderItemPriceElement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemPriceElement
     *            BusSolnOrderItemPriceElement} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessSolutionOrderServiceBatchChangeSet
        updateBusSolnOrderItemPriceElement( @Nonnull final BusSolnOrderItemPriceElement busSolnOrderItemPriceElement );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemPriceElement
     * BusSolnOrderItemPriceElement} entity in the S/4HANA system.
     *
     * @param busSolnOrderItemPriceElement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemPriceElement
     *            BusSolnOrderItemPriceElement} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessSolutionOrderServiceBatchChangeSet
        deleteBusSolnOrderItemPriceElement( @Nonnull final BusSolnOrderItemPriceElement busSolnOrderItemPriceElement );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemProductList
     * BusSolnOrderItemProductList} entity and save it to the S/4HANA system.
     *
     * @param busSolnOrderItemProductList
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemProductList
     *            BusSolnOrderItemProductList} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessSolutionOrderServiceBatchChangeSet
        createBusSolnOrderItemProductList( @Nonnull final BusSolnOrderItemProductList busSolnOrderItemProductList );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemProductList
     * BusSolnOrderItemProductList} entity and save it to the S/4HANA system.
     *
     * @param busSolnOrderItemProductList
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemProductList
     *            BusSolnOrderItemProductList} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessSolutionOrderServiceBatchChangeSet
        updateBusSolnOrderItemProductList( @Nonnull final BusSolnOrderItemProductList busSolnOrderItemProductList );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemProductList
     * BusSolnOrderItemProductList} entity in the S/4HANA system.
     *
     * @param busSolnOrderItemProductList
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemProductList
     *            BusSolnOrderItemProductList} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessSolutionOrderServiceBatchChangeSet
        deleteBusSolnOrderItemProductList( @Nonnull final BusSolnOrderItemProductList busSolnOrderItemProductList );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderSalesItem
     * BusSolnOrderSalesItem} entity and save it to the S/4HANA system.
     *
     * @param busSolnOrderSalesItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderSalesItem
     *            BusSolnOrderSalesItem} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessSolutionOrderServiceBatchChangeSet
        createBusSolnOrderSalesItem( @Nonnull final BusSolnOrderSalesItem busSolnOrderSalesItem );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderSalesItem
     * BusSolnOrderSalesItem} entity and save it to the S/4HANA system.
     *
     * @param busSolnOrderSalesItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderSalesItem
     *            BusSolnOrderSalesItem} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessSolutionOrderServiceBatchChangeSet
        updateBusSolnOrderSalesItem( @Nonnull final BusSolnOrderSalesItem busSolnOrderSalesItem );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderSalesItem
     * BusSolnOrderSalesItem} entity in the S/4HANA system.
     *
     * @param busSolnOrderSalesItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderSalesItem
     *            BusSolnOrderSalesItem} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessSolutionOrderServiceBatchChangeSet
        deleteBusSolnOrderSalesItem( @Nonnull final BusSolnOrderSalesItem busSolnOrderSalesItem );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderServiceItem
     * BusSolnOrderServiceItem} entity and save it to the S/4HANA system.
     *
     * @param busSolnOrderServiceItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderServiceItem
     *            BusSolnOrderServiceItem} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessSolutionOrderServiceBatchChangeSet
        createBusSolnOrderServiceItem( @Nonnull final BusSolnOrderServiceItem busSolnOrderServiceItem );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderServiceItem
     * BusSolnOrderServiceItem} entity and save it to the S/4HANA system.
     *
     * @param busSolnOrderServiceItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderServiceItem
     *            BusSolnOrderServiceItem} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessSolutionOrderServiceBatchChangeSet
        updateBusSolnOrderServiceItem( @Nonnull final BusSolnOrderServiceItem busSolnOrderServiceItem );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderServiceItem
     * BusSolnOrderServiceItem} entity in the S/4HANA system.
     *
     * @param busSolnOrderServiceItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderServiceItem
     *            BusSolnOrderServiceItem} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessSolutionOrderServiceBatchChangeSet
        deleteBusSolnOrderServiceItem( @Nonnull final BusSolnOrderServiceItem busSolnOrderServiceItem );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItemRelationships
     * BusSolnOrdItemRelationships} entity and save it to the S/4HANA system.
     *
     * @param busSolnOrdItemRelationships
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItemRelationships
     *            BusSolnOrdItemRelationships} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessSolutionOrderServiceBatchChangeSet
        createBusSolnOrdItemRelationships( @Nonnull final BusSolnOrdItemRelationships busSolnOrdItemRelationships );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItemRelationships
     * BusSolnOrdItemRelationships} entity in the S/4HANA system.
     *
     * @param busSolnOrdItemRelationships
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItemRelationships
     *            BusSolnOrdItemRelationships} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessSolutionOrderServiceBatchChangeSet
        deleteBusSolnOrdItemRelationships( @Nonnull final BusSolnOrdItemRelationships busSolnOrdItemRelationships );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmConfiguration
     * BusSolnOrdItmConfiguration} entity and save it to the S/4HANA system.
     *
     * @param busSolnOrdItmConfiguration
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmConfiguration
     *            BusSolnOrdItmConfiguration} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessSolutionOrderServiceBatchChangeSet
        createBusSolnOrdItmConfiguration( @Nonnull final BusSolnOrdItmConfiguration busSolnOrdItmConfiguration );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmReferenceObject
     * BusSolnOrdItmReferenceObject} entity and save it to the S/4HANA system.
     *
     * @param busSolnOrdItmReferenceObject
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmReferenceObject
     *            BusSolnOrdItmReferenceObject} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessSolutionOrderServiceBatchChangeSet
        createBusSolnOrdItmReferenceObject( @Nonnull final BusSolnOrdItmReferenceObject busSolnOrdItmReferenceObject );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmReferenceObject
     * BusSolnOrdItmReferenceObject} entity and save it to the S/4HANA system.
     *
     * @param busSolnOrdItmReferenceObject
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmReferenceObject
     *            BusSolnOrdItmReferenceObject} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessSolutionOrderServiceBatchChangeSet
        updateBusSolnOrdItmReferenceObject( @Nonnull final BusSolnOrdItmReferenceObject busSolnOrdItmReferenceObject );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmReferenceObject
     * BusSolnOrdItmReferenceObject} entity in the S/4HANA system.
     *
     * @param busSolnOrdItmReferenceObject
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmReferenceObject
     *            BusSolnOrdItmReferenceObject} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessSolutionOrderServiceBatchChangeSet
        deleteBusSolnOrdItmReferenceObject( @Nonnull final BusSolnOrdItmReferenceObject busSolnOrdItmReferenceObject );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnParam
     * BusSolnOrdItmSubscrpnParam} entity and save it to the S/4HANA system.
     *
     * @param busSolnOrdItmSubscrpnParam
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnParam
     *            BusSolnOrdItmSubscrpnParam} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessSolutionOrderServiceBatchChangeSet
        createBusSolnOrdItmSubscrpnParam( @Nonnull final BusSolnOrdItmSubscrpnParam busSolnOrdItmSubscrpnParam );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnParam
     * BusSolnOrdItmSubscrpnParam} entity and save it to the S/4HANA system.
     *
     * @param busSolnOrdItmSubscrpnParam
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnParam
     *            BusSolnOrdItmSubscrpnParam} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessSolutionOrderServiceBatchChangeSet
        updateBusSolnOrdItmSubscrpnParam( @Nonnull final BusSolnOrdItmSubscrpnParam busSolnOrdItmSubscrpnParam );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnParam
     * BusSolnOrdItmSubscrpnParam} entity in the S/4HANA system.
     *
     * @param busSolnOrdItmSubscrpnParam
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnParam
     *            BusSolnOrdItmSubscrpnParam} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessSolutionOrderServiceBatchChangeSet
        deleteBusSolnOrdItmSubscrpnParam( @Nonnull final BusSolnOrdItmSubscrpnParam busSolnOrdItmSubscrpnParam );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrAgrmt
     * BusSolnOrdItmSubscrpnPrAgrmt} entity and save it to the S/4HANA system.
     *
     * @param busSolnOrdItmSubscrpnPrAgrmt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrAgrmt
     *            BusSolnOrdItmSubscrpnPrAgrmt} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessSolutionOrderServiceBatchChangeSet
        createBusSolnOrdItmSubscrpnPrAgrmt( @Nonnull final BusSolnOrdItmSubscrpnPrAgrmt busSolnOrdItmSubscrpnPrAgrmt );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrAgrmt
     * BusSolnOrdItmSubscrpnPrAgrmt} entity and save it to the S/4HANA system.
     *
     * @param busSolnOrdItmSubscrpnPrAgrmt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrAgrmt
     *            BusSolnOrdItmSubscrpnPrAgrmt} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessSolutionOrderServiceBatchChangeSet
        updateBusSolnOrdItmSubscrpnPrAgrmt( @Nonnull final BusSolnOrdItmSubscrpnPrAgrmt busSolnOrdItmSubscrpnPrAgrmt );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrAgrmt
     * BusSolnOrdItmSubscrpnPrAgrmt} entity in the S/4HANA system.
     *
     * @param busSolnOrdItmSubscrpnPrAgrmt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrAgrmt
     *            BusSolnOrdItmSubscrpnPrAgrmt} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessSolutionOrderServiceBatchChangeSet
        deleteBusSolnOrdItmSubscrpnPrAgrmt( @Nonnull final BusSolnOrdItmSubscrpnPrAgrmt busSolnOrdItmSubscrpnPrAgrmt );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrParam
     * BusSolnOrdItmSubscrpnPrParam} entity and save it to the S/4HANA system.
     *
     * @param busSolnOrdItmSubscrpnPrParam
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrParam
     *            BusSolnOrdItmSubscrpnPrParam} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessSolutionOrderServiceBatchChangeSet
        createBusSolnOrdItmSubscrpnPrParam( @Nonnull final BusSolnOrdItmSubscrpnPrParam busSolnOrdItmSubscrpnPrParam );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrParam
     * BusSolnOrdItmSubscrpnPrParam} entity and save it to the S/4HANA system.
     *
     * @param busSolnOrdItmSubscrpnPrParam
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrParam
     *            BusSolnOrdItmSubscrpnPrParam} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessSolutionOrderServiceBatchChangeSet
        updateBusSolnOrdItmSubscrpnPrParam( @Nonnull final BusSolnOrdItmSubscrpnPrParam busSolnOrdItmSubscrpnPrParam );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrParam
     * BusSolnOrdItmSubscrpnPrParam} entity in the S/4HANA system.
     *
     * @param busSolnOrdItmSubscrpnPrParam
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrParam
     *            BusSolnOrdItmSubscrpnPrParam} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessSolutionOrderServiceBatchChangeSet
        deleteBusSolnOrdItmSubscrpnPrParam( @Nonnull final BusSolnOrdItmSubscrpnPrParam busSolnOrdItmSubscrpnPrParam );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmUserStatus
     * BusSolnOrdItmUserStatus} entity and save it to the S/4HANA system.
     *
     * @param busSolnOrdItmUserStatus
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmUserStatus
     *            BusSolnOrdItmUserStatus} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessSolutionOrderServiceBatchChangeSet
        createBusSolnOrdItmUserStatus( @Nonnull final BusSolnOrdItmUserStatus busSolnOrdItmUserStatus );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmUserStatus
     * BusSolnOrdItmUserStatus} entity and save it to the S/4HANA system.
     *
     * @param busSolnOrdItmUserStatus
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmUserStatus
     *            BusSolnOrdItmUserStatus} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessSolutionOrderServiceBatchChangeSet
        updateBusSolnOrdItmUserStatus( @Nonnull final BusSolnOrdItmUserStatus busSolnOrdItmUserStatus );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmUserStatus
     * BusSolnOrdItmUserStatus} entity in the S/4HANA system.
     *
     * @param busSolnOrdItmUserStatus
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmUserStatus
     *            BusSolnOrdItmUserStatus} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessSolutionOrderServiceBatchChangeSet
        deleteBusSolnOrdItmUserStatus( @Nonnull final BusSolnOrdItmUserStatus busSolnOrdItmUserStatus );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcContractItem
     * BusSolnOrdSrvcContractItem} entity and save it to the S/4HANA system.
     *
     * @param busSolnOrdSrvcContractItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcContractItem
     *            BusSolnOrdSrvcContractItem} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessSolutionOrderServiceBatchChangeSet
        createBusSolnOrdSrvcContractItem( @Nonnull final BusSolnOrdSrvcContractItem busSolnOrdSrvcContractItem );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcContractItem
     * BusSolnOrdSrvcContractItem} entity and save it to the S/4HANA system.
     *
     * @param busSolnOrdSrvcContractItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcContractItem
     *            BusSolnOrdSrvcContractItem} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessSolutionOrderServiceBatchChangeSet
        updateBusSolnOrdSrvcContractItem( @Nonnull final BusSolnOrdSrvcContractItem busSolnOrdSrvcContractItem );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcContractItem
     * BusSolnOrdSrvcContractItem} entity in the S/4HANA system.
     *
     * @param busSolnOrdSrvcContractItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcContractItem
     *            BusSolnOrdSrvcContractItem} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessSolutionOrderServiceBatchChangeSet
        deleteBusSolnOrdSrvcContractItem( @Nonnull final BusSolnOrdSrvcContractItem busSolnOrdSrvcContractItem );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcPrtItem
     * BusSolnOrdSrvcPrtItem} entity and save it to the S/4HANA system.
     *
     * @param busSolnOrdSrvcPrtItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcPrtItem
     *            BusSolnOrdSrvcPrtItem} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessSolutionOrderServiceBatchChangeSet
        createBusSolnOrdSrvcPrtItem( @Nonnull final BusSolnOrdSrvcPrtItem busSolnOrdSrvcPrtItem );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcPrtItem
     * BusSolnOrdSrvcPrtItem} entity and save it to the S/4HANA system.
     *
     * @param busSolnOrdSrvcPrtItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcPrtItem
     *            BusSolnOrdSrvcPrtItem} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessSolutionOrderServiceBatchChangeSet
        updateBusSolnOrdSrvcPrtItem( @Nonnull final BusSolnOrdSrvcPrtItem busSolnOrdSrvcPrtItem );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcPrtItem
     * BusSolnOrdSrvcPrtItem} entity in the S/4HANA system.
     *
     * @param busSolnOrdSrvcPrtItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcPrtItem
     *            BusSolnOrdSrvcPrtItem} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessSolutionOrderServiceBatchChangeSet
        deleteBusSolnOrdSrvcPrtItem( @Nonnull final BusSolnOrdSrvcPrtItem busSolnOrdSrvcPrtItem );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSubscrpnBillgItem
     * BusSolnOrdSubscrpnBillgItem} entity and save it to the S/4HANA system.
     *
     * @param busSolnOrdSubscrpnBillgItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSubscrpnBillgItem
     *            BusSolnOrdSubscrpnBillgItem} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessSolutionOrderServiceBatchChangeSet
        createBusSolnOrdSubscrpnBillgItem( @Nonnull final BusSolnOrdSubscrpnBillgItem busSolnOrdSubscrpnBillgItem );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSubscrpnBillgItem
     * BusSolnOrdSubscrpnBillgItem} entity and save it to the S/4HANA system.
     *
     * @param busSolnOrdSubscrpnBillgItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSubscrpnBillgItem
     *            BusSolnOrdSubscrpnBillgItem} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessSolutionOrderServiceBatchChangeSet
        updateBusSolnOrdSubscrpnBillgItem( @Nonnull final BusSolnOrdSubscrpnBillgItem busSolnOrdSubscrpnBillgItem );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSubscrpnBillgItem
     * BusSolnOrdSubscrpnBillgItem} entity in the S/4HANA system.
     *
     * @param busSolnOrdSubscrpnBillgItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSubscrpnBillgItem
     *            BusSolnOrdSubscrpnBillgItem} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessSolutionOrderServiceBatchChangeSet
        deleteBusSolnOrdSubscrpnBillgItem( @Nonnull final BusSolnOrdSubscrpnBillgItem busSolnOrdSubscrpnBillgItem );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdUserStatus
     * BusSolnOrdUserStatus} entity and save it to the S/4HANA system.
     *
     * @param busSolnOrdUserStatus
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdUserStatus
     *            BusSolnOrdUserStatus} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessSolutionOrderServiceBatchChangeSet
        createBusSolnOrdUserStatus( @Nonnull final BusSolnOrdUserStatus busSolnOrdUserStatus );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdUserStatus
     * BusSolnOrdUserStatus} entity and save it to the S/4HANA system.
     *
     * @param busSolnOrdUserStatus
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdUserStatus
     *            BusSolnOrdUserStatus} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessSolutionOrderServiceBatchChangeSet
        updateBusSolnOrdUserStatus( @Nonnull final BusSolnOrdUserStatus busSolnOrdUserStatus );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdUserStatus
     * BusSolnOrdUserStatus} entity in the S/4HANA system.
     *
     * @param busSolnOrdUserStatus
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdUserStatus
     *            BusSolnOrdUserStatus} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessSolutionOrderServiceBatchChangeSet
        deleteBusSolnOrdUserStatus( @Nonnull final BusSolnOrdUserStatus busSolnOrdUserStatus );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolutionOrderItemText
     * BusSolutionOrderItemText} entity and save it to the S/4HANA system.
     *
     * @param busSolutionOrderItemText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolutionOrderItemText
     *            BusSolutionOrderItemText} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessSolutionOrderServiceBatchChangeSet
        createBusSolutionOrderItemText( @Nonnull final BusSolutionOrderItemText busSolutionOrderItemText );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolutionOrderItemText
     * BusSolutionOrderItemText} entity and save it to the S/4HANA system.
     *
     * @param busSolutionOrderItemText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolutionOrderItemText
     *            BusSolutionOrderItemText} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessSolutionOrderServiceBatchChangeSet
        updateBusSolutionOrderItemText( @Nonnull final BusSolutionOrderItemText busSolutionOrderItemText );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolutionOrderItemText
     * BusSolutionOrderItemText} entity in the S/4HANA system.
     *
     * @param busSolutionOrderItemText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolutionOrderItemText
     *            BusSolutionOrderItemText} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    BusinessSolutionOrderServiceBatchChangeSet
        deleteBusSolutionOrderItemText( @Nonnull final BusSolutionOrderItemText busSolutionOrderItemText );

}
