/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link BusinessSolutionOrderServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessSolutionOrderService BusinessSolutionOrderService},
 * allowing you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultBusinessSolutionOrderServiceBatch
    extends
    BatchFluentHelperBasic<BusinessSolutionOrderServiceBatch, BusinessSolutionOrderServiceBatchChangeSet>
    implements
    BusinessSolutionOrderServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessSolutionOrderService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultBusinessSolutionOrderServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultBusinessSolutionOrderServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessSolutionOrderService service )
    {
        this(
            service,
            com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessSolutionOrderService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultBusinessSolutionOrderServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultBusinessSolutionOrderServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessSolutionOrderService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultBusinessSolutionOrderServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public BusinessSolutionOrderServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultBusinessSolutionOrderServiceBatchChangeSet(this, service);
    }

}
