/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdEntProjectItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItemRelationships;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmConfiguration;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmReferenceObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnParam;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrAgrmt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrParam;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmUserStatus;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcContractItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcPrtItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSubscrpnBillgItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdUserStatus;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderExpenseItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemObjectList;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemPriceElement;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderItemProductList;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderSalesItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrderServiceItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolutionOrderItemText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusinessSolutionOrder;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusinessSolutionOrderText;

/**
 * Implementation of the {@link BusinessSolutionOrderServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessSolutionOrderService BusinessSolutionOrderService}.
 *
 */
public class DefaultBusinessSolutionOrderServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<BusinessSolutionOrderServiceBatch, BusinessSolutionOrderServiceBatchChangeSet>
    implements
    BusinessSolutionOrderServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessSolutionOrderService service;

    @SuppressWarnings( "deprecation" )
    DefaultBusinessSolutionOrderServiceBatchChangeSet(
        @Nonnull final DefaultBusinessSolutionOrderServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessSolutionOrderService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultBusinessSolutionOrderServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public BusinessSolutionOrderServiceBatchChangeSet createBusinessSolutionOrder(
        @Nonnull final BusinessSolutionOrder businessSolutionOrder )
    {
        return addRequestCreate(service::createBusinessSolutionOrder, businessSolutionOrder);
    }

    @Nonnull
    @Override
    public BusinessSolutionOrderServiceBatchChangeSet updateBusinessSolutionOrder(
        @Nonnull final BusinessSolutionOrder businessSolutionOrder )
    {
        return addRequestUpdate(service::updateBusinessSolutionOrder, businessSolutionOrder);
    }

    @Nonnull
    @Override
    public BusinessSolutionOrderServiceBatchChangeSet createBusinessSolutionOrderText(
        @Nonnull final BusinessSolutionOrderText businessSolutionOrderText )
    {
        return addRequestCreate(service::createBusinessSolutionOrderText, businessSolutionOrderText);
    }

    @Nonnull
    @Override
    public BusinessSolutionOrderServiceBatchChangeSet updateBusinessSolutionOrderText(
        @Nonnull final BusinessSolutionOrderText businessSolutionOrderText )
    {
        return addRequestUpdate(service::updateBusinessSolutionOrderText, businessSolutionOrderText);
    }

    @Nonnull
    @Override
    public BusinessSolutionOrderServiceBatchChangeSet deleteBusinessSolutionOrderText(
        @Nonnull final BusinessSolutionOrderText businessSolutionOrderText )
    {
        return addRequestDelete(service::deleteBusinessSolutionOrderText, businessSolutionOrderText);
    }

    @Nonnull
    @Override
    public BusinessSolutionOrderServiceBatchChangeSet createBusSolnOrdEntProjectItem(
        @Nonnull final BusSolnOrdEntProjectItem busSolnOrdEntProjectItem )
    {
        return addRequestCreate(service::createBusSolnOrdEntProjectItem, busSolnOrdEntProjectItem);
    }

    @Nonnull
    @Override
    public BusinessSolutionOrderServiceBatchChangeSet updateBusSolnOrdEntProjectItem(
        @Nonnull final BusSolnOrdEntProjectItem busSolnOrdEntProjectItem )
    {
        return addRequestUpdate(service::updateBusSolnOrdEntProjectItem, busSolnOrdEntProjectItem);
    }

    @Nonnull
    @Override
    public BusinessSolutionOrderServiceBatchChangeSet deleteBusSolnOrdEntProjectItem(
        @Nonnull final BusSolnOrdEntProjectItem busSolnOrdEntProjectItem )
    {
        return addRequestDelete(service::deleteBusSolnOrdEntProjectItem, busSolnOrdEntProjectItem);
    }

    @Nonnull
    @Override
    public BusinessSolutionOrderServiceBatchChangeSet createBusSolnOrderExpenseItem(
        @Nonnull final BusSolnOrderExpenseItem busSolnOrderExpenseItem )
    {
        return addRequestCreate(service::createBusSolnOrderExpenseItem, busSolnOrderExpenseItem);
    }

    @Nonnull
    @Override
    public BusinessSolutionOrderServiceBatchChangeSet updateBusSolnOrderExpenseItem(
        @Nonnull final BusSolnOrderExpenseItem busSolnOrderExpenseItem )
    {
        return addRequestUpdate(service::updateBusSolnOrderExpenseItem, busSolnOrderExpenseItem);
    }

    @Nonnull
    @Override
    public BusinessSolutionOrderServiceBatchChangeSet deleteBusSolnOrderExpenseItem(
        @Nonnull final BusSolnOrderExpenseItem busSolnOrderExpenseItem )
    {
        return addRequestDelete(service::deleteBusSolnOrderExpenseItem, busSolnOrderExpenseItem);
    }

    @Nonnull
    @Override
    public BusinessSolutionOrderServiceBatchChangeSet createBusSolnOrderItemObjectList(
        @Nonnull final BusSolnOrderItemObjectList busSolnOrderItemObjectList )
    {
        return addRequestCreate(service::createBusSolnOrderItemObjectList, busSolnOrderItemObjectList);
    }

    @Nonnull
    @Override
    public BusinessSolutionOrderServiceBatchChangeSet deleteBusSolnOrderItemObjectList(
        @Nonnull final BusSolnOrderItemObjectList busSolnOrderItemObjectList )
    {
        return addRequestDelete(service::deleteBusSolnOrderItemObjectList, busSolnOrderItemObjectList);
    }

    @Nonnull
    @Override
    public BusinessSolutionOrderServiceBatchChangeSet createBusSolnOrderItemPriceElement(
        @Nonnull final BusSolnOrderItemPriceElement busSolnOrderItemPriceElement )
    {
        return addRequestCreate(service::createBusSolnOrderItemPriceElement, busSolnOrderItemPriceElement);
    }

    @Nonnull
    @Override
    public BusinessSolutionOrderServiceBatchChangeSet updateBusSolnOrderItemPriceElement(
        @Nonnull final BusSolnOrderItemPriceElement busSolnOrderItemPriceElement )
    {
        return addRequestUpdate(service::updateBusSolnOrderItemPriceElement, busSolnOrderItemPriceElement);
    }

    @Nonnull
    @Override
    public BusinessSolutionOrderServiceBatchChangeSet deleteBusSolnOrderItemPriceElement(
        @Nonnull final BusSolnOrderItemPriceElement busSolnOrderItemPriceElement )
    {
        return addRequestDelete(service::deleteBusSolnOrderItemPriceElement, busSolnOrderItemPriceElement);
    }

    @Nonnull
    @Override
    public BusinessSolutionOrderServiceBatchChangeSet createBusSolnOrderItemProductList(
        @Nonnull final BusSolnOrderItemProductList busSolnOrderItemProductList )
    {
        return addRequestCreate(service::createBusSolnOrderItemProductList, busSolnOrderItemProductList);
    }

    @Nonnull
    @Override
    public BusinessSolutionOrderServiceBatchChangeSet updateBusSolnOrderItemProductList(
        @Nonnull final BusSolnOrderItemProductList busSolnOrderItemProductList )
    {
        return addRequestUpdate(service::updateBusSolnOrderItemProductList, busSolnOrderItemProductList);
    }

    @Nonnull
    @Override
    public BusinessSolutionOrderServiceBatchChangeSet deleteBusSolnOrderItemProductList(
        @Nonnull final BusSolnOrderItemProductList busSolnOrderItemProductList )
    {
        return addRequestDelete(service::deleteBusSolnOrderItemProductList, busSolnOrderItemProductList);
    }

    @Nonnull
    @Override
    public BusinessSolutionOrderServiceBatchChangeSet createBusSolnOrderSalesItem(
        @Nonnull final BusSolnOrderSalesItem busSolnOrderSalesItem )
    {
        return addRequestCreate(service::createBusSolnOrderSalesItem, busSolnOrderSalesItem);
    }

    @Nonnull
    @Override
    public BusinessSolutionOrderServiceBatchChangeSet updateBusSolnOrderSalesItem(
        @Nonnull final BusSolnOrderSalesItem busSolnOrderSalesItem )
    {
        return addRequestUpdate(service::updateBusSolnOrderSalesItem, busSolnOrderSalesItem);
    }

    @Nonnull
    @Override
    public BusinessSolutionOrderServiceBatchChangeSet deleteBusSolnOrderSalesItem(
        @Nonnull final BusSolnOrderSalesItem busSolnOrderSalesItem )
    {
        return addRequestDelete(service::deleteBusSolnOrderSalesItem, busSolnOrderSalesItem);
    }

    @Nonnull
    @Override
    public BusinessSolutionOrderServiceBatchChangeSet createBusSolnOrderServiceItem(
        @Nonnull final BusSolnOrderServiceItem busSolnOrderServiceItem )
    {
        return addRequestCreate(service::createBusSolnOrderServiceItem, busSolnOrderServiceItem);
    }

    @Nonnull
    @Override
    public BusinessSolutionOrderServiceBatchChangeSet updateBusSolnOrderServiceItem(
        @Nonnull final BusSolnOrderServiceItem busSolnOrderServiceItem )
    {
        return addRequestUpdate(service::updateBusSolnOrderServiceItem, busSolnOrderServiceItem);
    }

    @Nonnull
    @Override
    public BusinessSolutionOrderServiceBatchChangeSet deleteBusSolnOrderServiceItem(
        @Nonnull final BusSolnOrderServiceItem busSolnOrderServiceItem )
    {
        return addRequestDelete(service::deleteBusSolnOrderServiceItem, busSolnOrderServiceItem);
    }

    @Nonnull
    @Override
    public BusinessSolutionOrderServiceBatchChangeSet createBusSolnOrdItemRelationships(
        @Nonnull final BusSolnOrdItemRelationships busSolnOrdItemRelationships )
    {
        return addRequestCreate(service::createBusSolnOrdItemRelationships, busSolnOrdItemRelationships);
    }

    @Nonnull
    @Override
    public BusinessSolutionOrderServiceBatchChangeSet deleteBusSolnOrdItemRelationships(
        @Nonnull final BusSolnOrdItemRelationships busSolnOrdItemRelationships )
    {
        return addRequestDelete(service::deleteBusSolnOrdItemRelationships, busSolnOrdItemRelationships);
    }

    @Nonnull
    @Override
    public BusinessSolutionOrderServiceBatchChangeSet createBusSolnOrdItmConfiguration(
        @Nonnull final BusSolnOrdItmConfiguration busSolnOrdItmConfiguration )
    {
        return addRequestCreate(service::createBusSolnOrdItmConfiguration, busSolnOrdItmConfiguration);
    }

    @Nonnull
    @Override
    public BusinessSolutionOrderServiceBatchChangeSet createBusSolnOrdItmReferenceObject(
        @Nonnull final BusSolnOrdItmReferenceObject busSolnOrdItmReferenceObject )
    {
        return addRequestCreate(service::createBusSolnOrdItmReferenceObject, busSolnOrdItmReferenceObject);
    }

    @Nonnull
    @Override
    public BusinessSolutionOrderServiceBatchChangeSet updateBusSolnOrdItmReferenceObject(
        @Nonnull final BusSolnOrdItmReferenceObject busSolnOrdItmReferenceObject )
    {
        return addRequestUpdate(service::updateBusSolnOrdItmReferenceObject, busSolnOrdItmReferenceObject);
    }

    @Nonnull
    @Override
    public BusinessSolutionOrderServiceBatchChangeSet deleteBusSolnOrdItmReferenceObject(
        @Nonnull final BusSolnOrdItmReferenceObject busSolnOrdItmReferenceObject )
    {
        return addRequestDelete(service::deleteBusSolnOrdItmReferenceObject, busSolnOrdItmReferenceObject);
    }

    @Nonnull
    @Override
    public BusinessSolutionOrderServiceBatchChangeSet createBusSolnOrdItmSubscrpnParam(
        @Nonnull final BusSolnOrdItmSubscrpnParam busSolnOrdItmSubscrpnParam )
    {
        return addRequestCreate(service::createBusSolnOrdItmSubscrpnParam, busSolnOrdItmSubscrpnParam);
    }

    @Nonnull
    @Override
    public BusinessSolutionOrderServiceBatchChangeSet updateBusSolnOrdItmSubscrpnParam(
        @Nonnull final BusSolnOrdItmSubscrpnParam busSolnOrdItmSubscrpnParam )
    {
        return addRequestUpdate(service::updateBusSolnOrdItmSubscrpnParam, busSolnOrdItmSubscrpnParam);
    }

    @Nonnull
    @Override
    public BusinessSolutionOrderServiceBatchChangeSet deleteBusSolnOrdItmSubscrpnParam(
        @Nonnull final BusSolnOrdItmSubscrpnParam busSolnOrdItmSubscrpnParam )
    {
        return addRequestDelete(service::deleteBusSolnOrdItmSubscrpnParam, busSolnOrdItmSubscrpnParam);
    }

    @Nonnull
    @Override
    public BusinessSolutionOrderServiceBatchChangeSet createBusSolnOrdItmSubscrpnPrAgrmt(
        @Nonnull final BusSolnOrdItmSubscrpnPrAgrmt busSolnOrdItmSubscrpnPrAgrmt )
    {
        return addRequestCreate(service::createBusSolnOrdItmSubscrpnPrAgrmt, busSolnOrdItmSubscrpnPrAgrmt);
    }

    @Nonnull
    @Override
    public BusinessSolutionOrderServiceBatchChangeSet updateBusSolnOrdItmSubscrpnPrAgrmt(
        @Nonnull final BusSolnOrdItmSubscrpnPrAgrmt busSolnOrdItmSubscrpnPrAgrmt )
    {
        return addRequestUpdate(service::updateBusSolnOrdItmSubscrpnPrAgrmt, busSolnOrdItmSubscrpnPrAgrmt);
    }

    @Nonnull
    @Override
    public BusinessSolutionOrderServiceBatchChangeSet deleteBusSolnOrdItmSubscrpnPrAgrmt(
        @Nonnull final BusSolnOrdItmSubscrpnPrAgrmt busSolnOrdItmSubscrpnPrAgrmt )
    {
        return addRequestDelete(service::deleteBusSolnOrdItmSubscrpnPrAgrmt, busSolnOrdItmSubscrpnPrAgrmt);
    }

    @Nonnull
    @Override
    public BusinessSolutionOrderServiceBatchChangeSet createBusSolnOrdItmSubscrpnPrParam(
        @Nonnull final BusSolnOrdItmSubscrpnPrParam busSolnOrdItmSubscrpnPrParam )
    {
        return addRequestCreate(service::createBusSolnOrdItmSubscrpnPrParam, busSolnOrdItmSubscrpnPrParam);
    }

    @Nonnull
    @Override
    public BusinessSolutionOrderServiceBatchChangeSet updateBusSolnOrdItmSubscrpnPrParam(
        @Nonnull final BusSolnOrdItmSubscrpnPrParam busSolnOrdItmSubscrpnPrParam )
    {
        return addRequestUpdate(service::updateBusSolnOrdItmSubscrpnPrParam, busSolnOrdItmSubscrpnPrParam);
    }

    @Nonnull
    @Override
    public BusinessSolutionOrderServiceBatchChangeSet deleteBusSolnOrdItmSubscrpnPrParam(
        @Nonnull final BusSolnOrdItmSubscrpnPrParam busSolnOrdItmSubscrpnPrParam )
    {
        return addRequestDelete(service::deleteBusSolnOrdItmSubscrpnPrParam, busSolnOrdItmSubscrpnPrParam);
    }

    @Nonnull
    @Override
    public BusinessSolutionOrderServiceBatchChangeSet createBusSolnOrdItmUserStatus(
        @Nonnull final BusSolnOrdItmUserStatus busSolnOrdItmUserStatus )
    {
        return addRequestCreate(service::createBusSolnOrdItmUserStatus, busSolnOrdItmUserStatus);
    }

    @Nonnull
    @Override
    public BusinessSolutionOrderServiceBatchChangeSet updateBusSolnOrdItmUserStatus(
        @Nonnull final BusSolnOrdItmUserStatus busSolnOrdItmUserStatus )
    {
        return addRequestUpdate(service::updateBusSolnOrdItmUserStatus, busSolnOrdItmUserStatus);
    }

    @Nonnull
    @Override
    public BusinessSolutionOrderServiceBatchChangeSet deleteBusSolnOrdItmUserStatus(
        @Nonnull final BusSolnOrdItmUserStatus busSolnOrdItmUserStatus )
    {
        return addRequestDelete(service::deleteBusSolnOrdItmUserStatus, busSolnOrdItmUserStatus);
    }

    @Nonnull
    @Override
    public BusinessSolutionOrderServiceBatchChangeSet createBusSolnOrdSrvcContractItem(
        @Nonnull final BusSolnOrdSrvcContractItem busSolnOrdSrvcContractItem )
    {
        return addRequestCreate(service::createBusSolnOrdSrvcContractItem, busSolnOrdSrvcContractItem);
    }

    @Nonnull
    @Override
    public BusinessSolutionOrderServiceBatchChangeSet updateBusSolnOrdSrvcContractItem(
        @Nonnull final BusSolnOrdSrvcContractItem busSolnOrdSrvcContractItem )
    {
        return addRequestUpdate(service::updateBusSolnOrdSrvcContractItem, busSolnOrdSrvcContractItem);
    }

    @Nonnull
    @Override
    public BusinessSolutionOrderServiceBatchChangeSet deleteBusSolnOrdSrvcContractItem(
        @Nonnull final BusSolnOrdSrvcContractItem busSolnOrdSrvcContractItem )
    {
        return addRequestDelete(service::deleteBusSolnOrdSrvcContractItem, busSolnOrdSrvcContractItem);
    }

    @Nonnull
    @Override
    public BusinessSolutionOrderServiceBatchChangeSet createBusSolnOrdSrvcPrtItem(
        @Nonnull final BusSolnOrdSrvcPrtItem busSolnOrdSrvcPrtItem )
    {
        return addRequestCreate(service::createBusSolnOrdSrvcPrtItem, busSolnOrdSrvcPrtItem);
    }

    @Nonnull
    @Override
    public BusinessSolutionOrderServiceBatchChangeSet updateBusSolnOrdSrvcPrtItem(
        @Nonnull final BusSolnOrdSrvcPrtItem busSolnOrdSrvcPrtItem )
    {
        return addRequestUpdate(service::updateBusSolnOrdSrvcPrtItem, busSolnOrdSrvcPrtItem);
    }

    @Nonnull
    @Override
    public BusinessSolutionOrderServiceBatchChangeSet deleteBusSolnOrdSrvcPrtItem(
        @Nonnull final BusSolnOrdSrvcPrtItem busSolnOrdSrvcPrtItem )
    {
        return addRequestDelete(service::deleteBusSolnOrdSrvcPrtItem, busSolnOrdSrvcPrtItem);
    }

    @Nonnull
    @Override
    public BusinessSolutionOrderServiceBatchChangeSet createBusSolnOrdSubscrpnBillgItem(
        @Nonnull final BusSolnOrdSubscrpnBillgItem busSolnOrdSubscrpnBillgItem )
    {
        return addRequestCreate(service::createBusSolnOrdSubscrpnBillgItem, busSolnOrdSubscrpnBillgItem);
    }

    @Nonnull
    @Override
    public BusinessSolutionOrderServiceBatchChangeSet updateBusSolnOrdSubscrpnBillgItem(
        @Nonnull final BusSolnOrdSubscrpnBillgItem busSolnOrdSubscrpnBillgItem )
    {
        return addRequestUpdate(service::updateBusSolnOrdSubscrpnBillgItem, busSolnOrdSubscrpnBillgItem);
    }

    @Nonnull
    @Override
    public BusinessSolutionOrderServiceBatchChangeSet deleteBusSolnOrdSubscrpnBillgItem(
        @Nonnull final BusSolnOrdSubscrpnBillgItem busSolnOrdSubscrpnBillgItem )
    {
        return addRequestDelete(service::deleteBusSolnOrdSubscrpnBillgItem, busSolnOrdSubscrpnBillgItem);
    }

    @Nonnull
    @Override
    public BusinessSolutionOrderServiceBatchChangeSet createBusSolnOrdUserStatus(
        @Nonnull final BusSolnOrdUserStatus busSolnOrdUserStatus )
    {
        return addRequestCreate(service::createBusSolnOrdUserStatus, busSolnOrdUserStatus);
    }

    @Nonnull
    @Override
    public BusinessSolutionOrderServiceBatchChangeSet updateBusSolnOrdUserStatus(
        @Nonnull final BusSolnOrdUserStatus busSolnOrdUserStatus )
    {
        return addRequestUpdate(service::updateBusSolnOrdUserStatus, busSolnOrdUserStatus);
    }

    @Nonnull
    @Override
    public BusinessSolutionOrderServiceBatchChangeSet deleteBusSolnOrdUserStatus(
        @Nonnull final BusSolnOrdUserStatus busSolnOrdUserStatus )
    {
        return addRequestDelete(service::deleteBusSolnOrdUserStatus, busSolnOrdUserStatus);
    }

    @Nonnull
    @Override
    public BusinessSolutionOrderServiceBatchChangeSet createBusSolutionOrderItemText(
        @Nonnull final BusSolutionOrderItemText busSolutionOrderItemText )
    {
        return addRequestCreate(service::createBusSolutionOrderItemText, busSolutionOrderItemText);
    }

    @Nonnull
    @Override
    public BusinessSolutionOrderServiceBatchChangeSet updateBusSolutionOrderItemText(
        @Nonnull final BusSolutionOrderItemText busSolutionOrderItemText )
    {
        return addRequestUpdate(service::updateBusSolutionOrderItemText, busSolutionOrderItemText);
    }

    @Nonnull
    @Override
    public BusinessSolutionOrderServiceBatchChangeSet deleteBusSolutionOrderItemText(
        @Nonnull final BusSolutionOrderItemText busSolutionOrderItemText )
    {
        return addRequestDelete(service::deleteBusSolutionOrderItemText, busSolutionOrderItemText);
    }

}
