/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.link;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.EntityLink;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdFUPEntProject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.selectable.BusSolnOrdFUPEntProjectSelectable;

/**
 * Template class to represent entity navigation links of
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdFUPEntProject
 * BusSolnOrdFUPEntProject} to other entities. Instances of this object are used in query modifier methods of the entity
 * fluent helpers. Contains methods to compare a field's value with a provided value.
 *
 * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying OData
 * field names, so use the constructor with caution.
 *
 * @param <ObjectT>
 *            Entity type of subclasses from {@link com.sap.cloud.sdk.datamodel.odata.helper.VdmObject VdmObject}.
 *
 */
public class BusSolnOrdFUPEntProjectLink<ObjectT extends VdmObject<?>>
    extends
    EntityLink<BusSolnOrdFUPEntProjectLink<ObjectT>, BusSolnOrdFUPEntProject, ObjectT>
    implements
    BusSolnOrdFUPEntProjectSelectable
{

    /**
     * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying
     * OData field names, so use with caution.
     *
     * @param fieldName
     *            OData navigation field name. Must match the field returned by the underlying OData service.
     */
    public BusSolnOrdFUPEntProjectLink( final String fieldName )
    {
        super(fieldName);
    }

    private BusSolnOrdFUPEntProjectLink(
        final EntityLink<BusSolnOrdFUPEntProjectLink<ObjectT>, BusSolnOrdFUPEntProject, ObjectT> toClone )
    {
        super(toClone);
    }

    @Nonnull
    @Override
    protected BusSolnOrdFUPEntProjectLink<ObjectT> translateLinkType(
        final EntityLink<BusSolnOrdFUPEntProjectLink<ObjectT>, BusSolnOrdFUPEntProject, ObjectT> link )
    {
        return new BusSolnOrdFUPEntProjectLink<ObjectT>(link);
    }

}
