/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.link;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.EntityLink;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSubscrpnBillgItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.selectable.BusSolnOrdSubscrpnBillgItemSelectable;

/**
 * Template class to represent entity navigation links of
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSubscrpnBillgItem
 * BusSolnOrdSubscrpnBillgItem} to other entities. Instances of this object are used in query modifier methods of the
 * entity fluent helpers. Contains methods to compare a field's value with a provided value.
 *
 * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying OData
 * field names, so use the constructor with caution.
 *
 * @param <ObjectT>
 *            Entity type of subclasses from {@link com.sap.cloud.sdk.datamodel.odata.helper.VdmObject VdmObject}.
 *
 */
public class BusSolnOrdSubscrpnBillgItemLink<ObjectT extends VdmObject<?>>
    extends
    EntityLink<BusSolnOrdSubscrpnBillgItemLink<ObjectT>, BusSolnOrdSubscrpnBillgItem, ObjectT>
    implements
    BusSolnOrdSubscrpnBillgItemSelectable
{

    /**
     * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying
     * OData field names, so use with caution.
     *
     * @param fieldName
     *            OData navigation field name. Must match the field returned by the underlying OData service.
     */
    public BusSolnOrdSubscrpnBillgItemLink( final String fieldName )
    {
        super(fieldName);
    }

    private BusSolnOrdSubscrpnBillgItemLink(
        final EntityLink<BusSolnOrdSubscrpnBillgItemLink<ObjectT>, BusSolnOrdSubscrpnBillgItem, ObjectT> toClone )
    {
        super(toClone);
    }

    @Nonnull
    @Override
    protected BusSolnOrdSubscrpnBillgItemLink<ObjectT> translateLinkType(
        final EntityLink<BusSolnOrdSubscrpnBillgItemLink<ObjectT>, BusSolnOrdSubscrpnBillgItem, ObjectT> link )
    {
        return new BusSolnOrdSubscrpnBillgItemLink<ObjectT>(link);
    }

}
