/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BSOrdSrvcContrItmBillgReqItm;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BSOrdSrvcContrItmBillgReqItm
 * BSOrdSrvcContrItmBillgReqItm}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.field.BSOrdSrvcContrItmBillgReqItmField
 * BSOrdSrvcContrItmBillgReqItmField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.link.BSOrdSrvcContrItmBillgReqItmLink
 * BSOrdSrvcContrItmBillgReqItmLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BSOrdSrvcContrItmBillgReqItm#BUSINESS_SOLUTION_ORDER
 * BUSINESS_SOLUTION_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BSOrdSrvcContrItmBillgReqItm#BUSINESS_SOLUTION_ORDER_ITEM
 * BUSINESS_SOLUTION_ORDER_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BSOrdSrvcContrItmBillgReqItm#BILLING_REQUEST_ITEM
 * BILLING_REQUEST_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BSOrdSrvcContrItmBillgReqItm#BILLG_REQ_ITEM_BILLING_DATE_TIME
 * BILLG_REQ_ITEM_BILLING_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BSOrdSrvcContrItmBillgReqItm#SETTLEMENT_START_DATE_TIME
 * SETTLEMENT_START_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BSOrdSrvcContrItmBillgReqItm#SETTLEMENT_END_DATE_TIME
 * SETTLEMENT_END_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BSOrdSrvcContrItmBillgReqItm#BILLING_PLAN_TIME_ZONE
 * BILLING_PLAN_TIME_ZONE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BSOrdSrvcContrItmBillgReqItm#TRANSACTION_CURRENCY
 * TRANSACTION_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BSOrdSrvcContrItmBillgReqItm#BILLG_REQ_ITEM_NET_AMOUNT
 * BILLG_REQ_ITEM_NET_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BSOrdSrvcContrItmBillgReqItm#TO_PRICING_ELEMENT
 * TO_PRICING_ELEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BSOrdSrvcContrItmBillgReqItm#TO_SERVICE_CONTRACT_ITEM
 * TO_SERVICE_CONTRACT_ITEM}</li>
 * </ul>
 *
 */
public interface BSOrdSrvcContrItmBillgReqItmSelectable extends EntitySelectable<BSOrdSrvcContrItmBillgReqItm>
{

}
