/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdEntProjectItem;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdEntProjectItem
 * BusSolnOrdEntProjectItem}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.field.BusSolnOrdEntProjectItemField
 * BusSolnOrdEntProjectItemField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.link.BusSolnOrdEntProjectItemLink
 * BusSolnOrdEntProjectItemLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdEntProjectItem#BUSINESS_SOLUTION_ORDER
 * BUSINESS_SOLUTION_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdEntProjectItem#BUSINESS_SOLUTION_ORDER_ITEM
 * BUSINESS_SOLUTION_ORDER_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdEntProjectItem#BUSINESS_SOLUTION_ORDER_ITEM_UUID
 * BUSINESS_SOLUTION_ORDER_ITEM_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdEntProjectItem#BUS_SOLN_ORD_ITM_CATEGORY
 * BUS_SOLN_ORD_ITM_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdEntProjectItem#PRODUCT
 * PRODUCT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdEntProjectItem#QUANTITY
 * QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdEntProjectItem#QUANTITY_UNIT
 * QUANTITY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdEntProjectItem#BUS_SOLN_ORD_ITM_QTY_UNIT_SAP_CODE
 * BUS_SOLN_ORD_ITM_QTY_UNIT_SAP_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdEntProjectItem#BUS_SOLN_ORD_ITM_QTY_UNIT_ISO_CODE
 * BUS_SOLN_ORD_ITM_QTY_UNIT_ISO_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdEntProjectItem#BUS_SOLN_ORD_ITM_DESCRIPTION
 * BUS_SOLN_ORD_ITM_DESCRIPTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdEntProjectItem#SERVICE_DOCUMENT_ITEM_NET_AMOUNT
 * SERVICE_DOCUMENT_ITEM_NET_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdEntProjectItem#TRANSACTION_CURRENCY
 * TRANSACTION_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdEntProjectItem#BUS_SOLN_ORD_ITM_EXT_REFERENCE
 * BUS_SOLN_ORD_ITM_EXT_REFERENCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdEntProjectItem#BUS_SOLN_ORD_ITM_IS_RELEASED
 * BUS_SOLN_ORD_ITM_IS_RELEASED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdEntProjectItem#BUS_SOLN_ORD_ITM_IS_COMPLETED
 * BUS_SOLN_ORD_ITM_IS_COMPLETED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdEntProjectItem#SOLD_TO_PARTY
 * SOLD_TO_PARTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdEntProjectItem#PROJECT_MANAGER
 * PROJECT_MANAGER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdEntProjectItem#PERSON_RESPONSIBLE
 * PERSON_RESPONSIBLE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdEntProjectItem#PROJECT_START_DATE
 * PROJECT_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdEntProjectItem#PROJECT_END_DATE
 * PROJECT_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdEntProjectItem#RESPONSIBLE_COST_CENTER
 * RESPONSIBLE_COST_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdEntProjectItem#PROFIT_CENTER
 * PROFIT_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdEntProjectItem#ENTERPRISE_PROJECT_SERVICE_ORG
 * ENTERPRISE_PROJECT_SERVICE_ORG}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdEntProjectItem#SERVICE_DOCUMENT_ITEM_CHAR_UUID
 * SERVICE_DOCUMENT_ITEM_CHAR_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdEntProjectItem#LINKED_PROJECT
 * LINKED_PROJECT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdEntProjectItem#TO_BUSINESS_SOLUTION_ORDER
 * TO_BUSINESS_SOLUTION_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdEntProjectItem#TO_ENTERPRISE_PROJECT
 * TO_ENTERPRISE_PROJECT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdEntProjectItem#TO_TEXT
 * TO_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdEntProjectItem#TO_USER_STATUS
 * TO_USER_STATUS}</li>
 * </ul>
 *
 */
public interface BusSolnOrdEntProjectItemSelectable extends EntitySelectable<BusSolnOrdEntProjectItem>
{

}
