/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdFUPServiceOrder;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdFUPServiceOrder
 * BusSolnOrdFUPServiceOrder}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.field.BusSolnOrdFUPServiceOrderField
 * BusSolnOrdFUPServiceOrderField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.link.BusSolnOrdFUPServiceOrderLink
 * BusSolnOrdFUPServiceOrderLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdFUPServiceOrder#SERVICE_DOCUMENT_RELATION_UUID
 * SERVICE_DOCUMENT_RELATION_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdFUPServiceOrder#SERVICE_DOC_RLTN_SEQUENCE_NUMBER
 * SERVICE_DOC_RLTN_SEQUENCE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdFUPServiceOrder#BUSINESS_SOLUTION_ORDER
 * BUSINESS_SOLUTION_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdFUPServiceOrder#BUSINESS_SOLUTION_ORDER_UUID
 * BUSINESS_SOLUTION_ORDER_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdFUPServiceOrder#SERVICE_ORDER
 * SERVICE_ORDER}</li>
 * </ul>
 *
 */
public interface BusSolnOrdFUPServiceOrderSelectable extends EntitySelectable<BusSolnOrdFUPServiceOrder>
{

}
