/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdFUPSubscrpn;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdFUPSubscrpn
 * BusSolnOrdFUPSubscrpn}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.field.BusSolnOrdFUPSubscrpnField
 * BusSolnOrdFUPSubscrpnField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.link.BusSolnOrdFUPSubscrpnLink
 * BusSolnOrdFUPSubscrpnLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdFUPSubscrpn#SERVICE_DOCUMENT_RELATION_UUID
 * SERVICE_DOCUMENT_RELATION_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdFUPSubscrpn#SERVICE_DOC_RLTN_SEQUENCE_NUMBER
 * SERVICE_DOC_RLTN_SEQUENCE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdFUPSubscrpn#BUSINESS_SOLUTION_ORDER_UUID
 * BUSINESS_SOLUTION_ORDER_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdFUPSubscrpn#BUSINESS_SOLUTION_ORDER
 * BUSINESS_SOLUTION_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdFUPSubscrpn#SUBSCRPN_BILLG_SUBSCRIPTION
 * SUBSCRPN_BILLG_SUBSCRIPTION}</li>
 * </ul>
 *
 */
public interface BusSolnOrdFUPSubscrpnSelectable extends EntitySelectable<BusSolnOrdFUPSubscrpn>
{

}
