/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItemRelationships;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItemRelationships
 * BusSolnOrdItemRelationships}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.field.BusSolnOrdItemRelationshipsField
 * BusSolnOrdItemRelationshipsField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.link.BusSolnOrdItemRelationshipsLink
 * BusSolnOrdItemRelationshipsLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItemRelationships#BUSINESS_SOLUTION_ORDER
 * BUSINESS_SOLUTION_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItemRelationships#SRVC_ITEM_RELSHP_FROM_ITEM_NUMBER
 * SRVC_ITEM_RELSHP_FROM_ITEM_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItemRelationships#SRVC_ITEM_RELSHP_TYPE
 * SRVC_ITEM_RELSHP_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItemRelationships#SRVC_ITEM_RELSHP_TO_ITEM_NUMBER
 * SRVC_ITEM_RELSHP_TO_ITEM_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItemRelationships#SRVC_ITEM_RELSHP_FROM_TYPE_NAME
 * SRVC_ITEM_RELSHP_FROM_TYPE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItemRelationships#SRVC_ITEM_RELSHP_TO_TYPE_NAME
 * SRVC_ITEM_RELSHP_TO_TYPE_NAME}</li>
 * </ul>
 *
 */
public interface BusSolnOrdItemRelationshipsSelectable extends EntitySelectable<BusSolnOrdItemRelationships>
{

}
