/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmFUPSalesOrder;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmFUPSalesOrder
 * BusSolnOrdItmFUPSalesOrder}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.field.BusSolnOrdItmFUPSalesOrderField
 * BusSolnOrdItmFUPSalesOrderField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.link.BusSolnOrdItmFUPSalesOrderLink
 * BusSolnOrdItmFUPSalesOrderLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmFUPSalesOrder#SERVICE_DOCUMENT_ITM_RELATION_UUID
 * SERVICE_DOCUMENT_ITM_RELATION_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmFUPSalesOrder#SERVICE_DOC_ITM_RLTN_SQNC_NUMBER
 * SERVICE_DOC_ITM_RLTN_SQNC_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmFUPSalesOrder#BUSINESS_SOLUTION_ORDER_UUID
 * BUSINESS_SOLUTION_ORDER_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmFUPSalesOrder#BUSINESS_SOLUTION_ORDER
 * BUSINESS_SOLUTION_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmFUPSalesOrder#BUSINESS_SOLUTION_ORDER_ITEM
 * BUSINESS_SOLUTION_ORDER_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmFUPSalesOrder#SALES_ORDER
 * SALES_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmFUPSalesOrder#SALES_ORDER_ITEM
 * SALES_ORDER_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmFUPSalesOrder#SERVICE_DOC_SUCCESSOR_BUS_OBJ_TYPE
 * SERVICE_DOC_SUCCESSOR_BUS_OBJ_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmFUPSalesOrder#SERVICE_OBJECT_TYPE
 * SERVICE_OBJECT_TYPE}</li>
 * </ul>
 *
 */
public interface BusSolnOrdItmFUPSalesOrderSelectable extends EntitySelectable<BusSolnOrdItmFUPSalesOrder>
{

}
