/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmFUPServiceOrder;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmFUPServiceOrder
 * BusSolnOrdItmFUPServiceOrder}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.field.BusSolnOrdItmFUPServiceOrderField
 * BusSolnOrdItmFUPServiceOrderField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.link.BusSolnOrdItmFUPServiceOrderLink
 * BusSolnOrdItmFUPServiceOrderLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmFUPServiceOrder#SERVICE_DOCUMENT_ITM_RELATION_UUID
 * SERVICE_DOCUMENT_ITM_RELATION_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmFUPServiceOrder#SERVICE_DOC_ITM_RLTN_SQNC_NUMBER
 * SERVICE_DOC_ITM_RLTN_SQNC_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmFUPServiceOrder#BUSINESS_SOLUTION_ORDER_UUID
 * BUSINESS_SOLUTION_ORDER_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmFUPServiceOrder#BUSINESS_SOLUTION_ORDER
 * BUSINESS_SOLUTION_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmFUPServiceOrder#BUSINESS_SOLUTION_ORDER_ITEM
 * BUSINESS_SOLUTION_ORDER_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmFUPServiceOrder#SERVICE_ORDER
 * SERVICE_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmFUPServiceOrder#SERVICE_ORDER_ITEM
 * SERVICE_ORDER_ITEM}</li>
 * </ul>
 *
 */
public interface BusSolnOrdItmFUPServiceOrderSelectable extends EntitySelectable<BusSolnOrdItmFUPServiceOrder>
{

}
