/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmFUPSrvcContr;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmFUPSrvcContr
 * BusSolnOrdItmFUPSrvcContr}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.field.BusSolnOrdItmFUPSrvcContrField
 * BusSolnOrdItmFUPSrvcContrField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.link.BusSolnOrdItmFUPSrvcContrLink
 * BusSolnOrdItmFUPSrvcContrLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmFUPSrvcContr#SERVICE_DOCUMENT_ITM_RELATION_UUID
 * SERVICE_DOCUMENT_ITM_RELATION_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmFUPSrvcContr#SERVICE_DOC_ITM_RLTN_SQNC_NUMBER
 * SERVICE_DOC_ITM_RLTN_SQNC_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmFUPSrvcContr#BUSINESS_SOLUTION_ORDER_UUID
 * BUSINESS_SOLUTION_ORDER_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmFUPSrvcContr#BUSINESS_SOLUTION_ORDER
 * BUSINESS_SOLUTION_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmFUPSrvcContr#BUSINESS_SOLUTION_ORDER_ITEM
 * BUSINESS_SOLUTION_ORDER_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmFUPSrvcContr#SERVICE_CONTRACT
 * SERVICE_CONTRACT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmFUPSrvcContr#SERVICE_CONTRACT_ITEM
 * SERVICE_CONTRACT_ITEM}</li>
 * </ul>
 *
 */
public interface BusSolnOrdItmFUPSrvcContrSelectable extends EntitySelectable<BusSolnOrdItmFUPSrvcContr>
{

}
