/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmFUPSubscrpn;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmFUPSubscrpn
 * BusSolnOrdItmFUPSubscrpn}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.field.BusSolnOrdItmFUPSubscrpnField
 * BusSolnOrdItmFUPSubscrpnField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.link.BusSolnOrdItmFUPSubscrpnLink
 * BusSolnOrdItmFUPSubscrpnLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmFUPSubscrpn#SERVICE_DOCUMENT_ITM_RELATION_UUID
 * SERVICE_DOCUMENT_ITM_RELATION_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmFUPSubscrpn#SERVICE_DOC_ITM_RLTN_SQNC_NUMBER
 * SERVICE_DOC_ITM_RLTN_SQNC_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmFUPSubscrpn#BUSINESS_SOLUTION_ORDER
 * BUSINESS_SOLUTION_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmFUPSubscrpn#BUSINESS_SOLUTION_ORDER_ITEM
 * BUSINESS_SOLUTION_ORDER_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmFUPSubscrpn#BUS_SOLN_ORDER_ITEM_CHAR_UUID
 * BUS_SOLN_ORDER_ITEM_CHAR_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmFUPSubscrpn#SUBSCRPN_BILLG_SUBSCRIPTION
 * SUBSCRPN_BILLG_SUBSCRIPTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmFUPSubscrpn#SUBSCRPN_BILLG_SUBSCRIPTION_ITEM
 * SUBSCRPN_BILLG_SUBSCRIPTION_ITEM}</li>
 * </ul>
 *
 */
public interface BusSolnOrdItmFUPSubscrpnSelectable extends EntitySelectable<BusSolnOrdItmFUPSubscrpn>
{

}
