/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmRateElement;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmRateElement
 * BusSolnOrdItmRateElement}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.field.BusSolnOrdItmRateElementField
 * BusSolnOrdItmRateElementField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.link.BusSolnOrdItmRateElementLink
 * BusSolnOrdItmRateElementLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmRateElement#BUSINESS_SOLUTION_ORDER
 * BUSINESS_SOLUTION_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmRateElement#BUSINESS_SOLUTION_ORDER_ITEM
 * BUSINESS_SOLUTION_ORDER_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmRateElement#SUBSCRIPTION_RATE_ELEMENT
 * SUBSCRIPTION_RATE_ELEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmRateElement#SUBSCRIPTION_RATE_ELEMENT_TYPE
 * SUBSCRIPTION_RATE_ELEMENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmRateElement#SUBSCRPN_RATE_ELEMENT_TYPE_TEXT
 * SUBSCRPN_RATE_ELEMENT_TYPE_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmRateElement#SUBSCRPN_RATE_ELEMENT_NET_AMOUNT
 * SUBSCRPN_RATE_ELEMENT_NET_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmRateElement#SUBSCRPN_RATE_ELEMENT_GROSS_AMOUNT
 * SUBSCRPN_RATE_ELEMENT_GROSS_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmRateElement#SUBSCRPN_RATE_ELEMENT_TAX_AMOUNT
 * SUBSCRPN_RATE_ELEMENT_TAX_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmRateElement#CURRENCY
 * CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmRateElement#TO_BUSINESS_SOLUTION_ORDER
 * TO_BUSINESS_SOLUTION_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmRateElement#TO_SUBSCRIPTION_BILLING_ITEM
 * TO_SUBSCRIPTION_BILLING_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmRateElement#TO_SUBSCRIPTION_RATE_ELM_PRICE_ELM
 * TO_SUBSCRIPTION_RATE_ELM_PRICE_ELM}</li>
 * </ul>
 *
 */
public interface BusSolnOrdItmRateElementSelectable extends EntitySelectable<BusSolnOrdItmRateElement>
{

}
