/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmReferenceObject;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmReferenceObject
 * BusSolnOrdItmReferenceObject}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.field.BusSolnOrdItmReferenceObjectField
 * BusSolnOrdItmReferenceObjectField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.link.BusSolnOrdItmReferenceObjectLink
 * BusSolnOrdItmReferenceObjectLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmReferenceObject#BUSINESS_SOLUTION_ORDER
 * BUSINESS_SOLUTION_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmReferenceObject#BUSINESS_SOLUTION_ORDER_ITEM
 * BUSINESS_SOLUTION_ORDER_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmReferenceObject#REFERENCE_PRODUCT
 * REFERENCE_PRODUCT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmReferenceObject#SERVICE_REF_FUNCTIONAL_LOCATION
 * SERVICE_REF_FUNCTIONAL_LOCATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmReferenceObject#SERVICE_REFERENCE_EQUIPMENT
 * SERVICE_REFERENCE_EQUIPMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmReferenceObject#SRVC_REF_OBJ_IS_MAIN_OBJECT
 * SRVC_REF_OBJ_IS_MAIN_OBJECT}</li>
 * </ul>
 *
 */
public interface BusSolnOrdItmReferenceObjectSelectable extends EntitySelectable<BusSolnOrdItmReferenceObject>
{

}
