/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrAgrmt;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrAgrmt
 * BusSolnOrdItmSubscrpnPrAgrmt}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.field.BusSolnOrdItmSubscrpnPrAgrmtField
 * BusSolnOrdItmSubscrpnPrAgrmtField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.link.BusSolnOrdItmSubscrpnPrAgrmtLink
 * BusSolnOrdItmSubscrpnPrAgrmtLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrAgrmt#BUSINESS_SOLUTION_ORDER
 * BUSINESS_SOLUTION_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrAgrmt#BUSINESS_SOLUTION_ORDER_ITEM
 * BUSINESS_SOLUTION_ORDER_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrAgrmt#SUBSCRIPTION_RATE_ELEMENT
 * SUBSCRIPTION_RATE_ELEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrAgrmt#SUBSCRIPTION_RATE_SUB_ELEMENT
 * SUBSCRIPTION_RATE_SUB_ELEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrAgrmt#SUBSCRPN_BILLG_PRC_ELMNT_SPEC
 * SUBSCRPN_BILLG_PRC_ELMNT_SPEC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrAgrmt#SUBSCRPN_BILLG_PRICING_FIELD
 * SUBSCRPN_BILLG_PRICING_FIELD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrAgrmt#SUBSCRPN_BILLG_PRC_AGREEMENT_LINE
 * SUBSCRPN_BILLG_PRC_AGREEMENT_LINE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrAgrmt#SUBSCRPN_BILLG_PRICING_SCALE_TYPE
 * SUBSCRPN_BILLG_PRICING_SCALE_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrAgrmt#SUBSCRPN_BILLG_CNDN_CALC_TYPE
 * SUBSCRPN_BILLG_CNDN_CALC_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrAgrmt#CONDITION_SCALE_QUANTITY
 * CONDITION_SCALE_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrAgrmt#CONDITION_SCALE_QUANTITY_UNIT
 * CONDITION_SCALE_QUANTITY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrAgrmt#CONDITION_SCALE_AMOUNT
 * CONDITION_SCALE_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrAgrmt#CONDITION_SCALE_AMOUNT_CURRENCY
 * CONDITION_SCALE_AMOUNT_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrAgrmt#CONDITION_RATE_VALUE
 * CONDITION_RATE_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrAgrmt#CONDITION_CURRENCY
 * CONDITION_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrAgrmt#CONDITION_QUANTITY
 * CONDITION_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrAgrmt#CONDITION_QUANTITY_UNIT
 * CONDITION_QUANTITY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrAgrmt#CONDITION_RATE_RATIO
 * CONDITION_RATE_RATIO}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrAgrmt#SBSCR_BILG_CNDN_SCALE_LINE_IS_UNLMTD
 * SBSCR_BILG_CNDN_SCALE_LINE_IS_UNLMTD}</li>
 * </ul>
 *
 */
public interface BusSolnOrdItmSubscrpnPrAgrmtSelectable extends EntitySelectable<BusSolnOrdItmSubscrpnPrAgrmt>
{

}
