/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrParam;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrParam
 * BusSolnOrdItmSubscrpnPrParam}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.field.BusSolnOrdItmSubscrpnPrParamField
 * BusSolnOrdItmSubscrpnPrParamField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.link.BusSolnOrdItmSubscrpnPrParamLink
 * BusSolnOrdItmSubscrpnPrParamLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrParam#BUSINESS_SOLUTION_ORDER
 * BUSINESS_SOLUTION_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrParam#BUSINESS_SOLUTION_ORDER_ITEM
 * BUSINESS_SOLUTION_ORDER_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrParam#SUBSCRPN_PRCG_PARAMETER
 * SUBSCRPN_PRCG_PARAMETER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrParam#SUBSCRPN_PRCG_PARAM_VAL_TYPE
 * SUBSCRPN_PRCG_PARAM_VAL_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrParam#SUBSCRPN_PARAMETER_DECIMAL_VALUE
 * SUBSCRPN_PARAMETER_DECIMAL_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrParam#SUBSCRPN_PRCG_PARAM_VAL_TYPE_TEXT
 * SUBSCRPN_PRCG_PARAM_VAL_TYPE_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrParam#SUBSCRPN_PARAM_DFLT_DECIMAL_VALUE
 * SUBSCRPN_PARAM_DFLT_DECIMAL_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdItmSubscrpnPrParam#SUBSCRPN_PRCG_PARAM_VAL_IS_SPCFD
 * SUBSCRPN_PRCG_PARAM_VAL_IS_SPCFD}</li>
 * </ul>
 *
 */
public interface BusSolnOrdItmSubscrpnPrParamSelectable extends EntitySelectable<BusSolnOrdItmSubscrpnPrParam>
{

}
