/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcContractItem;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcContractItem
 * BusSolnOrdSrvcContractItem}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.field.BusSolnOrdSrvcContractItemField
 * BusSolnOrdSrvcContractItemField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.link.BusSolnOrdSrvcContractItemLink
 * BusSolnOrdSrvcContractItemLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcContractItem#BUSINESS_SOLUTION_ORDER
 * BUSINESS_SOLUTION_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcContractItem#BUSINESS_SOLUTION_ORDER_ITEM
 * BUSINESS_SOLUTION_ORDER_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcContractItem#SERVICE_DOCUMENT_ITEM_CHAR_UUID
 * SERVICE_DOCUMENT_ITEM_CHAR_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcContractItem#BUSINESS_SOLUTION_ORDER_ITEM_UUID
 * BUSINESS_SOLUTION_ORDER_ITEM_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcContractItem#BUS_SOLN_ORD_ITM_CATEGORY
 * BUS_SOLN_ORD_ITM_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcContractItem#PRODUCT
 * PRODUCT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcContractItem#QUANTITY
 * QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcContractItem#QUANTITY_UNIT
 * QUANTITY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcContractItem#BUS_SOLN_ORD_ITM_QTY_UNIT_SAP_CODE
 * BUS_SOLN_ORD_ITM_QTY_UNIT_SAP_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcContractItem#BUS_SOLN_ORD_ITM_QTY_UNIT_ISO_CODE
 * BUS_SOLN_ORD_ITM_QTY_UNIT_ISO_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcContractItem#BUS_SOLN_ORD_ITM_DESCRIPTION
 * BUS_SOLN_ORD_ITM_DESCRIPTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcContractItem#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcContractItem#BUS_SOLN_ORD_ITM_EXT_REFERENCE
 * BUS_SOLN_ORD_ITM_EXT_REFERENCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcContractItem#BUS_SOLN_ORD_ITM_IS_RELEASED
 * BUS_SOLN_ORD_ITM_IS_RELEASED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcContractItem#BUS_SOLN_ORD_ITM_IS_COMPLETED
 * BUS_SOLN_ORD_ITM_IS_COMPLETED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcContractItem#BUS_SOLN_ORD_ITM_IS_REJECTED
 * BUS_SOLN_ORD_ITM_IS_REJECTED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcContractItem#BUS_SOLN_ORD_ITM_DISTR_STATUS
 * BUS_SOLN_ORD_ITM_DISTR_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcContractItem#BUS_SOLN_ORD_ITM_DISTR_STATUS_NAME
 * BUS_SOLN_ORD_ITM_DISTR_STATUS_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcContractItem#BUS_SOLN_ORD_ITM_RJCN_REASON
 * BUS_SOLN_ORD_ITM_RJCN_REASON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcContractItem#BUS_SOLN_ORD_ITM_RJCN_REASON_TEXT
 * BUS_SOLN_ORD_ITM_RJCN_REASON_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcContractItem#BILLING_BLOCK_REASON
 * BILLING_BLOCK_REASON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcContractItem#SERVICE_DOCUMENT_ITEM_NET_AMOUNT
 * SERVICE_DOCUMENT_ITEM_NET_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcContractItem#TRANSACTION_CURRENCY
 * TRANSACTION_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcContractItem#CONFIGURATION_NUMBER
 * CONFIGURATION_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcContractItem#SOLD_TO_PARTY
 * SOLD_TO_PARTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcContractItem#SHIP_TO_PARTY
 * SHIP_TO_PARTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcContractItem#BILL_TO_PARTY
 * BILL_TO_PARTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcContractItem#PAYER_PARTY
 * PAYER_PARTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcContractItem#PERSON_RESPONSIBLE
 * PERSON_RESPONSIBLE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcContractItem#CONTACT_PERSON
 * CONTACT_PERSON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcContractItem#PAYMENT_TERMS
 * PAYMENT_TERMS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcContractItem#SERVICE_PROFILE
 * SERVICE_PROFILE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcContractItem#RESPONSE_PROFILE
 * RESPONSE_PROFILE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcContractItem#BILLING_PLAN_BILLING_DATE_RULE
 * BILLING_PLAN_BILLING_DATE_RULE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcContractItem#SETTLEMENT_PERIOD_RULE
 * SETTLEMENT_PERIOD_RULE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcContractItem#SERVICE_CONTR_ITEM_START_DATE_TIME
 * SERVICE_CONTR_ITEM_START_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcContractItem#SERVICE_CONTR_ITEM_END_DATE_TIME
 * SERVICE_CONTR_ITEM_END_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcContractItem#SRVC_CONTR_ITEM_RNWL_DURATION
 * SRVC_CONTR_ITEM_RNWL_DURATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcContractItem#SRVC_CONTR_ITEM_RNWL_DURATION_UNIT
 * SRVC_CONTR_ITEM_RNWL_DURATION_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcContractItem#SRVC_CONTR_ITEM_EXTENSION_DURATION
 * SRVC_CONTR_ITEM_EXTENSION_DURATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcContractItem#SRVC_CONTR_ITEM_EXTN_DURATION_UNIT
 * SRVC_CONTR_ITEM_EXTN_DURATION_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcContractItem#CPQ_QUOTATION_ITEM
 * CPQ_QUOTATION_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcContractItem#TO_BILLING_REQUEST_ITEM
 * TO_BILLING_REQUEST_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcContractItem#TO_BUSINESS_SOLUTION_ORDER
 * TO_BUSINESS_SOLUTION_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcContractItem#TO_CONFIGURATIONS
 * TO_CONFIGURATIONS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcContractItem#TO_OBJECT_LIST
 * TO_OBJECT_LIST}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcContractItem#TO_PRICE_ELEMENT
 * TO_PRICE_ELEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcContractItem#TO_PRODUCT_LIST
 * TO_PRODUCT_LIST}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcContractItem#TO_SERVICE_CONTRACT
 * TO_SERVICE_CONTRACT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcContractItem#TO_TEXT
 * TO_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcContractItem#TO_USER_STATUS
 * TO_USER_STATUS}</li>
 * </ul>
 *
 */
public interface BusSolnOrdSrvcContractItemSelectable extends EntitySelectable<BusSolnOrdSrvcContractItem>
{

}
