/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcPrtItem;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcPrtItem
 * BusSolnOrdSrvcPrtItem}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.field.BusSolnOrdSrvcPrtItemField
 * BusSolnOrdSrvcPrtItemField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.link.BusSolnOrdSrvcPrtItemLink
 * BusSolnOrdSrvcPrtItemLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcPrtItem#BUSINESS_SOLUTION_ORDER
 * BUSINESS_SOLUTION_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcPrtItem#BUSINESS_SOLUTION_ORDER_ITEM
 * BUSINESS_SOLUTION_ORDER_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcPrtItem#SERVICE_DOCUMENT_ITEM_CHAR_UUID
 * SERVICE_DOCUMENT_ITEM_CHAR_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcPrtItem#BUSINESS_SOLUTION_ORDER_ITEM_UUID
 * BUSINESS_SOLUTION_ORDER_ITEM_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcPrtItem#BUS_SOLN_ORD_ITM_CATEGORY
 * BUS_SOLN_ORD_ITM_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcPrtItem#PRODUCT
 * PRODUCT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcPrtItem#QUANTITY
 * QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcPrtItem#QUANTITY_UNIT
 * QUANTITY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcPrtItem#BUS_SOLN_ORD_ITM_QTY_UNIT_SAP_CODE
 * BUS_SOLN_ORD_ITM_QTY_UNIT_SAP_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcPrtItem#BUS_SOLN_ORD_ITM_QTY_UNIT_ISO_CODE
 * BUS_SOLN_ORD_ITM_QTY_UNIT_ISO_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcPrtItem#BUS_SOLN_ORD_ITM_DESCRIPTION
 * BUS_SOLN_ORD_ITM_DESCRIPTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcPrtItem#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcPrtItem#BUS_SOLN_ORD_ITM_EXT_REFERENCE
 * BUS_SOLN_ORD_ITM_EXT_REFERENCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcPrtItem#ITEM_ORDER_PROBABILITY_IN_PERCENT
 * ITEM_ORDER_PROBABILITY_IN_PERCENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcPrtItem#PAYMENT_TERMS
 * PAYMENT_TERMS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcPrtItem#BILLABLE_CONTROL
 * BILLABLE_CONTROL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcPrtItem#SERVICE_DOCUMENT_ITEM_NET_AMOUNT
 * SERVICE_DOCUMENT_ITEM_NET_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcPrtItem#TRANSACTION_CURRENCY
 * TRANSACTION_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcPrtItem#BUS_SOLN_ORD_ITM_IS_COMPLETED
 * BUS_SOLN_ORD_ITM_IS_COMPLETED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcPrtItem#BUS_SOLN_ORD_ITM_IS_RELEASED
 * BUS_SOLN_ORD_ITM_IS_RELEASED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcPrtItem#BUS_SOLN_ORD_ITM_IS_REJECTED
 * BUS_SOLN_ORD_ITM_IS_REJECTED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcPrtItem#BUS_SOLN_ORD_ITM_DISTR_STATUS
 * BUS_SOLN_ORD_ITM_DISTR_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcPrtItem#BUS_SOLN_ORD_ITM_DISTR_STATUS_NAME
 * BUS_SOLN_ORD_ITM_DISTR_STATUS_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcPrtItem#BUS_SOLN_ORD_ITM_RJCN_REASON
 * BUS_SOLN_ORD_ITM_RJCN_REASON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcPrtItem#BUS_SOLN_ORD_ITM_RJCN_REASON_TEXT
 * BUS_SOLN_ORD_ITM_RJCN_REASON_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcPrtItem#REFERENCE_SERVICE_CONTRACT
 * REFERENCE_SERVICE_CONTRACT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcPrtItem#REFERENCE_SERVICE_CONTRACT_ITEM
 * REFERENCE_SERVICE_CONTRACT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcPrtItem#SRVC_CONTR_DETN_IS_SPPRSD
 * SRVC_CONTR_DETN_IS_SPPRSD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcPrtItem#SOLD_TO_PARTY
 * SOLD_TO_PARTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcPrtItem#SHIP_TO_PARTY
 * SHIP_TO_PARTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcPrtItem#BILL_TO_PARTY
 * BILL_TO_PARTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcPrtItem#PAYER_PARTY
 * PAYER_PARTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcPrtItem#PERSON_RESPONSIBLE
 * PERSON_RESPONSIBLE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcPrtItem#CONTACT_PERSON
 * CONTACT_PERSON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcPrtItem#TO_BUSINESS_SOLUTION_ORDER
 * TO_BUSINESS_SOLUTION_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcPrtItem#TO_PRICE_ELEMENT
 * TO_PRICE_ELEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcPrtItem#TO_REFERENCE_OBJECT
 * TO_REFERENCE_OBJECT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcPrtItem#TO_SERVICE_ORDER
 * TO_SERVICE_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcPrtItem#TO_TEXT
 * TO_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSrvcPrtItem#TO_USER_STATUS
 * TO_USER_STATUS}</li>
 * </ul>
 *
 */
public interface BusSolnOrdSrvcPrtItemSelectable extends EntitySelectable<BusSolnOrdSrvcPrtItem>
{

}
