/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSubscrpnBillgItem;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSubscrpnBillgItem
 * BusSolnOrdSubscrpnBillgItem}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.field.BusSolnOrdSubscrpnBillgItemField
 * BusSolnOrdSubscrpnBillgItemField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.link.BusSolnOrdSubscrpnBillgItemLink
 * BusSolnOrdSubscrpnBillgItemLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSubscrpnBillgItem#BUSINESS_SOLUTION_ORDER
 * BUSINESS_SOLUTION_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSubscrpnBillgItem#BUSINESS_SOLUTION_ORDER_ITEM
 * BUSINESS_SOLUTION_ORDER_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSubscrpnBillgItem#BUSINESS_SOLUTION_ORDER_ITEM_UUID
 * BUSINESS_SOLUTION_ORDER_ITEM_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSubscrpnBillgItem#BUS_SOLN_ORD_ITM_CATEGORY
 * BUS_SOLN_ORD_ITM_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSubscrpnBillgItem#PRODUCT
 * PRODUCT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSubscrpnBillgItem#QUANTITY
 * QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSubscrpnBillgItem#QUANTITY_UNIT
 * QUANTITY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSubscrpnBillgItem#BUS_SOLN_ORD_ITM_QTY_UNIT_SAP_CODE
 * BUS_SOLN_ORD_ITM_QTY_UNIT_SAP_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSubscrpnBillgItem#BUS_SOLN_ORD_ITM_QTY_UNIT_ISO_CODE
 * BUS_SOLN_ORD_ITM_QTY_UNIT_ISO_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSubscrpnBillgItem#BUS_SOLN_ORD_ITM_DESCRIPTION
 * BUS_SOLN_ORD_ITM_DESCRIPTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSubscrpnBillgItem#BUS_SOLN_ORD_ITM_EXT_REFERENCE
 * BUS_SOLN_ORD_ITM_EXT_REFERENCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSubscrpnBillgItem#SERVICE_DOCUMENT_ITEM_NET_AMOUNT
 * SERVICE_DOCUMENT_ITEM_NET_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSubscrpnBillgItem#TRANSACTION_CURRENCY
 * TRANSACTION_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSubscrpnBillgItem#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSubscrpnBillgItem#BUS_SOLN_ORD_ITM_IS_COMPLETED
 * BUS_SOLN_ORD_ITM_IS_COMPLETED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSubscrpnBillgItem#BUS_SOLN_ORD_ITM_IS_RELEASED
 * BUS_SOLN_ORD_ITM_IS_RELEASED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSubscrpnBillgItem#BUS_SOLN_ORD_ITM_DISTR_STATUS
 * BUS_SOLN_ORD_ITM_DISTR_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSubscrpnBillgItem#BUS_SOLN_ORD_ITM_DISTR_STATUS_NAME
 * BUS_SOLN_ORD_ITM_DISTR_STATUS_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSubscrpnBillgItem#SUBSCRPN_SIMULATION_STATUS
 * SUBSCRPN_SIMULATION_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSubscrpnBillgItem#SUBSCRPN_SIMULATION_STATUS_NAME
 * SUBSCRPN_SIMULATION_STATUS_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSubscrpnBillgItem#SUBSCRIPTION_START_DATE_TIME
 * SUBSCRIPTION_START_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSubscrpnBillgItem#SUBSCRIPTION_END_DATE_TIME
 * SUBSCRIPTION_END_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSubscrpnBillgItem#SUBSCRPN_BILLG_ITM_PRCG_DATE_TIME
 * SUBSCRPN_BILLG_ITM_PRCG_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSubscrpnBillgItem#SUBSCRPN_WITHDRAWAL_PERIOD
 * SUBSCRPN_WITHDRAWAL_PERIOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSubscrpnBillgItem#SUBSCRIPTION_FIXED_TERM
 * SUBSCRIPTION_FIXED_TERM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSubscrpnBillgItem#SUBSCRIPTION_TERM_OF_NOTICE
 * SUBSCRIPTION_TERM_OF_NOTICE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSubscrpnBillgItem#SUBSCRIPTION_MINIMUM_TERM
 * SUBSCRIPTION_MINIMUM_TERM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSubscrpnBillgItem#SUBSCRIPTION_RENEWAL_PERIOD
 * SUBSCRIPTION_RENEWAL_PERIOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSubscrpnBillgItem#SUBSCRIPTION_EXPECTED_TERM
 * SUBSCRIPTION_EXPECTED_TERM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSubscrpnBillgItem#SUBSCRPN_CONTR_TRMS_ARE_SPECIFIED
 * SUBSCRPN_CONTR_TRMS_ARE_SPECIFIED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSubscrpnBillgItem#MID_BILLG_CYC_EXPRTN_IS_ALLOWED
 * MID_BILLG_CYC_EXPRTN_IS_ALLOWED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSubscrpnBillgItem#SUBSCRIPTION_BILLING_CYCLE
 * SUBSCRIPTION_BILLING_CYCLE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSubscrpnBillgItem#SOLD_TO_PARTY
 * SOLD_TO_PARTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSubscrpnBillgItem#SHIP_TO_PARTY
 * SHIP_TO_PARTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSubscrpnBillgItem#BILL_TO_PARTY
 * BILL_TO_PARTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSubscrpnBillgItem#PAYER_PARTY
 * PAYER_PARTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSubscrpnBillgItem#TO_BUSINESS_SOLUTION_ORDER
 * TO_BUSINESS_SOLUTION_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSubscrpnBillgItem#TO_PRICE_PARAMETERS
 * TO_PRICE_PARAMETERS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSubscrpnBillgItem#TO_RATE_ELEMENTS
 * TO_RATE_ELEMENTS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSubscrpnBillgItem#TO_SUBSCRIPTION_BILLING
 * TO_SUBSCRIPTION_BILLING}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSubscrpnBillgItem#TO_SUBSCRIPTION_PARAMETERS
 * TO_SUBSCRIPTION_PARAMETERS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSubscrpnBillgItem#TO_SUBSCRIPTION_PRICE_AGREEMENTS
 * TO_SUBSCRIPTION_PRICE_AGREEMENTS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businesssolutionorder.BusSolnOrdSubscrpnBillgItem#TO_USER_STATUS
 * TO_USER_STATUS}</li>
 * </ul>
 *
 */
public interface BusSolnOrdSubscrpnBillgItemSelectable extends EntitySelectable<BusSolnOrdSubscrpnBillgItem>
{

}
