/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessuserchange.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link BusinessUserChangeServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessUserChangeService BusinessUserChangeService},
 * allowing you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultBusinessUserChangeServiceBatch
    extends
    BatchFluentHelperBasic<BusinessUserChangeServiceBatch, BusinessUserChangeServiceBatchChangeSet>
    implements
    BusinessUserChangeServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessUserChangeService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultBusinessUserChangeServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultBusinessUserChangeServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessUserChangeService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessUserChangeService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultBusinessUserChangeServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultBusinessUserChangeServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessUserChangeService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultBusinessUserChangeServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public BusinessUserChangeServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultBusinessUserChangeServiceBatchChangeSet(this, service);
    }

}
