/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessuserchange.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link BusinessUserChangeServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessUserChangeService BusinessUserChangeService}.
 *
 */
public class DefaultBusinessUserChangeServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<BusinessUserChangeServiceBatch, BusinessUserChangeServiceBatchChangeSet>
    implements
    BusinessUserChangeServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessUserChangeService service;

    @SuppressWarnings( "deprecation" )
    DefaultBusinessUserChangeServiceBatchChangeSet(
        @Nonnull final DefaultBusinessUserChangeServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.BusinessUserChangeService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultBusinessUserChangeServiceBatchChangeSet getThis()
    {
        return this;
    }

}
