/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessuserchange.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessuserchange.BusinessUserChanges;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessuserchange.BusinessUserChanges
 * BusinessUserChanges}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessuserchange.field.BusinessUserChangesField
 * BusinessUserChangesField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessuserchange.link.BusinessUserChangesLink
 * BusinessUserChangesLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessuserchange.BusinessUserChanges#BUSINESS_USER_ID
 * BUSINESS_USER_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessuserchange.BusinessUserChanges#CHANGED_ON
 * CHANGED_ON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessuserchange.BusinessUserChanges#CHANGE_CATEGORY
 * CHANGE_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessuserchange.BusinessUserChanges#ATTRIBUTE
 * ATTRIBUTE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessuserchange.BusinessUserChanges#VALUE_CHANGED_FROM
 * VALUE_CHANGED_FROM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessuserchange.BusinessUserChanges#VALUE_CHANGED_TO
 * VALUE_CHANGED_TO}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessuserchange.BusinessUserChanges#CHANGED_BY_USER_NAME
 * CHANGED_BY_USER_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessuserchange.BusinessUserChanges#CHANGED_BY_USER_ID
 * CHANGED_BY_USER_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessuserchange.BusinessUserChanges#CHANGED_BY_USER_EMAIL_ADDRESS
 * CHANGED_BY_USER_EMAIL_ADDRESS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessuserchange.BusinessUserChanges#CHANGED_BY_GLOBAL_USER_ID
 * CHANGED_BY_GLOBAL_USER_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessuserchange.BusinessUserChanges#ACTION
 * ACTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessuserchange.BusinessUserChanges#CHANGE_CATEGORY_TEXT
 * CHANGE_CATEGORY_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessuserchange.BusinessUserChanges#ATTRIBUTE_TEXT
 * ATTRIBUTE_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessuserchange.BusinessUserChanges#VALUE_CHANGED_FROM_TEXT
 * VALUE_CHANGED_FROM_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.businessuserchange.BusinessUserChanges#VALUE_CHANGED_TO_TEXT
 * VALUE_CHANGED_TO_TEXT}</li>
 * </ul>
 *
 */
public interface BusinessUserChangesSelectable extends EntitySelectable<BusinessUserChanges>
{

}
