/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract;

import java.math.BigDecimal;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.field.CePuCoDistrdContrPaytTrmsField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.selectable.CePuCoDistrdContrPaytTrmsSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Distributed Payment Terms
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_CePuCoDistrdContrPaytTrmsType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CePuCoDistrdContrPaytTrms extends VdmEntity<CePuCoDistrdContrPaytTrms>
{

    /**
     * Selector for all available fields of CePuCoDistrdContrPaytTrms.
     *
     */
    public final static CePuCoDistrdContrPaytTrmsSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CentralPurchaseContract</b>
     * </p>
     *
     * @return Purchasing Document Number
     */
    @Key
    @SerializedName( "CentralPurchaseContract" )
    @JsonProperty( "CentralPurchaseContract" )
    @Nullable
    @ODataField( odataName = "CentralPurchaseContract" )
    private String centralPurchaseContract;
    /**
     * Use with available fluent helpers to apply the <b>CentralPurchaseContract</b> field to query operations.
     *
     */
    public final static CePuCoDistrdContrPaytTrmsField<String> CENTRAL_PURCHASE_CONTRACT =
        new CePuCoDistrdContrPaytTrmsField<String>("CentralPurchaseContract");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ExtContractForPurg</b>
     * </p>
     *
     * @return Contract of External System
     */
    @Key
    @SerializedName( "ExtContractForPurg" )
    @JsonProperty( "ExtContractForPurg" )
    @Nullable
    @ODataField( odataName = "ExtContractForPurg" )
    private String extContractForPurg;
    /**
     * Use with available fluent helpers to apply the <b>ExtContractForPurg</b> field to query operations.
     *
     */
    public final static CePuCoDistrdContrPaytTrmsField<String> EXT_CONTRACT_FOR_PURG =
        new CePuCoDistrdContrPaytTrmsField<String>("ExtContractForPurg");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProcurementHubSourceSystem</b>
     * </p>
     *
     * @return Logical System
     */
    @Key
    @SerializedName( "ProcurementHubSourceSystem" )
    @JsonProperty( "ProcurementHubSourceSystem" )
    @Nullable
    @ODataField( odataName = "ProcurementHubSourceSystem" )
    private String procurementHubSourceSystem;
    /**
     * Use with available fluent helpers to apply the <b>ProcurementHubSourceSystem</b> field to query operations.
     *
     */
    public final static CePuCoDistrdContrPaytTrmsField<String> PROCUREMENT_HUB_SOURCE_SYSTEM =
        new CePuCoDistrdContrPaytTrmsField<String>("ProcurementHubSourceSystem");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PaymentTerms</b>
     * </p>
     *
     * @return Terms of Payment Key
     */
    @SerializedName( "PaymentTerms" )
    @JsonProperty( "PaymentTerms" )
    @Nullable
    @ODataField( odataName = "PaymentTerms" )
    private String paymentTerms;
    /**
     * Use with available fluent helpers to apply the <b>PaymentTerms</b> field to query operations.
     *
     */
    public final static CePuCoDistrdContrPaytTrmsField<String> PAYMENT_TERMS =
        new CePuCoDistrdContrPaytTrmsField<String>("PaymentTerms");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>NetPaymentDays</b>
     * </p>
     *
     * @return Net Payment Terms Period
     */
    @SerializedName( "NetPaymentDays" )
    @JsonProperty( "NetPaymentDays" )
    @Nullable
    @ODataField( odataName = "NetPaymentDays" )
    private BigDecimal netPaymentDays;
    /**
     * Use with available fluent helpers to apply the <b>NetPaymentDays</b> field to query operations.
     *
     */
    public final static CePuCoDistrdContrPaytTrmsField<BigDecimal> NET_PAYMENT_DAYS =
        new CePuCoDistrdContrPaytTrmsField<BigDecimal>("NetPaymentDays");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount1Days</b>
     * </p>
     *
     * @return Cash discount days 1
     */
    @SerializedName( "CashDiscount1Days" )
    @JsonProperty( "CashDiscount1Days" )
    @Nullable
    @ODataField( odataName = "CashDiscount1Days" )
    private BigDecimal cashDiscount1Days;
    /**
     * Use with available fluent helpers to apply the <b>CashDiscount1Days</b> field to query operations.
     *
     */
    public final static CePuCoDistrdContrPaytTrmsField<BigDecimal> CASH_DISCOUNT1_DAYS =
        new CePuCoDistrdContrPaytTrmsField<BigDecimal>("CashDiscount1Days");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount1Percent</b>
     * </p>
     *
     * @return Cash Discount Percentage 1
     */
    @SerializedName( "CashDiscount1Percent" )
    @JsonProperty( "CashDiscount1Percent" )
    @Nullable
    @ODataField( odataName = "CashDiscount1Percent" )
    private BigDecimal cashDiscount1Percent;
    /**
     * Use with available fluent helpers to apply the <b>CashDiscount1Percent</b> field to query operations.
     *
     */
    public final static CePuCoDistrdContrPaytTrmsField<BigDecimal> CASH_DISCOUNT1_PERCENT =
        new CePuCoDistrdContrPaytTrmsField<BigDecimal>("CashDiscount1Percent");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount2Days</b>
     * </p>
     *
     * @return Cash discount days 2
     */
    @SerializedName( "CashDiscount2Days" )
    @JsonProperty( "CashDiscount2Days" )
    @Nullable
    @ODataField( odataName = "CashDiscount2Days" )
    private BigDecimal cashDiscount2Days;
    /**
     * Use with available fluent helpers to apply the <b>CashDiscount2Days</b> field to query operations.
     *
     */
    public final static CePuCoDistrdContrPaytTrmsField<BigDecimal> CASH_DISCOUNT2_DAYS =
        new CePuCoDistrdContrPaytTrmsField<BigDecimal>("CashDiscount2Days");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount2Percent</b>
     * </p>
     *
     * @return Cash Discount Percentage 2
     */
    @SerializedName( "CashDiscount2Percent" )
    @JsonProperty( "CashDiscount2Percent" )
    @Nullable
    @ODataField( odataName = "CashDiscount2Percent" )
    private BigDecimal cashDiscount2Percent;
    /**
     * Use with available fluent helpers to apply the <b>CashDiscount2Percent</b> field to query operations.
     *
     */
    public final static CePuCoDistrdContrPaytTrmsField<BigDecimal> CASH_DISCOUNT2_PERCENT =
        new CePuCoDistrdContrPaytTrmsField<BigDecimal>("CashDiscount2Percent");

    @Nonnull
    @Override
    public Class<CePuCoDistrdContrPaytTrms> getType()
    {
        return CePuCoDistrdContrPaytTrms.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CentralPurchaseContract</b>
     * </p>
     *
     * @param centralPurchaseContract
     *            Purchasing Document Number
     */
    public void setCentralPurchaseContract( @Nullable final String centralPurchaseContract )
    {
        rememberChangedField("CentralPurchaseContract", this.centralPurchaseContract);
        this.centralPurchaseContract = centralPurchaseContract;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ExtContractForPurg</b>
     * </p>
     *
     * @param extContractForPurg
     *            Contract of External System
     */
    public void setExtContractForPurg( @Nullable final String extContractForPurg )
    {
        rememberChangedField("ExtContractForPurg", this.extContractForPurg);
        this.extContractForPurg = extContractForPurg;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProcurementHubSourceSystem</b>
     * </p>
     *
     * @param procurementHubSourceSystem
     *            Logical System
     */
    public void setProcurementHubSourceSystem( @Nullable final String procurementHubSourceSystem )
    {
        rememberChangedField("ProcurementHubSourceSystem", this.procurementHubSourceSystem);
        this.procurementHubSourceSystem = procurementHubSourceSystem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PaymentTerms</b>
     * </p>
     *
     * @param paymentTerms
     *            Terms of Payment Key
     */
    public void setPaymentTerms( @Nullable final String paymentTerms )
    {
        rememberChangedField("PaymentTerms", this.paymentTerms);
        this.paymentTerms = paymentTerms;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>NetPaymentDays</b>
     * </p>
     *
     * @param netPaymentDays
     *            Net Payment Terms Period
     */
    public void setNetPaymentDays( @Nullable final BigDecimal netPaymentDays )
    {
        rememberChangedField("NetPaymentDays", this.netPaymentDays);
        this.netPaymentDays = netPaymentDays;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount1Days</b>
     * </p>
     *
     * @param cashDiscount1Days
     *            Cash discount days 1
     */
    public void setCashDiscount1Days( @Nullable final BigDecimal cashDiscount1Days )
    {
        rememberChangedField("CashDiscount1Days", this.cashDiscount1Days);
        this.cashDiscount1Days = cashDiscount1Days;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount1Percent</b>
     * </p>
     *
     * @param cashDiscount1Percent
     *            Cash Discount Percentage 1
     */
    public void setCashDiscount1Percent( @Nullable final BigDecimal cashDiscount1Percent )
    {
        rememberChangedField("CashDiscount1Percent", this.cashDiscount1Percent);
        this.cashDiscount1Percent = cashDiscount1Percent;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount2Days</b>
     * </p>
     *
     * @param cashDiscount2Days
     *            Cash discount days 2
     */
    public void setCashDiscount2Days( @Nullable final BigDecimal cashDiscount2Days )
    {
        rememberChangedField("CashDiscount2Days", this.cashDiscount2Days);
        this.cashDiscount2Days = cashDiscount2Days;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount2Percent</b>
     * </p>
     *
     * @param cashDiscount2Percent
     *            Cash Discount Percentage 2
     */
    public void setCashDiscount2Percent( @Nullable final BigDecimal cashDiscount2Percent )
    {
        rememberChangedField("CashDiscount2Percent", this.cashDiscount2Percent);
        this.cashDiscount2Percent = cashDiscount2Percent;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_CePuCoDistrdContrPaytTrms";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("CentralPurchaseContract", getCentralPurchaseContract());
        result.put("ExtContractForPurg", getExtContractForPurg());
        result.put("ProcurementHubSourceSystem", getProcurementHubSourceSystem());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("CentralPurchaseContract", getCentralPurchaseContract());
        values.put("ExtContractForPurg", getExtContractForPurg());
        values.put("ProcurementHubSourceSystem", getProcurementHubSourceSystem());
        values.put("PaymentTerms", getPaymentTerms());
        values.put("NetPaymentDays", getNetPaymentDays());
        values.put("CashDiscount1Days", getCashDiscount1Days());
        values.put("CashDiscount1Percent", getCashDiscount1Percent());
        values.put("CashDiscount2Days", getCashDiscount2Days());
        values.put("CashDiscount2Percent", getCashDiscount2Percent());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CentralPurchaseContract") ) {
                final Object value = values.remove("CentralPurchaseContract");
                if( (value == null) || (!value.equals(getCentralPurchaseContract())) ) {
                    setCentralPurchaseContract(((String) value));
                }
            }
            if( values.containsKey("ExtContractForPurg") ) {
                final Object value = values.remove("ExtContractForPurg");
                if( (value == null) || (!value.equals(getExtContractForPurg())) ) {
                    setExtContractForPurg(((String) value));
                }
            }
            if( values.containsKey("ProcurementHubSourceSystem") ) {
                final Object value = values.remove("ProcurementHubSourceSystem");
                if( (value == null) || (!value.equals(getProcurementHubSourceSystem())) ) {
                    setProcurementHubSourceSystem(((String) value));
                }
            }
            if( values.containsKey("PaymentTerms") ) {
                final Object value = values.remove("PaymentTerms");
                if( (value == null) || (!value.equals(getPaymentTerms())) ) {
                    setPaymentTerms(((String) value));
                }
            }
            if( values.containsKey("NetPaymentDays") ) {
                final Object value = values.remove("NetPaymentDays");
                if( (value == null) || (!value.equals(getNetPaymentDays())) ) {
                    setNetPaymentDays(((BigDecimal) value));
                }
            }
            if( values.containsKey("CashDiscount1Days") ) {
                final Object value = values.remove("CashDiscount1Days");
                if( (value == null) || (!value.equals(getCashDiscount1Days())) ) {
                    setCashDiscount1Days(((BigDecimal) value));
                }
            }
            if( values.containsKey("CashDiscount1Percent") ) {
                final Object value = values.remove("CashDiscount1Percent");
                if( (value == null) || (!value.equals(getCashDiscount1Percent())) ) {
                    setCashDiscount1Percent(((BigDecimal) value));
                }
            }
            if( values.containsKey("CashDiscount2Days") ) {
                final Object value = values.remove("CashDiscount2Days");
                if( (value == null) || (!value.equals(getCashDiscount2Days())) ) {
                    setCashDiscount2Days(((BigDecimal) value));
                }
            }
            if( values.containsKey("CashDiscount2Percent") ) {
                final Object value = values.remove("CashDiscount2Percent");
                if( (value == null) || (!value.equals(getCashDiscount2Percent())) ) {
                    setCashDiscount2Percent(((BigDecimal) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> CePuCoDistrdContrPaytTrmsField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new CePuCoDistrdContrPaytTrmsField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CePuCoDistrdContrPaytTrmsField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CePuCoDistrdContrPaytTrmsField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.CentralPurchaseContractService.DEFAULT_SERVICE_PATH);
    }

}
