/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.field.CePuCoDistrdOutlineAgrmtField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.link.CePuCoDistrdOutlineAgrmtOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.selectable.CePuCoDistrdOutlineAgrmtSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Distributed Outline Agreement
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_CePuCoDistrdOutlineAgrmtType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CePuCoDistrdOutlineAgrmt extends VdmEntity<CePuCoDistrdOutlineAgrmt>
{

    /**
     * Selector for all available fields of CePuCoDistrdOutlineAgrmt.
     *
     */
    public final static CePuCoDistrdOutlineAgrmtSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CentralPurchaseContract</b>
     * </p>
     *
     * @return Purchasing Document Number
     */
    @Key
    @SerializedName( "CentralPurchaseContract" )
    @JsonProperty( "CentralPurchaseContract" )
    @Nullable
    @ODataField( odataName = "CentralPurchaseContract" )
    private String centralPurchaseContract;
    /**
     * Use with available fluent helpers to apply the <b>CentralPurchaseContract</b> field to query operations.
     *
     */
    public final static CePuCoDistrdOutlineAgrmtField<String> CENTRAL_PURCHASE_CONTRACT =
        new CePuCoDistrdOutlineAgrmtField<String>("CentralPurchaseContract");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ExtContractForPurg</b>
     * </p>
     *
     * @return Contract of External System
     */
    @Key
    @SerializedName( "ExtContractForPurg" )
    @JsonProperty( "ExtContractForPurg" )
    @Nullable
    @ODataField( odataName = "ExtContractForPurg" )
    private String extContractForPurg;
    /**
     * Use with available fluent helpers to apply the <b>ExtContractForPurg</b> field to query operations.
     *
     */
    public final static CePuCoDistrdOutlineAgrmtField<String> EXT_CONTRACT_FOR_PURG =
        new CePuCoDistrdOutlineAgrmtField<String>("ExtContractForPurg");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProcurementHubSourceSystem</b>
     * </p>
     *
     * @return Logical System
     */
    @Key
    @SerializedName( "ProcurementHubSourceSystem" )
    @JsonProperty( "ProcurementHubSourceSystem" )
    @Nullable
    @ODataField( odataName = "ProcurementHubSourceSystem" )
    private String procurementHubSourceSystem;
    /**
     * Use with available fluent helpers to apply the <b>ProcurementHubSourceSystem</b> field to query operations.
     *
     */
    public final static CePuCoDistrdOutlineAgrmtField<String> PROCUREMENT_HUB_SOURCE_SYSTEM =
        new CePuCoDistrdOutlineAgrmtField<String>("ProcurementHubSourceSystem");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @return Company Code
     */
    @SerializedName( "CompanyCode" )
    @JsonProperty( "CompanyCode" )
    @Nullable
    @ODataField( odataName = "CompanyCode" )
    private String companyCode;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCode</b> field to query operations.
     *
     */
    public final static CePuCoDistrdOutlineAgrmtField<String> COMPANY_CODE =
        new CePuCoDistrdOutlineAgrmtField<String>("CompanyCode");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingOrganization</b>
     * </p>
     *
     * @return Purchasing Organization
     */
    @SerializedName( "PurchasingOrganization" )
    @JsonProperty( "PurchasingOrganization" )
    @Nullable
    @ODataField( odataName = "PurchasingOrganization" )
    private String purchasingOrganization;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingOrganization</b> field to query operations.
     *
     */
    public final static CePuCoDistrdOutlineAgrmtField<String> PURCHASING_ORGANIZATION =
        new CePuCoDistrdOutlineAgrmtField<String>("PurchasingOrganization");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingGroup</b>
     * </p>
     *
     * @return Purchasing Group
     */
    @SerializedName( "PurchasingGroup" )
    @JsonProperty( "PurchasingGroup" )
    @Nullable
    @ODataField( odataName = "PurchasingGroup" )
    private String purchasingGroup;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingGroup</b> field to query operations.
     *
     */
    public final static CePuCoDistrdOutlineAgrmtField<String> PURCHASING_GROUP =
        new CePuCoDistrdOutlineAgrmtField<String>("PurchasingGroup");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PurgDocItemDistributionStatus</b>
     * </p>
     *
     * @return Distribution Status
     */
    @SerializedName( "PurgDocItemDistributionStatus" )
    @JsonProperty( "PurgDocItemDistributionStatus" )
    @Nullable
    @ODataField( odataName = "PurgDocItemDistributionStatus" )
    private String purgDocItemDistributionStatus;
    /**
     * Use with available fluent helpers to apply the <b>PurgDocItemDistributionStatus</b> field to query operations.
     *
     */
    public final static CePuCoDistrdOutlineAgrmtField<String> PURG_DOC_ITEM_DISTRIBUTION_STATUS =
        new CePuCoDistrdOutlineAgrmtField<String>("PurgDocItemDistributionStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SourceListIsUpdated</b>
     * </p>
     *
     * @return Sourcelist Updated
     */
    @SerializedName( "SourceListIsUpdated" )
    @JsonProperty( "SourceListIsUpdated" )
    @Nullable
    @ODataField( odataName = "SourceListIsUpdated" )
    private String sourceListIsUpdated;
    /**
     * Use with available fluent helpers to apply the <b>SourceListIsUpdated</b> field to query operations.
     *
     */
    public final static CePuCoDistrdOutlineAgrmtField<String> SOURCE_LIST_IS_UPDATED =
        new CePuCoDistrdOutlineAgrmtField<String>("SourceListIsUpdated");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SourceListChangeConfStatus</b>
     * </p>
     *
     * @return Source List Change Status
     */
    @SerializedName( "SourceListChangeConfStatus" )
    @JsonProperty( "SourceListChangeConfStatus" )
    @Nullable
    @ODataField( odataName = "SourceListChangeConfStatus" )
    private String sourceListChangeConfStatus;
    /**
     * Use with available fluent helpers to apply the <b>SourceListChangeConfStatus</b> field to query operations.
     *
     */
    public final static CePuCoDistrdOutlineAgrmtField<String> SOURCE_LIST_CHANGE_CONF_STATUS =
        new CePuCoDistrdOutlineAgrmtField<String>("SourceListChangeConfStatus");
    /**
     * Navigation property <b>to_CentralPurchaseContract</b> for <b>CePuCoDistrdOutlineAgrmt</b> to single
     * <b>CentralPurchaseContract</b>.
     *
     */
    @SerializedName( "to_CentralPurchaseContract" )
    @JsonProperty( "to_CentralPurchaseContract" )
    @ODataField( odataName = "to_CentralPurchaseContract" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private CentralPurchaseContract toCentralPurchaseContract;
    /**
     * Navigation property <b>to_DistributedPaymentTerms</b> for <b>CePuCoDistrdOutlineAgrmt</b> to single
     * <b>CePuCoDistrdContrPaytTrms</b>.
     *
     */
    @SerializedName( "to_DistributedPaymentTerms" )
    @JsonProperty( "to_DistributedPaymentTerms" )
    @ODataField( odataName = "to_DistributedPaymentTerms" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private CePuCoDistrdContrPaytTrms toDistributedPaymentTerms;
    /**
     * Use with available fluent helpers to apply the <b>to_CentralPurchaseContract</b> navigation property to query
     * operations.
     *
     */
    public final static CePuCoDistrdOutlineAgrmtOneToOneLink<CentralPurchaseContract> TO_CENTRAL_PURCHASE_CONTRACT =
        new CePuCoDistrdOutlineAgrmtOneToOneLink<CentralPurchaseContract>("to_CentralPurchaseContract");
    /**
     * Use with available fluent helpers to apply the <b>to_DistributedPaymentTerms</b> navigation property to query
     * operations.
     *
     */
    public final static CePuCoDistrdOutlineAgrmtOneToOneLink<CePuCoDistrdContrPaytTrms> TO_DISTRIBUTED_PAYMENT_TERMS =
        new CePuCoDistrdOutlineAgrmtOneToOneLink<CePuCoDistrdContrPaytTrms>("to_DistributedPaymentTerms");

    @Nonnull
    @Override
    public Class<CePuCoDistrdOutlineAgrmt> getType()
    {
        return CePuCoDistrdOutlineAgrmt.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CentralPurchaseContract</b>
     * </p>
     *
     * @param centralPurchaseContract
     *            Purchasing Document Number
     */
    public void setCentralPurchaseContract( @Nullable final String centralPurchaseContract )
    {
        rememberChangedField("CentralPurchaseContract", this.centralPurchaseContract);
        this.centralPurchaseContract = centralPurchaseContract;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ExtContractForPurg</b>
     * </p>
     *
     * @param extContractForPurg
     *            Contract of External System
     */
    public void setExtContractForPurg( @Nullable final String extContractForPurg )
    {
        rememberChangedField("ExtContractForPurg", this.extContractForPurg);
        this.extContractForPurg = extContractForPurg;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProcurementHubSourceSystem</b>
     * </p>
     *
     * @param procurementHubSourceSystem
     *            Logical System
     */
    public void setProcurementHubSourceSystem( @Nullable final String procurementHubSourceSystem )
    {
        rememberChangedField("ProcurementHubSourceSystem", this.procurementHubSourceSystem);
        this.procurementHubSourceSystem = procurementHubSourceSystem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @param companyCode
     *            Company Code
     */
    public void setCompanyCode( @Nullable final String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingOrganization</b>
     * </p>
     *
     * @param purchasingOrganization
     *            Purchasing Organization
     */
    public void setPurchasingOrganization( @Nullable final String purchasingOrganization )
    {
        rememberChangedField("PurchasingOrganization", this.purchasingOrganization);
        this.purchasingOrganization = purchasingOrganization;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingGroup</b>
     * </p>
     *
     * @param purchasingGroup
     *            Purchasing Group
     */
    public void setPurchasingGroup( @Nullable final String purchasingGroup )
    {
        rememberChangedField("PurchasingGroup", this.purchasingGroup);
        this.purchasingGroup = purchasingGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PurgDocItemDistributionStatus</b>
     * </p>
     *
     * @param purgDocItemDistributionStatus
     *            Distribution Status
     */
    public void setPurgDocItemDistributionStatus( @Nullable final String purgDocItemDistributionStatus )
    {
        rememberChangedField("PurgDocItemDistributionStatus", this.purgDocItemDistributionStatus);
        this.purgDocItemDistributionStatus = purgDocItemDistributionStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SourceListIsUpdated</b>
     * </p>
     *
     * @param sourceListIsUpdated
     *            Sourcelist Updated
     */
    public void setSourceListIsUpdated( @Nullable final String sourceListIsUpdated )
    {
        rememberChangedField("SourceListIsUpdated", this.sourceListIsUpdated);
        this.sourceListIsUpdated = sourceListIsUpdated;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SourceListChangeConfStatus</b>
     * </p>
     *
     * @param sourceListChangeConfStatus
     *            Source List Change Status
     */
    public void setSourceListChangeConfStatus( @Nullable final String sourceListChangeConfStatus )
    {
        rememberChangedField("SourceListChangeConfStatus", this.sourceListChangeConfStatus);
        this.sourceListChangeConfStatus = sourceListChangeConfStatus;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_CePuCoDistrdOutlineAgrmt";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("CentralPurchaseContract", getCentralPurchaseContract());
        result.put("ExtContractForPurg", getExtContractForPurg());
        result.put("ProcurementHubSourceSystem", getProcurementHubSourceSystem());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("CentralPurchaseContract", getCentralPurchaseContract());
        values.put("ExtContractForPurg", getExtContractForPurg());
        values.put("ProcurementHubSourceSystem", getProcurementHubSourceSystem());
        values.put("CompanyCode", getCompanyCode());
        values.put("PurchasingOrganization", getPurchasingOrganization());
        values.put("PurchasingGroup", getPurchasingGroup());
        values.put("PurgDocItemDistributionStatus", getPurgDocItemDistributionStatus());
        values.put("SourceListIsUpdated", getSourceListIsUpdated());
        values.put("SourceListChangeConfStatus", getSourceListChangeConfStatus());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CentralPurchaseContract") ) {
                final Object value = values.remove("CentralPurchaseContract");
                if( (value == null) || (!value.equals(getCentralPurchaseContract())) ) {
                    setCentralPurchaseContract(((String) value));
                }
            }
            if( values.containsKey("ExtContractForPurg") ) {
                final Object value = values.remove("ExtContractForPurg");
                if( (value == null) || (!value.equals(getExtContractForPurg())) ) {
                    setExtContractForPurg(((String) value));
                }
            }
            if( values.containsKey("ProcurementHubSourceSystem") ) {
                final Object value = values.remove("ProcurementHubSourceSystem");
                if( (value == null) || (!value.equals(getProcurementHubSourceSystem())) ) {
                    setProcurementHubSourceSystem(((String) value));
                }
            }
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((String) value));
                }
            }
            if( values.containsKey("PurchasingOrganization") ) {
                final Object value = values.remove("PurchasingOrganization");
                if( (value == null) || (!value.equals(getPurchasingOrganization())) ) {
                    setPurchasingOrganization(((String) value));
                }
            }
            if( values.containsKey("PurchasingGroup") ) {
                final Object value = values.remove("PurchasingGroup");
                if( (value == null) || (!value.equals(getPurchasingGroup())) ) {
                    setPurchasingGroup(((String) value));
                }
            }
            if( values.containsKey("PurgDocItemDistributionStatus") ) {
                final Object value = values.remove("PurgDocItemDistributionStatus");
                if( (value == null) || (!value.equals(getPurgDocItemDistributionStatus())) ) {
                    setPurgDocItemDistributionStatus(((String) value));
                }
            }
            if( values.containsKey("SourceListIsUpdated") ) {
                final Object value = values.remove("SourceListIsUpdated");
                if( (value == null) || (!value.equals(getSourceListIsUpdated())) ) {
                    setSourceListIsUpdated(((String) value));
                }
            }
            if( values.containsKey("SourceListChangeConfStatus") ) {
                final Object value = values.remove("SourceListChangeConfStatus");
                if( (value == null) || (!value.equals(getSourceListChangeConfStatus())) ) {
                    setSourceListChangeConfStatus(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CentralPurchaseContract") ) {
                final Object value = (values).remove("to_CentralPurchaseContract");
                if( value instanceof Map ) {
                    if( toCentralPurchaseContract == null ) {
                        toCentralPurchaseContract = new CentralPurchaseContract();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCentralPurchaseContract.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_DistributedPaymentTerms") ) {
                final Object value = (values).remove("to_DistributedPaymentTerms");
                if( value instanceof Map ) {
                    if( toDistributedPaymentTerms == null ) {
                        toDistributedPaymentTerms = new CePuCoDistrdContrPaytTrms();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toDistributedPaymentTerms.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> CePuCoDistrdOutlineAgrmtField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new CePuCoDistrdOutlineAgrmtField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CePuCoDistrdOutlineAgrmtField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CePuCoDistrdOutlineAgrmtField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.CentralPurchaseContractService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCentralPurchaseContract != null ) {
            (values).put("to_CentralPurchaseContract", toCentralPurchaseContract);
        }
        if( toDistributedPaymentTerms != null ) {
            (values).put("to_DistributedPaymentTerms", toDistributedPaymentTerms);
        }
        return values;
    }

    /**
     * Fetches the <b>CentralPurchaseContract</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_CentralPurchaseContract</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>CentralPurchaseContract</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public CentralPurchaseContract fetchCentralPurchaseContract()
    {
        return fetchFieldAsSingle("to_CentralPurchaseContract", CentralPurchaseContract.class);
    }

    /**
     * Retrieval of associated <b>CentralPurchaseContract</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_CentralPurchaseContract</b>.
     * <p>
     * If the navigation property <b>to_CentralPurchaseContract</b> of a queried <b>CePuCoDistrdOutlineAgrmt</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CentralPurchaseContract</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public CentralPurchaseContract getCentralPurchaseContractOrFetch()
    {
        if( toCentralPurchaseContract == null ) {
            toCentralPurchaseContract = fetchCentralPurchaseContract();
        }
        return toCentralPurchaseContract;
    }

    /**
     * Retrieval of associated <b>CentralPurchaseContract</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_CentralPurchaseContract</b>.
     * <p>
     * If the navigation property for an entity <b>CePuCoDistrdOutlineAgrmt</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CentralPurchaseContract</b> is already loaded, the
     *         result will contain the <b>CentralPurchaseContract</b> entity. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<CentralPurchaseContract> getCentralPurchaseContractIfPresent()
    {
        return Option.of(toCentralPurchaseContract);
    }

    /**
     * Overwrites the associated <b>CentralPurchaseContract</b> entity for the loaded navigation property
     * <b>to_CentralPurchaseContract</b>.
     *
     * @param value
     *            New <b>CentralPurchaseContract</b> entity.
     */
    public void setCentralPurchaseContract( final CentralPurchaseContract value )
    {
        toCentralPurchaseContract = value;
    }

    /**
     * Fetches the <b>CePuCoDistrdContrPaytTrms</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_DistributedPaymentTerms</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>CePuCoDistrdContrPaytTrms</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public CePuCoDistrdContrPaytTrms fetchDistributedPaymentTerms()
    {
        return fetchFieldAsSingle("to_DistributedPaymentTerms", CePuCoDistrdContrPaytTrms.class);
    }

    /**
     * Retrieval of associated <b>CePuCoDistrdContrPaytTrms</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_DistributedPaymentTerms</b>.
     * <p>
     * If the navigation property <b>to_DistributedPaymentTerms</b> of a queried <b>CePuCoDistrdOutlineAgrmt</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CePuCoDistrdContrPaytTrms</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public CePuCoDistrdContrPaytTrms getDistributedPaymentTermsOrFetch()
    {
        if( toDistributedPaymentTerms == null ) {
            toDistributedPaymentTerms = fetchDistributedPaymentTerms();
        }
        return toDistributedPaymentTerms;
    }

    /**
     * Retrieval of associated <b>CePuCoDistrdContrPaytTrms</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_DistributedPaymentTerms</b>.
     * <p>
     * If the navigation property for an entity <b>CePuCoDistrdOutlineAgrmt</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_DistributedPaymentTerms</b> is already loaded, the
     *         result will contain the <b>CePuCoDistrdContrPaytTrms</b> entity. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<CePuCoDistrdContrPaytTrms> getDistributedPaymentTermsIfPresent()
    {
        return Option.of(toDistributedPaymentTerms);
    }

    /**
     * Overwrites the associated <b>CePuCoDistrdContrPaytTrms</b> entity for the loaded navigation property
     * <b>to_DistributedPaymentTerms</b>.
     *
     * @param value
     *            New <b>CePuCoDistrdContrPaytTrms</b> entity.
     */
    public void setDistributedPaymentTerms( final CePuCoDistrdContrPaytTrms value )
    {
        toDistributedPaymentTerms = value;
    }

    /**
     * Helper class to allow for fluent creation of CePuCoDistrdOutlineAgrmt instances.
     *
     */
    public final static class CePuCoDistrdOutlineAgrmtBuilder
    {

        private CentralPurchaseContract toCentralPurchaseContract;
        private String centralPurchaseContract = null;
        private CePuCoDistrdContrPaytTrms toDistributedPaymentTerms;

        private CePuCoDistrdOutlineAgrmt.CePuCoDistrdOutlineAgrmtBuilder toCentralPurchaseContract(
            final CentralPurchaseContract value )
        {
            toCentralPurchaseContract = value;
            return this;
        }

        /**
         * Navigation property <b>to_CentralPurchaseContract</b> for <b>CePuCoDistrdOutlineAgrmt</b> to single
         * <b>CentralPurchaseContract</b>.
         *
         * @param value
         *            The CentralPurchaseContract to build this CePuCoDistrdOutlineAgrmt with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CePuCoDistrdOutlineAgrmt.CePuCoDistrdOutlineAgrmtBuilder centralPurchaseContract(
            final CentralPurchaseContract value )
        {
            return toCentralPurchaseContract(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 10
         * <p>
         * Original property name from the Odata EDM: <b>CentralPurchaseContract</b>
         * </p>
         *
         * @param value
         *            The centralPurchaseContract to build this CePuCoDistrdOutlineAgrmt with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CePuCoDistrdOutlineAgrmt.CePuCoDistrdOutlineAgrmtBuilder centralPurchaseContract( final String value )
        {
            centralPurchaseContract = value;
            return this;
        }

        private CePuCoDistrdOutlineAgrmt.CePuCoDistrdOutlineAgrmtBuilder toDistributedPaymentTerms(
            final CePuCoDistrdContrPaytTrms value )
        {
            toDistributedPaymentTerms = value;
            return this;
        }

        /**
         * Navigation property <b>to_DistributedPaymentTerms</b> for <b>CePuCoDistrdOutlineAgrmt</b> to single
         * <b>CePuCoDistrdContrPaytTrms</b>.
         *
         * @param value
         *            The CePuCoDistrdContrPaytTrms to build this CePuCoDistrdOutlineAgrmt with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CePuCoDistrdOutlineAgrmt.CePuCoDistrdOutlineAgrmtBuilder distributedPaymentTerms(
            final CePuCoDistrdContrPaytTrms value )
        {
            return toDistributedPaymentTerms(value);
        }

    }

}
