/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.selectable.CePuCoDistrdOutlineAgrmtSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CePuCoDistrdOutlineAgrmt
 * CePuCoDistrdOutlineAgrmt} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class CePuCoDistrdOutlineAgrmtByKeyFluentHelper
    extends
    FluentHelperByKey<CePuCoDistrdOutlineAgrmtByKeyFluentHelper, CePuCoDistrdOutlineAgrmt, CePuCoDistrdOutlineAgrmtSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CePuCoDistrdOutlineAgrmt
     * CePuCoDistrdOutlineAgrmt} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code CePuCoDistrdOutlineAgrmt}
     * @param centralPurchaseContract
     *            Purchasing Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param procurementHubSourceSystem
     *            Logical System
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code CePuCoDistrdOutlineAgrmt}
     * @param extContractForPurg
     *            Contract of External System
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     */
    public CePuCoDistrdOutlineAgrmtByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String centralPurchaseContract,
        final String extContractForPurg,
        final String procurementHubSourceSystem )
    {
        super(servicePath, entityCollection);
        this.key.put("CentralPurchaseContract", centralPurchaseContract);
        this.key.put("ExtContractForPurg", extContractForPurg);
        this.key.put("ProcurementHubSourceSystem", procurementHubSourceSystem);
    }

    @Override
    @Nonnull
    protected Class<CePuCoDistrdOutlineAgrmt> getEntityClass()
    {
        return CePuCoDistrdOutlineAgrmt.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
