/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.field.CentralPurchaseContractField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.link.CentralPurchaseContractLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.selectable.CentralPurchaseContractSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Central Purchase Contract
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_CentralPurchaseContractType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CentralPurchaseContract extends VdmEntity<CentralPurchaseContract>
{

    /**
     * Selector for all available fields of CentralPurchaseContract.
     *
     */
    public final static CentralPurchaseContractSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CentralPurchaseContract</b>
     * </p>
     *
     * @return Active Purchasing Document
     */
    @Key
    @SerializedName( "CentralPurchaseContract" )
    @JsonProperty( "CentralPurchaseContract" )
    @Nullable
    @ODataField( odataName = "CentralPurchaseContract" )
    private String centralPurchaseContract;
    /**
     * Use with available fluent helpers to apply the <b>CentralPurchaseContract</b> field to query operations.
     *
     */
    public final static CentralPurchaseContractField<String> CENTRAL_PURCHASE_CONTRACT =
        new CentralPurchaseContractField<String>("CentralPurchaseContract");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseContractType</b>
     * </p>
     *
     * @return Purchasing Document Type
     */
    @SerializedName( "PurchaseContractType" )
    @JsonProperty( "PurchaseContractType" )
    @Nullable
    @ODataField( odataName = "PurchaseContractType" )
    private String purchaseContractType;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseContractType</b> field to query operations.
     *
     */
    public final static CentralPurchaseContractField<String> PURCHASE_CONTRACT_TYPE =
        new CentralPurchaseContractField<String>("PurchaseContractType");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentCategory</b>
     * </p>
     *
     * @return Purchasing Document Category
     */
    @SerializedName( "PurchasingDocumentCategory" )
    @JsonProperty( "PurchasingDocumentCategory" )
    @Nullable
    @ODataField( odataName = "PurchasingDocumentCategory" )
    private String purchasingDocumentCategory;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingDocumentCategory</b> field to query operations.
     *
     */
    public final static CentralPurchaseContractField<String> PURCHASING_DOCUMENT_CATEGORY =
        new CentralPurchaseContractField<String>("PurchasingDocumentCategory");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentSubtype</b>
     * </p>
     *
     * @return Control indicator for purchasing document type
     */
    @SerializedName( "PurchasingDocumentSubtype" )
    @JsonProperty( "PurchasingDocumentSubtype" )
    @Nullable
    @ODataField( odataName = "PurchasingDocumentSubtype" )
    private String purchasingDocumentSubtype;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingDocumentSubtype</b> field to query operations.
     *
     */
    public final static CentralPurchaseContractField<String> PURCHASING_DOCUMENT_SUBTYPE =
        new CentralPurchaseContractField<String>("PurchasingDocumentSubtype");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @return Supplier
     */
    @SerializedName( "Supplier" )
    @JsonProperty( "Supplier" )
    @Nullable
    @ODataField( odataName = "Supplier" )
    private String supplier;
    /**
     * Use with available fluent helpers to apply the <b>Supplier</b> field to query operations.
     *
     */
    public final static CentralPurchaseContractField<String> SUPPLIER =
        new CentralPurchaseContractField<String>("Supplier");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @return Company Code
     */
    @SerializedName( "CompanyCode" )
    @JsonProperty( "CompanyCode" )
    @Nullable
    @ODataField( odataName = "CompanyCode" )
    private String companyCode;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCode</b> field to query operations.
     *
     */
    public final static CentralPurchaseContractField<String> COMPANY_CODE =
        new CentralPurchaseContractField<String>("CompanyCode");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingOrganization</b>
     * </p>
     *
     * @return Purchasing Organization
     */
    @SerializedName( "PurchasingOrganization" )
    @JsonProperty( "PurchasingOrganization" )
    @Nullable
    @ODataField( odataName = "PurchasingOrganization" )
    private String purchasingOrganization;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingOrganization</b> field to query operations.
     *
     */
    public final static CentralPurchaseContractField<String> PURCHASING_ORGANIZATION =
        new CentralPurchaseContractField<String>("PurchasingOrganization");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingGroup</b>
     * </p>
     *
     * @return Purchasing Group
     */
    @SerializedName( "PurchasingGroup" )
    @JsonProperty( "PurchasingGroup" )
    @Nullable
    @ODataField( odataName = "PurchasingGroup" )
    private String purchasingGroup;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingGroup</b> field to query operations.
     *
     */
    public final static CentralPurchaseContractField<String> PURCHASING_GROUP =
        new CentralPurchaseContractField<String>("PurchasingGroup");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @return Start of Validity Period
     */
    @SerializedName( "ValidityStartDate" )
    @JsonProperty( "ValidityStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityStartDate</b> field to query operations.
     *
     */
    public final static CentralPurchaseContractField<LocalDateTime> VALIDITY_START_DATE =
        new CentralPurchaseContractField<LocalDateTime>("ValidityStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @return End of Validity Period
     */
    @SerializedName( "ValidityEndDate" )
    @JsonProperty( "ValidityEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityEndDate</b> field to query operations.
     *
     */
    public final static CentralPurchaseContractField<LocalDateTime> VALIDITY_END_DATE =
        new CentralPurchaseContractField<LocalDateTime>("ValidityEndDate");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>DocumentCurrency</b>
     * </p>
     *
     * @return Currency Key
     */
    @SerializedName( "DocumentCurrency" )
    @JsonProperty( "DocumentCurrency" )
    @Nullable
    @ODataField( odataName = "DocumentCurrency" )
    private String documentCurrency;
    /**
     * Use with available fluent helpers to apply the <b>DocumentCurrency</b> field to query operations.
     *
     */
    public final static CentralPurchaseContractField<String> DOCUMENT_CURRENCY =
        new CentralPurchaseContractField<String>("DocumentCurrency");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @return Change Time Stamp
     */
    @SerializedName( "LastChangeDateTime" )
    @JsonProperty( "LastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime lastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDateTime</b> field to query operations.
     *
     */
    public final static CentralPurchaseContractField<ZonedDateTime> LAST_CHANGE_DATE_TIME =
        new CentralPurchaseContractField<ZonedDateTime>("LastChangeDateTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @return Creation Date of Purchasing Document
     */
    @SerializedName( "CreationDate" )
    @JsonProperty( "CreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime creationDate;
    /**
     * Use with available fluent helpers to apply the <b>CreationDate</b> field to query operations.
     *
     */
    public final static CentralPurchaseContractField<LocalDateTime> CREATION_DATE =
        new CentralPurchaseContractField<LocalDateTime>("CreationDate");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PaymentTerms</b>
     * </p>
     *
     * @return Terms of Payment Key
     */
    @SerializedName( "PaymentTerms" )
    @JsonProperty( "PaymentTerms" )
    @Nullable
    @ODataField( odataName = "PaymentTerms" )
    private String paymentTerms;
    /**
     * Use with available fluent helpers to apply the <b>PaymentTerms</b> field to query operations.
     *
     */
    public final static CentralPurchaseContractField<String> PAYMENT_TERMS =
        new CentralPurchaseContractField<String>("PaymentTerms");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount1Days</b>
     * </p>
     *
     * @return Cash discount days 1
     */
    @SerializedName( "CashDiscount1Days" )
    @JsonProperty( "CashDiscount1Days" )
    @Nullable
    @ODataField( odataName = "CashDiscount1Days" )
    private BigDecimal cashDiscount1Days;
    /**
     * Use with available fluent helpers to apply the <b>CashDiscount1Days</b> field to query operations.
     *
     */
    public final static CentralPurchaseContractField<BigDecimal> CASH_DISCOUNT1_DAYS =
        new CentralPurchaseContractField<BigDecimal>("CashDiscount1Days");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount2Days</b>
     * </p>
     *
     * @return Cash discount days 2
     */
    @SerializedName( "CashDiscount2Days" )
    @JsonProperty( "CashDiscount2Days" )
    @Nullable
    @ODataField( odataName = "CashDiscount2Days" )
    private BigDecimal cashDiscount2Days;
    /**
     * Use with available fluent helpers to apply the <b>CashDiscount2Days</b> field to query operations.
     *
     */
    public final static CentralPurchaseContractField<BigDecimal> CASH_DISCOUNT2_DAYS =
        new CentralPurchaseContractField<BigDecimal>("CashDiscount2Days");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount1Percent</b>
     * </p>
     *
     * @return Cash Discount Percentage 1
     */
    @SerializedName( "CashDiscount1Percent" )
    @JsonProperty( "CashDiscount1Percent" )
    @Nullable
    @ODataField( odataName = "CashDiscount1Percent" )
    private BigDecimal cashDiscount1Percent;
    /**
     * Use with available fluent helpers to apply the <b>CashDiscount1Percent</b> field to query operations.
     *
     */
    public final static CentralPurchaseContractField<BigDecimal> CASH_DISCOUNT1_PERCENT =
        new CentralPurchaseContractField<BigDecimal>("CashDiscount1Percent");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount2Percent</b>
     * </p>
     *
     * @return Cash Discount Percentage 2
     */
    @SerializedName( "CashDiscount2Percent" )
    @JsonProperty( "CashDiscount2Percent" )
    @Nullable
    @ODataField( odataName = "CashDiscount2Percent" )
    private BigDecimal cashDiscount2Percent;
    /**
     * Use with available fluent helpers to apply the <b>CashDiscount2Percent</b> field to query operations.
     *
     */
    public final static CentralPurchaseContractField<BigDecimal> CASH_DISCOUNT2_PERCENT =
        new CentralPurchaseContractField<BigDecimal>("CashDiscount2Percent");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>NetPaymentDays</b>
     * </p>
     *
     * @return Net Payment Terms Period
     */
    @SerializedName( "NetPaymentDays" )
    @JsonProperty( "NetPaymentDays" )
    @Nullable
    @ODataField( odataName = "NetPaymentDays" )
    private BigDecimal netPaymentDays;
    /**
     * Use with available fluent helpers to apply the <b>NetPaymentDays</b> field to query operations.
     *
     */
    public final static CentralPurchaseContractField<BigDecimal> NET_PAYMENT_DAYS =
        new CentralPurchaseContractField<BigDecimal>("NetPaymentDays");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsClassification</b>
     * </p>
     *
     * @return Incoterms (Part 1)
     */
    @SerializedName( "IncotermsClassification" )
    @JsonProperty( "IncotermsClassification" )
    @Nullable
    @ODataField( odataName = "IncotermsClassification" )
    private String incotermsClassification;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsClassification</b> field to query operations.
     *
     */
    public final static CentralPurchaseContractField<String> INCOTERMS_CLASSIFICATION =
        new CentralPurchaseContractField<String>("IncotermsClassification");
    /**
     * Constraints: Not nullable, Maximum length: 28
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsTransferLocation</b>
     * </p>
     *
     * @return Incoterms (Part 2)
     */
    @SerializedName( "IncotermsTransferLocation" )
    @JsonProperty( "IncotermsTransferLocation" )
    @Nullable
    @ODataField( odataName = "IncotermsTransferLocation" )
    private String incotermsTransferLocation;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsTransferLocation</b> field to query operations.
     *
     */
    public final static CentralPurchaseContractField<String> INCOTERMS_TRANSFER_LOCATION =
        new CentralPurchaseContractField<String>("IncotermsTransferLocation");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsVersion</b>
     * </p>
     *
     * @return Incoterms Version
     */
    @SerializedName( "IncotermsVersion" )
    @JsonProperty( "IncotermsVersion" )
    @Nullable
    @ODataField( odataName = "IncotermsVersion" )
    private String incotermsVersion;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsVersion</b> field to query operations.
     *
     */
    public final static CentralPurchaseContractField<String> INCOTERMS_VERSION =
        new CentralPurchaseContractField<String>("IncotermsVersion");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation1</b>
     * </p>
     *
     * @return Incoterms Location 1
     */
    @SerializedName( "IncotermsLocation1" )
    @JsonProperty( "IncotermsLocation1" )
    @Nullable
    @ODataField( odataName = "IncotermsLocation1" )
    private String incotermsLocation1;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsLocation1</b> field to query operations.
     *
     */
    public final static CentralPurchaseContractField<String> INCOTERMS_LOCATION1 =
        new CentralPurchaseContractField<String>("IncotermsLocation1");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation2</b>
     * </p>
     *
     * @return Incoterms Location 2
     */
    @SerializedName( "IncotermsLocation2" )
    @JsonProperty( "IncotermsLocation2" )
    @Nullable
    @ODataField( odataName = "IncotermsLocation2" )
    private String incotermsLocation2;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsLocation2</b> field to query operations.
     *
     */
    public final static CentralPurchaseContractField<String> INCOTERMS_LOCATION2 =
        new CentralPurchaseContractField<String>("IncotermsLocation2");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseContractTargetAmount</b>
     * </p>
     *
     * @return Target Value for Header Area per Distribution
     */
    @SerializedName( "PurchaseContractTargetAmount" )
    @JsonProperty( "PurchaseContractTargetAmount" )
    @Nullable
    @ODataField( odataName = "PurchaseContractTargetAmount" )
    private BigDecimal purchaseContractTargetAmount;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseContractTargetAmount</b> field to query operations.
     *
     */
    public final static CentralPurchaseContractField<BigDecimal> PURCHASE_CONTRACT_TARGET_AMOUNT =
        new CentralPurchaseContractField<BigDecimal>("PurchaseContractTargetAmount");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ExchangeRate</b>
     * </p>
     *
     * @return The exchangeRate contained in this entity.
     */
    @SerializedName( "ExchangeRate" )
    @JsonProperty( "ExchangeRate" )
    @Nullable
    @ODataField( odataName = "ExchangeRate" )
    private String exchangeRate;
    /**
     * Use with available fluent helpers to apply the <b>ExchangeRate</b> field to query operations.
     *
     */
    public final static CentralPurchaseContractField<String> EXCHANGE_RATE =
        new CentralPurchaseContractField<String>("ExchangeRate");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ExchangeRateIsFixed</b>
     * </p>
     *
     * @return Indicator for Fixed Exchange Rate
     */
    @SerializedName( "ExchangeRateIsFixed" )
    @JsonProperty( "ExchangeRateIsFixed" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ExchangeRateIsFixed" )
    private Boolean exchangeRateIsFixed;
    /**
     * Use with available fluent helpers to apply the <b>ExchangeRateIsFixed</b> field to query operations.
     *
     */
    public final static CentralPurchaseContractField<Boolean> EXCHANGE_RATE_IS_FIXED =
        new CentralPurchaseContractField<Boolean>("ExchangeRateIsFixed");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SupplyingSupplier</b>
     * </p>
     *
     * @return Goods Supplier
     */
    @SerializedName( "SupplyingSupplier" )
    @JsonProperty( "SupplyingSupplier" )
    @Nullable
    @ODataField( odataName = "SupplyingSupplier" )
    private String supplyingSupplier;
    /**
     * Use with available fluent helpers to apply the <b>SupplyingSupplier</b> field to query operations.
     *
     */
    public final static CentralPurchaseContractField<String> SUPPLYING_SUPPLIER =
        new CentralPurchaseContractField<String>("SupplyingSupplier");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>QuotationSubmissionDate</b>
     * </p>
     *
     * @return Quotation Submission Date
     */
    @SerializedName( "QuotationSubmissionDate" )
    @JsonProperty( "QuotationSubmissionDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "QuotationSubmissionDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime quotationSubmissionDate;
    /**
     * Use with available fluent helpers to apply the <b>QuotationSubmissionDate</b> field to query operations.
     *
     */
    public final static CentralPurchaseContractField<LocalDateTime> QUOTATION_SUBMISSION_DATE =
        new CentralPurchaseContractField<LocalDateTime>("QuotationSubmissionDate");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SupplierQuotation</b>
     * </p>
     *
     * @return Quotation Number
     */
    @SerializedName( "SupplierQuotation" )
    @JsonProperty( "SupplierQuotation" )
    @Nullable
    @ODataField( odataName = "SupplierQuotation" )
    private String supplierQuotation;
    /**
     * Use with available fluent helpers to apply the <b>SupplierQuotation</b> field to query operations.
     *
     */
    public final static CentralPurchaseContractField<String> SUPPLIER_QUOTATION =
        new CentralPurchaseContractField<String>("SupplierQuotation");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CorrespncExternalReference</b>
     * </p>
     *
     * @return Your Reference
     */
    @SerializedName( "CorrespncExternalReference" )
    @JsonProperty( "CorrespncExternalReference" )
    @Nullable
    @ODataField( odataName = "CorrespncExternalReference" )
    private String correspncExternalReference;
    /**
     * Use with available fluent helpers to apply the <b>CorrespncExternalReference</b> field to query operations.
     *
     */
    public final static CentralPurchaseContractField<String> CORRESPNC_EXTERNAL_REFERENCE =
        new CentralPurchaseContractField<String>("CorrespncExternalReference");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CorrespncInternalReference</b>
     * </p>
     *
     * @return Our Reference
     */
    @SerializedName( "CorrespncInternalReference" )
    @JsonProperty( "CorrespncInternalReference" )
    @Nullable
    @ODataField( odataName = "CorrespncInternalReference" )
    private String correspncInternalReference;
    /**
     * Use with available fluent helpers to apply the <b>CorrespncInternalReference</b> field to query operations.
     *
     */
    public final static CentralPurchaseContractField<String> CORRESPNC_INTERNAL_REFERENCE =
        new CentralPurchaseContractField<String>("CorrespncInternalReference");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>SupplierRespSalesPersonName</b>
     * </p>
     *
     * @return Responsible Salesperson at Supplier's Office
     */
    @SerializedName( "SupplierRespSalesPersonName" )
    @JsonProperty( "SupplierRespSalesPersonName" )
    @Nullable
    @ODataField( odataName = "SupplierRespSalesPersonName" )
    private String supplierRespSalesPersonName;
    /**
     * Use with available fluent helpers to apply the <b>SupplierRespSalesPersonName</b> field to query operations.
     *
     */
    public final static CentralPurchaseContractField<String> SUPPLIER_RESP_SALES_PERSON_NAME =
        new CentralPurchaseContractField<String>("SupplierRespSalesPersonName");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>SupplierPhoneNumber</b>
     * </p>
     *
     * @return Supplier's Phone Number
     */
    @SerializedName( "SupplierPhoneNumber" )
    @JsonProperty( "SupplierPhoneNumber" )
    @Nullable
    @ODataField( odataName = "SupplierPhoneNumber" )
    private String supplierPhoneNumber;
    /**
     * Use with available fluent helpers to apply the <b>SupplierPhoneNumber</b> field to query operations.
     *
     */
    public final static CentralPurchaseContractField<String> SUPPLIER_PHONE_NUMBER =
        new CentralPurchaseContractField<String>("SupplierPhoneNumber");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ReleaseCode</b>
     * </p>
     *
     * @return Release Indicator: Purchasing Document
     */
    @SerializedName( "ReleaseCode" )
    @JsonProperty( "ReleaseCode" )
    @Nullable
    @ODataField( odataName = "ReleaseCode" )
    private String releaseCode;
    /**
     * Use with available fluent helpers to apply the <b>ReleaseCode</b> field to query operations.
     *
     */
    public final static CentralPurchaseContractField<String> RELEASE_CODE =
        new CentralPurchaseContractField<String>("ReleaseCode");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentName</b>
     * </p>
     *
     * @return Name of Purchasing Document
     */
    @SerializedName( "PurchasingDocumentName" )
    @JsonProperty( "PurchasingDocumentName" )
    @Nullable
    @ODataField( odataName = "PurchasingDocumentName" )
    private String purchasingDocumentName;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingDocumentName</b> field to query operations.
     *
     */
    public final static CentralPurchaseContractField<String> PURCHASING_DOCUMENT_NAME =
        new CentralPurchaseContractField<String>("PurchasingDocumentName");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return User of person who created a purchasing document
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static CentralPurchaseContractField<String> CREATED_BY_USER =
        new CentralPurchaseContractField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentDeletionCode</b>
     * </p>
     *
     * @return Deletion Indicator in Purchasing Document
     */
    @SerializedName( "PurchasingDocumentDeletionCode" )
    @JsonProperty( "PurchasingDocumentDeletionCode" )
    @Nullable
    @ODataField( odataName = "PurchasingDocumentDeletionCode" )
    private String purchasingDocumentDeletionCode;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingDocumentDeletionCode</b> field to query operations.
     *
     */
    public final static CentralPurchaseContractField<String> PURCHASING_DOCUMENT_DELETION_CODE =
        new CentralPurchaseContractField<String>("PurchasingDocumentDeletionCode");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingProcessingStatus</b>
     * </p>
     *
     * @return Purchasing Document Processing State
     */
    @SerializedName( "PurchasingProcessingStatus" )
    @JsonProperty( "PurchasingProcessingStatus" )
    @Nullable
    @ODataField( odataName = "PurchasingProcessingStatus" )
    private String purchasingProcessingStatus;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingProcessingStatus</b> field to query operations.
     *
     */
    public final static CentralPurchaseContractField<String> PURCHASING_PROCESSING_STATUS =
        new CentralPurchaseContractField<String>("PurchasingProcessingStatus");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CntrlPurContrDistributionSts</b>
     * </p>
     *
     * @return The cntrlPurContrDistributionSts contained in this entity.
     */
    @SerializedName( "CntrlPurContrDistributionSts" )
    @JsonProperty( "CntrlPurContrDistributionSts" )
    @Nullable
    @ODataField( odataName = "CntrlPurContrDistributionSts" )
    private String cntrlPurContrDistributionSts;
    /**
     * Use with available fluent helpers to apply the <b>CntrlPurContrDistributionSts</b> field to query operations.
     *
     */
    public final static CentralPurchaseContractField<String> CNTRL_PUR_CONTR_DISTRIBUTION_STS =
        new CentralPurchaseContractField<String>("CntrlPurContrDistributionSts");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PurgContractIsInPreparation</b>
     * </p>
     *
     * @return Boolean Variable (X = True, - = False, Space = Unknown)
     */
    @SerializedName( "PurgContractIsInPreparation" )
    @JsonProperty( "PurgContractIsInPreparation" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "PurgContractIsInPreparation" )
    private Boolean purgContractIsInPreparation;
    /**
     * Use with available fluent helpers to apply the <b>PurgContractIsInPreparation</b> field to query operations.
     *
     */
    public final static CentralPurchaseContractField<Boolean> PURG_CONTRACT_IS_IN_PREPARATION =
        new CentralPurchaseContractField<Boolean>("PurgContractIsInPreparation");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocVersionReasonCode</b>
     * </p>
     *
     * @return Reason for change
     */
    @SerializedName( "PurchasingDocVersionReasonCode" )
    @JsonProperty( "PurchasingDocVersionReasonCode" )
    @Nullable
    @ODataField( odataName = "PurchasingDocVersionReasonCode" )
    private String purchasingDocVersionReasonCode;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingDocVersionReasonCode</b> field to query operations.
     *
     */
    public final static CentralPurchaseContractField<String> PURCHASING_DOC_VERSION_REASON_CODE =
        new CentralPurchaseContractField<String>("PurchasingDocVersionReasonCode");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CntrlPurContrFlxblDistrIsAllwd</b>
     * </p>
     *
     * @return Boolean Variable (X = True, - = False, Space = Unknown)
     */
    @SerializedName( "CntrlPurContrFlxblDistrIsAllwd" )
    @JsonProperty( "CntrlPurContrFlxblDistrIsAllwd" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "CntrlPurContrFlxblDistrIsAllwd" )
    private Boolean cntrlPurContrFlxblDistrIsAllwd;
    /**
     * Use with available fluent helpers to apply the <b>CntrlPurContrFlxblDistrIsAllwd</b> field to query operations.
     *
     */
    public final static CentralPurchaseContractField<Boolean> CNTRL_PUR_CONTR_FLXBL_DISTR_IS_ALLWD =
        new CentralPurchaseContractField<Boolean>("CntrlPurContrFlxblDistrIsAllwd");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentVersion</b>
     * </p>
     *
     * @return Version number in Purchasing
     */
    @SerializedName( "PurchasingDocumentVersion" )
    @JsonProperty( "PurchasingDocumentVersion" )
    @Nullable
    @ODataField( odataName = "PurchasingDocumentVersion" )
    private String purchasingDocumentVersion;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingDocumentVersion</b> field to query operations.
     *
     */
    public final static CentralPurchaseContractField<String> PURCHASING_DOCUMENT_VERSION =
        new CentralPurchaseContractField<String>("PurchasingDocumentVersion");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PurgDocIsChgVers</b>
     * </p>
     *
     * @return Checkbox
     */
    @SerializedName( "PurgDocIsChgVers" )
    @JsonProperty( "PurgDocIsChgVers" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "PurgDocIsChgVers" )
    private Boolean purgDocIsChgVers;
    /**
     * Use with available fluent helpers to apply the <b>PurgDocIsChgVers</b> field to query operations.
     *
     */
    public final static CentralPurchaseContractField<Boolean> PURG_DOC_IS_CHG_VERS =
        new CentralPurchaseContractField<Boolean>("PurgDocIsChgVers");
    /**
     * Navigation property <b>to_CentralPurchaseContractItem</b> for <b>CentralPurchaseContract</b> to multiple
     * <b>CntrlPurchaseContractItem</b>.
     *
     */
    @SerializedName( "to_CentralPurchaseContractItem" )
    @JsonProperty( "to_CentralPurchaseContractItem" )
    @ODataField( odataName = "to_CentralPurchaseContractItem" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<CntrlPurchaseContractItem> toCentralPurchaseContractItem;
    /**
     * Navigation property <b>to_CntrlContrHdrDistribution</b> for <b>CentralPurchaseContract</b> to multiple
     * <b>CntrlPurContrHdrDistribution</b>.
     *
     */
    @SerializedName( "to_CntrlContrHdrDistribution" )
    @JsonProperty( "to_CntrlContrHdrDistribution" )
    @ODataField( odataName = "to_CntrlContrHdrDistribution" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<CntrlPurContrHdrDistribution> toCntrlContrHdrDistribution;
    /**
     * Navigation property <b>to_CntrlPurContrDistrMessages</b> for <b>CentralPurchaseContract</b> to multiple
     * <b>CntrlPurContrDistrMessages</b>.
     *
     */
    @SerializedName( "to_CntrlPurContrDistrMessages" )
    @JsonProperty( "to_CntrlPurContrDistrMessages" )
    @ODataField( odataName = "to_CntrlPurContrDistrMessages" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<CntrlPurContrDistrMessages> toCntrlPurContrDistrMessages;
    /**
     * Navigation property <b>to_CntrlPurContrHdrCndnValdty</b> for <b>CentralPurchaseContract</b> to multiple
     * <b>CntrlPurContrHdrCndnValdty</b>.
     *
     */
    @SerializedName( "to_CntrlPurContrHdrCndnValdty" )
    @JsonProperty( "to_CntrlPurContrHdrCndnValdty" )
    @ODataField( odataName = "to_CntrlPurContrHdrCndnValdty" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<CntrlPurContrHdrCndnValdty> toCntrlPurContrHdrCndnValdty;
    /**
     * Navigation property <b>to_CntrlPurContrHdrNotes</b> for <b>CentralPurchaseContract</b> to multiple
     * <b>CntrlPurContractHeaderNotes</b>.
     *
     */
    @SerializedName( "to_CntrlPurContrHdrNotes" )
    @JsonProperty( "to_CntrlPurContrHdrNotes" )
    @ODataField( odataName = "to_CntrlPurContrHdrNotes" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<CntrlPurContractHeaderNotes> toCntrlPurContrHdrNotes;
    /**
     * Navigation property <b>to_CntrlPurContrVersionHistory</b> for <b>CentralPurchaseContract</b> to multiple
     * <b>CntrlPurContrVersionHistory</b>.
     *
     */
    @SerializedName( "to_CntrlPurContrVersionHistory" )
    @JsonProperty( "to_CntrlPurContrVersionHistory" )
    @ODataField( odataName = "to_CntrlPurContrVersionHistory" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<CntrlPurContrVersionHistory> toCntrlPurContrVersionHistory;
    /**
     * Navigation property <b>to_DistributedOutlineAgreement</b> for <b>CentralPurchaseContract</b> to multiple
     * <b>CePuCoDistrdOutlineAgrmt</b>.
     *
     */
    @SerializedName( "to_DistributedOutlineAgreement" )
    @JsonProperty( "to_DistributedOutlineAgreement" )
    @ODataField( odataName = "to_DistributedOutlineAgreement" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<CePuCoDistrdOutlineAgrmt> toDistributedOutlineAgreement;
    /**
     * Navigation property <b>to_LegalTransaction</b> for <b>CentralPurchaseContract</b> to multiple
     * <b>CntrlPurContrLegalTrans</b>.
     *
     */
    @SerializedName( "to_LegalTransaction" )
    @JsonProperty( "to_LegalTransaction" )
    @ODataField( odataName = "to_LegalTransaction" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<CntrlPurContrLegalTrans> toLegalTransaction;
    /**
     * Navigation property <b>to_SubordinateCntrlContract</b> for <b>CentralPurchaseContract</b> to multiple
     * <b>SubordinateCntrlContract</b>.
     *
     */
    @SerializedName( "to_SubordinateCntrlContract" )
    @JsonProperty( "to_SubordinateCntrlContract" )
    @ODataField( odataName = "to_SubordinateCntrlContract" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SubordinateCntrlContract> toSubordinateCntrlContract;
    /**
     * Use with available fluent helpers to apply the <b>to_CentralPurchaseContractItem</b> navigation property to query
     * operations.
     *
     */
    public final static CentralPurchaseContractLink<CntrlPurchaseContractItem> TO_CENTRAL_PURCHASE_CONTRACT_ITEM =
        new CentralPurchaseContractLink<CntrlPurchaseContractItem>("to_CentralPurchaseContractItem");
    /**
     * Use with available fluent helpers to apply the <b>to_CntrlContrHdrDistribution</b> navigation property to query
     * operations.
     *
     */
    public final static CentralPurchaseContractLink<CntrlPurContrHdrDistribution> TO_CNTRL_CONTR_HDR_DISTRIBUTION =
        new CentralPurchaseContractLink<CntrlPurContrHdrDistribution>("to_CntrlContrHdrDistribution");
    /**
     * Use with available fluent helpers to apply the <b>to_CntrlPurContrDistrMessages</b> navigation property to query
     * operations.
     *
     */
    public final static CentralPurchaseContractLink<CntrlPurContrDistrMessages> TO_CNTRL_PUR_CONTR_DISTR_MESSAGES =
        new CentralPurchaseContractLink<CntrlPurContrDistrMessages>("to_CntrlPurContrDistrMessages");
    /**
     * Use with available fluent helpers to apply the <b>to_CntrlPurContrHdrCndnValdty</b> navigation property to query
     * operations.
     *
     */
    public final static CentralPurchaseContractLink<CntrlPurContrHdrCndnValdty> TO_CNTRL_PUR_CONTR_HDR_CNDN_VALDTY =
        new CentralPurchaseContractLink<CntrlPurContrHdrCndnValdty>("to_CntrlPurContrHdrCndnValdty");
    /**
     * Use with available fluent helpers to apply the <b>to_CntrlPurContrHdrNotes</b> navigation property to query
     * operations.
     *
     */
    public final static CentralPurchaseContractLink<CntrlPurContractHeaderNotes> TO_CNTRL_PUR_CONTR_HDR_NOTES =
        new CentralPurchaseContractLink<CntrlPurContractHeaderNotes>("to_CntrlPurContrHdrNotes");
    /**
     * Use with available fluent helpers to apply the <b>to_CntrlPurContrVersionHistory</b> navigation property to query
     * operations.
     *
     */
    public final static CentralPurchaseContractLink<CntrlPurContrVersionHistory> TO_CNTRL_PUR_CONTR_VERSION_HISTORY =
        new CentralPurchaseContractLink<CntrlPurContrVersionHistory>("to_CntrlPurContrVersionHistory");
    /**
     * Use with available fluent helpers to apply the <b>to_DistributedOutlineAgreement</b> navigation property to query
     * operations.
     *
     */
    public final static CentralPurchaseContractLink<CePuCoDistrdOutlineAgrmt> TO_DISTRIBUTED_OUTLINE_AGREEMENT =
        new CentralPurchaseContractLink<CePuCoDistrdOutlineAgrmt>("to_DistributedOutlineAgreement");
    /**
     * Use with available fluent helpers to apply the <b>to_LegalTransaction</b> navigation property to query
     * operations.
     *
     */
    public final static CentralPurchaseContractLink<CntrlPurContrLegalTrans> TO_LEGAL_TRANSACTION =
        new CentralPurchaseContractLink<CntrlPurContrLegalTrans>("to_LegalTransaction");
    /**
     * Use with available fluent helpers to apply the <b>to_SubordinateCntrlContract</b> navigation property to query
     * operations.
     *
     */
    public final static CentralPurchaseContractLink<SubordinateCntrlContract> TO_SUBORDINATE_CNTRL_CONTRACT =
        new CentralPurchaseContractLink<SubordinateCntrlContract>("to_SubordinateCntrlContract");

    @Nonnull
    @Override
    public Class<CentralPurchaseContract> getType()
    {
        return CentralPurchaseContract.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CentralPurchaseContract</b>
     * </p>
     *
     * @param centralPurchaseContract
     *            Active Purchasing Document
     */
    public void setCentralPurchaseContract( @Nullable final String centralPurchaseContract )
    {
        rememberChangedField("CentralPurchaseContract", this.centralPurchaseContract);
        this.centralPurchaseContract = centralPurchaseContract;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseContractType</b>
     * </p>
     *
     * @param purchaseContractType
     *            Purchasing Document Type
     */
    public void setPurchaseContractType( @Nullable final String purchaseContractType )
    {
        rememberChangedField("PurchaseContractType", this.purchaseContractType);
        this.purchaseContractType = purchaseContractType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentCategory</b>
     * </p>
     *
     * @param purchasingDocumentCategory
     *            Purchasing Document Category
     */
    public void setPurchasingDocumentCategory( @Nullable final String purchasingDocumentCategory )
    {
        rememberChangedField("PurchasingDocumentCategory", this.purchasingDocumentCategory);
        this.purchasingDocumentCategory = purchasingDocumentCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentSubtype</b>
     * </p>
     *
     * @param purchasingDocumentSubtype
     *            Control indicator for purchasing document type
     */
    public void setPurchasingDocumentSubtype( @Nullable final String purchasingDocumentSubtype )
    {
        rememberChangedField("PurchasingDocumentSubtype", this.purchasingDocumentSubtype);
        this.purchasingDocumentSubtype = purchasingDocumentSubtype;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @param supplier
     *            Supplier
     */
    public void setSupplier( @Nullable final String supplier )
    {
        rememberChangedField("Supplier", this.supplier);
        this.supplier = supplier;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @param companyCode
     *            Company Code
     */
    public void setCompanyCode( @Nullable final String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingOrganization</b>
     * </p>
     *
     * @param purchasingOrganization
     *            Purchasing Organization
     */
    public void setPurchasingOrganization( @Nullable final String purchasingOrganization )
    {
        rememberChangedField("PurchasingOrganization", this.purchasingOrganization);
        this.purchasingOrganization = purchasingOrganization;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingGroup</b>
     * </p>
     *
     * @param purchasingGroup
     *            Purchasing Group
     */
    public void setPurchasingGroup( @Nullable final String purchasingGroup )
    {
        rememberChangedField("PurchasingGroup", this.purchasingGroup);
        this.purchasingGroup = purchasingGroup;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @param validityStartDate
     *            Start of Validity Period
     */
    public void setValidityStartDate( @Nullable final LocalDateTime validityStartDate )
    {
        rememberChangedField("ValidityStartDate", this.validityStartDate);
        this.validityStartDate = validityStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @param validityEndDate
     *            End of Validity Period
     */
    public void setValidityEndDate( @Nullable final LocalDateTime validityEndDate )
    {
        rememberChangedField("ValidityEndDate", this.validityEndDate);
        this.validityEndDate = validityEndDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>DocumentCurrency</b>
     * </p>
     *
     * @param documentCurrency
     *            Currency Key
     */
    public void setDocumentCurrency( @Nullable final String documentCurrency )
    {
        rememberChangedField("DocumentCurrency", this.documentCurrency);
        this.documentCurrency = documentCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @param lastChangeDateTime
     *            Change Time Stamp
     */
    public void setLastChangeDateTime( @Nullable final ZonedDateTime lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @param creationDate
     *            Creation Date of Purchasing Document
     */
    public void setCreationDate( @Nullable final LocalDateTime creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PaymentTerms</b>
     * </p>
     *
     * @param paymentTerms
     *            Terms of Payment Key
     */
    public void setPaymentTerms( @Nullable final String paymentTerms )
    {
        rememberChangedField("PaymentTerms", this.paymentTerms);
        this.paymentTerms = paymentTerms;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount1Days</b>
     * </p>
     *
     * @param cashDiscount1Days
     *            Cash discount days 1
     */
    public void setCashDiscount1Days( @Nullable final BigDecimal cashDiscount1Days )
    {
        rememberChangedField("CashDiscount1Days", this.cashDiscount1Days);
        this.cashDiscount1Days = cashDiscount1Days;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount2Days</b>
     * </p>
     *
     * @param cashDiscount2Days
     *            Cash discount days 2
     */
    public void setCashDiscount2Days( @Nullable final BigDecimal cashDiscount2Days )
    {
        rememberChangedField("CashDiscount2Days", this.cashDiscount2Days);
        this.cashDiscount2Days = cashDiscount2Days;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount1Percent</b>
     * </p>
     *
     * @param cashDiscount1Percent
     *            Cash Discount Percentage 1
     */
    public void setCashDiscount1Percent( @Nullable final BigDecimal cashDiscount1Percent )
    {
        rememberChangedField("CashDiscount1Percent", this.cashDiscount1Percent);
        this.cashDiscount1Percent = cashDiscount1Percent;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount2Percent</b>
     * </p>
     *
     * @param cashDiscount2Percent
     *            Cash Discount Percentage 2
     */
    public void setCashDiscount2Percent( @Nullable final BigDecimal cashDiscount2Percent )
    {
        rememberChangedField("CashDiscount2Percent", this.cashDiscount2Percent);
        this.cashDiscount2Percent = cashDiscount2Percent;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>NetPaymentDays</b>
     * </p>
     *
     * @param netPaymentDays
     *            Net Payment Terms Period
     */
    public void setNetPaymentDays( @Nullable final BigDecimal netPaymentDays )
    {
        rememberChangedField("NetPaymentDays", this.netPaymentDays);
        this.netPaymentDays = netPaymentDays;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsClassification</b>
     * </p>
     *
     * @param incotermsClassification
     *            Incoterms (Part 1)
     */
    public void setIncotermsClassification( @Nullable final String incotermsClassification )
    {
        rememberChangedField("IncotermsClassification", this.incotermsClassification);
        this.incotermsClassification = incotermsClassification;
    }

    /**
     * Constraints: Not nullable, Maximum length: 28
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsTransferLocation</b>
     * </p>
     *
     * @param incotermsTransferLocation
     *            Incoterms (Part 2)
     */
    public void setIncotermsTransferLocation( @Nullable final String incotermsTransferLocation )
    {
        rememberChangedField("IncotermsTransferLocation", this.incotermsTransferLocation);
        this.incotermsTransferLocation = incotermsTransferLocation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsVersion</b>
     * </p>
     *
     * @param incotermsVersion
     *            Incoterms Version
     */
    public void setIncotermsVersion( @Nullable final String incotermsVersion )
    {
        rememberChangedField("IncotermsVersion", this.incotermsVersion);
        this.incotermsVersion = incotermsVersion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation1</b>
     * </p>
     *
     * @param incotermsLocation1
     *            Incoterms Location 1
     */
    public void setIncotermsLocation1( @Nullable final String incotermsLocation1 )
    {
        rememberChangedField("IncotermsLocation1", this.incotermsLocation1);
        this.incotermsLocation1 = incotermsLocation1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation2</b>
     * </p>
     *
     * @param incotermsLocation2
     *            Incoterms Location 2
     */
    public void setIncotermsLocation2( @Nullable final String incotermsLocation2 )
    {
        rememberChangedField("IncotermsLocation2", this.incotermsLocation2);
        this.incotermsLocation2 = incotermsLocation2;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseContractTargetAmount</b>
     * </p>
     *
     * @param purchaseContractTargetAmount
     *            Target Value for Header Area per Distribution
     */
    public void setPurchaseContractTargetAmount( @Nullable final BigDecimal purchaseContractTargetAmount )
    {
        rememberChangedField("PurchaseContractTargetAmount", this.purchaseContractTargetAmount);
        this.purchaseContractTargetAmount = purchaseContractTargetAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ExchangeRate</b>
     * </p>
     *
     * @param exchangeRate
     *            The exchangeRate to set.
     */
    public void setExchangeRate( @Nullable final String exchangeRate )
    {
        rememberChangedField("ExchangeRate", this.exchangeRate);
        this.exchangeRate = exchangeRate;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ExchangeRateIsFixed</b>
     * </p>
     *
     * @param exchangeRateIsFixed
     *            Indicator for Fixed Exchange Rate
     */
    public void setExchangeRateIsFixed( @Nullable final Boolean exchangeRateIsFixed )
    {
        rememberChangedField("ExchangeRateIsFixed", this.exchangeRateIsFixed);
        this.exchangeRateIsFixed = exchangeRateIsFixed;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SupplyingSupplier</b>
     * </p>
     *
     * @param supplyingSupplier
     *            Goods Supplier
     */
    public void setSupplyingSupplier( @Nullable final String supplyingSupplier )
    {
        rememberChangedField("SupplyingSupplier", this.supplyingSupplier);
        this.supplyingSupplier = supplyingSupplier;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>QuotationSubmissionDate</b>
     * </p>
     *
     * @param quotationSubmissionDate
     *            Quotation Submission Date
     */
    public void setQuotationSubmissionDate( @Nullable final LocalDateTime quotationSubmissionDate )
    {
        rememberChangedField("QuotationSubmissionDate", this.quotationSubmissionDate);
        this.quotationSubmissionDate = quotationSubmissionDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SupplierQuotation</b>
     * </p>
     *
     * @param supplierQuotation
     *            Quotation Number
     */
    public void setSupplierQuotation( @Nullable final String supplierQuotation )
    {
        rememberChangedField("SupplierQuotation", this.supplierQuotation);
        this.supplierQuotation = supplierQuotation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CorrespncExternalReference</b>
     * </p>
     *
     * @param correspncExternalReference
     *            Your Reference
     */
    public void setCorrespncExternalReference( @Nullable final String correspncExternalReference )
    {
        rememberChangedField("CorrespncExternalReference", this.correspncExternalReference);
        this.correspncExternalReference = correspncExternalReference;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CorrespncInternalReference</b>
     * </p>
     *
     * @param correspncInternalReference
     *            Our Reference
     */
    public void setCorrespncInternalReference( @Nullable final String correspncInternalReference )
    {
        rememberChangedField("CorrespncInternalReference", this.correspncInternalReference);
        this.correspncInternalReference = correspncInternalReference;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>SupplierRespSalesPersonName</b>
     * </p>
     *
     * @param supplierRespSalesPersonName
     *            Responsible Salesperson at Supplier's Office
     */
    public void setSupplierRespSalesPersonName( @Nullable final String supplierRespSalesPersonName )
    {
        rememberChangedField("SupplierRespSalesPersonName", this.supplierRespSalesPersonName);
        this.supplierRespSalesPersonName = supplierRespSalesPersonName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>SupplierPhoneNumber</b>
     * </p>
     *
     * @param supplierPhoneNumber
     *            Supplier's Phone Number
     */
    public void setSupplierPhoneNumber( @Nullable final String supplierPhoneNumber )
    {
        rememberChangedField("SupplierPhoneNumber", this.supplierPhoneNumber);
        this.supplierPhoneNumber = supplierPhoneNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ReleaseCode</b>
     * </p>
     *
     * @param releaseCode
     *            Release Indicator: Purchasing Document
     */
    public void setReleaseCode( @Nullable final String releaseCode )
    {
        rememberChangedField("ReleaseCode", this.releaseCode);
        this.releaseCode = releaseCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentName</b>
     * </p>
     *
     * @param purchasingDocumentName
     *            Name of Purchasing Document
     */
    public void setPurchasingDocumentName( @Nullable final String purchasingDocumentName )
    {
        rememberChangedField("PurchasingDocumentName", this.purchasingDocumentName);
        this.purchasingDocumentName = purchasingDocumentName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            User of person who created a purchasing document
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentDeletionCode</b>
     * </p>
     *
     * @param purchasingDocumentDeletionCode
     *            Deletion Indicator in Purchasing Document
     */
    public void setPurchasingDocumentDeletionCode( @Nullable final String purchasingDocumentDeletionCode )
    {
        rememberChangedField("PurchasingDocumentDeletionCode", this.purchasingDocumentDeletionCode);
        this.purchasingDocumentDeletionCode = purchasingDocumentDeletionCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingProcessingStatus</b>
     * </p>
     *
     * @param purchasingProcessingStatus
     *            Purchasing Document Processing State
     */
    public void setPurchasingProcessingStatus( @Nullable final String purchasingProcessingStatus )
    {
        rememberChangedField("PurchasingProcessingStatus", this.purchasingProcessingStatus);
        this.purchasingProcessingStatus = purchasingProcessingStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CntrlPurContrDistributionSts</b>
     * </p>
     *
     * @param cntrlPurContrDistributionSts
     *            The cntrlPurContrDistributionSts to set.
     */
    public void setCntrlPurContrDistributionSts( @Nullable final String cntrlPurContrDistributionSts )
    {
        rememberChangedField("CntrlPurContrDistributionSts", this.cntrlPurContrDistributionSts);
        this.cntrlPurContrDistributionSts = cntrlPurContrDistributionSts;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PurgContractIsInPreparation</b>
     * </p>
     *
     * @param purgContractIsInPreparation
     *            Boolean Variable (X = True, - = False, Space = Unknown)
     */
    public void setPurgContractIsInPreparation( @Nullable final Boolean purgContractIsInPreparation )
    {
        rememberChangedField("PurgContractIsInPreparation", this.purgContractIsInPreparation);
        this.purgContractIsInPreparation = purgContractIsInPreparation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocVersionReasonCode</b>
     * </p>
     *
     * @param purchasingDocVersionReasonCode
     *            Reason for change
     */
    public void setPurchasingDocVersionReasonCode( @Nullable final String purchasingDocVersionReasonCode )
    {
        rememberChangedField("PurchasingDocVersionReasonCode", this.purchasingDocVersionReasonCode);
        this.purchasingDocVersionReasonCode = purchasingDocVersionReasonCode;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CntrlPurContrFlxblDistrIsAllwd</b>
     * </p>
     *
     * @param cntrlPurContrFlxblDistrIsAllwd
     *            Boolean Variable (X = True, - = False, Space = Unknown)
     */
    public void setCntrlPurContrFlxblDistrIsAllwd( @Nullable final Boolean cntrlPurContrFlxblDistrIsAllwd )
    {
        rememberChangedField("CntrlPurContrFlxblDistrIsAllwd", this.cntrlPurContrFlxblDistrIsAllwd);
        this.cntrlPurContrFlxblDistrIsAllwd = cntrlPurContrFlxblDistrIsAllwd;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentVersion</b>
     * </p>
     *
     * @param purchasingDocumentVersion
     *            Version number in Purchasing
     */
    public void setPurchasingDocumentVersion( @Nullable final String purchasingDocumentVersion )
    {
        rememberChangedField("PurchasingDocumentVersion", this.purchasingDocumentVersion);
        this.purchasingDocumentVersion = purchasingDocumentVersion;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PurgDocIsChgVers</b>
     * </p>
     *
     * @param purgDocIsChgVers
     *            Checkbox
     */
    public void setPurgDocIsChgVers( @Nullable final Boolean purgDocIsChgVers )
    {
        rememberChangedField("PurgDocIsChgVers", this.purgDocIsChgVers);
        this.purgDocIsChgVers = purgDocIsChgVers;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_CentralPurchaseContract";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("CentralPurchaseContract", getCentralPurchaseContract());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("CentralPurchaseContract", getCentralPurchaseContract());
        values.put("PurchaseContractType", getPurchaseContractType());
        values.put("PurchasingDocumentCategory", getPurchasingDocumentCategory());
        values.put("PurchasingDocumentSubtype", getPurchasingDocumentSubtype());
        values.put("Supplier", getSupplier());
        values.put("CompanyCode", getCompanyCode());
        values.put("PurchasingOrganization", getPurchasingOrganization());
        values.put("PurchasingGroup", getPurchasingGroup());
        values.put("ValidityStartDate", getValidityStartDate());
        values.put("ValidityEndDate", getValidityEndDate());
        values.put("DocumentCurrency", getDocumentCurrency());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        values.put("CreationDate", getCreationDate());
        values.put("PaymentTerms", getPaymentTerms());
        values.put("CashDiscount1Days", getCashDiscount1Days());
        values.put("CashDiscount2Days", getCashDiscount2Days());
        values.put("CashDiscount1Percent", getCashDiscount1Percent());
        values.put("CashDiscount2Percent", getCashDiscount2Percent());
        values.put("NetPaymentDays", getNetPaymentDays());
        values.put("IncotermsClassification", getIncotermsClassification());
        values.put("IncotermsTransferLocation", getIncotermsTransferLocation());
        values.put("IncotermsVersion", getIncotermsVersion());
        values.put("IncotermsLocation1", getIncotermsLocation1());
        values.put("IncotermsLocation2", getIncotermsLocation2());
        values.put("PurchaseContractTargetAmount", getPurchaseContractTargetAmount());
        values.put("ExchangeRate", getExchangeRate());
        values.put("ExchangeRateIsFixed", getExchangeRateIsFixed());
        values.put("SupplyingSupplier", getSupplyingSupplier());
        values.put("QuotationSubmissionDate", getQuotationSubmissionDate());
        values.put("SupplierQuotation", getSupplierQuotation());
        values.put("CorrespncExternalReference", getCorrespncExternalReference());
        values.put("CorrespncInternalReference", getCorrespncInternalReference());
        values.put("SupplierRespSalesPersonName", getSupplierRespSalesPersonName());
        values.put("SupplierPhoneNumber", getSupplierPhoneNumber());
        values.put("ReleaseCode", getReleaseCode());
        values.put("PurchasingDocumentName", getPurchasingDocumentName());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("PurchasingDocumentDeletionCode", getPurchasingDocumentDeletionCode());
        values.put("PurchasingProcessingStatus", getPurchasingProcessingStatus());
        values.put("CntrlPurContrDistributionSts", getCntrlPurContrDistributionSts());
        values.put("PurgContractIsInPreparation", getPurgContractIsInPreparation());
        values.put("PurchasingDocVersionReasonCode", getPurchasingDocVersionReasonCode());
        values.put("CntrlPurContrFlxblDistrIsAllwd", getCntrlPurContrFlxblDistrIsAllwd());
        values.put("PurchasingDocumentVersion", getPurchasingDocumentVersion());
        values.put("PurgDocIsChgVers", getPurgDocIsChgVers());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CentralPurchaseContract") ) {
                final Object value = values.remove("CentralPurchaseContract");
                if( (value == null) || (!value.equals(getCentralPurchaseContract())) ) {
                    setCentralPurchaseContract(((String) value));
                }
            }
            if( values.containsKey("PurchaseContractType") ) {
                final Object value = values.remove("PurchaseContractType");
                if( (value == null) || (!value.equals(getPurchaseContractType())) ) {
                    setPurchaseContractType(((String) value));
                }
            }
            if( values.containsKey("PurchasingDocumentCategory") ) {
                final Object value = values.remove("PurchasingDocumentCategory");
                if( (value == null) || (!value.equals(getPurchasingDocumentCategory())) ) {
                    setPurchasingDocumentCategory(((String) value));
                }
            }
            if( values.containsKey("PurchasingDocumentSubtype") ) {
                final Object value = values.remove("PurchasingDocumentSubtype");
                if( (value == null) || (!value.equals(getPurchasingDocumentSubtype())) ) {
                    setPurchasingDocumentSubtype(((String) value));
                }
            }
            if( values.containsKey("Supplier") ) {
                final Object value = values.remove("Supplier");
                if( (value == null) || (!value.equals(getSupplier())) ) {
                    setSupplier(((String) value));
                }
            }
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((String) value));
                }
            }
            if( values.containsKey("PurchasingOrganization") ) {
                final Object value = values.remove("PurchasingOrganization");
                if( (value == null) || (!value.equals(getPurchasingOrganization())) ) {
                    setPurchasingOrganization(((String) value));
                }
            }
            if( values.containsKey("PurchasingGroup") ) {
                final Object value = values.remove("PurchasingGroup");
                if( (value == null) || (!value.equals(getPurchasingGroup())) ) {
                    setPurchasingGroup(((String) value));
                }
            }
            if( values.containsKey("ValidityStartDate") ) {
                final Object value = values.remove("ValidityStartDate");
                if( (value == null) || (!value.equals(getValidityStartDate())) ) {
                    setValidityStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ValidityEndDate") ) {
                final Object value = values.remove("ValidityEndDate");
                if( (value == null) || (!value.equals(getValidityEndDate())) ) {
                    setValidityEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("DocumentCurrency") ) {
                final Object value = values.remove("DocumentCurrency");
                if( (value == null) || (!value.equals(getDocumentCurrency())) ) {
                    setDocumentCurrency(((String) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("PaymentTerms") ) {
                final Object value = values.remove("PaymentTerms");
                if( (value == null) || (!value.equals(getPaymentTerms())) ) {
                    setPaymentTerms(((String) value));
                }
            }
            if( values.containsKey("CashDiscount1Days") ) {
                final Object value = values.remove("CashDiscount1Days");
                if( (value == null) || (!value.equals(getCashDiscount1Days())) ) {
                    setCashDiscount1Days(((BigDecimal) value));
                }
            }
            if( values.containsKey("CashDiscount2Days") ) {
                final Object value = values.remove("CashDiscount2Days");
                if( (value == null) || (!value.equals(getCashDiscount2Days())) ) {
                    setCashDiscount2Days(((BigDecimal) value));
                }
            }
            if( values.containsKey("CashDiscount1Percent") ) {
                final Object value = values.remove("CashDiscount1Percent");
                if( (value == null) || (!value.equals(getCashDiscount1Percent())) ) {
                    setCashDiscount1Percent(((BigDecimal) value));
                }
            }
            if( values.containsKey("CashDiscount2Percent") ) {
                final Object value = values.remove("CashDiscount2Percent");
                if( (value == null) || (!value.equals(getCashDiscount2Percent())) ) {
                    setCashDiscount2Percent(((BigDecimal) value));
                }
            }
            if( values.containsKey("NetPaymentDays") ) {
                final Object value = values.remove("NetPaymentDays");
                if( (value == null) || (!value.equals(getNetPaymentDays())) ) {
                    setNetPaymentDays(((BigDecimal) value));
                }
            }
            if( values.containsKey("IncotermsClassification") ) {
                final Object value = values.remove("IncotermsClassification");
                if( (value == null) || (!value.equals(getIncotermsClassification())) ) {
                    setIncotermsClassification(((String) value));
                }
            }
            if( values.containsKey("IncotermsTransferLocation") ) {
                final Object value = values.remove("IncotermsTransferLocation");
                if( (value == null) || (!value.equals(getIncotermsTransferLocation())) ) {
                    setIncotermsTransferLocation(((String) value));
                }
            }
            if( values.containsKey("IncotermsVersion") ) {
                final Object value = values.remove("IncotermsVersion");
                if( (value == null) || (!value.equals(getIncotermsVersion())) ) {
                    setIncotermsVersion(((String) value));
                }
            }
            if( values.containsKey("IncotermsLocation1") ) {
                final Object value = values.remove("IncotermsLocation1");
                if( (value == null) || (!value.equals(getIncotermsLocation1())) ) {
                    setIncotermsLocation1(((String) value));
                }
            }
            if( values.containsKey("IncotermsLocation2") ) {
                final Object value = values.remove("IncotermsLocation2");
                if( (value == null) || (!value.equals(getIncotermsLocation2())) ) {
                    setIncotermsLocation2(((String) value));
                }
            }
            if( values.containsKey("PurchaseContractTargetAmount") ) {
                final Object value = values.remove("PurchaseContractTargetAmount");
                if( (value == null) || (!value.equals(getPurchaseContractTargetAmount())) ) {
                    setPurchaseContractTargetAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("ExchangeRate") ) {
                final Object value = values.remove("ExchangeRate");
                if( (value == null) || (!value.equals(getExchangeRate())) ) {
                    setExchangeRate(((String) value));
                }
            }
            if( values.containsKey("ExchangeRateIsFixed") ) {
                final Object value = values.remove("ExchangeRateIsFixed");
                if( (value == null) || (!value.equals(getExchangeRateIsFixed())) ) {
                    setExchangeRateIsFixed(((Boolean) value));
                }
            }
            if( values.containsKey("SupplyingSupplier") ) {
                final Object value = values.remove("SupplyingSupplier");
                if( (value == null) || (!value.equals(getSupplyingSupplier())) ) {
                    setSupplyingSupplier(((String) value));
                }
            }
            if( values.containsKey("QuotationSubmissionDate") ) {
                final Object value = values.remove("QuotationSubmissionDate");
                if( (value == null) || (!value.equals(getQuotationSubmissionDate())) ) {
                    setQuotationSubmissionDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("SupplierQuotation") ) {
                final Object value = values.remove("SupplierQuotation");
                if( (value == null) || (!value.equals(getSupplierQuotation())) ) {
                    setSupplierQuotation(((String) value));
                }
            }
            if( values.containsKey("CorrespncExternalReference") ) {
                final Object value = values.remove("CorrespncExternalReference");
                if( (value == null) || (!value.equals(getCorrespncExternalReference())) ) {
                    setCorrespncExternalReference(((String) value));
                }
            }
            if( values.containsKey("CorrespncInternalReference") ) {
                final Object value = values.remove("CorrespncInternalReference");
                if( (value == null) || (!value.equals(getCorrespncInternalReference())) ) {
                    setCorrespncInternalReference(((String) value));
                }
            }
            if( values.containsKey("SupplierRespSalesPersonName") ) {
                final Object value = values.remove("SupplierRespSalesPersonName");
                if( (value == null) || (!value.equals(getSupplierRespSalesPersonName())) ) {
                    setSupplierRespSalesPersonName(((String) value));
                }
            }
            if( values.containsKey("SupplierPhoneNumber") ) {
                final Object value = values.remove("SupplierPhoneNumber");
                if( (value == null) || (!value.equals(getSupplierPhoneNumber())) ) {
                    setSupplierPhoneNumber(((String) value));
                }
            }
            if( values.containsKey("ReleaseCode") ) {
                final Object value = values.remove("ReleaseCode");
                if( (value == null) || (!value.equals(getReleaseCode())) ) {
                    setReleaseCode(((String) value));
                }
            }
            if( values.containsKey("PurchasingDocumentName") ) {
                final Object value = values.remove("PurchasingDocumentName");
                if( (value == null) || (!value.equals(getPurchasingDocumentName())) ) {
                    setPurchasingDocumentName(((String) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("PurchasingDocumentDeletionCode") ) {
                final Object value = values.remove("PurchasingDocumentDeletionCode");
                if( (value == null) || (!value.equals(getPurchasingDocumentDeletionCode())) ) {
                    setPurchasingDocumentDeletionCode(((String) value));
                }
            }
            if( values.containsKey("PurchasingProcessingStatus") ) {
                final Object value = values.remove("PurchasingProcessingStatus");
                if( (value == null) || (!value.equals(getPurchasingProcessingStatus())) ) {
                    setPurchasingProcessingStatus(((String) value));
                }
            }
            if( values.containsKey("CntrlPurContrDistributionSts") ) {
                final Object value = values.remove("CntrlPurContrDistributionSts");
                if( (value == null) || (!value.equals(getCntrlPurContrDistributionSts())) ) {
                    setCntrlPurContrDistributionSts(((String) value));
                }
            }
            if( values.containsKey("PurgContractIsInPreparation") ) {
                final Object value = values.remove("PurgContractIsInPreparation");
                if( (value == null) || (!value.equals(getPurgContractIsInPreparation())) ) {
                    setPurgContractIsInPreparation(((Boolean) value));
                }
            }
            if( values.containsKey("PurchasingDocVersionReasonCode") ) {
                final Object value = values.remove("PurchasingDocVersionReasonCode");
                if( (value == null) || (!value.equals(getPurchasingDocVersionReasonCode())) ) {
                    setPurchasingDocVersionReasonCode(((String) value));
                }
            }
            if( values.containsKey("CntrlPurContrFlxblDistrIsAllwd") ) {
                final Object value = values.remove("CntrlPurContrFlxblDistrIsAllwd");
                if( (value == null) || (!value.equals(getCntrlPurContrFlxblDistrIsAllwd())) ) {
                    setCntrlPurContrFlxblDistrIsAllwd(((Boolean) value));
                }
            }
            if( values.containsKey("PurchasingDocumentVersion") ) {
                final Object value = values.remove("PurchasingDocumentVersion");
                if( (value == null) || (!value.equals(getPurchasingDocumentVersion())) ) {
                    setPurchasingDocumentVersion(((String) value));
                }
            }
            if( values.containsKey("PurgDocIsChgVers") ) {
                final Object value = values.remove("PurgDocIsChgVers");
                if( (value == null) || (!value.equals(getPurgDocIsChgVers())) ) {
                    setPurgDocIsChgVers(((Boolean) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CentralPurchaseContractItem") ) {
                final Object value = (values).remove("to_CentralPurchaseContractItem");
                if( value instanceof Iterable ) {
                    if( toCentralPurchaseContractItem == null ) {
                        toCentralPurchaseContractItem = Lists.newArrayList();
                    } else {
                        toCentralPurchaseContractItem = Lists.newArrayList(toCentralPurchaseContractItem);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        CntrlPurchaseContractItem entity;
                        if( toCentralPurchaseContractItem.size() > i ) {
                            entity = toCentralPurchaseContractItem.get(i);
                        } else {
                            entity = new CntrlPurchaseContractItem();
                            toCentralPurchaseContractItem.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_CntrlContrHdrDistribution") ) {
                final Object value = (values).remove("to_CntrlContrHdrDistribution");
                if( value instanceof Iterable ) {
                    if( toCntrlContrHdrDistribution == null ) {
                        toCntrlContrHdrDistribution = Lists.newArrayList();
                    } else {
                        toCntrlContrHdrDistribution = Lists.newArrayList(toCntrlContrHdrDistribution);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        CntrlPurContrHdrDistribution entity;
                        if( toCntrlContrHdrDistribution.size() > i ) {
                            entity = toCntrlContrHdrDistribution.get(i);
                        } else {
                            entity = new CntrlPurContrHdrDistribution();
                            toCntrlContrHdrDistribution.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_CntrlPurContrDistrMessages") ) {
                final Object value = (values).remove("to_CntrlPurContrDistrMessages");
                if( value instanceof Iterable ) {
                    if( toCntrlPurContrDistrMessages == null ) {
                        toCntrlPurContrDistrMessages = Lists.newArrayList();
                    } else {
                        toCntrlPurContrDistrMessages = Lists.newArrayList(toCntrlPurContrDistrMessages);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        CntrlPurContrDistrMessages entity;
                        if( toCntrlPurContrDistrMessages.size() > i ) {
                            entity = toCntrlPurContrDistrMessages.get(i);
                        } else {
                            entity = new CntrlPurContrDistrMessages();
                            toCntrlPurContrDistrMessages.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_CntrlPurContrHdrCndnValdty") ) {
                final Object value = (values).remove("to_CntrlPurContrHdrCndnValdty");
                if( value instanceof Iterable ) {
                    if( toCntrlPurContrHdrCndnValdty == null ) {
                        toCntrlPurContrHdrCndnValdty = Lists.newArrayList();
                    } else {
                        toCntrlPurContrHdrCndnValdty = Lists.newArrayList(toCntrlPurContrHdrCndnValdty);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        CntrlPurContrHdrCndnValdty entity;
                        if( toCntrlPurContrHdrCndnValdty.size() > i ) {
                            entity = toCntrlPurContrHdrCndnValdty.get(i);
                        } else {
                            entity = new CntrlPurContrHdrCndnValdty();
                            toCntrlPurContrHdrCndnValdty.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_CntrlPurContrHdrNotes") ) {
                final Object value = (values).remove("to_CntrlPurContrHdrNotes");
                if( value instanceof Iterable ) {
                    if( toCntrlPurContrHdrNotes == null ) {
                        toCntrlPurContrHdrNotes = Lists.newArrayList();
                    } else {
                        toCntrlPurContrHdrNotes = Lists.newArrayList(toCntrlPurContrHdrNotes);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        CntrlPurContractHeaderNotes entity;
                        if( toCntrlPurContrHdrNotes.size() > i ) {
                            entity = toCntrlPurContrHdrNotes.get(i);
                        } else {
                            entity = new CntrlPurContractHeaderNotes();
                            toCntrlPurContrHdrNotes.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_CntrlPurContrVersionHistory") ) {
                final Object value = (values).remove("to_CntrlPurContrVersionHistory");
                if( value instanceof Iterable ) {
                    if( toCntrlPurContrVersionHistory == null ) {
                        toCntrlPurContrVersionHistory = Lists.newArrayList();
                    } else {
                        toCntrlPurContrVersionHistory = Lists.newArrayList(toCntrlPurContrVersionHistory);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        CntrlPurContrVersionHistory entity;
                        if( toCntrlPurContrVersionHistory.size() > i ) {
                            entity = toCntrlPurContrVersionHistory.get(i);
                        } else {
                            entity = new CntrlPurContrVersionHistory();
                            toCntrlPurContrVersionHistory.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_DistributedOutlineAgreement") ) {
                final Object value = (values).remove("to_DistributedOutlineAgreement");
                if( value instanceof Iterable ) {
                    if( toDistributedOutlineAgreement == null ) {
                        toDistributedOutlineAgreement = Lists.newArrayList();
                    } else {
                        toDistributedOutlineAgreement = Lists.newArrayList(toDistributedOutlineAgreement);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        CePuCoDistrdOutlineAgrmt entity;
                        if( toDistributedOutlineAgreement.size() > i ) {
                            entity = toDistributedOutlineAgreement.get(i);
                        } else {
                            entity = new CePuCoDistrdOutlineAgrmt();
                            toDistributedOutlineAgreement.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_LegalTransaction") ) {
                final Object value = (values).remove("to_LegalTransaction");
                if( value instanceof Iterable ) {
                    if( toLegalTransaction == null ) {
                        toLegalTransaction = Lists.newArrayList();
                    } else {
                        toLegalTransaction = Lists.newArrayList(toLegalTransaction);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        CntrlPurContrLegalTrans entity;
                        if( toLegalTransaction.size() > i ) {
                            entity = toLegalTransaction.get(i);
                        } else {
                            entity = new CntrlPurContrLegalTrans();
                            toLegalTransaction.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_SubordinateCntrlContract") ) {
                final Object value = (values).remove("to_SubordinateCntrlContract");
                if( value instanceof Iterable ) {
                    if( toSubordinateCntrlContract == null ) {
                        toSubordinateCntrlContract = Lists.newArrayList();
                    } else {
                        toSubordinateCntrlContract = Lists.newArrayList(toSubordinateCntrlContract);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SubordinateCntrlContract entity;
                        if( toSubordinateCntrlContract.size() > i ) {
                            entity = toSubordinateCntrlContract.get(i);
                        } else {
                            entity = new SubordinateCntrlContract();
                            toSubordinateCntrlContract.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> CentralPurchaseContractField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new CentralPurchaseContractField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CentralPurchaseContractField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CentralPurchaseContractField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.CentralPurchaseContractService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCentralPurchaseContractItem != null ) {
            (values).put("to_CentralPurchaseContractItem", toCentralPurchaseContractItem);
        }
        if( toCntrlContrHdrDistribution != null ) {
            (values).put("to_CntrlContrHdrDistribution", toCntrlContrHdrDistribution);
        }
        if( toCntrlPurContrDistrMessages != null ) {
            (values).put("to_CntrlPurContrDistrMessages", toCntrlPurContrDistrMessages);
        }
        if( toCntrlPurContrHdrCndnValdty != null ) {
            (values).put("to_CntrlPurContrHdrCndnValdty", toCntrlPurContrHdrCndnValdty);
        }
        if( toCntrlPurContrHdrNotes != null ) {
            (values).put("to_CntrlPurContrHdrNotes", toCntrlPurContrHdrNotes);
        }
        if( toCntrlPurContrVersionHistory != null ) {
            (values).put("to_CntrlPurContrVersionHistory", toCntrlPurContrVersionHistory);
        }
        if( toDistributedOutlineAgreement != null ) {
            (values).put("to_DistributedOutlineAgreement", toDistributedOutlineAgreement);
        }
        if( toLegalTransaction != null ) {
            (values).put("to_LegalTransaction", toLegalTransaction);
        }
        if( toSubordinateCntrlContract != null ) {
            (values).put("to_SubordinateCntrlContract", toSubordinateCntrlContract);
        }
        return values;
    }

    /**
     * Fetches the <b>CntrlPurchaseContractItem</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_CentralPurchaseContractItem</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>CntrlPurchaseContractItem</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CntrlPurchaseContractItem> fetchCentralPurchaseContractItem()
    {
        return fetchFieldAsList("to_CentralPurchaseContractItem", CntrlPurchaseContractItem.class);
    }

    /**
     * Retrieval of associated <b>CntrlPurchaseContractItem</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CentralPurchaseContractItem</b>.
     * <p>
     * If the navigation property <b>to_CentralPurchaseContractItem</b> of a queried <b>CentralPurchaseContract</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CntrlPurchaseContractItem</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CntrlPurchaseContractItem> getCentralPurchaseContractItemOrFetch()
    {
        if( toCentralPurchaseContractItem == null ) {
            toCentralPurchaseContractItem = fetchCentralPurchaseContractItem();
        }
        return toCentralPurchaseContractItem;
    }

    /**
     * Retrieval of associated <b>CntrlPurchaseContractItem</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CentralPurchaseContractItem</b>.
     * <p>
     * If the navigation property for an entity <b>CentralPurchaseContract</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CentralPurchaseContractItem</b> is already loaded, the
     *         result will contain the <b>CntrlPurchaseContractItem</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<CntrlPurchaseContractItem>> getCentralPurchaseContractItemIfPresent()
    {
        return Option.of(toCentralPurchaseContractItem);
    }

    /**
     * Overwrites the list of associated <b>CntrlPurchaseContractItem</b> entities for the loaded navigation property
     * <b>to_CentralPurchaseContractItem</b>.
     * <p>
     * If the navigation property <b>to_CentralPurchaseContractItem</b> of a queried <b>CentralPurchaseContract</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>CntrlPurchaseContractItem</b> entities.
     */
    public void setCentralPurchaseContractItem( @Nonnull final List<CntrlPurchaseContractItem> value )
    {
        if( toCentralPurchaseContractItem == null ) {
            toCentralPurchaseContractItem = Lists.newArrayList();
        }
        toCentralPurchaseContractItem.clear();
        toCentralPurchaseContractItem.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>CntrlPurchaseContractItem</b> entities. This corresponds to the OData
     * navigation property <b>to_CentralPurchaseContractItem</b>.
     * <p>
     * If the navigation property <b>to_CentralPurchaseContractItem</b> of a queried <b>CentralPurchaseContract</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>CntrlPurchaseContractItem</b> entities.
     */
    public void addCentralPurchaseContractItem( CntrlPurchaseContractItem... entity )
    {
        if( toCentralPurchaseContractItem == null ) {
            toCentralPurchaseContractItem = Lists.newArrayList();
        }
        toCentralPurchaseContractItem.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>CntrlPurContrHdrDistribution</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_CntrlContrHdrDistribution</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>CntrlPurContrHdrDistribution</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CntrlPurContrHdrDistribution> fetchCntrlContrHdrDistribution()
    {
        return fetchFieldAsList("to_CntrlContrHdrDistribution", CntrlPurContrHdrDistribution.class);
    }

    /**
     * Retrieval of associated <b>CntrlPurContrHdrDistribution</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CntrlContrHdrDistribution</b>.
     * <p>
     * If the navigation property <b>to_CntrlContrHdrDistribution</b> of a queried <b>CentralPurchaseContract</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CntrlPurContrHdrDistribution</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CntrlPurContrHdrDistribution> getCntrlContrHdrDistributionOrFetch()
    {
        if( toCntrlContrHdrDistribution == null ) {
            toCntrlContrHdrDistribution = fetchCntrlContrHdrDistribution();
        }
        return toCntrlContrHdrDistribution;
    }

    /**
     * Retrieval of associated <b>CntrlPurContrHdrDistribution</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CntrlContrHdrDistribution</b>.
     * <p>
     * If the navigation property for an entity <b>CentralPurchaseContract</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CntrlContrHdrDistribution</b> is already loaded, the
     *         result will contain the <b>CntrlPurContrHdrDistribution</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<CntrlPurContrHdrDistribution>> getCntrlContrHdrDistributionIfPresent()
    {
        return Option.of(toCntrlContrHdrDistribution);
    }

    /**
     * Overwrites the list of associated <b>CntrlPurContrHdrDistribution</b> entities for the loaded navigation property
     * <b>to_CntrlContrHdrDistribution</b>.
     * <p>
     * If the navigation property <b>to_CntrlContrHdrDistribution</b> of a queried <b>CentralPurchaseContract</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>CntrlPurContrHdrDistribution</b> entities.
     */
    public void setCntrlContrHdrDistribution( @Nonnull final List<CntrlPurContrHdrDistribution> value )
    {
        if( toCntrlContrHdrDistribution == null ) {
            toCntrlContrHdrDistribution = Lists.newArrayList();
        }
        toCntrlContrHdrDistribution.clear();
        toCntrlContrHdrDistribution.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>CntrlPurContrHdrDistribution</b> entities. This corresponds to the
     * OData navigation property <b>to_CntrlContrHdrDistribution</b>.
     * <p>
     * If the navigation property <b>to_CntrlContrHdrDistribution</b> of a queried <b>CentralPurchaseContract</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>CntrlPurContrHdrDistribution</b> entities.
     */
    public void addCntrlContrHdrDistribution( CntrlPurContrHdrDistribution... entity )
    {
        if( toCntrlContrHdrDistribution == null ) {
            toCntrlContrHdrDistribution = Lists.newArrayList();
        }
        toCntrlContrHdrDistribution.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>CntrlPurContrDistrMessages</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_CntrlPurContrDistrMessages</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>CntrlPurContrDistrMessages</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CntrlPurContrDistrMessages> fetchCntrlPurContrDistrMessages()
    {
        return fetchFieldAsList("to_CntrlPurContrDistrMessages", CntrlPurContrDistrMessages.class);
    }

    /**
     * Retrieval of associated <b>CntrlPurContrDistrMessages</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CntrlPurContrDistrMessages</b>.
     * <p>
     * If the navigation property <b>to_CntrlPurContrDistrMessages</b> of a queried <b>CentralPurchaseContract</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CntrlPurContrDistrMessages</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CntrlPurContrDistrMessages> getCntrlPurContrDistrMessagesOrFetch()
    {
        if( toCntrlPurContrDistrMessages == null ) {
            toCntrlPurContrDistrMessages = fetchCntrlPurContrDistrMessages();
        }
        return toCntrlPurContrDistrMessages;
    }

    /**
     * Retrieval of associated <b>CntrlPurContrDistrMessages</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CntrlPurContrDistrMessages</b>.
     * <p>
     * If the navigation property for an entity <b>CentralPurchaseContract</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CntrlPurContrDistrMessages</b> is already loaded, the
     *         result will contain the <b>CntrlPurContrDistrMessages</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<CntrlPurContrDistrMessages>> getCntrlPurContrDistrMessagesIfPresent()
    {
        return Option.of(toCntrlPurContrDistrMessages);
    }

    /**
     * Overwrites the list of associated <b>CntrlPurContrDistrMessages</b> entities for the loaded navigation property
     * <b>to_CntrlPurContrDistrMessages</b>.
     * <p>
     * If the navigation property <b>to_CntrlPurContrDistrMessages</b> of a queried <b>CentralPurchaseContract</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>CntrlPurContrDistrMessages</b> entities.
     */
    public void setCntrlPurContrDistrMessages( @Nonnull final List<CntrlPurContrDistrMessages> value )
    {
        if( toCntrlPurContrDistrMessages == null ) {
            toCntrlPurContrDistrMessages = Lists.newArrayList();
        }
        toCntrlPurContrDistrMessages.clear();
        toCntrlPurContrDistrMessages.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>CntrlPurContrDistrMessages</b> entities. This corresponds to the OData
     * navigation property <b>to_CntrlPurContrDistrMessages</b>.
     * <p>
     * If the navigation property <b>to_CntrlPurContrDistrMessages</b> of a queried <b>CentralPurchaseContract</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>CntrlPurContrDistrMessages</b> entities.
     */
    public void addCntrlPurContrDistrMessages( CntrlPurContrDistrMessages... entity )
    {
        if( toCntrlPurContrDistrMessages == null ) {
            toCntrlPurContrDistrMessages = Lists.newArrayList();
        }
        toCntrlPurContrDistrMessages.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>CntrlPurContrHdrCndnValdty</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_CntrlPurContrHdrCndnValdty</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>CntrlPurContrHdrCndnValdty</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CntrlPurContrHdrCndnValdty> fetchCntrlPurContrHdrCndnValdty()
    {
        return fetchFieldAsList("to_CntrlPurContrHdrCndnValdty", CntrlPurContrHdrCndnValdty.class);
    }

    /**
     * Retrieval of associated <b>CntrlPurContrHdrCndnValdty</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CntrlPurContrHdrCndnValdty</b>.
     * <p>
     * If the navigation property <b>to_CntrlPurContrHdrCndnValdty</b> of a queried <b>CentralPurchaseContract</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CntrlPurContrHdrCndnValdty</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CntrlPurContrHdrCndnValdty> getCntrlPurContrHdrCndnValdtyOrFetch()
    {
        if( toCntrlPurContrHdrCndnValdty == null ) {
            toCntrlPurContrHdrCndnValdty = fetchCntrlPurContrHdrCndnValdty();
        }
        return toCntrlPurContrHdrCndnValdty;
    }

    /**
     * Retrieval of associated <b>CntrlPurContrHdrCndnValdty</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CntrlPurContrHdrCndnValdty</b>.
     * <p>
     * If the navigation property for an entity <b>CentralPurchaseContract</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CntrlPurContrHdrCndnValdty</b> is already loaded, the
     *         result will contain the <b>CntrlPurContrHdrCndnValdty</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<CntrlPurContrHdrCndnValdty>> getCntrlPurContrHdrCndnValdtyIfPresent()
    {
        return Option.of(toCntrlPurContrHdrCndnValdty);
    }

    /**
     * Overwrites the list of associated <b>CntrlPurContrHdrCndnValdty</b> entities for the loaded navigation property
     * <b>to_CntrlPurContrHdrCndnValdty</b>.
     * <p>
     * If the navigation property <b>to_CntrlPurContrHdrCndnValdty</b> of a queried <b>CentralPurchaseContract</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>CntrlPurContrHdrCndnValdty</b> entities.
     */
    public void setCntrlPurContrHdrCndnValdty( @Nonnull final List<CntrlPurContrHdrCndnValdty> value )
    {
        if( toCntrlPurContrHdrCndnValdty == null ) {
            toCntrlPurContrHdrCndnValdty = Lists.newArrayList();
        }
        toCntrlPurContrHdrCndnValdty.clear();
        toCntrlPurContrHdrCndnValdty.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>CntrlPurContrHdrCndnValdty</b> entities. This corresponds to the OData
     * navigation property <b>to_CntrlPurContrHdrCndnValdty</b>.
     * <p>
     * If the navigation property <b>to_CntrlPurContrHdrCndnValdty</b> of a queried <b>CentralPurchaseContract</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>CntrlPurContrHdrCndnValdty</b> entities.
     */
    public void addCntrlPurContrHdrCndnValdty( CntrlPurContrHdrCndnValdty... entity )
    {
        if( toCntrlPurContrHdrCndnValdty == null ) {
            toCntrlPurContrHdrCndnValdty = Lists.newArrayList();
        }
        toCntrlPurContrHdrCndnValdty.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>CntrlPurContractHeaderNotes</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_CntrlPurContrHdrNotes</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>CntrlPurContractHeaderNotes</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CntrlPurContractHeaderNotes> fetchCntrlPurContrHdrNotes()
    {
        return fetchFieldAsList("to_CntrlPurContrHdrNotes", CntrlPurContractHeaderNotes.class);
    }

    /**
     * Retrieval of associated <b>CntrlPurContractHeaderNotes</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CntrlPurContrHdrNotes</b>.
     * <p>
     * If the navigation property <b>to_CntrlPurContrHdrNotes</b> of a queried <b>CentralPurchaseContract</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CntrlPurContractHeaderNotes</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CntrlPurContractHeaderNotes> getCntrlPurContrHdrNotesOrFetch()
    {
        if( toCntrlPurContrHdrNotes == null ) {
            toCntrlPurContrHdrNotes = fetchCntrlPurContrHdrNotes();
        }
        return toCntrlPurContrHdrNotes;
    }

    /**
     * Retrieval of associated <b>CntrlPurContractHeaderNotes</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CntrlPurContrHdrNotes</b>.
     * <p>
     * If the navigation property for an entity <b>CentralPurchaseContract</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CntrlPurContrHdrNotes</b> is already loaded, the result
     *         will contain the <b>CntrlPurContractHeaderNotes</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<CntrlPurContractHeaderNotes>> getCntrlPurContrHdrNotesIfPresent()
    {
        return Option.of(toCntrlPurContrHdrNotes);
    }

    /**
     * Overwrites the list of associated <b>CntrlPurContractHeaderNotes</b> entities for the loaded navigation property
     * <b>to_CntrlPurContrHdrNotes</b>.
     * <p>
     * If the navigation property <b>to_CntrlPurContrHdrNotes</b> of a queried <b>CentralPurchaseContract</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>CntrlPurContractHeaderNotes</b> entities.
     */
    public void setCntrlPurContrHdrNotes( @Nonnull final List<CntrlPurContractHeaderNotes> value )
    {
        if( toCntrlPurContrHdrNotes == null ) {
            toCntrlPurContrHdrNotes = Lists.newArrayList();
        }
        toCntrlPurContrHdrNotes.clear();
        toCntrlPurContrHdrNotes.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>CntrlPurContractHeaderNotes</b> entities. This corresponds to the
     * OData navigation property <b>to_CntrlPurContrHdrNotes</b>.
     * <p>
     * If the navigation property <b>to_CntrlPurContrHdrNotes</b> of a queried <b>CentralPurchaseContract</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>CntrlPurContractHeaderNotes</b> entities.
     */
    public void addCntrlPurContrHdrNotes( CntrlPurContractHeaderNotes... entity )
    {
        if( toCntrlPurContrHdrNotes == null ) {
            toCntrlPurContrHdrNotes = Lists.newArrayList();
        }
        toCntrlPurContrHdrNotes.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>CntrlPurContrVersionHistory</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_CntrlPurContrVersionHistory</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>CntrlPurContrVersionHistory</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CntrlPurContrVersionHistory> fetchCntrlPurContrVersionHistory()
    {
        return fetchFieldAsList("to_CntrlPurContrVersionHistory", CntrlPurContrVersionHistory.class);
    }

    /**
     * Retrieval of associated <b>CntrlPurContrVersionHistory</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CntrlPurContrVersionHistory</b>.
     * <p>
     * If the navigation property <b>to_CntrlPurContrVersionHistory</b> of a queried <b>CentralPurchaseContract</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CntrlPurContrVersionHistory</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CntrlPurContrVersionHistory> getCntrlPurContrVersionHistoryOrFetch()
    {
        if( toCntrlPurContrVersionHistory == null ) {
            toCntrlPurContrVersionHistory = fetchCntrlPurContrVersionHistory();
        }
        return toCntrlPurContrVersionHistory;
    }

    /**
     * Retrieval of associated <b>CntrlPurContrVersionHistory</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CntrlPurContrVersionHistory</b>.
     * <p>
     * If the navigation property for an entity <b>CentralPurchaseContract</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CntrlPurContrVersionHistory</b> is already loaded, the
     *         result will contain the <b>CntrlPurContrVersionHistory</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<CntrlPurContrVersionHistory>> getCntrlPurContrVersionHistoryIfPresent()
    {
        return Option.of(toCntrlPurContrVersionHistory);
    }

    /**
     * Overwrites the list of associated <b>CntrlPurContrVersionHistory</b> entities for the loaded navigation property
     * <b>to_CntrlPurContrVersionHistory</b>.
     * <p>
     * If the navigation property <b>to_CntrlPurContrVersionHistory</b> of a queried <b>CentralPurchaseContract</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>CntrlPurContrVersionHistory</b> entities.
     */
    public void setCntrlPurContrVersionHistory( @Nonnull final List<CntrlPurContrVersionHistory> value )
    {
        if( toCntrlPurContrVersionHistory == null ) {
            toCntrlPurContrVersionHistory = Lists.newArrayList();
        }
        toCntrlPurContrVersionHistory.clear();
        toCntrlPurContrVersionHistory.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>CntrlPurContrVersionHistory</b> entities. This corresponds to the
     * OData navigation property <b>to_CntrlPurContrVersionHistory</b>.
     * <p>
     * If the navigation property <b>to_CntrlPurContrVersionHistory</b> of a queried <b>CentralPurchaseContract</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>CntrlPurContrVersionHistory</b> entities.
     */
    public void addCntrlPurContrVersionHistory( CntrlPurContrVersionHistory... entity )
    {
        if( toCntrlPurContrVersionHistory == null ) {
            toCntrlPurContrVersionHistory = Lists.newArrayList();
        }
        toCntrlPurContrVersionHistory.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>CePuCoDistrdOutlineAgrmt</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_DistributedOutlineAgreement</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>CePuCoDistrdOutlineAgrmt</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CePuCoDistrdOutlineAgrmt> fetchDistributedOutlineAgreement()
    {
        return fetchFieldAsList("to_DistributedOutlineAgreement", CePuCoDistrdOutlineAgrmt.class);
    }

    /**
     * Retrieval of associated <b>CePuCoDistrdOutlineAgrmt</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_DistributedOutlineAgreement</b>.
     * <p>
     * If the navigation property <b>to_DistributedOutlineAgreement</b> of a queried <b>CentralPurchaseContract</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CePuCoDistrdOutlineAgrmt</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CePuCoDistrdOutlineAgrmt> getDistributedOutlineAgreementOrFetch()
    {
        if( toDistributedOutlineAgreement == null ) {
            toDistributedOutlineAgreement = fetchDistributedOutlineAgreement();
        }
        return toDistributedOutlineAgreement;
    }

    /**
     * Retrieval of associated <b>CePuCoDistrdOutlineAgrmt</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_DistributedOutlineAgreement</b>.
     * <p>
     * If the navigation property for an entity <b>CentralPurchaseContract</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_DistributedOutlineAgreement</b> is already loaded, the
     *         result will contain the <b>CePuCoDistrdOutlineAgrmt</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<CePuCoDistrdOutlineAgrmt>> getDistributedOutlineAgreementIfPresent()
    {
        return Option.of(toDistributedOutlineAgreement);
    }

    /**
     * Overwrites the list of associated <b>CePuCoDistrdOutlineAgrmt</b> entities for the loaded navigation property
     * <b>to_DistributedOutlineAgreement</b>.
     * <p>
     * If the navigation property <b>to_DistributedOutlineAgreement</b> of a queried <b>CentralPurchaseContract</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>CePuCoDistrdOutlineAgrmt</b> entities.
     */
    public void setDistributedOutlineAgreement( @Nonnull final List<CePuCoDistrdOutlineAgrmt> value )
    {
        if( toDistributedOutlineAgreement == null ) {
            toDistributedOutlineAgreement = Lists.newArrayList();
        }
        toDistributedOutlineAgreement.clear();
        toDistributedOutlineAgreement.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>CePuCoDistrdOutlineAgrmt</b> entities. This corresponds to the OData
     * navigation property <b>to_DistributedOutlineAgreement</b>.
     * <p>
     * If the navigation property <b>to_DistributedOutlineAgreement</b> of a queried <b>CentralPurchaseContract</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>CePuCoDistrdOutlineAgrmt</b> entities.
     */
    public void addDistributedOutlineAgreement( CePuCoDistrdOutlineAgrmt... entity )
    {
        if( toDistributedOutlineAgreement == null ) {
            toDistributedOutlineAgreement = Lists.newArrayList();
        }
        toDistributedOutlineAgreement.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>CntrlPurContrLegalTrans</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_LegalTransaction</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>CntrlPurContrLegalTrans</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CntrlPurContrLegalTrans> fetchLegalTransaction()
    {
        return fetchFieldAsList("to_LegalTransaction", CntrlPurContrLegalTrans.class);
    }

    /**
     * Retrieval of associated <b>CntrlPurContrLegalTrans</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_LegalTransaction</b>.
     * <p>
     * If the navigation property <b>to_LegalTransaction</b> of a queried <b>CentralPurchaseContract</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CntrlPurContrLegalTrans</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CntrlPurContrLegalTrans> getLegalTransactionOrFetch()
    {
        if( toLegalTransaction == null ) {
            toLegalTransaction = fetchLegalTransaction();
        }
        return toLegalTransaction;
    }

    /**
     * Retrieval of associated <b>CntrlPurContrLegalTrans</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_LegalTransaction</b>.
     * <p>
     * If the navigation property for an entity <b>CentralPurchaseContract</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_LegalTransaction</b> is already loaded, the result will
     *         contain the <b>CntrlPurContrLegalTrans</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<CntrlPurContrLegalTrans>> getLegalTransactionIfPresent()
    {
        return Option.of(toLegalTransaction);
    }

    /**
     * Overwrites the list of associated <b>CntrlPurContrLegalTrans</b> entities for the loaded navigation property
     * <b>to_LegalTransaction</b>.
     * <p>
     * If the navigation property <b>to_LegalTransaction</b> of a queried <b>CentralPurchaseContract</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>CntrlPurContrLegalTrans</b> entities.
     */
    public void setLegalTransaction( @Nonnull final List<CntrlPurContrLegalTrans> value )
    {
        if( toLegalTransaction == null ) {
            toLegalTransaction = Lists.newArrayList();
        }
        toLegalTransaction.clear();
        toLegalTransaction.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>CntrlPurContrLegalTrans</b> entities. This corresponds to the OData
     * navigation property <b>to_LegalTransaction</b>.
     * <p>
     * If the navigation property <b>to_LegalTransaction</b> of a queried <b>CentralPurchaseContract</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>CntrlPurContrLegalTrans</b> entities.
     */
    public void addLegalTransaction( CntrlPurContrLegalTrans... entity )
    {
        if( toLegalTransaction == null ) {
            toLegalTransaction = Lists.newArrayList();
        }
        toLegalTransaction.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SubordinateCntrlContract</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_SubordinateCntrlContract</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SubordinateCntrlContract</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SubordinateCntrlContract> fetchSubordinateCntrlContract()
    {
        return fetchFieldAsList("to_SubordinateCntrlContract", SubordinateCntrlContract.class);
    }

    /**
     * Retrieval of associated <b>SubordinateCntrlContract</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SubordinateCntrlContract</b>.
     * <p>
     * If the navigation property <b>to_SubordinateCntrlContract</b> of a queried <b>CentralPurchaseContract</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SubordinateCntrlContract</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SubordinateCntrlContract> getSubordinateCntrlContractOrFetch()
    {
        if( toSubordinateCntrlContract == null ) {
            toSubordinateCntrlContract = fetchSubordinateCntrlContract();
        }
        return toSubordinateCntrlContract;
    }

    /**
     * Retrieval of associated <b>SubordinateCntrlContract</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SubordinateCntrlContract</b>.
     * <p>
     * If the navigation property for an entity <b>CentralPurchaseContract</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SubordinateCntrlContract</b> is already loaded, the
     *         result will contain the <b>SubordinateCntrlContract</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SubordinateCntrlContract>> getSubordinateCntrlContractIfPresent()
    {
        return Option.of(toSubordinateCntrlContract);
    }

    /**
     * Overwrites the list of associated <b>SubordinateCntrlContract</b> entities for the loaded navigation property
     * <b>to_SubordinateCntrlContract</b>.
     * <p>
     * If the navigation property <b>to_SubordinateCntrlContract</b> of a queried <b>CentralPurchaseContract</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SubordinateCntrlContract</b> entities.
     */
    public void setSubordinateCntrlContract( @Nonnull final List<SubordinateCntrlContract> value )
    {
        if( toSubordinateCntrlContract == null ) {
            toSubordinateCntrlContract = Lists.newArrayList();
        }
        toSubordinateCntrlContract.clear();
        toSubordinateCntrlContract.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SubordinateCntrlContract</b> entities. This corresponds to the OData
     * navigation property <b>to_SubordinateCntrlContract</b>.
     * <p>
     * If the navigation property <b>to_SubordinateCntrlContract</b> of a queried <b>CentralPurchaseContract</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SubordinateCntrlContract</b> entities.
     */
    public void addSubordinateCntrlContract( SubordinateCntrlContract... entity )
    {
        if( toSubordinateCntrlContract == null ) {
            toSubordinateCntrlContract = Lists.newArrayList();
        }
        toSubordinateCntrlContract.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of CentralPurchaseContract instances.
     *
     */
    public final static class CentralPurchaseContractBuilder
    {

        private List<CntrlPurchaseContractItem> toCentralPurchaseContractItem = Lists.newArrayList();
        private List<CntrlPurContrHdrDistribution> toCntrlContrHdrDistribution = Lists.newArrayList();
        private List<CntrlPurContrDistrMessages> toCntrlPurContrDistrMessages = Lists.newArrayList();
        private List<CntrlPurContrHdrCndnValdty> toCntrlPurContrHdrCndnValdty = Lists.newArrayList();
        private List<CntrlPurContractHeaderNotes> toCntrlPurContrHdrNotes = Lists.newArrayList();
        private List<CntrlPurContrVersionHistory> toCntrlPurContrVersionHistory = Lists.newArrayList();
        private List<CePuCoDistrdOutlineAgrmt> toDistributedOutlineAgreement = Lists.newArrayList();
        private List<CntrlPurContrLegalTrans> toLegalTransaction = Lists.newArrayList();
        private List<SubordinateCntrlContract> toSubordinateCntrlContract = Lists.newArrayList();

        private CentralPurchaseContract.CentralPurchaseContractBuilder toCentralPurchaseContractItem(
            final List<CntrlPurchaseContractItem> value )
        {
            toCentralPurchaseContractItem.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CentralPurchaseContractItem</b> for <b>CentralPurchaseContract</b> to multiple
         * <b>CntrlPurchaseContractItem</b>.
         *
         * @param value
         *            The CntrlPurchaseContractItems to build this CentralPurchaseContract with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CentralPurchaseContract.CentralPurchaseContractBuilder centralPurchaseContractItem(
            CntrlPurchaseContractItem... value )
        {
            return toCentralPurchaseContractItem(Lists.newArrayList(value));
        }

        private CentralPurchaseContract.CentralPurchaseContractBuilder toCntrlContrHdrDistribution(
            final List<CntrlPurContrHdrDistribution> value )
        {
            toCntrlContrHdrDistribution.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CntrlContrHdrDistribution</b> for <b>CentralPurchaseContract</b> to multiple
         * <b>CntrlPurContrHdrDistribution</b>.
         *
         * @param value
         *            The CntrlPurContrHdrDistributions to build this CentralPurchaseContract with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CentralPurchaseContract.CentralPurchaseContractBuilder cntrlContrHdrDistribution(
            CntrlPurContrHdrDistribution... value )
        {
            return toCntrlContrHdrDistribution(Lists.newArrayList(value));
        }

        private CentralPurchaseContract.CentralPurchaseContractBuilder toCntrlPurContrDistrMessages(
            final List<CntrlPurContrDistrMessages> value )
        {
            toCntrlPurContrDistrMessages.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CntrlPurContrDistrMessages</b> for <b>CentralPurchaseContract</b> to multiple
         * <b>CntrlPurContrDistrMessages</b>.
         *
         * @param value
         *            The CntrlPurContrDistrMessagess to build this CentralPurchaseContract with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CentralPurchaseContract.CentralPurchaseContractBuilder cntrlPurContrDistrMessages(
            CntrlPurContrDistrMessages... value )
        {
            return toCntrlPurContrDistrMessages(Lists.newArrayList(value));
        }

        private CentralPurchaseContract.CentralPurchaseContractBuilder toCntrlPurContrHdrCndnValdty(
            final List<CntrlPurContrHdrCndnValdty> value )
        {
            toCntrlPurContrHdrCndnValdty.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CntrlPurContrHdrCndnValdty</b> for <b>CentralPurchaseContract</b> to multiple
         * <b>CntrlPurContrHdrCndnValdty</b>.
         *
         * @param value
         *            The CntrlPurContrHdrCndnValdtys to build this CentralPurchaseContract with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CentralPurchaseContract.CentralPurchaseContractBuilder cntrlPurContrHdrCndnValdty(
            CntrlPurContrHdrCndnValdty... value )
        {
            return toCntrlPurContrHdrCndnValdty(Lists.newArrayList(value));
        }

        private CentralPurchaseContract.CentralPurchaseContractBuilder toCntrlPurContrHdrNotes(
            final List<CntrlPurContractHeaderNotes> value )
        {
            toCntrlPurContrHdrNotes.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CntrlPurContrHdrNotes</b> for <b>CentralPurchaseContract</b> to multiple
         * <b>CntrlPurContractHeaderNotes</b>.
         *
         * @param value
         *            The CntrlPurContractHeaderNotess to build this CentralPurchaseContract with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CentralPurchaseContract.CentralPurchaseContractBuilder cntrlPurContrHdrNotes(
            CntrlPurContractHeaderNotes... value )
        {
            return toCntrlPurContrHdrNotes(Lists.newArrayList(value));
        }

        private CentralPurchaseContract.CentralPurchaseContractBuilder toCntrlPurContrVersionHistory(
            final List<CntrlPurContrVersionHistory> value )
        {
            toCntrlPurContrVersionHistory.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CntrlPurContrVersionHistory</b> for <b>CentralPurchaseContract</b> to multiple
         * <b>CntrlPurContrVersionHistory</b>.
         *
         * @param value
         *            The CntrlPurContrVersionHistorys to build this CentralPurchaseContract with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CentralPurchaseContract.CentralPurchaseContractBuilder cntrlPurContrVersionHistory(
            CntrlPurContrVersionHistory... value )
        {
            return toCntrlPurContrVersionHistory(Lists.newArrayList(value));
        }

        private CentralPurchaseContract.CentralPurchaseContractBuilder toDistributedOutlineAgreement(
            final List<CePuCoDistrdOutlineAgrmt> value )
        {
            toDistributedOutlineAgreement.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_DistributedOutlineAgreement</b> for <b>CentralPurchaseContract</b> to multiple
         * <b>CePuCoDistrdOutlineAgrmt</b>.
         *
         * @param value
         *            The CePuCoDistrdOutlineAgrmts to build this CentralPurchaseContract with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CentralPurchaseContract.CentralPurchaseContractBuilder distributedOutlineAgreement(
            CePuCoDistrdOutlineAgrmt... value )
        {
            return toDistributedOutlineAgreement(Lists.newArrayList(value));
        }

        private CentralPurchaseContract.CentralPurchaseContractBuilder toLegalTransaction(
            final List<CntrlPurContrLegalTrans> value )
        {
            toLegalTransaction.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_LegalTransaction</b> for <b>CentralPurchaseContract</b> to multiple
         * <b>CntrlPurContrLegalTrans</b>.
         *
         * @param value
         *            The CntrlPurContrLegalTranss to build this CentralPurchaseContract with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CentralPurchaseContract.CentralPurchaseContractBuilder legalTransaction(
            CntrlPurContrLegalTrans... value )
        {
            return toLegalTransaction(Lists.newArrayList(value));
        }

        private CentralPurchaseContract.CentralPurchaseContractBuilder toSubordinateCntrlContract(
            final List<SubordinateCntrlContract> value )
        {
            toSubordinateCntrlContract.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_SubordinateCntrlContract</b> for <b>CentralPurchaseContract</b> to multiple
         * <b>SubordinateCntrlContract</b>.
         *
         * @param value
         *            The SubordinateCntrlContracts to build this CentralPurchaseContract with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CentralPurchaseContract.CentralPurchaseContractBuilder subordinateCntrlContract(
            SubordinateCntrlContract... value )
        {
            return toSubordinateCntrlContract(Lists.newArrayList(value));
        }

    }

}
