/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract;

import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.field.CntrlPurContrDistrMessagesField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.selectable.CntrlPurContrDistrMessagesSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Distribution Message
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_CntrlPurContrDistrMessagesType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CntrlPurContrDistrMessages extends VdmEntity<CntrlPurContrDistrMessages>
{

    /**
     * Selector for all available fields of CntrlPurContrDistrMessages.
     *
     */
    public final static CntrlPurContrDistrMessagesSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SequenceNumber</b>
     * </p>
     *
     * @return Sequence No. of Message during Contract Distribution
     */
    @Key
    @SerializedName( "SequenceNumber" )
    @JsonProperty( "SequenceNumber" )
    @Nullable
    @ODataField( odataName = "SequenceNumber" )
    private String sequenceNumber;
    /**
     * Use with available fluent helpers to apply the <b>SequenceNumber</b> field to query operations.
     *
     */
    public final static CntrlPurContrDistrMessagesField<String> SEQUENCE_NUMBER =
        new CntrlPurContrDistrMessagesField<String>("SequenceNumber");
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>DistrResponseMessageUUID</b>
     * </p>
     *
     * @return Generic Data Element for GUID Fields (X16)
     */
    @Key
    @SerializedName( "DistrResponseMessageUUID" )
    @JsonProperty( "DistrResponseMessageUUID" )
    @Nullable
    @ODataField( odataName = "DistrResponseMessageUUID" )
    private UUID distrResponseMessageUUID;
    /**
     * Use with available fluent helpers to apply the <b>DistrResponseMessageUUID</b> field to query operations.
     *
     */
    public final static CntrlPurContrDistrMessagesField<UUID> DISTR_RESPONSE_MESSAGE_UUID =
        new CntrlPurContrDistrMessagesField<UUID>("DistrResponseMessageUUID");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocument</b>
     * </p>
     *
     * @return Purchasing Document Number
     */
    @SerializedName( "PurchasingDocument" )
    @JsonProperty( "PurchasingDocument" )
    @Nullable
    @ODataField( odataName = "PurchasingDocument" )
    private String purchasingDocument;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingDocument</b> field to query operations.
     *
     */
    public final static CntrlPurContrDistrMessagesField<String> PURCHASING_DOCUMENT =
        new CntrlPurContrDistrMessagesField<String>("PurchasingDocument");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentCategory</b>
     * </p>
     *
     * @return Purchasing Document Category
     */
    @SerializedName( "PurchasingDocumentCategory" )
    @JsonProperty( "PurchasingDocumentCategory" )
    @Nullable
    @ODataField( odataName = "PurchasingDocumentCategory" )
    private String purchasingDocumentCategory;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingDocumentCategory</b> field to query operations.
     *
     */
    public final static CntrlPurContrDistrMessagesField<String> PURCHASING_DOCUMENT_CATEGORY =
        new CntrlPurContrDistrMessagesField<String>("PurchasingDocumentCategory");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ExtContractForPurg</b>
     * </p>
     *
     * @return Contract of External System
     */
    @SerializedName( "ExtContractForPurg" )
    @JsonProperty( "ExtContractForPurg" )
    @Nullable
    @ODataField( odataName = "ExtContractForPurg" )
    private String extContractForPurg;
    /**
     * Use with available fluent helpers to apply the <b>ExtContractForPurg</b> field to query operations.
     *
     */
    public final static CntrlPurContrDistrMessagesField<String> EXT_CONTRACT_FOR_PURG =
        new CntrlPurContrDistrMessagesField<String>("ExtContractForPurg");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>LogicalSystem</b>
     * </p>
     *
     * @return Logical System
     */
    @SerializedName( "LogicalSystem" )
    @JsonProperty( "LogicalSystem" )
    @Nullable
    @ODataField( odataName = "LogicalSystem" )
    private String logicalSystem;
    /**
     * Use with available fluent helpers to apply the <b>LogicalSystem</b> field to query operations.
     *
     */
    public final static CntrlPurContrDistrMessagesField<String> LOGICAL_SYSTEM =
        new CntrlPurContrDistrMessagesField<String>("LogicalSystem");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SystemMessageType</b>
     * </p>
     *
     * @return Message Type
     */
    @SerializedName( "SystemMessageType" )
    @JsonProperty( "SystemMessageType" )
    @Nullable
    @ODataField( odataName = "SystemMessageType" )
    private String systemMessageType;
    /**
     * Use with available fluent helpers to apply the <b>SystemMessageType</b> field to query operations.
     *
     */
    public final static CntrlPurContrDistrMessagesField<String> SYSTEM_MESSAGE_TYPE =
        new CntrlPurContrDistrMessagesField<String>("SystemMessageType");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SystemMessageIdentification</b>
     * </p>
     *
     * @return Message identification
     */
    @SerializedName( "SystemMessageIdentification" )
    @JsonProperty( "SystemMessageIdentification" )
    @Nullable
    @ODataField( odataName = "SystemMessageIdentification" )
    private String systemMessageIdentification;
    /**
     * Use with available fluent helpers to apply the <b>SystemMessageIdentification</b> field to query operations.
     *
     */
    public final static CntrlPurContrDistrMessagesField<String> SYSTEM_MESSAGE_IDENTIFICATION =
        new CntrlPurContrDistrMessagesField<String>("SystemMessageIdentification");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SystemMessageNumber</b>
     * </p>
     *
     * @return Message number
     */
    @SerializedName( "SystemMessageNumber" )
    @JsonProperty( "SystemMessageNumber" )
    @Nullable
    @ODataField( odataName = "SystemMessageNumber" )
    private String systemMessageNumber;
    /**
     * Use with available fluent helpers to apply the <b>SystemMessageNumber</b> field to query operations.
     *
     */
    public final static CntrlPurContrDistrMessagesField<String> SYSTEM_MESSAGE_NUMBER =
        new CntrlPurContrDistrMessagesField<String>("SystemMessageNumber");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>SystemMessageVariable1</b>
     * </p>
     *
     * @return Message variable 01
     */
    @SerializedName( "SystemMessageVariable1" )
    @JsonProperty( "SystemMessageVariable1" )
    @Nullable
    @ODataField( odataName = "SystemMessageVariable1" )
    private String systemMessageVariable1;
    /**
     * Use with available fluent helpers to apply the <b>SystemMessageVariable1</b> field to query operations.
     *
     */
    public final static CntrlPurContrDistrMessagesField<String> SYSTEM_MESSAGE_VARIABLE1 =
        new CntrlPurContrDistrMessagesField<String>("SystemMessageVariable1");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>SystemMessageVariable2</b>
     * </p>
     *
     * @return Message variable 02
     */
    @SerializedName( "SystemMessageVariable2" )
    @JsonProperty( "SystemMessageVariable2" )
    @Nullable
    @ODataField( odataName = "SystemMessageVariable2" )
    private String systemMessageVariable2;
    /**
     * Use with available fluent helpers to apply the <b>SystemMessageVariable2</b> field to query operations.
     *
     */
    public final static CntrlPurContrDistrMessagesField<String> SYSTEM_MESSAGE_VARIABLE2 =
        new CntrlPurContrDistrMessagesField<String>("SystemMessageVariable2");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>SystemMessageVariable3</b>
     * </p>
     *
     * @return Message variable 03
     */
    @SerializedName( "SystemMessageVariable3" )
    @JsonProperty( "SystemMessageVariable3" )
    @Nullable
    @ODataField( odataName = "SystemMessageVariable3" )
    private String systemMessageVariable3;
    /**
     * Use with available fluent helpers to apply the <b>SystemMessageVariable3</b> field to query operations.
     *
     */
    public final static CntrlPurContrDistrMessagesField<String> SYSTEM_MESSAGE_VARIABLE3 =
        new CntrlPurContrDistrMessagesField<String>("SystemMessageVariable3");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>SystemMessageVariable4</b>
     * </p>
     *
     * @return Message variable 04
     */
    @SerializedName( "SystemMessageVariable4" )
    @JsonProperty( "SystemMessageVariable4" )
    @Nullable
    @ODataField( odataName = "SystemMessageVariable4" )
    private String systemMessageVariable4;
    /**
     * Use with available fluent helpers to apply the <b>SystemMessageVariable4</b> field to query operations.
     *
     */
    public final static CntrlPurContrDistrMessagesField<String> SYSTEM_MESSAGE_VARIABLE4 =
        new CntrlPurContrDistrMessagesField<String>("SystemMessageVariable4");
    /**
     * Constraints: Not nullable, Maximum length: 220
     * <p>
     * Original property name from the Odata EDM: <b>SystemMessageText</b>
     * </p>
     *
     * @return The systemMessageText contained in this entity.
     */
    @SerializedName( "SystemMessageText" )
    @JsonProperty( "SystemMessageText" )
    @Nullable
    @ODataField( odataName = "SystemMessageText" )
    private String systemMessageText;
    /**
     * Use with available fluent helpers to apply the <b>SystemMessageText</b> field to query operations.
     *
     */
    public final static CntrlPurContrDistrMessagesField<String> SYSTEM_MESSAGE_TEXT =
        new CntrlPurContrDistrMessagesField<String>("SystemMessageText");

    @Nonnull
    @Override
    public Class<CntrlPurContrDistrMessages> getType()
    {
        return CntrlPurContrDistrMessages.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SequenceNumber</b>
     * </p>
     *
     * @param sequenceNumber
     *            Sequence No. of Message during Contract Distribution
     */
    public void setSequenceNumber( @Nullable final String sequenceNumber )
    {
        rememberChangedField("SequenceNumber", this.sequenceNumber);
        this.sequenceNumber = sequenceNumber;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>DistrResponseMessageUUID</b>
     * </p>
     *
     * @param distrResponseMessageUUID
     *            Generic Data Element for GUID Fields (X16)
     */
    public void setDistrResponseMessageUUID( @Nullable final UUID distrResponseMessageUUID )
    {
        rememberChangedField("DistrResponseMessageUUID", this.distrResponseMessageUUID);
        this.distrResponseMessageUUID = distrResponseMessageUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocument</b>
     * </p>
     *
     * @param purchasingDocument
     *            Purchasing Document Number
     */
    public void setPurchasingDocument( @Nullable final String purchasingDocument )
    {
        rememberChangedField("PurchasingDocument", this.purchasingDocument);
        this.purchasingDocument = purchasingDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentCategory</b>
     * </p>
     *
     * @param purchasingDocumentCategory
     *            Purchasing Document Category
     */
    public void setPurchasingDocumentCategory( @Nullable final String purchasingDocumentCategory )
    {
        rememberChangedField("PurchasingDocumentCategory", this.purchasingDocumentCategory);
        this.purchasingDocumentCategory = purchasingDocumentCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ExtContractForPurg</b>
     * </p>
     *
     * @param extContractForPurg
     *            Contract of External System
     */
    public void setExtContractForPurg( @Nullable final String extContractForPurg )
    {
        rememberChangedField("ExtContractForPurg", this.extContractForPurg);
        this.extContractForPurg = extContractForPurg;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>LogicalSystem</b>
     * </p>
     *
     * @param logicalSystem
     *            Logical System
     */
    public void setLogicalSystem( @Nullable final String logicalSystem )
    {
        rememberChangedField("LogicalSystem", this.logicalSystem);
        this.logicalSystem = logicalSystem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SystemMessageType</b>
     * </p>
     *
     * @param systemMessageType
     *            Message Type
     */
    public void setSystemMessageType( @Nullable final String systemMessageType )
    {
        rememberChangedField("SystemMessageType", this.systemMessageType);
        this.systemMessageType = systemMessageType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SystemMessageIdentification</b>
     * </p>
     *
     * @param systemMessageIdentification
     *            Message identification
     */
    public void setSystemMessageIdentification( @Nullable final String systemMessageIdentification )
    {
        rememberChangedField("SystemMessageIdentification", this.systemMessageIdentification);
        this.systemMessageIdentification = systemMessageIdentification;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SystemMessageNumber</b>
     * </p>
     *
     * @param systemMessageNumber
     *            Message number
     */
    public void setSystemMessageNumber( @Nullable final String systemMessageNumber )
    {
        rememberChangedField("SystemMessageNumber", this.systemMessageNumber);
        this.systemMessageNumber = systemMessageNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>SystemMessageVariable1</b>
     * </p>
     *
     * @param systemMessageVariable1
     *            Message variable 01
     */
    public void setSystemMessageVariable1( @Nullable final String systemMessageVariable1 )
    {
        rememberChangedField("SystemMessageVariable1", this.systemMessageVariable1);
        this.systemMessageVariable1 = systemMessageVariable1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>SystemMessageVariable2</b>
     * </p>
     *
     * @param systemMessageVariable2
     *            Message variable 02
     */
    public void setSystemMessageVariable2( @Nullable final String systemMessageVariable2 )
    {
        rememberChangedField("SystemMessageVariable2", this.systemMessageVariable2);
        this.systemMessageVariable2 = systemMessageVariable2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>SystemMessageVariable3</b>
     * </p>
     *
     * @param systemMessageVariable3
     *            Message variable 03
     */
    public void setSystemMessageVariable3( @Nullable final String systemMessageVariable3 )
    {
        rememberChangedField("SystemMessageVariable3", this.systemMessageVariable3);
        this.systemMessageVariable3 = systemMessageVariable3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>SystemMessageVariable4</b>
     * </p>
     *
     * @param systemMessageVariable4
     *            Message variable 04
     */
    public void setSystemMessageVariable4( @Nullable final String systemMessageVariable4 )
    {
        rememberChangedField("SystemMessageVariable4", this.systemMessageVariable4);
        this.systemMessageVariable4 = systemMessageVariable4;
    }

    /**
     * Constraints: Not nullable, Maximum length: 220
     * <p>
     * Original property name from the Odata EDM: <b>SystemMessageText</b>
     * </p>
     *
     * @param systemMessageText
     *            The systemMessageText to set.
     */
    public void setSystemMessageText( @Nullable final String systemMessageText )
    {
        rememberChangedField("SystemMessageText", this.systemMessageText);
        this.systemMessageText = systemMessageText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_CntrlPurContrDistrMessages";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SequenceNumber", getSequenceNumber());
        result.put("DistrResponseMessageUUID", getDistrResponseMessageUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SequenceNumber", getSequenceNumber());
        values.put("DistrResponseMessageUUID", getDistrResponseMessageUUID());
        values.put("PurchasingDocument", getPurchasingDocument());
        values.put("PurchasingDocumentCategory", getPurchasingDocumentCategory());
        values.put("ExtContractForPurg", getExtContractForPurg());
        values.put("LogicalSystem", getLogicalSystem());
        values.put("SystemMessageType", getSystemMessageType());
        values.put("SystemMessageIdentification", getSystemMessageIdentification());
        values.put("SystemMessageNumber", getSystemMessageNumber());
        values.put("SystemMessageVariable1", getSystemMessageVariable1());
        values.put("SystemMessageVariable2", getSystemMessageVariable2());
        values.put("SystemMessageVariable3", getSystemMessageVariable3());
        values.put("SystemMessageVariable4", getSystemMessageVariable4());
        values.put("SystemMessageText", getSystemMessageText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SequenceNumber") ) {
                final Object value = values.remove("SequenceNumber");
                if( (value == null) || (!value.equals(getSequenceNumber())) ) {
                    setSequenceNumber(((String) value));
                }
            }
            if( values.containsKey("DistrResponseMessageUUID") ) {
                final Object value = values.remove("DistrResponseMessageUUID");
                if( (value == null) || (!value.equals(getDistrResponseMessageUUID())) ) {
                    setDistrResponseMessageUUID(((UUID) value));
                }
            }
            if( values.containsKey("PurchasingDocument") ) {
                final Object value = values.remove("PurchasingDocument");
                if( (value == null) || (!value.equals(getPurchasingDocument())) ) {
                    setPurchasingDocument(((String) value));
                }
            }
            if( values.containsKey("PurchasingDocumentCategory") ) {
                final Object value = values.remove("PurchasingDocumentCategory");
                if( (value == null) || (!value.equals(getPurchasingDocumentCategory())) ) {
                    setPurchasingDocumentCategory(((String) value));
                }
            }
            if( values.containsKey("ExtContractForPurg") ) {
                final Object value = values.remove("ExtContractForPurg");
                if( (value == null) || (!value.equals(getExtContractForPurg())) ) {
                    setExtContractForPurg(((String) value));
                }
            }
            if( values.containsKey("LogicalSystem") ) {
                final Object value = values.remove("LogicalSystem");
                if( (value == null) || (!value.equals(getLogicalSystem())) ) {
                    setLogicalSystem(((String) value));
                }
            }
            if( values.containsKey("SystemMessageType") ) {
                final Object value = values.remove("SystemMessageType");
                if( (value == null) || (!value.equals(getSystemMessageType())) ) {
                    setSystemMessageType(((String) value));
                }
            }
            if( values.containsKey("SystemMessageIdentification") ) {
                final Object value = values.remove("SystemMessageIdentification");
                if( (value == null) || (!value.equals(getSystemMessageIdentification())) ) {
                    setSystemMessageIdentification(((String) value));
                }
            }
            if( values.containsKey("SystemMessageNumber") ) {
                final Object value = values.remove("SystemMessageNumber");
                if( (value == null) || (!value.equals(getSystemMessageNumber())) ) {
                    setSystemMessageNumber(((String) value));
                }
            }
            if( values.containsKey("SystemMessageVariable1") ) {
                final Object value = values.remove("SystemMessageVariable1");
                if( (value == null) || (!value.equals(getSystemMessageVariable1())) ) {
                    setSystemMessageVariable1(((String) value));
                }
            }
            if( values.containsKey("SystemMessageVariable2") ) {
                final Object value = values.remove("SystemMessageVariable2");
                if( (value == null) || (!value.equals(getSystemMessageVariable2())) ) {
                    setSystemMessageVariable2(((String) value));
                }
            }
            if( values.containsKey("SystemMessageVariable3") ) {
                final Object value = values.remove("SystemMessageVariable3");
                if( (value == null) || (!value.equals(getSystemMessageVariable3())) ) {
                    setSystemMessageVariable3(((String) value));
                }
            }
            if( values.containsKey("SystemMessageVariable4") ) {
                final Object value = values.remove("SystemMessageVariable4");
                if( (value == null) || (!value.equals(getSystemMessageVariable4())) ) {
                    setSystemMessageVariable4(((String) value));
                }
            }
            if( values.containsKey("SystemMessageText") ) {
                final Object value = values.remove("SystemMessageText");
                if( (value == null) || (!value.equals(getSystemMessageText())) ) {
                    setSystemMessageText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> CntrlPurContrDistrMessagesField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new CntrlPurContrDistrMessagesField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CntrlPurContrDistrMessagesField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CntrlPurContrDistrMessagesField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.CentralPurchaseContractService.DEFAULT_SERVICE_PATH);
    }

}
