/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract;

import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.selectable.CntrlPurContrDistrMessagesSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrDistrMessages
 * CntrlPurContrDistrMessages} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class CntrlPurContrDistrMessagesByKeyFluentHelper
    extends
    FluentHelperByKey<CntrlPurContrDistrMessagesByKeyFluentHelper, CntrlPurContrDistrMessages, CntrlPurContrDistrMessagesSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.CntrlPurContrDistrMessages
     * CntrlPurContrDistrMessages} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code CntrlPurContrDistrMessages}
     * @param sequenceNumber
     *            Sequence No. of Message during Contract Distribution
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code CntrlPurContrDistrMessages}
     * @param distrResponseMessageUUID
     *            Generic Data Element for GUID Fields (X16)
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     */
    public CntrlPurContrDistrMessagesByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String sequenceNumber,
        final UUID distrResponseMessageUUID )
    {
        super(servicePath, entityCollection);
        this.key.put("SequenceNumber", sequenceNumber);
        this.key.put("DistrResponseMessageUUID", distrResponseMessageUUID);
    }

    @Override
    @Nonnull
    protected Class<CntrlPurContrDistrMessages> getEntityClass()
    {
        return CntrlPurContrDistrMessages.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
