/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.field.CntrlPurContrHdrCndnValdtyField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.link.CntrlPurContrHdrCndnValdtyLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.link.CntrlPurContrHdrCndnValdtyOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.selectable.CntrlPurContrHdrCndnValdtySelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Header Condition Validity
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_CntrlPurContrHdrCndnValdtyType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CntrlPurContrHdrCndnValdty extends VdmEntity<CntrlPurContrHdrCndnValdty>
{

    /**
     * Selector for all available fields of CntrlPurContrHdrCndnValdty.
     *
     */
    public final static CntrlPurContrHdrCndnValdtySelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CentralPurchaseContract</b>
     * </p>
     *
     * @return Purchasing Document Number
     */
    @Key
    @SerializedName( "CentralPurchaseContract" )
    @JsonProperty( "CentralPurchaseContract" )
    @Nullable
    @ODataField( odataName = "CentralPurchaseContract" )
    private String centralPurchaseContract;
    /**
     * Use with available fluent helpers to apply the <b>CentralPurchaseContract</b> field to query operations.
     *
     */
    public final static CntrlPurContrHdrCndnValdtyField<String> CENTRAL_PURCHASE_CONTRACT =
        new CntrlPurContrHdrCndnValdtyField<String>("CentralPurchaseContract");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRecord</b>
     * </p>
     *
     * @return Number of Condition Record
     */
    @Key
    @SerializedName( "ConditionRecord" )
    @JsonProperty( "ConditionRecord" )
    @Nullable
    @ODataField( odataName = "ConditionRecord" )
    private String conditionRecord;
    /**
     * Use with available fluent helpers to apply the <b>ConditionRecord</b> field to query operations.
     *
     */
    public final static CntrlPurContrHdrCndnValdtyField<String> CONDITION_RECORD =
        new CntrlPurContrHdrCndnValdtyField<String>("ConditionRecord");
    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConditionValidityEndDate</b>
     * </p>
     *
     * @return Validity end date of the condition record
     */
    @Key
    @SerializedName( "ConditionValidityEndDate" )
    @JsonProperty( "ConditionValidityEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ConditionValidityEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime conditionValidityEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ConditionValidityEndDate</b> field to query operations.
     *
     */
    public final static CntrlPurContrHdrCndnValdtyField<LocalDateTime> CONDITION_VALIDITY_END_DATE =
        new CntrlPurContrHdrCndnValdtyField<LocalDateTime>("ConditionValidityEndDate");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConditionApplication</b>
     * </p>
     *
     * @return Application
     */
    @SerializedName( "ConditionApplication" )
    @JsonProperty( "ConditionApplication" )
    @Nullable
    @ODataField( odataName = "ConditionApplication" )
    private String conditionApplication;
    /**
     * Use with available fluent helpers to apply the <b>ConditionApplication</b> field to query operations.
     *
     */
    public final static CntrlPurContrHdrCndnValdtyField<String> CONDITION_APPLICATION =
        new CntrlPurContrHdrCndnValdtyField<String>("ConditionApplication");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ConditionType</b>
     * </p>
     *
     * @return Condition Type
     */
    @SerializedName( "ConditionType" )
    @JsonProperty( "ConditionType" )
    @Nullable
    @ODataField( odataName = "ConditionType" )
    private String conditionType;
    /**
     * Use with available fluent helpers to apply the <b>ConditionType</b> field to query operations.
     *
     */
    public final static CntrlPurContrHdrCndnValdtyField<String> CONDITION_TYPE =
        new CntrlPurContrHdrCndnValdtyField<String>("ConditionType");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConditionValidityStartDate</b>
     * </p>
     *
     * @return Validity start date of the condition record
     */
    @SerializedName( "ConditionValidityStartDate" )
    @JsonProperty( "ConditionValidityStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ConditionValidityStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime conditionValidityStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ConditionValidityStartDate</b> field to query operations.
     *
     */
    public final static CntrlPurContrHdrCndnValdtyField<LocalDateTime> CONDITION_VALIDITY_START_DATE =
        new CntrlPurContrHdrCndnValdtyField<LocalDateTime>("ConditionValidityStartDate");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ConditionIsDeleted</b>
     * </p>
     *
     * @return Deletion Indicator for Condition Record
     */
    @SerializedName( "ConditionIsDeleted" )
    @JsonProperty( "ConditionIsDeleted" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ConditionIsDeleted" )
    private Boolean conditionIsDeleted;
    /**
     * Use with available fluent helpers to apply the <b>ConditionIsDeleted</b> field to query operations.
     *
     */
    public final static CntrlPurContrHdrCndnValdtyField<Boolean> CONDITION_IS_DELETED =
        new CntrlPurContrHdrCndnValdtyField<Boolean>("ConditionIsDeleted");
    /**
     * Navigation property <b>to_CentralPurchaseContract</b> for <b>CntrlPurContrHdrCndnValdty</b> to single
     * <b>CentralPurchaseContract</b>.
     *
     */
    @SerializedName( "to_CentralPurchaseContract" )
    @JsonProperty( "to_CentralPurchaseContract" )
    @ODataField( odataName = "to_CentralPurchaseContract" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private CentralPurchaseContract toCentralPurchaseContract;
    /**
     * Navigation property <b>to_CntrlPurContrHdrCndnAmount</b> for <b>CntrlPurContrHdrCndnValdty</b> to multiple
     * <b>CntrlPurContrHdrCndnAmount</b>.
     *
     */
    @SerializedName( "to_CntrlPurContrHdrCndnAmount" )
    @JsonProperty( "to_CntrlPurContrHdrCndnAmount" )
    @ODataField( odataName = "to_CntrlPurContrHdrCndnAmount" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<CntrlPurContrHdrCndnAmount> toCntrlPurContrHdrCndnAmount;
    /**
     * Use with available fluent helpers to apply the <b>to_CentralPurchaseContract</b> navigation property to query
     * operations.
     *
     */
    public final static CntrlPurContrHdrCndnValdtyOneToOneLink<CentralPurchaseContract> TO_CENTRAL_PURCHASE_CONTRACT =
        new CntrlPurContrHdrCndnValdtyOneToOneLink<CentralPurchaseContract>("to_CentralPurchaseContract");
    /**
     * Use with available fluent helpers to apply the <b>to_CntrlPurContrHdrCndnAmount</b> navigation property to query
     * operations.
     *
     */
    public final static CntrlPurContrHdrCndnValdtyLink<CntrlPurContrHdrCndnAmount> TO_CNTRL_PUR_CONTR_HDR_CNDN_AMOUNT =
        new CntrlPurContrHdrCndnValdtyLink<CntrlPurContrHdrCndnAmount>("to_CntrlPurContrHdrCndnAmount");

    @Nonnull
    @Override
    public Class<CntrlPurContrHdrCndnValdty> getType()
    {
        return CntrlPurContrHdrCndnValdty.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CentralPurchaseContract</b>
     * </p>
     *
     * @param centralPurchaseContract
     *            Purchasing Document Number
     */
    public void setCentralPurchaseContract( @Nullable final String centralPurchaseContract )
    {
        rememberChangedField("CentralPurchaseContract", this.centralPurchaseContract);
        this.centralPurchaseContract = centralPurchaseContract;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRecord</b>
     * </p>
     *
     * @param conditionRecord
     *            Number of Condition Record
     */
    public void setConditionRecord( @Nullable final String conditionRecord )
    {
        rememberChangedField("ConditionRecord", this.conditionRecord);
        this.conditionRecord = conditionRecord;
    }

    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConditionValidityEndDate</b>
     * </p>
     *
     * @param conditionValidityEndDate
     *            Validity end date of the condition record
     */
    public void setConditionValidityEndDate( @Nullable final LocalDateTime conditionValidityEndDate )
    {
        rememberChangedField("ConditionValidityEndDate", this.conditionValidityEndDate);
        this.conditionValidityEndDate = conditionValidityEndDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConditionApplication</b>
     * </p>
     *
     * @param conditionApplication
     *            Application
     */
    public void setConditionApplication( @Nullable final String conditionApplication )
    {
        rememberChangedField("ConditionApplication", this.conditionApplication);
        this.conditionApplication = conditionApplication;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ConditionType</b>
     * </p>
     *
     * @param conditionType
     *            Condition Type
     */
    public void setConditionType( @Nullable final String conditionType )
    {
        rememberChangedField("ConditionType", this.conditionType);
        this.conditionType = conditionType;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConditionValidityStartDate</b>
     * </p>
     *
     * @param conditionValidityStartDate
     *            Validity start date of the condition record
     */
    public void setConditionValidityStartDate( @Nullable final LocalDateTime conditionValidityStartDate )
    {
        rememberChangedField("ConditionValidityStartDate", this.conditionValidityStartDate);
        this.conditionValidityStartDate = conditionValidityStartDate;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ConditionIsDeleted</b>
     * </p>
     *
     * @param conditionIsDeleted
     *            Deletion Indicator for Condition Record
     */
    public void setConditionIsDeleted( @Nullable final Boolean conditionIsDeleted )
    {
        rememberChangedField("ConditionIsDeleted", this.conditionIsDeleted);
        this.conditionIsDeleted = conditionIsDeleted;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_CntrlPurContrHdrCndnValdty";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("CentralPurchaseContract", getCentralPurchaseContract());
        result.put("ConditionRecord", getConditionRecord());
        result.put("ConditionValidityEndDate", getConditionValidityEndDate());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("CentralPurchaseContract", getCentralPurchaseContract());
        values.put("ConditionRecord", getConditionRecord());
        values.put("ConditionValidityEndDate", getConditionValidityEndDate());
        values.put("ConditionApplication", getConditionApplication());
        values.put("ConditionType", getConditionType());
        values.put("ConditionValidityStartDate", getConditionValidityStartDate());
        values.put("ConditionIsDeleted", getConditionIsDeleted());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CentralPurchaseContract") ) {
                final Object value = values.remove("CentralPurchaseContract");
                if( (value == null) || (!value.equals(getCentralPurchaseContract())) ) {
                    setCentralPurchaseContract(((String) value));
                }
            }
            if( values.containsKey("ConditionRecord") ) {
                final Object value = values.remove("ConditionRecord");
                if( (value == null) || (!value.equals(getConditionRecord())) ) {
                    setConditionRecord(((String) value));
                }
            }
            if( values.containsKey("ConditionValidityEndDate") ) {
                final Object value = values.remove("ConditionValidityEndDate");
                if( (value == null) || (!value.equals(getConditionValidityEndDate())) ) {
                    setConditionValidityEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ConditionApplication") ) {
                final Object value = values.remove("ConditionApplication");
                if( (value == null) || (!value.equals(getConditionApplication())) ) {
                    setConditionApplication(((String) value));
                }
            }
            if( values.containsKey("ConditionType") ) {
                final Object value = values.remove("ConditionType");
                if( (value == null) || (!value.equals(getConditionType())) ) {
                    setConditionType(((String) value));
                }
            }
            if( values.containsKey("ConditionValidityStartDate") ) {
                final Object value = values.remove("ConditionValidityStartDate");
                if( (value == null) || (!value.equals(getConditionValidityStartDate())) ) {
                    setConditionValidityStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ConditionIsDeleted") ) {
                final Object value = values.remove("ConditionIsDeleted");
                if( (value == null) || (!value.equals(getConditionIsDeleted())) ) {
                    setConditionIsDeleted(((Boolean) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CentralPurchaseContract") ) {
                final Object value = (values).remove("to_CentralPurchaseContract");
                if( value instanceof Map ) {
                    if( toCentralPurchaseContract == null ) {
                        toCentralPurchaseContract = new CentralPurchaseContract();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCentralPurchaseContract.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_CntrlPurContrHdrCndnAmount") ) {
                final Object value = (values).remove("to_CntrlPurContrHdrCndnAmount");
                if( value instanceof Iterable ) {
                    if( toCntrlPurContrHdrCndnAmount == null ) {
                        toCntrlPurContrHdrCndnAmount = Lists.newArrayList();
                    } else {
                        toCntrlPurContrHdrCndnAmount = Lists.newArrayList(toCntrlPurContrHdrCndnAmount);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        CntrlPurContrHdrCndnAmount entity;
                        if( toCntrlPurContrHdrCndnAmount.size() > i ) {
                            entity = toCntrlPurContrHdrCndnAmount.get(i);
                        } else {
                            entity = new CntrlPurContrHdrCndnAmount();
                            toCntrlPurContrHdrCndnAmount.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> CntrlPurContrHdrCndnValdtyField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new CntrlPurContrHdrCndnValdtyField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CntrlPurContrHdrCndnValdtyField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CntrlPurContrHdrCndnValdtyField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.CentralPurchaseContractService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCentralPurchaseContract != null ) {
            (values).put("to_CentralPurchaseContract", toCentralPurchaseContract);
        }
        if( toCntrlPurContrHdrCndnAmount != null ) {
            (values).put("to_CntrlPurContrHdrCndnAmount", toCntrlPurContrHdrCndnAmount);
        }
        return values;
    }

    /**
     * Fetches the <b>CentralPurchaseContract</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_CentralPurchaseContract</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>CentralPurchaseContract</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public CentralPurchaseContract fetchCentralPurchaseContract()
    {
        return fetchFieldAsSingle("to_CentralPurchaseContract", CentralPurchaseContract.class);
    }

    /**
     * Retrieval of associated <b>CentralPurchaseContract</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_CentralPurchaseContract</b>.
     * <p>
     * If the navigation property <b>to_CentralPurchaseContract</b> of a queried <b>CntrlPurContrHdrCndnValdty</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CentralPurchaseContract</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public CentralPurchaseContract getCentralPurchaseContractOrFetch()
    {
        if( toCentralPurchaseContract == null ) {
            toCentralPurchaseContract = fetchCentralPurchaseContract();
        }
        return toCentralPurchaseContract;
    }

    /**
     * Retrieval of associated <b>CentralPurchaseContract</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_CentralPurchaseContract</b>.
     * <p>
     * If the navigation property for an entity <b>CntrlPurContrHdrCndnValdty</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CentralPurchaseContract</b> is already loaded, the
     *         result will contain the <b>CentralPurchaseContract</b> entity. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<CentralPurchaseContract> getCentralPurchaseContractIfPresent()
    {
        return Option.of(toCentralPurchaseContract);
    }

    /**
     * Overwrites the associated <b>CentralPurchaseContract</b> entity for the loaded navigation property
     * <b>to_CentralPurchaseContract</b>.
     *
     * @param value
     *            New <b>CentralPurchaseContract</b> entity.
     */
    public void setCentralPurchaseContract( final CentralPurchaseContract value )
    {
        toCentralPurchaseContract = value;
    }

    /**
     * Fetches the <b>CntrlPurContrHdrCndnAmount</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_CntrlPurContrHdrCndnAmount</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>CntrlPurContrHdrCndnAmount</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CntrlPurContrHdrCndnAmount> fetchCntrlPurContrHdrCndnAmount()
    {
        return fetchFieldAsList("to_CntrlPurContrHdrCndnAmount", CntrlPurContrHdrCndnAmount.class);
    }

    /**
     * Retrieval of associated <b>CntrlPurContrHdrCndnAmount</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CntrlPurContrHdrCndnAmount</b>.
     * <p>
     * If the navigation property <b>to_CntrlPurContrHdrCndnAmount</b> of a queried <b>CntrlPurContrHdrCndnValdty</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CntrlPurContrHdrCndnAmount</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CntrlPurContrHdrCndnAmount> getCntrlPurContrHdrCndnAmountOrFetch()
    {
        if( toCntrlPurContrHdrCndnAmount == null ) {
            toCntrlPurContrHdrCndnAmount = fetchCntrlPurContrHdrCndnAmount();
        }
        return toCntrlPurContrHdrCndnAmount;
    }

    /**
     * Retrieval of associated <b>CntrlPurContrHdrCndnAmount</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CntrlPurContrHdrCndnAmount</b>.
     * <p>
     * If the navigation property for an entity <b>CntrlPurContrHdrCndnValdty</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CntrlPurContrHdrCndnAmount</b> is already loaded, the
     *         result will contain the <b>CntrlPurContrHdrCndnAmount</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<CntrlPurContrHdrCndnAmount>> getCntrlPurContrHdrCndnAmountIfPresent()
    {
        return Option.of(toCntrlPurContrHdrCndnAmount);
    }

    /**
     * Overwrites the list of associated <b>CntrlPurContrHdrCndnAmount</b> entities for the loaded navigation property
     * <b>to_CntrlPurContrHdrCndnAmount</b>.
     * <p>
     * If the navigation property <b>to_CntrlPurContrHdrCndnAmount</b> of a queried <b>CntrlPurContrHdrCndnValdty</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>CntrlPurContrHdrCndnAmount</b> entities.
     */
    public void setCntrlPurContrHdrCndnAmount( @Nonnull final List<CntrlPurContrHdrCndnAmount> value )
    {
        if( toCntrlPurContrHdrCndnAmount == null ) {
            toCntrlPurContrHdrCndnAmount = Lists.newArrayList();
        }
        toCntrlPurContrHdrCndnAmount.clear();
        toCntrlPurContrHdrCndnAmount.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>CntrlPurContrHdrCndnAmount</b> entities. This corresponds to the OData
     * navigation property <b>to_CntrlPurContrHdrCndnAmount</b>.
     * <p>
     * If the navigation property <b>to_CntrlPurContrHdrCndnAmount</b> of a queried <b>CntrlPurContrHdrCndnValdty</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>CntrlPurContrHdrCndnAmount</b> entities.
     */
    public void addCntrlPurContrHdrCndnAmount( CntrlPurContrHdrCndnAmount... entity )
    {
        if( toCntrlPurContrHdrCndnAmount == null ) {
            toCntrlPurContrHdrCndnAmount = Lists.newArrayList();
        }
        toCntrlPurContrHdrCndnAmount.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of CntrlPurContrHdrCndnValdty instances.
     *
     */
    public final static class CntrlPurContrHdrCndnValdtyBuilder
    {

        private CentralPurchaseContract toCentralPurchaseContract;
        private String centralPurchaseContract = null;
        private List<CntrlPurContrHdrCndnAmount> toCntrlPurContrHdrCndnAmount = Lists.newArrayList();

        private CntrlPurContrHdrCndnValdty.CntrlPurContrHdrCndnValdtyBuilder toCentralPurchaseContract(
            final CentralPurchaseContract value )
        {
            toCentralPurchaseContract = value;
            return this;
        }

        /**
         * Navigation property <b>to_CentralPurchaseContract</b> for <b>CntrlPurContrHdrCndnValdty</b> to single
         * <b>CentralPurchaseContract</b>.
         *
         * @param value
         *            The CentralPurchaseContract to build this CntrlPurContrHdrCndnValdty with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CntrlPurContrHdrCndnValdty.CntrlPurContrHdrCndnValdtyBuilder centralPurchaseContract(
            final CentralPurchaseContract value )
        {
            return toCentralPurchaseContract(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 10
         * <p>
         * Original property name from the Odata EDM: <b>CentralPurchaseContract</b>
         * </p>
         *
         * @param value
         *            The centralPurchaseContract to build this CntrlPurContrHdrCndnValdty with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CntrlPurContrHdrCndnValdty.CntrlPurContrHdrCndnValdtyBuilder centralPurchaseContract(
            final String value )
        {
            centralPurchaseContract = value;
            return this;
        }

        private CntrlPurContrHdrCndnValdty.CntrlPurContrHdrCndnValdtyBuilder toCntrlPurContrHdrCndnAmount(
            final List<CntrlPurContrHdrCndnAmount> value )
        {
            toCntrlPurContrHdrCndnAmount.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CntrlPurContrHdrCndnAmount</b> for <b>CntrlPurContrHdrCndnValdty</b> to multiple
         * <b>CntrlPurContrHdrCndnAmount</b>.
         *
         * @param value
         *            The CntrlPurContrHdrCndnAmounts to build this CntrlPurContrHdrCndnValdty with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CntrlPurContrHdrCndnValdty.CntrlPurContrHdrCndnValdtyBuilder cntrlPurContrHdrCndnAmount(
            CntrlPurContrHdrCndnAmount... value )
        {
            return toCntrlPurContrHdrCndnAmount(Lists.newArrayList(value));
        }

    }

}
