/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.field.CntrlPurContrHdrDistributionField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.link.CntrlPurContrHdrDistributionLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.link.CntrlPurContrHdrDistributionOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.centralpurchasecontract.selectable.CntrlPurContrHdrDistributionSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Header Distribution
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_CntrlPurContrHdrDistributionType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CntrlPurContrHdrDistribution extends VdmEntity<CntrlPurContrHdrDistribution>
{

    /**
     * Selector for all available fields of CntrlPurContrHdrDistribution.
     *
     */
    public final static CntrlPurContrHdrDistributionSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CentralPurchaseContract</b>
     * </p>
     *
     * @return Purchasing Document Number
     */
    @Key
    @SerializedName( "CentralPurchaseContract" )
    @JsonProperty( "CentralPurchaseContract" )
    @Nullable
    @ODataField( odataName = "CentralPurchaseContract" )
    private String centralPurchaseContract;
    /**
     * Use with available fluent helpers to apply the <b>CentralPurchaseContract</b> field to query operations.
     *
     */
    public final static CntrlPurContrHdrDistributionField<String> CENTRAL_PURCHASE_CONTRACT =
        new CntrlPurContrHdrDistributionField<String>("CentralPurchaseContract");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>DistributionKey</b>
     * </p>
     *
     * @return Distribution Number of Central Purchasing Document
     */
    @Key
    @SerializedName( "DistributionKey" )
    @JsonProperty( "DistributionKey" )
    @Nullable
    @ODataField( odataName = "DistributionKey" )
    private String distributionKey;
    /**
     * Use with available fluent helpers to apply the <b>DistributionKey</b> field to query operations.
     *
     */
    public final static CntrlPurContrHdrDistributionField<String> DISTRIBUTION_KEY =
        new CntrlPurContrHdrDistributionField<String>("DistributionKey");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CentralPurchaseContractItem</b>
     * </p>
     *
     * @return Item Number of Purchasing Document
     */
    @SerializedName( "CentralPurchaseContractItem" )
    @JsonProperty( "CentralPurchaseContractItem" )
    @Nullable
    @ODataField( odataName = "CentralPurchaseContractItem" )
    private String centralPurchaseContractItem;
    /**
     * Use with available fluent helpers to apply the <b>CentralPurchaseContractItem</b> field to query operations.
     *
     */
    public final static CntrlPurContrHdrDistributionField<String> CENTRAL_PURCHASE_CONTRACT_ITEM =
        new CntrlPurContrHdrDistributionField<String>("CentralPurchaseContractItem");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProcmtHubCompanyCode</b>
     * </p>
     *
     * @return Company Code
     */
    @SerializedName( "ProcmtHubCompanyCode" )
    @JsonProperty( "ProcmtHubCompanyCode" )
    @Nullable
    @ODataField( odataName = "ProcmtHubCompanyCode" )
    private String procmtHubCompanyCode;
    /**
     * Use with available fluent helpers to apply the <b>ProcmtHubCompanyCode</b> field to query operations.
     *
     */
    public final static CntrlPurContrHdrDistributionField<String> PROCMT_HUB_COMPANY_CODE =
        new CntrlPurContrHdrDistributionField<String>("ProcmtHubCompanyCode");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProcmtHubPlant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "ProcmtHubPlant" )
    @JsonProperty( "ProcmtHubPlant" )
    @Nullable
    @ODataField( odataName = "ProcmtHubPlant" )
    private String procmtHubPlant;
    /**
     * Use with available fluent helpers to apply the <b>ProcmtHubPlant</b> field to query operations.
     *
     */
    public final static CntrlPurContrHdrDistributionField<String> PROCMT_HUB_PLANT =
        new CntrlPurContrHdrDistributionField<String>("ProcmtHubPlant");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProcmtHubPurchasingOrg</b>
     * </p>
     *
     * @return Purchasing Organization
     */
    @SerializedName( "ProcmtHubPurchasingOrg" )
    @JsonProperty( "ProcmtHubPurchasingOrg" )
    @Nullable
    @ODataField( odataName = "ProcmtHubPurchasingOrg" )
    private String procmtHubPurchasingOrg;
    /**
     * Use with available fluent helpers to apply the <b>ProcmtHubPurchasingOrg</b> field to query operations.
     *
     */
    public final static CntrlPurContrHdrDistributionField<String> PROCMT_HUB_PURCHASING_ORG =
        new CntrlPurContrHdrDistributionField<String>("ProcmtHubPurchasingOrg");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProcmtHubPurchasingGroup</b>
     * </p>
     *
     * @return Purchasing Group
     */
    @SerializedName( "ProcmtHubPurchasingGroup" )
    @JsonProperty( "ProcmtHubPurchasingGroup" )
    @Nullable
    @ODataField( odataName = "ProcmtHubPurchasingGroup" )
    private String procmtHubPurchasingGroup;
    /**
     * Use with available fluent helpers to apply the <b>ProcmtHubPurchasingGroup</b> field to query operations.
     *
     */
    public final static CntrlPurContrHdrDistributionField<String> PROCMT_HUB_PURCHASING_GROUP =
        new CntrlPurContrHdrDistributionField<String>("ProcmtHubPurchasingGroup");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProcmtHubCompanyCodeGroupingID</b>
     * </p>
     *
     * @return Grouping ID for Company Codes
     */
    @SerializedName( "ProcmtHubCompanyCodeGroupingID" )
    @JsonProperty( "ProcmtHubCompanyCodeGroupingID" )
    @Nullable
    @ODataField( odataName = "ProcmtHubCompanyCodeGroupingID" )
    private String procmtHubCompanyCodeGroupingID;
    /**
     * Use with available fluent helpers to apply the <b>ProcmtHubCompanyCodeGroupingID</b> field to query operations.
     *
     */
    public final static CntrlPurContrHdrDistributionField<String> PROCMT_HUB_COMPANY_CODE_GROUPING_ID =
        new CntrlPurContrHdrDistributionField<String>("ProcmtHubCompanyCodeGroupingID");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CntrlPurContrDistrCurrency</b>
     * </p>
     *
     * @return Currency Key
     */
    @SerializedName( "CntrlPurContrDistrCurrency" )
    @JsonProperty( "CntrlPurContrDistrCurrency" )
    @Nullable
    @ODataField( odataName = "CntrlPurContrDistrCurrency" )
    private String cntrlPurContrDistrCurrency;
    /**
     * Use with available fluent helpers to apply the <b>CntrlPurContrDistrCurrency</b> field to query operations.
     *
     */
    public final static CntrlPurContrHdrDistributionField<String> CNTRL_PUR_CONTR_DISTR_CURRENCY =
        new CntrlPurContrHdrDistributionField<String>("CntrlPurContrDistrCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PaymentTerms</b>
     * </p>
     *
     * @return Terms of Payment Key
     */
    @SerializedName( "PaymentTerms" )
    @JsonProperty( "PaymentTerms" )
    @Nullable
    @ODataField( odataName = "PaymentTerms" )
    private String paymentTerms;
    /**
     * Use with available fluent helpers to apply the <b>PaymentTerms</b> field to query operations.
     *
     */
    public final static CntrlPurContrHdrDistributionField<String> PAYMENT_TERMS =
        new CntrlPurContrHdrDistributionField<String>("PaymentTerms");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount1Days</b>
     * </p>
     *
     * @return Cash discount days 1
     */
    @SerializedName( "CashDiscount1Days" )
    @JsonProperty( "CashDiscount1Days" )
    @Nullable
    @ODataField( odataName = "CashDiscount1Days" )
    private BigDecimal cashDiscount1Days;
    /**
     * Use with available fluent helpers to apply the <b>CashDiscount1Days</b> field to query operations.
     *
     */
    public final static CntrlPurContrHdrDistributionField<BigDecimal> CASH_DISCOUNT1_DAYS =
        new CntrlPurContrHdrDistributionField<BigDecimal>("CashDiscount1Days");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount2Days</b>
     * </p>
     *
     * @return Cash discount days 2
     */
    @SerializedName( "CashDiscount2Days" )
    @JsonProperty( "CashDiscount2Days" )
    @Nullable
    @ODataField( odataName = "CashDiscount2Days" )
    private BigDecimal cashDiscount2Days;
    /**
     * Use with available fluent helpers to apply the <b>CashDiscount2Days</b> field to query operations.
     *
     */
    public final static CntrlPurContrHdrDistributionField<BigDecimal> CASH_DISCOUNT2_DAYS =
        new CntrlPurContrHdrDistributionField<BigDecimal>("CashDiscount2Days");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>NetPaymentDays</b>
     * </p>
     *
     * @return Net Payment Terms Period
     */
    @SerializedName( "NetPaymentDays" )
    @JsonProperty( "NetPaymentDays" )
    @Nullable
    @ODataField( odataName = "NetPaymentDays" )
    private BigDecimal netPaymentDays;
    /**
     * Use with available fluent helpers to apply the <b>NetPaymentDays</b> field to query operations.
     *
     */
    public final static CntrlPurContrHdrDistributionField<BigDecimal> NET_PAYMENT_DAYS =
        new CntrlPurContrHdrDistributionField<BigDecimal>("NetPaymentDays");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount1Percent</b>
     * </p>
     *
     * @return Cash Discount Percentage 1
     */
    @SerializedName( "CashDiscount1Percent" )
    @JsonProperty( "CashDiscount1Percent" )
    @Nullable
    @ODataField( odataName = "CashDiscount1Percent" )
    private BigDecimal cashDiscount1Percent;
    /**
     * Use with available fluent helpers to apply the <b>CashDiscount1Percent</b> field to query operations.
     *
     */
    public final static CntrlPurContrHdrDistributionField<BigDecimal> CASH_DISCOUNT1_PERCENT =
        new CntrlPurContrHdrDistributionField<BigDecimal>("CashDiscount1Percent");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount2Percent</b>
     * </p>
     *
     * @return Cash Discount Percentage 2
     */
    @SerializedName( "CashDiscount2Percent" )
    @JsonProperty( "CashDiscount2Percent" )
    @Nullable
    @ODataField( odataName = "CashDiscount2Percent" )
    private BigDecimal cashDiscount2Percent;
    /**
     * Use with available fluent helpers to apply the <b>CashDiscount2Percent</b> field to query operations.
     *
     */
    public final static CntrlPurContrHdrDistributionField<BigDecimal> CASH_DISCOUNT2_PERCENT =
        new CntrlPurContrHdrDistributionField<BigDecimal>("CashDiscount2Percent");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentCategory</b>
     * </p>
     *
     * @return Purchasing Document Category
     */
    @SerializedName( "PurchasingDocumentCategory" )
    @JsonProperty( "PurchasingDocumentCategory" )
    @Nullable
    @ODataField( odataName = "PurchasingDocumentCategory" )
    private String purchasingDocumentCategory;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingDocumentCategory</b> field to query operations.
     *
     */
    public final static CntrlPurContrHdrDistributionField<String> PURCHASING_DOCUMENT_CATEGORY =
        new CntrlPurContrHdrDistributionField<String>("PurchasingDocumentCategory");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentType</b>
     * </p>
     *
     * @return Purchasing Document Type
     */
    @SerializedName( "PurchasingDocumentType" )
    @JsonProperty( "PurchasingDocumentType" )
    @Nullable
    @ODataField( odataName = "PurchasingDocumentType" )
    private String purchasingDocumentType;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingDocumentType</b> field to query operations.
     *
     */
    public final static CntrlPurContrHdrDistributionField<String> PURCHASING_DOCUMENT_TYPE =
        new CntrlPurContrHdrDistributionField<String>("PurchasingDocumentType");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageLocation</b>
     * </p>
     *
     * @return Storage Location
     */
    @SerializedName( "StorageLocation" )
    @JsonProperty( "StorageLocation" )
    @Nullable
    @ODataField( odataName = "StorageLocation" )
    private String storageLocation;
    /**
     * Use with available fluent helpers to apply the <b>StorageLocation</b> field to query operations.
     *
     */
    public final static CntrlPurContrHdrDistributionField<String> STORAGE_LOCATION =
        new CntrlPurContrHdrDistributionField<String>("StorageLocation");
    /**
     * Constraints: Not nullable, Precision: 6, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CntrlPurContrDistributionPct</b>
     * </p>
     *
     * @return Distribution Percentage in Central Purchasing Document
     */
    @SerializedName( "CntrlPurContrDistributionPct" )
    @JsonProperty( "CntrlPurContrDistributionPct" )
    @Nullable
    @ODataField( odataName = "CntrlPurContrDistributionPct" )
    private BigDecimal cntrlPurContrDistributionPct;
    /**
     * Use with available fluent helpers to apply the <b>CntrlPurContrDistributionPct</b> field to query operations.
     *
     */
    public final static CntrlPurContrHdrDistributionField<BigDecimal> CNTRL_PUR_CONTR_DISTRIBUTION_PCT =
        new CntrlPurContrHdrDistributionField<BigDecimal>("CntrlPurContrDistributionPct");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsClassification</b>
     * </p>
     *
     * @return Incoterms (Part 1)
     */
    @SerializedName( "IncotermsClassification" )
    @JsonProperty( "IncotermsClassification" )
    @Nullable
    @ODataField( odataName = "IncotermsClassification" )
    private String incotermsClassification;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsClassification</b> field to query operations.
     *
     */
    public final static CntrlPurContrHdrDistributionField<String> INCOTERMS_CLASSIFICATION =
        new CntrlPurContrHdrDistributionField<String>("IncotermsClassification");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation1</b>
     * </p>
     *
     * @return Incoterms Location 1
     */
    @SerializedName( "IncotermsLocation1" )
    @JsonProperty( "IncotermsLocation1" )
    @Nullable
    @ODataField( odataName = "IncotermsLocation1" )
    private String incotermsLocation1;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsLocation1</b> field to query operations.
     *
     */
    public final static CntrlPurContrHdrDistributionField<String> INCOTERMS_LOCATION1 =
        new CntrlPurContrHdrDistributionField<String>("IncotermsLocation1");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ShippingInstruction</b>
     * </p>
     *
     * @return Shipping Instructions
     */
    @SerializedName( "ShippingInstruction" )
    @JsonProperty( "ShippingInstruction" )
    @Nullable
    @ODataField( odataName = "ShippingInstruction" )
    private String shippingInstruction;
    /**
     * Use with available fluent helpers to apply the <b>ShippingInstruction</b> field to query operations.
     *
     */
    public final static CntrlPurContrHdrDistributionField<String> SHIPPING_INSTRUCTION =
        new CntrlPurContrHdrDistributionField<String>("ShippingInstruction");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CntrlPurContrItmDistrAmt</b>
     * </p>
     *
     * @return Target Value for Header Area per Distribution
     */
    @SerializedName( "CntrlPurContrItmDistrAmt" )
    @JsonProperty( "CntrlPurContrItmDistrAmt" )
    @Nullable
    @ODataField( odataName = "CntrlPurContrItmDistrAmt" )
    private BigDecimal cntrlPurContrItmDistrAmt;
    /**
     * Use with available fluent helpers to apply the <b>CntrlPurContrItmDistrAmt</b> field to query operations.
     *
     */
    public final static CntrlPurContrHdrDistributionField<BigDecimal> CNTRL_PUR_CONTR_ITM_DISTR_AMT =
        new CntrlPurContrHdrDistributionField<BigDecimal>("CntrlPurContrItmDistrAmt");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProcurementHubSourceSystem</b>
     * </p>
     *
     * @return Logical System
     */
    @SerializedName( "ProcurementHubSourceSystem" )
    @JsonProperty( "ProcurementHubSourceSystem" )
    @Nullable
    @ODataField( odataName = "ProcurementHubSourceSystem" )
    private String procurementHubSourceSystem;
    /**
     * Use with available fluent helpers to apply the <b>ProcurementHubSourceSystem</b> field to query operations.
     *
     */
    public final static CntrlPurContrHdrDistributionField<String> PROCUREMENT_HUB_SOURCE_SYSTEM =
        new CntrlPurContrHdrDistributionField<String>("ProcurementHubSourceSystem");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsDeleted</b>
     * </p>
     *
     * @return Boolean Variable (X = True, - = False, Space = Unknown)
     */
    @SerializedName( "IsDeleted" )
    @JsonProperty( "IsDeleted" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsDeleted" )
    private Boolean isDeleted;
    /**
     * Use with available fluent helpers to apply the <b>IsDeleted</b> field to query operations.
     *
     */
    public final static CntrlPurContrHdrDistributionField<Boolean> IS_DELETED =
        new CntrlPurContrHdrDistributionField<Boolean>("IsDeleted");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingInfoRecordUpdateCode</b>
     * </p>
     *
     * @return Indicator: Update Info Record
     */
    @SerializedName( "PurchasingInfoRecordUpdateCode" )
    @JsonProperty( "PurchasingInfoRecordUpdateCode" )
    @Nullable
    @ODataField( odataName = "PurchasingInfoRecordUpdateCode" )
    private String purchasingInfoRecordUpdateCode;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingInfoRecordUpdateCode</b> field to query operations.
     *
     */
    public final static CntrlPurContrHdrDistributionField<String> PURCHASING_INFO_RECORD_UPDATE_CODE =
        new CntrlPurContrHdrDistributionField<String>("PurchasingInfoRecordUpdateCode");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SourceListIsUpdated</b>
     * </p>
     *
     * @return Checkbox
     */
    @SerializedName( "SourceListIsUpdated" )
    @JsonProperty( "SourceListIsUpdated" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "SourceListIsUpdated" )
    private Boolean sourceListIsUpdated;
    /**
     * Use with available fluent helpers to apply the <b>SourceListIsUpdated</b> field to query operations.
     *
     */
    public final static CntrlPurContrHdrDistributionField<Boolean> SOURCE_LIST_IS_UPDATED =
        new CntrlPurContrHdrDistributionField<Boolean>("SourceListIsUpdated");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SourceListRestriction</b>
     * </p>
     *
     * @return Source List Restriction Indicator
     */
    @SerializedName( "SourceListRestriction" )
    @JsonProperty( "SourceListRestriction" )
    @Nullable
    @ODataField( odataName = "SourceListRestriction" )
    private String sourceListRestriction;
    /**
     * Use with available fluent helpers to apply the <b>SourceListRestriction</b> field to query operations.
     *
     */
    public final static CntrlPurContrHdrDistributionField<String> SOURCE_LIST_RESTRICTION =
        new CntrlPurContrHdrDistributionField<String>("SourceListRestriction");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDistributionNumber</b>
     * </p>
     *
     * @return Distribution Number of Central Purchasing Document
     */
    @SerializedName( "ReferenceDistributionNumber" )
    @JsonProperty( "ReferenceDistributionNumber" )
    @Nullable
    @ODataField( odataName = "ReferenceDistributionNumber" )
    private String referenceDistributionNumber;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceDistributionNumber</b> field to query operations.
     *
     */
    public final static CntrlPurContrHdrDistributionField<String> REFERENCE_DISTRIBUTION_NUMBER =
        new CntrlPurContrHdrDistributionField<String>("ReferenceDistributionNumber");
    /**
     * Navigation property <b>to_CentralPurchaseContract</b> for <b>CntrlPurContrHdrDistribution</b> to single
     * <b>CentralPurchaseContract</b>.
     *
     */
    @SerializedName( "to_CentralPurchaseContract" )
    @JsonProperty( "to_CentralPurchaseContract" )
    @ODataField( odataName = "to_CentralPurchaseContract" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private CentralPurchaseContract toCentralPurchaseContract;
    /**
     * Navigation property <b>to_CntrlPurContrHeaderPartner</b> for <b>CntrlPurContrHdrDistribution</b> to multiple
     * <b>CntrlPurContrHeaderPartner</b>.
     *
     */
    @SerializedName( "to_CntrlPurContrHeaderPartner" )
    @JsonProperty( "to_CntrlPurContrHeaderPartner" )
    @ODataField( odataName = "to_CntrlPurContrHeaderPartner" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<CntrlPurContrHeaderPartner> toCntrlPurContrHeaderPartner;
    /**
     * Use with available fluent helpers to apply the <b>to_CentralPurchaseContract</b> navigation property to query
     * operations.
     *
     */
    public final static CntrlPurContrHdrDistributionOneToOneLink<CentralPurchaseContract> TO_CENTRAL_PURCHASE_CONTRACT =
        new CntrlPurContrHdrDistributionOneToOneLink<CentralPurchaseContract>("to_CentralPurchaseContract");
    /**
     * Use with available fluent helpers to apply the <b>to_CntrlPurContrHeaderPartner</b> navigation property to query
     * operations.
     *
     */
    public final static CntrlPurContrHdrDistributionLink<CntrlPurContrHeaderPartner> TO_CNTRL_PUR_CONTR_HEADER_PARTNER =
        new CntrlPurContrHdrDistributionLink<CntrlPurContrHeaderPartner>("to_CntrlPurContrHeaderPartner");

    @Nonnull
    @Override
    public Class<CntrlPurContrHdrDistribution> getType()
    {
        return CntrlPurContrHdrDistribution.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CentralPurchaseContract</b>
     * </p>
     *
     * @param centralPurchaseContract
     *            Purchasing Document Number
     */
    public void setCentralPurchaseContract( @Nullable final String centralPurchaseContract )
    {
        rememberChangedField("CentralPurchaseContract", this.centralPurchaseContract);
        this.centralPurchaseContract = centralPurchaseContract;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>DistributionKey</b>
     * </p>
     *
     * @param distributionKey
     *            Distribution Number of Central Purchasing Document
     */
    public void setDistributionKey( @Nullable final String distributionKey )
    {
        rememberChangedField("DistributionKey", this.distributionKey);
        this.distributionKey = distributionKey;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CentralPurchaseContractItem</b>
     * </p>
     *
     * @param centralPurchaseContractItem
     *            Item Number of Purchasing Document
     */
    public void setCentralPurchaseContractItem( @Nullable final String centralPurchaseContractItem )
    {
        rememberChangedField("CentralPurchaseContractItem", this.centralPurchaseContractItem);
        this.centralPurchaseContractItem = centralPurchaseContractItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProcmtHubCompanyCode</b>
     * </p>
     *
     * @param procmtHubCompanyCode
     *            Company Code
     */
    public void setProcmtHubCompanyCode( @Nullable final String procmtHubCompanyCode )
    {
        rememberChangedField("ProcmtHubCompanyCode", this.procmtHubCompanyCode);
        this.procmtHubCompanyCode = procmtHubCompanyCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProcmtHubPlant</b>
     * </p>
     *
     * @param procmtHubPlant
     *            Plant
     */
    public void setProcmtHubPlant( @Nullable final String procmtHubPlant )
    {
        rememberChangedField("ProcmtHubPlant", this.procmtHubPlant);
        this.procmtHubPlant = procmtHubPlant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProcmtHubPurchasingOrg</b>
     * </p>
     *
     * @param procmtHubPurchasingOrg
     *            Purchasing Organization
     */
    public void setProcmtHubPurchasingOrg( @Nullable final String procmtHubPurchasingOrg )
    {
        rememberChangedField("ProcmtHubPurchasingOrg", this.procmtHubPurchasingOrg);
        this.procmtHubPurchasingOrg = procmtHubPurchasingOrg;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProcmtHubPurchasingGroup</b>
     * </p>
     *
     * @param procmtHubPurchasingGroup
     *            Purchasing Group
     */
    public void setProcmtHubPurchasingGroup( @Nullable final String procmtHubPurchasingGroup )
    {
        rememberChangedField("ProcmtHubPurchasingGroup", this.procmtHubPurchasingGroup);
        this.procmtHubPurchasingGroup = procmtHubPurchasingGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProcmtHubCompanyCodeGroupingID</b>
     * </p>
     *
     * @param procmtHubCompanyCodeGroupingID
     *            Grouping ID for Company Codes
     */
    public void setProcmtHubCompanyCodeGroupingID( @Nullable final String procmtHubCompanyCodeGroupingID )
    {
        rememberChangedField("ProcmtHubCompanyCodeGroupingID", this.procmtHubCompanyCodeGroupingID);
        this.procmtHubCompanyCodeGroupingID = procmtHubCompanyCodeGroupingID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CntrlPurContrDistrCurrency</b>
     * </p>
     *
     * @param cntrlPurContrDistrCurrency
     *            Currency Key
     */
    public void setCntrlPurContrDistrCurrency( @Nullable final String cntrlPurContrDistrCurrency )
    {
        rememberChangedField("CntrlPurContrDistrCurrency", this.cntrlPurContrDistrCurrency);
        this.cntrlPurContrDistrCurrency = cntrlPurContrDistrCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PaymentTerms</b>
     * </p>
     *
     * @param paymentTerms
     *            Terms of Payment Key
     */
    public void setPaymentTerms( @Nullable final String paymentTerms )
    {
        rememberChangedField("PaymentTerms", this.paymentTerms);
        this.paymentTerms = paymentTerms;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount1Days</b>
     * </p>
     *
     * @param cashDiscount1Days
     *            Cash discount days 1
     */
    public void setCashDiscount1Days( @Nullable final BigDecimal cashDiscount1Days )
    {
        rememberChangedField("CashDiscount1Days", this.cashDiscount1Days);
        this.cashDiscount1Days = cashDiscount1Days;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount2Days</b>
     * </p>
     *
     * @param cashDiscount2Days
     *            Cash discount days 2
     */
    public void setCashDiscount2Days( @Nullable final BigDecimal cashDiscount2Days )
    {
        rememberChangedField("CashDiscount2Days", this.cashDiscount2Days);
        this.cashDiscount2Days = cashDiscount2Days;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>NetPaymentDays</b>
     * </p>
     *
     * @param netPaymentDays
     *            Net Payment Terms Period
     */
    public void setNetPaymentDays( @Nullable final BigDecimal netPaymentDays )
    {
        rememberChangedField("NetPaymentDays", this.netPaymentDays);
        this.netPaymentDays = netPaymentDays;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount1Percent</b>
     * </p>
     *
     * @param cashDiscount1Percent
     *            Cash Discount Percentage 1
     */
    public void setCashDiscount1Percent( @Nullable final BigDecimal cashDiscount1Percent )
    {
        rememberChangedField("CashDiscount1Percent", this.cashDiscount1Percent);
        this.cashDiscount1Percent = cashDiscount1Percent;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CashDiscount2Percent</b>
     * </p>
     *
     * @param cashDiscount2Percent
     *            Cash Discount Percentage 2
     */
    public void setCashDiscount2Percent( @Nullable final BigDecimal cashDiscount2Percent )
    {
        rememberChangedField("CashDiscount2Percent", this.cashDiscount2Percent);
        this.cashDiscount2Percent = cashDiscount2Percent;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentCategory</b>
     * </p>
     *
     * @param purchasingDocumentCategory
     *            Purchasing Document Category
     */
    public void setPurchasingDocumentCategory( @Nullable final String purchasingDocumentCategory )
    {
        rememberChangedField("PurchasingDocumentCategory", this.purchasingDocumentCategory);
        this.purchasingDocumentCategory = purchasingDocumentCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentType</b>
     * </p>
     *
     * @param purchasingDocumentType
     *            Purchasing Document Type
     */
    public void setPurchasingDocumentType( @Nullable final String purchasingDocumentType )
    {
        rememberChangedField("PurchasingDocumentType", this.purchasingDocumentType);
        this.purchasingDocumentType = purchasingDocumentType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageLocation</b>
     * </p>
     *
     * @param storageLocation
     *            Storage Location
     */
    public void setStorageLocation( @Nullable final String storageLocation )
    {
        rememberChangedField("StorageLocation", this.storageLocation);
        this.storageLocation = storageLocation;
    }

    /**
     * Constraints: Not nullable, Precision: 6, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CntrlPurContrDistributionPct</b>
     * </p>
     *
     * @param cntrlPurContrDistributionPct
     *            Distribution Percentage in Central Purchasing Document
     */
    public void setCntrlPurContrDistributionPct( @Nullable final BigDecimal cntrlPurContrDistributionPct )
    {
        rememberChangedField("CntrlPurContrDistributionPct", this.cntrlPurContrDistributionPct);
        this.cntrlPurContrDistributionPct = cntrlPurContrDistributionPct;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsClassification</b>
     * </p>
     *
     * @param incotermsClassification
     *            Incoterms (Part 1)
     */
    public void setIncotermsClassification( @Nullable final String incotermsClassification )
    {
        rememberChangedField("IncotermsClassification", this.incotermsClassification);
        this.incotermsClassification = incotermsClassification;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation1</b>
     * </p>
     *
     * @param incotermsLocation1
     *            Incoterms Location 1
     */
    public void setIncotermsLocation1( @Nullable final String incotermsLocation1 )
    {
        rememberChangedField("IncotermsLocation1", this.incotermsLocation1);
        this.incotermsLocation1 = incotermsLocation1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ShippingInstruction</b>
     * </p>
     *
     * @param shippingInstruction
     *            Shipping Instructions
     */
    public void setShippingInstruction( @Nullable final String shippingInstruction )
    {
        rememberChangedField("ShippingInstruction", this.shippingInstruction);
        this.shippingInstruction = shippingInstruction;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CntrlPurContrItmDistrAmt</b>
     * </p>
     *
     * @param cntrlPurContrItmDistrAmt
     *            Target Value for Header Area per Distribution
     */
    public void setCntrlPurContrItmDistrAmt( @Nullable final BigDecimal cntrlPurContrItmDistrAmt )
    {
        rememberChangedField("CntrlPurContrItmDistrAmt", this.cntrlPurContrItmDistrAmt);
        this.cntrlPurContrItmDistrAmt = cntrlPurContrItmDistrAmt;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProcurementHubSourceSystem</b>
     * </p>
     *
     * @param procurementHubSourceSystem
     *            Logical System
     */
    public void setProcurementHubSourceSystem( @Nullable final String procurementHubSourceSystem )
    {
        rememberChangedField("ProcurementHubSourceSystem", this.procurementHubSourceSystem);
        this.procurementHubSourceSystem = procurementHubSourceSystem;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsDeleted</b>
     * </p>
     *
     * @param isDeleted
     *            Boolean Variable (X = True, - = False, Space = Unknown)
     */
    public void setIsDeleted( @Nullable final Boolean isDeleted )
    {
        rememberChangedField("IsDeleted", this.isDeleted);
        this.isDeleted = isDeleted;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingInfoRecordUpdateCode</b>
     * </p>
     *
     * @param purchasingInfoRecordUpdateCode
     *            Indicator: Update Info Record
     */
    public void setPurchasingInfoRecordUpdateCode( @Nullable final String purchasingInfoRecordUpdateCode )
    {
        rememberChangedField("PurchasingInfoRecordUpdateCode", this.purchasingInfoRecordUpdateCode);
        this.purchasingInfoRecordUpdateCode = purchasingInfoRecordUpdateCode;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SourceListIsUpdated</b>
     * </p>
     *
     * @param sourceListIsUpdated
     *            Checkbox
     */
    public void setSourceListIsUpdated( @Nullable final Boolean sourceListIsUpdated )
    {
        rememberChangedField("SourceListIsUpdated", this.sourceListIsUpdated);
        this.sourceListIsUpdated = sourceListIsUpdated;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SourceListRestriction</b>
     * </p>
     *
     * @param sourceListRestriction
     *            Source List Restriction Indicator
     */
    public void setSourceListRestriction( @Nullable final String sourceListRestriction )
    {
        rememberChangedField("SourceListRestriction", this.sourceListRestriction);
        this.sourceListRestriction = sourceListRestriction;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDistributionNumber</b>
     * </p>
     *
     * @param referenceDistributionNumber
     *            Distribution Number of Central Purchasing Document
     */
    public void setReferenceDistributionNumber( @Nullable final String referenceDistributionNumber )
    {
        rememberChangedField("ReferenceDistributionNumber", this.referenceDistributionNumber);
        this.referenceDistributionNumber = referenceDistributionNumber;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_CntrlPurContrHdrDistribution";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("CentralPurchaseContract", getCentralPurchaseContract());
        result.put("DistributionKey", getDistributionKey());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("CentralPurchaseContract", getCentralPurchaseContract());
        values.put("DistributionKey", getDistributionKey());
        values.put("CentralPurchaseContractItem", getCentralPurchaseContractItem());
        values.put("ProcmtHubCompanyCode", getProcmtHubCompanyCode());
        values.put("ProcmtHubPlant", getProcmtHubPlant());
        values.put("ProcmtHubPurchasingOrg", getProcmtHubPurchasingOrg());
        values.put("ProcmtHubPurchasingGroup", getProcmtHubPurchasingGroup());
        values.put("ProcmtHubCompanyCodeGroupingID", getProcmtHubCompanyCodeGroupingID());
        values.put("CntrlPurContrDistrCurrency", getCntrlPurContrDistrCurrency());
        values.put("PaymentTerms", getPaymentTerms());
        values.put("CashDiscount1Days", getCashDiscount1Days());
        values.put("CashDiscount2Days", getCashDiscount2Days());
        values.put("NetPaymentDays", getNetPaymentDays());
        values.put("CashDiscount1Percent", getCashDiscount1Percent());
        values.put("CashDiscount2Percent", getCashDiscount2Percent());
        values.put("PurchasingDocumentCategory", getPurchasingDocumentCategory());
        values.put("PurchasingDocumentType", getPurchasingDocumentType());
        values.put("StorageLocation", getStorageLocation());
        values.put("CntrlPurContrDistributionPct", getCntrlPurContrDistributionPct());
        values.put("IncotermsClassification", getIncotermsClassification());
        values.put("IncotermsLocation1", getIncotermsLocation1());
        values.put("ShippingInstruction", getShippingInstruction());
        values.put("CntrlPurContrItmDistrAmt", getCntrlPurContrItmDistrAmt());
        values.put("ProcurementHubSourceSystem", getProcurementHubSourceSystem());
        values.put("IsDeleted", getIsDeleted());
        values.put("PurchasingInfoRecordUpdateCode", getPurchasingInfoRecordUpdateCode());
        values.put("SourceListIsUpdated", getSourceListIsUpdated());
        values.put("SourceListRestriction", getSourceListRestriction());
        values.put("ReferenceDistributionNumber", getReferenceDistributionNumber());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CentralPurchaseContract") ) {
                final Object value = values.remove("CentralPurchaseContract");
                if( (value == null) || (!value.equals(getCentralPurchaseContract())) ) {
                    setCentralPurchaseContract(((String) value));
                }
            }
            if( values.containsKey("DistributionKey") ) {
                final Object value = values.remove("DistributionKey");
                if( (value == null) || (!value.equals(getDistributionKey())) ) {
                    setDistributionKey(((String) value));
                }
            }
            if( values.containsKey("CentralPurchaseContractItem") ) {
                final Object value = values.remove("CentralPurchaseContractItem");
                if( (value == null) || (!value.equals(getCentralPurchaseContractItem())) ) {
                    setCentralPurchaseContractItem(((String) value));
                }
            }
            if( values.containsKey("ProcmtHubCompanyCode") ) {
                final Object value = values.remove("ProcmtHubCompanyCode");
                if( (value == null) || (!value.equals(getProcmtHubCompanyCode())) ) {
                    setProcmtHubCompanyCode(((String) value));
                }
            }
            if( values.containsKey("ProcmtHubPlant") ) {
                final Object value = values.remove("ProcmtHubPlant");
                if( (value == null) || (!value.equals(getProcmtHubPlant())) ) {
                    setProcmtHubPlant(((String) value));
                }
            }
            if( values.containsKey("ProcmtHubPurchasingOrg") ) {
                final Object value = values.remove("ProcmtHubPurchasingOrg");
                if( (value == null) || (!value.equals(getProcmtHubPurchasingOrg())) ) {
                    setProcmtHubPurchasingOrg(((String) value));
                }
            }
            if( values.containsKey("ProcmtHubPurchasingGroup") ) {
                final Object value = values.remove("ProcmtHubPurchasingGroup");
                if( (value == null) || (!value.equals(getProcmtHubPurchasingGroup())) ) {
                    setProcmtHubPurchasingGroup(((String) value));
                }
            }
            if( values.containsKey("ProcmtHubCompanyCodeGroupingID") ) {
                final Object value = values.remove("ProcmtHubCompanyCodeGroupingID");
                if( (value == null) || (!value.equals(getProcmtHubCompanyCodeGroupingID())) ) {
                    setProcmtHubCompanyCodeGroupingID(((String) value));
                }
            }
            if( values.containsKey("CntrlPurContrDistrCurrency") ) {
                final Object value = values.remove("CntrlPurContrDistrCurrency");
                if( (value == null) || (!value.equals(getCntrlPurContrDistrCurrency())) ) {
                    setCntrlPurContrDistrCurrency(((String) value));
                }
            }
            if( values.containsKey("PaymentTerms") ) {
                final Object value = values.remove("PaymentTerms");
                if( (value == null) || (!value.equals(getPaymentTerms())) ) {
                    setPaymentTerms(((String) value));
                }
            }
            if( values.containsKey("CashDiscount1Days") ) {
                final Object value = values.remove("CashDiscount1Days");
                if( (value == null) || (!value.equals(getCashDiscount1Days())) ) {
                    setCashDiscount1Days(((BigDecimal) value));
                }
            }
            if( values.containsKey("CashDiscount2Days") ) {
                final Object value = values.remove("CashDiscount2Days");
                if( (value == null) || (!value.equals(getCashDiscount2Days())) ) {
                    setCashDiscount2Days(((BigDecimal) value));
                }
            }
            if( values.containsKey("NetPaymentDays") ) {
                final Object value = values.remove("NetPaymentDays");
                if( (value == null) || (!value.equals(getNetPaymentDays())) ) {
                    setNetPaymentDays(((BigDecimal) value));
                }
            }
            if( values.containsKey("CashDiscount1Percent") ) {
                final Object value = values.remove("CashDiscount1Percent");
                if( (value == null) || (!value.equals(getCashDiscount1Percent())) ) {
                    setCashDiscount1Percent(((BigDecimal) value));
                }
            }
            if( values.containsKey("CashDiscount2Percent") ) {
                final Object value = values.remove("CashDiscount2Percent");
                if( (value == null) || (!value.equals(getCashDiscount2Percent())) ) {
                    setCashDiscount2Percent(((BigDecimal) value));
                }
            }
            if( values.containsKey("PurchasingDocumentCategory") ) {
                final Object value = values.remove("PurchasingDocumentCategory");
                if( (value == null) || (!value.equals(getPurchasingDocumentCategory())) ) {
                    setPurchasingDocumentCategory(((String) value));
                }
            }
            if( values.containsKey("PurchasingDocumentType") ) {
                final Object value = values.remove("PurchasingDocumentType");
                if( (value == null) || (!value.equals(getPurchasingDocumentType())) ) {
                    setPurchasingDocumentType(((String) value));
                }
            }
            if( values.containsKey("StorageLocation") ) {
                final Object value = values.remove("StorageLocation");
                if( (value == null) || (!value.equals(getStorageLocation())) ) {
                    setStorageLocation(((String) value));
                }
            }
            if( values.containsKey("CntrlPurContrDistributionPct") ) {
                final Object value = values.remove("CntrlPurContrDistributionPct");
                if( (value == null) || (!value.equals(getCntrlPurContrDistributionPct())) ) {
                    setCntrlPurContrDistributionPct(((BigDecimal) value));
                }
            }
            if( values.containsKey("IncotermsClassification") ) {
                final Object value = values.remove("IncotermsClassification");
                if( (value == null) || (!value.equals(getIncotermsClassification())) ) {
                    setIncotermsClassification(((String) value));
                }
            }
            if( values.containsKey("IncotermsLocation1") ) {
                final Object value = values.remove("IncotermsLocation1");
                if( (value == null) || (!value.equals(getIncotermsLocation1())) ) {
                    setIncotermsLocation1(((String) value));
                }
            }
            if( values.containsKey("ShippingInstruction") ) {
                final Object value = values.remove("ShippingInstruction");
                if( (value == null) || (!value.equals(getShippingInstruction())) ) {
                    setShippingInstruction(((String) value));
                }
            }
            if( values.containsKey("CntrlPurContrItmDistrAmt") ) {
                final Object value = values.remove("CntrlPurContrItmDistrAmt");
                if( (value == null) || (!value.equals(getCntrlPurContrItmDistrAmt())) ) {
                    setCntrlPurContrItmDistrAmt(((BigDecimal) value));
                }
            }
            if( values.containsKey("ProcurementHubSourceSystem") ) {
                final Object value = values.remove("ProcurementHubSourceSystem");
                if( (value == null) || (!value.equals(getProcurementHubSourceSystem())) ) {
                    setProcurementHubSourceSystem(((String) value));
                }
            }
            if( values.containsKey("IsDeleted") ) {
                final Object value = values.remove("IsDeleted");
                if( (value == null) || (!value.equals(getIsDeleted())) ) {
                    setIsDeleted(((Boolean) value));
                }
            }
            if( values.containsKey("PurchasingInfoRecordUpdateCode") ) {
                final Object value = values.remove("PurchasingInfoRecordUpdateCode");
                if( (value == null) || (!value.equals(getPurchasingInfoRecordUpdateCode())) ) {
                    setPurchasingInfoRecordUpdateCode(((String) value));
                }
            }
            if( values.containsKey("SourceListIsUpdated") ) {
                final Object value = values.remove("SourceListIsUpdated");
                if( (value == null) || (!value.equals(getSourceListIsUpdated())) ) {
                    setSourceListIsUpdated(((Boolean) value));
                }
            }
            if( values.containsKey("SourceListRestriction") ) {
                final Object value = values.remove("SourceListRestriction");
                if( (value == null) || (!value.equals(getSourceListRestriction())) ) {
                    setSourceListRestriction(((String) value));
                }
            }
            if( values.containsKey("ReferenceDistributionNumber") ) {
                final Object value = values.remove("ReferenceDistributionNumber");
                if( (value == null) || (!value.equals(getReferenceDistributionNumber())) ) {
                    setReferenceDistributionNumber(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CentralPurchaseContract") ) {
                final Object value = (values).remove("to_CentralPurchaseContract");
                if( value instanceof Map ) {
                    if( toCentralPurchaseContract == null ) {
                        toCentralPurchaseContract = new CentralPurchaseContract();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCentralPurchaseContract.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_CntrlPurContrHeaderPartner") ) {
                final Object value = (values).remove("to_CntrlPurContrHeaderPartner");
                if( value instanceof Iterable ) {
                    if( toCntrlPurContrHeaderPartner == null ) {
                        toCntrlPurContrHeaderPartner = Lists.newArrayList();
                    } else {
                        toCntrlPurContrHeaderPartner = Lists.newArrayList(toCntrlPurContrHeaderPartner);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        CntrlPurContrHeaderPartner entity;
                        if( toCntrlPurContrHeaderPartner.size() > i ) {
                            entity = toCntrlPurContrHeaderPartner.get(i);
                        } else {
                            entity = new CntrlPurContrHeaderPartner();
                            toCntrlPurContrHeaderPartner.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> CntrlPurContrHdrDistributionField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new CntrlPurContrHdrDistributionField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CntrlPurContrHdrDistributionField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CntrlPurContrHdrDistributionField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.CentralPurchaseContractService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCentralPurchaseContract != null ) {
            (values).put("to_CentralPurchaseContract", toCentralPurchaseContract);
        }
        if( toCntrlPurContrHeaderPartner != null ) {
            (values).put("to_CntrlPurContrHeaderPartner", toCntrlPurContrHeaderPartner);
        }
        return values;
    }

    /**
     * Fetches the <b>CentralPurchaseContract</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_CentralPurchaseContract</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>CentralPurchaseContract</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public CentralPurchaseContract fetchCentralPurchaseContract()
    {
        return fetchFieldAsSingle("to_CentralPurchaseContract", CentralPurchaseContract.class);
    }

    /**
     * Retrieval of associated <b>CentralPurchaseContract</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_CentralPurchaseContract</b>.
     * <p>
     * If the navigation property <b>to_CentralPurchaseContract</b> of a queried <b>CntrlPurContrHdrDistribution</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CentralPurchaseContract</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public CentralPurchaseContract getCentralPurchaseContractOrFetch()
    {
        if( toCentralPurchaseContract == null ) {
            toCentralPurchaseContract = fetchCentralPurchaseContract();
        }
        return toCentralPurchaseContract;
    }

    /**
     * Retrieval of associated <b>CentralPurchaseContract</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_CentralPurchaseContract</b>.
     * <p>
     * If the navigation property for an entity <b>CntrlPurContrHdrDistribution</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CentralPurchaseContract</b> is already loaded, the
     *         result will contain the <b>CentralPurchaseContract</b> entity. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<CentralPurchaseContract> getCentralPurchaseContractIfPresent()
    {
        return Option.of(toCentralPurchaseContract);
    }

    /**
     * Overwrites the associated <b>CentralPurchaseContract</b> entity for the loaded navigation property
     * <b>to_CentralPurchaseContract</b>.
     *
     * @param value
     *            New <b>CentralPurchaseContract</b> entity.
     */
    public void setCentralPurchaseContract( final CentralPurchaseContract value )
    {
        toCentralPurchaseContract = value;
    }

    /**
     * Fetches the <b>CntrlPurContrHeaderPartner</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_CntrlPurContrHeaderPartner</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>CntrlPurContrHeaderPartner</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CntrlPurContrHeaderPartner> fetchCntrlPurContrHeaderPartner()
    {
        return fetchFieldAsList("to_CntrlPurContrHeaderPartner", CntrlPurContrHeaderPartner.class);
    }

    /**
     * Retrieval of associated <b>CntrlPurContrHeaderPartner</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CntrlPurContrHeaderPartner</b>.
     * <p>
     * If the navigation property <b>to_CntrlPurContrHeaderPartner</b> of a queried <b>CntrlPurContrHdrDistribution</b>
     * is operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CntrlPurContrHeaderPartner</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CntrlPurContrHeaderPartner> getCntrlPurContrHeaderPartnerOrFetch()
    {
        if( toCntrlPurContrHeaderPartner == null ) {
            toCntrlPurContrHeaderPartner = fetchCntrlPurContrHeaderPartner();
        }
        return toCntrlPurContrHeaderPartner;
    }

    /**
     * Retrieval of associated <b>CntrlPurContrHeaderPartner</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CntrlPurContrHeaderPartner</b>.
     * <p>
     * If the navigation property for an entity <b>CntrlPurContrHdrDistribution</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CntrlPurContrHeaderPartner</b> is already loaded, the
     *         result will contain the <b>CntrlPurContrHeaderPartner</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<CntrlPurContrHeaderPartner>> getCntrlPurContrHeaderPartnerIfPresent()
    {
        return Option.of(toCntrlPurContrHeaderPartner);
    }

    /**
     * Overwrites the list of associated <b>CntrlPurContrHeaderPartner</b> entities for the loaded navigation property
     * <b>to_CntrlPurContrHeaderPartner</b>.
     * <p>
     * If the navigation property <b>to_CntrlPurContrHeaderPartner</b> of a queried <b>CntrlPurContrHdrDistribution</b>
     * is operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>CntrlPurContrHeaderPartner</b> entities.
     */
    public void setCntrlPurContrHeaderPartner( @Nonnull final List<CntrlPurContrHeaderPartner> value )
    {
        if( toCntrlPurContrHeaderPartner == null ) {
            toCntrlPurContrHeaderPartner = Lists.newArrayList();
        }
        toCntrlPurContrHeaderPartner.clear();
        toCntrlPurContrHeaderPartner.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>CntrlPurContrHeaderPartner</b> entities. This corresponds to the OData
     * navigation property <b>to_CntrlPurContrHeaderPartner</b>.
     * <p>
     * If the navigation property <b>to_CntrlPurContrHeaderPartner</b> of a queried <b>CntrlPurContrHdrDistribution</b>
     * is operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>CntrlPurContrHeaderPartner</b> entities.
     */
    public void addCntrlPurContrHeaderPartner( CntrlPurContrHeaderPartner... entity )
    {
        if( toCntrlPurContrHeaderPartner == null ) {
            toCntrlPurContrHeaderPartner = Lists.newArrayList();
        }
        toCntrlPurContrHeaderPartner.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of CntrlPurContrHdrDistribution instances.
     *
     */
    public final static class CntrlPurContrHdrDistributionBuilder
    {

        private CentralPurchaseContract toCentralPurchaseContract;
        private String centralPurchaseContract = null;
        private List<CntrlPurContrHeaderPartner> toCntrlPurContrHeaderPartner = Lists.newArrayList();

        private CntrlPurContrHdrDistribution.CntrlPurContrHdrDistributionBuilder toCentralPurchaseContract(
            final CentralPurchaseContract value )
        {
            toCentralPurchaseContract = value;
            return this;
        }

        /**
         * Navigation property <b>to_CentralPurchaseContract</b> for <b>CntrlPurContrHdrDistribution</b> to single
         * <b>CentralPurchaseContract</b>.
         *
         * @param value
         *            The CentralPurchaseContract to build this CntrlPurContrHdrDistribution with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CntrlPurContrHdrDistribution.CntrlPurContrHdrDistributionBuilder centralPurchaseContract(
            final CentralPurchaseContract value )
        {
            return toCentralPurchaseContract(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 10
         * <p>
         * Original property name from the Odata EDM: <b>CentralPurchaseContract</b>
         * </p>
         *
         * @param value
         *            The centralPurchaseContract to build this CntrlPurContrHdrDistribution with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CntrlPurContrHdrDistribution.CntrlPurContrHdrDistributionBuilder centralPurchaseContract(
            final String value )
        {
            centralPurchaseContract = value;
            return this;
        }

        private CntrlPurContrHdrDistribution.CntrlPurContrHdrDistributionBuilder toCntrlPurContrHeaderPartner(
            final List<CntrlPurContrHeaderPartner> value )
        {
            toCntrlPurContrHeaderPartner.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CntrlPurContrHeaderPartner</b> for <b>CntrlPurContrHdrDistribution</b> to multiple
         * <b>CntrlPurContrHeaderPartner</b>.
         *
         * @param value
         *            The CntrlPurContrHeaderPartners to build this CntrlPurContrHdrDistribution with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CntrlPurContrHdrDistribution.CntrlPurContrHdrDistributionBuilder cntrlPurContrHeaderPartner(
            CntrlPurContrHeaderPartner... value )
        {
            return toCntrlPurContrHeaderPartner(Lists.newArrayList(value));
        }

    }

}
